/*
SQLyog Ultimate v8.6 Beta2
MySQL - 5.1.41 : Database - creativedreams
*********************************************************************
*/

/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`creativedreams` /*!40100 DEFAULT CHARACTER SET latin1 */;

USE `creativedreams`;

/*Table structure for table `oldimage` */

DROP TABLE IF EXISTS `oldimage`;

CREATE TABLE `oldimage` (
  `oi_id` int(15) unsigned NOT NULL AUTO_INCREMENT,
  `oi_name` varchar(255) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL DEFAULT '',
  `oi_archive_name` varchar(255) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL DEFAULT '',
  `oi_size` int(8) unsigned NOT NULL DEFAULT '0',
  `oi_width` int(5) NOT NULL DEFAULT '0',
  `oi_height` int(5) NOT NULL DEFAULT '0',
  `oi_bits` int(3) NOT NULL DEFAULT '0',
  `oi_description` tinyblob NOT NULL,
  `oi_user` int(5) unsigned NOT NULL DEFAULT '0',
  `oi_user_text` varchar(255) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL DEFAULT '',
  `oi_timestamp` varchar(14) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL DEFAULT '',
  `oi_metadata` mediumblob NOT NULL,
  `oi_media_type` enum('UNKNOWN','BITMAP','DRAWING','AUDIO','VIDEO','MULTIMEDIA','OFFICE','TEXT','EXECUTABLE','ARCHIVE') DEFAULT NULL,
  `oi_major_mime` enum('unknown','application','audio','image','text','video','message','model','multipart') NOT NULL DEFAULT 'unknown',
  `oi_minor_mime` varchar(32) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL DEFAULT 'unknown',
  `oi_deleted` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `oi_sha1` varchar(32) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`oi_id`),
  KEY `oi_name_timestamp` (`oi_name`,`oi_timestamp`),
  KEY `oi_name_archive_name` (`oi_name`,`oi_archive_name`(14)),
  KEY `oi_usertext_timestamp` (`oi_user_text`,`oi_timestamp`),
  KEY `oi_sha1` (`oi_sha1`)
) ENGINE=InnoDB AUTO_INCREMENT=135173 DEFAULT CHARSET=latin1;

/*Data for the table `oldimage` */

insert  into `oldimage`(`oi_id`,`oi_name`,`oi_archive_name`,`oi_size`,`oi_width`,`oi_height`,`oi_bits`,`oi_description`,`oi_user`,`oi_user_text`,`oi_timestamp`,`oi_metadata`,`oi_media_type`,`oi_major_mime`,`oi_minor_mime`,`oi_deleted`,`oi_sha1`) values (1,'Theodor-Schwann.jpg','20020825230628!Theodor_Schwann.jpg',22253,0,0,0,'upload smaller version over original',4,'Magnus Manske','20020825120832','',NULL,'unknown','unknown',0,''),(2,'Merrimac.jpg','20020829210909!Merrimac.jpg',5945,200,165,8,'Reverted to earlier revision',0,'203.192.36.159','20020829210100','0','BITMAP','image','jpeg',0,'1e93hge9or1h5v6dl9keeyerxpf1bi0'),(3,'Merrimac.jpg','20020829210100!Merrimac.jpg',16041,350,289,8,'Resize of Merrimac from http:/  /  www.history.navy.mil/  photos/  images/  h45000/  h45973.jpg',2376,'Zoe','20020829204915','0','BITMAP','image','jpeg',0,'pwqrg34s63suubcrw8bznnp3z26azu3'),(4,'Stravinsky-petrushka-fanfare.png','20021009211242!Stravinsky-petrushka-fanfare.png',7484,566,161,8,'fanfare from Igor Stravinsky\'s ballet \"Petrushka\"',3113,'Camembert','20021009143840','0','BITMAP','image','png',0,'bdy87hyah1kbmv44ao5p40dfmjkhmjx'),(5,'Thesnowman.jpg','20021219211254!Thesnowman.jpg',5417,120,160,8,'Raymond Briggs\'s \"The Snowman\"',6175,'Taras','20021219210916','0','BITMAP','image','jpeg',0,'1tnmu0bgmqx9sjspzk1ym5zcjphpe62'),(6,'ATP.png','20021221213221!ATP.png',2255,412,319,4,'from meta',4,'Magnus Manske','20020827043249','0','BITMAP','image','png',0,'spse8xos7jcm5cdkc8m1z8nkx1tttqd'),(7,'Nicotine.png','20021223010912!Nicotine.png',1666,281,164,8,'Structure of [[nicotine]]',2,'AxelBoldt','20021217025901','0','BITMAP','image','png',0,'28dumwlpsxqit4nos8zpjvz5my9g1k0'),(8,'Acetylcholine.png','20021223015320!Acetylcholine.png',1063,338,120,8,'Structure of Acetylcholine',2,'AxelBoldt','20021217012842','0','BITMAP','image','png',0,'i4vz31wiz0tnny9jokx85r26fbakvbd'),(9,'Davy-Crockett.jpg','20030102172931!Davy_Crockett.jpg',43253,350,422,8,'From [http:/  /  www.lib.utexas.edu], in the [[public domain]]',4,'Magnus Manske','20021230223953','0','BITMAP','image','jpeg',0,'isginbw7z6mrvvvws02wc9egwr19fuc'),(10,'Pillwar.png','20031118040840!Pillwar.png',16103,519,367,8,'Bolo screenshot, presumed fair use, or something',10109,'Evercat','20030920191931','0','BITMAP','image','png',0,'a5pgwx6i6hji79ie9uqab4y94uesfsm'),(11,'ECClines.png','20030122033023!ECClines.png',7821,700,190,8,'for elipptic curve group; by me for Wiki',4476,'Chas zzz brown','20030122031512','0','BITMAP','image','png',0,'81c2gjz0ihq06o9lzw4xonxb39ot368'),(12,'ECClines.png','20030122082131!ECClines.png',9625,700,190,8,'better version; by me for wiki',4476,'Chas zzz brown','20030122033023','0','BITMAP','image','png',0,'gvo17yccg36u7ycd4966ewqdaonntbf'),(13,'Elas.gif','20030122141949!Elas.gif',4244,0,0,0,'Example of perfectly elastic and inelastic demand',7178,'Finsj','20030120080513','',NULL,'unknown','unknown',0,''),(14,'Elas.gif','20030122141949!Elas.gif',4286,0,0,0,'Example of perfect elasticity and inelasticity',7178,'Finsj','20030122142001','',NULL,'unknown','unknown',0,''),(15,'Elas.gif','20030122141949!Elas.gif',4286,0,0,0,'Example of perfect elasticity and inelasticity',7178,'Finsj','20030122142227','',NULL,'unknown','unknown',0,''),(16,'','20030215192830!Dolly_the_sheep2-thumb.jpg',5515,0,0,0,'Thumbnail photo of [[Dolly the sheep]] based on [[:image:Dolly the sheep2.jpg]] owned by [[Roslin Institute]] obtained from http:/ / www.roslin.ac.uk/ library/  . This image ',62,'Mav','20030215192759','',NULL,'unknown','unknown',0,''),(17,'Junkers-Ju-388L-1.jpg','20030222170821!Junkers_Ju_388L-1.jpg',32809,1005,360,8,'Junkers Ju 388L-1',2175,'Maury Markowitz','20030222170607','0','BITMAP','image','jpeg',0,'q790yjiodnlk8f69hlldmv6qg1gmvkd'),(18,'Complex.png','20030227215211!Complex.png',15392,767,1014,8,'',4808,'Wshun','20030227215028','0','BITMAP','image','png',0,'6orn3b7xkitya5tgwsgx7r2ryxumh9o'),(19,'Complex.png','20030227215546!Complex.png',13067,300,396,8,'',4808,'Wshun','20030227215213','0','BITMAP','image','png',0,'3a8s2ca92263a57661pb4wlyph2wl6g'),(20,'Complex.png','20030227215612!Complex.png',15382,767,1014,8,'misspelling in previous version',4808,'Wshun','20030227215546','0','BITMAP','image','png',0,'pgv2u47f024xch79m7v5utblr8wiy86'),(21,'Hseries.png','20030303221320!Hseries.png',4398,400,81,8,'1st 16 notes of harmonic series',4191,'Nevilley','20030303221013','0','BITMAP','image','png',0,'rtfmog878dx8gmpx0jjy4onmsm5k654'),(22,'Hseries.png','20030303221413!Hseries.png',8849,1423,233,8,'Larger try of harmonic series',4191,'Nevilley','20030303221320','0','BITMAP','image','png',0,'95rowxe9ncmsl54rc68eqyl7hso4n6u'),(23,'Reflection-in-a-ripple-tank.png','20030305100132!Reflection_in_a_ripple_tank.png',10522,339,210,8,'Two diagrams showing a plane wave reflecting off a barrier',8257,'Theresa knott','20030305095514','0','BITMAP','image','png',0,'hkdasgbdcibis24anmz32rc1nt1kz7b'),(24,'Reflection-in-a-ripple-tank.png','20030305111000!Reflection_in_a_ripple_tank.png',9620,356,226,8,'',8257,'Theresa knott','20030305100136','0','BITMAP','image','png',0,'nyqeb1cugvxh5qikdh4s0wimvejyoh3'),(25,'Ripple-tank-plane-waves.png','20030305121709!Ripple_tank_plane_waves.png',7563,258,178,8,'view of the shadows formed when plane waves are produced on a riple tank. Diagram drawn by theresa knott',8257,'Theresa knott','20030305085758','0','BITMAP','image','png',0,'brnxu7t880n49vwen99c4pvw1gpzv7o'),(26,'Reflecting-from-a-curved-barrier.png','20030305125934!Reflecting_from_a_curved_barrier.png',15574,293,97,8,'Plane waves approaching a curved barier, reflecting from it and focusing at a point. Diagram drawn by theresa knott',8257,'Theresa knott','20030305125602','0','BITMAP','image','png',0,'sp8e50vcvns2iy2dywpe7mb7l969h9x'),(27,'HiroshimaPrefecturalPromotionHall.JPG','20030310075248!HiroshimaPrefecturalPromotionHall.JPG',28850,640,480,8,'Hiroshima Prefectural Promotion Hall, the only building standing after the blast.',9023,'Xamian','20030310054613','0','BITMAP','image','jpeg',0,'le7e4u5v5iqnxb0dsbmu5hsqvfxrv25'),(28,'Motlawa-2002.jpg','20030310223236!Motlawa_2002.jpg',45745,712,358,8,'',3759,'Topory','20030310210916','0','BITMAP','image','jpeg',0,'m2171bm4yn7njc3rtjo8cg8rcbce82v'),(29,'Motlawa-2002.jpg','20030310223322!Motlawa_2002.jpg',54946,712,358,8,'',3759,'Topory','20030310223236','0','BITMAP','image','jpeg',0,'kfhm3t8aygikwdociusg95ii5u1jff6'),(30,'HiroshimaPrefecturalPromotionHall.JPG','20030311011732!HiroshimaPrefecturalPromotionHall.JPG',11329,300,225,8,'downsized to 300px',62,'Mav','20030310075248','0','BITMAP','image','jpeg',0,'ll8aj71df5rwrdpybdd5stpb87fjql8'),(31,'HiroshimaPrefecturalPromotionHall.JPG','20030311011813!HiroshimaPrefecturalPromotionHall.JPG',28850,640,480,8,'Reverted to earlier revision',9023,'Xamian','20030311011732','0','BITMAP','image','jpeg',0,'le7e4u5v5iqnxb0dsbmu5hsqvfxrv25'),(32,'Louisiana-purchase-treaty1.jpg','20030311082900!Louisiana_purchase_treaty1.jpg',116886,586,877,8,'',0,'(Automated conversion)','20020720114937','0','BITMAP','image','jpeg',0,'1t2648anb18i5yhhfk12x7qmauls6l9'),(33,'CrassTheFeedingofthe5000.jpg','20030314124810!CrassTheFeedingofthe5000.jpg',14403,200,200,8,'Crass \"The Feeding of the 5000\" album cover',8351,'TUF-KAT','20030314055951','0','BITMAP','image','jpeg',0,'2vxjk2l7n59zejx4ordtyjr35srx5or'),(34,'Clovehitch.png','20030321133256!Clovehitch.png',13293,874,754,8,'clove hitch',2954,'Heron','20030321132741','0','BITMAP','image','png',0,'4cfjb0o7wfkqdlgp9h9skaquuw3cwnn'),(35,'Ideogram-ji.png','20030324231304!Ideogram_ji.png',33102,107,102,0,'created by [[TakuyaMurata]]',6707,'TakuyaMurata','20030324225858','0','BITMAP','image','x-bmp',0,'ndunhxfih5f167rywl6gln4p5w29pu1'),(36,'Boss-tweed.jpg','20030406085850!Boss_tweed.jpg',61513,400,406,8,'1869 tobacco label portraying Boss Tweed, from http:/ / memory.loc.gov/ ammem/ today/ dec04.html',6280,'Dave Farquhar','20030403154119','0','BITMAP','image','jpeg',0,'ahczmxb3kcpnk41xol05wl7ac2evdjj'),(37,'Bundeslaender-germany-he.png','20030425200851!Bundeslaender_germany_he.png',5663,221,298,4,'memory optimized image',2124,'Flups','20030423233959','0','BITMAP','image','png',0,'se4a870qbi76jn1sm17bghmlaizpfh9'),(38,'Bundeslaender-germany-he.png','20030423233958!Bundeslaender_germany_he.png',26322,226,324,8,'Federal states of Germany: Hesse',4024,'Cordyph','20030228130722','0','BITMAP','image','png',0,'2toknleqeswrr4qwrvaw1xjnswtz11j'),(39,'Bundeslaender-germany-mv.png','20030425202226!Bundeslaender_germany_mv.png',26188,226,324,8,'Federal states of Germany: Mecklenburg-Western Pomerania',4024,'Cordyph','20030228130759','0','BITMAP','image','png',0,'t7rt1x0v2ryf5kyb3vevrk050et1j5q'),(40,'Bundeslaender-germany-rp.png','20030425202834!Bundeslaender_germany_rp.png',26147,226,324,8,'Federal states of Germany: Rhineland-Palatinate',4024,'Cordyph','20030228130910','0','BITMAP','image','png',0,'4u1o5i0uttawgy3p0kkk1e9ju1scz2j'),(41,'Bundeslaender-germany-sh.png','20030425204630!Bundeslaender_germany_sh.png',25989,226,324,8,'Federal states of Germany: Schleswig-Holstein',4024,'Cordyph','20030228131006','0','BITMAP','image','png',0,'2i849ch8o61h4ildz10an9xmi4gymp0'),(42,'Bundeslaender-germany-th.png','20030425204853!Bundeslaender_germany_th.png',26090,226,324,8,'Federal states of Germany: Thuringia',4024,'Cordyph','20030228131044','0','BITMAP','image','png',0,'64mha1efef106pqrcgsx8uj0uho4tpo'),(43,'Bundeslaender-germany-hb.png','20030425205202!Bundeslaender_germany_hb.png',25231,226,324,8,'Federal states of Germany: Bremen',4024,'Cordyph','20030228130706','0','BITMAP','image','png',0,'scqdf0dk1blwovw9eukqt5xl2664wtl'),(44,'Bundeslaender-germany-sx.png','20030425205406!Bundeslaender_germany_sx.png',26038,226,324,8,'Federal states of Germany: Saxony',4024,'Cordyph','20030228131021','0','BITMAP','image','png',0,'h1d4u7hz436i2wr5ie7rowe1m2ibuet'),(45,'Bundeslaender-germany-sa.png','20030425205510!Bundeslaender_germany_sa.png',26289,226,324,8,'Federal states of Germany: Saxony-Anhalt',4024,'Cordyph','20030228130929','0','BITMAP','image','png',0,'cezaysfwtx8gmscv0vjo4lmyboc0bwv'),(46,'NurembergTrials.jpg','20030504102347!NurembergTrials.jpg',88736,400,312,8,'Nuremberg Trials',2376,'Zoe','20030504034152','0','BITMAP','image','jpeg',0,'oefnt3vq16sgbukqkn6tk8bvgd5cy7x'),(47,'Roger-Needham.jpg','20030521054954!Roger_Needham.jpg',6521,160,155,8,'Assumed to be fair use. From [http:/ / europa.eu.int/ comm/ research/ science-society/ women/ wir/ cvneedham.html]',62,'Mav','20030308095107','0','BITMAP','image','jpeg',0,'mdgxb7sqedzzc1psoba8k0z7xbzvaa7'),(48,'Benjaminfranklin.jpg','20030523022616!Benjaminfranklin.jpg',87258,327,399,8,'Images of American Political History  ',8780,'Kingturtle','20030522231103','0','BITMAP','image','jpeg',0,'g40w9fyq6tqm7ikvudzv4g7l0676o9x'),(49,'Benjaminfranklin.jpg','20030523042532!Benjaminfranklin.jpg',17871,327,399,8,'touched up, optimized, compressed',3853,'Mbecker','20030523022616','0','BITMAP','image','jpeg',0,'38w0ouy0uvakemsl2dqve9l67bjw150'),(50,'Fuzzyimage.png','20030603101138!Fuzzyimage.png',4499,182,92,8,'fuzzy logic basic xplntn',4099,'Stevertigo','20030603100217','0','BITMAP','image','png',0,'li74s1d9p1oyxe513ai67ybah564akm'),(51,'Vampmasq.jpg','20030613202940!Vampmasq.jpg',27022,437,600,8,'The cover of [[Vampire: The Masquerade]] (3rd edition)',11070,'Pizza Puzzle','20030613202700','0','BITMAP','image','jpeg',0,'2gu0r97r3t43co4alhnslvmxlbl8hy2'),(52,'Wikipedia.vim','20030615135555!Wikipedia.vim',13664,0,0,0,'Wikipedia syntax highlighting file for [[Vim]]',4635,'Tim Starling','20030615132306','','UNKNOWN','unknown','unknown',0,'lamjm6wkpdym56n1r0udftukoezifzr'),(53,'EBerlinerGramophoneDisc.png','20030623031715!EBerlinerGramophoneDisc.png',286038,421,435,8,'Berliner Gramophone Disc Record, 1897',4444,'Infrogmation','20030616222500','0','BITMAP','image','png',0,'ky6qyads8e0aq0osfa7tkws1iv8v4fv'),(54,'Am-radio.png','20030719020503!Am_radio.png',6403,1170,924,8,'Network schematic of an AM radio',122,'Ap','20030719020038','0','BITMAP','image','png',0,'eilvsarwk08wwx6qss9di31nu5qn4xk'),(55,'Am-radio.png','20030719022020!Am_radio.png',4045,585,462,8,'Reduced resolution version',122,'Ap','20030719020503','0','BITMAP','image','png',0,'e9or8kbsa4oa040rqmtjzeo3ec8lq6f'),(56,'Am-radio.png','20030719022221!Am_radio.png',9795,599,516,8,'Compacter version',122,'Ap','20030719022020','0','BITMAP','image','png',0,'bu7llu6jggzfe2jc6chjmdalg6gl54d'),(57,'030817-silly.jpg','20030817120255!030817_silly.jpg',97236,800,600,8,'Railway station of Silly ',19650,'Sdschuit','20030817115109','a:27:{s:16:\"ImageDescription\";s:31:\"OLYMPUS DIGITAL CAMERA         \";s:4:\"Make\";s:23:\"OLYMPUS OPTICAL CO.,LTD\";s:5:\"Model\";s:6:\"C2000Z\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:27:\"ACD Systems Digital Imaging\";s:8:\"DateTime\";s:19:\"2003:08:17 13:50:47\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:7:\"10/1250\";s:7:\"FNumber\";s:5:\"50/10\";s:15:\"ExposureProgram\";i:4;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2003:08:17 11:54:41\";s:17:\"DateTimeDigitized\";s:19:\"2003:08:17 11:54:41\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"30/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"82/10\";s:10:\"SubSecTime\";s:2:\"63\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'lww0sol4v1pvw7iuocb2x7dyozttx7e'),(58,'Ardagh-House.jpg','20030724154427!Ardagh_House.jpg',404293,1144,753,8,'Picture of house in Ardagh',10719,'Harry Potter','20030724153559','0','BITMAP','image','jpeg',0,'sbgf8jldiet2e5ehn03ccj6vsdtf6fs'),(59,'Ardagh-House.jpg','20030724154427!Ardagh_House.jpg',117650,1144,753,8,'smaller version than before',10719,'Harry Potter','20030724154432','0','BITMAP','image','jpeg',0,'sbgf8jldiet2e5ehn03ccj6vsdtf6fs'),(60,'Ardagh-House.jpg','20030724155427!Ardagh_House.jpg',117650,551,363,8,'smaller version than before',10719,'Harry Potter','20030724154858','0','BITMAP','image','jpeg',0,'ddii9fx1zkcfuolx7s501reh2822t6m'),(61,'Ardagh-House.jpg','20030724155427!Ardagh_House.jpg',15327,551,363,8,'',10719,'Harry Potter','20030724155431','0','BITMAP','image','jpeg',0,'ddii9fx1zkcfuolx7s501reh2822t6m'),(62,'Data-Strobe-Encoding.png','20030813173706!Data_Strobe_Encoding.png',2968,379,240,8,'Data strobe encoding and the resultant clock.',15182,'Colin Marquardt','20030813172632','0','BITMAP','image','png',0,'kfjvx8dkmo5hd3zvtoz900wn58r679l'),(63,'Data-Strobe-Encoding.png','20030813175246!Data_Strobe_Encoding.png',2621,379,240,8,'New version.',15182,'Colin Marquardt','20030813173706','0','BITMAP','image','png',0,'j24lfo4ustjh5xf0yzy1nwgddpunt39'),(64,'Donostia.jpg','20030813201724!Donostia.jpg',13187,408,269,8,'Donostia/ San Sebastian pic',19150,'Jmartinezot','20030813141419','0','BITMAP','image','jpeg',0,'3t9j6uq1ftvfnpnep6dgoibbrv0wlnd'),(65,'Donostia.jpg','20030813201943!Donostia.jpg',13244,327,216,8,'Donostia /  San Sebastian',19150,'Jmartinezot','20030813201724','0','BITMAP','image','jpeg',0,'49rjnzurbllpsui5h7zlpot1ka4ezcx'),(66,'Crecy.png','20030827134401!Crecy.png',45255,946,733,8,'sketch of the battle of crecy',8201,'Muriel Gottrop','20030827134028','0','BITMAP','image','png',0,'qnwbog90o0q5ilu2z6s8vt34kfut93x'),(67,'Cursus.png','20030827140151!Cursus.png',48882,941,607,8,'roman cursus honorum',8201,'Muriel Gottrop','20030827135950','0','BITMAP','image','png',0,'rstfhblvh7mxsj2c4daq2ftxumtc0qv'),(68,'Cursus.png','20030901104316!Cursus.png',35601,627,405,8,'smaller...',8201,'Muriel Gottrop','20030827140151','0','BITMAP','image','png',0,'6um1eai88pytnwq836y51ca6zfpqsc8'),(69,'Kit1.jpg','20030911021801!Kit1.jpg',59274,1109,1121,8,'an extended drum kit',8846,'Andrewa','20030911020229','0','BITMAP','image','jpeg',0,'l18d04syh0moq60ljqyonqubxv576w3'),(70,'Bled-lake.jpg','20031017120310!Bled_lake.jpg',23211,400,300,8,'Lake of Bled, taken by myself',24744,'Donarreiskoffer','20031017115225','0','BITMAP','image','jpeg',0,'2tr9rrub80pdq5ci6v10gdjnsvz333d'),(71,'SLR.jpg','20030927002907!SLR.jpg',16587,300,248,8,'Replacing PNG',43,'Lee Daniel Crocker','20020905165210','0','BITMAP','image','jpeg',0,'8d1cabeqnpmfhwtk05lpnvxfffkymk8'),(72,'Bakert.jpg','20031010223718!Bakert.jpg',111091,523,561,8,'non-copyrighted publicity still of Tom Baker as the Doctor',6661,'PMelvilleAustin','20031010223023','0','BITMAP','image','jpeg',0,'451e29kf0pf2fzk4ywmxak1xj7pmch9'),(73,'Rotunda.jpg','20031012201449!Rotunda.jpg',18282,248,165,8,'Thomas Jefferson\'s Rotunda',25253,'Aplank','20031011151614','0','BITMAP','image','jpeg',0,'3avwf5ldggcto0gwaui5wha2nb4ck0r'),(74,'Diag.png','20031014180950!Diag.png',4268,622,877,8,'Diagonal commutative diagrams',18901,'Phys','20030923215132','0','BITMAP','image','png',0,'j8x82yb2h8kwdzk1xt6bduaa1v7zz2j'),(75,'Complex.png','20031018010845!Complex.png',13037,300,396,8,'',4808,'Wshun','20030227215612','0','BITMAP','image','png',0,'lsjdt1yc0i1ba2al7y9dr78gn0vdfa6'),(76,'Complex.png','20031018011053!Complex.png',0,0,0,0,'better one',4808,'Wshun','20031018010845','0','BITMAP','image','png',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(77,'JoeMabel1.jpg','20031030064500!JoeMabel1.jpg',2604,83,84,8,'Joe Mabel self portrait',28107,'Jmabel','20031030064402','0','BITMAP','image','jpeg',0,'kdtl7v2y81b23agj3kjxqzyv5wnj1zj'),(78,'JoeMabel1.jpg','20031030064602!JoeMabel1.jpg',2604,83,84,8,'Joe Mabel self portrait',28107,'Jmabel','20031030064500','0','BITMAP','image','jpeg',0,'kdtl7v2y81b23agj3kjxqzyv5wnj1zj'),(79,'JoeMabel1.jpg','20031030064623!JoeMabel1.jpg',2604,83,84,8,'Reverted to earlier revision',28107,'Jmabel','20031030064603','0','BITMAP','image','jpeg',0,'kdtl7v2y81b23agj3kjxqzyv5wnj1zj'),(80,'Hebe-small.png','20031102055533!Hebe_small.png',15582,126,112,8,'part of photo i took',10003,'Tristanb','20031102014602','0','BITMAP','image','png',0,'rc02pqzhmmxc4fq75bbrep3qpyedjx1'),(81,'LeicesterShires.jpg','20031102130432!LeicesterShires.jpg',38331,626,400,8,'the corner of the shires, leicester',17287,'Morwen','20031102130105','0','BITMAP','image','jpeg',0,'jksuaxufkfg4tzbc3owax89cmh82nkh'),(82,'LeicesterShires.jpg','20031102130724!LeicesterShires.jpg',0,0,0,0,'smaller shires image now',17287,'Morwen','20031102130440','0','BITMAP','image','jpeg',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(83,'Southernalligatorlizard.jpg','20031103034234!Southernalligatorlizard.jpg',144299,500,381,8,'',12028,'Jengod','20031103023533','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"400/1\";s:11:\"YResolution\";s:5:\"400/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2003:11:02 18:29:49\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'43ffrocpgzo0gl1ggrmn7r6w573u5sg'),(84,'Rotunda.jpg','20031103042826!Rotunda.jpg',13139,200,147,8,'Rotunda',25253,'Aplank','20031012201449','0','BITMAP','image','jpeg',0,'kw8uww8k01ea2i8qpw5nrpk2ie2p9qe'),(85,'Rotunda.jpg','20031103043343!Rotunda.jpg',18282,248,165,8,'Reverted to earlier revision',18998,'ElmoHoo','20031103042827','0','BITMAP','image','jpeg',0,'3avwf5ldggcto0gwaui5wha2nb4ck0r'),(86,'Lightning-rod.png','20031103163129!Lightning_rod.png',5984,158,223,8,'Lightning-Protector US1266175 patent',13833,'Reddi','20030930000542','0','BITMAP','image','png',0,'chstsofmqcgeqybhsagn0otwq6tpp7x'),(87,'Ny.terra.600pix.jpg','20031106191458!Ny.terra.600pix.jpg',167781,600,796,8,'New York from space',7095,'Arpingstone','20031106191152','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"100/1\";s:11:\"YResolution\";s:5:\"100/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2003:08:01 17:01:25\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'0scvarml0jl3yavy9qonwgao2ahkxuz'),(88,'Ac.woodsworth.jpg','20031107030856!Ac.woodsworth.jpg',26423,415,540,8,'J S Woodsworth',22444,'Adam Carr','20031107025624','0','BITMAP','image','jpeg',0,'aqugglxlph0t5jtje8ycgzlp8krl6lr'),(89,'Hitlermusso.jpg','20031107072536!Hitlermusso.jpg',41492,277,307,8,'Hitler and Mussolini salute',9718,'J.J.','20030710054549','0','BITMAP','image','jpeg',0,'20i6x7jmnvuiprsgx6dileu3s2k2ryf'),(90,'LeicesterHumberstoneGate.jpg','20031108221807!LeicesterHumberstoneGate.jpg',28110,480,357,8,'Humberstone Gate, in Leicester',17287,'Morwen','20031108221530','0','BITMAP','image','jpeg',0,'c747f4hzn6s1lyfpvfomryigyokj8vt'),(91,'Port-Jackson-Fig-detail.jpg','20031110094305!Port_Jackson_Fig_detail.jpg',44914,800,426,8,'Port Jackson Fig - detail',8846,'Andrewa','20031110093420','0','BITMAP','image','jpeg',0,'ldvbdqbofaxu5fgye7e11eddff25b8z'),(92,'Port-Jackson-Fig-detail.jpg','20031110094400!Port_Jackson_Fig_detail.jpg',44914,800,426,8,'',8846,'Andrewa','20031110094311','0','BITMAP','image','jpeg',0,'ldvbdqbofaxu5fgye7e11eddff25b8z'),(93,'Tierce.png','20031110130245!Tierce.png',2736,341,101,8,'An example of a tierce de Picardie, from Bach\'s \'\'Ich habe genug\'\' cantata, drawn by myself',14486,'Dysprosia','20031110093223','0','BITMAP','image','png',0,'rvues3pn7syzk8eorv4dzl9sz90pocs'),(94,'Complex.png','20031111005317!Complex.png',13037,300,396,8,'Reverted to earlier revision',4808,'Wshun','20031018011053','0','BITMAP','image','png',0,'lsjdt1yc0i1ba2al7y9dr78gn0vdfa6'),(95,'Robotwar.png','20031112003343!Robotwar.png',8829,571,391,8,'RobotWar screenshot',18084,'Tempshill','20031112002749','0','BITMAP','image','png',0,'9rqz6vl4bqzsbdrv0lo1tdmygsvucw0'),(96,'Robotwar.png','20031112003826!Robotwar.png',22049,428,293,8,'RobotWar screenshot',18084,'Tempshill','20031112003344','0','BITMAP','image','png',0,'paal0icoythzi26w012eo6qlrxp2qxc'),(97,'SOEgeorgestarr.jpg','20031114001933!SOEgeorgestarr.jpg',16928,209,340,8,'One of my own family photographs',29653,'Petermanchester','20031111131935','0','BITMAP','image','jpeg',0,'tf2a6ihungqf32sshuvel7gqgr27kh2'),(98,'Jules-verne.jpeg','20031115193853!Jules_verne.jpeg',35559,194,262,8,'',0,'(Automated conversion)','20020720114926','0','BITMAP','image','jpeg',0,'lvv1a7qjt6rb09r31yw6xsykw4u1s9j'),(99,'Nl-map.png','20031116004408!Nl-map.png',67922,517,628,8,'Map of Newfoundland and Labrador (created from public domain material by Montrealais)',3378,'Montrealais','20031019061825','0','BITMAP','image','png',0,'b37orj9oou1kl8y82jzmfbavp5lrpg3'),(100,'LocationSerbiaAndMontenegro.png','20031116054644!LocationSerbiaAndMontenegro.png',6127,250,115,8,'Location of Serbia and Montenegro',11304,'Nikola Smolenski','20031102084125','0','BITMAP','image','png',0,'82wfazk54m96zy26a5bk9c07jloniw6'),(101,'LocationSerbiaAndMontenegro.png','20031116055549!LocationSerbiaAndMontenegro.png',6928,250,115,8,'Location map for Serbia and Montenegro',25556,'Vardion','20031116054644','0','BITMAP','image','png',0,'9qlazwcvtccrlrf5jkvyrs40obzed4m'),(102,'Arnold-Schwarzenegger-sexual-harassment-protestors.JPG','20031117215055!Arnold_Schwarzenegger_sexual_harassment_protestors.JPG',821310,2048,1536,8,'Photo taken at [[Arnold Schwarzenegger]]\'s inauguration on [[November 17]], [[2003]]. Image released under the [[GND FDL]].  Source file',62,'Mav','20031117212328','a:24:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:9:\"CYBERSHOT\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2003:11:17 12:06:22\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/6400\";s:7:\"FNumber\";s:5:\"56/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:200;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2003:11:17 12:06:22\";s:17:\"DateTimeDigitized\";s:19:\"2003:11:17 12:06:22\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"48/16\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:21;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"80/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'hb5r5byvnm0iec2gky7gg3ggmt76pwv'),(103,'Jackfruit-chips.jpg','20031119184210!Jackfruit_chips.jpg',18630,333,519,8,'Pictures I took myself of jackfruit chips',18338,'Flyingbird','20031111180134','0','BITMAP','image','jpeg',0,'9236vsaxs8jcxgdgf8gqkqvozag3jkc'),(104,'Jackfruit-chips.jpg','20031119185545!Jackfruit_chips.jpg',17301,266,403,8,'Sharper picture that I took of some Jackfruit chips',18338,'Flyingbird','20031119184210','0','BITMAP','image','jpeg',0,'ku3bectr6gk3wd3ssxwh0cckv331gy5'),(105,'NewZealandElectorates2002.png','20031121011219!NewZealandElectorates2002.png',17380,423,604,8,'Map of New Zealand electorates in the 2002 election',25556,'Vardion','20031121004303','0','BITMAP','image','png',0,'tiwpxwmfya8cx94xt7z3ss8lpnrg7pe'),(106,'Hfem.jpg','20031121090320!Hfem.jpg',1259,195,24,8,'by me',4127,'Hfastedge','20031121085820','0','BITMAP','image','png',0,'ap9f48i5d2v3ser3d4dp33fk8opt2am'),(107,'Disc-tumbler-unlocked.png','20031121222636!Disc_tumbler_unlocked.png',9344,250,194,8,'Illustration of the [[disc tumbler lock]] created by [[User:Wapcaplet|Wapcaplet]] in [[Blender (program)|Blender]] and touched up in the [[GIMP]].',6264,'Wapcaplet','20031121221742','0','BITMAP','image','png',0,'948a0ywuhs155dtw2xgmbcsnkx17lko'),(108,'SSA-example1.2.png','20031123041656!SSA_example1.2.png',11488,200,290,8,'An example CFG with SSA partially done',13476,'Dcoetzee','20031123040646','0','BITMAP','image','png',0,'64gi8hg0acuaitookqke1c8rbx65k31'),(109,'SSA-example1.1.png','20031123041721!SSA_example1.1.png',10379,200,290,8,'An example control flow graph',13476,'Dcoetzee','20031123035442','0','BITMAP','image','png',0,'hbuu15i94s944i2rtx2tkka41v24qz5'),(110,'SSA-example1.2.png','20031123042317!SSA_example1.2.png',10809,200,290,8,'',13476,'Dcoetzee','20031123041656','0','BITMAP','image','png',0,'srgtaab98gu4302bis3txd112o5u9n2'),(111,'SOE-(F)-Networks-in-France-June-1943.jpg','20031123135048!SOE_(F)_Networks_in_France_June_1943.jpg',36285,496,540,8,'Map showing major SOE networks in France, June 1943',29653,'Petermanchester','20031122230710','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"200/1\";s:11:\"YResolution\";s:5:\"200/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2003:11:22 22:58:01\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'pmlcd62yo6id3wygrk2xid0lboiuhrg'),(112,'SOE-(F)-Networks-in-France-June-1943.jpg','20031123153832!SOE_(F)_Networks_in_France_June_1943.jpg',38492,512,524,8,'Map showing major SOE networks in France, June 1943',29653,'Petermanchester','20031123135052','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"500/1\";s:11:\"YResolution\";s:5:\"500/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2003:11:23 13:44:57\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'qt3ltj0tg1t9fpat0tpakbotllxda5z'),(113,'LondonWestEnd.png','20031126074819!LondonWestEnd.png',17958,201,166,8,'outline map showing the west end of london, see [[Image:LondonCity.png]] for copyright',17287,'Morwen','20031126073818','0','BITMAP','image','png',0,'3y2h7fvmeg4vyfy8s4yomhfy8nvp0gy'),(114,'NewZealandElectorates1999.png','20031126080350!NewZealandElectorates1999.png',19865,423,604,8,'Map of electorates in the 1999 New Zealand elections',25556,'Vardion','20031123112855','0','BITMAP','image','png',0,'dociha5udqvnc4a9bbwc0u71wqe4avv'),(115,'WallpaperP3.GIF','20031204034448!WallpaperP3.GIF',8019,250,250,8,'Example of wallpaper plane class p3',32987,'AnomalousArtemis','20031204034114','0','BITMAP','image','gif',0,'9qhp3izm9aumqman5861c8eocydl7aw'),(116,'WallpaperP3.GIF','20031204034112!WallpaperP3.GIF',8019,250,250,8,'Example of wallpaper plane class p2 ',32987,'AnomalousArtemis','20031204034048','0','BITMAP','image','gif',0,'9qhp3izm9aumqman5861c8eocydl7aw'),(117,'Hungerfordfootbridge.jpg','20031128182907!Hungerfordfootbridge.jpg',127771,640,480,8,'Hungerford foot bridge',17287,'Morwen','20031128182800','a:38:{s:4:\"Make\";s:8:\"FUJIFILM\";s:5:\"Model\";s:14:\"FinePix A202  \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:37:\"Digital Camera FinePix A202   Ver1.00\";s:8:\"DateTime\";s:19:\"2003:11:28 13:14:21\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/4200\";s:7:\"FNumber\";s:7:\"460/100\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2003:11:28 13:14:21\";s:17:\"DateTimeDigitized\";s:19:\"2003:11:28 13:14:21\";s:22:\"CompressedBitsPerPixel\";s:5:\"30/10\";s:17:\"ShutterSpeedValue\";s:7:\"870/100\";s:13:\"ApertureValue\";s:7:\"440/100\";s:15:\"BrightnessValue\";s:7:\"834/100\";s:17:\"ExposureBiasValue\";s:5:\"0/100\";s:16:\"MaxApertureValue\";s:7:\"440/100\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:7:\"550/100\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:6:\"1231/1\";s:21:\"FocalPlaneYResolution\";s:6:\"1231/1\";s:24:\"FocalPlaneResolutionUnit\";i:3;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"SceneCaptureType\";i:0;s:9:\"Sharpness\";i:3;s:20:\"SubjectDistanceRange\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'6xm3gg1fwdb9mph9v8sv3kl8lcuef38'),(118,'Castile-familytree.png','20031129090534!Castile-familytree.png',39981,741,1796,1,'kings of Castile family tree',8201,'Muriel Gottrop','20031030110942','0','BITMAP','image','png',0,'jnbvhvt95fpzt0hwz3vn537wwtip1pa'),(119,'France-1stCarolingians.png','20031129090608!France-1stCarolingians.png',14869,741,702,1,'Kings of France - 1st Dynasty, Carolingians',8201,'Muriel Gottrop','20031029104245','0','BITMAP','image','png',0,'8l3134xjyidmnfi3t8k7c1tmn6rys0u'),(120,'France-2ndCapet.png','20031129090653!France-2ndCapet.png',35904,741,1661,1,'Kings of France - 2nd dynasty, Capet',8201,'Muriel Gottrop','20031029104328','0','BITMAP','image','png',0,'1yrvrg8976lr00a5nv8zpz4o7ybfe0y'),(121,'France-3rdValois.png','20031129090714!France-3rdValois.png',40219,741,1722,1,'Kings of France - 3rd dynasty, Valois',8201,'Muriel Gottrop','20031029104403','0','BITMAP','image','png',0,'2yqfhxedu0pwz0ql72ik0fkxo8pzmdg'),(122,'Navarre-familytree.png','20031129090757!Navarre-familytree.png',41207,741,1973,1,'Kings of Naverre family tree until Henry III',8201,'Muriel Gottrop','20031029105552','0','BITMAP','image','png',0,'0pz5vze63aaulv73a3w1rmr4p3j1q4l'),(123,'Spain-familytree.png','20031129090828!Spain-familytree.png',47871,741,2228,1,'kings of Spain (united) family tree',8201,'Muriel Gottrop','20031030111019','0','BITMAP','image','png',0,'cnpjjcexuevff3dqiu3jqhrxvhjr4ci'),(124,'SLR.jpg','20031129213905!SLR.jpg',40820,300,200,8,'Vancouverguy\'s 20-year-old camera',16445,'Vancouverguy','20030927002907','a:24:{s:4:\"Make\";s:15:\"Hewlett-Packard\";s:5:\"Model\";s:17:\"HP PhotoSmart 318\";s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:5:\"V4.00\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:13:\"27862/1000000\";s:7:\"FNumber\";s:8:\"2800/100\";s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2001:05:11 05:27:00\";s:17:\"DateTimeDigitized\";s:19:\"2001:05:11 05:27:00\";s:22:\"CompressedBitsPerPixel\";s:6:\"12/100\";s:17:\"ShutterSpeedValue\";s:7:\"516/100\";s:13:\"ApertureValue\";s:7:\"300/100\";s:17:\"ExposureBiasValue\";s:3:\"0/1\";s:16:\"MaxApertureValue\";s:7:\"600/100\";s:15:\"SubjectDistance\";s:6:\"40/100\";s:12:\"MeteringMode\";i:2;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:7:\"679/100\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'9sg2ou728grsmn2ncp1vmsagwi7t344'),(125,'SLR.jpg','20031129213921!SLR.jpg',16587,300,248,8,'Reverted to earlier revision',25873,'Noldoaran','20031129213905','0','BITMAP','image','jpeg',0,'8d1cabeqnpmfhwtk05lpnvxfffkymk8'),(126,'SLR.jpg','20031129214408!SLR.jpg',40820,300,200,8,'Reverted to earlier revision',25873,'Noldoaran','20031129213921','a:24:{s:4:\"Make\";s:15:\"Hewlett-Packard\";s:5:\"Model\";s:17:\"HP PhotoSmart 318\";s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:5:\"V4.00\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:13:\"27862/1000000\";s:7:\"FNumber\";s:8:\"2800/100\";s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2001:05:11 05:27:00\";s:17:\"DateTimeDigitized\";s:19:\"2001:05:11 05:27:00\";s:22:\"CompressedBitsPerPixel\";s:6:\"12/100\";s:17:\"ShutterSpeedValue\";s:7:\"516/100\";s:13:\"ApertureValue\";s:7:\"300/100\";s:17:\"ExposureBiasValue\";s:3:\"0/1\";s:16:\"MaxApertureValue\";s:7:\"600/100\";s:15:\"SubjectDistance\";s:6:\"40/100\";s:12:\"MeteringMode\";i:2;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:7:\"679/100\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'9sg2ou728grsmn2ncp1vmsagwi7t344'),(127,'Brun.jpg','20031201155756!Brun.jpg',70042,827,378,8,'',25253,'AlexPlank','20031201155535','0','BITMAP','image','jpeg',0,'krinrco9kztgpyfxhl8c5a6ksmei9st'),(128,'Brun.jpg','20031201160031!Brun.jpg',29088,606,254,8,'',25253,'AlexPlank','20031201155756','0','BITMAP','image','jpeg',0,'7re2h3mcxjaxamfh0vz7heo0kfwrm2b'),(129,'JutaroKomura.jpeg','20031202041439!JutaroKomura.jpeg',7137,210,199,8,'Komura Jutaro (pre-1911 photo from www.mofa.go.jp)',3628,'Hephaestos','20031130000831','0','BITMAP','image','jpeg',0,'r3t17xnssztmkayj08zxo4gcul7d057'),(130,'FurleyAmbWagon1880\'s.jpg','20031203154042!FurleyAmbWagon1880\'s.jpg',242437,1238,1106,8,'A Furley Ambulance Wagon from the 1880\'s',32965,'Tom perrett','20031203152333','0','BITMAP','image','jpeg',0,'jsxbc6ufgkcbwcj8qmc1msvk3zznghf'),(131,'Owlpussycat.jpg','20031204004937!Owlpussycat.jpg',30204,300,491,8,'Edward Lear, illustration and start of text for \"The Owl and the Pussycat\"',21036,'Dpbsmith','20031204002450','0','BITMAP','image','jpeg',0,'08b0j4ftutr4pck3v7kh9n42z6sun82'),(132,'Owlpussycat.jpg','20031204005618!Owlpussycat.jpg',19459,276,164,8,'Edward Lear illustration for \"The Owl and the Pussycat\"',21036,'Dpbsmith','20031204004937','0','BITMAP','image','jpeg',0,'0mldcppfuqfgzz7yp2htf1lndo1xr0x'),(133,'SA2-on-pad.jpg','20031205013811!SA2_on_pad.jpg',198685,342,451,8,'SA-2 on pad 34',29293,'Enceladus','20031204040039','0','BITMAP','image','jpeg',0,'im6ljh6smoc52zyw4874suicinaadms'),(134,'Uk2pnd2002-S.jpg','20031205235025!Uk2pnd2002-S.jpg',23504,512,384,8,'UK £2 coin, 2002 - Scottish variation - own scan',7891,'Arwel Parry','20031205233853','0','BITMAP','image','jpeg',0,'i75vwhnu7vcmcv6240rdfbz3rd971up'),(135,'Petroglyphs-on-Petroglyph-Point-4-750px.JPG','20031207100702!Petroglyphs_on_Petroglyph_Point-4-750px.JPG',86849,750,394,8,'Photograph by [[user:maveric149|Daniel Mayer]]. Taken in October 2003 and released under terms of the [[GNU FDL]]',62,'Mav','20031207100546','0','BITMAP','image','jpeg',0,'maew91nwzsn5y5wl3ax2jw9c707wc0u'),(136,'Uk2pnd2002-S.jpg','20031208023228!Uk2pnd2002-S.jpg',23504,512,384,8,'UK £2 coin, 2002 - Scottish variation - own scan',7891,'Arwel Parry','20031205235025','0','BITMAP','image','jpeg',0,'i75vwhnu7vcmcv6240rdfbz3rd971up'),(137,'Bilbao-metro-map.png','20031208083009!Bilbao-metro-map.png',21165,825,401,8,'Bilbao metro map, created by Montrealais (see image for copyright info and GNU release)',3378,'Montrealais','20031208083002','0','BITMAP','image','png',0,'2c82mg15rjogadmu93eez9jdkdogk9b'),(138,'WesternMeadowlark23.jpg','20031208095136!WesternMeadowlark23.jpg',9674,250,281,8,'Western Meadowlark from US FWS',9932,'Big iron','20031129125016','0','BITMAP','image','jpeg',0,'gruvojeba038ce6bnulrhms9nccfc9b'),(139,'WesternMeadowlark23.jpg','20031208095255!WesternMeadowlark23.jpg',9674,250,281,8,'Western Tanager from US FWS',9932,'Big iron','20031208095136','0','BITMAP','image','jpeg',0,'gruvojeba038ce6bnulrhms9nccfc9b'),(140,'Ontesx.PNG','20031209042128!Ontesx.PNG',0,0,0,0,'',26201,'Earl Andrew','20031209042020','0','BITMAP','image','png',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(141,'Ontwln.PNG','20031209045506!Ontwln.PNG',9687,378,379,8,'Wellington',26201,'Earl Andrew','20031209045304','0','BITMAP','image','png',0,'tbriq3y4lh8dzwgvjvoiwx9wggx191j'),(142,'Diag.png','20031211125635!Diag.png',2234,292,80,8,'optimizing',3628,'Hephaestos','20031014180950','0','BITMAP','image','png',0,'g2zess7l9uk7r8qkkq6n5523hjqjvk8'),(143,'Diag.png','20031211125733!Diag.png',1872,183,167,8,'Illustration of defining property of projective modules',2,'AxelBoldt','20031211125635','0','BITMAP','image','png',0,'moh5ga7rucck0mandk6op5b6t813595'),(144,'Christian-lineage.JPG','20031211164208!Christian-lineage.JPG',33296,740,297,8,'picture to replace ascii art on [[Christianity]]',8995,'LittleDan','20031016213359','0','BITMAP','image','jpeg',0,'jng5ahkq9wido645vfuyg9m48psspfb'),(145,'No-stubs.PNG','20031213030348!No_stubs.PNG',7389,192,197,8,'no stubs logo for my user page, created and GDFL\'d by [[User:Pcb21]] who is clearly not an artist',7320,'Pcb21','20031016102952','0','BITMAP','image','png',0,'s9gbmxh61o4uagblr17hgcletmn2j48'),(146,'No-stubs.PNG','20031213031414!No_stubs.PNG',34753,192,197,8,'Enhanced',33763,'Greenmountainboy','20031213030348','0','BITMAP','image','png',0,'314lhsaltjevb1u6080m1dozmb42ngx'),(147,'Gscarborough.jpg','20031213175946!Gscarborough.jpg',15993,165,277,8,'',33763,'Greenmountainboy','20031213175553','0','BITMAP','image','jpeg',0,'bt8qcwr97dnhpc4hb8c2m458bi68776'),(148,'Serotoninbiosynthesis.jpg','20031214171917!Serotoninbiosynthesis.jpg',25,0,0,0,'serotonin biosynthesis',34451,'Fuelbottle','20031214164552','0','BITMAP','image','jpeg',0,'97ojjgvxme4i0rohuwi2bai0t4eunkd'),(149,'HowardjohnsonwwII.png','20031214200747!HowardjohnsonwwII.png',37292,385,128,8,'Howard Johnson\'s logo, circa World War II',21036,'Dpbsmith','20031214195112','0','BITMAP','image','png',0,'4zjr5vcehg3l704w0qxe4gwf5eshsz4'),(150,'MaryPhagan.jpg','20031215105552!MaryPhagan.jpg',5104,150,162,8,'Mary Phagan, 1915 photo',14002,'Viajero','20031215104441','0','BITMAP','image','jpeg',0,'9dypbqn94tfy1a9x64aiyfpu2670zfw'),(151,'Ellora7.JPG','20031216150312!Ellora7.JPG',95300,600,800,8,'Ellora',16685,'KRS','20031216135502','0','BITMAP','image','jpeg',0,'dl36nohf42dzcdj8pqoxl2dafz5yptx'),(152,'Ellora5.JPG','20031216150440!Ellora5.JPG',48575,600,450,8,'Ellora',16685,'KRS','20031216135349','0','BITMAP','image','jpeg',0,'9jbha2sin1xwkdbb3dkqjy7ty895wbk'),(153,'Robotwar.png','20031218192217!Robotwar.png',8829,571,391,8,'Reverted to earlier revision',18084,'Tempshill','20031112003826','0','BITMAP','image','png',0,'9rqz6vl4bqzsbdrv0lo1tdmygsvucw0'),(154,'VietnameseProvincesMap.png','20031220013706!VietnameseProvincesMap.png',25832,428,713,8,'A map showing the borders and names of the Vietnamese provinces (including the changes approved in Nov 2003)',25556,'Vardion','20031219004524','0','BITMAP','image','png',0,'tiojhq2g8bsfq8qk97ifanb5qhl20gb'),(155,'Ellora5.JPG','20031220030230!Ellora5.JPG',38442,533,400,8,'Ellora5',16685,'KRS','20031216150440','0','BITMAP','image','jpeg',0,'cfisiu3dqpn00bw6nhd4c97kkvtz9x7'),(156,'Ellora7.JPG','20031220030256!Ellora7.JPG',26387,300,400,8,'Ellora7',16685,'KRS','20031216150312','0','BITMAP','image','jpeg',0,'ei3do3ezzie7t3r1zvtlvedy8brv00o'),(157,'Hampi5.JPG','20031220030506!Hampi5.JPG',42883,533,400,8,'Hampi5',16685,'KRS','20031216151320','0','BITMAP','image','jpeg',0,'9j3o2kvu62pufbu3znrrt8heqp45en3'),(158,'Pattadakal2.JPG','20031220030726!Pattadakal2.JPG',36007,533,400,8,'Pattadakal2',16685,'KRS','20031216152636','0','BITMAP','image','jpeg',0,'0mr3rm8r79ce6yfnezbih1oy7pq8uqa'),(159,'Somnathpur2.JPG','20031220030820!Somnathpur2.JPG',30643,533,400,8,'Somnathpur2',16685,'KRS','20031216153254','0','BITMAP','image','jpeg',0,'hx7l64d7ci17dquh65mqqaja8w5vulj'),(160,'Itep.png','20031220074558!Itep.png',3719,255,255,8,'How to get to ITEP',34229,'Ilya (usurped)','20031220074221','0','BITMAP','image','png',0,'kls7p6tvq12cnxcht6eqg5i58xvhzcb'),(161,'Chu-snowman.jpg','20031227151215!Chu_snowman.jpg',47376,382,566,8,'Snowman built 2002, Cambridge',35639,'Dmn','20031227150923','0','BITMAP','image','jpeg',0,'dhivzb6dq7k8mlehkgpyfqvmajdnoa9'),(162,'Cumberland-MD-760x350.jpg','20031230073301!Cumberland_MD_760x350.jpg',146055,757,341,8,'Cumberland, MD map from Census Tiger Server',30225,'Rfc1394','20031230063213','0','BITMAP','image','jpeg',0,'7glxpo5aqjuvkn41kfmcczod7k9rib4'),(163,'EnthanasiePropaganda.jpg','20040106021358!EnthanasiePropaganda.jpg',23224,431,550,8,'Nazi Euthanasia Propaganda Poster',27792,'Xiaopo','20040106020813','0','BITMAP','image','jpeg',0,'bu3zjss67cpe7g7zsvh1o6mve5y2ci1'),(164,'Marsh-fly01.jpg','20040106015015!Marsh_fly01.jpg',41809,250,262,8,'Photograph of a Marsh fly',16734,'Marshman','20040106013813','a:25:{s:4:\"Make\";s:5:\"NIKON\";s:5:\"Model\";s:4:\"E950\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:01:05 15:37:38\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/1250\";s:7:\"FNumber\";s:5:\"66/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:80;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2003:05:31 13:41:33\";s:17:\"DateTimeDigitized\";s:19:\"2003:05:31 13:41:33\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"26/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:6:\"190/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'44g75rgd00vefzyssumwirlxux2gppf'),(165,'Nauvoo,-Illinois-daguerreotype-(1846).jpg','20040106171902!Nauvoo,_Illinois_daguerreotype_(1846).jpg',25539,250,300,8,'Daguerreotype of Nauvoo, Illinois in 1846 (probably taken by Lucien Foster)',29394,'COGDEN','20040106164926','0','BITMAP','image','jpeg',0,'m5e4scw9iau17lxc1mzqvmrirzyvola'),(166,'HMS-King-George-V-with-USS-Missouri-in-background-1945.jpg','20040106200646!HMS_King_George_V_with_USS_Missouri_in_background_1945.jpg',74866,740,610,8,'',35090,'SoLando','20040106195147','0','BITMAP','image','jpeg',0,'h75bhdg276ekfn16owrehfyrlbnfl2v'),(167,'HMS-King-George-V-with-USS-Missouri-in-background-1945.jpg','20040106200841!HMS_King_George_V_with_USS_Missouri_in_background_1945.jpg',9802,200,158,8,'',35090,'SoLando','20040106200652','0','BITMAP','image','jpeg',0,'gqmhy70zk3hrkf8gbp7j92xz777rf9o'),(168,'HMS-King-George-V-with-USS-Missouri-in-background-1945.jpg','20040106200958!HMS_King_George_V_with_USS_Missouri_in_background_1945.jpg',9802,200,158,8,'',35090,'SoLando','20040106200848','0','BITMAP','image','jpeg',0,'gqmhy70zk3hrkf8gbp7j92xz777rf9o'),(169,'HMS-King-George-V-with-USS-Missouri-in-background-1945.jpg','20040106201015!HMS_King_George_V_with_USS_Missouri_in_background_1945.jpg',9802,200,158,8,'Reverted to earlier revision',35090,'SoLando','20040106201001','0','BITMAP','image','jpeg',0,'gqmhy70zk3hrkf8gbp7j92xz777rf9o'),(170,'HMS-King-George-V-with-USS-Missouri-in-background-1945.jpg','20040106201326!HMS_King_George_V_with_USS_Missouri_in_background_1945.jpg',74866,740,610,8,'Reverted to earlier revision',35090,'SoLando','20040106201016','0','BITMAP','image','jpeg',0,'h75bhdg276ekfn16owrehfyrlbnfl2v'),(171,'Gettysburg-Map.png','20040106210627!Gettysburg_Map.png',79169,486,671,8,'Map of Gettysburg and Vicinity',36708,'Hlj','20040106162006','0','BITMAP','image','png',0,'mxooqsvepddqzf0trcwyednnhhh0lt4'),(172,'Husky.jpg','20040106212105!Husky.jpg',22574,406,336,8,'',0,'(Automated conversion)','20020720114937','0','BITMAP','image','jpeg',0,'q127ny2k8ltrlqkkl0psqeclstkdxc5'),(173,'Husky.jpg','20040107120619!Husky.jpg',22468,225,170,8,'Under GNU FDL',672,'XJamRastafire','20040106212105','a:24:{s:16:\"ImageDescription\";s:8:\"3MegaCam\";s:4:\"Make\";s:8:\"3MegaCam\";s:5:\"Model\";s:8:\"3MegaCam\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:01:06 22:16:09\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:4:\"2/36\";s:7:\"FNumber\";s:5:\"20/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"1/11\";s:16:\"MaxApertureValue\";s:3:\"3/2\";s:12:\"MeteringMode\";i:2;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"82/11\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'pb7x78nj0ijkig9m6q5cpflmc253boi'),(174,'FranklinMountains6k.jpg','20040109041903!FranklinMountains6k.jpg',5121,400,300,8,'Franklin mountains, ( El Paso TX,) as seen at 30 mi distance, from western side',37284,'Ancheta Wis','20040109040521','0','BITMAP','image','jpeg',0,'lzstsmis51l6f546bt0z3wal086xwte'),(175,'FranklinMountains6k.jpg','20040109042457!FranklinMountains6k.jpg',48258,156,103,0,'Franklin Mountains of El Paso, Texas, 50 Km distant',37284,'Ancheta Wis','20040109041904','0','BITMAP','image','x-bmp',0,'ql1yt9qg0mfj58yhywixe4m9vjeej31'),(176,'Dime-con-quien-andas.ogg','20040109192249!Dime_con_quien_andas.ogg',41116,0,0,0,'Popular Spanish proverb (recorded by me)',21931,'Pilaf','20040109191637','a:4:{s:7:\"version\";i:2;s:7:\"streams\";a:1:{i:14234;a:8:{s:6:\"serial\";i:14234;s:5:\"group\";i:0;s:4:\"type\";s:6:\"Vorbis\";s:6:\"vendor\";s:29:\"Xiph.Org libVorbis I 20020717\";s:6:\"length\";d:2.50022675736961463854868270573206245899200439453125;s:4:\"size\";i:41116;s:6:\"header\";a:9:{s:14:\"vorbis_version\";i:0;s:14:\"audio_channels\";i:2;s:17:\"audio_sample_rate\";i:22050;s:15:\"bitrate_maximum\";i:4294967295;s:15:\"bitrate_nominal\";i:128000;s:15:\"bitrate_minimum\";i:4294967295;s:11:\"blocksize_0\";i:9;s:11:\"blocksize_1\";i:10;s:12:\"framing_flag\";i:0;}s:8:\"comments\";a:10:{s:5:\"ALBUM\";s:0:\"\";s:6:\"ARTIST\";s:0:\"\";s:7:\"COMMENT\";s:0:\"\";s:5:\"GENRE\";s:0:\"\";s:5:\"TITLE\";s:0:\"\";s:5:\"TRACK\";s:0:\"\";s:4:\"DATE\";s:0:\"\";s:4:\"YEAR\";s:0:\"\";s:11:\"TRACKNUMBER\";s:0:\"\";s:7:\"CONTACT\";s:55:\"Created with: FreeRIP 2.53 - http://www.mgshareware.com\";}}}s:6:\"length\";d:2.50022675736961463854868270573206245899200439453125;s:6:\"offset\";N;}','AUDIO','application','ogg',0,'k67srnu9nre61j36w3wubc2coqhayab'),(177,'Dime-con-quien-andas.ogg','20040109193135!Dime_con_quien_andas.ogg',41116,0,0,0,'Popular Spanish proverb (recorded by me)',21931,'Pilaf','20040109192250','a:4:{s:7:\"version\";i:2;s:7:\"streams\";a:1:{i:14234;a:8:{s:6:\"serial\";i:14234;s:5:\"group\";i:0;s:4:\"type\";s:6:\"Vorbis\";s:6:\"vendor\";s:29:\"Xiph.Org libVorbis I 20020717\";s:6:\"length\";d:2.50022675736961463854868270573206245899200439453125;s:4:\"size\";i:41116;s:6:\"header\";a:9:{s:14:\"vorbis_version\";i:0;s:14:\"audio_channels\";i:2;s:17:\"audio_sample_rate\";i:22050;s:15:\"bitrate_maximum\";i:4294967295;s:15:\"bitrate_nominal\";i:128000;s:15:\"bitrate_minimum\";i:4294967295;s:11:\"blocksize_0\";i:9;s:11:\"blocksize_1\";i:10;s:12:\"framing_flag\";i:0;}s:8:\"comments\";a:10:{s:5:\"ALBUM\";s:0:\"\";s:6:\"ARTIST\";s:0:\"\";s:7:\"COMMENT\";s:0:\"\";s:5:\"GENRE\";s:0:\"\";s:5:\"TITLE\";s:0:\"\";s:5:\"TRACK\";s:0:\"\";s:4:\"DATE\";s:0:\"\";s:4:\"YEAR\";s:0:\"\";s:11:\"TRACKNUMBER\";s:0:\"\";s:7:\"CONTACT\";s:55:\"Created with: FreeRIP 2.53 - http://www.mgshareware.com\";}}}s:6:\"length\";d:2.50022675736961463854868270573206245899200439453125;s:6:\"offset\";N;}','AUDIO','application','ogg',0,'k67srnu9nre61j36w3wubc2coqhayab'),(178,'Ilya-more-blue.png','20040112155908!Ilya_more_blue.png',125,20,10,8,'',34229,'Ilya (usurped)','20040112155549','0','BITMAP','image','png',0,'oxs4v7h6gvdux2rh6c0r4m85pqp0vhv'),(179,'Ilya-more-blue.png','20040112161038!Ilya_more_blue.png',124,20,10,8,'',34229,'Ilya (usurped)','20040112155908','0','BITMAP','image','png',0,'pzfzb7idls1w0q3bepuw2zy7ip5uvde'),(180,'Ilya-more-blue.png','20040112161219!Ilya_more_blue.png',193,20,12,8,'',34229,'Ilya (usurped)','20040112161038','0','BITMAP','image','png',0,'m7cfwyji54grr5b5bxlaq6efhpgff3a'),(181,'Ilya-more-blue.png','20040112161521!Ilya_more_blue.png',193,20,12,8,'',34229,'Ilya (usurped)','20040112161219','0','BITMAP','image','png',0,'nu4tzbr7ycdkomciilixgjtgy232qhh'),(182,'Sonny-Carter.jpg','20040114222829!Sonny_Carter.jpg',44883,640,480,8,'',25568,'Ke4roh','20040114221220','0','BITMAP','image','jpeg',0,'51qw6mggsf9i8fi3gf10tc37wwa9lzs'),(183,'Encryption.png','20040116014253!Encryption.png',7233,195,168,8,'Basic diagram of block cipher encryption - I drew it, and  release it into the public domain',38470,'Lunkwill','20040116014034','0','BITMAP','image','png',0,'0bc0wjjrbaf72zzz87mk6v7wkykqysn'),(184,'HadleyCross-sec.jpg','20040116215923!HadleyCross-sec.jpg',33695,0,0,0,'Hadley cell cross-section',36346,'Dwindrim','20040116215448','','BITMAP','application','photoshop',0,'mv0b1b6yfc52hhvd900jizmna82z28j'),(185,'HadleyCross-sec.jpg','20040116220409!HadleyCross-sec.jpg',33695,0,0,0,'Hadley cell cross-section',36346,'Dwindrim','20040116215923','','BITMAP','application','photoshop',0,'mv0b1b6yfc52hhvd900jizmna82z28j'),(186,'HadleyCross-sec.jpg','20040116221151!HadleyCross-sec.jpg',30423,0,0,0,'Hadley cell cross-section',36346,'Dwindrim','20040116220409','','BITMAP','application','photoshop',0,'fvng2jxms2fn5nd61hsubpkz0wadg24'),(187,'Kauai-from-space.jpg','20040117015533!Kauai_from_space.jpg',24645,450,450,8,'From [http:/ / earth.jsc.nasa.gov], in the [[public domain]]',4,'Magnus Manske','20030101202727','0','BITMAP','image','jpeg',0,'k0qskw8wym4kvyf7fsnvarlmyn18wng'),(188,'CentipedevsSpider-reduced.jpg','20040117041302!CentipedevsSpider_reduced.jpg',36630,400,234,8,'Predation example',16734,'Marshman','20040106035644','a:25:{s:4:\"Make\";s:5:\"NIKON\";s:5:\"Model\";s:4:\"E950\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:01:05 17:39:17\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/600\";s:7:\"FNumber\";s:5:\"39/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:80;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:01:03 09:27:15\";s:17:\"DateTimeDigitized\";s:19:\"2004:01:03 09:27:15\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"26/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:1;s:11:\"FocalLength\";s:6:\"190/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'48lucmi3f7pz4bmwjx2wj0p28n76y15'),(189,'RLC-serial-1.PNG','20040117095520!RLC-serial-1.PNG',1996,238,103,8,'',36344,'Rubber hound','20040117095413','0','BITMAP','image','png',0,'ss1mjys67slrkxw58k2rzz686rghw2n'),(190,'British-9th-(Scottish)-Division-Insignia.png','20040119002419!British_9th_(Scottish)_Division_Insignia.png',4079,100,100,8,'divisional patch',646,'Gsl','20040116065046','0','BITMAP','image','png',0,'3re04drms5lyvcu84232thr3p3aokd5'),(191,'British-9th-(Scottish)-Division-Insignia.png','20040119002854!British_9th_(Scottish)_Division_Insignia.png',5131,100,100,8,'improved',646,'Gsl','20040119002419','0','BITMAP','image','png',0,'b4zit2fcfzllc5gr2pw4jp9eojkpxwl'),(192,'Smalfut.jpg','20040119031139!Smalfut.jpg',16811,247,331,8,'bigfoot',37222,'Lizard King','20040118054133','0','BITMAP','image','jpeg',0,'maq8kr9i3af50gpvkli2bdai7l8hqfh'),(193,'British-3rd-Infantry-Division1.png','20040120051707!British_3rd_Infantry_Division1.png',1422,100,99,8,'ww1 division patch',646,'Gsl','20040120045338','0','BITMAP','image','png',0,'1ygg1yt2awn2306w0yyg3b5c47m0cma'),(194,'LeicsLeicester.png','20040120183109!LeicsLeicester.png',0,0,0,0,'Map showing [[Leicester]] within [[Tyne and Wear]]',17287,'Morwen','20040120183048','0','BITMAP','image','png',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(195,'Cbc-decryption.jpg','20040120204439!Cbc_decryption.jpg',15981,600,222,8,'Standard diagram for CBC decryption.  Public domain, created by me.',38470,'Lunkwill','20040116022400','0','BITMAP','image','jpeg',0,'1c9f8bbmbtsv86dbipto8e64mwv1hc1'),(196,'WYorks-Kirklees.png','20040121073258!WYorks-Kirklees.png',0,0,0,0,'Map of [[Kirklees]] within [[West Yorkshire]]',17287,'Morwen','20040121072909','','TEXT','text','plain',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(197,'EnglandCleveland.png','20040122192436!EnglandCleveland.png',24948,200,247,8,'Former adminstrative county of England',17287,'Morwen','20040122192402','0','BITMAP','image','png',0,'4ygkoo7plivclb2c4v8vp2gqznpazbs'),(198,'ScotlandGrampians1974.png','20040123073718!ScotlandGrampians1974.png',0,0,0,0,'one of the former [[subdivisions of Scotland]]',17287,'Morwen','20040123073619','0','BITMAP','image','png',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(199,'EnglandClevelandNumbered.png','20040123211515!EnglandClevelandNumbered.png',10385,200,105,8,'Numbered map of districts of former county of [[Cleveland, England]]',17287,'Morwen','20040123205728','0','BITMAP','image','png',0,'4tyv1f55hdoi4x8yprly421wancy1tc'),(200,'EnglandCleveland.png','20040123211941!EnglandCleveland.png',24948,200,247,8,'Former adminstrative county of England',17287,'Morwen','20040122192436','0','BITMAP','image','png',0,'4ygkoo7plivclb2c4v8vp2gqznpazbs'),(201,'EnglandAvon.png','20040123212006!EnglandAvon.png',24989,200,247,8,'Former adminstrative county of England',17287,'Morwen','20040122192340','0','BITMAP','image','png',0,'f78k0g4ubglnpw8nnr5ernk6x801rj7'),(202,'EnglandHumberside.png','20040123212701!EnglandHumberside.png',24845,200,247,8,'Former adminstrative county of England',17287,'Morwen','20040122192352','0','BITMAP','image','png',0,'iax1y5vxchevbyxhmwiioqm9gv2teb8'),(203,'Wanglogo.png','20040124024042!Wanglogo.png',9296,200,80,8,'Wang logo circa 1970',21036,'Dpbsmith','20040124024015','0','BITMAP','image','png',0,'15185u9gvlipav73xgkgpwpvd1o3pr0'),(204,'UKEngland.png','20040124133754!UKEngland.png',10463,170,257,8,'map of [[England]] within the [[United Kingdom]]',17287,'Morwen','20040117125349','0','BITMAP','image','png',0,'nuj6gwnphj89q53q1o80294j39fk23x'),(205,'LondonSouth.png','20040124154642!LondonSouth.png',18143,201,166,8,'south london - see [[Image:LondonCity.png]] for copyright',17287,'Morwen','20031126205314','0','BITMAP','image','png',0,'0yk9vgwce8ej1ny0y180tao21c9ziv9'),(206,'LondonSouth.png','20040124154753!LondonSouth.png',20701,200,155,8,'updated map',17287,'Morwen','20040124154642','0','BITMAP','image','png',0,'ljj0f0f4xe7ogcd5rohn00wbl8vn1me'),(207,'LondonWestEnd.png','20040124154802!LondonWestEnd.png',17926,201,166,8,'fix map not to show west end including kensington, hammersmith',17287,'Morwen','20031126074819','0','BITMAP','image','png',0,'oto7z1qlanxi3ineihrmfs0cl21i419'),(208,'LondonEastEnd.png','20040124154812!LondonEastEnd.png',17973,201,166,8,'outline map showing the east end of london, see [[Image:LondonCity.png]] for copyright',17287,'Morwen','20031126073602','0','BITMAP','image','png',0,'ka9hn1wbxf1j4fo1p8168qwji6tr6in'),(209,'LondonAssemblyMakeup.png','20040124155852!LondonAssemblyMakeup.png',10853,201,166,8,'Maps of current standing of London Assembly constituencies - see [[Image:LondonCity.png]] for copyright',17287,'Morwen','20031126203345','0','BITMAP','image','png',0,'5m8o4gemuiur7rlm2mrbxe343hfs8mm'),(210,'LeicestershireNumbered.png','20040124161904!LeicestershireNumbered.png',0,0,0,0,'numbered map of districts of [[Leicestershire]]',17287,'Morwen','20040124161357','0','BITMAP','image','png',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(211,'LeicestershireNumbered.png','20040124162524!LeicestershireNumbered.png',16589,200,200,8,'numbered map of districts of [[Leicestershire]]',17287,'Morwen','20040124161904','0','BITMAP','image','png',0,'t9rmf0v53soit54o7oaacjqoiycnpuy'),(212,'Londonstreetfiddlerc.1880.jpg','20040125183718!Londonstreetfiddlerc.1880.jpg',54472,0,0,0,'public domain photo',8351,'TUF-KAT','20040123040159','',NULL,'unknown','unknown',0,''),(213,'Londonstreetmusicianc.1880.jpg','20040125183802!Londonstreetmusicianc.1880.jpg',43945,0,0,0,'public domain photo',8351,'TUF-KAT','20040123040553','',NULL,'unknown','unknown',0,''),(214,'Londonstreetmusiciansc.1880.jpg','20040125183835!Londonstreetmusiciansc.1880.jpg',70854,0,0,0,'public domain photo',8351,'TUF-KAT','20040123040837','',NULL,'unknown','unknown',0,''),(215,'Kiwiperformersc.1906.jpg','20040125184748!Kiwiperformersc.1906.jpg',102156,0,0,0,'public domain photo',8351,'TUF-KAT','20040123041226','',NULL,'unknown','unknown',0,''),(216,'Zulumusiciansc.1900.jpg','20040125184819!Zulumusiciansc.1900.jpg',68962,0,0,0,'Zulu musicians, 1900, public domain',8351,'TUF-KAT','20040123041758','',NULL,'unknown','unknown',0,''),(217,'EssexNumbered.png','20040126194940!EssexNumbered.png',14270,0,0,0,'[[Essex]] districts',17287,'Morwen','20040126194317','',NULL,'unknown','unknown',0,''),(218,'Thalidomide-structure.png','20040127023522!Thalidomide_structure.png',2405,0,0,0,'structural drawing of thalidomide',33032,'Catbar','20040127022219','',NULL,'unknown','unknown',0,''),(219,'Wpdms-terra-newarkbay.jpg','20040127073838!Wpdms_terra_newarkbay.jpg',34625,0,0,0,'TERRA Newark Bay',37527,'Decumanus','20040127073450','',NULL,'unknown','unknown',0,''),(220,'Hakone-fuji-jpatokal.jpg','20040128144013!Hakone-fuji-jpatokal.jpg',28716,0,0,0,'Mt. Fuji from Hakone, jpatokal',8155,'Jpatokal','20040128143827','',NULL,'unknown','unknown',0,''),(221,'Wiesbaden-in-Germany.png','20040129042601!Wiesbaden_in_Germany.png',5324,188,235,8,'',8289,'Snoyes','20040129042556','0','BITMAP','image','png',0,'9c4ivkdfynr2jq7xieumx2k727dcgxi'),(222,'Wiesbaden-in-Germany.png','20040129042606!Wiesbaden_in_Germany.png',5324,188,235,8,'',8289,'Snoyes','20040129042602','0','BITMAP','image','png',0,'9c4ivkdfynr2jq7xieumx2k727dcgxi'),(223,'DorsetNumbered.png','20040129073131!DorsetNumbered.png',12541,200,139,8,'numbered map of devon',17287,'Morwen','20040129072911','0','BITMAP','image','png',0,'ddzihn3by866hq1tafvey7xx6b8j5ei'),(224,'Leverkusen-in-Germany.png','20040129080237!Leverkusen_in_Germany.png',5311,188,235,8,'',8289,'Snoyes','20040129042220','0','BITMAP','image','png',0,'drj8ccwd4ne9ivatyhdms3dbejx3kmc'),(225,'Leverkusen-in-Germany.png','20040129080242!Leverkusen_in_Germany.png',5311,188,235,8,'',8289,'Snoyes','20040129080237','0','BITMAP','image','png',0,'drj8ccwd4ne9ivatyhdms3dbejx3kmc'),(226,'Ludwigshafen-am-Rhein-in-Germany.png','20040129080247!Ludwigshafen_am_Rhein_in_Germany.png',5327,188,235,8,'',8289,'Snoyes','20040129042226','0','BITMAP','image','png',0,'o6c9rlcb0yqk43k5clpoop68g51wuad'),(227,'Lübeck-in-Germany.png','20040129080302!Lübeck_in_Germany.png',5349,188,235,8,'',8289,'Snoyes','20040129042231','0','BITMAP','image','png',0,'f7ivzyogep5pl7vgscw00vvttocabhq'),(228,'Lübeck-in-Germany.png','20040129080311!Lübeck_in_Germany.png',5349,188,235,8,'',8289,'Snoyes','20040129080302','0','BITMAP','image','png',0,'f7ivzyogep5pl7vgscw00vvttocabhq'),(229,'Cradle-of-Humanity-States.png','20040129164734!Cradle_of_Humanity_States.png',307806,2607,1903,8,'Cradle of Humanity States/ Territories',40723,'Sentinel','20040129134359','0','BITMAP','image','png',0,'0yln0168cvfdkg7hgdg9kg00tp7wym3'),(230,'Eyeball-view-3.jpg','20040130040632!Eyeball_view_3.jpg',25537,503,405,8,'',38163,'Pat Kelso','20040130040203','0','BITMAP','image','jpeg',0,'qbde7qswkmwe3b6hhtlfphfcu3jnap6'),(231,'Cradle-of-Humanity-States.png','20040130174303!Cradle_of_Humanity_States.png',24611,350,255,8,'Re-upload',40723,'Sentinel','20040129164745','0','BITMAP','image','png',0,'d6zvsvotankqsj888l7x68cssue9ulo'),(232,'Cradle-of-Humanity-States.png','20040130174529!Cradle_of_Humanity_States.png',66239,800,600,8,'Re-upload',40723,'Sentinel','20040130174310','0','BITMAP','image','png',0,'odiw3mjtldy24rxbp2y9yitwl7e057j'),(233,'Cradle-of-Humanity-States.png','20040130174945!Cradle_of_Humanity_States.png',59850,750,547,8,'Re-upload',40723,'Sentinel','20040130174533','0','BITMAP','image','png',0,'fj8e02peecs67halggyor5lh7i5fjky'),(234,'Cradle-of-Humanity-States.png','20040130175247!Cradle_of_Humanity_States.png',229462,2000,1459,8,'',40723,'Sentinel','20040130174949','0','BITMAP','image','png',0,'92lu25qxed5g928e1c0ikw4oqh236gp'),(235,'Cradle-of-Humanity-States.png','20040130182116!Cradle_of_Humanity_States.png',166184,1500,1094,8,'',40723,'Sentinel','20040130175301','0','BITMAP','image','png',0,'6ay4ven6dpoirs0icv17yn3dkmpqt4w'),(236,'Cradle-of-Humanity-States.png','20040130193742!Cradle_of_Humanity_States.png',90639,1000,729,8,'',40723,'Sentinel','20040130182131','0','BITMAP','image','png',0,'tjwheaawao6alz8jz7fzuw51nlhtrom'),(237,'Unionbush.jpg','20040130220406!Unionbush.jpg',30872,400,277,8,'Bush\'s 2002 state of the union speech, white house handout photo by Eric Draper ',9718,'J.J.','20040130214614','0','BITMAP','image','jpeg',0,'rpxyx5cl02fwp3t3wuxyicmf87ngcpd'),(238,'Wpdms-oregon-territory-1848.jpg','20040131013548!Wpdms_oregon_territory_1848.jpg',9571,275,208,8,'Oregon Territory 1848',37527,'Decumanus','20040131012826','0','BITMAP','image','jpeg',0,'i0v70fi758r14y8qajczhwp5dtt4iv7'),(239,'Eyeball-view-3.jpg','20040131042136!Eyeball_view_3.jpg',25593,503,405,8,'',38163,'Pat Kelso','20040130040632','0','BITMAP','image','jpeg',0,'3wbfbwujlfzs4gebqpp2p6so8l0fe0f'),(240,'MarkDayton.jpg','20040131095123!MarkDayton.jpg',4754,100,115,8,'Public Domain Image of Senator Mark Dayton from http:/ / jcp.senate.gov/ members.html',12070,'Mulad','20040131070059','0','BITMAP','image','jpeg',0,'e00l6an89a3u4texstwb3xovzsy36lz'),(241,'RioGrandeRiftNM.jpg','20040131153335!RioGrandeRiftNM.jpg',8841,500,425,8,'STS100-704-151 Astronaut image showing the Rio Grande rift',37284,'Ancheta Wis','20040131153049','0','BITMAP','image','jpeg',0,'i2d81a553ormunipsn5gngmrnbhtiyw'),(242,'MerseysideStHelens.png','20040131162240!MerseysideStHelens.png',14729,200,211,8,'Map showing [[St Helens]] within [[Merseyside]].',17287,'Morwen','20040119225943','0','BITMAP','image','png',0,'ns59n1vquhy04qq8qd3jdunlb2suxq0'),(243,'RioGrandeRiftNM.jpg','20040131233904!RioGrandeRiftNM.jpg',5436,116,171,8,'Rio Grande  rift. Astronaut image STS100-171-151',37284,'Ancheta Wis','20040131153335','0','BITMAP','image','jpeg',0,'hbnvx8vx3oehrj90wxyx9ws92azdbbu'),(244,'Thalidomide-structure.png','20040201052812!Thalidomide_structure.png',1138,237,203,1,'reload lost picture',33032,'Catbar','20040201052803','0','BITMAP','image','png',0,'kjwo1jajxqwdvc7qtzv02ehzgxxbyc1'),(245,'Wpdms-oregon-territory-1848.jpg','20040201060856!Wpdms_oregon_territory_1848.jpg',8842,275,208,8,'Oregon Territory 1848',37527,'Decumanus','20040131013548','0','BITMAP','image','jpeg',0,'jwnapmpb9994baoiux1oaxrdd77ijg0'),(246,'Wpdms-oregon-territory-1859-detail.jpg','20040201061017!Wpdms_oregon_territory_1859_detail.jpg',8210,275,208,8,'State of Oregon, Washington Territory 1859 ',37527,'Decumanus','20040131020420','0','BITMAP','image','jpeg',0,'5ikex4y3d1j1b7dj4xn7g6c8dlbklfg'),(247,'Wpdms-washington-idaho-territories-1863.png','20040201081042!Wpdms_washington_idaho_territories_1863.png',25278,270,200,8,'Washington and Idaho Territories 1863',37527,'Decumanus','20040201071937','0','BITMAP','image','png',0,'fprfe2vvinxsv5zd4wapsut7tz1q4an'),(248,'Wpdms-idaho-territory-1864-legend.png','20040201212516!Wpdms_idaho_territory_1864_legend.png',41760,232,303,8,'Idaho Territory, Montana Territory 1864 with legend',37527,'Decumanus','20040201212237','0','BITMAP','image','png',0,'2yzcl0ansdek2qwvfoozjh6r9i8qf6n'),(249,'Cradle-of-Humanity-States.png','20040201212703!Cradle_of_Humanity_States.png',64942,800,583,8,'',40723,'Sentinel','20040130193757','0','BITMAP','image','png',0,'su9x0usrhcpc9bjma3voe4ga1hoj4ce'),(250,'Cradle-of-Humanity-States.png','20040201212747!Cradle_of_Humanity_States.png',58882,796,536,8,'removed text from picture so it can be NPOVed',52,'Eloquence','20040201212703','0','BITMAP','image','png',0,'s4qtt7twzaa5sa1nw1e9fcd5mp388sq'),(251,'User-dino.jpg','20040202034304!User_dino.jpg',32615,206,457,8,'photo of user:dino, taken in 1997 in Lavenham, England. I own the image, so no permission is necessary',13774,'Dino','20040202033958','0','BITMAP','image','jpeg',0,'og4pam7a7pg24h4l4h68qrk9oabq6ui'),(252,'British-24th-Division-Insignia.png','20040203064023!British_24th_Division_Insignia.png',1607,100,100,8,'division patch',646,'Gsl','20040203064001','0','BITMAP','image','png',0,'jy4t7cpyiw6q01jriep4cnoxxq24lfy'),(253,'Tokyo2-Landsat.jpg','20040204004154!Tokyo2_Landsat.jpg',129823,640,500,8,'Further out Landat of Tokyo ',15708,'WhisperToMe','20040204003645','0','BITMAP','image','jpeg',0,'ssfajv0i2suy2ifu9x38edvwqrx87yi'),(254,'Irontriangle.PNG','20040204052946!Irontriangle.PNG',12005,451,362,8,'Diagram of an iron triangle in government',41443,'Ubernetizen','20040204045046','0','BITMAP','image','png',0,'l2vl5jc6aul12joyevcvnyt3zfrh3ce'),(255,'Wpdms-terra-killvankull.jpg','20040205191515!Wpdms_terra_killvankull.jpg',22311,295,247,8,'TERRA: Kill Van Kull',37527,'Decumanus','20040205074150','0','BITMAP','image','jpeg',0,'dn3774p0kzlfxjriu3cbdlr6g88mjes'),(256,'Wpdms-terra-northriver.jpg','20040205193401!Wpdms_terra_northriver.jpg',34738,300,398,8,'TERRA: North River',37527,'Decumanus','20040205191709','0','BITMAP','image','jpeg',0,'9kethbz1gzw8boshafdjnugfkvztw65'),(257,'Nightfall-cover.jpg','20040207030243!Nightfall_cover.jpg',77415,400,679,8,'Scan I made of the cover of Nightfall (Isaac Asimov) - fair use claimed ',21013,'Raul654','20040207030057','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"150/1\";s:11:\"YResolution\";s:5:\"150/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:02:06 21:35:16\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'by3hc94qgqwj4kttv3fyj2se22wkhzm'),(258,'Teleprompter.PNG','20040207223218!Teleprompter.PNG',88144,707,412,8,'rudimentary diagram of how a teleprompter works',34433,'Dhodges','20040207222524','0','BITMAP','image','png',0,'9a7tkqh7elqn9wum52wvvuee18tirpy'),(259,'M.U.L.E..png','20040208142619!M.U.L.E..png',216,24,16,2,'Sprite from the M.U.L.E. game (1983)',28478,'Psychonaut','20040208141548','0','BITMAP','image','png',0,'lld27wyaqzuw2wyg9j51m5c0msb1alr'),(260,'WhiteRabbit.ogg','20040210032612!WhiteRabbit.ogg',1102032,0,0,0,'White Rabbit - Jefferson Airplane (short clip, fair use)',3628,'Hephaestos','20040209205404','a:4:{s:7:\"version\";i:2;s:7:\"streams\";a:1:{i:16838;a:8:{s:6:\"serial\";i:16838;s:5:\"group\";i:0;s:4:\"type\";s:6:\"Vorbis\";s:6:\"vendor\";s:32:\"Xiphophorus libVorbis I 20011231\";s:6:\"length\";d:26.3778684807256240674178116023540496826171875;s:4:\"size\";i:1102032;s:6:\"header\";a:9:{s:14:\"vorbis_version\";i:0;s:14:\"audio_channels\";i:2;s:17:\"audio_sample_rate\";i:44100;s:15:\"bitrate_maximum\";i:4294967295;s:15:\"bitrate_nominal\";i:128031;s:15:\"bitrate_minimum\";i:4294967295;s:11:\"blocksize_0\";i:8;s:11:\"blocksize_1\";i:11;s:12:\"framing_flag\";i:0;}s:8:\"comments\";a:1:{s:0:\"\";s:0:\"\";}}}s:6:\"length\";d:26.3778684807256240674178116023540496826171875;s:6:\"offset\";N;}','AUDIO','application','ogg',0,'70f3btf86akm5hfb7ue780hdvqx674u'),(261,'Lechuguilla.jpg','20040211073047!Lechuguilla.jpg',85533,400,300,8,'Lechuguilla',38705,'Bob Palin','20040211072912','a:32:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:19:\"Canon PowerShot S40\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:01:29 12:04:12\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:6:\"1/1000\";s:7:\"FNumber\";s:5:\"35/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:01:29 12:04:12\";s:17:\"DateTimeDigitized\";s:19:\"2004:01:29 12:04:12\";s:22:\"CompressedBitsPerPixel\";s:3:\"5/1\";s:17:\"ShutterSpeedValue\";s:6:\"319/32\";s:13:\"ApertureValue\";s:6:\"116/32\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:12:\"194698/65536\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:6:\"276/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"2272000/280\";s:21:\"FocalPlaneYResolution\";s:11:\"1704000/210\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:9:\"2272/2272\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'1bofeotgr2094op2hwmd9ymb7b3ed8l'),(262,'Lechuguilla.jpg','20040211073558!Lechuguilla.jpg',85533,400,300,8,'Lecheguilla',38705,'Bob Palin','20040211073047','a:32:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:19:\"Canon PowerShot S40\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:01:29 12:04:12\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:6:\"1/1000\";s:7:\"FNumber\";s:5:\"35/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:01:29 12:04:12\";s:17:\"DateTimeDigitized\";s:19:\"2004:01:29 12:04:12\";s:22:\"CompressedBitsPerPixel\";s:3:\"5/1\";s:17:\"ShutterSpeedValue\";s:6:\"319/32\";s:13:\"ApertureValue\";s:6:\"116/32\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:12:\"194698/65536\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:6:\"276/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"2272000/280\";s:21:\"FocalPlaneYResolution\";s:11:\"1704000/210\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:9:\"2272/2272\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'1bofeotgr2094op2hwmd9ymb7b3ed8l'),(263,'Spitzer-Valentine.jpg','20040213013424!Spitzer_Valentine.jpg',41478,360,450,8,'NGC 7129 from the Spitzer Space Telescope.  Credit: NASA/ JPL-Caltech/ T. Megeath (Harvard-Smithsonian CfA).  Public domain image c/ o [[http:/ / sirtf.caltech.edu/ ]]',26861,'Zandperl','20040213010458','0','BITMAP','image','jpeg',0,'eclupdgz64nbaxnhxr0gtbnzugf0hoo'),(264,'NewZealandElectorates2002.png','20040213082235!NewZealandElectorates2002.png',19699,423,604,8,'Map of electorates in the New Zealand 2002 election (corrected version)',25556,'Vardion','20031121011219','0','BITMAP','image','png',0,'i18e97p6jidynp7u3vknx5eqwgj98xw'),(265,'NewZealandElectorates1999.png','20040213125833!NewZealandElectorates1999.png',19892,423,604,8,'New Zealand electorate results in 1999 (corrected again)',25556,'Vardion','20031126080350','0','BITMAP','image','png',0,'85twxglmeo1a9gj3c65tnjm0rs4vtpi'),(266,'Stnz-opchr-1942.png','20040213141644!Stnz_opchr_1942.png',102899,800,251,8,'indicative plan of St Nazaire docks 1942',8,'TwoOneTwo','20040212182114','0','BITMAP','image','png',0,'8i6xe11bxzowjl6tjbx94zrxrnxr0ya'),(267,'TOCP-structure.png','20040214043305!TOCP_structure.png',2926,302,277,8,'tri-o-cresyl phosphate chemical structure for \"jake\" article',33032,'Catbar','20040214011340','0','BITMAP','image','png',0,'ev3sc97ebk4ua0c81yeqshyebcja6m3'),(268,'Judas-Priest-Turbo.jpg','20040214070006!Judas_Priest_Turbo.jpg',11269,200,200,8,'Judas Priest - \"Turbo\" album cover',27822,'RedWolf','20040214065052','0','BITMAP','image','jpeg',0,'kb2dblpkv2jqg5twf43l8ooo5s70cls'),(269,'Husky.jpg','20040214161431!Husky.jpg',7861,225,170,8,'lightened a little',6561,'Sannse','20040107120620','0','BITMAP','image','jpeg',0,'787y7qr6ov35dm9mc348gut2dspvxal'),(270,'Stack.png','20040214191851!Stack.png',4146,256,256,8,'created by me with OpenFX',25873,'Noldoaran','20040214190336','0','BITMAP','image','png',0,'6m4qnbagcyzqopnc0t13qs9ite1be4d'),(271,'Gorevietnam.jpg','20040215011825!Gorevietnam.jpg',18395,93,148,8,'',35792,'AmericanCentury21','20040215011029','0','BITMAP','image','jpeg',0,'jk74by9ly3pj9jyyuo5i87t6owxm91n'),(272,'RonaldRadford-1.jpg','20040215123821!RonaldRadford_1.jpg',32292,320,353,8,'Ronald Radford,Flamenco guitarist(photo by me. Rleased to public domain)',43633,'Serak','20040212210919','a:7:{s:11:\"Orientation\";i:1;s:8:\"Software\";s:27:\"ACD Systems Digital Imaging\";s:8:\"DateTime\";s:19:\"2004:02:12 15:03:24\";s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:10:\"SubSecTime\";s:2:\"97\";s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'dik1qbxbwsq16bv5w23knpobb6k3wt1'),(273,'Hematite-sinus-meridiani-tes-hematit-br.jpg','20040215140307!Hematite_sinus_meridiani_tes_hematit_br.jpg',0,0,0,0,'',37647,'Sennheiser','20040215140144','0','BITMAP','image','jpeg',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(274,'Mandarynka.jpg','20040215151559!Mandarynka.jpg',60113,300,242,8,'Mandarin duck',36365,'Lysy','20040108004800','a:37:{s:16:\"ImageDescription\";s:31:\"MINOLTA DIGITAL CAMERA         \";s:4:\"Make\";s:17:\"Minolta Co., Ltd.\";s:5:\"Model\";s:9:\"DiMAGE Xt\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:9:\"Ver. 1.00\";s:8:\"DateTime\";s:19:\"2004:01:02 11:59:07\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/1800\";s:7:\"FNumber\";s:5:\"36/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:50;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:01:02 11:59:07\";s:17:\"DateTimeDigitized\";s:19:\"2004:01:02 11:59:07\";s:22:\"CompressedBitsPerPixel\";s:3:\"4/1\";s:15:\"BrightnessValue\";s:5:\"55/10\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"37/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:6:\"171/10\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:1;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:5:\"0/100\";s:21:\"FocalLengthIn35mmFilm\";i:111;s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:20:\"SubjectDistanceRange\";i:2;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'m9zxqkp8v602z630w8wpov8o17p08oj'),(275,'UKEngland.png','20040215184123!UKEngland.png',20462,200,246,8,'',17287,'Morwen','20040124133754','0','BITMAP','image','png',0,'41j4d3twnrrvoqjumroggw2rprz96g2'),(276,'Wpdms-nygis-tottenville.jpg','20040216024632!Wpdms_nygis_tottenville.jpg',48721,452,393,8,'NYGIS Tottenville',37527,'Decumanus','20040213192151','0','BITMAP','image','jpeg',0,'94sv8noo8pr7l9ch3rifxqiye66c917'),(277,'Wpdms-nygis-new-dorp.jpg','20040216024725!Wpdms_nygis_new_dorp.jpg',48727,452,393,8,'NYGIS New Dorp, Staten Island ',37527,'Decumanus','20040213191353','0','BITMAP','image','jpeg',0,'eokmmgrel94luxun0ats88lo2h41odw'),(278,'Register-renaming:tag-indexed-scheme.png','20040216053740!Register_renaming:tag_indexed_scheme.png',13111,612,647,8,'Schematic of an Out-of-Order CPU using the tag indexed scheme',35676,'Iain.mcclatchie','20040216052035','0','BITMAP','image','png',0,'qnrkcpk8at5i1fprcicnx48pf3lw2f8'),(279,'Dk-sd-logo.png','20040217030122!Dk-sd-logo.png',2288,44,44,8,'',16455,'Peregrine981','20040217025343','0','BITMAP','image','png',0,'j0l3kz0tfg8ryy8gi9hztg43yyngwrd'),(280,'NorthernIrelandLarne.png','20040217205012!NorthernIrelandLarne.png',18501,200,161,8,'',17287,'Morwen','20040217204921','0','BITMAP','image','png',0,'7x51kq36wojqejr6g07gu0o52s5zwr5'),(281,'WalterMondale.jpg','20040218005517!WalterMondale.jpg',17641,179,225,8,'[v http:/ / bioguide.congress.gov/ bioguide/ photo/ M/ M000851.jpg]',13800,'RickK','20030817225843','0','BITMAP','image','jpeg',0,'iy3w9ol0ztz44hruzrvr0c57gy04si7'),(282,'WalterMondale.jpg','20040218005612!WalterMondale.jpg',36572,191,242,8,'',35792,'AmericanCentury21','20040218005518','0','BITMAP','image','jpeg',0,'3vhkslilqxxa5wmdmzwhm4a0nx5eb0n'),(283,'Apollo-18-album-cover.png','20040218195412!Apollo_18_album_cover.png',19071,301,300,8,'cover art of They Might Be Giants\' \'\'Apollo 18\'\' (fair use; copyright held by Elektra Entertainment)',38898,'Djinn112','20040218194324','0','BITMAP','image','jpeg',0,'97ys9ols6w9b72e7f3dp2p88jf5op18'),(284,'Apollo-18-album-cover.png','20040218195731!Apollo_18_album_cover.png',90894,241,240,8,'smaller, brighter',38898,'Djinn112','20040218195412','0','BITMAP','image','png',0,'7y5pqt052yyw9eehs2ky0akpev5crny'),(285,'British-42nd-(East-Lancashire)-Division-Insignia.png','20040219053720!British_42nd_(East_Lancashire)_Division_Insignia.png',795,81,100,8,'division patch',646,'Gsl','20040212031710','0','BITMAP','image','png',0,'p1kiz478v5svgbchrjnh69mna0g557g'),(286,'British-11th-(Northern)-Division-Insignia.png','20040219064115!British_11th_(Northern)_Division_Insignia.png',2363,44,100,8,'division patch',646,'Gsl','20040119225448','0','BITMAP','image','png',0,'38zmdyax33nj4l7mple4bfjpgmki0fw'),(287,'Milford-sound.jpg','20040219105112!Milford_sound.jpg',38277,506,379,8,'Photograph of Milford Sound, New Zealand',45461,'Mperrin','20040219104453','0','BITMAP','image','jpeg',0,'fv6ezxeiuvntlorai735d23zyra4zzd'),(288,'USFWS-Logo.jpg','20040220083627!USFWS_Logo.jpg',4816,99,150,8,'public domain',34978,'Lupo','20040219162953','0','BITMAP','image','jpeg',0,'234robjerp1bs512nbne56ljc4quhwn'),(289,'Wpdms-topo-nasa-willamette-valley.jpg','20040221060915!Wpdms_topo_nasa_willamette_valley.jpg',26486,285,284,8,'Topo: Willamette Valley',37527,'Decumanus','20040221060828','0','BITMAP','image','jpeg',0,'34iwdiq1c0rawiuurhhpu2kgsjwve1u'),(290,'Wpdms-topo-nasa-willamette-valley.jpg','20040221061012!Wpdms_topo_nasa_willamette_valley.jpg',21517,232,284,8,'Willamette Valley',37527,'Decumanus','20040221060915','0','BITMAP','image','jpeg',0,'ay6a502i5oe7bbsl0egtlv90qib9ceo'),(291,'Devil.jpg','20040221172706!Devil.jpg',10246,265,93,8,'Cow and Chicken\'s Red Guy. Permission Given by Kurt to use image on 20 March 2003',5904,'Hoshie','20030321012417','0','BITMAP','image','jpeg',0,'71car50va9gvzzwk6y0hqdfgwflb1p7'),(292,'Devil.jpg','20040221172735!Devil.jpg',9913,250,239,8,'Tasmanian_devil',45959,'Jgritz','20040221172707','0','BITMAP','image','jpeg',0,'80x0apnn3dtyg6v2e4fsk6zk1mj1nv6'),(293,'LocationEuropeanUnion15.png','20040222173221!LocationEuropeanUnion15.png',14038,250,116,8,'',17287,'Morwen','20040222173125','0','BITMAP','image','png',0,'2oxnjyot0lmgulifgg2rxq1vojoeivx'),(294,'LocationEuropeanUnion15.png','20040222173256!LocationEuropeanUnion15.png',14038,250,116,8,'',17287,'Morwen','20040222173221','0','BITMAP','image','png',0,'2oxnjyot0lmgulifgg2rxq1vojoeivx'),(295,'RussiaMagadan.png','20040222221050!RussiaMagadan.png',35070,300,178,8,'',17287,'Morwen','20040221222431','0','BITMAP','image','png',0,'mhux61tc670c3l65iyf9khs8rpqtkgy'),(296,'One-thru-Nine-Step-by-Step-Orthographic-Auxillary-Projection.jpg','20040222235419!One_thru_Nine_Step_by_Step_Orthographic_Auxillary_Projection.jpg',26133,526,556,8,'One thru Nine Step by Step Orthographic Auxillary Projection',38163,'Pat Kelso','20040222222816','0','BITMAP','image','jpeg',0,'9cjtdf8a22m3rv21z1hf7amubctz2i6'),(297,'Mrt-small.png','20040223000608!Mrt_small.png',5690,446,304,8,'marginal rate of transformation',11870,'Mydogategodshat','20031213055634','0','BITMAP','image','png',0,'2acegom5hg33xem9fox58uhmsqpgtm9'),(298,'Thames-tunnels.png','20040224230750!Thames_tunnels.png',6871,401,117,8,'Thames tunnels',26468,'ChrisO','20040224225239','0','BITMAP','image','png',0,'jnh9kirrfdxl23sqggh70um65kb1uea'),(299,'Mee.jpg','20040224234539!Mee.jpg',28940,255,192,8,'',1752,'Anthere','20040216193403','0','BITMAP','image','jpeg',0,'o6qwijehun3blq2ejrpggst4p60bat6'),(300,'LocationNorthYemen.png','20040225181321!LocationNorthYemen.png',6129,250,115,8,'map showing [[North Yemen]]',17287,'Morwen','20040224222613','0','BITMAP','image','png',0,'70ji8l31vgzjgielq128zwfh2d9wlnr'),(301,'LondonAssemblyMakeup.png','20040225182049!LondonAssemblyMakeup.png',17710,200,155,8,'',17287,'Morwen','20040124155852','0','BITMAP','image','png',0,'ba6ucd98f1gjzk73avafko7g020b8qy'),(302,'Cetacea-range-map-Baird\'s-Beaked-Whale.PNG','20040225184609!Cetacea_range_map_Baird\'s_Beaked_Whale.PNG',34860,1357,628,8,'{{msg:GFDL}}, User:Pcb21 after User:Vardion. See [[Wikipedia:WikiProject Cetaceans]] for further details',7320,'Pcb21','20040225183959','0','BITMAP','image','png',0,'fhhzbvdqhip1epgszas5an1x46nnyqm'),(303,'Cetacea-range-map-Shepherd\'s-Beaked-Whale.PNG','20040225190934!Cetacea_range_map_Shepherd\'s_Beaked_Whale.PNG',34664,1357,628,8,'{{msg:GFDL}}, User:Pcb21 after User:Vardion. See [[Wikipedia:WikiProject Cetaceans]] for further details',7320,'Pcb21','20040225190928','0','BITMAP','image','png',0,'ooctf1f0q8zl60gptgnnkm4emwn081b'),(304,'Palmsundaytwintornadoes.jpg','20040225222453!Palmsundaytwintornadoes.jpg',3178,160,128,8,'',37459,'BigT27','20040225222147','0','BITMAP','image','jpeg',0,'n7cd1s80g85nd66do5u7b1muwtqilm2'),(305,'Snowskid.JPG','20040226044524!Snowskid.JPG',26863,400,300,8,'skid steer with snowplow attachement',7068,'Gbleem','20040226044259','0','BITMAP','image','jpeg',0,'oq4b96i21suwmvdomr4l8tq4otczskx'),(306,'Snowskid.JPG','20040226044554!Snowskid.JPG',11388,233,251,8,'skid steer with snowplow attachement',7068,'Gbleem','20040226044524','0','BITMAP','image','jpeg',0,'9swc5dbvnlwzljgc32blnb36yx1h5sg'),(307,'Snowskid.JPG','20040226044556!Snowskid.JPG',11388,400,300,8,'skid steer with snowplow attachement',7068,'Gbleem','20040226044524','0','BITMAP','image','jpeg',0,'oq4b96i21suwmvdomr4l8tq4otczskx'),(308,'Snowskid.JPG','20040226044608!Snowskid.JPG',26863,400,300,8,'Reverted to earlier revision',7068,'Gbleem','20040226044556','0','BITMAP','image','jpeg',0,'oq4b96i21suwmvdomr4l8tq4otczskx'),(309,'Snowskid.JPG','20040226045737!Snowskid.JPG',26863,400,300,8,'Reverted to earlier revision',7068,'Gbleem','20040226044609','0','BITMAP','image','jpeg',0,'oq4b96i21suwmvdomr4l8tq4otczskx'),(310,'Snowskid.JPG','20040226045909!Snowskid.JPG',11388,233,251,8,'skid steer with snowplow attachement',7068,'Gbleem','20040226045737','0','BITMAP','image','jpeg',0,'9swc5dbvnlwzljgc32blnb36yx1h5sg'),(311,'Ch-infra.jpg','20040227044030!Ch_infra.jpg',3673,270,37,8,'CK infra',45743,'64hokanching','20040227043957','0','BITMAP','image','jpeg',0,'r1z6npvrbxqfc71yxp8hjk5ax07kact'),(312,'Balkans-political-map-small.png','20040227141151!Balkans-political-map-small.png',46955,351,300,8,'Based on a map of Europe by [[User:Brion VIBBER|Brion VIBBER]]; this is a political map of the Balkans',40609,'Sinuhe','20040226125557','0','BITMAP','image','png',0,'fyhlc5qkybmaip5yqndkop2igki738y'),(313,'Picture-plane-projection-pivoted.png','20040227222657!Picture_plane_projection_pivoted.png',32401,325,317,8,'Illustration of [[Perspective distortion]]. Image created by [[User:Pat Kelso|Pat Kelso]]; cropping and coloring by [[User:Wapcaplet|Wapcaplet]].',6264,'Wapcaplet','20040227221934','0','BITMAP','image','png',0,'tu4p9og6h0f4ovvezz2n22kmfcwrx48'),(314,'VerdialesSerak.ogg','20040228031613!VerdialesSerak.ogg',370053,0,0,0,'Verdiales by Serak.',43633,'Serak','20040228012637','a:4:{s:7:\"version\";i:2;s:7:\"streams\";a:1:{i:32393;a:8:{s:6:\"serial\";i:32393;s:5:\"group\";i:0;s:4:\"type\";s:6:\"Vorbis\";s:6:\"vendor\";s:29:\"Xiph.Org libVorbis I 20030909\";s:6:\"length\";d:117.8785625000000010231815394945442676544189453125;s:4:\"size\";i:370053;s:6:\"header\";a:9:{s:14:\"vorbis_version\";i:0;s:14:\"audio_channels\";i:1;s:17:\"audio_sample_rate\";i:16000;s:15:\"bitrate_maximum\";i:4294967295;s:15:\"bitrate_nominal\";i:24000;s:15:\"bitrate_minimum\";i:4294967295;s:11:\"blocksize_0\";i:10;s:11:\"blocksize_1\";i:10;s:12:\"framing_flag\";i:0;}s:8:\"comments\";a:4:{s:5:\"TITLE\";s:9:\"Verdiales\";s:6:\"ARTIST\";s:5:\"Serak\";s:5:\"GENRE\";s:8:\"Flamenco\";s:7:\"COMMENT\";s:400:\"Copyright (c)  2004  Russ Parks. Permission is granted to copy, distribute and/or modify this document under the terms of the GNU Free Documentation License, Version 1.2 or any\r\nlater version published by the Free Software Foundation; with no Invariant Sections, no Front-Cover Texts, and no Back-Cover Texts.A copy of the license is included in the section entitled \"GNU Free Documentation License\".\";}}}s:6:\"length\";d:117.8785625000000010231815394945442676544189453125;s:6:\"offset\";d:1.2159999999999999698019337301957421004772186279296875;}','AUDIO','application','ogg',0,'3ouaxsirjcwnsbi83oit7i5lpwn32bg'),(315,'Map-of-USA-highlighting-Northeast.jpg','20040228040416!Map_of_USA_highlighting_Northeast.jpg',21192,280,183,8,'',32337,'Davodd','20040228035941','0','BITMAP','image','jpeg',0,'sqzmjpkz7qqgnnjrfoho9vhhr8r9zdb'),(316,'Ptable-MainPage.png','20040228135604!Ptable-MainPage.png',6902,100,59,8,'Periodic table icon for Main Page',52,'Eloquence','20040227232024','0','BITMAP','image','png',0,'rp1l5xdrl1m6obbaz8is84wsvkisla2'),(317,'Ptable-MainPage.png','20040228194559!Ptable-MainPage.png',13939,99,70,8,'',28394,'Ankur','20040228135605','0','BITMAP','image','png',0,'e1h1gst2yj0ndbfjnjl0q9yezytgogg'),(318,'John-Haggert.gif','20040228224749!John_Haggert.gif',148647,287,532,8,'John Haggert, Brampton, Ontario\'s first mayor',6468,'Zanimum','20030613181826','0','BITMAP','image','gif',0,'4ukytg54zbu8lez05anagxbezsqjoqm'),(319,'Wpdms-early-grants-1621-1639.png','20040229182257!Wpdms_early_grants_1621_1639.png',90413,426,491,8,'English Colonial Grants in North America (1621-1639)',37527,'Decumanus','20040229154338','0','BITMAP','image','png',0,'mld51jkxk5mmrfs6n16r2s9p578z64w'),(320,'Avignon-palais.jpg','20040229195024!Avignon-palais.jpg',76502,426,640,8,'Photo of Avignon',6815,'Yann','20040229194956','0','BITMAP','image','jpeg',0,'acxn7hmnbbddd1n9972s97e031snqqw'),(321,'Avignon-palais.jpg','20040229195132!Avignon-palais.jpg',76502,426,640,8,'Photo of Avignon',6815,'Yann','20040229195024','0','BITMAP','image','jpeg',0,'acxn7hmnbbddd1n9972s97e031snqqw'),(322,'Wpdms-province-of-maine-1622.png','20040229212247!Wpdms_province_of_maine_1622.png',20528,174,205,8,'Province of Maine',37527,'Decumanus','20040229212118','0','BITMAP','image','png',0,'hw6n3t13349bm1mw74zwexq8llbiwys'),(323,'Carnegie-lib-640-03.jpg','20040301184540!Carnegie_lib_640_03.jpg',60411,640,471,8,'A Carnegie library: Avondale Branch, The Public Library of Cincinnati and Hamilton County, 2004, by Rick Dikeman',27288,'Rdikeman','20040301153733','0','BITMAP','image','jpeg',0,'ocfpr97kyfnt1oqo3kimpcc3fzc7kba'),(324,'Carnegie-lib-640-03.jpg','20040301184717!Carnegie_lib_640_03.jpg',116380,640,471,8,'A Carnegie library: Avondale Branch, The Public Library of Cincinnati and Hamilton County, 2004, by Rick Dikeman ',27288,'Rdikeman','20040301184540','0','BITMAP','image','jpeg',0,'lxp8vf12iknzuqwlcps45kgs82t0z4u'),(325,'Wpdms-province-of-maine-1622.png','20040301211512!Wpdms_province_of_maine_1622.png',60072,348,410,8,'',37527,'Decumanus','20040229212248','0','BITMAP','image','png',0,'lns2jnil40t1zmhyzy37ix03k1bliuo'),(326,'Laponie2.jpg','20040302222127!Laponie2.jpg',23620,425,319,8,'Laponie',1752,'Anthere','20040225002100','0','BITMAP','image','jpeg',0,'e9wl6iukd6s9he92bbeza5x7r8hshhi'),(327,'Humphrey.jpg','20040303010734!Humphrey.jpg',15524,360,243,8,'Hubert H. Humphrey',300,'Andre Engels','20020807085018','0','BITMAP','image','jpeg',0,'5b4s1r72wskvoyhoieaiwzo4eo0gqtm'),(328,'Humphrey.jpg','20040303014153!Humphrey.jpg',73840,223,274,8,'I believe this is the official White House pic for VP Humphrey',35792,'AmericanCentury21','20040303010735','0','BITMAP','image','jpeg',0,'b67e7jq0y7hnbne93bnxjs2kfbw2zb8'),(329,'Humphrey.jpg','20040303014519!Humphrey.jpg',15524,223,274,8,'Reverted to earlier revision',34793,'Anthony','20040303014154','0','BITMAP','image','jpeg',0,'b67e7jq0y7hnbne93bnxjs2kfbw2zb8'),(330,'Humphrey.jpg','20040303014519!Humphrey.jpg',73840,223,274,8,'Reverted to earlier revision',35792,'AmericanCentury21','20040303014519','0','BITMAP','image','jpeg',0,'b67e7jq0y7hnbne93bnxjs2kfbw2zb8'),(331,'Humphrey.jpg','20040303014557!Humphrey.jpg',15524,360,243,8,'Reverted to earlier revision',34793,'Anthony','20040303014519','0','BITMAP','image','jpeg',0,'5b4s1r72wskvoyhoieaiwzo4eo0gqtm'),(332,'Humphrey.jpg','20040303015724!Humphrey.jpg',15524,223,274,8,'Reverted to earlier revision',34793,'Anthony','20040303014557','0','BITMAP','image','jpeg',0,'b67e7jq0y7hnbne93bnxjs2kfbw2zb8'),(333,'Laponie2.jpg','20040303220638!Laponie2.jpg',8302,213,283,8,'lapland',1752,'Anthere','20040302222128','0','BITMAP','image','jpeg',0,'nbozsn93xmkvbw9ko9iem72pts63h6k'),(334,'WalterMondale.jpg','20040303223532!WalterMondale.jpg',17641,179,225,8,'Reverted to earlier revision',35792,'AmericanCentury21','20040218005612','0','BITMAP','image','jpeg',0,'iy3w9ol0ztz44hruzrvr0c57gy04si7'),(335,'WalterMondale.jpg','20040303223916!WalterMondale.jpg',36572,191,242,8,'Reverted to earlier revision',35792,'AmericanCentury21','20040303223532','0','BITMAP','image','jpeg',0,'3vhkslilqxxa5wmdmzwhm4a0nx5eb0n'),(336,'Arms-cheshunt.jpg','20040304014513!Arms-cheshunt.jpg',14241,256,339,8,'Arms of the former council of Cheshunt, Herts. From civicheraldry.co.uk with permission',38775,'Marnanel','20040303191350','0','BITMAP','image','jpeg',0,'nxriile7im2adwla3ydvytnlyplyjrr'),(337,'Shanghaimusiccons.jpg','20040304090315!Shanghaimusiccons.jpg',34682,400,600,8,'Shanghai Conservatory of  Music, photo by nevilley',4191,'Nevilley','20040304090302','0','BITMAP','image','jpeg',0,'55euffinvc48tni43epjt3pkgjwy6we'),(338,'Chella-logo.png','20040304114503!Chella_logo.png',6580,397,92,8,'',38648,'Chellabm','20040227171118','0','BITMAP','image','png',0,'crwas4q3rsncg1l7njzeenljowe8nda'),(339,'Chella-logo.png','20040304114842!Chella_logo.png',7833,397,92,8,'my image',38648,'Chellabm','20040304114503','0','BITMAP','image','png',0,'qcj669iov3fqmp9aftw21ylfpu9k2uw'),(340,'Lesser-Sunda-Islands.png','20040304131403!Lesser_Sunda_Islands.png',22227,416,531,8,'{{msg:GFDL}} modified Krzysztof P. Jasiutowicz generated by aquarius.geomar.de',11,'Kpjas','20040303224735','0','BITMAP','image','png',0,'apof60zl6pg79vdpautu34lvjf85aiw'),(341,'Sengore.jpg','20040305022526!Sengore.jpg',8733,153,200,8,'',35792,'AmericanCentury21','20040215011346','0','BITMAP','image','jpeg',0,'tndom0vscpks51f1o9q07ww8f3lr380'),(342,'Gamut.tar.gz','20040305203539!Gamut.tar.gz',15436,0,0,0,'new version',25806,'Hankwang','20040305194830','',NULL,'unknown','unknown',0,''),(343,'Mexico.FoxSahagun.01.jpg','20040306122420!Mexico.FoxSahagun.01.jpg',12725,212,264,8,'Vicente Fox & wife -- whitehouse.gov, PD, from w:es',23076,'Hajor','20040305202928','0','BITMAP','image','jpeg',0,'c35g830sx16gksb70pocv2q8s3h4qu4'),(344,'Mexico.FoxSahagun.01.jpg','20040306140434!Mexico.FoxSahagun.01.jpg',25884,399,267,8,'uncropped',10049,'Jiang','20040306122420','0','BITMAP','image','jpeg',0,'h3s5xhdjs0u9jqu1ict0jkbobe5owl3'),(345,'EnglandNumbered1965.png','20040307102428!EnglandNumbered1965.png',80074,400,507,8,'the counties of England from 1965 - 1974',17287,'Morwen','20040124172846','0','BITMAP','image','png',0,'lk6m1g9xu0yzimijvrsqbc4tixvhs7e'),(346,'EnglandLincolnshireHolland1965.png','20040307105519!EnglandLincolnshireHolland1965.png',24629,200,254,8,'reupload',17287,'Morwen','20040208112420','0','BITMAP','image','png',0,'45gceufeshv085tr1zab33tbuvde20f'),(347,'EnglandLincolnshireKesteven1965.png','20040307105543!EnglandLincolnshireKesteven1965.png',24648,200,254,8,'reupload',17287,'Morwen','20040208112433','0','BITMAP','image','png',0,'mi244rwbgm6z7ooprcsimu5zo3s2xq6'),(348,'EnglandLincolnshireHolland1965.png','20040307105555!EnglandLincolnshireHolland1965.png',24852,200,254,8,'',17287,'Morwen','20040307105519','0','BITMAP','image','png',0,'kre56amr2dvcuhapfzo33aqx1m48mwu'),(349,'EnglandLincolnshireLindsey1965.png','20040307105604!EnglandLincolnshireLindsey1965.png',24642,200,254,8,'reupload',17287,'Morwen','20040208112444','0','BITMAP','image','png',0,'n4gn9vjyu9prgp1x6nbirf8k7ujxykb'),(350,'EnglandHuntingdonshirePeterborough.png','20040307105617!EnglandHuntingdonshirePeterborough.png',24013,200,253,8,'the counties of England from 1965 - 1974',17287,'Morwen','20040124173420','0','BITMAP','image','png',0,'05243odysw3m94l63h1czcf6mkmx3z5'),(351,'EnglandYorkshireNorthRiding1965.png','20040307105736!EnglandYorkshireNorthRiding1965.png',23980,200,253,8,'reupload',17287,'Morwen','20040208112339','0','BITMAP','image','png',0,'h994pwilxqbgkqg2rxkbil12d0qgkx4'),(352,'EnglandYorkshireWestRiding1965.png','20040307105743!EnglandYorkshireWestRiding1965.png',23974,200,253,8,'reupload',17287,'Morwen','20040208112352','0','BITMAP','image','png',0,'0tf1cpdny4lrbtjrk2zfh3n5xi4bhzn'),(353,'Wpdms-nasa-topo-colorado-river.jpg','20040307202746!Wpdms_nasa_topo_colorado_river.jpg',69847,342,323,8,'[[Colorado River (U.S.)|Colorado River]] and major tributaries. {{msg:GFDL}}',37527,'Decumanus','20040307195901','0','BITMAP','image','jpeg',0,'lrw94ylg4h0fcdbdkqe4vagj5t0jj43'),(354,'CarolMoseleyBraun.jpg','20040308011410!CarolMoseleyBraun.jpg',15844,200,197,8,'Carol Moseley Braun from the US Senate website',13800,'RickK','20030817031431','0','BITMAP','image','jpeg',0,'i0wyn5lbivvrrd36u62ik7ygdkqfj7i'),(355,'CarolMoseleyBraun.jpg','20040308013507!CarolMoseleyBraun.jpg',23709,138,164,8,'',35792,'AmericanCentury21','20040308011411','0','BITMAP','image','jpeg',0,'hiv5q5mdasw7maoqyctecao33e2wfjt'),(356,'Wpdms-nasa-topo-dolores-river.jpg','20040308063844!Wpdms_nasa_topo_dolores_river.jpg',67516,345,310,8,'[[Dolores River]] {{msg:GFDL}}',37527,'Decumanus','20040308033825','0','BITMAP','image','jpeg',0,'254tejmi391hme7tjwcxvjuluoaatbp'),(357,'Diodebridge4.png','20040308154940!Diodebridge4.png',6040,370,180,8,'New diode bridge diagram (AC rectification) {{msg:GFDL}}',2251,'DrBob','20040305215747','0','BITMAP','image','png',0,'bclxzm0txvqvtsa60m67wfm4a4q1w52'),(358,'Switched-On-Bach.jpg','20040309131228!Switched_On_Bach.jpg',52980,350,354,8,'Cover 0f 1969 album - Uploaded as fair use for article',22254,'Bwmodular','20040309130802','0','BITMAP','image','jpeg',0,'1sreehx0z5boe8mr4hrvcrdkw9uiil4'),(359,'Stevemaclean.jpg','20040309194525!Stevemaclean.jpg',36384,386,480,8,'steve maclean, canadian astronaut.  public domain, from nasa',32750,'Moink','20040308192202','0','BITMAP','image','jpeg',0,'bq2hz03t9ke9bgzhmgqjnm3wymnwngu'),(360,'Bundeslaender-germany-hb.png','20040309220532!Bundeslaender_germany_hb.png',9195,206,277,8,'Better scaled version',7580,'Ahoerstemeier','20030425205229','0','BITMAP','image','png',0,'g1kx2o83xpdv9via7shnkdsmyjkg05b'),(361,'Bundeslaender-germany-he.png','20040309220548!Bundeslaender_germany_he.png',9314,206,277,8,'Better scaled version',7580,'Ahoerstemeier','20030425200855','0','BITMAP','image','png',0,'ou6bayhep0bth9w7bhid21mhx397k57'),(362,'Bundeslaender-germany-hh.png','20040309220625!Bundeslaender_germany_hh.png',25232,226,324,8,'Federal states of Germany: Hamburg',4024,'Cordyph','20030228130737','0','BITMAP','image','png',0,'ha704m6a3tmhu20kzqmmrqowfvtbpga'),(363,'Bundeslaender-germany-mv.png','20040309220653!Bundeslaender_germany_mv.png',9326,206,277,8,'Better scaled version',7580,'Ahoerstemeier','20030425202347','0','BITMAP','image','png',0,'famlf0yf1w3fx1ydn5ititrw276m3y4'),(364,'Bundeslaender-germany-rp.png','20040309220743!Bundeslaender_germany_rp.png',9269,206,277,8,'Better scaled version',7580,'Ahoerstemeier','20030425202857','0','BITMAP','image','png',0,'1b5jxcea1aa1fbp3cvgmjd6w13cq7m4'),(365,'Bundeslaender-germany-rp.png','20040309220755!Bundeslaender_germany_rp.png',23527,200,266,8,'',17287,'Morwen','20040309220743','0','BITMAP','image','png',0,'i4icfjsy05fejt8dpkz9ii29momy4p1'),(366,'Bundeslaender-germany-sh.png','20040309220805!Bundeslaender_germany_sh.png',9270,206,277,8,'Better scaled version',7580,'Ahoerstemeier','20030425204726','0','BITMAP','image','png',0,'azmtzr2wfxql0xwaklhy5mx382xqw3y'),(367,'Bundeslaender-germany-sh.png','20040309220818!Bundeslaender_germany_sh.png',23362,200,266,8,'',17287,'Morwen','20040309220805','0','BITMAP','image','png',0,'2ehm7x6kfrcy4mbru4e3s5tgm1annwt'),(368,'Bundeslaender-germany-th.png','20040309220916!Bundeslaender_germany_th.png',25677,206,277,8,'Better scaled version',7580,'Ahoerstemeier','20030425204904','0','BITMAP','image','png',0,'kunpbtmei844nago75uumd2nq6gd74j'),(369,'Hermite-gaussian.png','20040310004543!Hermite-gaussian.png',32346,350,268,8,'Hermite-Gaussian transverse mode patterns, {{msg:GFDL}}',2251,'DrBob','20040309224641','0','BITMAP','image','png',0,'9rkusjd3kgb6vo4xcvvxehw906maoie'),(370,'Sengore.jpg','20040310021625!Sengore.jpg',14146,149,216,8,'Provided by Congress Bio Guide. Gov',35792,'AmericanCentury21','20040305022527','0','BITMAP','image','jpeg',0,'ip67c2pidd3u230eylzrzllh65hyibl'),(371,'Addison-vt-highlight-sm.png','20040310023844!Addison_vt_highlight_sm.png',8656,180,287,8,'addison vermont town highligh map',12292,'Redjar','20040302180046','0','BITMAP','image','png',0,'m28h1g7iozx57pdd6do16dsgqflmepd'),(372,'Wpdms-nasa-topo-yampa-river.jpg','20040310042044!Wpdms_nasa_topo_yampa_river.jpg',67535,345,310,8,'[[Yampa River]] {{msg:GFDL}}',37527,'Decumanus','20040308033856','0','BITMAP','image','jpeg',0,'195dd0e5696nej0hftr17g40jtynxzl'),(373,'Crude-EU25.png','20040310184659!Crude-EU25.png',3894,262,160,8,'{{msg:GFDL}}',17287,'Morwen','20040309223026','0','BITMAP','image','png',0,'1netlwla6z1ails8id8w9ntrdq210yw'),(374,'Crude-EU27.png','20040310184722!Crude-EU27.png',3905,262,160,8,'{{msg:GFDL}}',17287,'Morwen','20040309223129','0','BITMAP','image','png',0,'iw1g0kxunpzsv2edysw4ewdnojwn1yz'),(375,'Crude-EU15.png','20040310185217!Crude-EU15.png',3892,262,160,8,'{{msg:GFDL}}',17287,'Morwen','20040309223020','0','BITMAP','image','png',0,'t44fg61d476ahm8k6aul8vcnb2niogv'),(376,'Crude-EU15.png','20040310185730!Crude-EU15.png',4155,262,160,8,'highlighted enlargements',20318,'Joy','20040310185218','0','BITMAP','image','png',0,'idid4izx5k8ii1c8stu85qbffn276tx'),(377,'Carte-Localisation-Région-France-Bourggne.png','20040310224353!Carte_Localisation_Région_France_Bourggne.png',17945,257,256,8,'stolen from french wikipedia',8289,'Snoyes','20031213171616','0','BITMAP','image','png',0,'2p2l12vjwvfruugvfcy9edye99akp12'),(378,'Carte-Localisation-Région-France-Champagne-Ardenne.png','20040310224522!Carte_Localisation_Région_France_Champagne-Ardenne.png',17983,257,256,8,'stolen from french wikipedia',8289,'Snoyes','20031213171901','0','BITMAP','image','png',0,'te4f5ardjzvm4k7xgmd2rz1ip7ceu1s'),(379,'Carte-Localisation-Région-France-Haute-Normandie.png','20040310224627!Carte_Localisation_Région_France_Haute-Normandie.png',17837,257,256,8,'stolen from french wikipedia',8289,'Snoyes','20031213171937','0','BITMAP','image','png',0,'mi74d32dq0xh7gif9czkcnp85ugk9n8'),(380,'Limestone-pavement-above-Malham-Cove.jpg','20040311105526!Limestone_pavement_above_Malham_Cove.jpg',118164,800,600,8,'Taken by me, 3/ Nov/ 2003 in the Yorkshire Dales. {{msg:GFDL}}',42385,'Lupin','20040311104942','a:32:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:19:\"Canon PowerShot A70\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2003:09:27 18:07:34\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:4:\"1/60\";s:7:\"FNumber\";s:5:\"28/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2003:09:27 18:07:34\";s:17:\"DateTimeDigitized\";s:19:\"2003:09:27 18:07:34\";s:22:\"CompressedBitsPerPixel\";s:3:\"5/1\";s:17:\"ShutterSpeedValue\";s:6:\"189/32\";s:13:\"ApertureValue\";s:5:\"95/32\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:5:\"95/32\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:6:\"173/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"2048000/208\";s:21:\"FocalPlaneYResolution\";s:11:\"1536000/156\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:9:\"2048/2048\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'nflhv00iotpvv6euimkx8hidme6uold'),(381,'JunkersJu290.jpg','20040311134333!JunkersJu290.jpg',19877,300,121,8,'Junkers Ju 290A-5',8817,'Rlandmann','20040311134113','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:03:11 23:40:32\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'1imlaew5bvgmf56jkl4q1ivdvnt1ywl'),(382,'Wpdms-nasa-topo-colorado-river.jpg','20040312054553!Wpdms_nasa_topo_colorado_river.jpg',74703,353,356,8,'',37527,'Decumanus','20040307202746','0','BITMAP','image','jpeg',0,'j94bt7di2zxxs2nrj8rtigl475ysaxr'),(383,'Wpdms-nasa-topo-san-juan-river-utah.jpg','20040312054851!Wpdms_nasa_topo_san_juan_river_utah.jpg',67561,345,310,8,'[[San Juan River (Utah)|San Juan River]] {{msg:GFDL}}',37527,'Decumanus','20040307225559','0','BITMAP','image','jpeg',0,'b1xcyd5expqw4t36kmua38v4m9mys0v'),(384,'Wpdms-nasa-topo-dolores-river.jpg','20040312054915!Wpdms_nasa_topo_dolores_river.jpg',67537,345,310,8,'',37527,'Decumanus','20040308063844','0','BITMAP','image','jpeg',0,'as7b38ey1sotw9hu0o5rexhupja4yjo'),(385,'Wpdms-nasa-topo-white-river-utah.jpg','20040312055322!Wpdms_nasa_topo_white_river_utah.jpg',67545,345,310,8,'The [[White River (Utah)|White River]] in [[Colorado]] and [[Utah]] {{msg:GFDL}}',37527,'Decumanus','20040310042126','0','BITMAP','image','jpeg',0,'7xwsdsndyq1t5ljj8u515hr5nljw3qw'),(386,'Wpdms-nasa-topo-yampa-river.jpg','20040312055431!Wpdms_nasa_topo_yampa_river.jpg',67547,345,310,8,'',37527,'Decumanus','20040310042044','0','BITMAP','image','jpeg',0,'50105g9qbup0e9x8aj8mqh0gdnndkrf'),(387,'Wpdms-nasa-topo-little-snake-river.jpg','20040312055506!Wpdms_nasa_topo_little_snake_river.jpg',67649,345,310,8,'[[Little Snake River]] in [[Colorado]] {{msg:GFDL}}',37527,'Decumanus','20040310042205','0','BITMAP','image','jpeg',0,'9defqz15qfe49zqheqla0xp8df75dyx'),(388,'Wpdms-nasa-topo-big-sandy-river-wyoming.jpg','20040312055604!Wpdms_nasa_topo_big_sandy_river_wyoming.jpg',67519,345,310,8,'[[Big Sandy River (Wyoming)|Big Sand River]] in [[Wyoming]] {{msg:GFDL}}',37527,'Decumanus','20040310041711','0','BITMAP','image','jpeg',0,'3g3m32911svjue9vvm6jjyxjwplm01b'),(389,'Wpdms-nasa-topo-dolores-river.jpg','20040312055636!Wpdms_nasa_topo_dolores_river.jpg',66023,330,310,8,'',37527,'Decumanus','20040312054915','0','BITMAP','image','jpeg',0,'5xb9yis1ucvpidco0w1vp2c7pnizvzm'),(390,'Wpdms-nasa-topo-uncompahgre-river.jpg','20040312055859!Wpdms_nasa_topo_uncompahgre_river.jpg',67554,345,310,8,'[[Uncompahgre River]] in [[Colorado]] {{msg:GFDL}}',37527,'Decumanus','20040310042011','0','BITMAP','image','jpeg',0,'ppjpgmz79dfvsd3muso2ymhfqolwig7'),(391,'Wpdms-nasa-topo-roaring-fork-river.jpg','20040312055929!Wpdms_nasa_topo_roaring_fork_river.jpg',67562,345,310,8,'The [[Roaring Fork River]] in [[Colorado]] {{msg:GFDL}}',37527,'Decumanus','20040310042300','0','BITMAP','image','jpeg',0,'8r7xb3t3n8889yrtxnee62o27ytwqfb'),(392,'Wpdms-nasa-topo-virgin-river.jpg','20040312060642!Wpdms_nasa_topo_virgin_river.jpg',67560,345,310,8,'[[Virgin River]] {{msg:GFDL}}',37527,'Decumanus','20040308033929','0','BITMAP','image','jpeg',0,'ilwwdqy9o6f8wjml768x2nae261g7tg'),(393,'Wpdms-nasa-topo-absaroka-range.jpg','20040312194055!Wpdms_nasa_topo_absaroka_range.jpg',37331,356,345,8,'Absaroka Range',37527,'Decumanus','20040224161624','0','BITMAP','image','jpeg',0,'gilhjltq5xj49xtbcvmnk1wczefqf52'),(394,'Wpdms-nasa-topo-laramie-mountains.jpg','20040312194728!Wpdms_nasa_topo_laramie_mountains.jpg',37305,356,345,8,'Laramie Mountains',37527,'Decumanus','20040226174956','0','BITMAP','image','jpeg',0,'gbbhr8m409h2gowyrqd0eemek9frcr1'),(395,'Wpdms-nasa-topo-owl-creek-mountains.jpg','20040312215736!Wpdms_nasa_topo_owl_creek_mountains.jpg',31114,335,280,8,'[[Owl Creek Mountains]] in [[Wyoming]] {{msg:GFDL}}',37527,'Decumanus','20040312194401','0','BITMAP','image','jpeg',0,'4tlom2ypoktyzxbxyjfsdckbb6phecu'),(396,'Ba8.png','20040312221303!Ba8.png',0,0,0,0,'Brodmann area 8',41339,'Washington irving','20040312220359','0','BITMAP','image','png',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(397,'Wpdms-nasa-topo-bridger-mountains-wyoming.jpg','20040312223134!Wpdms_nasa_topo_bridger_mountains_wyoming.jpg',31122,335,280,8,'[[Bridger Mountains (Wyoming)|Bridger Mountains]] in [[Wyoming]] {{msg:GFDL}}',37527,'Decumanus','20040312220301','0','BITMAP','image','jpeg',0,'cyf5bphob245qjlemna5cq5plfpakis'),(398,'Wpdms-nasa-topo-owl-creek-mountains.jpg','20040312223615!Wpdms_nasa_topo_owl_creek_mountains.jpg',31119,335,280,8,'',37527,'Decumanus','20040312215736','0','BITMAP','image','jpeg',0,'7hyggsyajshmmda87s5i98bazotf798'),(399,'Vow-00a.wav','20040312223748!Vow-00a.wav',11983,0,0,0,'IPA example Vow-00a.wav',13661,'Nohat','20040312221044','','AUDIO','audio','wav',0,'dlxua3del3ugznl5fum98umi18j288k'),(400,'Vow-00a.wav','20040312223755!Vow-00a.wav',11983,0,0,0,'IPA example Vow-00a.wav. \n\nmaterial may be used in any way, provided that it is acknowledged. It should be cited as: UCLA Phonetics Lab Archive, 2003. ... Contact: phonetic.ucla.edu',13661,'Nohat','20040312223748','','AUDIO','audio','wav',0,'dlxua3del3ugznl5fum98umi18j288k'),(401,'Vow-00a.wav','20040312223801!Vow-00a.wav',11983,0,0,0,'IPA example Vow-00a.wav. \n\nmaterial may be used in any way, provided that it is acknowledged. It should be cited as: UCLA Phonetics Lab Archive, 2003. ... Contact: phonetic.ucla.edu',13661,'Nohat','20040312223755','','AUDIO','audio','wav',0,'dlxua3del3ugznl5fum98umi18j288k'),(402,'Vow-00a.wav','20040312223808!Vow-00a.wav',11983,0,0,0,'IPA example Vow-00a.wav. \n\nmaterial may be used in any way, provided that it is acknowledged. It should be cited as: UCLA Phonetics Lab Archive, 2003. ... Contact: phonetic.ucla.edu',13661,'Nohat','20040312223802','','AUDIO','audio','wav',0,'dlxua3del3ugznl5fum98umi18j288k'),(403,'Vow-00a.wav','20040312223823!Vow-00a.wav',11983,0,0,0,'IPA example Vow-00a.wav. \n\nmaterial may be used in any way, provided that it is acknowledged. It should be cited as: UCLA Phonetics Lab Archive, 2003. ... Contact: phonetic.ucla.edu',13661,'Nohat','20040312223809','','AUDIO','audio','wav',0,'dlxua3del3ugznl5fum98umi18j288k'),(404,'Wpdms-nasa-topo-owl-creek-mountains.jpg','20040312223854!Wpdms_nasa_topo_owl_creek_mountains.jpg',31119,335,280,8,'',37527,'Decumanus','20040312223615','0','BITMAP','image','jpeg',0,'7hyggsyajshmmda87s5i98bazotf798'),(405,'Vow-00a.wav','20040312223910!Vow-00a.wav',11983,0,0,0,'IPA example Vow-00a.wav. \n\nmaterial may be used in any way, provided that it is acknowledged. It should be cited as: UCLA Phonetics Lab Archive, 2003. ... Contact: phonetic.ucla.edu',13661,'Nohat','20040312223823','','AUDIO','audio','wav',0,'dlxua3del3ugznl5fum98umi18j288k'),(406,'Con-61b.wav','20040312230225!Con-61b.wav',16334,0,0,0,'IPA example Con-61b.wav. \n\nmaterial may be used in any way, provided that it is acknowledged. It should be cited as: UCLA Phonetics Lab Archive, 2003. ... Contact: phonetic.ucla.edu',13661,'Nohat','20040312225745','','AUDIO','audio','wav',0,'lp6l7lez7yryn3h1v38wky51ws8jcj9'),(407,'Ba11.png','20040312230626!Ba11.png',0,0,0,0,'Brodmann area 11',41339,'Washington irving','20040312220448','0','BITMAP','image','png',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(408,'Ba11.png','20040312231000!Ba11.png',30948,256,192,8,'Brodmann area 11',41339,'Washington irving','20040312230626','0','BITMAP','image','png',0,'7ji7vkuk4iqtq8zrj3os2m2mmag3hle'),(409,'Con-68b.wav','20040312231019!Con-68b.wav',15039,0,0,0,'IPA example Con-68b.wav. \n\nmaterial may be used in any way, provided that it is acknowledged. It should be cited as: UCLA Phonetics Lab Archive, 2003. ... Contact: phonetic.ucla.edu',51129,'NohatBot','20040312230318','','AUDIO','audio','wav',0,'ift8zhftzt7tmfdj5puskdmzbpn9gxq'),(410,'Con-69b.wav','20040312231027!Con-69b.wav',14671,0,0,0,'IPA example Con-69b.wav. \n\nmaterial may be used in any way, provided that it is acknowledged. It should be cited as: UCLA Phonetics Lab Archive, 2003. ... Contact: phonetic.ucla.edu',51129,'NohatBot','20040312230327','','AUDIO','audio','wav',0,'qjg1w58id8r81wbyr10lxy8xc71944d'),(411,'20million.JPG','20040313083616!20million.JPG',119537,1090,581,8,'Twenty Million Turkish Lira banknote. Presently the highest denomination in circulation, and due to be replaced in 2005 by a similar design banknote valued at 20 New Turkish Lira',50471,'Pavlvsrex','20040311093907','0','BITMAP','image','jpeg',0,'15ghgulhizfymn1flcrxfw8szbnzc6y'),(412,'Fingerthimble.jpg','20040313135835!Fingerthimble.jpg',56026,320,240,8,'Finger wearing metal thimble',50838,'JubeJube','20040311194444','a:38:{s:4:\"Make\";s:8:\"FUJIFILM\";s:5:\"Model\";s:14:\"FinePix A303  \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:37:\"Digital Camera FinePix A303   Ver1.00\";s:8:\"DateTime\";s:19:\"2004:03:11 14:28:58\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:5:\"10/53\";s:7:\"FNumber\";s:7:\"280/100\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:03:11 14:28:58\";s:17:\"DateTimeDigitized\";s:19:\"2004:03:11 14:28:58\";s:22:\"CompressedBitsPerPixel\";s:5:\"32/10\";s:17:\"ShutterSpeedValue\";s:7:\"240/100\";s:13:\"ApertureValue\";s:7:\"310/100\";s:15:\"BrightnessValue\";s:6:\"78/100\";s:17:\"ExposureBiasValue\";s:5:\"0/100\";s:16:\"MaxApertureValue\";s:7:\"300/100\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:7:\"570/100\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:6:\"3884/1\";s:21:\"FocalPlaneYResolution\";s:6:\"3884/1\";s:24:\"FocalPlaneResolutionUnit\";i:3;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"SceneCaptureType\";i:0;s:9:\"Sharpness\";i:3;s:20:\"SubjectDistanceRange\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'1xi395kd4dfpii5f3hpjbetczyt5tet'),(413,'SevernayaZemlya.JPG','20040313183502!SevernayaZemlya.JPG',3412,115,150,8,'Sattelite image of Severnaya Zemlya, from http:/ / visibleearth.nasa.gov/ cgi-bin/ viewrecord?8799 {{msg:PD}}',35314,'Seth Ilys','20040313182656','0','BITMAP','image','jpeg',0,'iryypydp7s9iozhhblgzho284pxsy6q'),(414,'Ba44.png','20040313201953!Ba44.png',29771,256,192,8,'Brodmann area 44',41339,'Washington irving','20040313201502','0','BITMAP','image','png',0,'7ljnzbh11q99nl5bfnn0xwsvza1fx4f'),(415,'Ba45.png','20040313202019!Ba45.png',30789,256,192,8,'Brodmann area 45',41339,'Washington irving','20040313201535','0','BITMAP','image','png',0,'bsfmwz49advho30kbzffy32yjsjgb60'),(416,'Usmc-Haiti-2004.jpg','20040313213726!Usmc_Haiti_2004.jpg',178198,800,521,8,'U.S. Marines from the 3rd Battalion, 8th Marine Regiment, Camp Lejeune, N.C., patrol the streets of Port-au-Prince, Haiti, on March 9, 2004. U.S. troops are deployed to Haiti at the request of the new Haitian President to help promote the constitutional p',10049,'Jiang','20040313094546','0','BITMAP','image','jpeg',0,'t1ifxx4fwmvymvycepd7ldiyhiow0g3'),(417,'Ba8.png','20040313214459!Ba8.png',29226,256,192,8,'Brodmann area 8',41339,'Washington irving','20040312221303','0','BITMAP','image','png',0,'rw3em90vhjvzboipms5bp4419l2ju87'),(418,'Ba8.png','20040313214553!Ba8.png',0,0,0,0,'Reverted to earlier revision',41339,'Washington irving','20040313214459','0','BITMAP','image','png',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(419,'Very-Large-Telescope-Array.aerial-view.jpg','20040313220513!Very_Large_Telescope_Array.aerial_view.jpg',20468,354,326,8,'Very Large Telescope Array',35996,'Maio','20040313215148','0','BITMAP','image','jpeg',0,'frwwwe7xcqkeopeqnqe78gmlt5pq960'),(420,'LocMap-Guadalupe-Mountains-National-Park.png','20040313231600!LocMap_Guadalupe_Mountains_National_Park.png',85675,0,0,0,'[[Guadalupe Mountains National Park]]  {{msg:GFDL}}',37527,'Decumanus','20040313231436','0','BITMAP','image','png',0,'nxu94iycprdy07nwja257g2gu0wnl0v'),(421,'First-Lieutenant-insignia.png','20040314045122!First_Lieutenant_insignia.png',17223,205,500,8,'USAF First Lieutenant insignia, public domain image from af.mil',23743,'RadicalBender','20040229214055','0','BITMAP','image','png',0,'kp5zkylgvg1uapvq3eicsyq4h56p7hk'),(422,'Second-Lieutenant-insignia.png','20040314045134!Second_Lieutenant_insignia.png',27730,207,500,8,'USAF Second Lieutenant insignia, public domain image from af.mil',23743,'RadicalBender','20040229214308','0','BITMAP','image','png',0,'hzwepoqbd5j6rj65nxmgsupw0jgo83x'),(423,'First-Lieutenant-insignia.png','20040314045247!First_Lieutenant_insignia.png',27730,207,500,8,'Somehow, I got the ranks mixed up - this is the correct file',23743,'RadicalBender','20040314045122','0','BITMAP','image','png',0,'hzwepoqbd5j6rj65nxmgsupw0jgo83x'),(424,'First-Lieutenant-insignia.png','20040314045358!First_Lieutenant_insignia.png',27730,207,500,8,'File doesn\'t seem to be uploading right - trying again',23743,'RadicalBender','20040314045247','0','BITMAP','image','png',0,'hzwepoqbd5j6rj65nxmgsupw0jgo83x'),(425,'Second-Lieutenant-insignia.png','20040314045456!Second_Lieutenant_insignia.png',17223,205,500,8,'Somehow, I got the ranks mixed up - this is the correct file',23743,'RadicalBender','20040314045134','0','BITMAP','image','png',0,'kp5zkylgvg1uapvq3eicsyq4h56p7hk'),(426,'Second-Lieutenant-insignia.png','20040314045507!Second_Lieutenant_insignia.png',17223,205,500,8,'Correct image (didn\'t upload properly?)',23743,'RadicalBender','20040314045456','0','BITMAP','image','png',0,'kp5zkylgvg1uapvq3eicsyq4h56p7hk'),(427,'HiroshimaPrefecturalPromotionHall.JPG','20040314050552!HiroshimaPrefecturalPromotionHall.JPG',11329,300,225,8,'Reverted to earlier revision',9023,'Xamian','20030311011813','0','BITMAP','image','jpeg',0,'ll8aj71df5rwrdpybdd5stpb87fjql8'),(428,'Eskimonebula.jpg','20040314052433!Eskimonebula.jpg',9276,266,264,8,'',37647,'Sennheiser','20040130131836','0','BITMAP','image','jpeg',0,'ddbcn88kww8o0fxtgrftqovc3qso9ee'),(429,'Bannerman-castle-water.jpg','20040314100750!Bannerman_castle_water.jpg',88043,800,551,8,'Bannerman\'s Castle viewed from the water',26210,'Friedo','20040314100022','0','BITMAP','image','jpeg',0,'6dj2prm879j12dlk62kghxiqawdx072'),(430,'LocMap-Carlsbad.png','20040314201938!LocMap_Carlsbad.png',0,0,0,0,'I created this from the existing Map_of_USA.png',19619,'Bevo','20040314201901','0','BITMAP','image','png',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(431,'LocMap-Carlsbad.png','20040314233033!LocMap_Carlsbad.png',0,0,0,0,'I created this from the existing Map_of_USA.png',19619,'Bevo','20040314201939','0','BITMAP','image','png',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(432,'Sts-63-crew.jpg','20040315001428!Sts-63-crew.jpg',178735,2859,2226,8,'From NASA',10109,'Evercat','20040314235726','0','BITMAP','image','jpeg',0,'jvs7jj9q40efsmsdqqzypgntglv53a9'),(433,'Sts-63-crew.jpg','20040315001711!Sts-63-crew.jpg',201178,2842,679,8,'cropped',10109,'Evercat','20040315001431','0','BITMAP','image','jpeg',0,'2ck7u6enrplpvehb1vfamqv89c1e1j0'),(434,'Louisiana-purchase-treaty1.jpg','20040315044456!Louisiana_purchase_treaty1.jpg',18720,300,449,8,'downsized to 300px',62,'Mav','20030311082900','0','BITMAP','image','jpeg',0,'a5jjwwocnn9mk5rl5s0gmqool759c2l'),(435,'Spitzer-Valentine.jpg','20040315201405!Spitzer_Valentine.jpg',56254,150,188,8,'smaller version',26861,'Zandperl','20040213013424','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:02:12 20:31:00\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'2axikjicpd1hug2gpvn3610iytwko13'),(436,'Dominions2-battle.png','20040315224257!Dominions2_battle.png',36950,300,240,8,'Screenshot: A battle situation in Dominions2. ',51032,'Horst F JENS','20040315222617','0','BITMAP','image','png',0,'efs2oc8t4qzftopoidjsmgpf6lmu4zn'),(437,'CentipedevsSpider.jpg','20040316012853!CentipedevsSpider.jpg',153455,900,526,8,'Predation example (larger version)',16734,'Marshman','20040106035945','a:25:{s:4:\"Make\";s:5:\"NIKON\";s:5:\"Model\";s:4:\"E950\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:01:05 17:38:54\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/600\";s:7:\"FNumber\";s:5:\"39/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:80;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:01:03 09:27:15\";s:17:\"DateTimeDigitized\";s:19:\"2004:01:03 09:27:15\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"26/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:1;s:11:\"FocalLength\";s:6:\"190/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'e5th1w77a0llw0hzm4q4dwd4fb0wmwr'),(438,'Dexamethasone.png','20040316140235!Dexamethasone.png',13441,646,523,8,'Chemical structure of dexamethasone',46555,'Jfdwolff','20040316135746','0','BITMAP','image','png',0,'qvgm92e9a8qvsglhz7n67snivtoi4lz'),(439,'Dexamethasone.png','20040316140353!Dexamethasone.png',3576,323,262,8,'Chemical structure of dexamethasone',46555,'Jfdwolff','20040316140236','0','BITMAP','image','png',0,'las2jieicvh9un9gp6pa1ilimo2a0c7'),(440,'DescartesCirclesA.png','20040316164509!DescartesCirclesA.png',4293,192,192,8,'Four kissing circles (Descartes circles case A)',42818,'Herbee','20040316143220','0','BITMAP','image','png',0,'4dggw46clwvrazecq20ac6l8nugczdb'),(441,'DescartesCirclesB.png','20040316164535!DescartesCirclesB.png',6150,192,192,8,'Four kissing circles (Descartes circles case B)',42818,'Herbee','20040316143251','0','BITMAP','image','png',0,'d3ilht8sw3959q25u722ltoqk2ijwpk'),(442,'DescartesCirclesC.png','20040316164602!DescartesCirclesC.png',6397,192,192,8,'Four kissing circles (Descartes circles case C)',42818,'Herbee','20040316143323','0','BITMAP','image','png',0,'c4auhk3h0zk7ot3hql30t4kjj3s02sp'),(443,'DescartesCirclesD.png','20040316164644!DescartesCirclesD.png',4641,192,192,8,'Four kissing circles (Descartes circles case D)',42818,'Herbee','20040316151715','0','BITMAP','image','png',0,'av3uh48f1of772za9knijcgo2drzzxv'),(444,'DescartesCirclesA.png','20040316173729!DescartesCirclesA.png',5039,192,192,8,'Four kissing circles (Descartes circles case A)',42818,'Herbee','20040316164510','0','BITMAP','image','png',0,'a3or1ofra0f1lv0zfslanbzcktcvyg8'),(445,'DescartesCircles.png','20040316222355!DescartesCircles.png',10813,256,256,8,'Four kissing circles, illustrating Descartes\' theorem.',42818,'Herbee','20040316215955','0','BITMAP','image','png',0,'q6277yoamlf9s8p28a898yo21vfvpcr'),(446,'DescartesCircles.png','20040316222612!DescartesCircles.png',11813,256,256,8,'Four kissing circles, illustrating Descartes\' theorem.',42818,'Herbee','20040316222355','0','BITMAP','image','png',0,'5mblna8oikin9b6nxxov1sfauupr5pg'),(447,'Apollo-18-album-cover.png','20040317010228!Apollo_18_album_cover.png',92054,241,240,8,'less ugly',38898,'Djinn112','20040218195731','0','BITMAP','image','png',0,'6p2ifltjyq9r5bmca0juwi9b77wr5gy'),(448,'BasicCombatTraining.jpg','20040317041248!BasicCombatTraining.jpg',53205,375,570,8,'taken from http:/ / www-tradoc.army.mil',8780,'Kingturtle','20040304195020','0','BITMAP','image','jpeg',0,'7gk0p183ro9ssty99od5n6dn94o0l5y'),(449,'Cardiacfunctioncurve.png','20040317220230!Cardiacfunctioncurve.png',32933,410,390,8,'cardiac function curve',20762,'Prisonblues','20040317214812','0','BITMAP','image','png',0,'6fnti7ch9nk39w811gsdevpcx4ww0ru'),(450,'20million.JPG','20040318101429!20million.JPG',119537,1090,581,8,'20Million TL',50471,'Pavlvsrex','20040313083616','0','BITMAP','image','jpeg',0,'15ghgulhizfymn1flcrxfw8szbnzc6y'),(451,'Bulger-cctv.jpg','20040318121730!Bulger_cctv.jpg',5470,150,180,8,'This image is a still taken from a shopping centre CCTV camera in 1993. It was released by the shopping centre to the police and the public in the hunt for [[Jamie Bulger]]\'s killers. It is contended to be in the public domain.',7320,'Pcb21','20040318121719','0','BITMAP','image','jpeg',0,'pzitj32t320ou28bxnzzqrh1zr0nqm9'),(452,'ATP.png','20040318142414!ATP.png',2126,250,186,1,'modified from ADP.png',66,'Bryan Derksen','20021221213221','0','BITMAP','image','png',0,'jqqmlkz887bnxuo9rch7scf0va8vx1h'),(453,'ATP.png','20040318142434!ATP.png',2255,412,319,4,'Reverted to earlier revision',45935,'JuanitaJP','20040318142414','0','BITMAP','image','png',0,'spse8xos7jcm5cdkc8m1z8nkx1tttqd'),(454,'Sexpatent03.png','20040318143149!Sexpatent03.png',749921,669,973,8,'Page three of US patent 745,264',52,'Eloquence','20030930014117','0','BITMAP','image','png',0,'6uf5x61jm67akd0a1n596ifztk5880d'),(455,'Img019c.png','20040318143429!Img019c.png',459088,515,459,8,'Map of the Holland Purchase',23458,'Bill1745','20040228101307','0','BITMAP','image','png',0,'2tif6x9fvu8a1ba0iyot9995rdh8833'),(456,'Ac.spainmap3.png','20040318155012!Ac.spainmap3.png',21877,601,397,8,'PNG version of Ac.spainmap3.jpg',10109,'Evercat','20040316203640','0','BITMAP','image','png',0,'iee0ugnpqwpovq09kq1vyiufnqv8cci'),(457,'Cardiacfunctioncurve.png','20040318183422!Cardiacfunctioncurve.png',33118,410,390,8,'Cardiac function curve',20762,'Prisonblues','20040317220230','0','BITMAP','image','png',0,'nmi6iat6wmme6fwt8feeg3b657olnmp'),(458,'Cardiacfunctioncurve.png','20040318184249!Cardiacfunctioncurve.png',12444,410,390,8,'Human Cardiac function curve',20762,'Prisonblues','20040318183422','0','BITMAP','image','png',0,'6e0kyklyfazhtsffz3tev2dk90twk42'),(459,'Descriptive-geometry---skew-lines-appearing-perpendicular.PNG','20040318195255!Descriptive_geometry_-_skew_lines_appearing_perpendicular.PNG',44459,500,369,8,'Descriptive geometry - skew lines appearing perpendicular',38163,'Pat Kelso','20040318183113','0','BITMAP','image','png',0,'mu0xk53nzhacdfa1pukd10d7qm19kbt'),(460,'BA37.png','20040318201553!BA37.png',0,0,0,0,'Brodmann area 37',41339,'Washington irving','20040318201452','0','BITMAP','image','png',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(461,'Davisonpeter.jpg','20040318230835!Davisonpeter.jpg',25147,150,150,8,'copyright-free publicity still of Peter Davison as the Doctor',6661,'PMelvilleAustin','20031012012208','0','BITMAP','image','jpeg',0,'q4uwa5r5ik4o55xc2h2ramx8wgku6bc'),(462,'BerlinerDisc.jpg','20040319022818!BerlinerDisc.jpg',19401,350,356,8,'Berliner Disc record, 1897 (jpg to replace larger png version)',4444,'Infrogmation','20030618232147','0','BITMAP','image','jpeg',0,'gmwacnhkck4knszvc38kj8htfm35xn7'),(463,'EBerlinerGramophoneDisc.png','20040319023842!EBerlinerGramophoneDisc.png',257964,421,435,8,'optimized to reduce file size',236,'Lorax','20030623031722','0','BITMAP','image','png',0,'9f44bqphdtbyqavfuxazjshck28m781'),(464,'EBerlinerGramophoneDisc.png','20040319024204!EBerlinerGramophoneDisc.png',292280,441,455,8,'Photoshop a bit for clarity',21036,'Dpbsmith','20040319023847','0','BITMAP','image','png',0,'gclexszsn6denavfff4oktweysz1fcm'),(465,'Wpdms-nasa-topo-big-sandy-river-wyoming.jpg','20040319074414!Wpdms_nasa_topo_big_sandy_river_wyoming.jpg',66040,330,310,8,'',37527,'Decumanus','20040312055604','0','BITMAP','image','jpeg',0,'sf1xwr7wibrdlavxlyr1cotysl7b62w'),(466,'Wpdms-nasa-topo-blue-river-colorado.jpg','20040319074602!Wpdms_nasa_topo_blue_river_colorado.jpg',66031,330,310,8,'',37527,'Decumanus','20040312060015','0','BITMAP','image','jpeg',0,'thgzfgw8vxv6i5rsdm27k8b1anjco8r'),(467,'Wpdms-nasa-topo-colorado-river.jpg','20040319074624!Wpdms_nasa_topo_colorado_river.jpg',66193,330,310,8,'',37527,'Decumanus','20040312054553','0','BITMAP','image','jpeg',0,'etir4agirac6yvycwjwmppatfwuhhey'),(468,'Wpdms-nasa-topo-dolores-river.jpg','20040319074649!Wpdms_nasa_topo_dolores_river.jpg',66023,330,310,8,'',37527,'Decumanus','20040312055636','0','BITMAP','image','jpeg',0,'5xb9yis1ucvpidco0w1vp2c7pnizvzm'),(469,'Wpdms-nasa-topo-eagle-river-colorado.jpg','20040319074707!Wpdms_nasa_topo_eagle_river_colorado.jpg',66015,330,310,8,'[[Eagle River (Colorado)|Eagle River]] in [[Colorado]] {{msg:GFDL}}',37527,'Decumanus','20040312060239','0','BITMAP','image','jpeg',0,'pdmtrgzxvt7tc473hqtgy7tmtuipaiz'),(470,'Wpdms-nasa-topo-little-colorado-river.jpg','20040319074837!Wpdms_nasa_topo_little_colorado_river.jpg',66065,330,310,8,'[[Little Colorado River]] in [[Arizona]] {{msg:GFDL}}',37527,'Decumanus','20040312054749','0','BITMAP','image','jpeg',0,'s0n090xeburaaxtjx1wwdyxs47iopv6'),(471,'Wpdms-nasa-topo-little-snake-river.jpg','20040319074854!Wpdms_nasa_topo_little_snake_river.jpg',66061,330,310,8,'',37527,'Decumanus','20040312055506','0','BITMAP','image','jpeg',0,'d2iijlpr7yn0gpe5472ep1na4253jhw'),(472,'Wpdms-nasa-topo-roaring-fork-river.jpg','20040319074917!Wpdms_nasa_topo_roaring_fork_river.jpg',66040,330,310,8,'',37527,'Decumanus','20040312055929','0','BITMAP','image','jpeg',0,'kxf4d3qb6ffm5d4243xqdpuv8issh3j'),(473,'Wpdms-nasa-topo-san-juan-river-utah.jpg','20040319075055!Wpdms_nasa_topo_san_juan_river_utah.jpg',66136,330,310,8,'',37527,'Decumanus','20040312054851','0','BITMAP','image','jpeg',0,'elaznadgbs2avv81kx5xigith08wom9'),(474,'Wpdms-nasa-topo-san-miguel-river-colorado.jpg','20040319075118!Wpdms_nasa_topo_san_miguel_river_colorado.jpg',66030,330,310,8,'The [[San Miguel River (Colorado)|San Miguel River]] in [[Colorado]] {{msg:GFDL}}',37527,'Decumanus','20040312055726','0','BITMAP','image','jpeg',0,'0v78a4gax5vgc56ub3x25zuuzk7ew42'),(475,'Wpdms-nasa-topo-san-rafael-river-utah.jpg','20040319075138!Wpdms_nasa_topo_san_rafael_river_utah.jpg',66030,330,310,8,'[[San Rafael River (Utah)|San Rafael River]] in [[Utah]] {{msg:GFDL}}',37527,'Decumanus','20040312055228','0','BITMAP','image','jpeg',0,'plx0r12kb2f8v7uos958tyvhtff32hg'),(476,'Wpdms-nasa-topo-uncompahgre-river.jpg','20040319075156!Wpdms_nasa_topo_uncompahgre_river.jpg',66039,330,310,8,'',37527,'Decumanus','20040312055859','0','BITMAP','image','jpeg',0,'2dvu6hoaxhj6lhinz7sh8d2avx9jbek'),(477,'Wpdms-nasa-topo-virgin-river.jpg','20040319075211!Wpdms_nasa_topo_virgin_river.jpg',66047,330,310,8,'',37527,'Decumanus','20040312060642','0','BITMAP','image','jpeg',0,'ihvyc3lnodgtg54aagd078dcd3hm87f'),(478,'Wpdms-nasa-topo-white-river-utah.jpg','20040319075228!Wpdms_nasa_topo_white_river_utah.jpg',66057,330,310,8,'',37527,'Decumanus','20040312055322','0','BITMAP','image','jpeg',0,'l5z5i9q52gxwyvebtg649avnvxn8c42'),(479,'Wpdms-nasa-topo-yampa-river.jpg','20040319075247!Wpdms_nasa_topo_yampa_river.jpg',66038,330,310,8,'',37527,'Decumanus','20040312055431','0','BITMAP','image','jpeg',0,'fexu7vxbms2e2szq5y5e0jce5r3kg14'),(480,'Taiwan-map.png','20040319105158!Taiwan_map.png',44038,218,359,8,'',10049,'Jiang','20031230075350','0','BITMAP','image','png',0,'ou5ng28hq4h0qkslguv7lrf5j6pfsak'),(481,'Musicians.jpg','20040319123827!Musicians.jpg',38694,402,308,8,'armenian folk musicians',35639,'Dmn','20040121155017','0','BITMAP','image','jpeg',0,'ceihos6mnozgf7ryhqzls835lx6mwle'),(482,'Musicians.jpg','20040319133502!Musicians.jpg',38737,402,308,8,'A picture of Armenian musicians I took last summer.',35639,'Dmn','20040319123827','0','BITMAP','image','jpeg',0,'6n2eglbmpgw8jvr236nf8rsq4h8r3r5'),(483,'Uterus-and-vagina-no-captions.png','20040319143643!Uterus_and_vagina_no_captions.png',6342,482,394,8,'Female anatomy for articles on menstruation.  No captions.',37404,'Fabiform','20040203155008','0','BITMAP','image','png',0,'fxhy2or26lmvgo39fhyga1rksszvpzc'),(484,'Uterus-and-vagina-with-captions.png','20040319143828!Uterus_and_vagina_with_captions.png',10527,482,394,8,'Female anatomy for articles on menstruation.  With captions.',37404,'Fabiform','20040203155120','0','BITMAP','image','png',0,'b222rhzl6soci8bo6oxbrso7lf66wix'),(485,'Kenilworth-Castle-keep-from-north.jpg','20040320182817!Kenilworth_Castle_keep_from_north.jpg',785538,1536,2048,8,'[[Kenilworth Castle]] hall ruins. {{msg:stub}}',8776,'Jdforrester','20040320182612','a:24:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:9:\"CYBERSHOT\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2003:12:09 12:27:28\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/1600\";s:7:\"FNumber\";s:5:\"56/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2003:12:09 12:27:28\";s:17:\"DateTimeDigitized\";s:19:\"2003:12:09 12:27:28\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"48/16\";s:12:\"MeteringMode\";i:3;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"80/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'edlxy12egqmo5ptrsqztmt84kf6kav0'),(486,'Venice-Beach.jpg','20040321010812!Venice_Beach.jpg',37271,400,275,8,'By mdoege@compuserve.com on 1993-04-16',19910,'Morn','20030823122104','0','BITMAP','image','jpeg',0,'90xyttpyozheddop9q4ns1atmrd9axt'),(487,'Cottonfieldpanorama.jpg','20040321082727!Cottonfieldpanorama.jpg',16988,580,123,8,'Picking cotton in Georgia.',6468,'Zanimum','20031015132115','0','BITMAP','image','jpeg',0,'q45rjrtz365viha5tr7e4ca16hxbebk'),(488,'Alpaca.png','20040321155248!Alpaca.png',34868,343,435,4,'',0,'(Automated conversion)','20020720114936','0','BITMAP','image','png',0,'h674vzno8xzeysp0txyusg9b32n562e'),(489,'NCMap-countiesdone.PNG','20040321194413!NCMap-countiesdone.PNG',9224,300,117,8,'{{msg:GFDL}} Adapted from Wikipedia\'s NC county maps by Seth Ilys.',35314,'Seth Ilys','20040320185948','0','BITMAP','image','png',0,'7tyzfemmwtoayt2dlq6klid5z0cv4os'),(490,'Wpdms-nasa-topo-bad-river-south-dakota.jpg','20040321205717!Wpdms_nasa_topo_bad_river_south_dakota.jpg',46059,300,250,8,'[[Bad River (South Dakota)|Bad River]] &#169; 2004 Matthew Trump {{msg:GFDL}}',37527,'Decumanus','20040321203854','0','BITMAP','image','jpeg',0,'lhcuzqn35t7pkrpfz4170m0q0ysoe7q'),(491,'Wpdms-nasa-topo-belle-fourche-river.jpg','20040321205733!Wpdms_nasa_topo_belle_fourche_river.jpg',46090,300,250,8,'[[Belle Fourche River]] &#169; 2004 Matthew Trump {{msg:GFDL}}',37527,'Decumanus','20040321203947','0','BITMAP','image','jpeg',0,'8p6lr5o17srsnd0f3gnf5umtqs325oy'),(492,'NCMap-countiesdone.PNG','20040321210136!NCMap-countiesdone.PNG',9219,300,117,8,'',35314,'Seth Ilys','20040321194413','0','BITMAP','image','png',0,'de19ws5ri3olact2bijtebtjegycair'),(493,'Wpdms-nasa-topo-big-blue-river.jpg','20040321211005!Wpdms_nasa_topo_big_blue_river.jpg',46069,300,250,8,'[[Big Blue River]] &#169; 2004 Matthew Trump {{msg:GFDL}}',37527,'Decumanus','20040321204030','0','BITMAP','image','jpeg',0,'9qefnyl8cf7abbbclyskmp3wcldjxu0'),(494,'Wpdms-nasa-topo-big-sioux-river.jpg','20040321211024!Wpdms_nasa_topo_big_sioux_river.jpg',46119,300,250,8,'[[Big Sioux River]] &#169; 2004 Matthew Trump {{msg:GFDL}}',37527,'Decumanus','20040321204245','0','BITMAP','image','jpeg',0,'bvpczonwdfu4a203nl9jsdc5zosyi1w'),(495,'Wpdms-nasa-topo-cache-la-poudre-river.jpg','20040321211044!Wpdms_nasa_topo_cache_la_poudre_river.jpg',46066,300,250,8,'[[Cache La Poudre River]] &#169; 2004 Matthew Trump {{msg:GFDL}}',37527,'Decumanus','20040321204337','0','BITMAP','image','jpeg',0,'74og805g7gjxo37rzmx1vka70ly85o3'),(496,'Wpdms-nasa-topo-elkhorn-river-nebraska.jpg','20040321211118!Wpdms_nasa_topo_elkhorn_river_nebraska.jpg',46308,300,250,8,'[[Elkhorn River]] &#169; 2004 Matthew Trump {{msg:GFDL}}',37527,'Decumanus','20040321204610','0','BITMAP','image','jpeg',0,'hreqqoysi4h8szs6lg4ajht0sh1jkrt'),(497,'Wpdms-nasa-topo-white-river-south-dakota.jpg','20040321213855!Wpdms_nasa_topo_white_river_south_dakota.jpg',46298,300,250,8,'[[White River (South Dakota)|White River]] &#169; 2004 Matthew Trump {{msg:GFDL}}',37527,'Decumanus','20040321030250','0','BITMAP','image','jpeg',0,'rw92q7evi4r0cl9x6ui1p7fuldnzfus'),(498,'Prograph-object-types.PNG','20040321213935!Prograph_object_types.PNG',2627,201,241,8,'Prograph object types - courtesy MacTech',2175,'Maury Markowitz','20040321211237','0','BITMAP','image','png',0,'h3yhjkezxjs52frvw1lws9q5hbrklbq'),(499,'NCMap-countiesdone.PNG','20040321223624!NCMap-countiesdone.PNG',9240,300,117,8,'',35314,'Seth Ilys','20040321210136','0','BITMAP','image','png',0,'lsppk5wz47wa0zjn09r57tpetlwh94g'),(500,'Glucose-6-phosphate.png','20040322001250!Glucose-6-phosphate.png',17729,365,454,8,'Glucose-6-phosphate molecule (G6P)',51395,'Delta G','20040322000631','0','BITMAP','image','png',0,'ravd96fpo9wae5jp9rpfywsnqf6xx5l'),(501,'NCMap-countiesdone.PNG','20040322004333!NCMap-countiesdone.PNG',9221,300,117,8,'',35314,'Seth Ilys','20040321223624','0','BITMAP','image','png',0,'m0rjtoo7iy2zhw6wo0zj7ocw3zxelr5'),(502,'W780925-1.jpg','20040322040112!W780925-1.jpg',13111,334,370,8,'Pacific Southwest Airlines flight 182 as it crashes over San Diego',53726,'Alvin b 18','20040322035925','0','BITMAP','image','jpeg',0,'bvqvnnxb2s11wj17ef3teoiicvm5mgi'),(503,'NCMap-countiesdone.PNG','20040322134319!NCMap-countiesdone.PNG',9211,300,117,8,'',35314,'Seth Ilys','20040322004333','0','BITMAP','image','png',0,'d4akviy24mc24ate2qk5g59kqr8jsqd'),(504,'Motlawa-2002.jpg','20040323051013!Motlawa_2002.jpg',54946,712,358,8,'',3759,'Topory','20030310223322','0','BITMAP','image','jpeg',0,'kfhm3t8aygikwdociusg95ii5u1jff6'),(505,'Motlawa-2002.jpg','20040323051014!Motlawa_2002.jpg',54946,712,358,8,'Reverted to earlier revision',32233,'Halibutt','20040323051013','0','BITMAP','image','jpeg',0,'kfhm3t8aygikwdociusg95ii5u1jff6'),(506,'Tea-ceremony-implements.jpg','20040323070827!Tea_ceremony_implements.jpg',13196,300,300,8,'',37736,'Exploding Boy','20040131114728','0','BITMAP','image','jpeg',0,'sdosfr39hqdscairvv1ste0xgs6jixv'),(507,'Chawan.jpg','20040323070956!Chawan.jpg',10823,300,300,8,'',37736,'Exploding Boy','20040131114557','0','BITMAP','image','jpeg',0,'7ah20ptl66en7a0nc84h42wzacke1c1'),(508,'Natsume.jpg','20040323071059!Natsume.jpg',11293,300,300,8,'Natsume tea caddy for Japanese Tea Ceremony',37736,'Exploding Boy','20040124135032','0','BITMAP','image','jpeg',0,'nh51wyk6g1bot3lshv2epjwrmrskr6u'),(509,'Prograph-object-types.PNG','20040323131751!Prograph_object_types.PNG',2478,192,194,8,'cropped a bit better',2175,'Maury Markowitz','20040321213935','0','BITMAP','image','png',0,'q0fioeynn5zsosoo6t32nfccidg4jtu'),(510,'Proper-vi-in-hindi.png','20040323181957!Proper-vi-in-hindi.png',1859,256,256,8,'The correct way to write \"vi\" in Hindi, painted by me in the GIMP. -- ~~~~',6949,'Paddu','20040323145702','0','BITMAP','image','png',0,'lq3lss4banoykvaj0qiljuu0i9l8wbo'),(511,'Improper-vi-in-hindi.png','20040323182025!Improper-vi-in-hindi.png',2983,256,256,8,'The way most software render \"vi\" in Hindi (incorrectly) as, painted by me in the GIMP. -- ~~~~',6949,'Paddu','20040323145841','0','BITMAP','image','png',0,'mmjc9wv5jm3jxuq8a9tqvrdschxkqt1'),(512,'Glucose-6-phosphate.png','20040323223523!Glucose-6-phosphate.png',8561,200,248,8,'Glucose-6-phosphate molecule (G6P)',51395,'Delta G','20040322001250','0','BITMAP','image','png',0,'m9895ixuspji0t7gvm5rd4v7lsbwvjm'),(513,'RuBP.png','20040323224322!RuBP.png',13341,230,290,8,'ribulose-1,5-bisphosphate (RuBP)',51395,'Delta G','20040323223740','0','BITMAP','image','png',0,'p8hpcnst3wrjmmtc68vowsi2xiwjqv3'),(514,'USN.insignia.e5.blues.wag.png','20040324032732!USN.insignia.e5.blues.wag.png',774,50,63,8,'',44261,'Wguynes','20040324025838','0','BITMAP','image','png',0,'8je3t0l9fw7fxp25cex7f4fjhqrowgw'),(515,'USN.insignia.e5.blues.wag.png','20040324032818!USN.insignia.e5.blues.wag.png',774,50,63,8,'',44261,'Wguynes','20040324032732','0','BITMAP','image','png',0,'8je3t0l9fw7fxp25cex7f4fjhqrowgw'),(516,'USN.insignia.e5.blues.wag.png','20040324032822!USN.insignia.e5.blues.wag.png',774,50,63,8,'',44261,'Wguynes','20040324032818','0','BITMAP','image','png',0,'8je3t0l9fw7fxp25cex7f4fjhqrowgw'),(517,'Doublylinkedlist.png','20040324141817!Doublylinkedlist.png',11642,600,60,8,'i made this;',31635,'Yacht','20040307111756','0','BITMAP','image','png',0,'24ye10v3zykylgp5oq9n970uo7yrktp'),(518,'Iron-metabolism.png','20040324151812!Iron_metabolism.png',25396,545,239,8,'Distribution of body iron stores',46555,'Jfdwolff','20040324151119','0','BITMAP','image','png',0,'q8eki4ebezog0trgfrxfrsswt0187eh'),(519,'Airforce-watching-WWE.jpg','20040324155125!Airforce_watching_WWE.jpg',71297,200,217,8,'Troops at Camp Victory in Iraq during the WWE SMACKDOWN on Christmas Day  Picture from:  http:/ / www-p.afsv.af.mil/ NWVW/ February04/ Art13.htm  License: Information presented on Air Force Services Agency Website is considered public information and may ',6468,'Zanimum','20040324154553','0','BITMAP','image','jpeg',0,'c7i67qoupkushal9chsmtbriw4yxz1e'),(520,'Airforce-watching-WWE.jpg','20040324155148!Airforce_watching_WWE.jpg',71297,200,217,8,'Two men wrestling Picture from: http:/ / www-p.afsv.af.mil/ AFSports/   License: Information presented on Air Force Services Agency Website is considered public information and may be distributed or copied. Use of appropriate byline/ photo/ image credits ',6468,'Zanimum','20040324155125','0','BITMAP','image','jpeg',0,'c7i67qoupkushal9chsmtbriw4yxz1e'),(521,'ColombiaNumbered.png','20040324205518!ColombiaNumbered.png',81666,400,534,8,'{{msg:GFDL}}',17287,'Morwen','20040324204212','0','BITMAP','image','png',0,'651ju180kzp9yqi6ipu1kqkaypmxd8a'),(522,'ColombiaNumbered.png','20040324212617!ColombiaNumbered.png',81352,400,534,8,'{{msg:GFDL}}',17287,'Morwen','20040324205518','0','BITMAP','image','png',0,'gfohv510fd33kdix07qfrgwvj9f307q'),(523,'ColombiaMagdalena.png','20040324213553!ColombiaMagdalena.png',26642,200,267,8,'{{msg:GFDL}}',17287,'Morwen','20040324213454','0','BITMAP','image','png',0,'j8uwftz1np73fg5bhgzj84hj5d7x2np'),(524,'Gambusia-punctata.png','20040324230223!Gambusia_punctata.png',38369,640,480,8,'drawing of Gambusia punctata',9855,'Tkinias','20040324225032','0','BITMAP','image','png',0,'hi757mrn3ib90xhj8hvrv4nblzw3lb8'),(525,'Liebknecht.jpg','20040325041303!Liebknecht.jpg',9161,250,326,8,'Public domain photograph of Wilhelm Liebknecht from http:/ / www.lib.utexas.edu/ photodraw/ portraits/ index.html',8551,'Angela','20031018061220','0','BITMAP','image','jpeg',0,'osrq06fwav9z8d9ymm9t0gmbh143aii'),(526,'Liebknecht.jpg','20040325041835!Liebknecht.jpg',93145,692,828,8,'public domain',5016,'Kwertii','20040325041303','0','BITMAP','image','jpeg',0,'jn0fb962njpgmd6oqy5hhk9dp5naz7u'),(527,'USAirF.insignia.e3.sra.png','20040325175817!USAirF.insignia.e3.sra.png',552,50,31,8,'based on [[:Image:USAirF.insignia.e3.wag.png]]',3628,'Hephaestos','20040325175418','0','BITMAP','image','png',0,'8p8bbj75w02nkpo9sb1407k49ubs8ny'),(528,'USAirF.insignia.e3.sra.png','20040325180905!USAirF.insignia.e3.sra.png',552,50,31,8,'trying to fix transparency',3628,'Hephaestos','20040325175817','0','BITMAP','image','png',0,'8p8bbj75w02nkpo9sb1407k49ubs8ny'),(529,'Airman-stripes.png','20040326011355!Airman_stripes.png',27752,650,277,8,'USAF Airman stripes, public domain image from af.mil',23743,'RadicalBender','20040229212500','0','BITMAP','image','png',0,'ip4gfgxiquet1reqgs3xa8qdytsnyhr'),(530,'Mercury-monument.jpg','20040326224945!Mercury_monument.jpg',16077,252,287,8,'Mercury space program monument',15116,'Audin','20030811044913','0','BITMAP','image','jpeg',0,'qjuvk3t7nyp6749lstjo1hoyvaecbst'),(531,'Albany-vt-highlight.png','20040327030532!Albany_vt_highlight.png',40638,445,724,8,'Vermont towns map with Albany highlighted.',12292,'Redjar','20040322015631','0','BITMAP','image','png',0,'l5o51p9zot0h20zgspccuae4pd9ocg6'),(532,'Arlington-vt-highlight.png','20040327031400!Arlington_vt_highlight.png',40603,445,724,8,'Vermont towns map with Arlington highlighted.',12292,'Redjar','20040322140535','0','BITMAP','image','png',0,'9y41boz6sucx6feaxisa3vbz163nd7e'),(533,'Baltimore-vt-highlight.png','20040327031623!Baltimore_vt_highlight.png',40600,445,724,8,'Vermont towns map with Baltimore highlighted.',12292,'Redjar','20040322144946','0','BITMAP','image','png',0,'aooqlf78idmx57i05b3p5ijynwtelqu'),(534,'Barnard-vt-highlight.png','20040327031839!Barnard_vt_highlight.png',35732,465,744,8,'Vermont towns map with Barnard highlighted.',12292,'Redjar','20040323163112','0','BITMAP','image','png',0,'fqw8cmh2ybb7t0t1ao89t8w8w39fnb7'),(535,'Bakersfield-vt-highlight.png','20040327033223!Bakersfield_vt_highlight.png',35706,465,744,8,'Vermont town map with town highlight',12292,'Redjar','20040327032003','0','BITMAP','image','png',0,'pszu7qpt6iczpgwkyswgcv52ctzddfx'),(536,'Diffraction.png','20040327061532!Diffraction.png',32076,372,228,8,'Water ripples diffraction through large and small gaps . Drawn by theresa knott',8257,'Theresa knott','20030307093948','0','BITMAP','image','png',0,'32ih30c7d5cplkeeser605qlyv31bwd'),(537,'Interf2.png','20040327061549!Interf2.png',168098,300,300,16,'Interference pattern of spherical wave fronts from three point sources in two dimensions',10476,'AndreaPersephone','20030917011342','0','BITMAP','image','png',0,'sf9152osm6nhmq6ve3ikhzeqj0syxjx'),(538,'Interf.png','20040327061601!Interf.png',140496,320,240,16,'Interference pattern of spherical wave fronts from two points sources in two dimensions',10476,'AndreaPersephone','20030917010943','0','BITMAP','image','png',0,'8lrjevdj4tuuf5wdcmp6tdyl7ighxvq'),(539,'Reflecting-from-a-curved-barrier.png','20040327061612!Reflecting_from_a_curved_barrier.png',15913,295,107,8,'',8257,'Theresa knott','20030305125939','0','BITMAP','image','png',0,'jonxkpfyvyru1zrjn3vbd7bq9b5ycbp'),(540,'Reflection-in-a-ripple-tank.png','20040327061621!Reflection_in_a_ripple_tank.png',8986,304,182,8,'',8257,'Theresa knott','20030305111004','0','BITMAP','image','png',0,'a4elnp5tyl9nhfm9jv5xpgur5ed11wq'),(541,'Ripple-tank.png','20040327061645!Ripple_tank.png',3304,227,155,8,'Diagram of a ripple tank drawn by theresa knott',8257,'Theresa knott','20030304161514','0','BITMAP','image','png',0,'exd9v6cn93jo9ygw6ma27gyvuh3vos5'),(542,'Ripple-tank-motor.png','20040327061654!Ripple_tank_motor.png',4770,208,123,8,'Diagram drawn by theresa knott. Annotations hand drawn by Rachel Knott',8257,'Theresa knott','20030420101804','0','BITMAP','image','png',0,'4garz6uedq8ieyh4pq6g1t75qraeznr'),(543,'Ripple-tank-plane-waves.png','20040327061729!Ripple_tank_plane_waves.png',8971,198,133,8,'',8257,'Theresa knott','20030305121713','0','BITMAP','image','png',0,'9khfkc6w1dcs8rrc9pdlp8gftu48mj7'),(544,'Aviary-Pagoda-by-siukin.JPG','20040327125411!Aviary_Pagoda_by_siukin.JPG',522385,1458,1944,8,'Aviary Pagoda',45221,'58siukin Wong','20040222180925','0','BITMAP','image','jpeg',0,'s6zzeicygwfz2m4f7pmhjxtm0op4cak'),(545,'Yuen-Long-West-Rail-Station-by-siukin.JPG','20040327125801!Yuen_Long_West_Rail_Station_by_siukin.JPG',434152,1944,1458,8,'Yuen Long West Rail Station',45221,'58siukin Wong','20040222172542','0','BITMAP','image','jpeg',0,'pzdxt1lxsft9vg51ydlqkchnlvefqi2'),(546,'Yuen-Long-West-Rail-Station-out.JPG','20040327125825!Yuen_Long_West_Rail_Station_out.JPG',576775,1944,1458,8,'Out looking of Yuen Long West Rail Station',45221,'58siukin Wong','20040222171336','0','BITMAP','image','jpeg',0,'45dbxg3exwvan0pjd5saz1q0qr55hus'),(547,'Climb.rj145.arp.750pix.jpg','20040327231140!Climb.rj145.arp.750pix.jpg',99198,750,561,8,'Climb',7095,'Arpingstone','20040327223535','a:34:{s:16:\"ImageDescription\";s:31:\"OLYMPUS DIGITAL CAMERA         \";s:4:\"Make\";s:19:\"OLYMPUS CORPORATION\";s:5:\"Model\";s:6:\"C750UZ\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:9:\"v753u2-86\";s:8:\"DateTime\";s:19:\"2004:03:21 12:27:23\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:8:\"10/10000\";s:7:\"FNumber\";s:5:\"56/10\";s:15:\"ExposureProgram\";i:4;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:03:21 12:27:23\";s:17:\"DateTimeDigitized\";s:19:\"2004:03:21 12:27:23\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"38/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:6:\"630/10\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:5:\"0/100\";s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'ah9piol7gzas2h6q7a0gtmejdqie1q8'),(548,'Benjaminfranklin.jpg','20040328010556!Benjaminfranklin.jpg',17162,300,366,8,'making smaller, too big',3853,'Mbecker','20030523042532','0','BITMAP','image','jpeg',0,'qke5ei6fpaf19til8867u3a21v2fkf4'),(549,'Benjaminfranklin.jpg','20040328010635!Benjaminfranklin.jpg',16006,294,359,8,'touched up, resized version of original - only slightly larger with much better quality',47960,'Guanaco','20040328010556','0','BITMAP','image','jpeg',0,'ssiuzv0wac8b7kgwjmz1x92nkdbtu3k'),(550,'B-42-Mixmaster.jpg','20040328124316!B-42_Mixmaster.jpg',22136,428,150,8,'B-42 Mixmaster',19833,'Morven','20040328123923','0','BITMAP','image','jpeg',0,'5dkrxkw0vwzhgsvzr7jmthk40kbj30t'),(551,'SonicTheHedgehog1.png','20040328160502!SonicTheHedgehog1.png',14521,320,224,8,'Sonic The Hedgehog (first) ingame screenshot',52703,'Graffity','20040324074224','0','BITMAP','image','png',0,'pi70idnvc8856bppo2uah4iyzbhxfjv'),(552,'Timeline-WW2-Pacific-Theatre.png','20040328202532!Timeline_WW2_Pacific_Theatre.png',17283,1190,600,4,'generated myself with EasyTimeline',4691,'Erik Zachte','20040326200408','0','BITMAP','image','png',0,'2gw22u09qf72flkliszo5yyvmt02cxc'),(553,'Argentina-BA-Hierba-Mate.jpg','20040328205633!Argentina-BA-Hierba_Mate.jpg',17105,360,480,8,'Hierba Mate from Argentina',6307,'Chmouel','20040206014923','a:7:{s:11:\"Orientation\";i:1;s:8:\"Software\";s:27:\"ACD Systems Digital Imaging\";s:8:\"DateTime\";s:19:\"2004:02:06 02:49:29\";s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:10:\"SubSecTime\";s:3:\"110\";s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'8l0zsul9cglgyonlfffvfa0tksflwy6'),(554,'Baby-with-mum.jpg','20040329000611!Baby-with-mum.jpg',50626,700,622,8,'Baby with her mum',6307,'Chmouel','20040328221040','a:38:{s:4:\"Make\";s:8:\"FUJIFILM\";s:5:\"Model\";s:17:\"FinePix S602 ZOOM\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:27:\"ACD Systems Digital Imaging\";s:8:\"DateTime\";s:19:\"2004:03:29 00:09:20\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:7:\"10/3400\";s:7:\"FNumber\";s:7:\"400/100\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:200;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:03:17 13:50:40\";s:17:\"DateTimeDigitized\";s:19:\"2004:03:17 13:50:40\";s:22:\"CompressedBitsPerPixel\";s:5:\"40/10\";s:17:\"ShutterSpeedValue\";s:7:\"840/100\";s:13:\"ApertureValue\";s:7:\"400/100\";s:15:\"BrightnessValue\";s:7:\"638/100\";s:17:\"ExposureBiasValue\";s:5:\"0/100\";s:16:\"MaxApertureValue\";s:7:\"300/100\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:8:\"4680/100\";s:10:\"SubSecTime\";s:3:\"992\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:6:\"1674/1\";s:21:\"FocalPlaneYResolution\";s:6:\"1671/1\";s:24:\"FocalPlaneResolutionUnit\";i:3;s:13:\"SensingMethod\";i:2;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"SceneCaptureType\";i:0;s:9:\"Sharpness\";i:3;s:20:\"SubjectDistanceRange\";i:3;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'6umlwjatl6zn7suo9d1hf88pd6xflbx'),(555,'Alpha-D-glucose-6-phosphate.png','20040329011653!Alpha-D-glucose_6-phosphate.png',3317,208,169,8,'alpha-D-glucose 6-phosphate',51395,'Delta G','20040326033503','0','BITMAP','image','png',0,'r3nur56ci0vdx3y6ypk3z073h4eu04n'),(556,'Alpha-D-glucose-6-phosphate.png','20040329011913!Alpha-D-glucose_6-phosphate.png',2063,113,135,8,'Haworth projection of alpha-D-glucose 6-phosphate',51395,'Delta G','20040329011658','0','BITMAP','image','png',0,'bulyugfecw0da082hlo0qux7afx9b2i'),(557,'Alpha-D-glucose-6-phosphate.png','20040329011953!Alpha-D-glucose_6-phosphate.png',2063,113,135,8,'',51395,'Delta G','20040329011920','0','BITMAP','image','png',0,'bulyugfecw0da082hlo0qux7afx9b2i'),(558,'Alpha-D-glucose-6-phosphate.png','20040329012700!Alpha-D-glucose_6-phosphate.png',0,0,0,0,'',51395,'Delta G','20040329011953','','TEXT','text','plain',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(559,'ExplodingSheep.png','20040329024449!ExplodingSheep.png',2157,141,54,8,'Exploding Sheep example {{msg:PD}}',3628,'Hephaestos','20040328044200','0','BITMAP','image','png',0,'azij994atnqe55l1bq7rfz4dyqwlvz7'),(560,'Scot1975Clackmannan.png','20040329115821!Scot1975Clackmannan.png',59861,400,458,8,'Clackmannan district',55077,'Keith Edkins','20040329115633','0','BITMAP','image','png',0,'s4uluhq6c3o4m8kd6z81oexuj1dnsmf'),(561,'Scot1975Clackmannan.png','20040329115912!Scot1975Clackmannan.png',59861,400,458,8,'Clackmannan District',55077,'Keith Edkins','20040329115821','0','BITMAP','image','png',0,'s4uluhq6c3o4m8kd6z81oexuj1dnsmf'),(562,'Scot1975BanffBuchan.png','20040329131024!Scot1975BanffBuchan.png',59583,400,458,8,'Banff and Buchan District',55077,'Keith Edkins','20040329130839','0','BITMAP','image','png',0,'diiw78qh6rhve0oyhm97y6rexbhywhu'),(563,'Scot1975CumDoon.png','20040329145951!Scot1975CumDoon.png',30409,200,229,8,'Cumnock and Doon Valley District',55077,'Keith Edkins','20040329145259','0','BITMAP','image','png',0,'5y74n2buwxdkaueqss2bet3f18lye31'),(564,'Gov1848.png','20040329180019!Gov1848.png',3261,479,267,4,'Power structure of United Canada in 1848',28794,'Mathieugp','20040329175000','0','BITMAP','image','png',0,'etk5pxke9qy2t0kqm56xmyut4hul8gj'),(565,'Rush-roll-the-bones.jpg','20040330052939!Rush_roll_the_bones.jpg',12995,250,249,8,'Rush - \"Roll the Bones\" album cover',27822,'RedWolf','20031201041225','0','BITMAP','image','jpeg',0,'eap4tsd1olm27ge3y3dhdlif1klmvem'),(566,'Scot1975EttLaud.png','20040330081142!Scot1975EttLaud.png',30408,200,229,8,'Ettrich & Lauderdale district',55077,'Keith Edkins','20040329094932','0','BITMAP','image','png',0,'cuxta5dj4y16mjvxaigg161cdrekhsa'),(567,'Scot1975Roxburgh.png','20040330081219!Scot1975Roxburgh.png',30457,200,229,8,'Roxburgh District',55077,'Keith Edkins','20040329100810','0','BITMAP','image','png',0,'09hl37o0hurwpemp69tq2ecv7ubpyl1'),(568,'Scot1975AnnEsk.png','20040330081250!Scot1975AnnEsk.png',30408,200,229,8,'Annandale & Eskdale District',55077,'Keith Edkins','20040329102424','0','BITMAP','image','png',0,'l800qja9di2sm3c5m86l9jzio3pkpol'),(569,'Scot1975Nithsdale.png','20040330081335!Scot1975Nithsdale.png',30402,200,229,8,'Nithsdale District',55077,'Keith Edkins','20040329103541','0','BITMAP','image','png',0,'1wv266v2tfzm4t0ccbpcvlk2tz09rx7'),(570,'Scot1975Stewartry.png','20040330081403!Scot1975Stewartry.png',30335,200,229,8,'Stewartry District',55077,'Keith Edkins','20040329104848','0','BITMAP','image','png',0,'lzsghhycfh2q4llo683rc3vptniu0hq'),(571,'Scot1975Wigtown.png','20040330081437!Scot1975Wigtown.png',30344,200,229,8,'Wigtown District',55077,'Keith Edkins','20040329105449','0','BITMAP','image','png',0,'hczoabktalykr5q2euqahhdp9msy07a'),(572,'Scot1975Dunfermline.png','20040330081511!Scot1975Dunfermline.png',30407,200,229,8,'Dunfermline District',55077,'Keith Edkins','20040329110852','0','BITMAP','image','png',0,'aik0vf3juq5dbmiscypqec1n8zlsx3o'),(573,'Scot1975NEFife.png','20040330081608!Scot1975NEFife.png',30407,200,229,8,'North-East Fife District',55077,'Keith Edkins','20040329111541','0','BITMAP','image','png',0,'pihgo78z3p6dpacbdi5enmbz6sev4tn'),(574,'Scot1975Clackmannan.png','20040330081639!Scot1975Clackmannan.png',30392,200,229,8,'Clackmannan District ',55077,'Keith Edkins','20040329115912','0','BITMAP','image','png',0,'1jlo3vnmyug58yd606mddw5feksy9o1'),(575,'Scot1975KyleCarrick.png','20040330101235!Scot1975KyleCarrick.png',30396,200,229,8,'Kyle and Carrick District',55077,'Keith Edkins','20040330100519','0','BITMAP','image','png',0,'fi8uyxxxpcizgp82adprtm8x7o32u3o'),(576,'Preikestolen.jpg','20040330165625!Preikestolen.jpg',21510,300,400,8,'Picture of preikestolen, Norway',7378,'Torge','20030123143556','0','BITMAP','image','jpeg',0,'rvoyk93tjn3pp9r32j6dw9wty8qchun'),(577,'Arna.png','20040330201342!Arna.png',0,0,0,0,'Map of the Hellenic peninsula, showing location of the Village of Arna, Greece',55969,'Sysin','20040330201010','0','BITMAP','image','png',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(578,'Bison-Drawing-historic.jpg','20040330210815!Bison_Drawing_historic.jpg',42466,640,540,8,'Drawing of a bison, German Brockhaus Konversations-Lexikon from 1895, GFDL due to old age',55101,'SebastianBreier','20040330204944','0','BITMAP','image','jpeg',0,'kmqnlo1qcwfr8afyhr2t6yft4twfg5e'),(579,'ScotlandRoxEtt.png','20040331081821!ScotlandRoxEtt.png',30414,200,229,8,'Roxburgh, Ettrick and Lauderdale Lieutenancy',55077,'Keith Edkins','20040330144651','0','BITMAP','image','png',0,'o0z74wrqch6vmzibpc7wqn3wkqrg5o5'),(580,'ScotlandAyrshireAndArran.png','20040331081933!ScotlandAyrshireAndArran.png',24289,200,229,8,'Ayrshire & Arran lieutenancy',55077,'Keith Edkins','20040326140357','0','BITMAP','image','png',0,'srhldv6mcc0osk37vm7238laijrfqyr'),(581,'PinkFloyd-London-66-67.jpg','20040331103042!PinkFloyd_London_66_67.jpg',19540,300,300,8,'Pink Floyd London \'66-\'67 album cover {{msg:fairuse}}',54496,'Auximines','20040331102913','0','BITMAP','image','jpeg',0,'qtx5x3dlae0d08682g36vg4pr35cuce'),(582,'Usinprogress.PNG','20040331192711!Usinprogress.PNG',38951,280,183,8,'',35314,'Seth Ilys','20040326161707','0','BITMAP','image','png',0,'hthkhc8i6w08ozjz6n6h9dig8dnbdkq'),(583,'USAirF.insignia.e9comm.afmil.png','20040331221054!USAirF.insignia.e9comm.afmil.png',0,0,0,0,'',44261,'Wguynes','20040331220827','0','BITMAP','image','png',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(584,'USAirF.insignia.e9comm.afmil.png','20040331221837!USAirF.insignia.e9comm.afmil.png',53415,980,1500,8,'',44261,'Wguynes','20040331221054','0','BITMAP','image','png',0,'t4n5hrjj0vj4uv119ptxmw1e00peh5y'),(585,'ExplodingSheep.png','20040331234838!ExplodingSheep.png',10684,615,245,8,'fine then.',3628,'Hephaestos','20040329024449','0','BITMAP','image','png',0,'e2q1o6lq5omi3zl2xbnseo6tafyk9ey'),(586,'EMU-Spacesuit.jpg','20040401003807!EMU_Spacesuit.jpg',281505,640,643,8,'The Extra-vechicular Mobility Unit (EMU) Spacesuit used in the Shuttle program',13480,'Skylark of Space','20040322182913','0','BITMAP','image','jpeg',0,'ozkvnbw70hylexjvycsqtcqgsuv7lfu'),(587,'EMU-Spacesuit.jpg','20040401003952!EMU_Spacesuit.jpg',10495,250,332,8,'Cropped and resized image',13480,'Skylark of Space','20040401003807','0','BITMAP','image','jpeg',0,'h35klhwbpsutvn08ieyeyll9v7z411t'),(588,'Ibuprofen.png','20040401054442!Ibuprofen.png',3201,202,258,8,'Ibuprofen structure',20762,'Prisonblues','20040316191828','0','BITMAP','image','png',0,'lsdlxtahxpa8se0kg4bxsjhhnc42gz1'),(589,'Ibuprofen.png','20040401054614!Ibuprofen.png',765,354,148,1,'Quick CORRECT drawing of Ibuprofen structure',8190,'Rboatright','20040401054442','0','BITMAP','image','png',0,'bu94z9ditjjg69kf4xxngedlulhu5zp'),(590,'Ibuprofen.png','20040401054643!Ibuprofen.png',765,354,148,1,'Quick CORRECT drawing of Ibuprofen structure',8190,'Rboatright','20040401054614','0','BITMAP','image','png',0,'bu94z9ditjjg69kf4xxngedlulhu5zp'),(591,'Davisonpeter.jpg','20040401073058!Davisonpeter.jpg',5966,113,150,8,'>>squished<< horizontally to produce a more realistic aspect',44416,'Gus Polly','20040318230835','0','BITMAP','image','jpeg',0,'174i9leox856gihavlg6rh568eitm8t'),(592,'Davisonpeter.jpg','20040401073146!Davisonpeter.jpg',39312,311,449,8,'',49505,'Senor Spielbergo','20040401073059','0','BITMAP','image','jpeg',0,'47rdy20cpsxxcvehn8qghi268ee0ozs'),(593,'Tel-el-Saba-October-31-1917.png','20040401133928!Tel_el_Saba_October_31_1917.png',43081,600,731,8,'map',646,'Gsl','20040309120732','0','BITMAP','image','png',0,'nlthjco370bo80yr0vwz0pomn2w2may'),(594,'Dhs-seal.jpg','20040402071349!Dhs_seal.jpg',3642,100,100,8,'The new Homeland Security seal.',12927,'Saint-Paddy','20030623161853','0','BITMAP','image','jpeg',0,'4th9y5wmnxx8d4x5rnrtdxds6emnkdb'),(595,'Wpdms-usgs-photo-whale-cove-oregon.jpg','20040402071403!Wpdms_usgs_photo_whale_cove_oregon.jpg',65930,370,350,8,'[[Whale Cove (Oregon)|Whale Cove]]  &#169; 2004 Matthew Trump Based on [[USGS]] aerial photo. {{msg:GFDL}}',37527,'Decumanus','20040401223049','0','BITMAP','image','jpeg',0,'q6pf7vjx3hb7flgd87lkf29xcohlpe5'),(596,'Seebeck-effect.png','20040402194738!Seebeck_effect.png',4628,310,201,8,'I made this.  It is public domain.  See my page for details.',18931,'Omegatron','20040402164039','0','BITMAP','image','png',0,'t1ccqtq45va6x7116qmryn75dj17jr1'),(597,'Pnp-transistor.png','20040402194846!Pnp-transistor.png',2785,233,164,8,'pnp-transistor',56687,'Armandino','20040401185742','0','BITMAP','image','png',0,'ou0b6fyjtguplyr1pu41ksubkwze957'),(598,'Pnp-transistor.png','20040402195224!Pnp-transistor.png',7525,376,196,8,'',56687,'Armandino','20040402194846','0','BITMAP','image','png',0,'49wj01vq8clfk9cfmory6l8ie11j2gi'),(599,'Pnp-transistor.png','20040402195350!Pnp-transistor.png',7525,376,196,8,'',56687,'Armandino','20040402195224','0','BITMAP','image','png',0,'49wj01vq8clfk9cfmory6l8ie11j2gi'),(600,'Sportsman-urn.jpg','20040403043826!Sportsman_urn.jpg',2328,78,97,8,'Sports Illustrated \"Sportsman of the Year\" trophy',27288,'Rdikeman','20040403043523','0','BITMAP','image','jpeg',0,'toxc2cplp1na2ftr76ft9dpyga40s7q'),(601,'Sportsman-urn.jpg','20040403044739!Sportsman_urn.jpg',2165,78,97,8,'',27288,'Rdikeman','20040403043826','0','BITMAP','image','jpeg',0,'3oknbkzxh34xljvvsnlf58o5p4rsajj'),(602,'Sportsman-urn.jpg','20040403050753!Sportsman_urn.jpg',7509,78,97,8,'',27288,'Rdikeman','20040403044739','0','BITMAP','image','jpeg',0,'pjj69gam473fztmq4ohxb55hnz3s7wd'),(603,'Tiberi-01.jpg','20040404064323!Tiberi_01.jpg',49093,600,460,8,'Emperor Tiberius',56885,'GeneralPatton','20040403115933','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"200/1\";s:11:\"YResolution\";s:5:\"200/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:04:03 13:58:16\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'rpfm7gvk92as2skmenvnmm7a4j03cpk'),(604,'St3153c1.gif','20040404165038!St3153c1.gif',0,0,0,0,'Image of single atomic zig-zag chain of Cs atoms (red) on the GaAs(110) surface. NASA {{msg:PD}} ',44378,'Perl','20040404164956','0','BITMAP','image','gif',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(605,'Hist-central-europe.jpg','20040404185410!Hist_central_europe.jpg',38618,459,339,8,'Historical regions of Central Europe',48983,'Kpalion','20040404140334','0','BITMAP','image','jpeg',0,'qgf2hsczd3vpbwxjg7ukwk200rp2x1s'),(606,'Hist-central-europe.jpg','20040404185455!Hist_central_europe.jpg',39191,459,339,8,'{{msg:PD}}',48983,'Kpalion','20040404185410','0','BITMAP','image','jpeg',0,'pt518g483n273ebl5udmzczqhh41ko5'),(607,'Hist-central-europe.jpg','20040404185520!Hist_central_europe.jpg',39191,459,339,8,'{{msg:PD}}',48983,'Kpalion','20040404185456','0','BITMAP','image','jpeg',0,'pt518g483n273ebl5udmzczqhh41ko5'),(608,'Hist-central-europe.jpg','20040404185648!Hist_central_europe.jpg',39191,459,339,8,'{{msg:PD}}',48983,'Kpalion','20040404185520','0','BITMAP','image','jpeg',0,'pt518g483n273ebl5udmzczqhh41ko5'),(609,'Hist-central-europe.jpg','20040404192307!Hist_central_europe.jpg',39191,459,339,8,'',48983,'Kpalion','20040404185648','0','BITMAP','image','jpeg',0,'pt518g483n273ebl5udmzczqhh41ko5'),(610,'Hist-central-europe.jpg','20040404192955!Hist_central_europe.jpg',39194,459,339,8,'',48983,'Kpalion','20040404192307','0','BITMAP','image','jpeg',0,'tnoz3blhr3evmoh83ljzvu7e1f6lg34'),(611,'Collins.jpg','20040405033346!Collins.jpg',12269,123,116,8,'',3091,'Akir','20020729052351','0','BITMAP','image','jpeg',0,'cen3ls65f150pxhyh3ml79q79qwbwoz'),(612,'Collins.jpg','20040405033409!Collins.jpg',20383,227,410,8,'1910 E104 baseball card of Eddie Collins, from the Library of Congress website. Public domain.',32383,'Andrew Levine','20040405033346','0','BITMAP','image','jpeg',0,'3hdxumlsj5xaqvvavyf0plalsyo1loc'),(613,'Thesnowman.jpg','20040405090325!Thesnowman.jpg',1650,60,80,8,'smaller',6175,'Taras','20021219211255','0','BITMAP','image','jpeg',0,'a7caa4kemg5gucz57l0jpfs2c8e760i'),(614,'Many-Karelias.png','20040405163241!Many_Karelias.png',99857,500,664,8,'Traditional divisions of Karelia',8534,'Jniemenmaa','20040403131023','0','BITMAP','image','png',0,'k8kdvujqixtcbmg60mi1m2r77pd05u2'),(615,'CentipedevsSpider.jpg','20040406073046!CentipedevsSpider.jpg',63350,900,526,8,'rm vertigo',3628,'Hephaestos','20040316012853','0','BITMAP','image','jpeg',0,'01wqmhv5hks0lpw19x4b9jitisljdcm'),(616,'CentipedevsSpider.jpg','20040406073127!CentipedevsSpider.jpg',153455,900,526,8,'Reverted to earlier revision',51418,'Drasil','20040406073047','a:25:{s:4:\"Make\";s:5:\"NIKON\";s:5:\"Model\";s:4:\"E950\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:01:05 17:38:54\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/600\";s:7:\"FNumber\";s:5:\"39/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:80;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:01:03 09:27:15\";s:17:\"DateTimeDigitized\";s:19:\"2004:01:03 09:27:15\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"26/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:1;s:11:\"FocalLength\";s:6:\"190/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'e5th1w77a0llw0hzm4q4dwd4fb0wmwr'),(617,'Tower.airtraffic.500pix.jpg','20040406153500!Tower.airtraffic.500pix.jpg',95782,1384,1752,8,'ATC Tower',7095,'Arpingstone','20040406153033','a:26:{s:16:\"ImageDescription\";s:31:\"OLYMPUS DIGITAL CAMERA         \";s:4:\"Make\";s:23:\"OLYMPUS OPTICAL CO.,LTD\";s:5:\"Model\";s:13:\"C3100Z,C3020Z\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:7:\"v374-74\";s:8:\"DateTime\";s:19:\"0000:00:00 00:00:00\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/6500\";s:7:\"FNumber\";s:5:\"80/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"0000:00:00 00:00:00\";s:17:\"DateTimeDigitized\";s:19:\"0000:00:00 00:00:00\";s:22:\"CompressedBitsPerPixel\";s:3:\"1/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"30/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:6:\"104/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'ca4bvbtfrtxrmnv72q01pxg4x9msnr2'),(618,'Cellcycle-and-growth.png','20040406160523!Cellcycle_and_growth.png',20479,544,219,8,'The relationship between cell division and cell size.',8773,'JWSchmidt','20040402050503','0','BITMAP','image','png',0,'l5utof142cgdzoayiuci2omgxwzehly'),(619,'Flamethrower768.jpg','20040406211120!Flamethrower768.jpg',152956,919,768,8,'Flamethrower in World War 2.  USMC photo, B&W.',18084,'Tempshill','20040406210407','a:19:{s:10:\"ImageWidth\";i:1728;s:11:\"ImageLength\";i:1152;s:11:\"Compression\";i:1;s:25:\"PhotometricInterpretation\";i:2;s:4:\"Make\";s:5:\"Kodak\";s:12:\"StripOffsets\";i:50080;s:11:\"Orientation\";i:1;s:15:\"SamplesPerPixel\";i:3;s:12:\"RowsPerStrip\";i:1152;s:15:\"StripByteCounts\";i:5971968;s:11:\"XResolution\";s:5:\"0/100\";s:11:\"YResolution\";s:5:\"0/100\";s:19:\"PlanarConfiguration\";i:1;s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:52:\"KODAK PROFESSIONAL DCS Photo Desk JPEG Export v3.1 W\";s:8:\"DateTime\";s:19:\"2003:08:14:16:52:57\";s:16:\"DateTimeOriginal\";s:19:\"2003:08:14:16:52:57\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'eabgd6hof2b8ldu56a8y9z60ze8nym0'),(620,'Foucault-Test-1.png','20040406224700!Foucault-Test_1.png',57091,1000,415,8,'Foucault-Test Setup diagram',45336,'Wikibob','20040406221955','0','BITMAP','image','png',0,'9eo0ai5iplpytcfxdkwn83jib0kvygl'),(621,'Beta-carotene.png','20040406225213!Beta-carotene.png',4701,776,151,8,'Beta-carotene chemical structure',51395,'Delta G','20040406054825','0','BITMAP','image','png',0,'0xcmwt2eazm8uzk8joqmy9eflva4yhw'),(622,'BuckinghamshireNumbered.png','20040406232018!BuckinghamshireNumbered.png',18000,200,282,8,'reupload',17287,'Morwen','20040208104802','0','BITMAP','image','png',0,'hjelfiasono85nfiool7n1fiy4ridq7'),(623,'Lycopene.png','20040406232514!Lycopene.png',3073,1115,74,8,'Chemical structure of lycopene',51395,'Delta G','20040406232017','0','BITMAP','image','png',0,'2e3wbmmultie7z29ers06o3ijn266gh'),(624,'Lycopene.png','20040406232626!Lycopene.png',3073,1115,74,8,'Chemical structure of lycopene (smaller than previous)',51395,'Delta G','20040406232514','0','BITMAP','image','png',0,'2e3wbmmultie7z29ers06o3ijn266gh'),(625,'STilden.JPG','20040406233611!STilden.JPG',31148,171,263,8,'',35792,'AmericanCentury21','20040406233300','0','BITMAP','image','jpeg',0,'6cb9fo6nb0op85r6zvlnq9vwgdchkjn'),(626,'GeorgiaTechStudentCenterSidewalk.jpg','20040407010753!GeorgiaTechStudentCenterSidewalk.jpg',114324,640,480,8,'Sidewalk in front of Georgia Tech\'s Student Center.',13476,'Dcoetzee','20040407010708','a:23:{s:16:\"ImageDescription\";s:20:\"Intel Digital Camera\";s:4:\"Make\";s:30:\"Intel(R) Pocket Digital Camera\";s:5:\"Model\";s:5:\"CS780\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:04:06 21:04:51\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:5:\"1/120\";s:7:\"FNumber\";s:5:\"80/10\";s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"0000:00:00 00:00:00\";s:17:\"DateTimeDigitized\";s:19:\"0000:00:00 00:00:00\";s:22:\"CompressedBitsPerPixel\";s:5:\"16/10\";s:16:\"MaxApertureValue\";s:5:\"30/10\";s:12:\"MeteringMode\";i:1;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:7:\"646/100\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'2009cnucpf11g2vd5f5n3qradf2fsw1'),(627,'Pythagorean-proof.png','20040407020626!Pythagorean_proof.png',10870,274,165,8,'Two-square visual proof of the Pythagorean theorem',29360,'Jellyvista','20031106160825','0','BITMAP','image','png',0,'ob8y624ylswp76ut3714frqjgrzfpce'),(628,'US-population-center-700px-Bkell.png','20040407040841!US_population_center_700px_Bkell.png',142470,700,385,8,'my map of the mean population center of the United States over time',32452,'Bkell','20040407040014','0','BITMAP','image','png',0,'lvqsv8act9r9of1ilv6mmhpgvgxd6np'),(629,'Oak-Sphericon-1.jpg','20040407131356!Oak_Sphericon_1.jpg',14089,256,247,8,'Oak Sphericon 1',57171,'Proberts2003','20040407130917','0','BITMAP','image','jpeg',0,'dzl4yh87gw8nbnkjnp9rvyucxnwbs0v'),(630,'Cortisol.png','20040407203403!Cortisol.png',1911,379,192,1,'Molecular diagram of cortisol',48992,'Eric22','20040305022328','0','BITMAP','image','png',0,'srirxv0ax3dad71ykh8p185956wwsrb'),(631,'Centipede-anterior.jpg','20040408023836!Centipede_anterior.jpg',65511,576,396,8,'Close up of centipede head and first segments',16734,'Marshman','20040408023621','a:25:{s:4:\"Make\";s:5:\"NIKON\";s:5:\"Model\";s:4:\"E950\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:04:07 16:35:36\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/440\";s:7:\"FNumber\";s:5:\"39/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:80;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2002:01:05 10:13:49\";s:17:\"DateTimeDigitized\";s:19:\"2002:01:05 10:13:49\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"26/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:6:\"190/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'szi0chwbzksqtmrnceqep42kpgyvye0'),(632,'Wpdms-usgs-photo-sacramento-delta.jpg','20040408070538!Wpdms_usgs_photo_sacramento_delta.jpg',190554,700,520,8,'[[Sacramento Delta]] &#169; 2004 Matthew Trump {{msg:GFDL}}',37527,'Decumanus','20040408070259','0','BITMAP','image','jpeg',0,'okamoz1ojywfuii6qt27irc8734s401'),(633,'Many-Karelias.png','20040408121103!Many_Karelias.png',93801,500,664,8,'update',8534,'Jniemenmaa','20040405163246','0','BITMAP','image','png',0,'80ij42whfpwrrbp6ifn5d1292b28vhm'),(634,'Pigadhes.jpg','20040408182337!Pigadhes.jpg',54401,300,390,8,'Late Bronze Age Sanctuary of Myrtou-Pigadhes, TRNC in 2002',43015,'Yak','20040408182021','0','BITMAP','image','jpeg',0,'tft02ami2g38us9by9q60etlg6xgih5'),(635,'Dichroic-prism.png','20040408210146!Dichroic-prism.png',12460,300,291,8,'Dichroic prisms as used in a camcorder; {{msg:GFDL}}',2251,'DrBob','20040408180527','0','BITMAP','image','png',0,'arew2vv4kptz9l5wy2ulpfx54m0j6rj'),(636,'ChrisDJackson.jpg','20040408225933!ChrisDJackson.jpg',60365,202,254,8,'',35792,'AmericanCentury21','20040306234833','0','BITMAP','image','jpeg',0,'co3vxtb643bij8aikjdepvzsjtp89m3'),(637,'ChrisDJackson.jpg','20040408230122!ChrisDJackson.jpg',12515,202,254,8,'',35792,'AmericanCentury21','20040408225933','0','BITMAP','image','jpeg',0,'e0pnal0qrdmgmt361d8b69j3sdjgedr'),(638,'Pigadhes.jpg','20040409161031!Pigadhes.jpg',54401,300,390,8,'Myrtou-Pigadhes, Late Bronze Age Sanctuary, TRNC 2002',43015,'Yak','20040408182337','0','BITMAP','image','jpeg',0,'tft02ami2g38us9by9q60etlg6xgih5'),(639,'NormColeman.jpg','20040410030922!NormColeman.jpg',7724,86,95,8,'Public Domain image of Senator Norm Coleman from http:/ / drugcaucus.senate.gov/ ',12070,'Mulad','20040131070734','0','BITMAP','image','jpeg',0,'crpag299viqenv4k65m6gb5ckunenzv'),(640,'Gy-map.png','20040410051128!Gy-map.png',10779,329,706,4,'Map of Guyana from the 2002 CIA Factbook',488,'Scipius','20030413111908','0','BITMAP','image','png',0,'pcsse9o2ypc4jcyqower8a6e4ni9ror'),(641,'Nl-map.png','20040410085506!Nl-map.png',184229,350,447,8,'slightly smaller',16445,'Vancouverguy','20031116004418','0','BITMAP','image','png',0,'lwjobe49bfyl34yjepmt6d6pe66bv90'),(642,'Nl-map.png','20040410085552!Nl-map.png',9906,330,355,4,'map of the Netherlands, converted directly from CIA World Factbook GIF',32452,'Bkell','20040410085506','0','BITMAP','image','png',0,'g9kubt5fyli1zis8oxjn2zauqcjuonm'),(643,'Nu-map.png','20040410091111!Nu-map.png',275098,700,614,8,'Map of Nunavut (created through Online Map Creation, public domain, and altered by Montrealais)',3378,'Montrealais','20031016041017','0','BITMAP','image','png',0,'j01nvljhrhtb1w0lxkg29fze5ofiyik'),(644,'Nu-map.png','20040410091125!Nu-map.png',12140,330,353,4,'map of Nicaragua, converted directly from CIA World Factbook GIF',32452,'Bkell','20040410091112','0','BITMAP','image','png',0,'agevwwb9ngsr8ala6fiujt67dvwp39i'),(645,'Balkans-political-map-small.png','20040410142216!Balkans-political-map-small.png',39411,304,257,8,'removed rivers and country names',40609,'Sinuhe','20040227141200','0','BITMAP','image','png',0,'krve22ikddg9cotrfaff3boyzy8iixb'),(646,'Balkans-political-map-small.png','20040410142251!Balkans-political-map-small.png',46955,351,300,8,'Reverted to earlier revision',40609,'Sinuhe','20040410142216','0','BITMAP','image','png',0,'fyhlc5qkybmaip5yqndkop2igki738y'),(647,'Savoia-Marchetti-SM79.jpg','20040410144530!Savoia_Marchetti_SM79.jpg',26289,600,192,8,'',55077,'Keith Edkins','20040410141612','0','BITMAP','image','jpeg',0,'2yskr6132rzwnjwttjq5flqwdyjrzo1'),(648,'Cardiacfunctioncurve.png','20040410171516!Cardiacfunctioncurve.png',10867,349,332,8,'Human Cardiac function curve',20762,'Prisonblues','20040318184249','0','BITMAP','image','png',0,'chqgnlg8m3dz4dxbm0dkakgxze975va'),(649,'Plavix.png','20040410180543!Plavix.png',2982,479,270,8,'Chemical structure of Plavix (Clopidogrel bisulfate)',40019,'Ksheka','20040410164328','0','BITMAP','image','png',0,'esz8b27445tjapxwddj51tnq26vd7is'),(650,'The-Little-Belt-Bridge-(1935).jpeg','20040410215046!The_Little_Belt_Bridge_(1935).jpeg',88397,676,507,8,'An image of the little belt bridge',41983,'Ævar Arnfjörð Bjarmason','20040408220219','a:24:{s:16:\"ImageDescription\";s:8:\"3MegaCam\";s:4:\"Make\";s:8:\"3MegaCam\";s:5:\"Model\";s:8:\"3MegaCam\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:04:08 23:35:37\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:4:\"2/36\";s:7:\"FNumber\";s:5:\"20/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"1/11\";s:16:\"MaxApertureValue\";s:3:\"3/2\";s:12:\"MeteringMode\";i:2;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"82/11\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'tkmxcmp71pjd9o5ianba7wdjpxxpbbt'),(651,'Iron-metabolism.png','20040410221701!Iron_metabolism.png',4123,433,228,8,'Distribution of body iron stores',46555,'Jfdwolff','20040324151822','0','BITMAP','image','png',0,'jrbrt6ujkqxxvzcof84t5xcurh5r815'),(652,'ChristianHeritageNewZealandLogo.png','20040411013649!ChristianHeritageNewZealandLogo.png',9943,175,77,8,'Logo of the Christian Heritage New Zealand political party',25556,'Vardion','20031227063230','0','BITMAP','image','png',0,'ftfg1kz472rn0yon3j23rt7cnsi92db'),(653,'HI-Capitol.jpg','20040411071320!HI_Capitol.jpg',142860,800,600,8,'Honolulu Hale.  Licensed to Wikipedia by Keith Higa.  {{msg:gfdl}}',26472,'KeithH','20040411065909','0','BITMAP','image','jpeg',0,'nveyic94mlgu7ecnlm3titoz0v0enwr'),(654,'Iron-metabolism.png','20040411110017!Iron_metabolism.png',4014,417,208,8,'Distribution of body iron stores',46555,'Jfdwolff','20040410221710','0','BITMAP','image','png',0,'bhtrl7fuap2qc9ug49ub8wfzjwg8iv7'),(655,'Slifer.sk.jpg','20040411151406!Slifer.sk.jpg',11363,207,299,8,'',59213,'Setokaiba','20040411151134','0','BITMAP','image','jpeg',0,'880xdv8mqxv8q73qf24o75mwedni1vm'),(656,'Egyptsgreatest.gif','20040412013309!Egyptsgreatest.gif',13122,636,377,8,'Roman empire at its maximal extent (1085 B.C.)',58816,'Dinero','20040412012055','0','BITMAP','image','gif',0,'2ak2fmb4u5s9g1oyqt2dl351ybp8ina'),(657,'ArtemusWard.jpg','20040412023216!ArtemusWard.jpg',11951,161,219,8,'Artemus Ward, from book \"Wit and Humor of the Age\", 1901',4444,'Infrogmation','20031122020138','0','BITMAP','image','jpeg',0,'4a09az6cdnrcttg5n9djw06h9z7d6nz'),(658,'Hemoglobin-F.png','20040412153918!Hemoglobin_F.png',36662,612,522,8,'Fetal hemoglobin (white background). My snapshot of rendered version from PDB file [http:/ / www.snv.jussieu.fr/ vie/ telecharge/ pdb/ HbF-1FDH.pdb].',35331,'Diberri','20040412150114','0','BITMAP','image','gif',0,'ej7abcnqanazf0j0p7oo0kqpnupoxjc'),(659,'6489-golevka-03.jpg','20040412211638!6489_golevka-03.jpg',6277,401,401,8,'Computer model of Asteroid Golevka',57730,'The Singing Badger','20040412211638','0','BITMAP','image','jpeg',0,'43fovbsaq1o2evfoj4945o0ty6mxyvk'),(660,'Antagonist.png','20040413055353!Antagonist.png',12139,443,356,8,'Antagonists block receptors.',8773,'JWSchmidt','20040413053757','0','BITMAP','image','png',0,'4j1wevlpwxjpmwmd448i6eyawuaale4'),(661,'ScotlandCaithnessTrad.png','20040413173405!ScotlandCaithnessTrad.png',28980,200,229,8,'one of the [[traditional counties of Scotland]]',17287,'Morwen','20040124203851','0','BITMAP','image','png',0,'t4lopvmqab0kj6bg3hb14wnd2n4mto9'),(662,'Word-Gets-Around.jpg','20040413185614!Word_Gets_Around.jpg',9774,170,170,8,'',54993,'Scraggy4','20040411233610','0','BITMAP','image','jpeg',0,'fpe4bsy6vyye0zy99avs7dheyfco7ic'),(663,'80a-comparison.jpg','20040413234707!80a_comparison.jpg',21704,468,206,8,'Comparison between photograph with and without 80A blue filter',20244,'Dmetric','20040413234655','0','BITMAP','image','jpeg',0,'nid7pqnkki8s1azpn41c00tubistd2f'),(664,'Seoul-main-street-saturday-night.jpg','20040414003501!Seoul_main_street_saturday_night.jpg',663572,2272,1704,8,'market in seoul on an early sunday morning',35675,'Gwicke','20040414003102','a:23:{s:16:\"ImageDescription\";s:31:\"Tchibo   DIGITAL CAMERA        \";s:4:\"Make\";s:23:\"Tchibo   OPTICAL CO,LTD\";s:5:\"Model\";s:6:\"TCM410\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:7:\"V4-1018\";s:8:\"DateTime\";s:19:\"2001:12:00 00:00:00\";s:16:\"YCbCrPositioning\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2001:01:20 05:38:02\";s:17:\"DateTimeDigitized\";s:19:\"2001:01:20 05:38:04\";s:22:\"CompressedBitsPerPixel\";s:9:\"1050/7742\";s:17:\"ShutterSpeedValue\";s:4:\"47/8\";s:13:\"ApertureValue\";s:11:\"35055/10000\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:12:\"MeteringMode\";i:0;s:5:\"Flash\";i:1;s:11:\"FocalLength\";s:9:\"8240/1000\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'n8ypo582g4avrzbpb0z52bkd95y1iq2'),(665,'Laminar-shear-flow.PNG','20040414012229!Laminar_shear_flow.PNG',24623,420,330,8,'laminar shear-flow in a fluid',35830,'Cutler','20040209193008','0','BITMAP','image','png',0,'n6107lwmxtu2pzgs696fpbuho2lfdva'),(666,'Wexner.jpg','20040414051812!Wexner.jpg',8585,200,150,8,'Wexner centre',5522,'Pgunn','20040414040216','0','BITMAP','image','jpeg',0,'7cs2p9p117umakz46bihgfidxqfbl93'),(667,'WardhillLamon.jpg','20040416032334!WardhillLamon.jpg',7416,288,219,8,'Ward Lamon Hill, Lincoln\'s bodyguard',13774,'Dino','20040313230144','0','BITMAP','image','jpeg',0,'6gqpy5guvpux2ssk7pqdgjk8e6sgvle'),(668,'IslamAkhun.jpg','20040416225622!IslamAkhun.jpg',19922,200,353,8,'Islam Akhum Portrain',58340,'Jmclean','20040416225356','0','BITMAP','image','jpeg',0,'58e9ahhnlx0wbritil0fmg1h8dhysig'),(669,'Hartnellwilliam.jpg','20040417115316!Hartnellwilliam.jpg',13063,150,150,8,'copyright-free publicity still of William Hartnell as the Doctor',6661,'PMelvilleAustin','20031012012754','0','BITMAP','image','jpeg',0,'jwuysm0zhrnoas00p030n4vr9xaddmm'),(670,'Pertweejon.jpg','20040417115648!Pertweejon.jpg',20422,150,150,8,'copyright-free publicity still of Jon Pertwee as the Doctor',6661,'PMelvilleAustin','20031012011044','0','BITMAP','image','jpeg',0,'5ppcspba3psu0kht0uopjv9pjj9d3vr'),(671,'Bakercolin.jpg','20040417120638!Bakercolin.jpg',25453,150,150,8,'copyright-free publicity still of Colin Baker as the Doctor',6661,'PMelvilleAustin','20031012012357','0','BITMAP','image','jpeg',0,'ka4ypt4yj56w0fvwx8p7ue3m8qcp66b'),(672,'Hurricane-Alberto.png','20040418075900!Hurricane_Alberto.png',58385,720,528,8,'Hurricane Alberto via NOAA',35616,'Cyrius','20040403164413','0','BITMAP','image','png',0,'to92vbjoi5pg5jqoeqgkntq6d2ft47a'),(673,'8btheater.png','20040418083328!8btheater.png',161049,715,271,8,'Sample panels from the [[web comic]] [[8-Bit Theater]] by Brian Clevinger, used with his permission under the terms of the GNU FDL.',52,'Eloquence','20040306100515','0','BITMAP','image','png',0,'d7xy1jwfqszqdbefdpjr1zi1e8p8uwy'),(674,'DSCF0001.JPG','20040418101942!DSCF0001.JPG',17927,300,283,8,'Electric Ballroom- Taken by Stevewestinlondon',13949,'Stevewestinlondon','20030702192024','0','BITMAP','image','jpeg',0,'ri7ilkda1gkf5k25ndyptt9lnuoya8g'),(675,'DSCF0001.JPG','20040418102042!DSCF0001.JPG',35306,320,240,8,'Excalibur',58642,'Excalibur','20040418101942','a:37:{s:4:\"Make\";s:8:\"FUJIFILM\";s:5:\"Model\";s:14:\"FinePixA204   \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:19:\"1207959552/16777216\";s:11:\"YResolution\";s:19:\"1207959552/16777216\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:37:\"Digital Camera FinePixA204    Ver1.00\";s:8:\"DateTime\";s:19:\"2002:01:05 20:15:32\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:19:\"17895698/1073741824\";s:7:\"FNumber\";s:19:\"469762048/134217728\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0200\";s:16:\"DateTimeOriginal\";s:19:\"2002:01:05 20:15:32\";s:17:\"DateTimeDigitized\";s:19:\"2002:01:05 20:15:32\";s:22:\"CompressedBitsPerPixel\";s:19:\"402653184/134217728\";s:17:\"ShutterSpeedValue\";s:19:\"805306368/134217728\";s:13:\"ApertureValue\";s:19:\"483183808/134217728\";s:17:\"ExposureBiasValue\";s:3:\"0/1\";s:16:\"MaxApertureValue\";s:19:\"483183808/134217728\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:89;s:11:\"FocalLength\";s:19:\"805306368/134217728\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:16:\"322699264/262144\";s:21:\"FocalPlaneYResolution\";s:16:\"322699264/262144\";s:24:\"FocalPlaneResolutionUnit\";i:3;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"SceneCaptureType\";i:0;s:9:\"Sharpness\";i:3;s:20:\"SubjectDistanceRange\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'r5q7rh5nno1od212tj0la0n6yigbigb'),(676,'Bob-Dylan.png','20040418135846!Bob-Dylan.png',30295,345,340,8,'',60960,'Sambo','20040418133907','0','BITMAP','image','png',0,'le64nufunjyfhqpyacoolfdnmkbe1ry'),(677,'Pelliotcave.jpg','20040418155742!Pelliotcave.jpg',22513,180,180,8,'Pelliot reviews manuscripts at Tun-huang',58340,'Jmclean','20040418155511','0','BITMAP','image','jpeg',0,'6bw3nvp8nckbf7jc9y8tscu5dkv0zqv'),(678,'Poveljakb.jpg','20040418173336!Poveljakb.jpg',0,0,0,0,'Povelja kulina bana- made in 1189 so it is fair use.',50816,'Avala','20040418172934','','TEXT','text','plain',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(679,'Tryptamines.png','20040419115204!Tryptamines.png',2701,372,187,8,'[[tryptamine|Substitued tryptamines]] structural formula',60494,'Russell E','20040419103232','0','BITMAP','image','png',0,'72kix3vjurz50xs5d18640tmebvu272'),(680,'Tryptamines.png','20040419130645!Tryptamines.png',2923,395,187,8,'',60494,'Russell E','20040419115204','0','BITMAP','image','png',0,'hizp9eigbyb09l2clkleuqwy9zmb3zu'),(681,'Prisoners-and-hats.PNG','20040419173223!Prisoners_and_hats.PNG',12515,500,500,8,'diagram for [[prisoners and hats puzzle]]. Made by me in paint (oh the shame...)',35906,'Ludraman','20040416181345','0','BITMAP','image','png',0,'2dxbphflx1ykvjd9zqduizw8zq1nyyu'),(682,'Doom-mapformat-screen.png','20040419204949!Doom_mapformat_screen.png',119479,700,501,8,'',26675,'Fredrik','20040419203150','0','BITMAP','image','png',0,'8e1l13ywblnw2jfi5hmjann5n4zvomo'),(683,'AxelBoldt.jpg','20040420054235!AxelBoldt.jpg',54314,0,0,0,'In Amsterdam, and therefore happy. January 2004.',2,'AxelBoldt','20040222224155','0','BITMAP','image','jpeg',0,'s9h4tesfq7xoqdfd9873n67gy0wuxua'),(684,'Uspatent131873-1872.gif','20040420133821!Uspatent131873_1872.gif',104127,851,2108,4,'corset',9397,'Haabet','20040420102413','0','BITMAP','image','gif',0,'dizjvtg0e4cmz1knvijtcy2qxozotjh'),(685,'Mee.jpg','20040420211402!Mee.jpg',9337,283,213,8,'My husband found that I was showing too much of myself...',1752,'Anthere','20040224234539','0','BITMAP','image','jpeg',0,'tac19mx5phb2bwcdz70zulr4bq8v57e'),(686,'Mee.jpg','20040420211737!Mee.jpg',28940,255,192,8,'Reverted to earlier revision',40599,'Palapala','20040420211404','0','BITMAP','image','jpeg',0,'o6qwijehun3blq2ejrpggst4p60bat6'),(687,'Edit-Summary-2.png','20040421160306!Edit_Summary-2.png',688,504,23,8,'This is a small screenshot I made of  the Wiki\'s \"Summary field\" for [[Wikipedia:Edit summary]. This is the second version (corrected)',9938,'Rotem Dan','20030416222438','0','BITMAP','image','png',0,'e41fmeu9xez1m3pdvxgytwyjsyapfb4'),(688,'Edit-Summary-2.png','20040421160436!Edit_Summary-2.png',636,478,28,8,'Updated screenshot of the edit summary to account for changes made at [[MediaWiki:Summary]]',8551,'Angela','20040421160320','0','BITMAP','image','png',0,'sf1ueluyc33jlp5epr7ui88f0svzxp8'),(689,'NASAMOR.jpg','20040422011744!NASAMOR.jpg',40228,648,513,8,'',37647,'Sennheiser','20040203161726','0','BITMAP','image','jpeg',0,'imef0ww6anjh6tra87llsumr39n4rgs'),(690,'Short-Horned-Lizard-Range.png','20040422105854!Short_Horned_Lizard_Range.png',40686,280,183,8,'Range of the [[Short-horned Lizard]]. Created by [[User:Lupo|Lupo]] from [[:Image:Map of USA highlighting Massachusetts.png]].<br>{{msg:GFDL}}',34978,'Lupo','20040422105406','0','BITMAP','image','png',0,'hl0g9i5bypy28xuqnlbizhzm05rwg34'),(691,'Ac.charioteer.jpg','20040422114444!Ac.charioteer.jpg',278894,1200,1600,8,'',22444,'Adam Carr','20040330102119','0','BITMAP','image','jpeg',0,'ilz7zmcm9t2l00cmhoikyly81ztdc38'),(692,'Ac.charioteer.jpg','20040422114653!Ac.charioteer.jpg',49143,500,621,8,'croppeed and resized',3857,'Ericd','20040422114445','0','BITMAP','image','jpeg',0,'nnyrrlmkf69arxhk9qqdqfmn5h10fbj'),(693,'Tyramine.png','20040422140219!Tyramine.png',1592,290,106,8,'',60494,'Russell E','20040421115552','0','BITMAP','image','png',0,'imth9si9wzftby8e5hr933pun3xc1y4'),(694,'Shinto-shrine.jpg','20040422141108!Shinto_shrine.jpg',100736,783,511,8,'{{msg:PD-US}}',5399,'DopefishJustin','20040328033046','0','BITMAP','image','jpeg',0,'q68zbdky753i3nuyspzt3zu2lox9dkl'),(695,'Tryptamines.png','20040422141724!Tryptamines.png',2694,395,187,8,'',60494,'Russell E','20040419130646','0','BITMAP','image','png',0,'6nflzbi7th53u5hixdbzkp3pjwta9fi'),(696,'WPPressGaugeDetail.jpg','20040422191756!WPPressGaugeDetail.jpg',53370,510,495,8,'Mechanics of a pressure gauge, annotated',46238,'Leonard G.','20040404165316','0','BITMAP','image','jpeg',0,'kmjmie8wyoyns84b72k9qw6hdjmtsf0'),(697,'SH60B.jpeg','20040422192316!SH60B.jpeg',136279,524,301,8,'SH-60B',42901,'TDC','20040422192245','0','BITMAP','image','jpeg',0,'nmqjswxvjizenu88dkbvv4zh055u73n'),(698,'WPPressGaugeDetail.jpg','20040422192521!WPPressGaugeDetail.jpg',70754,506,495,8,'improved contrast image of pressure gauge internals',46238,'Leonard G.','20040422191758','0','BITMAP','image','jpeg',0,'k2s5klti789amfgjew9yf1411dnmuyh'),(699,'Memorial-Hall-in-Harvard-University.JPG','20040422203934!Memorial_Hall_in_Harvard_University.JPG',1049275,2032,1524,8,'I took this picture myself. This is a picture of memorial hall at Harvard.',62097,'Yanamad','20040422160751','a:35:{s:4:\"Make\";s:21:\"EASTMAN KODAK COMPANY\";s:5:\"Model\";s:32:\"KODAK CX6330 ZOOM DIGITAL CAMERA\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"230/1\";s:11:\"YResolution\";s:5:\"230/1\";s:14:\"ResolutionUnit\";i:2;s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:5:\"1/125\";s:7:\"FNumber\";s:5:\"56/10\";s:15:\"ExposureProgram\";i:2;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2003:12:02 09:38:12\";s:17:\"DateTimeDigitized\";s:19:\"2003:12:02 09:38:12\";s:17:\"ShutterSpeedValue\";s:5:\"70/10\";s:13:\"ApertureValue\";s:3:\"5/1\";s:17:\"ExposureBiasValue\";s:6:\"0/1000\";s:16:\"MaxApertureValue\";s:5:\"29/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:5:\"56/10\";s:10:\"ColorSpace\";i:1;s:13:\"ExposureIndex\";s:5:\"100/1\";s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:5:\"0/100\";s:21:\"FocalLengthIn35mmFilm\";i:37;s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:20:\"SubjectDistanceRange\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'fvcnkb65ivrko015sz9i880us1c2m11'),(700,'Coral-snake.jpg','20040422205358!Coral_snake.jpg',5250,150,100,8,'Coral snake',7580,'Ahoerstemeier','20040422205016','0','BITMAP','image','jpeg',0,'9ev0rik0i9gjqevhc2z0cvckiz3lub4'),(701,'Ems.jpg','20040423000330!Ems.jpg',3789,111,136,8,'EMS Namboodiripad',10579,'Sudhir Krishnan','20030501161203','0','BITMAP','image','jpeg',0,'m06rl1h7lb3cnmyp6vkzhtagl00lrly'),(702,'BlackBoxSample9.png','20040424004859!BlackBoxSample9.png',614,261,281,4,'Uploaded by creator (Catbar/ Brian A. Rock) {{msg:GFDL}} demo image9  for \'Black Box (game)',33032,'Catbar','20040424004700','0','BITMAP','image','png',0,'p3bv7n8gaem31h9yuz816tj080ks7qj'),(703,'BlackBoxSample9.png','20040424004958!BlackBoxSample9.png',657,261,281,4,'Uploaded by creator (Catbar/ Brian A. Rock) {{msg:GFDL}} demo image 9 for \'Black Box (game)',33032,'Catbar','20040424004859','0','BITMAP','image','png',0,'kq0a3zbu4dm965mf8v7mtzwq5d4fzt8'),(704,'BlackBoxSample9.png','20040424005211!BlackBoxSample9.png',657,261,281,4,'Uploaded by creator (Catbar/ Brian A. Rock) {{msg:GFDL}} demo image 9 for \'Black Box (game)',33032,'Catbar','20040424004958','0','BITMAP','image','png',0,'kq0a3zbu4dm965mf8v7mtzwq5d4fzt8'),(705,'AustrKelpieBlackTan1-wb.jpg','20040424115250!AustrKelpieBlackTan1_wb.jpg',125145,500,391,8,'Australian Kelpie (black & tan)',40082,'Elf','20040309021232','0','BITMAP','image','jpeg',0,'blwzo6uofu1lekabp6fvc1ep0vaud1k'),(706,'Royal-mile-edinburgh.jpg','20040424200948!Royal_mile_edinburgh.jpg',18865,288,384,8,'Royal Mile, Edinburgh',6175,'Taras','20040325190351','0','BITMAP','image','jpeg',0,'181e21goor1mpcmkg9hl279zwd17r81'),(707,'Sharks-1-bg-100801-2.jpg','20040424232102!Sharks_1_bg_100801_2.jpg',49363,800,600,8,'This file was taken from Public Domain Image Resources: http:/ / pdphoto.org/  (Public Domain Photos) on April 24, 2004 ',62617,'Latitude0116','20040424225924','0','BITMAP','image','jpeg',0,'rtizj9b7zh5hmz7582ympshv6wxh90d'),(708,'Sharks-1-bg-100801-2.jpg','20040424232151!Sharks_1_bg_100801_2.jpg',49530,1184,888,8,'',62617,'Latitude0116','20040424232104','a:37:{s:4:\"Make\";s:21:\"EASTMAN KODAK COMPANY\";s:5:\"Model\";s:37:\"KODAK EASYSHARE CX6200 DIGITAL CAMERA\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"230/1\";s:11:\"YResolution\";s:5:\"230/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"Version 1.0100 \";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:14:\"125000/1000000\";s:7:\"FNumber\";s:7:\"450/100\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:200;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:04:24 19:17:28\";s:17:\"DateTimeDigitized\";s:19:\"2004:04:24 19:17:28\";s:22:\"CompressedBitsPerPixel\";s:6:\"37/100\";s:17:\"ShutterSpeedValue\";s:7:\"300/100\";s:13:\"ApertureValue\";s:7:\"433/100\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:7:\"433/100\";s:12:\"MeteringMode\";i:2;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:7:\"499/100\";s:10:\"ColorSpace\";i:1;s:13:\"ExposureIndex\";s:5:\"200/1\";s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:4:\"0/10\";s:21:\"FocalLengthIn35mmFilm\";i:38;s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:20:\"SubjectDistanceRange\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'48xonuejpb6a3z18xke5yascxdlt30x'),(709,'Sharks-1-bg-100801-2.jpg','20040424232214!Sharks_1_bg_100801_2.jpg',49530,1184,888,8,'',62617,'Latitude0116','20040424232159','a:37:{s:4:\"Make\";s:21:\"EASTMAN KODAK COMPANY\";s:5:\"Model\";s:37:\"KODAK EASYSHARE CX6200 DIGITAL CAMERA\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"230/1\";s:11:\"YResolution\";s:5:\"230/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"Version 1.0100 \";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:14:\"125000/1000000\";s:7:\"FNumber\";s:7:\"450/100\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:200;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:04:24 19:17:28\";s:17:\"DateTimeDigitized\";s:19:\"2004:04:24 19:17:28\";s:22:\"CompressedBitsPerPixel\";s:6:\"37/100\";s:17:\"ShutterSpeedValue\";s:7:\"300/100\";s:13:\"ApertureValue\";s:7:\"433/100\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:7:\"433/100\";s:12:\"MeteringMode\";i:2;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:7:\"499/100\";s:10:\"ColorSpace\";i:1;s:13:\"ExposureIndex\";s:5:\"200/1\";s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:4:\"0/10\";s:21:\"FocalLengthIn35mmFilm\";i:38;s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:20:\"SubjectDistanceRange\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'48xonuejpb6a3z18xke5yascxdlt30x'),(710,'Sharks-1-bg-100801-2.jpg','20040424232523!Sharks_1_bg_100801_2.jpg',49363,800,600,8,'Reverted to earlier revision',62617,'Latitude0116','20040424232214','0','BITMAP','image','jpeg',0,'rtizj9b7zh5hmz7582ympshv6wxh90d'),(711,'Sharks-1-bg-100801-2.jpg','20040424232523!Sharks_1_bg_100801_2.jpg',146226,800,600,8,'',62617,'Latitude0116','20040424232527','0','BITMAP','image','jpeg',0,'rtizj9b7zh5hmz7582ympshv6wxh90d'),(712,'Sharks-1-bg-100801-2.jpg','20040424232523!Sharks_1_bg_100801_2.jpg',146226,800,600,8,'',62617,'Latitude0116','20040424233001','0','BITMAP','image','jpeg',0,'rtizj9b7zh5hmz7582ympshv6wxh90d'),(713,'Barock.jpg','20040425043314!Barock.jpg',13424,300,271,8,'Uploaded by creator (Catbar/ Brian A. Rock) {{msg:GFDL}} Picture of Catbar/ Brian A. Rock',33032,'Catbar','20040425042720','0','BITMAP','image','jpeg',0,'docvd5nliywqezbjtkl2lnp3a5ykk66'),(714,'TICKLER.png','20040425064251!TICKLER.png',1296,250,150,8,'Armstrong Oscillator Schematic',26473,'Wobbly','20040425063808','0','BITMAP','image','png',0,'65w48c9r82w380j0la6vjdafw6sksh7'),(715,'TICKLER.png','20040425064308!TICKLER.png',1296,250,150,8,'armstrong oscillator schematic',26473,'Wobbly','20040425064251','0','BITMAP','image','png',0,'65w48c9r82w380j0la6vjdafw6sksh7'),(716,'Tavastia-Proper.png','20040425085032!Tavastia_Proper.png',3167,85,100,8,'Coat of Arms, Tavastia Proper',6273,'Mic','20040422220113','0','BITMAP','image','png',0,'b9ucl7pforzd8mrrf4wctptflu9l232'),(717,'Tavastia-Proper.png','20040425085053!Tavastia_Proper.png',8325,230,400,8,' {{msg:GFDL}}',8534,'Jniemenmaa','20040425085034','0','BITMAP','image','png',0,'02kgs6jbrgl8uuhoxh8t2cwnf3qh32i'),(718,'Kylieintimateandlivealbum.jpeg','20040425155850!Kylieintimateandlivealbum.jpeg',21671,297,300,8,'album cover, kylieminogue, intimate and live',39836,'Rossrs','20040425155433','0','BITMAP','image','jpeg',0,'94s83y2qi87r2dj8ffcypskuq94qife'),(719,'Kylieintimateandlivealbum.jpeg','20040425155935!Kylieintimateandlivealbum.jpeg',21671,297,300,8,'album cover, kylieminogue, intimate and live',39836,'Rossrs','20040425155851','0','BITMAP','image','jpeg',0,'94s83y2qi87r2dj8ffcypskuq94qife'),(720,'Mekongmembersangkor.jpg','20040425200738!Mekongmembersangkor.jpg',88441,1000,500,8,'{{msg:PD}}  scan by User: Markalexander100 of 1885 engraving of the members of the French Mekong Expedition',44845,'Henry Flower','20040425200713','0','BITMAP','image','jpeg',0,'jo6i1q6pi43t8mhr2rmr0o383p2jiur'),(721,'Great-Glen-Geological-Fault.png','20040425205612!Great_Glen_Geological_Fault.png',11007,226,269,8,'Illustration of the location and slippage of the Great Glen Fault',20151,'Topbanana','20040425205213','0','BITMAP','image','png',0,'lcbxyevqloicrpvv7s3fz0snshiytzl'),(722,'ChrisDAlA.jpg','20040426000218!ChrisDAlA.jpg',20131,387,305,8,'',35792,'AmericanCentury21','20040426000002','0','BITMAP','image','jpeg',0,'sxtrdcdpjfjn4pd798fv41nz7sob7m7'),(723,'Switched-On-Bach.jpg','20040426033332!Switched_On_Bach.jpg',22869,150,152,8,'Smaller version uploaded',22254,'Bwmodular','20040309131228','0','BITMAP','image','jpeg',0,'1k4voocc6khccbjck9g7ku80gllc8gk'),(724,'Fasciculus-chemicus-frontispiece.png','20040426085837!Fasciculus_chemicus_frontispiece.png',134965,350,520,8,'Re-upload of [[:Image:Fasicuculus chemicus frontispiece.tif]] in PNG format and with correct name.<br>{{msg:PD}} (from ca. 1630)',34978,'Lupo','20040426084622','0','BITMAP','image','png',0,'tmkv32elze6y0a2telftgwgj97eygzd'),(725,'Musicians.jpg','20040426193857!Musicians.jpg',38694,402,308,8,'Reverted to earlier revision',42385,'Lupin','20040319133503','0','BITMAP','image','jpeg',0,'ceihos6mnozgf7ryhqzls835lx6mwle'),(726,'Troglitazone.png','20040426203228!Troglitazone.png',4109,466,155,8,'Troglitazone',46555,'Jfdwolff','20040414202917','0','BITMAP','image','png',0,'hwqk8wekangihnmr3fchumxaow225kd'),(727,'Rosiglitazone.png','20040426203429!Rosiglitazone.png',3488,432,127,8,'Rosiglitazone',46555,'Jfdwolff','20040414202839','0','BITMAP','image','png',0,'7n48q9mm5nau14h4oy6k76oahwepelb'),(728,'Dexamethasone.png','20040426203553!Dexamethasone.png',3576,323,262,8,'Chemical structure of dexamethasone',46555,'Jfdwolff','20040316140353','0','BITMAP','image','png',0,'las2jieicvh9un9gp6pa1ilimo2a0c7'),(729,'Spencer-Fullerton-Baird.jpg','20040427092607!Spencer_Fullerton_Baird.jpg',278926,700,1053,8,'From the [[NOAA]], source: [[http:/ / www.photolib.noaa.gov/ historic/ c&gs/ theb3396.htm]].<br>{{msg:PD}}',34978,'Lupo','20040427092136','0','BITMAP','image','jpeg',0,'kjalsyof1gm4xhvnmfb967wol7egsny'),(730,'Tryptamines.png','20040427142407!Tryptamines.png',1979,335,164,8,'',60494,'Russell E','20040422141724','0','BITMAP','image','png',0,'r473igpdaviygunxrh5f6q7xe357m9t'),(731,'Colorblindpalette.m','20040427144106!Colorblindpalette.m',2950,0,0,0,'Octave/ Mathlab program to calculate RGB values that colorblind people cannot distinguish',25806,'Hankwang','20040427140113','','UNKNOWN','unknown','unknown',0,'qgbi9ky2obvq5qpjvvj4auxlh6o8djf'),(732,'Colorblindpalette.m','20040427152535!Colorblindpalette.m',2957,0,0,0,'more contrast',25806,'Hankwang','20040427144121','','UNKNOWN','unknown','unknown',0,'o02yv6w112x5fi074n3khc3ytisly22'),(733,'Kukkurovacac.jpg','20040427193907!Kukkurovacac.jpg',2057,0,0,0,'Kukkurovaca  (For profile page)',50832,'Kukkurovaca','20040427192642','0','BITMAP','image','jpeg',0,'jdwpbglebdsop2reocjjzccmm0j1p67'),(734,'TCDD-structure.png','20040427230100!TCDD_structure.png',901,286,152,1,'reload lost picture',33032,'Catbar','20040201052717','0','BITMAP','image','png',0,'aibog3vjqjbepswv4o6eio7a4droril'),(735,'Port-rich-wigwags.jpg','20040428231959!Port_rich_wigwags.jpg',40953,286,403,8,'Dan Furtado photo from www.trainweb.org',51717,'Lucky 6.9','20040401051149','0','BITMAP','image','jpeg',0,'1gz5nx3dr03uziaqn08sm9us6rxco73'),(736,'Neihu-district-taipei.JPG','20040429033133!Neihu_district_taipei.JPG',89092,800,600,8,'Neihu District Taipei, Taiwan| Picture taken December 2000 by Allen Timothy Chang',44426,'Allentchang','20040429032240','0','BITMAP','image','jpeg',0,'891tdiv8q7xtswb08j4i9sl2orox1f9'),(737,'Timor-sea.jpg','20040429130829!Timor_sea.jpg',36820,520,260,8,'',55077,'Keith Edkins','20040428121717','0','BITMAP','image','jpeg',0,'eyif3nzt0c758le7i4rjj34w6m3ardv'),(738,'LocationEuropeanUnion15.png','20040429220144!LocationEuropeanUnion15.png',14026,250,116,8,'',17287,'Morwen','20040222173256','0','BITMAP','image','png',0,'45ymt1a3mgvzrujhsppezsxtqs4hwd9'),(739,'Schema.jpg','20040429222018!Schema.jpg',14965,298,268,8,'Schema of Constantin Brunner\'s doctrine. I made this. ',63204,'Barrett Pashak','20040429221338','0','BITMAP','image','jpeg',0,'8p9cob11udyr1r7mk1qtt1jxxsa6m9m'),(740,'Austria-hungary-blank.png','20040430022300!Austria-hungary_blank.png',58609,561,416,8,'',48983,'Kpalion','20040430001133','0','BITMAP','image','png',0,'cpfk9ziloemw8kl1yn4sagd1f8867o4'),(741,'USAr.insignia.e4.wag2.png','20040430063447!USAr.insignia.e4.wag2.png',39473,1000,1133,8,'',44261,'Wguynes','20040417083508','0','BITMAP','image','png',0,'fqt2kkg8ajqh9o95nz5tufdqq8pu3a3'),(742,'USAr.insignia.e4.wag2.png','20040430064043!USAr.insignia.e4.wag2.png',34417,1000,1133,8,'realoding to a smaller size',52361,'Joseph Dwayne','20040430063448','0','BITMAP','image','png',0,'a22rjclinhpno18dohi6hvsifz367ep'),(743,'USAr.insignia.e3.wag2.png','20040430065347!USAr.insignia.e3.wag2.png',37761,1000,1161,8,'',44261,'Wguynes','20040417083407','0','BITMAP','image','png',0,'mtvanflasrius1cegjocaejeb1ax1qd'),(744,'USAr.insignia.e2.wag2.png','20040430065856!USAr.insignia.e2.wag2.png',31935,1000,944,8,'',44261,'Wguynes','20040417083143','0','BITMAP','image','png',0,'jtg0oml22mz1vztuuodu0orcks7ub5m'),(745,'USAr.insignia.e5.wag2.png','20040430070029!USAr.insignia.e5.wag2.png',47217,1000,1323,8,'',44261,'Wguynes','20040417083751','0','BITMAP','image','png',0,'ph3v6zbh6wasf3p37l6r2efml6mk44k'),(746,'USAr.insignia.e6.wag2.png','20040430070341!USAr.insignia.e6.wag2.png',52546,1000,1543,8,'',44261,'Wguynes','20040417083856','0','BITMAP','image','png',0,'1rduc130ji26grdeobn9m44wfad7odj'),(747,'USAr.insignia.e7.wag2.png','20040430070449!USAr.insignia.e7.wag2.png',57805,1000,1709,8,'',44261,'Wguynes','20040417083951','0','BITMAP','image','png',0,'az9815xdzq7ll0oq9brvg8v1itim2rz'),(748,'USAr.insignia.e8.wag2.png','20040430070550!USAr.insignia.e8.wag2.png',62566,1000,1867,8,'',44261,'Wguynes','20040417084113','0','BITMAP','image','png',0,'6ki7jhbns5bax64gtjybwqlzl20sszd'),(749,'USAr.insignia.e8firstsgt.wag2.png','20040430070720!USAr.insignia.e8firstsgt.wag2.png',64016,1000,1867,8,'',44261,'Wguynes','20040417084216','0','BITMAP','image','png',0,'nr5jm77depcutuv3xcxpkhq9a3501a0'),(750,'USAr.insignia.e9.wag2.png','20040430070834!USAr.insignia.e9.wag2.png',63620,1000,1867,8,'',44261,'Wguynes','20040417084317','0','BITMAP','image','png',0,'gqkqzs8ng8yl1bnop2btf4w6egmx3d1'),(751,'USAr.insignia.e9comm.wag2.png','20040430070923!USAr.insignia.e9comm.wag2.png',64733,1000,1867,8,'',44261,'Wguynes','20040417084409','0','BITMAP','image','png',0,'k6m0mg6sojmtckgp85zswe8qvldgfm8'),(752,'USAr.insignia.e9sma.wag2.png','20040430071024!USAr.insignia.e9sma.wag2.png',67210,1000,1867,8,'',44261,'Wguynes','20040417084501','0','BITMAP','image','png',0,'eahubvlxv0xa22ei1ubdj6nom5007wt'),(753,'Me-Mill.jpg','20040430080305!Me_Mill.jpg',283215,1280,960,8,'Pic of myself',1052,'Vanderesch','20040429211228','a:25:{s:16:\"ImageDescription\";s:31:\"OLYMPUS DIGITAL CAMERA         \";s:4:\"Make\";s:23:\"OLYMPUS OPTICAL CO.,LTD\";s:5:\"Model\";s:12:\"C-1         \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:22:\"OLYMPUS CAMEDIA Master\";s:8:\"DateTime\";s:19:\"2001:10:29 14:30:01\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:4:\"1/30\";s:7:\"FNumber\";s:5:\"28/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:200;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2001:08:11 21:42:16\";s:17:\"DateTimeDigitized\";s:19:\"2001:08:11 21:42:16\";s:22:\"CompressedBitsPerPixel\";s:3:\"1/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:7:\"300/100\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:1;s:11:\"FocalLength\";s:7:\"450/100\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'a6s0p7xzcgunfa5lxrs4i5epmhkm7b3'),(754,'Tonsure-fx-tr.png','20040430174243!Tonsure_fx_tr.png',16826,500,464,1,'Tonsure (monks with bald haircut)',40082,'Elf','20040430173547','0','BITMAP','image','png',0,'l8awr5f8cdvmsl9il7f0e9ceibs5oep'),(755,'Axial-flow-compressor.png','20040430230004!Axial-flow-compressor.png',49083,620,441,8,'Diagram of axial flow compressor',36574,'Mor','20040402091050','0','BITMAP','image','png',0,'2f0r93jmeix9wqauxbb5q8o54h4hpax'),(756,'Action-potential.png','20040501014248!Action_potential.png',12514,875,378,8,'Basic cardiac action potential (with labels)',40019,'Ksheka','20040501013002','0','BITMAP','image','png',0,'4b7wibug8cnm043dzu6qyritwf5h2w7'),(757,'HYDE-PARK.jpg','20040501015210!HYDE-PARK.jpg',49336,512,384,8,'Photograph taken by myself. Use, if you like.',64433,'Tin soldier','20040501014234','0','BITMAP','image','jpeg',0,'ix6r8iclczuvtpqhpo30gjkbs98n9kx'),(758,'1st.jpg','20040501021633!1st.jpg',11550,262,240,8,'Edited photo from 1st Force Recon',64433,'Tin soldier','20040501021516','0','BITMAP','image','jpeg',0,'q8k257bvzmkdw9tl4ten3mxexw9sm4s'),(759,'Crude-EU25-colored.png','20040501091230!Crude-EU25-colored.png',6548,262,160,8,'{{msg:GFDL}}',26939,'Korath','20040430235401','0','BITMAP','image','png',0,'9npzwoqsu9cxsxjpennwwhw7n9urhpt'),(760,'Sauterelle.jpg','20040501092225!Sauterelle.jpg',8777,283,213,8,'\"Sauterelle\" (perhaps Tettigonia viridissima)\'\'',1752,'Anthere','20040501091924','0','BITMAP','image','jpeg',0,'lw4ryrnc3lgknxph0t11fofuwku4bpn'),(761,'Austria-hungary-blank.png','20040501203059!Austria-hungary_blank.png',20554,561,416,8,'compress',47960,'Guanaco','20040430022301','0','BITMAP','image','png',0,'h0d29c0ujzdeotj9gxr1tj06gxdw645'),(762,'Map-Falkland-longdon-small.png','20040501205340!Map_Falkland_longdon_small.png',65545,459,263,8,'Map Falkland Mt Longdon area',45336,'Wikibob','20040430233734','0','BITMAP','image','png',0,'4vzmei0efcq4jz0x6zigki22v3nqr3e'),(763,'Map-Falkland-longdon-small.png','20040501205735!Map_Falkland_longdon_small.png',0,0,0,0,'Map East Falkland with named mountains',45336,'Wikibob','20040501205340','0','BITMAP','image','png',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(764,'Canadian-Northern-Railway-herald.png','20040501225533!Canadian_Northern_Railway_herald.png',5113,144,142,8,'compress',47960,'Guanaco','20040501224944','0','BITMAP','image','png',0,'qhfx8yo2asnt0mlw3elh0m5jddsdgxk'),(765,'Canadian-Northern-Railway-herald.png','20040501225620!Canadian_Northern_Railway_herald.png',5126,144,142,8,'making transparent',47960,'Guanaco','20040501225533','0','BITMAP','image','png',0,'qcnwjdks0z1xsfwealxv4f02fha9u48'),(766,'Canadian-Northern-Railway-herald.png','20040501225641!Canadian_Northern_Railway_herald.png',5916,144,142,8,'',47960,'Guanaco','20040501225620','0','BITMAP','image','png',0,'h24h6qggengvjn8ext12gtyx1ehp72z'),(767,'BlackBoxSample1.png','20040502005458!BlackBoxSample1.png',697,261,281,4,'Uploaded by creator (Catbar/ Brian A. Rock) {{msg:GFDL}} demo image 1 for \'Black Box (game)\'',33032,'Catbar','20040423231830','0','BITMAP','image','png',0,'84qbjtdkpa4gf2ymmvt4oczhf70t3b3'),(768,'Osuseal.jpg','20040502013953!Osuseal.jpg',12267,230,154,8,'Seal of OSU, released under the {{msg:GFDL}}',19400,'Taoster','20040502013858','0','BITMAP','image','jpeg',0,'skzzx5in9kcmkuk3n4nlxfji9u8a7ni'),(769,'Test-Crude-EU25-colored-stretched-greens.png','20040502121245!Test_Crude-EU25-colored_stretched_greens.png',3149,262,160,8,'Test green shades for EU25 map',45336,'Wikibob','20040502120226','0','BITMAP','image','png',0,'0bwkde68u9aacjne2x8c1qjdfbwki17'),(770,'Test-Crude-EU25-colored-blues-greens.png','20040502121605!Test_Crude-EU25-colored_blues_greens.png',3149,262,160,8,'Test blue and green shades for EU25 map',45336,'Wikibob','20040502120254','0','BITMAP','image','png',0,'mbm8bnsl2aonnjnnvflez0rwizezv9d'),(771,'Test-Crude-EU25-colored-blues-greens-2.png','20040502121806!Test_Crude-EU25-colored_blues_greens_2.png',3149,262,160,8,'Test yet more blue and green shades for EU25 map',45336,'Wikibob','20040502120315','0','BITMAP','image','png',0,'salenbquivpxisr8tbol8zcvwhp935x'),(772,'DuelSwords.png','20040502203602!DuelSwords.png',12474,500,351,8,'Dueling with swords',40082,'Elf','20040430172005','0','BITMAP','image','png',0,'mgok4m1dp3nk1o2mohdouyypek0rs3k'),(773,'Tonsure-fx-tr.png','20040502203719!Tonsure_fx_tr.png',19544,500,464,8,'replacing messed-up previous upload',40082,'Elf','20040430174243','0','BITMAP','image','png',0,'m1qynkx4ln14i3m92qkoyx17n7f4mat'),(774,'ChinUpBars-wb.png','20040502204032!ChinUpBars_wb.png',4479,400,217,8,'Chin-up bars sketch',40082,'Elf','20040501031750','0','BITMAP','image','png',0,'j9gfaujn094mbsg8ghhv51x5l9wkfpp'),(775,'FoxHuntingSketch.png','20040502204052!FoxHuntingSketch.png',42199,800,434,8,'Fox hunting (probably) woodblock  print',40082,'Elf','20040501011945','0','BITMAP','image','png',0,'g6aetnluohk7xpau225rvw3ycv1n96b'),(776,'Generation-Terrorists.jpg','20040503013304!Generation_Terrorists.jpg',3353,100,100,8,'',54993,'Scraggy4','20040412010152','0','BITMAP','image','jpeg',0,'jkl7f9brnxumbnll4j3fkqk9r5abto9'),(777,'Smiley-face-with-no-title.png','20040504025801!Smiley_face_with_no_title.png',1012,194,200,4,'more compact version',4558,'JohnOwens','20030424215723','0','BITMAP','image','png',0,'5ncr1r76yzli6d0iflh2ky76vby2csx'),(778,'Smiley-face-with-no-title.png','20040504025820!Smiley_face_with_no_title.png',859,203,195,4,'recrop from captioned image, optimize',47960,'Guanaco','20040504025801','0','BITMAP','image','png',0,'n7s60g89m9jocy8p8d5oh7hkggmodqb'),(779,'Smiley-face-with-no-title.png','20040504030102!Smiley_face_with_no_title.png',1012,194,200,4,'Reverted to earlier revision',47960,'Guanaco','20040504025820','0','BITMAP','image','png',0,'5ncr1r76yzli6d0iflh2ky76vby2csx'),(780,'Smiley-face-with-no-title.png','20040504040114!Smiley_face_with_no_title.png',854,194,200,4,'recrop with same dimensions to avoid caching bug, optimize',47960,'Guanaco','20040504030103','0','BITMAP','image','png',0,'99sc5rxizcqo7co023torxt6o2uosv7'),(781,'Smiley-face-with-no-title.png','20040504040123!Smiley_face_with_no_title.png',859,203,195,4,'Reverted to earlier revision',47960,'Guanaco','20040504040114','0','BITMAP','image','png',0,'n7s60g89m9jocy8p8d5oh7hkggmodqb'),(782,'Smiley-face-with-no-title.png','20040504040128!Smiley_face_with_no_title.png',854,194,200,4,'Reverted to earlier revision',47960,'Guanaco','20040504040123','0','BITMAP','image','png',0,'99sc5rxizcqo7co023torxt6o2uosv7'),(783,'Tone-mark-comparative-chart.png','20040504093119!Tone_mark_comparative_chart.png',86871,268,308,8,'Drawn by hand > digicam > GIMP scaled down & higher contrast',6153,'Menchi','20040227093701','0','BITMAP','image','png',0,'8qb5997dgcld0gcicw839swc688xhyi'),(784,'USAr.insignia.e2.wag2.png','20040504171717!USAr.insignia.e2.wag2.png',11067,200,189,8,'reloading image to a smaller size',52361,'Joseph Dwayne','20040430065856','0','BITMAP','image','png',0,'imrdb5a4v4an8gjs4jy0ycw7wru6yt0'),(785,'USAr.insignia.e3.wag2.png','20040504173253!USAr.insignia.e3.wag2.png',12229,200,232,8,'reloading image to a smaller size',52361,'Joseph Dwayne','20040430065347','0','BITMAP','image','png',0,'ql8zaolckrsq0o5iq0oda2wqs65sxc6'),(786,'USAr.insignia.e4.wag2.png','20040504173532!USAr.insignia.e4.wag2.png',26440,280,318,8,'realoding to a smaller size',52361,'Joseph Dwayne','20040430064043','0','BITMAP','image','png',0,'q2r0rcoz5fnn710joetwq602i62wbst'),(787,'USAr.insignia.e5.wag2.png','20040504173708!USAr.insignia.e5.wag2.png',16990,200,265,8,'reloading image to a smaller size',52361,'Joseph Dwayne','20040430070029','0','BITMAP','image','png',0,'hme7q8rt2eovbk43vahu0nnfg0a63kc'),(788,'USAr.insignia.e6.wag2.png','20040504173816!USAr.insignia.e6.wag2.png',18232,200,309,8,'reloading image to a smaller size',52361,'Joseph Dwayne','20040430070341','0','BITMAP','image','png',0,'smwpwnag0q7bz212regtht30z7gvilv'),(789,'USAr.insignia.e7.wag2.png','20040504173923!USAr.insignia.e7.wag2.png',19188,200,342,8,'reloading image to a smaller size',52361,'Joseph Dwayne','20040430070449','0','BITMAP','image','png',0,'ac17moayseua4sbh7mcshuru0usbp9k'),(790,'USAr.insignia.e8.wag2.png','20040504174029!USAr.insignia.e8.wag2.png',21499,200,373,8,'reloading image to a smaller size',52361,'Joseph Dwayne','20040430070550','0','BITMAP','image','png',0,'cvf1o1aml3yxw3h2mz5xhif04wektcc'),(791,'USAr.insignia.e8firstsgt.wag2.png','20040504174115!USAr.insignia.e8firstsgt.wag2.png',22939,200,373,8,'reloading image to a smaller size',52361,'Joseph Dwayne','20040430070720','0','BITMAP','image','png',0,'gwwyyl8tryfm4zs9kz2ybmgc6jjq6i0'),(792,'USAr.insignia.e9.wag2.png','20040504174241!USAr.insignia.e9.wag2.png',22564,200,373,8,'reloading image to a smaller size',52361,'Joseph Dwayne','20040430070834','0','BITMAP','image','png',0,'0d84tpsdyqed0yed5eflkhldo44d9o1'),(793,'USAr.insignia.e9comm.wag2.png','20040504174356!USAr.insignia.e9comm.wag2.png',23775,200,373,8,'reloading image to a smaller size',52361,'Joseph Dwayne','20040430070924','0','BITMAP','image','png',0,'m71br2jrxeih8wf5ctfr800udr695w5'),(794,'USAr.insignia.e9sma.wag2.png','20040504174509!USAr.insignia.e9sma.wag2.png',25524,200,373,8,'reloading image to a smaller size',52361,'Joseph Dwayne','20040430071024','0','BITMAP','image','png',0,'2g1emudj42fpi6o2tl3se5811abavmu'),(795,'USAr.insignia.e9sma.wag2.png','20040504175828!USAr.insignia.e9sma.wag2.png',67210,1000,1867,8,'larger size/ resolution has no bandwidth impact, and is more useful',44261,'Wguynes','20040504174510','0','BITMAP','image','png',0,'eahubvlxv0xa22ei1ubdj6nom5007wt'),(796,'USAr.insignia.e9comm.wag2.png','20040504175952!USAr.insignia.e9comm.wag2.png',64733,1000,1867,8,'larger size/ resolution has no bandwidth impact, and is more useful',44261,'Wguynes','20040504174356','0','BITMAP','image','png',0,'k6m0mg6sojmtckgp85zswe8qvldgfm8'),(797,'USAr.insignia.e9.wag2.png','20040504180108!USAr.insignia.e9.wag2.png',63620,1000,1867,8,'larger size/ resolution has no bandwidth impact, and is more useful',44261,'Wguynes','20040504174241','0','BITMAP','image','png',0,'gqkqzs8ng8yl1bnop2btf4w6egmx3d1'),(798,'USAr.insignia.e8firstsgt.wag2.png','20040504180223!USAr.insignia.e8firstsgt.wag2.png',64016,1000,1867,8,'larger size/ resolution has no bandwidth impact, and is more useful',44261,'Wguynes','20040504174115','0','BITMAP','image','png',0,'nr5jm77depcutuv3xcxpkhq9a3501a0'),(799,'USAr.insignia.e3.wag2.png','20040504180514!USAr.insignia.e3.wag2.png',37761,1000,1161,8,'larger size/ resolution has no bandwidth impact, and is more useful',44261,'Wguynes','20040504173254','0','BITMAP','image','png',0,'mtvanflasrius1cegjocaejeb1ax1qd'),(800,'USAr.insignia.e4.wag2.png','20040504180528!USAr.insignia.e4.wag2.png',39473,1000,1133,8,'larger size/ resolution has no bandwidth impact, and is more useful',44261,'Wguynes','20040504173532','0','BITMAP','image','png',0,'fqt2kkg8ajqh9o95nz5tufdqq8pu3a3'),(801,'USAr.insignia.e5.wag2.png','20040504180540!USAr.insignia.e5.wag2.png',47217,1000,1323,8,'larger size/ resolution has no bandwidth impact, and is more useful',44261,'Wguynes','20040504173708','0','BITMAP','image','png',0,'ph3v6zbh6wasf3p37l6r2efml6mk44k'),(802,'USAr.insignia.e6.wag2.png','20040504180601!USAr.insignia.e6.wag2.png',52546,1000,1543,8,'larger size/ resolution has no bandwidth impact, and is more useful',44261,'Wguynes','20040504173817','0','BITMAP','image','png',0,'1rduc130ji26grdeobn9m44wfad7odj'),(803,'USAr.insignia.e7.wag2.png','20040504180616!USAr.insignia.e7.wag2.png',57805,1000,1709,8,'larger size/ resolution has no bandwidth impact, and is more useful',44261,'Wguynes','20040504173923','0','BITMAP','image','png',0,'az9815xdzq7ll0oq9brvg8v1itim2rz'),(804,'USAr.insignia.e8.wag2.png','20040504180639!USAr.insignia.e8.wag2.png',62566,1000,1867,8,'larger size/ resolution has no bandwidth impact, and is more useful',44261,'Wguynes','20040504174029','0','BITMAP','image','png',0,'6ki7jhbns5bax64gtjybwqlzl20sszd'),(805,'USAirF.insignia.e2.afmil.png','20040504182347!USAirF.insignia.e2.afmil.png',26192,1495,636,8,'',44261,'Wguynes','20040329060711','0','BITMAP','image','png',0,'1oohuonjm0y13ow95vjvyhvvlx221xs'),(806,'USAirF.insignia.e3.afmil.png','20040504182409!USAirF.insignia.e3.afmil.png',33224,1498,826,8,'',44261,'Wguynes','20040329060906','0','BITMAP','image','png',0,'9eiz9tuwfmelruu7f8ue1khq7sb4yi7'),(807,'USAirF.insignia.e4.afmil.png','20040504182421!USAirF.insignia.e4.afmil.png',39723,1499,952,8,'',44261,'Wguynes','20040329060959','0','BITMAP','image','png',0,'fl9chnk4gyg8g74s55nwaxh6q07pex5'),(808,'USAirF.insignia.e5.afmil.png','20040504182438!USAirF.insignia.e5.afmil.png',47937,1486,1110,8,'',44261,'Wguynes','20040329061058','0','BITMAP','image','png',0,'ke7af1jaohoar6r490ika6pu3t4gs9b'),(809,'USAirF.insignia.e6.afmil.png','20040504182451!USAirF.insignia.e6.afmil.png',55372,1496,1284,8,'',44261,'Wguynes','20040329061154','0','BITMAP','image','png',0,'074uedd86qf2z0e5mudcun4l2lld5mr'),(810,'USAirF.insignia.e7.afmil.png','20040504182505!USAirF.insignia.e7.afmil.png',57856,1197,1497,8,'',44261,'Wguynes','20040329061238','0','BITMAP','image','png',0,'ebzz8edelo6nk2gj2p7loziiehn7oh1'),(811,'USAirF.insignia.e7firstsgt.afmil.png','20040504182523!USAirF.insignia.e7firstsgt.afmil.png',59186,1197,1497,8,'',44261,'Wguynes','20040329061514','0','BITMAP','image','png',0,'67exme8mplzrd0qunkgoeltb3i4uesn'),(812,'USAirF.insignia.e8.afmil.png','20040504182545!USAirF.insignia.e8.afmil.png',58415,1066,1496,8,'',44261,'Wguynes','20040329061328','0','BITMAP','image','png',0,'k7oe9ihur9grcl8u51mxy8929uitayg'),(813,'USAirF.insignia.e8firstsgt.afmil.png','20040504182603!USAirF.insignia.e8firstsgt.afmil.png',59493,1063,1496,8,'',44261,'Wguynes','20040329061619','0','BITMAP','image','png',0,'j67yb2ckfgxurhumeu27jbnjvr6usdc'),(814,'USAirF.insignia.e9.afmil.png','20040504182613!USAirF.insignia.e9.afmil.png',51271,976,1496,8,'',44261,'Wguynes','20040329061413','0','BITMAP','image','png',0,'r50gjf84xrsu4cg8kj1jz04so7826aj'),(815,'USAirF.insignia.e9cmsaf.afmil.png','20040504182623!USAirF.insignia.e9cmsaf.afmil.png',54108,988,1497,8,'',44261,'Wguynes','20040329063302','0','BITMAP','image','png',0,'ruvxiz6ol87xo3rmtk431vb1jn2er3f'),(816,'USAirF.insignia.e9comm.afmil.png','20040504182639!USAirF.insignia.e9comm.afmil.png',53389,980,1500,8,'',44261,'Wguynes','20040331221837','0','BITMAP','image','png',0,'4sqf1a5ymmjrlfb30g52vdxu9yggq8i'),(817,'USAirF.insignia.e9firstsgt.afmil.png','20040504182656!USAirF.insignia.e9firstsgt.afmil.png',52898,976,1496,8,'',44261,'Wguynes','20040329061716','0','BITMAP','image','png',0,'i9bmbulgwtma616h46pdi1w543ok243'),(818,'USAr.insignia.e2.wag2.png','20040505002729!USAr.insignia.e2.wag2.png',31935,1000,944,8,'',44261,'Wguynes','20040504171717','0','BITMAP','image','png',0,'jtg0oml22mz1vztuuodu0orcks7ub5m'),(819,'USAr.insignia.e2.wag2.png','20040505004151!USAr.insignia.e2.wag2.png',6842,1000,944,2,'Lossless file size reduction',6264,'Wapcaplet','20040505002729','0','BITMAP','image','png',0,'fnder92dflq5zlb2sm7ytgihn7c1z3z'),(820,'Wstick.jpg','20040505050441!Wstick.jpg',231601,631,268,8,'weatherstick',36346,'Dwindrim','20040505024245','0','BITMAP','image','jpeg',0,'n36fp8okw9mnx6lhcuwixct87z2wr6i'),(821,'IFSGreatSeal.png','20040505093617!IFSGreatSeal.png',33212,449,461,8,'Great Seal of the Irish Free State - fair use',49447,'Djegan','20040503224159','0','BITMAP','image','png',0,'hqnuhume8u8aupqt1ypxafcjlw9gw7v'),(822,'MinPoodle-wb.jpg','20040505181802!MinPoodle_wb.jpg',97893,500,375,8,'Black miniature poodle',40082,'Elf','20040503154127','0','BITMAP','image','jpeg',0,'ot7lonyk9hor3fwe9an9pveeaxuixe9'),(823,'MinPoodle-wb.jpg','20040505182536!MinPoodle_wb.jpg',97893,500,375,8,'remove lead (Elf, revert if you don\'t like this)',6561,'Sannse','20040505181803','0','BITMAP','image','jpeg',0,'ot7lonyk9hor3fwe9an9pveeaxuixe9'),(824,'USAr.insignia.e2.wag2.png','20040505202507!USAr.insignia.e2.wag2.png',14125,1000,944,8,'filesize losslessly reduced by changing to 4 color palette',44261,'Wguynes','20040505004152','0','BITMAP','image','png',0,'g7yjjltvy8a7wu1vkbef6ynbd3ljruu'),(825,'USAr.insignia.e3.wag2.png','20040505202709!USAr.insignia.e3.wag2.png',8189,1000,1161,2,'Lossless file size reduction',6264,'Wapcaplet','20040504180514','0','BITMAP','image','png',0,'890bsdf82t69yzbbtr4c49niyzv0hfr'),(826,'USAr.insignia.e4spec.wag2.png','20040505202813!USAr.insignia.e4spec.wag2.png',43074,1000,1161,8,'',44261,'Wguynes','20040417083634','0','BITMAP','image','png',0,'amd5o59bw1nid128fg8inuvwak3umog'),(827,'USAr.insignia.e4.wag2.png','20040505202946!USAr.insignia.e4.wag2.png',8887,1000,1133,2,'Lossless file size reduction',6264,'Wapcaplet','20040504180528','0','BITMAP','image','png',0,'ff8ttu4g3ccbhqp661v23vj8t5xzb6a'),(828,'USAr.insignia.e5.wag2.png','20040505203140!USAr.insignia.e5.wag2.png',10710,1000,1323,2,'Lossless file size reduction',6264,'Wapcaplet','20040504180540','0','BITMAP','image','png',0,'kkb2zt53m1efd7sq13nn7muivijqy0k'),(829,'USAr.insignia.e6.wag2.png','20040505203239!USAr.insignia.e6.wag2.png',12146,1000,1543,2,'Lossless file size reduction',6264,'Wapcaplet','20040504180602','0','BITMAP','image','png',0,'l3qde0ep0g6lfni2jkjxbrp4ea1qsxd'),(830,'USAr.insignia.e7.wag2.png','20040505203331!USAr.insignia.e7.wag2.png',13708,1000,1709,2,'Lossless file size reduction',6264,'Wapcaplet','20040504180616','0','BITMAP','image','png',0,'5ut1348vsy5gj1orqjrowjr3337czmk'),(831,'USAr.insignia.e8.wag2.png','20040505203448!USAr.insignia.e8.wag2.png',14823,1000,1867,2,'Lossless file size reduction',6264,'Wapcaplet','20040504180640','0','BITMAP','image','png',0,'o4yutcla3x93p0x9sh86s8rxsfztpkg'),(832,'USAr.insignia.e8firstsgt.wag2.png','20040505203541!USAr.insignia.e8firstsgt.wag2.png',16025,1000,1867,2,'Lossless file size reduction',6264,'Wapcaplet','20040504180223','0','BITMAP','image','png',0,'6bliu28b1quf0gfv07f6ks2lbxmj367'),(833,'USAr.insignia.e9.wag2.png','20040505203639!USAr.insignia.e9.wag2.png',15965,1000,1867,2,'Lossless file size reduction',6264,'Wapcaplet','20040504180109','0','BITMAP','image','png',0,'hhu5t6gsyf7kn2lfwols11qd0g3q7go'),(834,'USAr.insignia.e9comm.wag2.png','20040505203729!USAr.insignia.e9comm.wag2.png',16808,1000,1867,2,'Lossless file size reduction',6264,'Wapcaplet','20040504175952','0','BITMAP','image','png',0,'l3cus5eospk404jeowzjhiekw55fnzy'),(835,'USAr.insignia.e9sma.wag2.png','20040505203826!USAr.insignia.e9sma.wag2.png',18669,1000,1867,2,'Lossless file size reduction',6264,'Wapcaplet','20040504175828','0','BITMAP','image','png',0,'t4me4aybxn1u30ozct995pi12hul1lk'),(836,'Eskimo-kinship-chart.png','20040505210510!Eskimo-kinship-chart.png',10671,800,263,8,'Graphic of the Eskimo kinship system, authored by the uploader. The author releases all rights to this image. {{msg:PD}}',52305,'Maclyn611','20040505210124','0','BITMAP','image','png',0,'a5ysuylmrzcxbyzdjy169xpg1x8fwy8'),(837,'Eskimo-kinship-chart.png','20040505210627!Eskimo-kinship-chart.png',7883,943,310,8,'Graphic of the Eskimo kinship system, authored by the uploader. The author releases all rights to this image. {{msg:PD}}',52305,'Maclyn611','20040505210511','0','BITMAP','image','png',0,'ieefoyhb58swhtkxxi2iy7s3pa681v4'),(838,'Rtypedoppelganger.png','20040505222123!Rtypedoppelganger.png',58232,300,206,8,'Screenshot of the Doppelganger [[boss (video game)|boss]] from [[R-Type]].',65784,'Spottedowl','20040505204429','0','BITMAP','image','png',0,'btp310qrqulwzbz6229fbzbyau51903'),(839,'Brunner.jpg','20040506161232!Brunner.jpg',4194,100,168,8,'From the archives of the International Constantin Brunner Institute',63204,'Barrett Pashak','20040506155630','0','BITMAP','image','jpeg',0,'8zo87sm03odhmzqq8q9vhoxl1hvsz22'),(840,'Brunner.jpg','20040506161825!Brunner.jpg',24992,268,499,8,'from the archives of the International Constantin Brunner Institute',63204,'Barrett Pashak','20040506161233','0','BITMAP','image','jpeg',0,'s8t9ew6nv0lldcubhajmureuqsjzniu'),(841,'Usinprogress.PNG','20040507040654!Usinprogress.PNG',38941,280,183,8,'',35314,'Seth Ilys','20040331192712','0','BITMAP','image','png',0,'6e01oukd5xj6my0bbn6uyu4fgmutjac'),(842,'Balkans-political-map-small.png','20040507113346!Balkans-political-map-small.png',39411,304,257,8,'Reverted to earlier revision',40609,'Sinuhe','20040410142251','0','BITMAP','image','png',0,'krve22ikddg9cotrfaff3boyzy8iixb'),(843,'Glebe-hockey.jpg','20040507162912!Glebe_hockey.jpg',46768,695,349,8,'Glebe Collegiate hockey team, 1938',49254,'Joshuapaquin','20040507161921','0','BITMAP','image','jpeg',0,'azke6qvs7ohz85jq1daivuufkdx87p0'),(844,'Glebe-hockey.jpg','20040507164540!Glebe_hockey.jpg',26246,250,126,8,'Glebe Collegiate hockey team, 1938',49254,'Joshuapaquin','20040507162922','0','BITMAP','image','jpeg',0,'m3yss7lliygv5zq0cylnbg6947zd5lx'),(845,'KSokoban-screenshot.png','20040507221001!KSokoban-screenshot.png',259878,723,512,8,'screenshot from KSokoban (GPL program)',17226,'Grendelkhan','20040507220554','0','BITMAP','image','png',0,'3pwe2ld0famarwvu9sn14tajpalirzz'),(846,'Allypallyrosewfromse.jpg','20040507234537!Allypallyrosewfromse.jpg',91648,681,465,8,'Alexandra Palace - rose window',4191,'Nevilley','20040507234309','0','BITMAP','image','jpeg',0,'kktgndxki9b1d2lrsdgo0pyx7429yew'),(847,'Usinprogress.PNG','20040508012522!Usinprogress.PNG',38960,280,183,8,'',35314,'Seth Ilys','20040507040655','0','BITMAP','image','png',0,'h8a7itrb9014dbdql853gas8dzt0lch'),(848,'Wpdms-usgs-photo-raritan-bay.jpg','20040508031954!Wpdms_usgs_photo_raritan_bay.jpg',38604,300,370,8,'[[Raritan Bay]] &#169; 2004 Matthew Trump {{msg:GFDL}}',37527,'Decumanus','20040508025730','0','BITMAP','image','jpeg',0,'br0fbega040zfd2hv5ysbohss5foixo'),(849,'Wpdms-ev26188-fishers-island.jpg','20040508230703!Wpdms_ev26188_fishers_island.jpg',29672,325,217,8,'[[Fishers Island]] &#169; 2004 Matthew Trump {{msg:GFDL}}',37527,'Decumanus','20040508230511','0','BITMAP','image','jpeg',0,'tqel8kewx7l5p5cxkn3kge6ihnb6w0d'),(850,'Oyster-card-back.png','20040509170028!Oyster_card_back.png',190868,800,505,8,'Back of [[Oyster Card]]',19009,'Ed g2s','20040509162605','0','BITMAP','image','png',0,'n96occ1iyl7njfuitwsv442b9xxzymr'),(851,'Colchicum-blue.jpg','20040509193001!Colchicum-blue.jpg',33301,198,207,8,'photo taken by me on May 8, 2004 in the Bucegi Mountains, Carpathians, Romania',9475,'Bogdangiusca','20040509192059','0','BITMAP','image','jpeg',0,'o63lj41jmiky8wjpafueypok8i8i57d'),(852,'ShingTungYau.jpg','20040509204045!ShingTungYau.jpg',9940,240,180,8,'Shing-Tung Yau at Harvard Law School dining hall',66753,'Lumidek','20040509203718','0','BITMAP','image','jpeg',0,'7vi95p3c0blvwvma8woacfonqecq9no'),(853,'GaryHart.jpg','20040510004317!GaryHart.jpg',18071,150,225,8,'[http:/ / bioguide.congress.gov/ bioguide/ photo/ H/ H000287.jpg http:/ / bioguide.congress.gov/ bioguide/ photo/ H/ H000287.jpg]',13800,'RickK','20030817051509','0','BITMAP','image','jpeg',0,'qq01cc7kkxnd8d18idzexxnpve5gbtt'),(854,'Wpdms-ev26188-great-south-bay.jpg','20040510041030!Wpdms_ev26188_great_south_bay.jpg',27890,301,220,8,'[[Great South Bay]] &#169; 2004 Matthew Trump {{msg:GFDL}}',37527,'Decumanus','20040510032900','0','BITMAP','image','jpeg',0,'clobp8j9xr67i1v45y592u1ro9e993r'),(855,'Wpdms-ev26188-great-south-bay.jpg','20040510041702!Wpdms_ev26188_great_south_bay.jpg',15363,301,220,8,'correcting shaded area',37527,'Decumanus','20040510041030','0','BITMAP','image','jpeg',0,'fau6zwf8zdjyh7s7u4xb4iobbsyz53o'),(856,'Wpdms-ev26188-gardiners-bay.jpg','20040510043055!Wpdms_ev26188_gardiners_bay.jpg',32671,300,220,8,'[[Gardiners Bay]] &#169; 2004 Matthew Trump {{msg:GFDL}}',37527,'Decumanus','20040509003412','0','BITMAP','image','jpeg',0,'f3tfg4lni2q4lxpnokwtkmiwua750mo'),(857,'Mumbai-twin-towers.jpg','20040510220123!Mumbai-twin-towers.jpg',52077,338,450,8,'Tower blocks in Mumbai',36346,'Dwindrim','20040510215838','0','BITMAP','image','jpeg',0,'tf6adnsugatby5iwew2qtyh32e70zwc'),(858,'Nmi.jpg','20040511035857!Nmi.jpg',161630,968,684,8,'North Manitou Island',67150,'Ab5602','20040511035243','a:7:{s:11:\"XResolution\";s:5:\"150/1\";s:11:\"YResolution\";s:5:\"150/1\";s:14:\"ResolutionUnit\";i:2;s:16:\"YCbCrPositioning\";i:2;s:11:\"ExifVersion\";s:4:\"0200\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'arrsl8vft77lo14ar4n568stx7539fw'),(859,'Nmi.jpg','20040511040026!Nmi.jpg',161630,968,684,8,'North Manitou Island: Picture taken by myself in 2000, of dunes on south end of the island.',67150,'Ab5602','20040511035901','a:7:{s:11:\"XResolution\";s:5:\"150/1\";s:11:\"YResolution\";s:5:\"150/1\";s:14:\"ResolutionUnit\";i:2;s:16:\"YCbCrPositioning\";i:2;s:11:\"ExifVersion\";s:4:\"0200\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'arrsl8vft77lo14ar4n568stx7539fw'),(860,'Inner-product-angle.jpg','20040511042536!Inner_product_angle.jpg',6601,357,247,8,'inner product angle',61089,'CSTAR','20040511041026','0','BITMAP','image','jpeg',0,'kb04l15i1buzn50vga9yvy4elijck9w'),(861,'Antarctica-Map.png','20040511091008!Antarctica_Map.png',49793,503,619,8,'Antarctica map, adapted by [[User:Lupo|Lupo]] from the CIA factbook maps.<br>{{msg:PD}}',34978,'Lupo','20040511090246','0','BITMAP','image','png',0,'eanej5z7355r3zy3ruarsovg57zdb5w'),(862,'Antarctica-Map.png','20040511094036!Antarctica_Map.png',53405,502,617,8,'minor fix',34978,'Lupo','20040511091009','0','BITMAP','image','png',0,'kwyunibzdn01euwjc5sunrkzq676z6l'),(863,'Usinprogress.PNG','20040511215633!Usinprogress.PNG',38981,280,183,8,'update',35314,'Seth Ilys','20040508012523','0','BITMAP','image','png',0,'2lqerxlz3733nqas9fc098tpmb5twdo'),(864,'Rizongmonks.jpg','20040512164304!Rizongmonks.jpg',0,0,0,0,'Young monks from Rizong Monastery courtesy Bob Bharidge',48269,'20040302','20040512164018','','TEXT','text','plain',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(865,'Rizongmonks.jpg','20040512164613!Rizongmonks.jpg',63710,472,330,8,'Young monks from Rizong Monastery courtesy Bob Bharij',48269,'20040302','20040512164305','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"100/1\";s:11:\"YResolution\";s:5:\"100/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:02:19 17:37:46\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'1amm27zvda8gkfs05s4bd3r4kxs3vwb'),(866,'Antarctica-Map.png','20040513114256!Antarctica_Map.png',53616,502,617,8,'fix a spelling error',34978,'Lupo','20040511094037','0','BITMAP','image','png',0,'dagtbrtjgakkfoh8akj0093hllnjvfi'),(867,'US-CT-Barkhamsted.png','20040513144548!US-CT-Barkhamsted.png',55407,450,336,8,'I made this.  {{msg:GFDL}}',55842,'Plutor','20040513143904','0','BITMAP','image','png',0,'d108gki0y1y5lb0jv15bg0temtrpdbk'),(868,'Cathedral-of-Learning.jpg','20040513171747!Cathedral_of_Learning.jpg',1244035,2272,1704,8,'Cathedral of Learning, Pittsburgh, PA by Adam Retchless',2689,'AdamRetchless','20040513015059','a:35:{s:4:\"Make\";s:5:\"NIKON\";s:5:\"Model\";s:5:\"E4300\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:9:\"E4300v1.5\";s:8:\"DateTime\";s:19:\"2004:05:04 08:46:27\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/1067\";s:7:\"FNumber\";s:5:\"76/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:05:04 08:46:27\";s:17:\"DateTimeDigitized\";s:19:\"2004:05:04 08:46:27\";s:22:\"CompressedBitsPerPixel\";s:3:\"3/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"30/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:5:\"80/10\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:5:\"0/100\";s:21:\"FocalLengthIn35mmFilm\";i:38;s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:20:\"SubjectDistanceRange\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'b0w2ayedbpskzwubblan0xxc3b2i3mo'),(869,'Cathedral-of-Learning.jpg','20040513173718!Cathedral_of_Learning.jpg',914707,1080,2244,8,'Cathedral of Learning in Pittsburgh, by Adam Retchless',2689,'AdamRetchless','20040513171751','a:33:{s:4:\"Make\";s:5:\"NIKON\";s:5:\"Model\";s:5:\"E4300\";s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:9:\"E4300v1.5\";s:8:\"DateTime\";s:19:\"2004:05:04 08:46:27\";s:16:\"YCbCrPositioning\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:5:\"0/100\";s:21:\"FocalLengthIn35mmFilm\";i:38;s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:20:\"SubjectDistanceRange\";i:0;s:12:\"ExposureTime\";s:16:\"937207/100000000\";s:7:\"FNumber\";s:5:\"76/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:05:04 08:46:27\";s:17:\"DateTimeDigitized\";s:19:\"2004:05:04 08:46:27\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:3:\"3/1\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:3:\"8/1\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'poi0tqnav9hg1w2dlpuyc4uu2j9c92o'),(870,'Horsetail-vegeative-stem.JPG','20040513173944!Horsetail_vegeative_stem.JPG',27138,175,528,8,'Digi-photo taken by User:Menchi',6153,'Menchi','20040306132232','0','BITMAP','image','jpeg',0,'4l1dft76uptg81hes3bci08eaxpetpy'),(871,'Blank-county-map-of-Missouri.png','20040514003441!Blank_county_map_of_Missouri.png',32747,300,263,8,'(Public domain map courtesy of [http:/ / www.lib.utexas.edu/  The General Libraries, The University of Texas at Austin], modified to show counties. Released under GFDL. See [[Wikipedia:U.S. county map]]s.) ',33032,'Catbar','20040513235409','0','BITMAP','image','png',0,'h8k35dup4xxi3iey2b5vm8ulkyedfdv'),(872,'Naphthalene.PNG','20040514003746!Naphthalene.PNG',2752,480,80,8,'resonance structures of naphthalene',67285,'Sesqui','20040514003447','0','BITMAP','image','png',0,'iqahqn2kt8vyqgkp0vfe5byh9q114d5'),(873,'Blank-county-map-of-Arizona.png','20040514004009!Blank_county_map_of_Arizona.png',25417,260,300,8,'(Public domain map courtesy of [http:/ / www.lib.utexas.edu/  The General Libraries, The University of Texas at Austin], modified to show counties. Released under GFDL. See [[Wikipedia:U.S. county map]]s.) ',33032,'Catbar','20040513235514','0','BITMAP','image','png',0,'tig4xeimmakmbd7d10wfzaubfe7hm03'),(874,'Bakert.jpg','20040514012505!Bakert.jpg',26418,150,150,8,'copyright-free publlicity still of Tom Baker as the Doctor',6661,'PMelvilleAustin','20031010223718','0','BITMAP','image','jpeg',0,'4kly9uvbjgonzpb0rsrhdbncqq7dur6'),(875,'Bakert.jpg','20040514012537!Bakert.jpg',64494,262,281,8,'',6661,'PMelvilleAustin','20040514012505','0','BITMAP','image','jpeg',0,'2x52fmwru8z6i4v5iwzy62s9s58f64e'),(876,'Bakercolin.jpg','20040514013000!Bakercolin.jpg',31762,150,188,8,'visually fixed apsect ratio',42385,'Lupin','20040417120638','0','BITMAP','image','jpeg',0,'fvs2emzsuf4qhq5goeairlg8kko9el0'),(877,'Africa-portuguese-creoles.png','20040514013034!Africa_portuguese_creoles.png',89531,503,505,8,'Portuguese Creoles in South America.',30470,'PedroPVZ','20040514012338','0','BITMAP','image','png',0,'tlw9xxceaaeqf7k2q4celvhznt7r5js'),(878,'Africa-portuguese-creoles.png','20040514020021!Africa_portuguese_creoles.png',89531,503,505,8,'Africa Portuguese Creoles',30470,'PedroPVZ','20040514013034','0','BITMAP','image','png',0,'tlw9xxceaaeqf7k2q4celvhznt7r5js'),(879,'Irontriangle.PNG','20040514061733!Irontriangle.PNG',7842,326,259,8,'smaller version of same graphic',41443,'Ubernetizen','20040204052946','0','BITMAP','image','png',0,'bhq7rv4swqihw54hsgkj9kymup7gzgd'),(880,'Irontriangle.PNG','20040514061807!Irontriangle.PNG',12005,451,362,8,'Reverted to earlier revision',41443,'Ubernetizen','20040514061733','0','BITMAP','image','png',0,'l2vl5jc6aul12joyevcvnyt3zfrh3ce'),(881,'WesternTigerSwallowtail.jpg','20040514065626!WesternTigerSwallowtail.jpg',168327,819,813,8,'[[Western Tiger Swallowtail]]',28679,'Seglea','20040511052939','a:32:{s:4:\"Make\";s:8:\"FUJIFILM\";s:5:\"Model\";s:15:\"FinePix2600Zoom\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:38:\"Digital Camera FinePix2600Zoom Ver3.00\";s:8:\"DateTime\";s:19:\"2004:05:08 13:30:01\";s:16:\"YCbCrPositioning\";i:2;s:7:\"FNumber\";s:7:\"870/100\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:05:08 13:30:01\";s:17:\"DateTimeDigitized\";s:19:\"2004:05:08 13:30:01\";s:22:\"CompressedBitsPerPixel\";s:5:\"32/10\";s:17:\"ShutterSpeedValue\";s:7:\"660/100\";s:13:\"ApertureValue\";s:7:\"620/100\";s:15:\"BrightnessValue\";s:7:\"819/100\";s:17:\"ExposureBiasValue\";s:5:\"0/100\";s:16:\"MaxApertureValue\";s:7:\"360/100\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:8:\"1800/100\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:6:\"3053/1\";s:21:\"FocalPlaneYResolution\";s:6:\"3053/1\";s:24:\"FocalPlaneResolutionUnit\";i:3;s:13:\"SensingMethod\";i:2;s:9:\"Sharpness\";i:3;s:12:\"WhiteBalance\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'iku2n9gv1ata3k3j4oqxgfwmutmk18t'),(882,'KingsDenmark3.png','20040515041524!KingsDenmark3.png',39197,1149,1633,8,'Danish monarchs family tree',8201,'Muriel Gottrop','20040304105404','0','BITMAP','image','png',0,'6zodwcyc79dtvnnuh99q3gjul8q45ey'),(883,'HadleyCross-sec.jpg','20040515075158!HadleyCross-sec.jpg',40299,298,170,8,'Hadley cell cross-section',36346,'Dwindrim','20040116221151','0','BITMAP','image','jpeg',0,'r7vqifur3rp4g6fzwc3mlhcnx90e4e8'),(884,'Usinprogress.PNG','20040515181532!Usinprogress.PNG',38981,280,183,8,'update',35314,'Seth Ilys','20040511215633','0','BITMAP','image','png',0,'slpb63777xyferfob1mqcj64xa9s8he'),(885,'Gold-against-the-Soul-Album-cover.jpg','20040515210219!Gold_against_the_Soul_Album_cover.jpg',3280,100,100,8,'',54993,'Scraggy4','20040412155017','0','BITMAP','image','jpeg',0,'0g67sz3mj6ye3i0b6p0i31vkto4xvse'),(886,'Gold-against-the-Soul-Album-cover.jpg','20040515211011!Gold_against_the_Soul_Album_cover.jpg',18248,225,225,8,'{{msg:fairuse}} to replace existing image that is too small',54993,'Scraggy4','20040515210221','0','BITMAP','image','jpeg',0,'p0fnvvxy5l4x215xmondmk2gs4tj6y8'),(887,'Mybluesky.jpg','20040515221939!Mybluesky.jpg',101685,300,418,8,'cumulus humilis',36346,'Dwindrim','20040511175705','0','BITMAP','image','jpeg',0,'joar5ttk4kz5dkwtbltvcwke4qci2yk'),(888,'Wpdms-nasa-topo-2-virgin-river.jpg','20040516002618!Wpdms_nasa_topo_2_virgin_river.jpg',58171,330,310,8,'[[Virgin River]] &#169; 2004 Matthew Trump {{msg:GFDL}}',37527,'Decumanus','20040516002214','0','BITMAP','image','jpeg',0,'tlf8cyf32fiy30pfs7wfc4101ylgfdp'),(889,'Wpdms-nasa-topo-2-virgin-river.jpg','20040516002836!Wpdms_nasa_topo_2_virgin_river.jpg',53881,300,300,8,'',37527,'Decumanus','20040516002618','0','BITMAP','image','jpeg',0,'1fn9c1q8w2kazl04jm7gm0qopgoon5t'),(890,'Wpdms-nasa-topo-2-virgin-river.jpg','20040516003427!Wpdms_nasa_topo_2_virgin_river.jpg',53687,300,300,8,'',37527,'Decumanus','20040516002836','0','BITMAP','image','jpeg',0,'hxnel0x34hmheuil5bfeosehbwadd2m'),(891,'Wpdms-nasa-topo-2-virgin-river.jpg','20040516003835!Wpdms_nasa_topo_2_virgin_river.jpg',55850,300,300,8,'',37527,'Decumanus','20040516003428','0','BITMAP','image','jpeg',0,'4znnz9vwury0qj1z83pkvcycxdare7s'),(892,'Ny.terra.600pix.jpg','20040516034955!Ny.terra.600pix.jpg',167781,600,796,8,'New York from space',7095,'Arpingstone','20031106191527','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"100/1\";s:11:\"YResolution\";s:5:\"100/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2003:08:01 17:01:25\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'0scvarml0jl3yavy9qonwgao2ahkxuz'),(893,'Ny.terra.600pix.jpg','20040516035017!Ny.terra.600pix.jpg',167781,600,796,8,'Reverted to earlier revision',68040,'Aramgutang','20040516034956','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"100/1\";s:11:\"YResolution\";s:5:\"100/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2003:08:01 17:01:25\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'0scvarml0jl3yavy9qonwgao2ahkxuz'),(894,'TC-Mad-Mad-World.jpg','20040516065317!TC_Mad_Mad_World.jpg',5310,151,152,8,'Tom Cochrane - \"Mad Mad World\" album cover',27822,'RedWolf','20040122231923','0','BITMAP','image','jpeg',0,'a6n5kihksgf1d49q40x6apz9c9om0lk'),(895,'Vvbyhour.png','20040516085736!Vvbyhour.png',3170,468,352,2,'for my user page',18610,'VeryVerily','20040502235015','0','BITMAP','image','png',0,'6ejvbsmnjz91hx6cffging87jjncv3c'),(896,'Vvbyhour.png','20040516090159!Vvbyhour.png',2933,448,322,2,'',18610,'VeryVerily','20040516085737','0','BITMAP','image','png',0,'hg09imd05oxwmzeq99l20xkv5gkcroy'),(897,'GPRS-core-structure.png','20040516104022!GPRS_core_structure.png',41909,599,416,8,'Structure of a GPRS Core network.  ',65193,'Mozzerati','20040516094117','0','BITMAP','image','png',0,'dzk0ievqx48z6smug4zaltv2tu0y1wk'),(898,'GPRS-core-structure.png','20040516104203!GPRS_core_structure.png',41850,599,416,8,'Corrected switched over interface labels.',65193,'Mozzerati','20040516104022','0','BITMAP','image','png',0,'qqxl5c09cv4kphgu3p7vdnshdrye8om'),(899,'Marching-band.jpg','20040516134414!Marching_band.jpg',16257,300,221,8,'Marching band, 1978, by Rick Dikeman',27288,'Rdikeman','20040207181919','0','BITMAP','image','jpeg',0,'ojx0a4ugoiskzafktb8oy0u208vxrby'),(900,'Fisherman.jpg','20040516140952!Fisherman.jpg',44365,197,300,8,'Fisherman, Long Island, NY, 1983, by Rick Dikeman',27288,'Rdikeman','20040210142959','0','BITMAP','image','jpeg',0,'ci8b6mxlsd68d3blll2n0edus8066mo'),(901,'Phtalic-anhydride.png','20040516143934!Phtalic_anhydride.png',455,0,0,0,'Phtalic anhydride formula. Drew that myself, decared Public Domain.',67718,'DenLianda','20040516143722','0','BITMAP','image','png',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(902,'Wpdms-nasa-topo-2-virgin-river.jpg','20040516174527!Wpdms_nasa_topo_2_virgin_river.jpg',47151,300,250,8,'',37527,'Decumanus','20040516003835','0','BITMAP','image','jpeg',0,'3ysjsuyhlhn1z5rsvz7jj55x2fkjfzq'),(903,'Drygrain1.jpg','20040517013215!Drygrain1.jpg',77519,625,809,8,'Photo of myself',50812,'DryGrain','20040517000101','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:05:16 16:42:50\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'61bivhdejsftce6xto928g3u0st6twt'),(904,'Bc2.png','20040517050110!Bc2.png',0,0,0,0,'Route marker sign: BC Highway 2',23958,'Denelson83','20040517045832','0','BITMAP','image','png',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(905,'TwCere.png','20040517095414!TwCere.png',139087,392,485,8,'tyne & wear shown as ceremonial county',62080,'Grinner','20040517094704','0','BITMAP','image','png',0,'0wfpb2ixrig3gwjal52451nab43qlwm'),(906,'Usinprogress.PNG','20040517150430!Usinprogress.PNG',38137,280,183,8,'update',35314,'Seth Ilys','20040515181533','0','BITMAP','image','png',0,'d9g6jemqnpu9i3lxnhttopxsussr3uv'),(907,'Lakewashshipcanal.names.png','20040517205732!Lakewashshipcanal.names.png',22014,253,215,8,'Based on a Census map from tiger.census.gov. I added labels. {{msg:PD]]',10642,'Lukobe','20040517205725','0','BITMAP','image','png',0,'ewbfhke4qfqnelt8cg42sej6xuows5l'),(908,'Drygrain1.jpg','20040517225849!Drygrain1.jpg',19450,125,161,8,'Photo of myself (resized)',50812,'DryGrain','20040517013215','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:05:16 16:42:50\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'rqn2fk9pqxhw7ag1zu1nne4jt2olucf'),(909,'Bc99.png','20040518012456!Bc99.png',12284,130,150,8,'Route marker sign: BC Highway 99',23958,'Denelson83','20040517081348','0','BITMAP','image','png',0,'a72hqycj084haol3aog30e2hu77qj0r'),(910,'Crist.png','20040518012947!Crist.png',9228,417,339,4,'A tengwar transliteration of Tolkien\'s Quenya translation of Cynewulf\'s Anglo-Saxon Crist poem.',67665,'HunterX','20040517221509','0','BITMAP','image','png',0,'j5wdwqnk0946upbodoz129aj63l6c2t'),(911,'Letterpress.jpg','20040518021924!Letterpress.jpg',117952,4653,1539,8,'Drawn by me using tkPaint {{msg:GFDL}}',69091,'Tympan','20040518021558','0','BITMAP','image','jpeg',0,'op12au07vkf2caimzcwke5c8v7jxca2'),(912,'Letterpress.jpg','20040518022020!Letterpress.jpg',7112,512,169,8,'Drawn by me using tkPaint {{msg:GFDL}}',69091,'Tympan','20040518021925','0','BITMAP','image','jpeg',0,'b7xql9gnso8mnljvmkp4vgzj16gkxec'),(913,'AlChris2004.jpg','20040518024736!AlChris2004.jpg',142104,397,303,8,'',35792,'AmericanCentury21','20040426004245','0','BITMAP','image','jpeg',0,'0z0x5sxuwrclhk189gv8qaqfmzacm28'),(914,'Mazama-collapse-phase-2.jpg','20040518063802!Mazama_collapse_phase_2.jpg',6929,248,207,8,'[[USGS]] image from [http:/ / geopubs.wr.usgs.gov/ fact-sheet/ fs092-02/ ] <br><br>{{msg:PD}}\n',62,'Mav','20040518062900','0','BITMAP','image','jpeg',0,'1pjm8v8957m632a2b5fw07ptv29c8k6'),(915,'LGA-Tas-SE-Brighton.png','20040518120541!LGA_Tas_SE_Brighton.png',22078,395,367,8,'Map of SE Tasmanian LGA\'s feat Brighton',3861,'Chuq','20040518113600','0','BITMAP','image','png',0,'rxthbq0i1x9q40dz93hf2h0t2lur972'),(916,'LGA-Tas-SE-Glenorchy.png','20040518120632!LGA_Tas_SE_Glenorchy.png',22062,395,367,8,'Map of SE Tasmanian LGA\'s feat Glenorchy',3861,'Chuq','20040518113710','0','BITMAP','image','png',0,'nlzw62s6loegxkamaolzghsr3keswu1'),(917,'LGA-Tas-SE-Hobart.png','20040518120649!LGA_Tas_SE_Hobart.png',21986,395,367,8,'Map of SE Tasmanian LGA\'s feat Hobart',3861,'Chuq','20040518113740','0','BITMAP','image','png',0,'m15z43ygf6jm71zq7fqtbbvz71ofgqx'),(918,'LGA-Tas-SE-Kingborough.png','20040518120709!LGA_Tas_SE_Kingborough.png',22392,395,367,8,'Map of SE Tasmanian LGA\'s feat Kingborough',3861,'Chuq','20040518113801','0','BITMAP','image','png',0,'gdq1f7xgjezm6t9v5so1hqhuylohkjk'),(919,'Eye.svg','20040518120824!Eye.svg',6189,744,1052,0,'Human eye, see eye.png',41853,'Kenny sh','20040518115226','','DRAWING','image','svg+xml',0,'c4pb12pyjy1lo3un9q7sh1nay0ionoa'),(920,'Eye.png','20040518120842!Eye.png',45344,595,842,8,'Human eye, rendered from eye.svg',41853,'Kenny sh','20040518115133','0','BITMAP','image','png',0,'s2aahvhffzpg1xfx2k7orwoaam1wf96'),(921,'LGATasmania-Burnie.png','20040518140415!LGATasmania_Burnie.png',58083,349,542,8,'Map of Tasmanian LGA\'s feat Burnie',3861,'Chuq','20040510120458','0','BITMAP','image','png',0,'2ineuxvay1tgadmblczefmmf63e1tl3'),(922,'LGATasmania-CentHighlands.png','20040518140438!LGATasmania_CentHighlands.png',58585,349,542,8,'Map of Tasmanian LGA\'s feat Central Highlands',3861,'Chuq','20040510120523','0','BITMAP','image','png',0,'et5aw25qzlfi3jpzihmz0f5azi70kmm'),(923,'LGATasmania-CentralCoast.png','20040518140458!LGATasmania_CentralCoast.png',58223,349,542,8,'Map of Tasmanian LGA\'s feat Central Coast',3861,'Chuq','20040510120543','0','BITMAP','image','png',0,'0xt61rfwhsnv6ga3bl69delqf0yft9w'),(924,'LGATasmania-CircularHead.png','20040518140526!LGATasmania_CircularHead.png',58913,349,542,8,'Map of Tasmanian LGA\'s feat Circular Head',3861,'Chuq','20040510120605','0','BITMAP','image','png',0,'3ft1li0b4652o7v7xbn90mgkf25zt63'),(925,'LGATasmania-Derwent.png','20040518140546!LGATasmania_Derwent.png',58670,349,542,8,'Map of Tasmanian LGA\'s feat Derwent Valley',3861,'Chuq','20040510120703','0','BITMAP','image','png',0,'nh50d56gaqpua8q247rlx4m3wq487z9'),(926,'LGATasmania-Devonport.png','20040518140607!LGATasmania_Devonport.png',57246,349,542,8,'Map of Tasmanian LGA\'s feat Devonport',3861,'Chuq','20040510120727','0','BITMAP','image','png',0,'8wc38ti6ingb2fh1kdrucvi6ot755xw'),(927,'LGATasmania-Kentish.png','20040518140904!LGATasmania_Kentish.png',57646,349,542,8,'Map of Tasmanian LGA\'s feat Kentish',3861,'Chuq','20040510121250','0','BITMAP','image','png',0,'kwj7hie2jt33n7i84t8jufwuit6e1wl'),(928,'LGATasmania-Meander.png','20040518141111!LGATasmania_Meander.png',57982,349,542,8,'Map of Tasmanian LGA\'s feat Meander Valley',3861,'Chuq','20040510122544','0','BITMAP','image','png',0,'4f1okbxccc0nvmiud87r7m3685l5w0s'),(929,'SickleAndGrassHook.jpg','20040518155606!SickleAndGrassHook.jpg',4064,225,202,8,'Sickle and grass hook',26995,'Chris 73','20040518134742','0','BITMAP','image','jpeg',0,'fd23ca56dgwv7u29n73wzpml4pro1kl'),(930,'Usinprogress.PNG','20040518160125!Usinprogress.PNG',37928,280,183,8,'update',35314,'Seth Ilys','20040517150430','0','BITMAP','image','png',0,'ii9rdnfztwdv8xcrdaubh3jgq1klq9u'),(931,'TCOIL3.png','20040518162056!TCOIL3.png',15047,1024,768,8,'Tesla Coil Schematic',53766,'K7jeb','20040418172555','0','BITMAP','image','png',0,'1i7p930xxi7zcc7ysaymilsntn57pj4'),(932,'Usinprogress.PNG','20040518173416!Usinprogress.PNG',38031,280,183,8,'update',35314,'Seth Ilys','20040518160125','0','BITMAP','image','png',0,'l0ktdomw0i0zvnenl4omyfqlx0adgaw'),(933,'Usinprogress.PNG','20040518173803!Usinprogress.PNG',37999,280,183,8,'update',35314,'Seth Ilys','20040518173417','0','BITMAP','image','png',0,'gj3z4tw096pa5r98kdq8sq0ahd7vvhy'),(934,'Chile-region-X.png','20040518214047!Chile_region_X.png',5488,71,271,8,'Map of Chile highlighting region X',7580,'Ahoerstemeier','20040409182632','0','BITMAP','image','png',0,'5ur7zupnsqdqe7plkvd8dgz1smjk2r3'),(935,'Bc15.png','20040518222005!Bc15.png',10396,130,150,8,'Route marker sign: BC Highway 15',23958,'Denelson83','20040517063934','0','BITMAP','image','png',0,'p2x4yy5ouo0zjscyhu8ffzhf7faqk9u'),(936,'Usinprogress.PNG','20040519201003!Usinprogress.PNG',37932,280,183,8,'update',35314,'Seth Ilys','20040518173803','0','BITMAP','image','png',0,'ccsbdvwodhgh7qyx7n22qqrclwxc0mx'),(937,'Wallpapercellcmm.gif','20040519201902!Wallpapercellcmm.gif',5377,193,202,8,'Wallpaper tiling cell: CMM',63601,'Tomruen','20040519201841','0','BITMAP','image','gif',0,'hyqcrczkeqn7n0au6o2evl0nn5uyywb'),(938,'Webdings.png','20040520003508!Webdings.png',71428,757,581,8,'webdings character mosaic',43000,'Monedula','20040517223114','0','BITMAP','image','png',0,'2c5e7u2qdcsuva94sl0hw5vkw79e334'),(939,'Coffee-percolator-section.png','20040520093926!Coffee_percolator_section.png',5439,240,360,8,'Schematice of a Coffee (Stove-top) Percolator',50356,'VampWillow','20040520091034','0','BITMAP','image','png',0,'7vy3v8bc8ols9v5dgvke9ijktacs94q'),(940,'1realIback.jpg','20040520204745!1realIback.jpg',5110,128,128,8,'',49775,'Redux','20040520204709','0','BITMAP','image','jpeg',0,'0svovkh7q7p3ka7ltowqlp7b5s2iste'),(941,'1realIback.jpg','20040520204812!1realIback.jpg',5110,128,128,8,'',49775,'Redux','20040520204753','0','BITMAP','image','jpeg',0,'0svovkh7q7p3ka7ltowqlp7b5s2iste'),(942,'1reallIIback-2.jpg','20040520215359!1reallIIback_2.jpg',5980,144,144,8,'',49775,'Redux','20040520214735','0','BITMAP','image','jpeg',0,'ommtalzmotkg45k9ewnd343grbrfh53'),(943,'Usinprogress.PNG','20040520222042!Usinprogress.PNG',37685,280,183,8,'update',35314,'Seth Ilys','20040519201003','0','BITMAP','image','png',0,'hw7b4go3vjnndnq83akqmcv12gorv5p'),(944,'Balkans-political-map.png','20040521084428!Balkans-political-map.png',40549,468,400,8,'Based on a map of Europe by [[User:Brion VIBBER|Brion VIBBER]]; this is a political map of the Balkans',40609,'Sinuhe','20040226125538','0','BITMAP','image','png',0,'4numjthk3rg5l8iofrt0tp2ye037qje'),(945,'Balkans-political-map.png','20040521084644!Balkans-political-map.png',40371,468,400,8,'',70019,'Wachter','20040521084428','0','BITMAP','image','png',0,'fwo5ei9q8jk3t7iq6w6izm2epm7tutv'),(946,'Balkans-political-map.png','20040521084734!Balkans-political-map.png',40371,468,400,8,'',70019,'Wachter','20040521084644','0','BITMAP','image','png',0,'fwo5ei9q8jk3t7iq6w6izm2epm7tutv'),(947,'US-CT-Roxbury.png','20040521121357!US-CT-Roxbury.png',55509,450,336,8,'I made this. {{msg:GFDL}}',55842,'Plutor','20040521121353','0','BITMAP','image','png',0,'blqrnc9nb8ex40vdbmwgp6076kzh4oh'),(948,'US-Navy-NRTOC-040508-N-2383B-377.jpg','20040521150928!US_Navy_NRTOC_040508-N-2383B-377.jpg',899604,3024,2016,8,'NRTOC, US Navy, PD',6468,'Zanimum','20040521150205','a:42:{s:16:\"ImageDescription\";s:751:\"040508-N-2383B-377\nNorfolk, Va. (May 08, 2004) - Newly graduated and commissioned officers of the Naval Reserve Officers Training Corps (NROTC) Unit Hampton Roads stand at attention as they are applauded during the Spring Commissioning Ceremony held at Norfolk State University.  The Hampton Roads unit was the first to offer complete NROTC programs at three seperate instititions to include Hampton University, Norfolk State University and Old Dominion University.  The unit provides professional and highly motivated commissioned officers that will serve with distinction in the Navy and Marine Corps.  Adm. Vern Clark, Chief of Naval Operations (CNO) was the guest speaker.  U.S. Navy photo by Chief Photographer\'s Mate Johnny Bivera.  (RELEASED)\n\n\";s:4:\"Make\";s:8:\"FUJIFILM\";s:5:\"Model\";s:12:\"FinePixS2Pro\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:28:\"Adobe Photoshop CS Macintosh\";s:8:\"DateTime\";s:19:\"2004:05:10 12:20:06\";s:6:\"Artist\";s:22:\"PHC (AW) Johnny Bivera\";s:16:\"YCbCrPositioning\";i:2;s:9:\"Copyright\";s:15:\"U.S. Navy Photo\";s:12:\"ExposureTime\";s:6:\"10/100\";s:7:\"FNumber\";s:7:\"350/100\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:800;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:05:08 18:36:10\";s:17:\"DateTimeDigitized\";s:19:\"2004:05:08 18:36:10\";s:22:\"CompressedBitsPerPixel\";s:5:\"32/10\";s:17:\"ShutterSpeedValue\";s:7:\"350/100\";s:13:\"ApertureValue\";s:7:\"366/100\";s:17:\"ExposureBiasValue\";s:5:\"0/100\";s:12:\"MeteringMode\";i:3;s:11:\"LightSource\";i:3;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:8:\"2400/100\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:6:\"1322/1\";s:21:\"FocalPlaneYResolution\";s:6:\"1322/1\";s:24:\"FocalPlaneResolutionUnit\";i:3;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:1;s:21:\"FocalLengthIn35mmFilm\";i:36;s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:1;s:10:\"Saturation\";i:1;s:9:\"Sharpness\";i:0;s:20:\"SubjectDistanceRange\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'88m9p23zigg46wp1dm4xe64kfrkdbxj'),(949,'US-Navy-NRTOC-040508-N-2383B-377.jpg','20040521151729!US_Navy_NRTOC_040508-N-2383B-377.jpg',31118,750,500,8,'replacing with image of reasonable size',3628,'Hephaestos','20040521150929','0','BITMAP','image','jpeg',0,'ciximhpl80i9iwsntso9txsjn5khdch'),(950,'US-Navy-Washington-Monument-030926-F-2828D-390.jpg','20040521152338!US_Navy_Washington_Monument_030926-F-2828D-390.jpg',1148141,1960,3008,8,'030926-F-2828D-390 Washington D.C. (Sept. 26, 2003) – An aerial view as seen from the south side of the Washington Memorial, directly adjacent to the White House. U.S. Air Force photo by Tech. Sgt. Andy Dunaway (Released) ',6468,'Zanimum','20040521151824','0','BITMAP','image','jpeg',0,'3p4liepnkbhmsqkn35wbi10aucx5nsv'),(951,'US-Navy-General\'s-body-language-040310-N-2568S-055.jpg','20040521154851!US_Navy_General\'s_body_language_040310-N-2568S-055.jpg',635125,2000,1312,8,'040310-N-2568S-055 Washington, D.C. (Mar. 10, 2003) - Gen. Michael W. Hagee, Commandant of the Marine Corps, gives testimony to members of the Senate Appropriations Committee concerning the Fiscal Year 2005 National Defense Authorization Budget Request fo',6468,'Zanimum','20040521152847','0','BITMAP','image','jpeg',0,'lml0kb3tmc4yrdroxzt5h945t4h1p2j'),(952,'US-Navy-Gordon-R-England-040310-N-2568S-051.jpg','20040521155113!US_Navy_Gordon_R_England_040310-N-2568S-051.jpg',531084,2000,1312,8,'040310-N-2568S-051 Washington, D.C. (Mar. 10, 2003) - The Honorable Gordon R. England, Secretary of the Navy (SECNAV), gives testimony to members of the Senate Appropriations Committee concerning the Fiscal Year 2005 National Defense Authorization Budget ',6468,'Zanimum','20040521153011','0','BITMAP','image','jpeg',0,'2zkbyekdras3bychfmmgo0t54iw10tb'),(953,'US-Navy-magnifying-glass-030903-N-2143T-001.jpg','20040521160444!US_Navy_magnifying_glass_030903-N-2143T-001.jpg',286843,1312,2000,8,'Magnifying glass, US Navy Newsstand photo, PD',6468,'Zanimum','20040521155500','0','BITMAP','image','jpeg',0,'1wulnk087j9pr0obeci6p906mek5yki'),(954,'Colchester-town-800.jpg','20040521232205!Colchester_town_800.jpg',145675,800,896,8,'Colchester  {{msg:GFDL}}',6561,'Sannse','20040521231827','0','BITMAP','image','jpeg',0,'85siuyccmbomiynx6ydyu6ubl6ryskp'),(955,'Strasbourg.jpg','20040521235956!Strasbourg.jpg',97913,1208,860,8,'{{msg:GFDL}}',62211,'Xandar','20040521162702','0','BITMAP','image','jpeg',0,'s1nxubawzu91o6zbd3rd4ee35tfqtju'),(956,'LGA-Tas-SE-Kingborough.png','20040522032111!LGA_Tas_SE_Kingborough.png',26190,395,367,8,'Map of SE Tasmanian LGA\'s feat Kingborough',3861,'Chuq','20040518120709','0','BITMAP','image','png',0,'dnq479926jh9lym5s51psct91rbo8dx'),(957,'MetroRail.jpg','20040522043227!MetroRail.jpg',105538,1600,1200,8,'Inside the Toyota Center',15708,'WhisperToMe','20040213014231','0','BITMAP','image','jpeg',0,'eust06i5hgdsxnydy6zbt8ek0mgyqwm'),(958,'Basic-smothered-mate.png','20040522132401!Basic_smothered_mate.png',2105,258,258,8,'A skeletal [[smothered mate]].',3113,'Camembert','20031106011848','0','BITMAP','image','png',0,'hh2g1r4o90mha2fvsuncsbk91rduwj9'),(959,'Stacks-jaredwf.png','20040522180506!Stacks_jaredwf.png',7185,251,251,8,'A series of stacks I created.  {{msg:PD}}',26381,'Jaredwf','20040522175205','0','BITMAP','image','png',0,'966xsw29kuetmkshzr77y3otbefag7b'),(960,'Leftmostderivations-jaredwf.png','20040522195635!Leftmostderivations_jaredwf.png',7791,301,130,8,'Two leftmost derivations for a string created by me. {{msg:PD}}',26381,'Jaredwf','20040522194843','0','BITMAP','image','png',0,'krwn3rr9bc1n3oxxjfod9p5gcj515gs'),(961,'Azulene.png','20040523083412!Azulene.png',5934,168,136,8,'Structure of Azulene (created by me after observing many images of it, which i have seen in books and websites)',63871,'SudhirP','20040523080212','0','BITMAP','image','png',0,'q7vp5p665f4zt46bhbt3lg1av59w0bb'),(962,'Sn2-Sn1-Graph.png','20040523083903!Sn2_Sn1_Graph.png',16239,300,300,8,'Graph of Sn2 and Sn2 reaction rates, designed by me, details being obtained from various texts',63871,'SudhirP','20040429160540','0','BITMAP','image','png',0,'f7kva16v05ofbb3lxx0a45b9e1tso2d'),(963,'Sn2-Sn1-Graph.png','20040523084524!Sn2_Sn1_Graph.png',16489,300,300,8,'Graph without signature, original by SudhirP',34751,'ElBenevolente','20040523083903','0','BITMAP','image','png',0,'i9xzqk4751mxbrlpigfrt2l63svary9'),(964,'Coronene.png','20040523085204!Coronene.png',8968,300,300,8,'Structure of Coronene ; image created by me',63871,'SudhirP','20040512015828','0','BITMAP','image','png',0,'nzcv0qjsfphb1vacfri3653prnwttl8'),(965,'LGA-Tas-SE-Hobart.png','20040523094447!LGA_Tas_SE_Hobart.png',25825,395,367,8,'Map of SE Tasmanian LGA\'s feat Hobart',3861,'Chuq','20040518120650','0','BITMAP','image','png',0,'a93sfturizyikizuqnvgui98gz8hnu4'),(966,'Music-hairpins.png','20040523185535!Music_hairpins.png',1293,304,88,8,'Hairpins in [[musical notation]]. Image made with [[Sibelius notation program|Sibelius]] and the [[GIMP]].',3113,'Camembert','20031018014850','0','BITMAP','image','png',0,'pmlh57hxj50pb47vad8g3ma0gn8x2jh'),(967,'Sir-ernest-satow.jpg','20040524023608!Sir_ernest_satow.jpg',37443,299,396,8,'Sir Ernest Satow',70689,'Roxymusic','20040524022307','0','BITMAP','image','jpeg',0,'h3aykw1a0rhb5hpkb3gs1nbx0kxybke'),(968,'Ottawa-Airport.jpg','20040524025337!Ottawa_Airport.jpg',137473,1084,948,8,'I took this photo myself.',50505,'Steggall','20040524023731','a:27:{s:4:\"Make\";s:21:\"EASTMAN KODAK COMPANY\";s:5:\"Model\";s:31:\"KODAK DC240 ZOOM DIGITAL CAMERA\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:13:\"4718592/65536\";s:11:\"YResolution\";s:13:\"4718592/65536\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"QuickTime 6.5.1\";s:8:\"DateTime\";s:19:\"2004:05:23 22:29:51\";s:16:\"YCbCrPositioning\";i:1;s:9:\"Copyright\";s:32:\"KODAK DC240 ZOOM DIGITAL CAMERA \";s:12:\"ExposureTime\";s:4:\"1/60\";s:7:\"FNumber\";s:5:\"67/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"1999:02:03 17:37:48\";s:17:\"DateTimeDigitized\";s:19:\"1999:02:03 17:37:48\";s:17:\"ShutterSpeedValue\";s:5:\"60/10\";s:13:\"ApertureValue\";s:5:\"55/10\";s:17:\"ExposureBiasValue\";s:5:\"0/100\";s:16:\"MaxApertureValue\";s:5:\"36/10\";s:12:\"MeteringMode\";i:1;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:6:\"120/10\";s:10:\"ColorSpace\";i:1;s:13:\"ExposureIndex\";s:5:\"140/1\";s:13:\"SensingMethod\";i:2;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'5qj7j4o12byd0ejzi6z693dk6gj9dei'),(969,'TwCere2.png','20040524095717!TwCere2.png',16449,200,247,8,'',62080,'Grinner','20040517095540','0','BITMAP','image','png',0,'1gt6j43qvvvj1fol4dejc6c2b6tmp3r'),(970,'SonomaCountyCoast20040519.jpg','20040524190905!SonomaCountyCoast20040519.jpg',0,0,0,0,'photo of the Pacific Ocean at Jenner, California by Brian Corr, May 19, 2004',21737,'Bcorr','20040524190609','0','BITMAP','image','jpeg',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(971,'SonomaCountyCoast20040519.jpg','20040524191118!SonomaCountyCoast20040519.jpg',68747,480,360,8,'photo of the Pacific Ocean at Jenner, California by Brian Corr, May 19, 2004',21737,'Bcorr','20040524190906','0','BITMAP','image','jpeg',0,'emmm8szw5s1zydcla7csm2eo43yy1ql'),(972,'Rideau-Sign.JPG','20040524203607!Rideau_Sign.JPG',227821,640,480,8,'Sign at the Entrance to the Rideau Canal - Taken March 2004',50505,'Steggall','20040524203056','a:27:{s:4:\"Make\";s:21:\"EASTMAN KODAK COMPANY\";s:5:\"Model\";s:31:\"KODAK DC240 ZOOM DIGITAL CAMERA\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:14:\"12582912/65536\";s:11:\"YResolution\";s:14:\"12582912/65536\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"QuickTime 6.5.1\";s:8:\"DateTime\";s:19:\"2004:05:24 16:28:34\";s:16:\"YCbCrPositioning\";i:1;s:9:\"Copyright\";s:32:\"KODAK DC240 ZOOM DIGITAL CAMERA \";s:12:\"ExposureTime\";s:5:\"1/125\";s:7:\"FNumber\";s:5:\"95/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"1999:02:04 15:55:51\";s:17:\"DateTimeDigitized\";s:19:\"1999:02:04 15:55:51\";s:17:\"ShutterSpeedValue\";s:5:\"70/10\";s:13:\"ApertureValue\";s:5:\"65/10\";s:17:\"ExposureBiasValue\";s:5:\"0/100\";s:16:\"MaxApertureValue\";s:5:\"36/10\";s:12:\"MeteringMode\";i:1;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:6:\"120/10\";s:10:\"ColorSpace\";i:1;s:13:\"ExposureIndex\";s:5:\"140/1\";s:13:\"SensingMethod\";i:2;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'k8egzlqhzve6fggufplwxgs5fminhlz'),(973,'Cy-map.png','20040525002344!Cy-map.png',12574,634,324,4,'Map of [[Cyprus]] from [http:/ / www.lib.utexas.edu/ maps/ cia02/ cyprus_sm02.gif CIA World Factbook].',17226,'Grendelkhan','20040525001505','0','BITMAP','image','png',0,'9tawdns37ylcwesw5ssxogqsgmkj6mg'),(974,'Sheepsfoot.jpg','20040525033802!Sheepsfoot.jpg',0,0,0,0,'Photograph taken by Ivan Yulaev (myself){{msg:GFDL}}',71009,'Ivan yulaev','20040525033052','0','BITMAP','image','jpeg',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(975,'Flag-icon.svg','20040525113840!Flag_icon.svg',1186,32,32,0,'small blue flag',41853,'Kenny sh','20040523135406','','DRAWING','image','svg+xml',0,'34jvcdy8bx7fm597k0cjsewlxrs1691'),(976,'Flag-icon.png','20040525113924!Flag_icon.png',589,32,32,8,'small blue flag',41853,'Kenny sh','20040523135421','0','BITMAP','image','png',0,'mrxjpikfzexjj6fpze6biukrs2n90nq'),(977,'Bentley.ContinentalGT.coupe.300pix.jpg','20040525133220!Bentley.ContinentalGT.coupe.300pix.jpg',106477,300,400,8,'2004 Bentley Continental GT Coupe at the 2004 North American International Auto Show in Detroit. Picture taken by Martin Hidinger in January 2004 and released to the public domain.',44008,'Mumriken','20040224193948','0','BITMAP','image','jpeg',0,'6x97n5ob29dm0ag6bedxxuu3g4wxe7g'),(978,'Usinprogress.PNG','20040525143033!Usinprogress.PNG',37466,280,183,8,'update',35314,'Seth Ilys','20040520222042','0','BITMAP','image','png',0,'kp7zdstw3s69nb0kccuhzkxf88i04pl'),(979,'TCOIL3.png','20040526084547!TCOIL3.png',34886,478,333,8,'TCOIL3.png',13833,'Reddi','20040518162102','0','BITMAP','image','png',0,'5ns99wsmfglm8balq6arpf819k11bh8'),(980,'TCOIL3.png','20040526084814!TCOIL3.png',15047,1024,768,8,'Reverted to earlier revision',56905,'Kieff','20040526084547','0','BITMAP','image','png',0,'1i7p930xxi7zcc7ysaymilsntn57pj4'),(981,'Isoflurane.png','20040526095505!Isoflurane.png',4274,452,192,8,'{{msg:GFDL}} <br> Structural formula of isoflurane. Typeset with PPCHTeX',30200,'Sverdrup','20040525221623','0','BITMAP','image','png',0,'s2u812i62mv07yiqmmwoewzqhiwhhfw'),(982,'Desflurane.png','20040526103136!Desflurane.png',6415,864,383,8,'retry',30200,'Sverdrup','20040526102938','0','BITMAP','image','png',0,'sk6c8ja26bc1ix3i3875rq2wjdg1qqb'),(983,'Usinprogress.PNG','20040526190157!Usinprogress.PNG',37502,280,183,8,'update',35314,'Seth Ilys','20040525143042','0','BITMAP','image','png',0,'ggfgpv9y7ylruln8eyqchm392z8wvrt'),(984,'Eequor-icon.gif','20040526201309!Eequor-icon.gif',5151,96,96,6,'Personal icon.',49577,'Eequor','20040526172804','0','BITMAP','image','gif',0,'cnni15hwmsgqs71n075k6ss0k094qqv'),(985,'Eequor-icon.gif','20040526203456!Eequor-icon.gif',5764,96,96,6,'Personal icon.',49577,'Eequor','20040526201329','0','BITMAP','image','gif',0,'7l9lra3q6oyfajsfnydl9nl14z80hxx'),(986,'Thrawn.jpg','20040527215157!Thrawn.jpg',148211,290,403,8,'Grand Admiral Thrawn',63572,'Husnock','20040527215138','0','BITMAP','image','jpeg',0,'ibaq1m8z3pun2gxdvubhq0amdd7b4ie'),(987,'Thrawn.jpg','20040527215233!Thrawn.jpg',148211,290,403,8,'Grand Admiral Thrawn',63572,'Husnock','20040527215157','0','BITMAP','image','jpeg',0,'ibaq1m8z3pun2gxdvubhq0amdd7b4ie'),(988,'Athens-Landsat.jpg','20040528033605!Athens_Landsat.jpg',47934,432,423,8,'NASA Landsat of Athens',15708,'WhisperToMe','20040207063109','0','BITMAP','image','jpeg',0,'3z5iplw9rfvjddcya1uatqe2fge6jtx'),(989,'Flow-volume-loop.png','20040528170811!Flow-volume-loop.png',23367,1067,733,8,'Spriometry Flow-Volume loop. Created myself from a printout.',49222,'Silvermask','20040504044222','0','BITMAP','image','png',0,'8y232sgfjjnif9e5lg64piv576lskql'),(990,'Flow-volume-loop.png','20040528191106!Flow-volume-loop.png',67799,814,733,8,'Annotated flow volume loop graph',20762,'Prisonblues','20040528170811','0','BITMAP','image','png',0,'0bwfqo40nw240td6o4dt6h3xo8vkptt'),(991,'Flow-volume-loop.png','20040528193917!Flow-volume-loop.png',67062,814,733,8,'Annotated flow volume loop graph',20762,'Prisonblues','20040528191106','0','BITMAP','image','png',0,'0nbogmd28vf6383ofngjdmimqinscd3'),(992,'Wikimedia-servers.png','20040529003359!Wikimedia-servers.png',366961,512,384,8,'This is a picture of the servers on the first day of install.  {{msg:GFDL}}',24,'Jimbo Wales','20040528175208','0','BITMAP','image','png',0,'lp6h2v6kfsvg89vhzicj5olvlyk03um'),(993,'Wikimedia-servers.png','20040529003704!Wikimedia-servers.png',349701,512,384,8,'lossless compressed version, no other changes, no changes meriting copyright protection.',22105,'Jamesday','20040529003359','0','BITMAP','image','png',0,'e4yauryfjxwbcevmooap9o34h3h6nin'),(994,'Espirito-Santo-Map-with-Viana-Municipality-Highlighted.png','20040529194422!Espirito_Santo_Map_with_Viana_Municipality_Highlighted.png',7332,218,345,8,'png version of Espirito Santo Map with Viana Municipality Highlighted.bmp',3628,'Hephaestos','20040516013458','0','BITMAP','image','png',0,'kowpocwmrydhrac2vezj7768fgitccj'),(995,'Show-preview.png','20040530095446!Show_preview.png',64693,460,243,8,'hint',4635,'Tim Starling','20040227030339','0','BITMAP','image','png',0,'nmj8c8aacnl1cu2qgns0rz2bthye3b3'),(996,'Sint-Lievens-HoutemLocatie.png','20040530135836!Sint-Lievens-HoutemLocatie.png',4051,270,203,8,'',34451,'Fuelbottle','20040530134946','0','BITMAP','image','png',0,'rwlclavha9e73gbtnx3zbme9pu0nedb'),(997,'Flow-volume-loop.png','20040530140608!Flow-volume-loop.png',77850,927,733,8,'Annotated flow volume loop graph',20762,'Prisonblues','20040528193917','0','BITMAP','image','png',0,'fngt9ih480aacgnzi0mqp79jkrnr2a4'),(998,'ProblemFramesProblemContext1.jpg','20040530150528!ProblemFramesProblemContext1.jpg',6782,205,161,8,'Illustration of a Problem Frames problem context',71835,'StephenFerg','20040528004851','0','BITMAP','image','jpeg',0,'3riwqqs5yrdza3grg9ayrokd4j2jq2n'),(999,'ProblemFramesProblemContext2.png','20040530152040!ProblemFramesProblemContext2.png',0,0,0,0,'',71835,'StephenFerg','20040530151650','','TEXT','text','plain',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(1000,'ProblemFramesProblemContext2.png','20040530152403!ProblemFramesProblemContext2.png',0,0,0,0,'',71835,'StephenFerg','20040530152041','','TEXT','text','plain',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(1001,'ProblemFramesProblemContext2.png','20040530152643!ProblemFramesProblemContext2.png',1799,239,42,8,'',71835,'StephenFerg','20040530152403','0','BITMAP','image','png',0,'d7kzj53k7mcwh6uva3hb2wz04r3iyst'),(1002,'ProblemFramesContextDiagram1.png','20040530153424!ProblemFramesContextDiagram1.png',15633,406,187,1,'',71835,'StephenFerg','20040530152850','0','BITMAP','image','png',0,'81wf2um7xob4cbt6ix6jbyyi2v2421d'),(1003,'Flag-icon.svg','20040530153401!Flag_icon.svg',1271,32,32,0,'more stright',41853,'Kenny sh','20040525113850','','DRAWING','image','svg+xml',0,'n4mjs5ifibzsw5b57h7njrq6bvtzz0y'),(1004,'Crecy.png','20040531002340!Crecy.png',36617,631,489,8,'smaller sketch of the battle of Crecy',8201,'Muriel Gottrop','20030827134403','0','BITMAP','image','png',0,'l6lj4riu5a365dqon7c4h1ns2mnmcpw'),(1005,'Crecy.png','20040531002412!Crecy.png',45255,946,733,8,'Reverted to earlier revision',55210,'Tim706','20040531002342','0','BITMAP','image','png',0,'qnwbog90o0q5ilu2z6s8vt34kfut93x'),(1006,'Atari-TOS-1-0.png','20040531013104!Atari_TOS_1_0.png',4156,320,200,8,'Screenshot of Atari TOS 1.0 desktop, snapshot by me, fair use because it displays icons etc owned by Atari/Digital Research and their successors {{msg:fairuse}}',72631,'Tjansen','20040530233929','0','BITMAP','image','png',0,'0e5bs6ys2m5biquwrndg9bft91y0xh5'),(1007,'EU-GDP-pc-vs-average.png','20040531120606!EU_GDP_pc_vs_average.png',9780,583,357,8,'EU GDP per capita (% compared to EU average) - self-made graph, {{msg:GFDL}}',49236,'Zoney','20040505165238','0','BITMAP','image','png',0,'crg6evfz282shlcd56g687rh2k34yo2'),(1008,'Sengore.jpg','20040531190137!Sengore.jpg',13728,145,196,8,'',35792,'AmericanCentury21','20040310021625','0','BITMAP','image','jpeg',0,'e2yaosmtgqn9kkw9d16k7hrokklzx4h'),(1009,'Puyo-whatisagroup.png','20040601032142!Puyo-whatisagroup.png',2588,320,192,8,'What is and is not a group in Puyo Puyo, by Damian Yerrick',1,'Damian Yerrick','20040601022628','0','BITMAP','image','png',0,'s3u1sq355gn6ad6j3juy5heg6cqw99u'),(1010,'Wpdms-na-elizabeth-islands.jpg','20040601040053!Wpdms_na_elizabeth_islands.jpg',33350,300,255,8,'[[Elizabeth Islands]] &#169;2004 Matthew Trump {{msg:GFDL}}',37527,'Decumanus','20040601033110','0','BITMAP','image','jpeg',0,'mr61am7bnou8csermktesioaa4i3zvo'),(1011,'Tasman-bridge.jpg','20040601062627!Tasman_bridge.jpg',4060,607,47,8,'Photograph of Tasman Bridge, from the North',29161,'Securiger','20040601061306','0','BITMAP','image','jpeg',0,'tmudcxuau1a1c9637esvnsojalvxitq'),(1012,'Saleh.jpeg','20040601062827!Saleh.jpeg',4939,150,200,8,'This is a picture of ABDULLAH AHMED ABDULLAH taken directly from the FBI Most wanted terrorist website dedicated to him. Since it was created by the US government, it is in the public domain',35478,'Alphaxer0','20040601062809','0','BITMAP','image','jpeg',0,'m75wkscit5ffs0t1hpv6htp3ox7ijjd'),(1013,'Saleh.jpeg','20040601063311!Saleh.jpeg',4939,150,200,8,'This is a picture of ABDULLAH AHMED ABDULLAH taken directly from the FBI Most wanted terrorist website dedicated to him. Since it was created by the US government, it is in the public domain',35478,'Alphaxer0','20040601062828','0','BITMAP','image','jpeg',0,'m75wkscit5ffs0t1hpv6htp3ox7ijjd'),(1014,'Tasman-bridge.jpg','20040601063741!Tasman_bridge.jpg',5112,599,71,8,'Second attempt at cropping & shrinking same photo',29161,'Securiger','20040601062627','0','BITMAP','image','jpeg',0,'1gkjt55lhqntiz1mk6wm7d9tpic04qk'),(1015,'Poincare-sphere.png','20040601122815!Poincare_sphere.png',10128,230,220,8,'',60494,'Russell E','20040528130338','0','BITMAP','image','png',0,'6hi1rr1pkkh4ro7d75khz5z9fdnxjll'),(1016,'Poincare-sphere.png','20040601122928!Poincare_sphere.png',0,0,0,0,'',60494,'Russell E','20040601122815','0','BITMAP','image','png',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(1017,'Ems.jpg','20040601193546!Ems.jpg',17345,320,256,8,'EMS Unit treats a Cardiac Arrest Patient.',12714,'Dquiring','20040423000330','0','BITMAP','image','jpeg',0,'4baai1v13h3vvlh0pl848ts1nub5bzc'),(1018,'Sarajevogrb.JPG','20040601231241!Sarajevogrb.JPG',5292,119,150,8,'Sarajevogrb',72174,'Asim Led','20040601223200','0','BITMAP','image','jpeg',0,'8pd4he0skhxvjx31we6qbg44tjiqiin'),(1019,'Leh.jpg','20040602025335!Leh.jpg',13058,250,160,8,'leh, ladakh',44845,'Henry Flower','20040414175703','0','BITMAP','image','jpeg',0,'362h8ckmmlsfkd9lnlvo3l06281vxvh'),(1020,'Vvbyhour.png','20040602110330!Vvbyhour.png',2937,448,322,2,'update',18610,'VeryVerily','20040516090159','0','BITMAP','image','png',0,'17il7nn7yet4zi77esk5v9c66q0bxed'),(1021,'Human-icon.svg','20040602110346!Human_icon.svg',1398,32,32,0,'',41853,'Kenny sh','20040523135703','','DRAWING','image','svg+xml',0,'d9jvnprcr3x2rer6tqqikbso7s7wtcm'),(1022,'Alter-of-Slabodka.jpg','20040602133257!Alter_of_Slabodka.jpg',78589,620,892,8,'Old public photo-etching of the Alter (or \"Sabba\") of Slabodka, Rabbi Nosson Tzvi Finkel',6549,'IZAK','20040602060951','0','BITMAP','image','jpeg',0,'lke9xr0w8b1454j4uzz3k89hgyw7by2'),(1023,'Flinders-Street-Station.jpg','20040602135712!Flinders-Street-Station.jpg',141650,875,563,8,'Flinders Street Station viewed from the far corner of Flinders St. and Swanston St.',3830,'Tobin Richard','20040601085851','0','BITMAP','image','jpeg',0,'nkicmly511x8knsf46z3m6z8ezojr4f'),(1024,'Mazda-Miata-1991-front-view-with-added-racing-stripe.jpg','20040602152737!Mazda_Miata_1991_front_view_with_added_racing_stripe.jpg',13120,264,221,8,'I took this picture and made this file.  Permission is granted to copy, distribute and/or modify this document under the terms of the \'\'\'GNU Free Documentation License\'\'\', Version 1.2 or any later version published by the Free Software Foundation; with no',73437,'Tomkin','20040602152656','0','BITMAP','image','jpeg',0,'aypmklhv3wdsvels8wnjdrskanokrk8'),(1025,'Mazda-Miata-1991-front-view-with-added-racing-stripe.jpg','20040602154345!Mazda_Miata_1991_front_view_with_added_racing_stripe.jpg',13120,264,221,8,'\'\'Permission is granted to copy, distribute and/or modify this document under the terms of the \'\'\'GNU Free Documentation License\'\'\', Version 1.2 or any later version published by the Free Software Foundation; with no Invariant Sections, no Front-Cover Tex',73437,'Tomkin','20040602152737','0','BITMAP','image','jpeg',0,'aypmklhv3wdsvels8wnjdrskanokrk8'),(1026,'WikiFox.png','20040602154849!WikiFox.png',18485,135,155,8,'Wikilogo with Foxhead',11061,'Conti','20040602113733','0','BITMAP','image','png',0,'mdpskndu534a6sw5k8xaxq7a0vf0ylk'),(1027,'WikiFox.png','20040602210508!WikiFox.png',12109,135,155,8,'',11061,'Conti','20040602154849','0','BITMAP','image','png',0,'f6koeri228t8d2yakwqcug9wl92pyv4'),(1028,'WikiFox.png','20040602210616!WikiFox.png',12199,135,155,8,'',11061,'Conti','20040602210508','0','BITMAP','image','png',0,'3oxy6vbvn8sz3du0fnu00lg5e50w5q9'),(1029,'WikiFox.png','20040602214018!WikiFox.png',12199,135,155,8,'test',11061,'Conti','20040602210616','0','BITMAP','image','png',0,'3oxy6vbvn8sz3du0fnu00lg5e50w5q9'),(1030,'PLL,generic.png','20040603185152!PLL,generic.png',5123,999,204,8,'Diagram of the implementation of a typical PLL',35676,'Iain.mcclatchie','20040603014403','0','BITMAP','image','png',0,'1zwtlsd8o2qe9zb43waovg9yf03251g'),(1031,'Vernier.jpg','20040604144239!Vernier.jpg',49666,1024,1920,8,'Taken and adapted from French Wikipedia article on the vernier scale {{msg:GFDL}} ',23657,'Lumos3','20040604142357','0','BITMAP','image','jpeg',0,'ptjv0p6qvxbdzbdtu4ddgdmif3hqp4f'),(1032,'Vernier.jpg','20040604145605!Vernier.jpg',23351,492,567,8,'Cropped version',23657,'Lumos3','20040604144240','0','BITMAP','image','jpeg',0,'dgiz6v0m4aak2k5ax2u79bemeadfk1o'),(1033,'WikiFox.png','20040604171826!WikiFox.png',12187,135,155,8,'',11061,'Conti','20040602214019','0','BITMAP','image','png',0,'j9rqvo6gvs6gx17qy8p853fwzew4qia'),(1034,'WikiFox.png','20040604172427!WikiFox.png',11594,135,155,8,'',11061,'Conti','20040604171826','0','BITMAP','image','png',0,'ddvkazmeblyjqkfxnkeewyk3aglsoam'),(1035,'Ford-Ka.JPG','20040604203914!Ford_Ka.JPG',1253146,1600,1200,8,'My own picture',33469,'GerardM','20040312062417','a:32:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:21:\"Canon DIGITAL IXUS v2\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:03:08 15:53:44\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:5:\"1/160\";s:7:\"FNumber\";s:5:\"40/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:03:08 15:53:44\";s:17:\"DateTimeDigitized\";s:19:\"2004:03:08 15:53:44\";s:22:\"CompressedBitsPerPixel\";s:3:\"5/1\";s:17:\"ShutterSpeedValue\";s:6:\"234/32\";s:13:\"ApertureValue\";s:12:\"262144/65536\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:12:\"194698/65536\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:6:\"346/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"1600000/206\";s:21:\"FocalPlaneYResolution\";s:11:\"1200000/155\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:9:\"1600/1600\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'42pb2ztcs1irueaw4hisznbvwgkduaj'),(1036,'Circuit-comp.jpg','20040604213115!Circuit-comp.jpg',10969,329,223,8,'composition of classical circuits',61089,'CSTAR','20040604194140','0','BITMAP','image','jpeg',0,'9ao4uyzk73t8j9yttt91poib8gzybt0'),(1037,'US-tritan.jpg','20040604223047!US-tritan.jpg',5631,180,111,8,'Simulation of US 4-color map as seen by color-blind person with tritanopia (a rare form)',74076,'Bethoc','20040604221759','0','BITMAP','image','jpeg',0,'lnbs3v8q4u23arpnobzltiv58fs14oc'),(1038,'US-protan.jpg','20040604223118!US-protan.jpg',5582,180,111,8,'Simulation of US 4-color map as seen by color-blind person with protanopia',74076,'Bethoc','20040604221642','0','BITMAP','image','jpeg',0,'fvg0rtbrguuw75jl3gsv1ei0sa0nx3v'),(1039,'US-protan.jpg','20040604223332!US-protan.jpg',5582,180,111,8,'Simulation of US 4-color map as seen by color-blind person with protanopia',74076,'Bethoc','20040604223118','0','BITMAP','image','jpeg',0,'fvg0rtbrguuw75jl3gsv1ei0sa0nx3v'),(1040,'US-deuter.jpg','20040604223447!US-deuter.jpg',5584,180,111,8,'Simulation of US 4-color map as seen by color-blind person with deuteranopia',74076,'Bethoc','20040604220413','0','BITMAP','image','jpeg',0,'q0ruy79ql3ho0ijg9zh3f742ob63ulu'),(1041,'Chipmunk.png','20040605005952!Chipmunk.png',24114,493,234,4,'',0,'(Automated conversion)','20020720114937','0','BITMAP','image','png',0,'qjcr223f3pjynyydywvntppx8mcqze2'),(1042,'InspectahDeckTheMovement.jpg','20040605192246!InspectahDeckTheMovement.jpg',8966,200,200,8,'Fair use, low-resolution album cover for Inspectah Deck - The Movement',72223,'ChrisCostello','20040605192241','0','BITMAP','image','jpeg',0,'n72znj8uqr7l5yo4dlwp2cbxzyv3n0g'),(1043,'Brothers,-Oregon-rocket-launch.jpg','20040606054451!Brothers,_Oregon_rocket_launch.jpg',100997,599,449,8,'[[Model rocketry]] launch in [[Brothers, Oregon]]',35785,'Jholman','20040606054031','0','BITMAP','image','jpeg',0,'cch1hob3sxkvypdydo4934i5i0iz6ma'),(1044,'WikimeetlondonPic1-03.jpg','20040606111037!WikimeetlondonPic1-03.jpg',168845,1544,756,8,'[[user:theresa knott]] and [[user:VampWillow]]',62473,'John Foley','20040606110429','a:27:{s:4:\"Make\";s:5:\"CASIO\";s:5:\"Model\";s:9:\"QV-2000UX\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:14:\"99.09.07.11.08\";s:8:\"DateTime\";s:19:\"2004:06:06 11:02:42\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:13:\"10000/1683501\";s:7:\"FNumber\";s:5:\"28/10\";s:15:\"ExposureProgram\";i:2;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:06:05 15:23:01\";s:17:\"DateTimeDigitized\";s:19:\"2004:06:05 15:23:01\";s:22:\"CompressedBitsPerPixel\";s:15:\"6963200/1920000\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:5:\"20/10\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:12:\"121513/10000\";s:10:\"ColorSpace\";i:1;s:12:\"WhiteBalance\";i:1;s:9:\"Sharpness\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'n1kkxe89ui4telo2cd0cc5j73xahr5k'),(1045,'Irontriangle.PNG','20040608050324!Irontriangle.PNG',7842,326,259,8,'Reverted to earlier revision',41443,'Ubernetizen','20040514061807','0','BITMAP','image','png',0,'bhq7rv4swqihw54hsgkj9kymup7gzgd'),(1046,'Ascona.lago.jpg','20040608063012!Ascona.lago.jpg',42536,900,356,8,'Lago Maggiore',52422,'Dierk','20040605145927','0','BITMAP','image','jpeg',0,'bbjxn6j36biffcjqjowkzdyp0oce47e'),(1047,'Dame\'s-rocket.jpg','20040608155904!Dame\'s_rocket.jpg',0,0,0,0,'taken by myself',33103,'Hadal','20040608155916','0','BITMAP','image','jpeg',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(1048,'NorthernIrelandCommunity.png','20040608165643!NorthernIrelandCommunity.png',61943,716,323,8,'',55077,'Keith Edkins','20040519105338','0','BITMAP','image','png',0,'gzawqlnrkh8xs191hdvf049dt0owydy'),(1049,'NorthernIrelandCommunity.png','20040608165647!NorthernIrelandCommunity.png',24108,914,738,8,'nicer antialiasing',17287,'Morwen','20040608165644','0','BITMAP','image','png',0,'a0mv5s4qz7weco470xf2s7j5h98nppw'),(1050,'People-on-the-platform.jpg','20040608174602!People_on_the_platform.jpg',60744,640,480,8,'Hustle bustle of passengers at the Lahore Railway Station',60874,'Pale blue dot','20040608174321','a:26:{s:16:\"ImageDescription\";s:8:\"Sunplus \";s:4:\"Make\";s:8:\"Sunplus \";s:5:\"Model\";s:8:\"Spca533 \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:06:08 15:50:21\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:8:\"10/25000\";s:7:\"FNumber\";s:5:\"30/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004/06/08 11:37:26\";s:17:\"DateTimeDigitized\";s:19:\"2004/06/08 11:37:26\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:6:\"139/10\";s:16:\"MaxApertureValue\";s:7:\"317/100\";s:12:\"MeteringMode\";i:2;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:7:\"968/100\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'ils9lpye077iw1wq8260kvwrd94km69'),(1051,'Poly.pov','20040608183732!Poly.pov',8418,0,0,0,'POV-Ray file with platonic and archimedean solids, made my me, inspired by AndrewKepert\'s [[rhombic dodecahedron]] image. Either GPL or GFDL, whichever is relevant to .pov files...',7586,'Cyp','20040608164613','','UNKNOWN','unknown','unknown',0,'32dxxk5xufso491orazina3xd5626d9'),(1052,'Usinprogress.PNG','20040608213207!Usinprogress.PNG',37626,280,183,8,'update',35314,'Seth Ilys','20040526190158','0','BITMAP','image','png',0,'edye9e3vv485kh2a7j81fqi3z7con1h'),(1053,'World2001-pm-non3.jpg','20040608225147!World2001-pm-non3.jpg',62081,512,662,8,'{{PD-USGov}} <br>From: http://aa.usno.navy.mil/faq/docs/first_sunrise.html',46219,'Niteowlneils','20040608224356','0','BITMAP','image','jpeg',0,'h9yksujd9agjrursy386r30pkcn9951'),(1054,'World2001-pm-non3.jpg','20040608225330!World2001-pm-non3.jpg',62081,512,662,8,'Try this again',46219,'Niteowlneils','20040608225148','0','BITMAP','image','jpeg',0,'h9yksujd9agjrursy386r30pkcn9951'),(1055,'SharksRugbyClubLogo.jpg','20040609012532!SharksRugbyClubLogo.jpg',11444,240,172,8,'Sharks rugby club logo {{fairuse}}',20772,'Stormie','20040609010953','0','BITMAP','image','jpeg',0,'3dsuuiygxtac0novd9c4knonqx3byvg'),(1056,'CondorcetTennesee.png','20040609054822!CondorcetTennesee.png',2634,413,117,8,'Census.gov map used in example for explaining Condorcet\'s method',96,'RobLa','20030518055823','0','BITMAP','image','png',0,'4ht5h9447gv27g6jvdd4l2n414li4ce'),(1057,'Poly.pov','20040609092504!Poly.pov',8551,0,0,0,'No reflection',7586,'Cyp','20040608183832','','UNKNOWN','unknown','unknown',0,'bon7j0f65l26fuo0hd6vmyikasyn4zv'),(1058,'Poly.pov','20040609222520!Poly.pov',8651,0,0,0,'Less flash option, should probably be used when making videos',7586,'Cyp','20040609092523','','UNKNOWN','unknown','unknown',0,'9ro7s1d1k3cd1wgfxtgf036yypa73xi'),(1059,'Poly.pov','20040609222946!Poly.pov',12609,0,0,0,'Added catalan solids',7586,'Cyp','20040609222524','','UNKNOWN','unknown','unknown',0,'mtx3zzo6wlr848dq36q5d9p283xuo8n'),(1060,'Poly.pov','20040610002024!Poly.pov',12611,0,0,0,'Commenting line, so only one polyhedron is selected, in case anyone tried to render without reading the file, and gets a weird mixture of two solids',7586,'Cyp','20040609222950','','UNKNOWN','unknown','unknown',0,'svq2hcx77mg0vhj0ig76nz4iwpuncj6'),(1061,'Kauai-from-space.jpg','20040610024041!Kauai_from_space.jpg',118343,450,450,8,'Rotated picture to put north near upper edge',16734,'Marshman','20040117015533','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:01:16 15:54:54\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'f29st5nkwmy7w2nwrid64seb328e3ia'),(1062,'Kauai-from-space.jpg','20040610025329!Kauai_from_space.jpg',11908,350,348,8,'correcting image orientation (north up) and cropping',37527,'Decumanus','20040610024045','0','BITMAP','image','jpeg',0,'hbqnmq402o28zumoxw47k7ryvdl8c3q'),(1063,'ScotlandInvernessLieut.png','20040610105710!ScotlandInvernessLieut.png',30157,200,229,8,'Inverness Lieutenancy',55077,'Keith Edkins','20040331085849','0','BITMAP','image','png',0,'89fn6hq1e0uqx11hqbzoxtfoyuca86q'),(1064,'Darwin-family-tree-v1.png','20040610143316!Darwin_family_tree_v1.png',5397,720,540,4,'Darwin family tree',35830,'Cutler','20040303211017','0','BITMAP','image','png',0,'959xsagfm8tvyswztunvt9tgy64f59d'),(1065,'Wpdms-nasa-topo-bay-of-fundy.jpg','20040610170644!Wpdms_nasa_topo_bay_of_fundy.jpg',16508,300,350,8,'Bay of Fundy',37527,'Decumanus','20040302195815','0','BITMAP','image','jpeg',0,'0rtwntvnf2bqnj27iyzbpnczz01uu1c'),(1066,'Kaohsiung-County-location.jpg','20040611005246!Kaohsiung_County_location.jpg',12706,214,299,8,'Made by [[user:spencer195]]',42891,'Spencer195','20040611005018','0','BITMAP','image','jpeg',0,'ea2q19iediojqusfhmmzgf0hxr6anro'),(1067,'Kaohsiung-County-location.jpg','20040611005424!Kaohsiung_County_location.jpg',13351,214,299,8,'Fixed colors',42891,'Spencer195','20040611005248','0','BITMAP','image','jpeg',0,'irti4ovmjo9q01m0zwgkm6byuic5vwg'),(1068,'Kaohsiung-County-location.jpg','20040611005442!Kaohsiung_County_location.jpg',13351,214,299,8,'Fixed colors',42891,'Spencer195','20040611005426','0','BITMAP','image','jpeg',0,'irti4ovmjo9q01m0zwgkm6byuic5vwg'),(1069,'Kasparov-vs-World-move-14b.png','20040611064618!Kasparov_vs_World_move_14b.png',4878,258,258,8,'The position in Kasparov v. The World, 1999, after black\'s fourteenth move',856,'Fritzlein','20040611064324','0','BITMAP','image','png',0,'5cafq22azak2d53agybekltcqti23hd'),(1070,'Home-in-lahore-(2).JPG','20040611075010!Home_in_lahore_(2).JPG',32620,640,480,8,'Home in  Lahore',60874,'Pale blue dot','20040611064703','0','BITMAP','image','jpeg',0,'gg2sszk5d1lysuzax4afvtpyppfrav0'),(1071,'Home-in-lahore-(2).JPG','20040611075317!Home_in_lahore_(2).JPG',32620,640,480,8,'Home in  Lahore',60874,'Pale blue dot','20040611075010','0','BITMAP','image','jpeg',0,'gg2sszk5d1lysuzax4afvtpyppfrav0'),(1072,'St.-Catherine%27s-College%2C-Cambridge.arp.jpg','20040611084111!St._Catherine%27s_College%2C_Cambridge.arp.jpg',75349,750,504,8,'Levelled, cut from 330K to 87K, lightened, sharpened',7095,'Arpingstone','20040611083351','',NULL,'unknown','unknown',0,''),(1073,'Map-of-Hunterdon-County-highlighting-Kingwood-Township.png','20040611150224!Map_of_Hunterdon_County_highlighting_Kingwood_Township.png',13526,552,665,8,'taken from State of New Jersey website - adapted by H. Cheney - GFDL & CC-SA-BY',35530,'Hcheney','20040611150209','0','BITMAP','image','png',0,'e0c8c9hfzkvfj21rqx25y6ogz2w7imu'),(1074,'Nantou-County-location.png','20040611215417!Nantou_County_location.png',6626,230,310,8,'Made by [[user:spencer195]]',42891,'Spencer195','20040611215012','0','BITMAP','image','png',0,'ovgc1ijc0qk6643skndkuyns9gb8q0q'),(1075,'Sodfebruary1977.jpg','20040611220641!Sodfebruary1977.jpg',53313,384,563,8,'Soap Opera Digest: February 1977',74099,'TheCustomOfLife','20040611220528','0','BITMAP','image','jpeg',0,'lyy9gytp0574k6sezx02bbnzfygzux7'),(1076,'Nantou-County-location.png','20040611230739!Nantou_County_location.png',6490,211,296,8,'Made by [[user:spencer195]]',42891,'Spencer195','20040611215418','0','BITMAP','image','png',0,'99jnjsmuyfrgommin5966b51hhplyjv'),(1077,'Nantou-County-location.png','20040611230840!Nantou_County_location.png',6490,211,296,8,'Made by [[user:spencer195]]',42891,'Spencer195','20040611230739','0','BITMAP','image','png',0,'99jnjsmuyfrgommin5966b51hhplyjv'),(1078,'Nantou-County-location.png','20040611230929!Nantou_County_location.png',7002,211,296,8,'Made by [[user:spencer195]]',42891,'Spencer195','20040611230840','0','BITMAP','image','png',0,'7p0g6hbb0hp05lq31ms2bdptd5w5fg5'),(1079,'Nantou-County-location.png','20040611230959!Nantou_County_location.png',7002,211,296,8,'Made by [[user:spencer195]]',42891,'Spencer195','20040611230929','0','BITMAP','image','png',0,'7p0g6hbb0hp05lq31ms2bdptd5w5fg5'),(1080,'Drumstick-anatomy.png','20040612081010!Drumstick_anatomy.png',10022,200,550,8,'drawn by me using [[Inkscape]] {{PD}}',42385,'Lupin','20040612080701','0','BITMAP','image','png',0,'n9yi37rq0a6cp7kxfnpseo2u12arksf'),(1081,'M.dscn1253.jpg','20040612082030!M.dscn1253.jpg',75290,400,300,8,'Leaves, flowers, and old fruits of Acacia Koa trees',50867,'Edoardo biagioni','20040311215449','a:25:{s:4:\"Make\";s:5:\"NIKON\";s:5:\"Model\";s:5:\"E2500\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:9:\"E2500v1.0\";s:8:\"DateTime\";s:19:\"2004:02:22 12:00:10\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/6752\";s:7:\"FNumber\";s:5:\"35/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:02:22 12:00:10\";s:17:\"DateTimeDigitized\";s:19:\"2004:02:22 12:00:10\";s:22:\"CompressedBitsPerPixel\";s:3:\"4/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"29/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"97/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'nmcmiaz221gy7rpix2r2f2deeabesli'),(1082,'LiverpoolMetropolitanCathedral-OwlofDoom.jpg','20040612094559!LiverpoolMetropolitanCathedral_OwlofDoom.jpg',61884,800,600,8,'',21013,'Raul654','20040612092400','a:32:{s:4:\"Make\";s:8:\"FUJIFILM\";s:5:\"Model\";s:15:\"FinePix2600Zoom\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:38:\"Digital Camera FinePix2600Zoom Ver3.00\";s:8:\"DateTime\";s:19:\"2003:07:27 16:43:24\";s:16:\"YCbCrPositioning\";i:2;s:7:\"FNumber\";s:7:\"870/100\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2003:07:27 16:43:24\";s:17:\"DateTimeDigitized\";s:19:\"2003:07:27 16:43:24\";s:22:\"CompressedBitsPerPixel\";s:5:\"16/10\";s:17:\"ShutterSpeedValue\";s:7:\"770/100\";s:13:\"ApertureValue\";s:7:\"620/100\";s:15:\"BrightnessValue\";s:7:\"916/100\";s:17:\"ExposureBiasValue\";s:5:\"0/100\";s:16:\"MaxApertureValue\";s:7:\"360/100\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:7:\"860/100\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:6:\"3053/1\";s:21:\"FocalPlaneYResolution\";s:6:\"3053/1\";s:24:\"FocalPlaneResolutionUnit\";i:3;s:13:\"SensingMethod\";i:2;s:9:\"Sharpness\";i:3;s:12:\"WhiteBalance\";i:512;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'sj0li0xzd29y9hxnnptkxacce8i8ulw'),(1083,'LiverpoolMetropolitanCathedral-OwlofDoom.jpg','20040612095118!LiverpoolMetropolitanCathedral_OwlofDoom.jpg',61884,800,600,8,'Liverpool Metropolitan Cathedral',72402,'OwlofDoom','20040612094559','a:32:{s:4:\"Make\";s:8:\"FUJIFILM\";s:5:\"Model\";s:15:\"FinePix2600Zoom\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:38:\"Digital Camera FinePix2600Zoom Ver3.00\";s:8:\"DateTime\";s:19:\"2003:07:27 16:43:24\";s:16:\"YCbCrPositioning\";i:2;s:7:\"FNumber\";s:7:\"870/100\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2003:07:27 16:43:24\";s:17:\"DateTimeDigitized\";s:19:\"2003:07:27 16:43:24\";s:22:\"CompressedBitsPerPixel\";s:5:\"16/10\";s:17:\"ShutterSpeedValue\";s:7:\"770/100\";s:13:\"ApertureValue\";s:7:\"620/100\";s:15:\"BrightnessValue\";s:7:\"916/100\";s:17:\"ExposureBiasValue\";s:5:\"0/100\";s:16:\"MaxApertureValue\";s:7:\"360/100\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:7:\"860/100\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:6:\"3053/1\";s:21:\"FocalPlaneYResolution\";s:6:\"3053/1\";s:24:\"FocalPlaneResolutionUnit\";i:3;s:13:\"SensingMethod\";i:2;s:9:\"Sharpness\";i:3;s:12:\"WhiteBalance\";i:512;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'sj0li0xzd29y9hxnnptkxacce8i8ulw'),(1084,'LocationScotland.png','20040612113709!LocationScotland.png',6130,250,115,8,'Location map for Scotland',56643,'K851jg2','20040401082706','0','BITMAP','image','png',0,'ktfowh9vt09mwyefnoqw4z58xvpu5u0'),(1085,'Poly.pov','20040612130352!Poly.pov',12615,0,0,0,'Spelling correction - should be tetrakis and pentakis',7586,'Cyp','20040610002028','','UNKNOWN','unknown','unknown',0,'rafx3wtn91mlqxdxwhutmoj6cnldlmj'),(1086,'Wpdms-shdrlfi020l-matanuska-river.jpg','20040612183325!Wpdms_shdrlfi020l_matanuska_river.jpg',50546,300,280,8,'South Central [[Alaska]] showing [[Matanuska River|Matanuska]] and [[Susitna River|Susitna]] rivers. &#169; 2004 Matthew Trump {{GFDL}}',37527,'Decumanus','20040612182140','0','BITMAP','image','jpeg',0,'jnj0zv027mrmvs491pc6jhsrzoa91s4'),(1087,'Worldmap-lat-long-non.jpg','20040613024851!Worldmap-lat-long-non.jpg',34803,361,181,8,'{{PD-USGov}}<br>From: http://ghrc.msfc.nasa.gov/ssmi/ssmi.html',46219,'Niteowlneils','20040609010512','0','BITMAP','image','jpeg',0,'sfr6ekbaxtyxokb5a8uodwtduce2e6a'),(1088,'Worldmap-lat-long-non.jpg','20040613025203!Worldmap-lat-long-non.jpg',67956,781,1021,8,'test',46219,'Niteowlneils','20040613024851','0','BITMAP','image','jpeg',0,'clqwxjsi3an2zalrtmxckhauvzd88uh'),(1089,'Kaohsiung-County-location.png','20040613050914!Kaohsiung_County_location.png',6869,211,296,8,'Made by [[user:spencer195]]',42891,'Spencer195','20040611222555','0','BITMAP','image','png',0,'iexnn13mwwfvtalcp5gje1xy2ri422y'),(1090,'Kaohsiung-County-location.png','20040613051131!Kaohsiung_County_location.png',6869,211,296,8,'Kaohsiung City emblem.  Drawn by [[user:spencer195]] using [[Blender]].  ',42891,'Spencer195','20040613050914','0','BITMAP','image','png',0,'iexnn13mwwfvtalcp5gje1xy2ri422y'),(1091,'Kaohsiung-County-location.png','20040614001717!Kaohsiung_County_location.png',6869,211,296,8,'Made by [[user:spencer195]].',42891,'Spencer195','20040613051132','0','BITMAP','image','png',0,'iexnn13mwwfvtalcp5gje1xy2ri422y'),(1092,'Kaohsiung-County-location.png','20040614001815!Kaohsiung_County_location.png',7041,211,296,8,'Made by [[user:spencer195]]',42891,'Spencer195','20040614001718','0','BITMAP','image','png',0,'cjpwq2mmqzc5m2anm5k3cgxo0rrhmfr'),(1093,'Kaohsiung-County-location.png','20040614001826!Kaohsiung_County_location.png',7041,211,296,8,'Made by [[user:spencer195]].',42891,'Spencer195','20040614001816','0','BITMAP','image','png',0,'cjpwq2mmqzc5m2anm5k3cgxo0rrhmfr'),(1094,'Kaohsiung-County-location.png','20040614001910!Kaohsiung_County_location.png',7041,211,296,8,'Reverted to earlier revision',42891,'Spencer195','20040614001827','0','BITMAP','image','png',0,'cjpwq2mmqzc5m2anm5k3cgxo0rrhmfr'),(1095,'Chiayi-City-seal.png','20040614023601!Chiayi_City_seal.png',4080,149,150,8,'{{noncommercial}}',42891,'Spencer195','20040614023210','0','BITMAP','image','png',0,'ixn382bdf45g2rto8zu1l1vqqkjpmmo'),(1096,'June-12-2004-billboards-of-lahore-beauty-girl-c.JPG','20040614024059!June_12_2004-billboards_of_lahore-beauty_girl-c.JPG',24471,721,373,8,'Beauty Girl Cold Creme Billboard',60874,'Pale blue dot','20040614023836','0','BITMAP','image','jpeg',0,'7b3ph9w7fvs80u4kweiltmx4eclkkwg'),(1097,'June-12-2004-billboards-of-lahore-beauty-girl-c.JPG','20040614024208!June_12_2004-billboards_of_lahore-beauty_girl-c.JPG',30512,640,331,8,'Beauty Girl Cold Creme Billboard',60874,'Pale blue dot','20040614024059','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"96/1\";s:11:\"YResolution\";s:4:\"96/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:06:14 12:12:29\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'gspl483egx49sxq9g70vh2jp2x55t4k'),(1098,'Alfalah-Building-(the-Mall,-Lahore)---2.JPG','20040614181452!Alfalah_Building_(the_Mall,_Lahore)_-_2.JPG',42150,640,480,8,'Alfalah Building (the Mall, Lahore)',60874,'Pale blue dot','20040614085457','0','BITMAP','image','jpeg',0,'5eu7dxv83u8jsdwsg1zua1hv7qt7rmz'),(1099,'Bapta.png','20040615050113!Bapta.png',2426,225,199,8,'BAPTA',35331,'Diberri','20040105185135','0','BITMAP','image','png',0,'loyz6f7z47h0j2duh1yjjexg5x52der'),(1100,'PortArthurConvictChurch.jpg','20040615091841!PortArthurConvictChurch.jpg',19233,278,187,8,'Taken by David Morgan-Mar, April 2000, at Port Arthur, Tasmania. {{GFDL}}',48535,'Dmmaus','20040615091215','0','BITMAP','image','jpeg',0,'n7o1q984dbnyu50lmq8tzifyjujhh4s'),(1101,'Bar-chart-EP-election-2004-1999.png','20040615214401!Bar_chart_EP_election_2004_1999.png',6523,600,370,8,'Bar chart showing the distribution of seats among the party groups in the 1999 and 2004 european parliament elections. 2004 is based on \'\'\'preliminary\'\'\' results. {{GFDL}}, &copy; ~~~ 2004',72856,'Chmod007','20040615214137','0','BITMAP','image','png',0,'p9deimlw4u03m07951bzl9yo7i7ehvf'),(1102,'Si-romap.png','20040616172529!Si_romap.png',25871,636,325,8,'Map of Slovenia with Roman provinces and cities in green',29844,'Boraczek','20040616144122','0','BITMAP','image','png',0,'fzw7lvwg4ijpojoava1wsuvncnr5rnm'),(1103,'EU-GNI-pc-PPP.png','20040616183044!EU-GNI-pc-PPP.png',21979,683,467,8,'done by myself, data from World Bank',46083,'Cantus','20040616173027','0','BITMAP','image','png',0,'1yw88xqzdiujfoivvo95vag1ddpgnxh'),(1104,'Si-romap.png','20040616202201!Si_romap.png',24597,636,325,8,'Map of Slovenia with Roman provinces and cities',29844,'Boraczek','20040616172529','0','BITMAP','image','png',0,'m242m27b3weo27mf9zmplpw27f27sw5'),(1105,'Strand-underpass-london-800.jpg','20040616215045!Strand-underpass-london-800.jpg',112690,800,590,8,'Strand underpass, London, picture by Nevilley 14/6/04.',4191,'Nevilley','20040616211244','0','BITMAP','image','jpeg',0,'abzyncqi67u6jjp85fnuzpeax0o6ndk'),(1106,'Strand-underpass-london-800.jpg','20040616215323!Strand-underpass-london-800.jpg',298908,800,590,8,'New version has taxi numberplate rendered illegible (privacy)',4191,'Nevilley','20040616215052','0','BITMAP','image','jpeg',0,'77pr9m5fiov7f2oj4kxzgq06b27g6nf'),(1107,'Ontthb.PNG','20040617021344!Ontthb.PNG',9627,378,379,8,'Thunder Bay District, Ontario',15941,'Timc','20040617021221','0','BITMAP','image','png',0,'5vrkx1yajtrvfpr5liuubi38pw3mcnr'),(1108,'Davisonpeter.jpg','20040617050214!Davisonpeter.jpg',39312,311,449,8,'',49505,'Senor Spielbergo','20040401073146','0','BITMAP','image','jpeg',0,'47rdy20cpsxxcvehn8qghi268ee0ozs'),(1109,'Davisonpeter.jpg','20040617050246!Davisonpeter.jpg',25147,150,150,8,'Reverted to earlier revision',65753,'Histrion','20040617050215','0','BITMAP','image','jpeg',0,'q4uwa5r5ik4o55xc2h2ramx8wgku6bc'),(1110,'Test-Crude-EU25-colored-stretched-greens.png','20040617222745!Test_Crude-EU25-colored_stretched_greens.png',3154,262,160,8,'Test  green shades for EU25 map plus Malta',45336,'Wikibob','20040502121245','0','BITMAP','image','png',0,'3aelmjhyxhj56iolx7e6a74qh4gjlz6'),(1111,'Test-Crude-EU25-colored-stretched-greens.png','20040617223949!Test_Crude-EU25-colored_stretched_greens.png',42441,324,197,8,'Added the Date of Joining',59144,'Daniel,levine','20040617222813','0','BITMAP','image','png',0,'6ad0gffxittjczkuhj2lxj7cqq56qq8'),(1112,'WpGreatWallReproWeapons.jpg','20040617231503!WpGreatWallReproWeapons.jpg',79180,800,408,8,'Reproduction Weapons at the Great Wall',46238,'Leonard G.','20040617021304','0','BITMAP','image','jpeg',0,'essvil5s9876x2mvtbsg7c43iwhvqlk'),(1113,'Polarized.outlet.us.png','20040617234347!Polarized.outlet.us.png',2818,149,155,8,'Diagram of a U.S. standard, polarized, three-prong electrical socket outlet.',65216,'Clarknova','20040617210033','0','BITMAP','image','png',0,'p22pn8xxkl7ew865405yvucnxpwixw9'),(1114,'Hist-central-europe.JPG','20040618011538!Hist_central_europe.JPG',40431,577,339,8,'Historical lands and provinces in Central Europe',1522,'Space Cadet','20040611205815','0','BITMAP','image','jpeg',0,'33d6la6cbhv0r7f3poz4j8346nnaqgy'),(1115,'Hist-central-europe.JPG','20040618012321!Hist_central_europe.JPG',40331,461,341,8,'Historical lands and provinces in Central Europe',1522,'Space Cadet','20040618011538','0','BITMAP','image','jpeg',0,'80h91pu1jmsj919rsuvcvc1hcbwkjof'),(1116,'Hist-central-europe.JPG','20040618012347!Hist_central_europe.JPG',40331,461,341,8,'Historical lands and provinces in Central Europe',1522,'Space Cadet','20040618012321','0','BITMAP','image','jpeg',0,'80h91pu1jmsj919rsuvcvc1hcbwkjof'),(1117,'AFIVeryProudofYa.jpg','20040618072959!AFIVeryProudofYa.jpg',10720,200,200,8,'AFI - Very Proud of Ya album cover, fair use.',75819,'Darkstarwithin','20040618072950','0','BITMAP','image','jpeg',0,'sggen8jt1fcp6g6yuaqm43yjcvppp0f'),(1118,'Caltrain-logo.png','20040618074652!Caltrain_logo.png',5989,193,114,8,'logo of [Caltrain], identifying mark, assumed fair use, from caltrain.org',77508,'ChrisRuvolo','20040618073523','0','BITMAP','image','png',0,'6inquedd7pqkhn12ewbf1z7h1spnkdo'),(1119,'EU-blank-no-rivers-territories256.png','20040618114325!EU_blank_no_rivers_territories256.png',28925,510,452,8,'Blank version of existing EU map. {{msg:GFDL}}',49236,'Zoney','20040523231654','0','BITMAP','image','png',0,'6on0djf73l5qp7rzsq780r0pcrvi0um'),(1120,'Wapda-House-(the-Mall,-Lahore).JPG','20040619113457!Wapda_House_(the_Mall,_Lahore).JPG',23402,640,480,8,'Wapda House (Mall Road, Lahore)',60874,'Pale blue dot','20040614093547','0','BITMAP','image','jpeg',0,'1s3ykc2l5t8whgxbb0mkpum941xywb4'),(1121,'Lightning-rod.png','20040619160821!Lightning_rod.png',5993,158,223,8,'img fix [needed the gap]',13833,'Reddi','20031103163129','0','BITMAP','image','png',0,'8tcn8drehl5ui3szk46ursg7yj391ee'),(1122,'Woodsorrel-(Oxalis-acetosella).jpg','20040620023803!Woodsorrel_(Oxalis_acetosella).jpg',168543,932,694,8,'Woodsorrel, (\'\'Oxalis acetosella\'\'). Photographed 2004-05-01, &copy; Laila Remahl 2004. {{GFDL}}',72856,'Chmod007','20040619134711','a:40:{s:11:\"Compression\";i:6;s:4:\"Make\";s:21:\"EASTMAN KODAK COMPANY\";s:5:\"Model\";s:32:\"KODAK DX6440 ZOOM DIGITAL CAMERA\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:10:\"ImageReady\";s:21:\"JPEGInterchangeFormat\";i:2708;s:27:\"JPEGInterchangeFormatLength\";i:7711;s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:5:\"1/125\";s:7:\"FNumber\";s:5:\"48/10\";s:15:\"ExposureProgram\";i:2;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:05:01 12:45:43\";s:17:\"DateTimeDigitized\";s:19:\"2004:05:01 12:45:43\";s:17:\"ShutterSpeedValue\";s:5:\"70/10\";s:13:\"ApertureValue\";s:5:\"45/10\";s:17:\"ExposureBiasValue\";s:6:\"0/1000\";s:16:\"MaxApertureValue\";s:5:\"45/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:6:\"220/10\";s:10:\"ColorSpace\";i:1;s:13:\"ExposureIndex\";s:5:\"170/1\";s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:7:\"140/100\";s:21:\"FocalLengthIn35mmFilm\";i:132;s:16:\"SceneCaptureType\";i:0;s:11:\"GainControl\";s:3:\"1/1\";s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:20:\"SubjectDistanceRange\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'8qdkosah4zza2wdeuf4gtyrpjyueefe'),(1123,'Vvbyhour.png','20040620032727!Vvbyhour.png',2890,448,322,2,'update',18610,'VeryVerily','20040602110330','0','BITMAP','image','png',0,'n2psrmaukgvxubre30es7uk13tbvao1'),(1124,'Scarlet-pimpernel-close-800.jpg','20040620080759!Scarlet_pimpernel_close_800.jpg',193310,999,999,8,'Scarlet pimpernel {{GFDL}}',6561,'Sannse','20040613203604','0','BITMAP','image','jpeg',0,'6f93z125gshrqjtkaw861u5eve3n0g1'),(1125,'Acetylcholine.png','20040621072039!Acetylcholine.png',1842,276,112,8,'Version with subscripts',2,'AxelBoldt','20021223015320','0','BITMAP','image','png',0,'dqzy7th7a0a68294pz8c5ishz15vixh'),(1126,'2004-0101FlightNewYears0008.JPG','20040621082842!2004_0101FlightNewYears0008.JPG',0,0,0,0,'Corey Burger (User:Burgundavia)',64066,'Burgundavia','20040621082754','0','BITMAP','image','jpeg',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(1127,'2004-0101FlightNewYears0008.JPG','20040621082907!2004_0101FlightNewYears0008.JPG',123095,640,480,8,'Corey Burger (User:Burgundavia)',64066,'Burgundavia','20040621082843','a:38:{s:4:\"Make\";s:8:\"FUJIFILM\";s:5:\"Model\";s:14:\"FinePix A205  \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:37:\"Digital Camera FinePix A205   Ver1.00\";s:8:\"DateTime\";s:19:\"2003:01:01 00:00:18\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/700\";s:7:\"FNumber\";s:7:\"300/100\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2003:01:01 00:00:18\";s:17:\"DateTimeDigitized\";s:19:\"2003:01:01 00:00:18\";s:22:\"CompressedBitsPerPixel\";s:5:\"30/10\";s:17:\"ShutterSpeedValue\";s:7:\"610/100\";s:13:\"ApertureValue\";s:7:\"320/100\";s:15:\"BrightnessValue\";s:7:\"453/100\";s:17:\"ExposureBiasValue\";s:5:\"0/100\";s:16:\"MaxApertureValue\";s:7:\"320/100\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:7:\"550/100\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:6:\"1213/1\";s:21:\"FocalPlaneYResolution\";s:6:\"1213/1\";s:24:\"FocalPlaneResolutionUnit\";i:3;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"SceneCaptureType\";i:0;s:9:\"Sharpness\";i:3;s:20:\"SubjectDistanceRange\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'tb9tvfhe56q5s97v777merh90wybheq'),(1128,'Polska22-wolynskie.png','20040621094329!Polska22_wolynskie.png',2455,244,267,4,'[[Volhynian Voivodship]] map',32233,'Halibutt','20040621094229','0','BITMAP','image','png',0,'37yfa6ej9ar62bjuwrygsxjdm1obish'),(1129,'Polska22-wolynskie.png','20040621094432!Polska22_wolynskie.png',2559,244,267,8,'[[Volhynian Voivodship]] map - 2nd version',32233,'Halibutt','20040621094329','0','BITMAP','image','png',0,'p28t7s2i5h7q0dhoqq7jtszdq7jka2d'),(1130,'KleinBottleParametric.PNG','20040621124520!KleinBottleParametric.PNG',20259,347,321,8,'A Klein bottle which has been defined by a set of parametric equations.',9565,'AugPi','20040615155547','0','BITMAP','image','png',0,'6etaqxjk4yq4z124gel0kfm0wiuwuob'),(1131,'KleinBottleParametric.PNG','20040621125306!KleinBottleParametric.PNG',19712,349,319,8,'Improved version.',9565,'AugPi','20040621124520','0','BITMAP','image','png',0,'axqhamnmqcs8br7viyaopp11s3oy26k'),(1132,'Feodor-Chaliapin.jpg','20040621143324!Feodor_Chaliapin.jpg',43313,275,450,8,'Russian opera singer',14002,'Viajero','20040621143212','0','BITMAP','image','jpeg',0,'0jnw9ptp62dfuqfmtprtgxfvpnbursq'),(1133,'Many-Karelias.png','20040621184241!Many_Karelias.png',30824,500,664,8,'new, smaller version.',8534,'Jniemenmaa','20040408121103','0','BITMAP','image','png',0,'3xvw1bwvq4uge2ja0vddiozcd6c9cmy'),(1134,'GiantStumpCalaverasNorthGrove.jpg','20040621213438!GiantStumpCalaverasNorthGrove.jpg',31617,233,312,8,'ginat stump of \"Discovery Tree\" at North Grove  of Calaveras State Park.  Photograph taken by me. (Paul Telford)  {{cc-by}}',31050,'PxT','20040621212905','a:33:{s:4:\"Make\";s:15:\"Hewlett-Packard\";s:5:\"Model\";s:27:\"HP PhotoSmart C935 (V03.60)\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:13:\"4718592/65536\";s:11:\"YResolution\";s:13:\"4718592/65536\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"QuickTime 6.5.1\";s:8:\"DateTime\";s:19:\"2004:06:20 13:03:35\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:11:\"1219/100000\";s:7:\"FNumber\";s:7:\"260/100\";s:15:\"ExposureProgram\";i:7;s:15:\"ISOSpeedRatings\";i:200;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:06:19 09:41:39\";s:17:\"DateTimeDigitized\";s:19:\"2004:06:19 09:41:39\";s:17:\"ShutterSpeedValue\";s:8:\"1629/256\";s:13:\"ApertureValue\";s:7:\"724/256\";s:15:\"BrightnessValue\";s:7:\"817/256\";s:17:\"ExposureBiasValue\";s:5:\"0/256\";s:12:\"MeteringMode\";i:2;s:11:\"LightSource\";i:23;s:5:\"Flash\";i:28;s:11:\"FocalLength\";s:7:\"760/100\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:1;s:12:\"ExposureMode\";i:1;s:12:\"WhiteBalance\";i:0;s:16:\"SceneCaptureType\";i:2;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'bd7678iq3tlj1zte2o1b2cwlcoq09qm'),(1135,'GiantStumpCalaverasNorthGrove.jpg','20040621213547!GiantStumpCalaverasNorthGrove.jpg',73515,359,480,8,'ginat stump of \"Discovery Tree\" at North Grove  of Calaveras State Park.  Photograph taken by me. (Paul Telford)  {{cc-by}}',31050,'PxT','20040621213439','a:33:{s:4:\"Make\";s:15:\"Hewlett-Packard\";s:5:\"Model\";s:27:\"HP PhotoSmart C935 (V03.60)\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:13:\"4718592/65536\";s:11:\"YResolution\";s:13:\"4718592/65536\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"QuickTime 6.5.1\";s:8:\"DateTime\";s:19:\"2004:06:20 13:03:35\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:11:\"1219/100000\";s:7:\"FNumber\";s:7:\"260/100\";s:15:\"ExposureProgram\";i:7;s:15:\"ISOSpeedRatings\";i:200;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:06:19 09:41:39\";s:17:\"DateTimeDigitized\";s:19:\"2004:06:19 09:41:39\";s:17:\"ShutterSpeedValue\";s:8:\"1629/256\";s:13:\"ApertureValue\";s:7:\"724/256\";s:15:\"BrightnessValue\";s:7:\"817/256\";s:17:\"ExposureBiasValue\";s:5:\"0/256\";s:12:\"MeteringMode\";i:2;s:11:\"LightSource\";i:23;s:5:\"Flash\";i:28;s:11:\"FocalLength\";s:7:\"760/100\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:1;s:12:\"ExposureMode\";i:1;s:12:\"WhiteBalance\";i:0;s:16:\"SceneCaptureType\";i:2;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'82x93x57dir6plovzah1y3eqa2w9n6c'),(1136,'Cindy-cashdollar-wik.jpg','20040622001445!Cindy_cashdollar_wik.jpg',22414,360,360,8,'Press photo. {{msg:CopyrightedFreeUseProvided}} the photographer is credited.\'\'\' Photo by Rob Buck, courtesy of Cindy Cashdollar.',53766,'K7jeb','20040523183104','0','BITMAP','image','jpeg',0,'o46puwvoq11s2ojzbo9lo1jt47oyg56'),(1137,'Cindy-cashdollar-wik.jpg','20040622001536!Cindy_cashdollar_wik.jpg',21347,280,358,8,'changed aspect ratio',53766,'K7jeb','20040622001446','0','BITMAP','image','jpeg',0,'pd66k7t2azqiisbolql79gok3m50vl4'),(1138,'Usinprogress.PNG','20040622022132!Usinprogress.PNG',37236,280,183,8,'update',35314,'Seth Ilys','20040608213207','0','BITMAP','image','png',0,'5ehlvoyj685jp8og15jdxpzmcqnbxwd'),(1139,'Aadoublejackplug.jpg','20040622060324!Aadoublejackplug.jpg',8815,741,321,8,'Double jack plug.',8846,'Andrewa','20040604031636','0','BITMAP','image','jpeg',0,'gadwz1qn289fsoxyjnp3nh0ay8vqph2'),(1140,'Trsconnectors.jpg','20040622060856!Trsconnectors.jpg',6573,600,258,8,'TRS plugs',8846,'Andrewa','20031111132458','0','BITMAP','image','jpeg',0,'qw8542daklpwiib02dfc3o9hfdevqm6'),(1141,'Oldphoneplugs.jpg','20040622061444!Oldphoneplugs.jpg',17725,600,619,8,'Old style jack plugs',8846,'Andrewa','20031111133106','0','BITMAP','image','jpeg',0,'a48uyqxxp4x7rfdhjwj0glc4797tpro'),(1142,'Jackplug.jpg','20040622061749!Jackplug.jpg',14237,600,379,8,'Jack plugs',8846,'Andrewa','20031111132945','0','BITMAP','image','jpeg',0,'f3nzcrst2vxecmmp1bh12yxb1fns8i9'),(1143,'Wpdms-shdrlfi020l-santa-clara-river.jpg','20040623035419!Wpdms_shdrlfi020l_santa_clara_river.jpg',45258,300,270,8,'[[Santa Clara River (California)]] &#169; 2004 Matthew Trump {{GFDL}}',37527,'Decumanus','20040623035044','0','BITMAP','image','jpeg',0,'9kgr6z2artfuyog1k2okgrwl3hkyjao'),(1144,'June21-2004-ThePunjabUniversity-OldCampusBuilding-1.jpg','20040623045408!June21-2004-ThePunjabUniversity-OldCampusBuilding-1.jpg',62929,640,480,8,'The Punjab University Old Campus Building',60874,'Pale blue dot','20040623045145','a:26:{s:16:\"ImageDescription\";s:8:\"Sunplus \";s:4:\"Make\";s:8:\"Sunplus \";s:5:\"Model\";s:8:\"Spca533 \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:06:22 03:53:49\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:8:\"10/10000\";s:7:\"FNumber\";s:5:\"30/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2002/01/01 16:31:14\";s:17:\"DateTimeDigitized\";s:19:\"2002/01/01 16:31:14\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:6:\"130/10\";s:16:\"MaxApertureValue\";s:7:\"317/100\";s:12:\"MeteringMode\";i:2;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:7:\"968/100\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'dqqgwj28b6qsh7jr6330c34ti70b5dl'),(1145,'OntarioOregon.jpg','20040623050440!OntarioOregon.jpg',25910,631,406,8,'Main Street, Ontario Oregon, c. 1920; from old post card',4444,'Infrogmation','20040623050008','0','BITMAP','image','jpeg',0,'jbc1345vaqj9sji5j1muvp4j0sh47w2'),(1146,'Fultons-Stable-in-Bodie,-California-800px.jpeg','20040623064248!Fultons_Stable_in_Bodie,_California-800px.jpeg',99913,800,745,8,'Image taken in June 2004 by [[user:maveric149|Daniel Mayer]].<br><br>{{msg:GFDL}}<br>{{msg:cc-by-sa}}\n\n\n',62,'Mav','20040623064234','0','BITMAP','image','jpeg',0,'l88tpxi9gvks6eoewnbnh7n2180vv9u'),(1147,'Jingcheng-Expwy-March03.jpg','20040623082551!Jingcheng_Expwy_March03.jpg',92202,640,480,8,'(Image of Jingcheng Expwy. (March 2003) [I took this picture and agree to release it under the terms of Wikipedia copyright])',75080,'DF08','20040623082413','a:24:{s:4:\"Make\";s:16:\"Minolta Co.,Ltd.\";s:5:\"Model\";s:11:\"DiMAGE E203\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:13:\"4718592/65536\";s:11:\"YResolution\";s:13:\"4718592/65536\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"QuickTime 6.5.1\";s:8:\"DateTime\";s:19:\"2004:06:23 16:20:02\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:8:\"42/10000\";s:7:\"FNumber\";s:5:\"46/10\";s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2003:03:26 17:00:31\";s:17:\"DateTimeDigitized\";s:19:\"2003:03:26 17:00:31\";s:22:\"CompressedBitsPerPixel\";s:5:\"17/10\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"30/10\";s:12:\"MeteringMode\";i:2;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:8:\"1580/100\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'p8p0dsm0tjbbpzkcxi9tx2iwkrtlugp'),(1148,'Neil-Young-Freedom.jpg','20040623110712!Neil_Young_Freedom.jpg',9474,200,200,8,'Neil Young - \"Freedom\" album cover',27822,'RedWolf','20040203214524','0','BITMAP','image','jpeg',0,'fk2ku70ydoudwj98rtxafuf156zbtp7'),(1149,'Map-of-Cape-May-County-highlighting-Avalon-Borough.png','20040623161646!Map_of_Cape_May_County_highlighting_Avalon_Borough.png',15843,549,657,8,'taken from State of New Jersey website - adapted by H. Cheney - GFDL & CC-SA-BY',35530,'Hcheney','20040622134630','0','BITMAP','image','png',0,'m7nwznse495bxce2t3n802e70i9bqtx'),(1150,'Dopamine.png','20040623220714!Dopamine.png',2762,268,99,8,'',10244,'Iorsh','20030516184448','0','BITMAP','image','png',0,'ck1koka82c3c6jiyp2jcrv130m1nsm7'),(1151,'Usinprogress.PNG','20040624011342!Usinprogress.PNG',36941,280,183,8,'update',35314,'Seth Ilys','20040622022132','0','BITMAP','image','png',0,'i9gxhubpqzih7y1mlgfzwsbmviteohr'),(1152,'Oversupply-price-to-eql.png','20040624031621!Oversupply_price_to_eql.png',6279,343,281,8,'Oversupply price in economics',578,'Jrincayc','20040623025207','0','BITMAP','image','png',0,'dfkgjac145fcaslbm64x7v5c2s9hqz4'),(1153,'Wpdms-shdrlfi020l-san-bernardino-mountains.jpg','20040624054648!Wpdms_shdrlfi020l_san_bernardino_mountains.jpg',49997,300,275,8,'[[San Bernardino Mountains]] &#169; 2004 Matthew Trump {{GFDL}}',37527,'Decumanus','20040624044349','0','BITMAP','image','jpeg',0,'resz3v51yjf4utjiu1uaekjdq739hqz'),(1154,'RathlinBirdSanctuary.jpg','20040624161215!RathlinBirdSanctuary.jpg',91757,600,450,8,'Photo of bird sanctuary on Rathlin island, taken by [[Gordoni]].',56379,'Gordoni','20040624160321','0','BITMAP','image','jpeg',0,'rwp35tsqozs3d5yev1nq0tzkd4kiiu8'),(1155,'Rotogravure-PrintUnit.jpg','20040624191140!Rotogravure_PrintUnit.jpg',45320,216,203,8,'image i created for [[rotogravure]]',81910,'Parktravelling','20040624184638','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:06:24 14:41:23\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'boh2edcnqomk9kbh9ael2v4xnv2yptp'),(1156,'Wpdms-shdrlfi020l-little-san-bernardino-mountains.jpg','20040624191233!Wpdms_shdrlfi020l_little_san_bernardino_mountains.jpg',49087,300,260,8,'[[Little San Bernardino Mountains]] &#169; 2004 Matthew Trump {{GFDL}}',37527,'Decumanus','20040624191027','0','BITMAP','image','jpeg',0,'g87rdl4u34ecd3y9607cqqws3f80n5z'),(1157,'Denatonium-benzoate.png','20040624203616!Denatonium_benzoate.png',3069,234,217,8,'I created {{GFDL}}',42878,'Cool Hand Luke','20040624201913','0','BITMAP','image','png',0,'oayzci5wrtvdy1c1hapefxa0lbs2awm'),(1158,'Denatonium-benzoate.png','20040624203846!Denatonium_benzoate.png',3321,230,196,8,'Fix transparency. I created this image. {{GFDL}}',42878,'Cool Hand Luke','20040624203620','0','BITMAP','image','png',0,'55myf2erzi59cb3oy05il112axh8ihl'),(1159,'PetShopBoysActually.jpg','20040624210437!PetShopBoysActually.jpg',8776,250,248,8,'Cover of [[Pet Shop Boys]] album [[Actually]]',45383,'CyborgTosser','20040624210215','0','BITMAP','image','jpeg',0,'fs9yr1zy9ap9u8vomkn6y37djjvi2n6'),(1160,'Gits-tiltrotor.jpeg','20040624210530!Gits-tiltrotor.jpeg',23442,490,275,8,'The [[tiltrotor]]  aircraft from the series [[Ghost in the Shell: Stand Alone Complex]]',74408,'Tobias Wolter','20040624210205','0','BITMAP','image','jpeg',0,'10nti6zx3tyfj86gbsj0evt8idmqadd'),(1161,'Marnanel-arms.png','20040625010305!Marnanel_arms.png',0,0,0,0,'[[User::Marnanel]]; coat of arms. {{GFDL}}',38775,'Marnanel','20040625010237','0','BITMAP','image','png',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(1162,'Marnanel-arms.png','20040625010608!Marnanel_arms.png',66286,400,500,8,'[[User::Marnanel]]; coat of arms. {{GFDL}}',38775,'Marnanel','20040625010309','0','BITMAP','image','png',0,'79p6dl6xfifmou12n29xn5ah8cyog54'),(1163,'Denatonium-benzoate.png','20040625011027!Denatonium_benzoate.png',2895,230,196,8,'I guess transparency is not an option?',42878,'Cool Hand Luke','20040624203848','0','BITMAP','image','png',0,'bn5h494n5433jtjh843e7wku9jxtcr3'),(1164,'BosniaGradSarajevo.PNG','20040625060758!BosniaGradSarajevo.PNG',3562,163,157,8,'Map showing canton within Bosnia and Herzegovina',72174,'Asim Led','20040616020556','0','BITMAP','image','png',0,'0z3wohx3zp94dm6ik0bjsohuhqln7cn'),(1165,'YellowstoneFalls.jpeg','20040625155115!YellowstoneFalls.jpeg',36171,433,650,8,'Picture of Lower Yellowstone Falls in Yellowstone National Park, Wyoming. Picture taken by me in 2000. {{GFDL}}',48455,'BigBen212','20040625151042','0','BITMAP','image','jpeg',0,'gdg3tntwijzi6b2h5nhs0zr214r8cty'),(1166,'Gorules-twoeyes.png','20040625202707!Gorules_twoeyes.png',1361,190,190,8,'Self made, public domain. Go illustration',10109,'Evercat','20040625201916','0','BITMAP','image','png',0,'f71njrmzgicspcmthwrakpouv5hhv5c'),(1167,'DC-mall-capitol.jpg','20040626223308!DC_mall_capitol.jpg',174996,2016,951,8,'',21013,'Raul654','20040625041003','a:26:{s:16:\"ImageDescription\";s:31:\"OLYMPUS DIGITAL CAMERA         \";s:4:\"Make\";s:23:\"OLYMPUS OPTICAL CO.,LTD\";s:5:\"Model\";s:6:\"C3000Z\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:8:\"v353u-75\";s:8:\"DateTime\";s:19:\"2004:06:23 15:26:59\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/5000\";s:7:\"FNumber\";s:5:\"45/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:06:23 15:26:59\";s:17:\"DateTimeDigitized\";s:19:\"2004:06:23 15:26:59\";s:22:\"CompressedBitsPerPixel\";s:3:\"1/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"30/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:6:\"191/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'1uo3frq7zcgse6wysr1t3c7mglkb0fy'),(1168,'Omeprazole-structure.png','20040627131900!Omeprazole-structure.png',10206,883,240,8,'{{GFDL}} Structural formula of [[Omeprazole]]. Typeset with PPCHTeX',30200,'Sverdrup','20040627131510','0','BITMAP','image','png',0,'47odbz0irdyg9xywqt3fokn5lac3chg'),(1169,'Omeprazole-structure.png','20040627140548!Omeprazole-structure.png',10218,883,240,8,'rm gray line',30200,'Sverdrup','20040627131905','0','BITMAP','image','png',0,'s0eoftnvfri6htparpp5cfribcopge3'),(1170,'Nicotine.png','20040627143736!Nicotine.png',2066,250,148,8,'version showing aromatic ring',2,'AxelBoldt','20021223010913','0','BITMAP','image','png',0,'fr26m87v1l078s65qebf2uczcd7nmn8'),(1171,'Omeprazole-structure.png','20040627173114!Omeprazole-structure.png',10588,857,284,8,'Somewhat better',30200,'Sverdrup','20040627140551','0','BITMAP','image','png',0,'pdsitca8n49m2e4mqkf6eorw6trj3pg'),(1172,'Wpdms-shdrlfi020l-owens-river.jpg','20040627232219!Wpdms_shdrlfi020l_owens_river.jpg',58383,300,300,8,'[[Owens River]] with [[Los Angeles Aqueduct]] &#169; 2004 Matthew Trump {{GFDL}}',37527,'Decumanus','20040627200314','0','BITMAP','image','jpeg',0,'h1wj7olml5ikepel7qbkoncfkgdkfi7'),(1173,'BlankMap-GermanyStates.png','20040628201349!BlankMap-GermanyStates.png',20543,778,1104,4,'Map of Germany with the boundaries of the Bundesländer',7580,'Ahoerstemeier','20040309233253','0','BITMAP','image','png',0,'06v0qfm7dsol5y0ts0j4wdx0j00dhsb'),(1174,'Bundeslaender-germany-he.png','20040628204635!Bundeslaender_germany_he.png',23527,200,266,8,'',17287,'Morwen','20040309220548','0','BITMAP','image','png',0,'1sxciez8obs81lim1dy4p31v8tz45ab'),(1175,'Bundeslaender-germany-rp.png','20040628204825!Bundeslaender_germany_rp.png',23527,200,266,8,'',17287,'Morwen','20040309220755','0','BITMAP','image','png',0,'i4icfjsy05fejt8dpkz9ii29momy4p1'),(1176,'Bundeslaender-germany-sl.png','20040628205129!Bundeslaender_germany_sl.png',23537,200,266,8,'',17287,'Morwen','20040309220828','0','BITMAP','image','png',0,'2k04jgecd52ibrjnuenbh8gr18tv9tn'),(1177,'Bundeslaender-germany-hb.png','20040628210313!Bundeslaender_germany_hb.png',23551,200,266,8,'',17287,'Morwen','20040309220532','0','BITMAP','image','png',0,'h4hd51ty6dtlopbqycsbr02j4rhfhfc'),(1178,'Bundeslaender-germany-hh.png','20040628210513!Bundeslaender_germany_hh.png',23552,200,266,8,'',17287,'Morwen','20040309220625','0','BITMAP','image','png',0,'hdrqwh7tgju6i9h1dzqauahncx9lstz'),(1179,'Bundeslaender-germany-sh.png','20040628210607!Bundeslaender_germany_sh.png',23362,200,266,8,'',17287,'Morwen','20040309220818','0','BITMAP','image','png',0,'2ehm7x6kfrcy4mbru4e3s5tgm1annwt'),(1180,'Bundeslaender-germany-mv.png','20040628211007!Bundeslaender_germany_mv.png',23394,200,266,8,'',17287,'Morwen','20040309220653','0','BITMAP','image','png',0,'hdrgg7rmo3ct0n234acsjlht0hnscy2'),(1181,'Bundeslaender-germany-sa.png','20040628211533!Bundeslaender_germany_sa.png',9308,206,277,8,'Better scaled version',7580,'Ahoerstemeier','20030425205520','0','BITMAP','image','png',0,'r1ytytcj7kdad9tnv7bzl6djnc66xmy'),(1182,'Bundeslaender-germany-sx.png','20040628212537!Bundeslaender_germany_sx.png',9290,206,277,8,'Better scaled version',7580,'Ahoerstemeier','20030425205410','0','BITMAP','image','png',0,'7k7v6zqcwko0y75e27lk36yyn5qopeo'),(1183,'Bundeslaender-germany-th.png','20040628212759!Bundeslaender_germany_th.png',23574,200,266,8,'',17287,'Morwen','20040309220916','0','BITMAP','image','png',0,'lw8yprn4a57752np7wf9hkgfsfzj383'),(1184,'Alfred-Krupp.jpg','20040629033250!Alfred_Krupp.jpg',28499,300,336,8,'Scanned from German ',4,'Magnus Manske','20030317092526','0','BITMAP','image','jpeg',0,'bla2t638igcdqlyussg9rsdyp1qun5s'),(1185,'IMG-0837-small.jpg','20040629053744!IMG_0837_small.jpg',0,0,0,0,'The chariot',82502,'Ajar','20040629051958','','TEXT','text','plain',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(1186,'IMG-0844-small.jpg','20040629054024!IMG_0844_small.jpg',0,0,0,0,'The chariot',82502,'Ajar','20040629051831','','TEXT','text','plain',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(1187,'PithaM(3).jpg','20040629172503!PithaM(3).jpg',8895,175,191,8,'PithaM(3)',16685,'KRS','20030816163627','0','BITMAP','image','jpeg',0,'o2svulk9ozprz7g74i577z310bhbs5e'),(1188,'PithaM(3).jpg','20040629174732!PithaM(3).jpg',19832,157,152,8,'Mandala 3',16685,'KRS','20040629172512','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:3:\"1/1\";s:11:\"YResolution\";s:3:\"1/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:06:28 21:44:15\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'p7tltc2t6d7uplo4w9n1lzda08sgak7'),(1189,'PithaM(3).jpg','20040629174759!PithaM(3).jpg',8895,175,191,8,'Reverted to earlier revision',16685,'KRS','20040629174733','0','BITMAP','image','jpeg',0,'o2svulk9ozprz7g74i577z310bhbs5e'),(1190,'Cyclopropane-structure.png','20040630010648!Cyclopropane-structure.png',2213,215,246,8,'{{GFDL}} Molecule structure of [[Cyclopropane]], typeset with [[PPCHTeX]].',30200,'Sverdrup','20040630001529','0','BITMAP','image','png',0,'ltxg5amkt1y30qv6jmdjwrj2kyr0ci8'),(1191,'Cellule01.jpg','20040630024215!Cellule01.jpg',36000,401,523,8,'La cellule nerveuse, public domaine',81073,'Excellsior','20040629212015','0','BITMAP','image','jpeg',0,'npqoc1wu0h1oh4gdrjmom5z67d3s3sh'),(1192,'Cellule01.jpg','20040630025126!Cellule01.jpg',36000,401,523,8,'G.Marinescu, La cellule nérveuse public domaine',81073,'Excellsior','20040630024224','0','BITMAP','image','jpeg',0,'npqoc1wu0h1oh4gdrjmom5z67d3s3sh'),(1193,'Tanabata.jpg','20040630121816!Tanabata.jpg',67024,295,480,8,'Tanabata Festival, Fussa, Tokyo, Japan {{GFDL}}',70428,'Fg2','20040630120756','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:8:\"DateTime\";s:19:\"2004:06:30 21:06:06\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'d8l8iyh0x5xwmvcuqf3ru45b9hq94fw'),(1194,'China-SEZ.jpg','20040701021350!China_SEZ.jpg',256714,1414,1116,8,'{{PD-USGov}}<br>Source: Central Intellegence Agency',10049,'Jiang','20040701021139','0','BITMAP','image','jpeg',0,'e0jpooy91ow5g9f6omjmap1r7lw44vn'),(1195,'The-Scream.jpg','20040701021837!The_Scream.jpg',27526,257,330,8,'by [[Edvard Munch]]',7457,'Egil','20030502120120','0','BITMAP','image','jpeg',0,'21zoaquo3at7yoczjciom5mboc081lw'),(1196,'Iowa.oldcapitol.construction.jpg','20040701160222!Iowa.oldcapitol.construction.jpg',75395,300,336,8,'The Old Capitol, part of the University of Iowa campus complex, undergoing rennovations.',65216,'Clarknova','20040701160137','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:07:01 10:59:03\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'6h7mhw4qow519ivn8vkp1ezrwlz5bfe'),(1197,'Sdcard.jpg','20040701200326!Sdcard.jpg',9878,0,0,0,'64MB Secure Digital card. Picture taken by [[User:eurleif]].',6516,'Eurleif','20040107043938','',NULL,'unknown','unknown',0,''),(1198,'Sdcard.jpg','20040701205156!Sdcard.jpg',71179,300,345,8,'Secure Digital 16Mb card made by Toshiba. {{PD}} replacing an unfocused image with a better version',25394,'Paranoid','20040701200357','0','BITMAP','image','jpeg',0,'9rawboqs5awvigkdlhvn3adfcecg58c'),(1199,'Galicia1.jpg','20040702011620!Galicia1.jpg',74634,560,913,8,'My picture (1/3 of it) for my user space.',30470,'PedroPVZ','20040702011351','0','BITMAP','image','jpeg',0,'n66dytz18k89ocdduaa2bhudyw76d3r'),(1200,'Girton-crest-source.svg','20040702120122!Girton_crest_source.svg',39539,744,1052,0,'SVG source of [[:Image:Girton crest.png]] <br> {{GFDL}}',42385,'Lupin','20040702102833','','DRAWING','image','svg+xml',0,'o2s40z3016a3vm59qw18km2b295rbsi'),(1201,'Dublin-Institute-of-Technology.png','20040702173716!Dublin_Institute_of_Technology.png',25150,240,240,8,'Dublin Institute of Technology - logo - fair use',49447,'Djegan','20040628190033','0','BITMAP','image','png',0,'3482n293oyv99sc1c3bfcr4lj24pnn1'),(1202,'National-University-of-Ireland.png','20040702174013!National_University_of_Ireland.png',31432,232,259,8,'Logo: National University of Ireland - fair use',49447,'Djegan','20040628084425','0','BITMAP','image','png',0,'3hqx2500hwupovppcatwb65xpwr1rjg'),(1203,'University-of-Limerick.png','20040702174823!University_of_Limerick.png',4655,211,217,8,'University of Limerick - logo - fair use as a corporate logo',49447,'Djegan','20040627230144','0','BITMAP','image','png',0,'6kclnv9vw7pdvjdapu4b8r3qvqn5t7k'),(1204,'NewG-and-b.jpg','20040702182604!NewG_and_b.jpg',10208,250,255,8,'I edited this, based on the old picture. ',56750,'Jdevine','20040702175801','0','BITMAP','image','jpeg',0,'tmir4b18mlt6bym4jqhav5fa1d4uqm0'),(1205,'Freytags-pyramid.png','20040702211038!Freytags_pyramid.png',3478,264,171,8,'Freytag\'s pyramid, for use in [[Dramatic structure]].  Made by me with the [[GIMP]], {{GFDL}}',55447,'Shibboleth','20040702204440','0','BITMAP','image','png',0,'ok4gxamfsw1gwa9umznskpmlo05z2gf'),(1206,'Canada-2004-results.png','20040702214117!Canada-2004-results.png',20833,1024,695,8,'Schematic map of the results of the [[Canadian federal election, 2004]], arranged by province/metropolitan area. Created by [[user:Montrealais|]], released under GNU FDL. Subject to revision.',3378,'Montrealais','20040629151148','0','BITMAP','image','png',0,'cnevytds5bzevt25o4eudbplx3mljf9'),(1207,'Waterloo-crest.png','20040702235910!Waterloo_crest.png',81116,400,524,8,'created by me with [[Inkscape]] using public domain lions from sodipodi flags collection<BR>{{GFDL}}',42385,'Lupin','20040702233257','0','BITMAP','image','png',0,'3i6kavv79lsul7g6plwljokfil1py6v'),(1208,'JCW-Map-Natal-General.png','20040703194144!JCW-Map-Natal-General.png',12648,300,317,8,'KwaZul-Natal General Map',69614,'Jcw69','20040703193932','0','BITMAP','image','png',0,'trzc4ugj2ye9raifxdp7woqxgcywt7f'),(1209,'JCW-Map-Natal-General.png','20040703195327!JCW-Map-Natal-General.png',12760,300,317,8,'KwaZulu-Natal Map',69614,'Jcw69','20040703194200','0','BITMAP','image','png',0,'c4nuiq6ud312cuu3za6fmbpuvx2dv2m'),(1210,'Vvbyhour.png','20040703212531!Vvbyhour.png',2920,448,322,2,'update',18610,'VeryVerily','20040620032727','0','BITMAP','image','png',0,'1v1zjfah0tzi70is2cxr4tsu0b571wy'),(1211,'Cricket-positions-300px-enhanced.png','20040704004755!Cricket_positions_300px_enhanced.png',14115,300,262,8,'Reworking of public domain image: [[:image:shots.jpg]]  {{PD}}',19009,'Ed g2s','20040701203904','0','BITMAP','image','png',0,'2qc7c8obkm6fdk3cel8zevmzwxsh86e'),(1212,'Forum-Romanum-panorama.jpg','20040704031144!Forum_Romanum_panorama.jpg',354266,2494,1043,8,'',26675,'Fredrik','20040703215202','0','BITMAP','image','jpeg',0,'5aadpw9r7yz8pbld7g69qnukroom70t'),(1213,'Newnham-crest.png','20040704092532!Newnham_crest.png',131065,800,1051,8,'made by me in [[Inkscape]]. <BR>{{GFDL}}',42385,'Lupin','20040704092035','0','BITMAP','image','png',0,'nnncmdhs1ada2ckkt7z3ciuh9ik00ws'),(1214,'Soldiers-english-coast.jpg','20040704165616!Soldiers-english-coast.jpg',112915,740,530,8,'US Soldiers in England',49757,'Taak','20040630011658','0','BITMAP','image','jpeg',0,'e1cm6xsv42z6nip4yqlhbzrfrvj1gm4'),(1215,'Lci-convoy.jpg','20040704165625!Lci-convoy.jpg',119180,740,615,8,'LCI (L) convoy, D-Day',49757,'Taak','20040626161833','0','BITMAP','image','jpeg',0,'faro3z7unxi94whfsj3ai2vytmqxok5'),(1216,'Kings-crest.png','20040704180300!Kings_crest.png',196689,800,926,8,'made by me in [[Inkscape]]. <BR>{{GFDL}}',42385,'Lupin','20040704180019','0','BITMAP','image','png',0,'moosughbrpnveaa97aii8u9nzsfpqjb'),(1217,'Kings-crest.png','20040704180509!Kings_crest.png',120938,800,926,8,'wrong colours :(',42385,'Lupin','20040704180304','0','BITMAP','image','png',0,'2buhw2oqd0cd3uksqikv7x330uu2gwc'),(1218,'Satyricon-darkmedievaltimes.jpg','20040704205215!Satyricon_darkmedievaltimes.jpg',54877,460,467,8,'{{msg:fairuse}}',75720,'Night','20040704203630','0','BITMAP','image','jpeg',0,'16ketmmem1rc9frf900npamq2ug9kck'),(1219,'User-Fredrik.jpg','20040704232320!User_Fredrik.jpg',25678,386,309,8,'[[User:Fredrik]]',26675,'Fredrik','20040430214741','0','BITMAP','image','jpeg',0,'00s5paxu1aqd3s43r69u4dx9oapj7v8'),(1220,'Omeprazole-structure.png','20040705000713!Omeprazole-structure.png',10583,857,284,8,'correct mistake',30200,'Sverdrup','20040627173119','0','BITMAP','image','png',0,'jh3z4kqv89ykkazr9dzz51i0ijr9umo'),(1221,'CherryLatticePastry.jpg','20040705134405!CherryLatticePastry.jpg',53491,400,300,8,'Photograph taken by Michael McGuffin in a Yonge-street bakery in Toronto, Canada. {{GFDL}}',79720,'MichaelMcGuffin','20040617192253','a:25:{s:4:\"Make\";s:5:\"NIKON\";s:5:\"Model\";s:5:\"E2500\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:9:\"E2500v1.0\";s:8:\"DateTime\";s:19:\"2004:06:15 17:06:05\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/300\";s:7:\"FNumber\";s:5:\"52/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:06:15 17:06:05\";s:17:\"DateTimeDigitized\";s:19:\"2004:06:15 17:06:05\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"29/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:1;s:11:\"FocalLength\";s:5:\"75/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'1ko6rzl66u069t3k1zns8nw9sfr9h4e'),(1222,'StoneRiver.jpg','20040705165138!StoneRiver.jpg',74504,448,852,8,'Stones River Battle',65782,'Sayeth','20040705164549','0','BITMAP','image','jpeg',0,'rgav6161ltuuibsgoni3qx3q9v0q7kt'),(1223,'StoneRiver.jpg','20040705165240!StoneRiver.jpg',112706,852,448,8,'Battle of Stone River',65782,'Sayeth','20040705165143','0','BITMAP','image','jpeg',0,'6xb5vfe7cjptof8cqinza2kuzbzcd2l'),(1224,'StoneRiver.jpg','20040705165529!StoneRiver.jpg',112675,852,448,8,'rotated',65782,'Sayeth','20040705165242','0','BITMAP','image','jpeg',0,'0t49afyg7ei8ik59p0kp68867rklo5a'),(1225,'StoneRiver.jpg','20040705165702!StoneRiver.jpg',112675,852,448,8,'Battle of Stone River',65782,'Sayeth','20040705165531','0','BITMAP','image','jpeg',0,'0t49afyg7ei8ik59p0kp68867rklo5a'),(1226,'StoneRiver.jpg','20040705165706!StoneRiver.jpg',112675,852,448,8,'Reverted to earlier revision',65782,'Sayeth','20040705165702','0','BITMAP','image','jpeg',0,'0t49afyg7ei8ik59p0kp68867rklo5a'),(1227,'Usenet-posts-containing-the-word-Wikipedia-Jan-01---Jun-04.png','20040705183341!Usenet_posts_containing_the_word_Wikipedia_Jan_01_-_Jun_04.png',11893,717,491,8,'Graph of Usenet posts containing the word Wikipedia Jan 01 - Jun 04, created by poster',76,'The Anome','20040705182216','0','BITMAP','image','png',0,'adpsocy9r3etke1v2ii2sdtw79q2udd'),(1228,'Dan-pittsburg-wigwag.jpg','20040705195456!Dan_pittsburg_wigwag.jpg',23365,372,252,8,'From www.trainweb.org/dansrailpix.  Used with permission by the photographer',51717,'Lucky 6.9','20040425220015','0','BITMAP','image','jpeg',0,'q7ipfvr29zpen7sjuo4vxjiceuqpa3o'),(1229,'Port-rich-wigwags.jpg','20040705200515!Port_rich_wigwags.jpg',34205,286,346,8,'cropped',52,'Eloquence','20040428231959','0','BITMAP','image','jpeg',0,'24ms3oxyor2pzfrfyhnkg2l6hia3a6x'),(1230,'Port-rich-wigwags.jpg','20040705200801!Port_rich_wigwags.jpg',46610,280,340,8,'rotated and cropped',33408,'AsianAstronaut','20040705200521','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:07:05 15:04:42\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'tn4sgjfqalmilmsb6dhdhy47we3x6h1'),(1231,'Port-rich-wigwags.jpg','20040705200906!Port_rich_wigwags.jpg',46632,280,340,8,'err, rotated and cropped for real this time, I think..',33408,'AsianAstronaut','20040705200806','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:07:05 15:06:49\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'s4j0n81efg2v5mciypwpbivv2ruo6ll'),(1232,'Nitrous-oxide-structure.png','20040706065213!Nitrous_oxide-structure.png',1510,601,68,8,'{{GFDL}} Structure for [[Nitrous oxide]]. Typeset with PPCHTeX',30200,'Sverdrup','20040628170837','0','BITMAP','image','png',0,'selz720ti1kz2lcua2fw6ae3vzk2wo5'),(1233,'Mendelian-inheritance-9-3-3-1.PNG','20040706074715!Mendelian_inheritance_9_3_3_1.PNG',18055,368,533,8,'improved version of already present file',62935,'H Padleckas','20040706060334','0','BITMAP','image','png',0,'bowue236rskp540jcpmyljyopaup0o2'),(1234,'JCW-Map-Natal-General.png','20040706112947!JCW-Map-Natal-General.png',12760,300,317,8,'KwaZulu-Natal Map',69614,'Jcw69','20040703195340','0','BITMAP','image','png',0,'c4nuiq6ud312cuu3za6fmbpuvx2dv2m'),(1235,'Emmanuel-crest.png','20040706163049!Emmanuel_crest.png',133803,600,687,8,'created by me with [[Inkscape]] <br> {{GFDL}}',42385,'Lupin','20040702222020','0','BITMAP','image','png',0,'4gpqt8f75iuk9qn9ny7vrau7x2uvebx'),(1236,'Emmanuel-crest.png','20040706184207!Emmanuel_crest.png',170993,800,916,8,'nicer text thanks to potrace',42385,'Lupin','20040706163054','0','BITMAP','image','png',0,'jowu43gpflqpm8mra2n5m20p5alg45q'),(1237,'Northandsouthjersey.png','20040707032313!Northandsouthjersey.png',11054,377,648,8,'map of New Jersey displaying the area of North Jersey and South Jersey - taken from State of New Jersey website and adapted for Wikipedia by H. Cheney - cc-by-sa & GFDL <br> {{GFDL}} {{cc-by-sa}}',35530,'Hcheney','20040703184354','0','BITMAP','image','png',0,'dsqvukptjj53eu6y0ixwttyuefdpxo7'),(1238,'LGColorAnaglyphSceneLR.jpg','20040707043620!LGColorAnaglyphSceneLR.jpg',111138,800,600,8,'Demonstration of color analglyph landscape',46238,'Leonard G.','20040707021400','0','BITMAP','image','jpeg',0,'40fd4fgtpo95jjcnqbp79bg3tl12l3w'),(1239,'The-American-College-Madurai-Logo.png','20040707111545!The_American_College_Madurai_Logo.png',3075,129,134,8,'The logo is provided to all students. It can be used to credit [[The American College]] and never be used to infringe the college name.',32794,'Rrjanbiah','20040707073844','0','BITMAP','image','png',0,'ix0h11t2yf5tgfouc6sl5et4jwc9xtn'),(1240,'Kalman-Filter-Scheme.png','20040707145208!Kalman_Filter_Scheme.png',128302,1556,542,8,'Copyright Seabhcan. May be used for anything.',41614,'Seabhcan','20040707143319','0','BITMAP','image','png',0,'8uclrnvdjn11j05nqxqdz7u0mjvkv4r'),(1241,'Kalman-Filter-Scheme.png','20040707145406!Kalman_Filter_Scheme.png',128474,1556,542,8,'Copyright Seabhcan. May be used for anything.',41614,'Seabhcan','20040707145220','0','BITMAP','image','png',0,'5sodd2mugeja0g404mdwxjvu2kw330p'),(1242,'Kalman-Filter-Scheme.png','20040707145535!Kalman_Filter_Scheme.png',128302,1556,542,8,'Reverted to earlier revision',41614,'Seabhcan','20040707145410','0','BITMAP','image','png',0,'5sodd2mugeja0g404mdwxjvu2kw330p'),(1243,'Cdnparliament1993.PNG','20040707145547!Cdnparliament1993.PNG',7085,667,255,8,'',26201,'Earl Andrew','20040702162610','0','BITMAP','image','png',0,'48iisqngshn7u0qwgao5d9638ohl1s0'),(1244,'Kalman-Filter-Scheme.png','20040707145743!Kalman_Filter_Scheme.png',128474,1556,542,8,'Copywright Seabhcan. May be used for anything',41614,'Seabhcan','20040707145540','0','BITMAP','image','png',0,'5sodd2mugeja0g404mdwxjvu2kw330p'),(1245,'Cdnparliament1988.PNG','20040707145838!Cdnparliament1988.PNG',6988,667,255,8,'',26201,'Earl Andrew','20040702163307','0','BITMAP','image','png',0,'fc3q2t9zbqnf63e4k2hhlgvsizs8a9s'),(1246,'Cdnparliament1984.PNG','20040707150326!Cdnparliament1984.PNG',6926,667,255,8,'',26201,'Earl Andrew','20040702165948','0','BITMAP','image','png',0,'karur6ygjzchg4165nmy7no16j7rddp'),(1247,'Cdnparliament1980.PNG','20040707160012!Cdnparliament1980.PNG',6662,667,255,8,'',26201,'Earl Andrew','20040702170417','0','BITMAP','image','png',0,'kkz9esdep9zqc6nes4bjvcesvw4a0i1'),(1248,'Cdnparliament1974.PNG','20040707160442!Cdnparliament1974.PNG',6560,667,255,8,'',26201,'Earl Andrew','20040702182611','0','BITMAP','image','png',0,'klbdsit51m0eh26hz94bs27w4ax29xz'),(1249,'Cdnparliament1968.PNG','20040707160837!Cdnparliament1968.PNG',6471,667,255,8,'',26201,'Earl Andrew','20040702185404','0','BITMAP','image','png',0,'2mrwfwti9o3n05mdpy51n944iwbfgdo'),(1250,'Reading-shield.png','20040707173602!Reading_shield.png',115565,800,1029,8,'made by me in [[Inkscape]]. <BR>{{GFDL}}',42385,'Lupin','20040707160516','0','BITMAP','image','png',0,'co1kuisyl1pibyt6gxkv5nix7rqb7sx'),(1251,'Spectrum-analyzer,-display,-noise-floor.jpg','20040707203640!Spectrum_analyzer,_display,_noise_floor.jpg',36727,448,336,8,'Spectrum analyzer display, showing noise floor. Self made. {{msg:PD}}',84522,'Brandon.irwin','20040707203543','a:7:{s:11:\"Orientation\";i:1;s:8:\"Software\";s:27:\"ACD Systems Digital Imaging\";s:8:\"DateTime\";s:19:\"2004:07:07 13:03:32\";s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:10:\"SubSecTime\";s:3:\"778\";s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'ou1nxv9adzve952spw5sjn2jftetkeh'),(1252,'Spectrum-analyzer,-display,-noise-floor.jpg','20040707203830!Spectrum_analyzer,_display,_noise_floor.jpg',36727,448,336,8,'Spectrum analyzer display, showing a signal below the noise floor. ',84522,'Brandon.irwin','20040707203650','a:7:{s:11:\"Orientation\";i:1;s:8:\"Software\";s:27:\"ACD Systems Digital Imaging\";s:8:\"DateTime\";s:19:\"2004:07:07 13:03:32\";s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:10:\"SubSecTime\";s:3:\"778\";s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'ou1nxv9adzve952spw5sjn2jftetkeh'),(1253,'Portland-House.jpg','20040708005018!Portland_House.jpg',48285,365,425,8,'Portland House behind the Victoria Palace Theatre, London. Photo taken 2 Aug 2003 by [[User:Alexd]] with Konica KD-400Z {{GFDL}}',58031,'Alexd','20040708004001','0','BITMAP','image','jpeg',0,'1yamzuxdbi8org62w70tbuwhatiwery'),(1254,'Portland-House.jpg','20040708005928!Portland_House.jpg',27271,250,316,8,'Portland House behind the Victoria Palace Theatre, London. Photo taken 2 Aug 2003 by [[User:Alexd|Alexd]] with a Konica KD-400Z {{GFDL}}',58031,'Alexd','20040708005026','0','BITMAP','image','jpeg',0,'r8iqeotmuwp3eqky0w64llqes5gwr17'),(1255,'GODSWORD-cover.jpg','20040708124022!GODSWORD-cover.jpg',80863,279,360,8,'Photo of the cover of GOD\'S WORD, published in 2003. Photo is public domain.',5904,'Hoshie','20040628024118','a:27:{s:4:\"Make\";s:21:\"EASTMAN KODAK COMPANY\";s:5:\"Model\";s:32:\"KODAK DC3400 ZOOM DIGITAL CAMERA\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:13:\"4718592/65536\";s:11:\"YResolution\";s:13:\"4718592/65536\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"QuickTime 6.5.1\";s:8:\"DateTime\";s:19:\"2004:06:27 22:26:07\";s:16:\"YCbCrPositioning\";i:1;s:9:\"Copyright\";s:32:\"KODAK DC3400 ZOOM DIGITAL CAMERA\";s:12:\"ExposureTime\";s:4:\"1/30\";s:7:\"FNumber\";s:7:\"300/100\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2000:03:02 17:35:05\";s:17:\"DateTimeDigitized\";s:19:\"2000:03:02 17:35:05\";s:17:\"ShutterSpeedValue\";s:5:\"50/10\";s:13:\"ApertureValue\";s:5:\"31/10\";s:17:\"ExposureBiasValue\";s:5:\"0/100\";s:16:\"MaxApertureValue\";s:5:\"31/10\";s:12:\"MeteringMode\";i:1;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:1;s:11:\"FocalLength\";s:5:\"63/10\";s:10:\"ColorSpace\";i:1;s:13:\"ExposureIndex\";s:5:\"100/1\";s:13:\"SensingMethod\";i:2;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'3wczzh72rfp59fcpr09km0j0kis8wil'),(1256,'H-1-rocket-engine.jpg','20040709025738!H-1_rocket_engine.jpg',97083,640,480,8,'H-1 Saturn I and Saturn IB rocket engine',38428,'Reubenbarton','20040610012735','0','BITMAP','image','jpeg',0,'iguv9uciqzxfgzvdl1knv3sfwu0vj8l'),(1257,'Sinitic-Languages.jpg','20040709081518!Sinitic_Languages.jpg',69180,472,942,8,'Sinitic Languages Map',72305,'Naus','20040530015753','0','BITMAP','image','jpeg',0,'tlfsp9yr09u6lt6cmvwue35q3809oqb'),(1258,'BlackRatSnake.JPG','20040709140333!BlackRatSnake.JPG',101451,821,302,8,'Picture of a Black Rat Snake that I took',85033,'Rupps','20040709135853','0','BITMAP','image','jpeg',0,'i9etf4uyxtsjgf335lj8yjg3z9f1aia'),(1259,'Bhutan-Jigme%20Dorji.jpg','20040709155659!Bhutan-Jigme%20Dorji.jpg',5631,131,161,8,'king of Bhutan',62524,'Monarchist','20040709155445','',NULL,'unknown','unknown',0,''),(1260,'Billy-Price.jpg','20040709164242!Billy_Price.jpg',3613,110,108,8,'Billy Price',49891,'Leland','20040308175414','0','BITMAP','image','jpeg',0,'2x8ej8zh990wypeyyyc6yevd4qo9bgq'),(1261,'Ceara-jericoacoara2.jpeg','20040709171614!Ceara_jericoacoara2.jpeg',20875,500,337,8,'Photograph of Jericoacoara, Brazil. Copyright free from the Brazilian Embassy in London',47506,'DO\'Neil','20040517090105','0','BITMAP','image','jpeg',0,'f3o8qngjok0dwckk7d06yuxgq14sm1f'),(1262,'KEYNES.jpg','20040709181500!KEYNES.jpg',23662,437,388,8,'The Keynesian view of Saving & Investment',56750,'Jdevine','20040709175053','0','BITMAP','image','jpeg',0,'00mdss4ftc2k5q83g5jinh4f5jxggwa'),(1263,'KEYNES.jpg','20040709184158!KEYNES.jpg',15347,328,291,8,'smaller version of Keynes on Saving & Investment',56750,'Jdevine','20040709181507','0','BITMAP','image','jpeg',0,'9c0sahucvdcert7marekgra9v27hx91'),(1264,'KEYNES.jpg','20040709192416!KEYNES.jpg',28668,437,405,8,'Keynes on Saving and Investment',56750,'Jdevine','20040709184201','0','BITMAP','image','jpeg',0,'3f02yuay8fqytfeuy0x2y7hfz0ds31a'),(1265,'DiodotusCoin.jpg','20040710071505!DiodotusCoin.jpg',6149,279,113,8,'',48296,'PHG','20040709232016','0','BITMAP','image','jpeg',0,'7og1jrt6rbxil8g1lci5isfoooz22sb'),(1266,'Cache,basic.png','20040710083615!Cache,basic.png',3188,402,239,8,'Diagram of the basic operation of a cache',35676,'Iain.mcclatchie','20040524232644','0','BITMAP','image','png',0,'j4iav9661gk8r90hkj256jvo1073r6d'),(1267,'Clacton-on-Sea-700.jpg','20040710180729!Clacton-on-Sea_700.jpg',97932,700,525,8,'Clacon-on-Sea town center.  Photo by [[User:Sannse|sannse]].  {{msg:GFDL}} ',6561,'Sannse','20040426193313','0','BITMAP','image','jpeg',0,'43lz4gtcskkqe5oarz82smjfwx2qeqt'),(1268,'B-CPMPortfolio.png','20040711002421!B-CPMPortfolio.png',4055,390,350,8,'{GFDL}} xfig source for portfolio CML',61089,'CSTAR','20040702163446','0','BITMAP','image','png',0,'puri69s21t2f6yw0c42os6oza8lcjr9'),(1269,'Data-Strobe-Encoding.png','20040711122954!Data_Strobe_Encoding.png',2349,379,240,8,'Another fix. Black was not black but transparent.',15182,'Colin Marquardt','20030813175246','0','BITMAP','image','png',0,'64oda5kawflb85zchb1783gkre6x8jt'),(1270,'Edit-Summary-2.png','20040712054522!Edit_Summary-2.png',621,478,28,8,'Updated screenshot of the edit summary to account for changes made at [[MediaWiki:Summary]]',8551,'Angela','20040421160459','0','BITMAP','image','png',0,'6j49gg8ogr5gy640n3a32djcreaiko8'),(1271,'Edit-Summary-2.png','20040712054950!Edit_Summary-2.png',350,478,28,4,'Updated to match Monobook skin.',48653,'BillyH','20040712054529','0','BITMAP','image','png',0,'3xvch6xayn7xm0jf23dirj0ga15klai'),(1272,'MartialArtStaff2.JPG','20040712063039!MartialArtStaff2.JPG',320753,1327,1208,8,'A young martial artist demonstrating a Staff routine.',519,'Kowloonese','20040712062824','a:26:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:9:\"CYBERSHOT\";s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:07:10 11:26:26\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/2000\";s:7:\"FNumber\";s:6:\"100/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:07:10 11:26:26\";s:17:\"DateTimeDigitized\";s:19:\"2004:07:10 11:26:26\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"48/16\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:6:\"240/10\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'ih1e888d99p2adh6vnqorbmka1d63de'),(1273,'Chopper-Commando-base.png','20040712063250!Chopper_Commando_base.png',11891,0,0,0,'Base screenshot of Chopper Commando by Neil Halelamien. {{screenshot}}',42594,'FleaPlus','20040712061854','',NULL,'unknown','unknown',0,''),(1274,'Royalhawaiianband.jpg','20040712180627!Royalhawaiianband.jpg',45980,434,326,8,'From the State of Hawaii Archives, unlicensed, released into the public domain for historical educational purposes.  {{msg:PD}}',69007,'Gerald Farinas','20040521165619','0','BITMAP','image','jpeg',0,'si762hjpye3r7rvsoy61ixhf14ldgg1'),(1275,'Hemer-arms-old.png','20040712191243!Hemer_arms_old.png',5725,220,277,8,'Old coat of arms of Hemer, Germany',7580,'Ahoerstemeier','20040707191335','0','BITMAP','image','png',0,'lfjy0o3zxxnj2p6fq42o1ehda100y2h'),(1276,'KarnatakaSangeetham.PNG','20040712202943!KarnatakaSangeetham.PNG',1860,223,55,8,'The Sanskrit name of Carnatic music, for people who don\'t have devanagari fonts',81488,'Skal','20040712202417','0','BITMAP','image','png',0,'ocgx0l0mzkzvvo8lz4gw97ce2mpjaoq'),(1277,'KarnatakaSangeetham.PNG','20040712224300!KarnatakaSangeetham.PNG',1860,223,55,8,'Name of C\'c music for people lacking devnag fonts',81488,'Skal','20040712202951','0','BITMAP','image','png',0,'ocgx0l0mzkzvvo8lz4gw97ce2mpjaoq'),(1278,'KarnatakaSangeetham.PNG','20040712224426!KarnatakaSangeetham.PNG',1590,196,46,8,'Removed space below and to the right; fixed devnag ortho.',81488,'Skal','20040712224307','0','BITMAP','image','png',0,'5t30vpauklgjcfhhpt2vz6vnpz7wslp'),(1279,'KarnatakaSangeetham.PNG','20040712224530!KarnatakaSangeetham.PNG',1590,196,46,8,'Retry of upload',81488,'Skal','20040712224428','0','BITMAP','image','png',0,'5t30vpauklgjcfhhpt2vz6vnpz7wslp'),(1280,'Ralph-Craig.jpg','20040713123342!Ralph_Craig.jpg',8739,100,263,8,'Ralph Craig',10623,'Gh','20040417133650','0','BITMAP','image','jpeg',0,'o5r4erp4sdpvt1h721bj4lezh4wo0al'),(1281,'Ralph-Craig.jpg','20040713123358!Ralph_Craig.jpg',5910,121,300,8,'Ralph Craig',10623,'Gh','20040713123348','0','BITMAP','image','jpeg',0,'5fwm6gm0v8ydrjzq32w3byar2w5y96w'),(1282,'Ralph-Craig.jpg','20040713123439!Ralph_Craig.jpg',8739,100,263,8,'Reverted to earlier revision',10623,'Gh','20040713123358','0','BITMAP','image','jpeg',0,'o5r4erp4sdpvt1h721bj4lezh4wo0al'),(1283,'Splashdown.png','20040713164247!Splashdown.png',69444,581,400,8,'Caribbean splashdown locations of American spacecraft. ',38428,'Reubenbarton','20040713162601','0','BITMAP','image','png',0,'f2f90q826r1jwxmaqma1wnlncd78fu2'),(1284,'Alpine-butterfly-knot-steps.png','20040713192330!Alpine_butterfly_knot_steps.png',20560,187,335,8,'{{GFDL}}',45635,'Sik0fewl','20040713053054','0','BITMAP','image','png',0,'4un5l1lr6bw127cugxsmtfrmp2wtopw'),(1285,'FrenchHornHarmonics.png','20040714004558!FrenchHornHarmonics.png',33644,935,1210,8,'This figure shows the first sixteen harmonics for the french horn. This file was created in lilypond format. An mechanism where lilypond generated images are created similar to the tex math stuff would be prefered.',72659,'Horndude77','20040714002910','0','BITMAP','image','png',0,'8guszfsgxny0l6ixchwyw9qy26qypdr'),(1286,'FrenchHornHarmonics.png','20040714005234!FrenchHornHarmonics.png',26508,740,939,8,'same thing, but with less whitespace around the edges',4319,'Bdesham','20040714004636','0','BITMAP','image','png',0,'sh69r6edbf20rg9un3b857womsxxkwp'),(1287,'Alpine-butterfly-knot-steps.png','20040714013058!Alpine_butterfly_knot_steps.png',20675,187,335,8,'',45635,'Sik0fewl','20040713192340','0','BITMAP','image','png',0,'86ao2h0p2r0igasub4qgw1lnses4g8o'),(1288,'Snape.png','20040714140223!Snape.png',83484,250,326,8,'Prof. Severus Snape',84330,'Rama','20040714085313','0','BITMAP','image','png',0,'6scb82v8wpyfb8xucxyvmchonu510ii'),(1289,'Vexations-MIDI.zip','20040714140301!Vexations-MIDI.zip',7585,0,0,0,'Vexations (Erik Satie), complete - MIDI - zipped',85402,'Francis Schonken','20040713111811','','ARCHIVE','application','zip',0,'puwma9ps2z2k39ip7hlwryszvu7dkte'),(1290,'Copyright-symbol.png','20040714153628!Copyright_symbol.png',8939,115,113,8,'{{PD}}',42385,'Lupin','20040714153412','0','BITMAP','image','png',0,'7zp03wtn3ohaebkznppntksgd8ul1y4'),(1291,'Snake-skull-joints-lateral-view.jpg','20040714204616!Snake_skull_joints_lateral_view.jpg',7682,399,221,8,'Lateral view of kinetic joints in snake skull',86076,'Mokele','20040713234140','0','BITMAP','image','jpeg',0,'ipo8adub1ynlkmh7b4wddo9v1y23jps'),(1292,'Test-Crude-EU25-colored-stretched-greens.png','20040714223239!Test_Crude-EU25-colored_stretched_greens.png',3154,262,160,8,'Compressed Image',59144,'Daniel,levine','20040617223949','0','BITMAP','image','png',0,'3aelmjhyxhj56iolx7e6a74qh4gjlz6'),(1293,'Pax-aslr-aslr01.png','20040714225326!Pax_aslr_aslr01.png',10638,621,201,8,'I made this, it shows another virtual address space concept model with ASLR enabled, {{PD}}',70169,'Bluefoxicy','20040714223834','0','BITMAP','image','png',0,'ii1v9f998yhpdza82sj9cwfztxrgas1'),(1294,'Pax-aslr-aslr00.png','20040714225345!Pax_aslr_aslr00.png',10270,621,202,8,'I made this, it shows a virtual address space concept model with ASLR enabled, {{PD}}',70169,'Bluefoxicy','20040714223711','0','BITMAP','image','png',0,'20kxs7ku0mhwwwmmdbqnp10q1y81sgg'),(1295,'Pax-aslr-noaslr.png','20040714225414!Pax_aslr_noaslr.png',8507,620,202,8,'I made this, it shows a virtual address space concept model, {{PD}}',70169,'Bluefoxicy','20040714221911','0','BITMAP','image','png',0,'o9utwesno2h6a2cyx4tx7iavpvqhr52'),(1296,'Pax-aslr-noaslr.png','20040714231637!Pax_aslr_noaslr.png',8982,421,242,8,'I made this, it shows another virtual address space concept model with ASLR enabled, {{PD}}',70169,'Bluefoxicy','20040714225417','0','BITMAP','image','png',0,'4d8tht85zy1c2ye7pby4imtex9nkeai'),(1297,'Pax-aslr-aslr00.png','20040714231703!Pax_aslr_aslr00.png',10097,422,241,8,'I made this, it shows another virtual address space concept model with ASLR enabled, {{PD}}',70169,'Bluefoxicy','20040714225350','0','BITMAP','image','png',0,'1cdjcagvdi6j1q1zsodrnp8bx85whei'),(1298,'Pax-aslr-aslr01.png','20040714231714!Pax_aslr_aslr01.png',9619,422,242,8,'I made this, it shows another virtual address space concept model with ASLR enabled, {{PD}}',70169,'Bluefoxicy','20040714225333','0','BITMAP','image','png',0,'7q9xwoq7plc8ujvwjjs6bz2hn1dpgxq'),(1299,'Ucb-logo.png','20040715002919!Ucb_logo.png',14003,144,144,8,'Not GFDL. UC seal assumed to be a trademark of the Regents of the University of California. See [[Wikipedia:Logos]].',10049,'Jiang','20040111075348','0','BITMAP','image','png',0,'8sakp58ay1tqdghl3m07fi2qnedtvqm'),(1300,'Kiminozo-coverart.jpg','20040715114918!Kiminozo_coverart.jpg',0,0,0,0,'Cover art for [[ren\'ai game]] [[Kimi ga Nozomu Eien]] (stripped of logos).  Gotten from official site, http://www.age-soft.jp/Product/Kimibo/index.htm.  {{fairuse}}',55447,'Shibboleth','20040715114740','0','BITMAP','image','jpeg',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(1301,'Polska22-wolynskie.png','20040715120201!Polska22_wolynskie.png',2559,244,267,8,'what the hell, why doesn\'t the red show up?!',32233,'Halibutt','20040621094432','0','BITMAP','image','png',0,'p28t7s2i5h7q0dhoqq7jtszdq7jka2d'),(1302,'Polska22-wolynskie.png','20040715120201!Polska22_wolynskie.png',2559,244,267,8,'what the hell, why doesn\'t the red show up?!',32233,'Halibutt','20040621094432','0','BITMAP','image','png',0,'p28t7s2i5h7q0dhoqq7jtszdq7jka2d'),(1303,'Polska22-wolynskie.png','20040715120230!Polska22_wolynskie.png',2455,244,267,4,'Reverted to earlier revision',86399,'Berkut','20040715120202','0','BITMAP','image','png',0,'37yfa6ej9ar62bjuwrygsxjdm1obish'),(1304,'Polska22-wolynskie.png','20040715120707!Polska22_wolynskie.png',2559,244,267,8,'Reverted to earlier revision',86399,'Berkut','20040715120230','0','BITMAP','image','png',0,'p28t7s2i5h7q0dhoqq7jtszdq7jka2d'),(1305,'Polska22-wolynskie.png','20040715120911!Polska22_wolynskie.png',2340,244,267,4,'',86399,'Berkut','20040715120713','0','BITMAP','image','png',0,'8i4lqq64tgwzav6jqaliqerikpdi9kb'),(1306,'Polska22-wolynskie.png','20040715123358!Polska22_wolynskie.png',2559,244,267,8,'Reverted to earlier revision',86399,'Berkut','20040715120912','0','BITMAP','image','png',0,'p28t7s2i5h7q0dhoqq7jtszdq7jka2d'),(1307,'Crude-EU9.png','20040715141002!Crude-EU9.png',3603,262,160,8,'{{msg:GFDL}}',17287,'Morwen','20040312224333','0','BITMAP','image','png',0,'ic6y0r4hl2ypkz8za7oyduc6bewlyig'),(1308,'Ti55iii.JPG','20040715150105!Ti55iii.JPG',95172,223,411,8,'I took this picture. {{PD}}',80666,'Archer3','20040715145925','0','BITMAP','image','jpeg',0,'fblkr90578nfgdmywzrwq1th2eu1zke'),(1309,'Crude-EU12-orig.png','20040715164955!Crude-EU12-orig.png',3622,262,160,8,'{{msg:GFDL}}',17287,'Morwen','20040312224346','0','BITMAP','image','png',0,'7znlgr1o3ylkvmw8uvid1kqbay4ys71'),(1310,'Crude-EU15.png','20040715165755!Crude-EU15.png',4144,262,160,8,'fixed color for east .de',20318,'Joy','20040310185730','0','BITMAP','image','png',0,'rnem27p8zsxelxvshngq5bw560lhafg'),(1311,'Glendalough-monastic-site.jpg','20040715223220!Glendalough_monastic_site.jpg',134386,640,480,8,'Gravestones and ancient church at [[Glendalough]], [[Ireland]].  Photograph by [[User:Toby Woodwark]], June 2004.  {{GFDL}}',52435,'Toby Woodwark','20040715221936','a:24:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:9:\"CYBERSHOT\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:06:26 09:42:35\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/1000\";s:7:\"FNumber\";s:5:\"32/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:06:26 09:42:35\";s:17:\"DateTimeDigitized\";s:19:\"2004:06:26 09:42:35\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"48/16\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"92/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'8hwkktk5f1ytbkkftifb3quiksrhr4i'),(1312,'Crude-EU9.png','20040716041402!Crude-EU9.png',4706,262,160,8,'changed color of UK/Denmark/Ireland to show enlargement',85484,'Aris Katsaris','20040715141010','0','BITMAP','image','png',0,'6tgysch4tk8x5wa5zcw3t0eu57bo4ck'),(1313,'Crude-EU12-orig.png','20040716041445!Crude-EU12-orig.png',4828,262,160,8,'different colors for Greece, Portugal, Spain, to show enlargement',85484,'Aris Katsaris','20040715165000','0','BITMAP','image','png',0,'lz3cemawarjyxbfrn77lxnt7zjyz1gr'),(1314,'Jingjintang-Expwy-Jul2004.jpg','20040716101234!Jingjintang_Expwy_Jul2004.jpg',389024,1600,1200,8,'{{GFDL}} Jingjintang Expressway - Beijing segment. Taken in July 2004 by Wikipedian DF08.',75080,'DF08','20040716100724','a:26:{s:4:\"Make\";s:6:\"CAMERA\";s:5:\"Model\";s:7:\"3MP-9F6\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:13:\"4718592/65536\";s:11:\"YResolution\";s:13:\"4718592/65536\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"QuickTime 6.5.1\";s:8:\"DateTime\";s:19:\"2004:07:14 13:08:40\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:5:\"1/500\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:07:13 23:32:48\";s:17:\"DateTimeDigitized\";s:19:\"2004:07:13 23:32:48\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ShutterSpeedValue\";s:3:\"9/1\";s:13:\"ApertureValue\";s:3:\"3/1\";s:17:\"ExposureBiasValue\";s:3:\"0/2\";s:16:\"MaxApertureValue\";s:3:\"3/1\";s:12:\"MeteringMode\";i:2;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:7:\"996/100\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'1b398kjds05pzuslp5cn2l8qxxe0dv7'),(1315,'Jamesddole.jpg','20040716170805!Jamesddole.jpg',15066,201,263,8,'{{PD}} Hawaii State Archives, James Drummond Dole, the Pineapple King',69007,'Gerald Farinas','20040707171532','0','BITMAP','image','jpeg',0,'9tqrm09jvv024akx3v8bl3uwat152uq'),(1316,'Vvbyhour.png','20040716221404!Vvbyhour.png',3286,442,320,2,'update',18610,'VeryVerily','20040703212540','0','BITMAP','image','png',0,'o84h08brsy0j2otuvuifcn83gohgsi1'),(1317,'NOAA.jpg','20040717040301!NOAA.jpg',35747,500,344,8,'NOAA, Public Domain',9697,'Poor Yorick','20030630062616','0','BITMAP','image','jpeg',0,'3rexgplgj4agw009f6sroi6s4fs56mo'),(1318,'Ethylene-oxide.png','20040717093217!Ethylene_oxide.png',679,125,106,8,'Ethylene oxide, synthesized from [[:Image:Ethene.png]] by [[User:Keith Edkins|Keith Edkins]]',55077,'Keith Edkins','20040717093116','0','BITMAP','image','png',0,'92r2i1qn4q4espwrue5zpg0humm2446'),(1319,'Nor-rev.png','20040717210833!Nor_rev.png',7432,414,250,8,'Normal_and_reverse_faults',8341,'Cferrero','20030214103503','0','BITMAP','image','png',0,'fywobq1ooxja9dsbu4xdmwiwf1qsr0r'),(1320,'Usinprogress.PNG','20040717221623!Usinprogress.PNG',36980,280,183,8,'update',35314,'Seth Ilys','20040624011342','0','BITMAP','image','png',0,'oxev67roi2s4kzf8bwrx3f0abm6oelx'),(1321,'Usinprogress.PNG','20040717222012!Usinprogress.PNG',36632,280,183,8,'update',35314,'Seth Ilys','20040717221627','0','BITMAP','image','png',0,'swe4zmxboepnmljzz2wcr3zxy5f4dbd'),(1322,'Usinprogress.PNG','20040717224229!Usinprogress.PNG',36632,280,183,8,'update',35314,'Seth Ilys','20040717222016','0','BITMAP','image','png',0,'swe4zmxboepnmljzz2wcr3zxy5f4dbd'),(1323,'Kids-50mm-100mm.jpg','20040718024221!Kids_50mm_100mm.jpg',29448,556,215,8,'a comparison of film and CCD',55547,'Toytoy','20040718024156','a:23:{s:4:\"Make\";s:21:\"Asahi Optical Co.,Ltd\";s:5:\"Model\";s:17:\"PENTAX Optio 330 \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:21:\"Ver1.10              \";s:8:\"DateTime\";s:19:\"2003:04:15 13:18:46\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:5:\"1/640\";s:7:\"FNumber\";s:5:\"30/10\";s:15:\"ExposureProgram\";i:2;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2003:04:15 13:18:46\";s:17:\"DateTimeDigitized\";s:19:\"2003:04:15 13:18:46\";s:22:\"CompressedBitsPerPixel\";s:3:\"4/1\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:5:\"28/10\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:6:\"102/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'cql67ia854npy3a2jafyyx01t4e65ad'),(1324,'USAF.jpg','20040718041938!USAF.jpg',119565,640,613,8,'',68411,'Neutrality','20040718040317','0','BITMAP','image','jpeg',0,'r65itfijsmb4x4ei3waseh7jw8r6uni'),(1325,'BosniaGradSarajevo.PNG','20040719042818!BosniaGradSarajevo.PNG',3562,163,157,8,'Map showing canton within Bosnia and Herzegovina',72174,'Asim Led','20040625060810','0','BITMAP','image','png',0,'0z3wohx3zp94dm6ik0bjsohuhqln7cn'),(1326,'Singing-Detective-Poster.jpg','20040719232505!Singing_Detective_Poster.jpg',44856,296,475,8,'A poster for \"The Singing Detective\"',65633,'Yossarian','20040719014832','0','BITMAP','image','jpeg',0,'apw9tiom9ab8q3y7e7s95dzsvfz0wp5'),(1327,'BosniaGradSarajevo.PNG','20040719235856!BosniaGradSarajevo.PNG',3551,163,157,8,'Map showing city within Bosnia and Herzegovina',72174,'Asim Led','20040719042828','0','BITMAP','image','png',0,'2lv05jy29xxfcplvae4o20hlkh9yu1h'),(1328,'BosniaGradSarajevo1.PNG','20040720022418!BosniaGradSarajevo1.PNG',3583,163,157,8,'Map showing Canton within Bosnia and Herzegovina',72174,'Asim Led','20040720012647','0','BITMAP','image','png',0,'ecci4auoj5ko9d87hp5vtbef1l13llt'),(1329,'Coequalizer-01.png','20040720041210!Coequalizer-01.png',2715,215,124,8,'commutative diagram for [[Coequalizer]]',43429,'Fropuff','20040719001117','0','BITMAP','image','png',0,'6q5lgrvlfwbzokiyjym4vrfol8a640g'),(1330,'Swr.png','20040720093412!Swr.png',18950,902,452,8,'standing wave ratio showing vmin and vmax',2954,'Heron','20040720085211','0','BITMAP','image','png',0,'09e4cmmrs1o9nvjr4tj4a2sznggpunm'),(1331,'Welsh-Rugby-Regions-2003.jpg','20040720122415!Welsh-Rugby-Regions-2003.jpg',13644,200,300,8,'Welsh Rugby regions 2003',86382,'Hackerjack','20040720121912','0','BITMAP','image','png',0,'3vl9wfv97vbk4n754mbarm59ku11i7q'),(1332,'LGAT-Brighton-towns.png','20040720130759!LGAT_Brighton_towns.png',3267,148,98,8,'LGA Tasmania - Brighton with towns',3861,'Chuq','20040720125710','0','BITMAP','image','png',0,'qkwtxrvtlbtohwm7yuuh1rl36knzwn4'),(1333,'Swr.png','20040720132545!Swr.png',24612,902,452,8,'replacing my previous, utterly incorrect, attempt',2954,'Heron','20040720093420','0','BITMAP','image','png',0,'09e4cmmrs1o9nvjr4tj4a2sznggpunm'),(1334,'Boston-terrier.jpg','20040720183315!Boston-terrier.jpg',33454,480,360,8,'Boston Terrier puppy, female',87570,'Mwm126','20040720180924','0','BITMAP','image','jpeg',0,'rori2vqj80nxg40qhsm1syz7rrwrwis'),(1335,'Watchet.marina.arp.750pix.jpg','20040720194250!Watchet.marina.arp.750pix.jpg',108274,750,561,8,'Watchet marina',7095,'Arpingstone','20040720193857','a:34:{s:16:\"ImageDescription\";s:31:\"OLYMPUS DIGITAL CAMERA         \";s:4:\"Make\";s:19:\"OLYMPUS CORPORATION\";s:5:\"Model\";s:6:\"C750UZ\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:9:\"v753u2-86\";s:8:\"DateTime\";s:19:\"2004:07:13 16:38:26\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/5000\";s:7:\"FNumber\";s:5:\"56/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:50;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:07:13 16:38:26\";s:17:\"DateTimeDigitized\";s:19:\"2004:07:13 16:38:26\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"30/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:5:\"63/10\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:5:\"0/100\";s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'r6kxc0w7faz28x4djj3fsckrzedv32z'),(1336,'EXTBENE.jpg','20040720220132!EXTBENE.jpg',27430,383,329,8,'External benefits with S&D -- I drew it mayself. ',56750,'Jdevine','20040720211718','0','BITMAP','image','jpeg',0,'c67f6wn4xjpr1vpqhzshzwko3tad8bi'),(1337,'Santorini.jpeg','20040721011914!Santorini.jpeg',36459,360,480,8,'Santorini View with a nice girl in front. Took when i was travelling in Greece in Juin 2003',6307,'Chmouel','20030725182146','a:27:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:9:\"CYBERSHOT\";s:11:\"Orientation\";i:6;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2003:06:11 22:06:38\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/5000\";s:7:\"FNumber\";s:6:\"110/10\";s:15:\"ExposureProgram\";i:0;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2003:06:11 22:06:38\";s:17:\"DateTimeDigitized\";s:19:\"2003:06:11 22:06:38\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:16:\"MaxApertureValue\";s:5:\"62/16\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"63/10\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"SceneCaptureType\";i:3;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'9f6v18u3fuba8657wjgt8urmiaug7z3'),(1338,'GreenMap.jpg','20040721050858!GreenMap.jpg',55668,650,251,8,'Map of Mars drawn by Nathaniel Green in 1877',39067,'Awolf002','20040721003651','0','BITMAP','image','jpeg',0,'2ybbndjoz9xpg4s9n1njwfjpwni5uoq'),(1339,'GreenMap.jpg','20040721051136!GreenMap.jpg',86444,763,588,8,'{{fairuse}} photograph of an out-of-copyright map',44727,'Curps','20040721050903','0','BITMAP','image','jpeg',0,'gho0dsdw999vrobkm7bwsiv1supqldb'),(1340,'Eversholt-mosaic.jpg','20040721074802!Eversholt_mosaic.jpg',82854,400,368,8,'Mosaic map of Eversholt at the Village Hall',44542,'Emrys2','20040713175615','a:21:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:22:\"Canon DIGITAL IXUS 300\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:8:\"DateTime\";s:19:\"2004:07:13 18:51:34\";s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0200\";s:16:\"DateTimeOriginal\";s:19:\"2004:02:01 14:10:25\";s:17:\"DateTimeDigitized\";s:19:\"2004:02:01 14:10:25\";s:17:\"ShutterSpeedValue\";s:12:\"501760/65536\";s:13:\"ApertureValue\";s:12:\"237568/65536\";s:17:\"ExposureBiasValue\";s:3:\"0/6\";s:11:\"FocalLength\";s:6:\"304/32\";s:10:\"ColorSpace\";i:65535;s:21:\"FocalPlaneXResolution\";s:11:\"1200000/155\";s:21:\"FocalPlaneYResolution\";s:11:\"1600000/206\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'awragppc12bjoahr1l9f27nfpfc947v'),(1341,'LGAT-WestCoast-towns.png','20040721124630!LGAT_WestCoast_towns.png',5407,144,232,8,'LGA Tasmania - West Coast with towns ',3861,'Chuq','20040721113348','0','BITMAP','image','png',0,'q5o1epeuj25lhbbt2qa4l9xz5wa6n9u'),(1342,'MethamphetaminePills.jpg','20040721132021!MethamphetaminePills.jpg',12113,223,218,8,'Methamphetamine pills in a hand',26995,'Chris 73','20040721040943','0','BITMAP','image','jpeg',0,'6z5gr52x0e1tcmzalgbwzu0c36ufpgv'),(1343,'MethamphetaminePills.jpg','20040721150032!MethamphetaminePills.jpg',9289,223,218,8,'improved colors',26995,'Chris 73','20040721132029','0','BITMAP','image','jpeg',0,'3fgboxhzlbb8lj2lj6lz19gtorqzcq0'),(1344,'FTV1400D.png','20040721162159!FTV1400D.png',31531,274,414,8,'DRYAD (Cryptography) sample cipher sheet',84951,'ArnoldReinhold','20040721150439','0','BITMAP','image','png',0,'0gtowttohfn7eh1ziwijbq5o0fi6bsv'),(1345,'Mars-express-kyknos.jpg','20040721163919!Mars_express_kyknos.jpg',22911,400,300,8,'An artist\'s concept of ESA Mars Express probe. Public Domain. Credit: NASA/JPL',86609,'Kyknos','20040721155447','0','BITMAP','image','jpeg',0,'igthgi78lt6z9tlkxz4v41pbydibe3d'),(1346,'SHIMLA-IMG-0030.jpg','20040722045038!SHIMLA_IMG_0030.jpg',96582,1000,750,8,'Shimla Scandal Point  ',82502,'Ajar','20040722045034','a:32:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:21:\"Canon PowerShot S1 IS\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:07:09 19:07:35\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:5:\"1/640\";s:7:\"FNumber\";s:5:\"45/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:07:09 19:07:35\";s:17:\"DateTimeDigitized\";s:19:\"2004:07:09 19:07:35\";s:22:\"CompressedBitsPerPixel\";s:3:\"5/1\";s:17:\"ShutterSpeedValue\";s:6:\"298/32\";s:13:\"ApertureValue\";s:6:\"139/32\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:6:\"104/32\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:10:\"13200/1000\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"2048000/208\";s:21:\"FocalPlaneYResolution\";s:11:\"1536000/156\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:9:\"2048/2048\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'p562dch57h6ri2ecst1s77nunouhsof'),(1347,'Crypto-diagrams.tgz','20040722063349!Crypto_diagrams.tgz',40314,0,0,0,'Tar/GZ file of OpenOffice drawings I used to create several of the crypto diagrams.  Created by me, released into the public domain.',38470,'Lunkwill','20040124180045','','TEXT','text','plain',0,'p287kfghozjs09d54tm2164an40rseh'),(1348,'Lblogo.jpg','20040722141130!Lblogo.jpg',3588,100,100,8,'lblogo {{GFDL}}',21212,'Zanthalon','20040722140311','0','BITMAP','image','jpeg',0,'34be0du55dofhdc206nvwx1bfvvxmm5'),(1349,'Crypto-diagrams.tgz','20040722162119!Crypto_diagrams.tgz',255907,0,0,0,'Cleaned up Openoffice diagrams for 1.1, added .png images of the diagrams.  Created by me, {{PD}}',38470,'Lunkwill','20040722063401','','TEXT','text','plain',0,'5ixgr7pewhe8fmlgd6mhg4omj0a8ish'),(1350,'USArmy-First-Cav-Patch.jpg','20040722180743!USArmy_First_Cav_Patch.jpg',4597,100,129,8,'1st Cav Insignia - US Army website',19091,'Ark30inf','20030928065100','0','BITMAP','image','jpeg',0,'m6vv0eakwaebejzo2fze1kf81esgyuj'),(1351,'Snowy-selywn-college-cambridge.jpg','20040723083928!Snowy_selywn_college_cambridge.jpg',47603,480,640,8,'[[Selwyn College, Cambridge]] in the snow, early in 2004. Photo by Matthew Mayer, released under GFDL. {{GFDL}}',5941,'Matthewmayer','20040722230518','0','BITMAP','image','jpeg',0,'97pp5228uf5a4hm5mn8uqp3kwlnvu9w'),(1352,'Lancashire-Option2-mod.png','20040723092403!Lancashire_Option2_mod.png',6048,200,296,8,'',55077,'Keith Edkins','20040713075458','0','BITMAP','image','png',0,'t3ksvfavfv5k6p6k604lxnfsvk181d9'),(1353,'Cache,basic.png','20040723180912!Cache,basic.png',8597,335,144,8,'Improved version of diagram using dia tool',35676,'Iain.mcclatchie','20040710083623','0','BITMAP','image','png',0,'22s8ky03l8r2g72ozqzct6nwwq7hnfe'),(1354,'Cache,basic.dia','20040723181118!Cache,basic.dia',26028,0,0,0,'Source for image [[Cache,basic.png]]',35676,'Iain.mcclatchie','20040710083850','','UNKNOWN','unknown','unknown',0,'rh19945m1331u1wuqmgzmfi7q8jlke9'),(1355,'EnglandAndWales1974Numbered.png','20040723190926!EnglandAndWales1974Numbered.png',92852,400,493,8,'{{GFDL}}',17287,'Morwen','20040723181236','0','BITMAP','image','png',0,'mg7sqo34f9n04cmckjes69lpyo0nk6j'),(1356,'KEYNES.jpg','20040723193145!KEYNES.jpg',28668,437,405,8,'Keynes on Saving & Investment',56750,'Jdevine','20040709192420','0','BITMAP','image','jpeg',0,'3f02yuay8fqytfeuy0x2y7hfz0ds31a'),(1357,'KEYNES.jpg','20040723195546!KEYNES.jpg',28664,437,405,8,'revised version of Keynes graph',56750,'Jdevine','20040723193154','0','BITMAP','image','jpeg',0,'pd4qtvb2rxcydvjc92ivlsfwe9askbm'),(1358,'Speckled-Wood-butterfly-800.jpg','20040723200633!Speckled_Wood_butterfly_800.jpg',178677,800,719,8,'Speckled Wood butterfly {{GFDL}}',6561,'Sannse','20040608172630','0','BITMAP','image','jpeg',0,'kgiaibudr780efa38lflaaywvarp26o'),(1359,'Speckled-Wood-butterfly-800.jpg','20040723201241!Speckled_Wood_butterfly_800.jpg',179023,800,630,8,'rotate',6561,'Sannse','20040723200717','0','BITMAP','image','jpeg',0,'ekmy7hx3k21v9bnfn7n9ubytui36iqt'),(1360,'KEYNES.jpg','20040723201256!KEYNES.jpg',28629,419,384,8,'a smaller version of the Keynes graph',56750,'Jdevine','20040723195603','0','BITMAP','image','jpeg',0,'ks106j3pymkk0kq3txf421uczpst3i1'),(1361,'KEYNES.jpg','20040723212013!KEYNES.jpg',23383,385,308,8,'an even smaller graph.',56750,'Jdevine','20040723201259','0','BITMAP','image','jpeg',0,'5vklpk782vngpmgkqph1fbzy3mtzdd6'),(1362,'Exponential-pdf.png','20040724004223!Exponential_pdf.png',8170,792,612,8,'Probability distribution function of exponential distr. Created on 7/17/2004 by Claus Wilke and released into the public domain.',20922,'Wilke','20040717222422','0','BITMAP','image','png',0,'ph7ejceq7u70s3sf55cm4lsk3lgwps9'),(1363,'Taylorseriesforsine.png','20040724005300!Taylorseriesforsine.png',9260,1069,358,8,'taylor series for sine to various degrees compared.  made by deelkar {{GFDL}}',87057,'Deelkar','20040723121758','0','BITMAP','image','png',0,'didtxxirayfky2ts6s5wg2kzqi4lnqq'),(1364,'Kerry-with-crew2.jpg','20040724033904!Kerry_with_crew2.jpg',20188,200,150,8,'',68411,'Neutrality','20040724033613','0','BITMAP','image','jpeg',0,'rnqruqeshftowke2303to0t65dek9mq'),(1365,'Kerry-with-crew2.jpg','20040724034150!Kerry_with_crew2.jpg',49728,520,385,8,'',68411,'Neutrality','20040724033908','0','BITMAP','image','jpeg',0,'batctgypqi6bznnjqzpnek8994tykhl'),(1366,'Seagull.jpg','20040724052320!Seagull.jpg',86056,600,396,8,'',46083,'Cantus','20040627070831','0','BITMAP','image','jpeg',0,'momclst04tdtxlhzewievxbjjbigp3i'),(1367,'EnglandSubdivisions1996.png','20040724151441!EnglandSubdivisions1996.png',120166,2165,2670,8,'{{GFDL}}',17287,'Morwen','20040724150638','0','BITMAP','image','png',0,'742r3gvvz826wa9mugmm01rs6l7ve3r'),(1368,'Si-romap.png','20040724165437!Si_romap.png',25032,636,325,8,'Nauportus added',29844,'Boraczek','20040616202203','0','BITMAP','image','png',0,'aba3aczcbe45g5bxmigi7gu1cav5c2c'),(1369,'Detroitmetroarea.jpg','20040724202418!Detroitmetroarea.jpg',91592,618,556,8,'The Detroit Metropolitan tri-county area',88050,'Gsgeorge','20040724162728','0','BITMAP','image','jpeg',0,'5gucl7d9e4a7ce2fkfdwhxh2krquv64'),(1370,'MontrealExpos-100.png','20040724205504!MontrealExpos_100.png',5909,100,100,8,'Montreal Expos logo, claiming fair use<br>{{msg:fairuse}}',23743,'RadicalBender','20040522003926','0','BITMAP','image','png',0,'nycyutryvukgfv6z9tyldazt51lcic5'),(1371,'Cambridge-University-Crest---embossed.png','20040724233615!Cambridge_University_Crest_-_embossed.png',325858,500,577,8,'Cambridge University Crest - embossed',20762,'Prisonblues','20040717125147','0','BITMAP','image','png',0,'i6mjf93khsb1bermuczylqigyryjbsz'),(1372,'Mao-Zemin.jpg','20040725012411!Mao_Zemin.jpg',30438,207,290,8,'[[Mao Zemin]], younger brother of Mao Zedong {{pd}}',42891,'Spencer195','20040725011701','0','BITMAP','image','jpeg',0,'3wadhbzmdfbafts8x00bf9u63hfm5l9'),(1373,'Mao-Zemin.jpg','20040725012434!Mao_Zemin.jpg',26343,204,288,8,'Better version',42891,'Spencer195','20040725012414','0','BITMAP','image','jpeg',0,'9kv127vwt0lksmu8219fvijptea6vm3'),(1374,'Mao-Zemin.jpg','20040725012441!Mao_Zemin.jpg',26343,204,288,8,'',42891,'Spencer195','20040725012437','0','BITMAP','image','jpeg',0,'9kv127vwt0lksmu8219fvijptea6vm3'),(1375,'Cornett.png','20040725040338!Cornett.png',25433,500,341,8,'Cornett',26995,'Chris 73','20040715142552','0','BITMAP','image','png',0,'juab88ymub6a90hadjpc48x17jf0rs9'),(1376,'Saddam-mouth-inspection.jpg','20040725042943!Saddam_mouth_inspection.jpg',7356,250,179,8,'cropped and resized from public domain image http://www.defenselink.mil/daimages/photos/dec2003/newsphotos/npi121403a2.jpg',76,'The Anome','20031215145022','0','BITMAP','image','jpeg',0,'tgs12vsadb6bgmxg2zkf39vjes9yitf'),(1377,'Lollapaloozalogo.png','20040725090343!Lollapaloozalogo.png',55776,711,426,8,'',21013,'Raul654','20040722182934','0','BITMAP','image','png',0,'c1txngrhgxt1i7tdcqa0bzmd6kbnqc6'),(1378,'Country-positions-Iraq-war.png','20040726020651!Country_positions_Iraq_war.png',89376,1357,628,8,'Country positions on the 2003 war in Iraq',49019,'Get-back-world-respect','20040606152137','0','BITMAP','image','png',0,'77gynhplme33cr0pt4x7um793fi7o9v'),(1379,'Copyright-symbol.png','20040726045656!Copyright_symbol.png',4210,114,112,8,'transparency looks crap',42385,'Lupin','20040714153631','0','BITMAP','image','png',0,'33r3o2majmf1qhg5ycdtpmmjg63628e'),(1380,'Go-board.jpg','20040726061145!Go_board.jpg',48248,600,317,8,'Photograph of Go board, taken by myself {{msg:GFDL}} ',24744,'Donarreiskoffer','20040505154609','0','BITMAP','image','jpeg',0,'czy70q9pposo6ev9yh491wj52893cjg'),(1381,'Bobbagum.jpg','20040726161624!Bobbagum.jpg',4155,170,170,8,'bobbagum\'s picture',88346,'Bobbagum','20040726155729','0','BITMAP','image','jpeg',0,'5drjb75ss2xtww1mba0odto9sr9mvd2'),(1382,'Laser-(debit-card).png','20040726183237!Laser_(debit_card).png',2921,69,73,8,'Laser (debit card)',49447,'Djegan','20040717173914','0','BITMAP','image','png',0,'kxmq3qx5ei4pe4j07o1wksn0yjktlta'),(1383,'EnglandWestRidingPre1974.png','20040726200645!EnglandWestRidingPre1974.png',62934,1500,1828,8,'{{GFDL}}',17287,'Morwen','20040726200216','0','BITMAP','image','png',0,'gka0kxpmy9kcamk0ik6mpg754z22l12'),(1384,'Country-positions-Iraq-war.png','20040727051042!Country_positions_Iraq_war.png',74679,1357,628,8,'non-interlaced, smaller file',85484,'Aris Katsaris','20040726020714','0','BITMAP','image','png',0,'6fmkvlp9bdnqrz8i482ptmq2buxsitr'),(1385,'Map-location-rockall.jpg','20040727094343!Map_location_rockall.jpg',33077,265,240,8,'Rockall location map, PD',29085,'Kokiri','20040727085452','0','BITMAP','image','jpeg',0,'5pvewxxw3elaorrcr0v0hy0c6pwizen'),(1386,'Coat-of-Arms-Reagan-Shield-1.png','20040727102856!Coat_of_Arms_Reagan_Shield_1.png',19728,150,175,8,'Rendering of shield from blazon',54836,'Garryq','20040726164306','0','BITMAP','image','png',0,'2vdi0eih002ki582m0rj0w66ut77h04'),(1387,'Coat-of-Arms-Reagan-Shield-1.png','20040727103316!Coat_of_Arms_Reagan_Shield_1.png',23941,112,144,8,'Arms redrawn  {{pd}}',54836,'Garryq','20040727102915','0','BITMAP','image','png',0,'4zqomcun1xx3q2e3ztxfuw575tmw6h3'),(1388,'Crude-EU12-orig.png','20040728062507!Crude-EU12-orig.png',4902,262,160,8,'correcting borders of USSR',85484,'Aris Katsaris','20040716041453','0','BITMAP','image','png',0,'3mnzve4ylvsywsyz80cunak2wshb073'),(1389,'EU25-greens-AK.png','20040728062538!EU25-greens-AK.png',6084,262,160,8,'Modified from Image:Test Crude-EU25-colored stretched greens.png {GFDL}',85484,'Aris Katsaris','20040714222003','0','BITMAP','image','png',0,'5lvp5xshtftbfvoo1ifuo2o0pvvvtkg'),(1390,'Single-channel-Bell-test.png','20040728092516!Single-channel_Bell_test.png',7923,379,122,8,'Smaller version of my \"pile of plates\" single channel Bell test sketch',82687,'Caroline Thompson','20040728090219','0','BITMAP','image','png',0,'j52cpw115qbb8ayoj39cjegbd9g5s7f'),(1391,'Single-channel-Bell-test.png','20040728093309!Single-channel_Bell_test.png',15492,0,0,0,'Improved version: my diagram of single-channel Bell test',82687,'Caroline Thompson','20040728092545','0','BITMAP','image','png',0,'3h2ox9cni17ify63w415xb7ku337xv7'),(1392,'Single-channel-Bell-test.png','20040728093544!Single-channel_Bell_test.png',15492,0,0,0,'Improved version: my diagram of single-channel Bell test',82687,'Caroline Thompson','20040728093318','0','BITMAP','image','png',0,'3h2ox9cni17ify63w415xb7ku337xv7'),(1393,'Happy-Happy-Happy2.jpg','20040729025457!Happy_Happy_Happy2.jpg',145937,1024,835,8,'Picture taken July 24, 2004 by Allen Timothy Chang in San Francisco Chinatown',44426,'Allentchang','20040727015506','0','BITMAP','image','jpeg',0,'oyaej4dlnusodukq3jp4w29ho7ou7e1'),(1394,'TyphoonCombatRating.PNG','20040729114807!TyphoonCombatRating.PNG',18877,892,620,8,'Typhoon Combat performance',56128,'H1523702','20040729114216','0','BITMAP','image','png',0,'9a5u8cbb14dcbmn353a4g42xpipgf9m'),(1395,'Speckled-Wood-butterfly-800.jpg','20040729180647!Speckled_Wood_butterfly_800.jpg',178677,800,719,8,'Reverted to earlier revision',6561,'Sannse','20040723201241','0','BITMAP','image','jpeg',0,'kgiaibudr780efa38lflaaywvarp26o'),(1396,'Palmsundaytwintornadoes.jpg','20040729184701!Palmsundaytwintornadoes.jpg',3178,160,128,8,'',37459,'BigT27','20040225222453','0','BITMAP','image','jpeg',0,'n7cd1s80g85nd66do5u7b1muwtqilm2'),(1397,'Drapers-COA.jpg','20040729225316!Drapers_COA.jpg',328470,1730,1620,8,'jpg conversion of [[Image:Drapers_COA.png]]',38775,'Marnanel','20040619162229','0','BITMAP','image','jpeg',0,'gzy3qgdfyfjvrflvnrm0ofn0wae1ogb'),(1398,'Go-board.jpg','20040730032503!Go_board.jpg',150448,600,352,8,'enhanced',4099,'Stevertigo','20040726061147','0','BITMAP','image','jpeg',0,'om2s79bt3rgro1yynwafbim0yfwa7n7'),(1399,'HbA-vs-HbF-saturation-curve.png','20040730213828!HbA_vs_HbF_saturation_curve.png',15046,637,544,8,'Comparison of [[hemoglobin]] and [[fetal hemoglobin]] oxygen dissociation curves, drawn by [[User:Diberri]] in [[Adobe Illustrator]]. {{GFDL}}',35331,'Diberri','20040730211834','0','BITMAP','image','png',0,'qq9k58arlwsejbusp7ygmtj6ftjdxc0'),(1400,'HbA-vs-HbF-saturation-curve-unlabeled.png','20040730213918!HbA_vs_HbF_saturation_curve_unlabeled.png',10216,637,544,8,'Unlabeled version of [[:Image:HbA vs HbF saturation curve.png]], by [[User:Diberri]]. {{GFDL}}',35331,'Diberri','20040730211935','0','BITMAP','image','png',0,'oponjjkss7z9bza80fflddmm48krsqc'),(1401,'HbA-vs-HbF-saturation-curve.png','20040730221500!HbA_vs_HbF_saturation_curve.png',15033,639,541,8,'realign',35331,'Diberri','20040730213856','0','BITMAP','image','png',0,'p0u7ula1xz6w5gda3ur4phmgcplnbv2'),(1402,'SFOakBBLaticeBeams.jpg','20040731040113!SFOakBBLaticeBeams.jpg',35592,400,368,8,'Detail of eastern span of the [[San Francisco-Oakland Bay Bridge]] showing obsolete lattice beams. Image by [[User:Leonard G.]]. {{cc-sa}}',46238,'Leonard G.','20040729154440','0','BITMAP','image','jpeg',0,'80wxd0anrp1os1oe82g29ntvx5zc1x4'),(1403,'Grand-Coulee.jpg','20040731063308!Grand_Coulee.jpg',187434,825,1124,8,'Grand Coulee',39635,'Pud','20040731061259','0','BITMAP','image','jpeg',0,'htbt37swl22ywl7fnqghv2qnmu2apej'),(1404,'Single-channel-Bell-test.png','20040731093744!Single-channel_Bell_test.png',5301,376,119,8,'Revised small version of single-channel Bell test diagram',82687,'Caroline Thompson','20040728093553','0','BITMAP','image','png',0,'2i97s3o6zphbst6wdv8gawwo1oqcaug'),(1405,'Single-channel-Bell-test.png','20040731094145!Single-channel_Bell_test.png',16369,866,273,8,'Sketch of single channel Bell test (png)',82687,'Caroline Thompson','20040731093807','0','BITMAP','image','png',0,'5fbgdb0ljclg6fjut13lv2ojmy1d8bp'),(1406,'Red-Cedar-Inn-Pacific-MO-med.jpg','20040801014944!Red_Cedar_Inn_Pacific_MO-med.jpg',103303,640,480,8,'Historic Red Cedar Inn, Pacific, MO',88976,'Kbh3rd','20040801010840','a:26:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"288/3\";s:11:\"YResolution\";s:5:\"288/3\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2000:00:00 00:00:00\";s:16:\"YCbCrPositioning\";i:2;s:9:\"Copyright\";s:16:\"Copyright 9,2002\";s:12:\"ExposureTime\";s:17:\"1615441/268435456\";s:7:\"FNumber\";s:7:\"800/100\";s:15:\"ExposureProgram\";i:3;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2000:00:00 00:00:00\";s:17:\"DateTimeDigitized\";s:19:\"2000:00:00 00:00:00\";s:22:\"CompressedBitsPerPixel\";s:15:\"6633904/3145728\";s:17:\"ShutterSpeedValue\";s:4:\"59/8\";s:13:\"ApertureValue\";s:7:\"600/100\";s:17:\"ExposureBiasValue\";s:4:\"0/18\";s:16:\"MaxApertureValue\";s:5:\"37/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:10:\"ColorSpace\";i:1;s:13:\"ExposureIndex\";s:3:\"1/1\";s:13:\"SensingMethod\";i:2;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'jz9cm9rh2j9eey3tntw2zj50h7mq2rc'),(1407,'Downtown-Pacific-MO-med.jpg','20040801015617!Downtown_Pacific_MO-med.jpg',68095,640,480,8,'Part of historic downtown in Pacific, Missouri',88976,'Kbh3rd','20040801012957','a:26:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"288/3\";s:11:\"YResolution\";s:5:\"288/3\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2000:00:00 00:00:00\";s:16:\"YCbCrPositioning\";i:2;s:9:\"Copyright\";s:16:\"Copyright 9,2002\";s:12:\"ExposureTime\";s:16:\"571536/268435456\";s:7:\"FNumber\";s:7:\"800/100\";s:15:\"ExposureProgram\";i:3;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2000:00:00 00:00:00\";s:17:\"DateTimeDigitized\";s:19:\"2000:00:00 00:00:00\";s:22:\"CompressedBitsPerPixel\";s:15:\"6632976/3145728\";s:17:\"ShutterSpeedValue\";s:4:\"71/8\";s:13:\"ApertureValue\";s:7:\"600/100\";s:17:\"ExposureBiasValue\";s:4:\"0/18\";s:16:\"MaxApertureValue\";s:5:\"37/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:10:\"ColorSpace\";i:1;s:13:\"ExposureIndex\";s:3:\"1/1\";s:13:\"SensingMethod\";i:2;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'8q3zq1iatri3uyoykwbjuot2xpwz159'),(1408,'Protected-Page-Lock.png','20040801042333!Protected_Page_Lock.png',1822,45,52,8,'{{GFDL}}',73335,'Squash','20040801003635','0','BITMAP','image','png',0,'tgm5drhxn73r8jbwol84k2bps9933d6'),(1409,'Speedy-Delete-Cross.png','20040801080912!Speedy_Delete_Cross.png',1951,45,44,8,'{{GFDL}}',73335,'Squash','20040801062941','0','BITMAP','image','png',0,'5brttye0t98vws4fr7i7exaqyn70wqa'),(1410,'Palmsundaytwintornadoes.jpg','20040802025620!Palmsundaytwintornadoes.jpg',3178,160,128,8,'Reverted to earlier revision',69086,'LumenSimus','20040729184702','0','BITMAP','image','jpeg',0,'n7cd1s80g85nd66do5u7b1muwtqilm2'),(1411,'Protected-Page-Lock.png','20040802055430!Protected_Page_Lock.png',1400,45,52,8,'deobnoxiousize, transparency, optimize',47960,'Guanaco','20040801082613','0','BITMAP','image','png',0,'ixy2vvd9xe7ssnglcgo2vibeude7fiy'),(1412,'Squash-Wikipedia-Design-2.png','20040802064244!Squash_Wikipedia_Design_2.png',5944,145,51,8,'{{GFDL}}',73335,'Squash','20040802054700','0','BITMAP','image','png',0,'8ig87n8nkp5g0ctxz563j1gzbrxo7fs'),(1413,'Squash-Wikipedia-Design-2.png','20040802070006!Squash_Wikipedia_Design_2.png',5259,145,51,8,'{{GFDL}}',73335,'Squash','20040802064258','0','BITMAP','image','png',0,'23cebc2hkm4ilig2smqe8yq59br1yuo'),(1414,'Ilyanepbyhour.png','20040802073853!Ilyanepbyhour.png',2422,441,320,2,'',18610,'VeryVerily','20040624005742','0','BITMAP','image','png',0,'hx7ntoftmiywnsud1n86nji553b71n9'),(1415,'Vvbyhour.png','20040802115035!Vvbyhour.png',3310,442,320,2,'update',18610,'VeryVerily','20040716221413','0','BITMAP','image','png',0,'d97c91zot0um0vuqr81d21pgw06nok1'),(1416,'User-Fredrik.jpg','20040802164923!User_Fredrik.jpg',55666,387,508,8,'different image',26675,'Fredrik','20040704232326','0','BITMAP','image','jpeg',0,'c5vlppgnsxxr8d2yjwrwtmelvslj62m'),(1417,'Nunavut-Melville-Island.png','20040802172217!Nunavut_Melville_Island.png',11260,320,329,8,'',55077,'Keith Edkins','20040802171015','0','BITMAP','image','png',0,'0pgphxmy3o943zp87aoptc9g30941r9'),(1418,'Ilyanep-contribution-graph.png','20040802173748!Ilyanep_contribution_graph.png',6187,458,179,8,'Contributions graph for [[User:Ilyanep]]. {{GFDL}}',26675,'Fredrik','20040625185153','0','BITMAP','image','png',0,'666ve9hn8m7s2pdphldwzuz6i75c88y'),(1419,'Pedal-curve-1.mng','20040802183735!Pedal-curve-1.mng',240374,0,0,0,'animation of [[pedal curve]] generation, this version showing a five-cusp [[hypocycloid]] generating a five-petal [[rose (mathematics)|rose]], made myself {{GFDL}}',20238,'Kwantus','20040802181912','','UNKNOWN','unknown','unknown',0,'ippyotz3ajdnb488nida0af0z4rlo4m'),(1420,'Baltic-languages.png','20040803032212!Baltic_languages.png',199761,480,543,8,'Distribution of the Baltic languages',68840,'Robin Hood','20040803025616','0','BITMAP','image','png',0,'kyyihil7h6rmsj5x9b2ep3c5soyn3we'),(1421,'Orderbath.gif','20040803033127!Orderbath.gif',11585,78,150,8,'Order of the Bath Medal {{PD}}',63572,'Husnock','20040803023448','0','BITMAP','image','gif',0,'1sn87nasm3f3hlxl64iqa9eghg0y5bk'),(1422,'Orderbath.gif','20040803033222!Orderbath.gif',54690,182,350,8,'',20178,'Lord Emsworth','20040803033135','0','BITMAP','image','gif',0,'59vss5qf1ls3mj2lry28cluhm96rge9'),(1423,'Protected-Page-Lock.png','20040803061858!Protected_Page_Lock.png',1822,45,52,8,'Reverted to earlier revision',73335,'Squash','20040802055430','0','BITMAP','image','png',0,'tgm5drhxn73r8jbwol84k2bps9933d6'),(1424,'Protected-Page-Lock.png','20040803062611!Protected_Page_Lock.png',707,35,40,8,'{{GFDL}}',73335,'Squash','20040803061911','0','BITMAP','image','png',0,'9uhlfdt55c8ejsdfgw9oq8jnw81dsls'),(1425,'NASA-Cavalli-Sforza.gif','20040803070437!NASA_Cavalli-Sforza.gif',92356,575,252,8,'{{GFDL}} Image produced from digitally modified NASA photo and data from books by Luigi Luca Cavalli-Sforza by Patrick Edwin Moran, 2004',16559,'Patrick0Moran','20040803070007','0','BITMAP','image','gif',0,'1w8fw838w5w3ugvilxydr6r19b8i3f4'),(1426,'Protected-Page-Lock.png','20040803075508!Protected_Page_Lock.png',703,35,40,8,'{{GFDL}}',73335,'Squash','20040803062716','0','BITMAP','image','png',0,'aqy3nwb2516ujwlcmovl85jairhof2l'),(1427,'Glendale-CA-seal.jpg','20040803180220!Glendale_CA_seal.jpg',14674,85,85,8,'Not GFDL. Seal of the city of Glendale, California. Obtained from [http://www.ci.glendale.ca.us/government/cityattorney/index.asp]. See [[Wikipedia:Logos]] for guidance on use.',50040,'Mackerm','20040803080515','0','BITMAP','image','jpeg',0,'ardjz81vaxysdw596vhpsixcdqj0lq5'),(1428,'Plettenberg-arms.png','20040803211919!Plettenberg_arms.png',5487,133,143,8,'Coat of arms of the city Plettenberg',7580,'Ahoerstemeier','20040719194813','0','BITMAP','image','png',0,'q4kp5xi8y7kbjtmfs9ni7qd9ov826sk'),(1429,'BankofLansing1.jpg','20040803213422!BankofLansing1.jpg',49866,278,432,8,'i took the picture and release it under {{GFDL}}  ',86452,'Carptrash','20040803184503','0','BITMAP','image','jpeg',0,'co0xxxj2itwxzrg7ugn2g61hn6fd6b7'),(1430,'BankofLansing2.jpg','20040803232911!BankofLansing2.jpg',48462,279,432,8,'I took the picture and release it as {{GFDL}}',86452,'Carptrash','20040803214235','0','BITMAP','image','jpeg',0,'dra71d8c3genudx8hlk4er5iaoabflx'),(1431,'BankofLansing2.jpg','20040803233603!BankofLansing2.jpg',48463,279,432,8,'i too it {{GFDL}}',86452,'Carptrash','20040803232935','0','BITMAP','image','jpeg',0,'dqert9vztlqb6bszdaevkzit94ncwhn'),(1432,'BankofLansing3.jpg','20040803233919!BankofLansing3.jpg',52921,279,433,8,'I took it {{GFDL}}',86452,'Carptrash','20040803223424','0','BITMAP','image','jpeg',0,'64h4tv1ytktg9u6p5ml081uv10l0vn7'),(1433,'Brazil-Espirito-Santo.png','20040804125408!Brazil_Espirito_Santo.png',18130,221,229,8,'{{msg:GFDL}}',17287,'Morwen','20040309195247','0','BITMAP','image','png',0,'1pvmxbp8dtk0ph5siezaiov0c5gflde'),(1434,'Map-of-Espirito-Santo-with-Capital-and-Neighbour-States.PNG','20040804125719!Map_of_Espirito_Santo_with_Capital_and_Neighbour_States.PNG',36422,227,345,8,'Map of Espirito Santo with Capital and Neighbour States',64597,'Kurogawa','20040612173431','0','BITMAP','image','png',0,'5cxwuailq83wdjwx2o598he8cn9bw2s'),(1435,'Espirito-Santo-Map-with-Linhares-Municipality-Highlighted.PNG','20040804130603!Espirito_Santo_Map_with_Linhares_Municipality_Highlighted.PNG',10353,238,345,8,'Espirito Santo Map with Linhares Municipality Highlighted',64597,'Kurogawa','20040524162926','0','BITMAP','image','png',0,'4u7xz0djcr9xb2ovi2iahs19sf3hbeb'),(1436,'Espirito-Santo-Map-with-Domingos-Martins-Municipality-Highlighted.PNG','20040804131357!Espirito_Santo_Map_with_Domingos_Martins_Municipality_Highlighted.PNG',10460,227,345,8,'Espirito Santo Map with Domingos Martins Municipality Highlighted',64597,'Kurogawa','20040524161614','0','BITMAP','image','png',0,'7qxdnuflosit3y3fe34c9zdyz8249pr'),(1437,'Espirito-Santo-Map-with-Afonso-Claudio-Municipality-Highlighted.PNG','20040804131345!Espirito_Santo_Map_with_Afonso_Claudio_Municipality_Highlighted.PNG',10418,227,345,8,'Eapirito Santo Map with Afonso Claudio Municipality Highlighted',64597,'Kurogawa','20040524155946','0','BITMAP','image','png',0,'8nuw3h5ir9f0ybausqntbdwc3rmvbs7'),(1438,'Espirito-Santo-Map-with-Marechal-Floriano-Municipality-Highlighted.PNG','20040804132247!Espirito_Santo_Map_with_Marechal_Floriano_Municipality_Highlighted.PNG',10397,227,345,8,'Espirito Santo Map with Marechal Floriano Municipality Highlighted',64597,'Kurogawa','20040524164830','0','BITMAP','image','png',0,'4l6c6ewk6971hgrybn3p0sv6r6phk3g'),(1439,'Espirito-Santo-Map-with-Venda-Nova-do-Imigrante-Municipality-Highlighted.PNG','20040804132244!Espirito_Santo_Map_with_Venda_Nova_do_Imigrante_Municipality_Highlighted.PNG',10491,227,345,8,'Espirito Santo Map with Venda Nova do Imigrante Municipality Highlighted',64597,'Kurogawa','20040524171032','0','BITMAP','image','png',0,'i1kbek0bglwikqb8vnpolnawdc3ggek'),(1440,'Espirito-Santo-Map-With-Serra-Municipality-Highlighted.PNG','20040804132715!Espirito_Santo_Map_With_Serra_Municipality_Highlighted.PNG',10035,227,345,8,'Espirito Santo Map with Serra Municipality Highlighted',64597,'Kurogawa','20040524154038','0','BITMAP','image','png',0,'be966fgywgs7lsjmrjmv63b7fblkx3d'),(1441,'Inuyashacharactersrelationshipguide.jpg','20040804171020!Inuyashacharactersrelationshipguide.jpg',68489,380,458,8,'Inuyasha Characters Relationship Guide',87359,'Raquel Sama','20040721165702','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"150/1\";s:11:\"YResolution\";s:5:\"150/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:07:21 13:56:08\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'qveskdrjpxvfavycrf2uq725u47zrd2'),(1442,'University-of-Puerto-Rico-at-Mayaguez.logo.jpg','20040804191721!University_of_Puerto_Rico_at_Mayaguez.logo.jpg',19111,197,189,8,'Logo of the [[University of Puerto Rico at Mayaguez]]',52361,'Joseph Dwayne','20040803015532','0','BITMAP','image','jpeg',0,'5gokfaugkxowxi84i7jiy276kjmo6pa'),(1443,'Alhaznawi-video-aljazeera.jpg','20040804205614!Alhaznawi_video_aljazeera.jpg',23571,269,150,8,'Al-Haznawi appearing in an al-Qaida video',57108,'Quadell','20040804205437','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2002:09:16 21:52:57\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'l7fyx4ig9noyqvuiewokjqpknquhbiw'),(1444,'Eagle2LL.jpg','20040804212830!Eagle2LL.jpg',37364,392,587,8,'I took it {{GFDL}}  [[Image:Eagle2LL.jpg|thumb|128px|left|Sodliers & SailorsMemorial Bridge, Philadelphia, Pennsylvania]]',86452,'Carptrash','20040804212638','0','BITMAP','image','jpeg',0,'kpe0b2075nevb7nko6vcfkmo1l35wd5'),(1445,'CarillonBell.jpg','20040805134840!CarillonBell.jpg',458752,1600,1200,8,'[[Carillon]] bell',26995,'Chris 73','20040805134751','a:25:{s:4:\"Make\";s:5:\"NIKON\";s:5:\"Model\";s:4:\"E950\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2002:05:26 18:57:42\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/600\";s:7:\"FNumber\";s:5:\"26/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:0;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2001:02:03 13:54:06\";s:17:\"DateTimeDigitized\";s:19:\"2001:02:03 13:54:06\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"26/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:1;s:11:\"FocalLength\";s:5:\"72/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'hthpq6oyuw1jj1qh6hyismiicxwlb8d'),(1446,'Wikipedia-onthe-web.png','20040805171256!Wikipedia-onthe-web.png',3910,480,321,8,'Chart of # of mentions of wikipedia on other sites',88976,'Kbh3rd','20040805151141','0','BITMAP','image','png',0,'cp0el4q3brn3v9w07yctc8uylpavygl'),(1447,'Inuyashacharactersrelationshipguide.jpg','20040805222507!Inuyashacharactersrelationshipguide.jpg',32435,380,458,8,'Replaced wâpuro with macrons',15708,'WhisperToMe','20040804171048','0','BITMAP','image','jpeg',0,'cjowgbadod8ook89o7h3ivgjp365yz5'),(1448,'Inuyashacharactersrelationshipguide.jpg','20040805222603!Inuyashacharactersrelationshipguide.jpg',68489,380,458,8,'Reverted to earlier revision',81822,'JoshG','20040805222507','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"150/1\";s:11:\"YResolution\";s:5:\"150/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:07:21 13:56:08\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'qveskdrjpxvfavycrf2uq725u47zrd2'),(1449,'Sgian-dubh.jpg','20040806052710!Sgian_dubh.jpg',15574,482,126,8,'Scottish ceremonial dagger.  {{noncommercial}}',65307,'Drhaggis','20040806052526','0','BITMAP','image','jpeg',0,'ggu2dcyazoidcxcuby5ydlqoz3qtbzh'),(1450,'Popham0.gif','20040806091114!Popham0.gif',1054,60,60,8,'Popham signal flag 0',54496,'Auximines','20040806080334','0','BITMAP','image','gif',0,'tlm8rqfkjm31lmjxzkwmsh89zucm7dr'),(1451,'Popham1.gif','20040806091142!Popham1.gif',1052,60,60,8,'Popham signal flag 1. Created by me.',54496,'Auximines','20040806080451','0','BITMAP','image','gif',0,'9cu9zhax7yem999f1fjd9tz5hd39sc5'),(1452,'Popham2.gif','20040806091200!Popham2.gif',987,60,60,8,'Popham signal flag 2. Created by me.',54496,'Auximines','20040806080519','0','BITMAP','image','gif',0,'3g5y151rshmgff3wnhwphtgmxjsu2nr'),(1453,'Popham3.gif','20040806091222!Popham3.gif',1101,60,60,8,'Popham signal flag 3. Created by me. {{GFDL}}',54496,'Auximines','20040806080558','0','BITMAP','image','gif',0,'hwpzehgl55v9wvtxcwfqldnhmf0qt6f'),(1454,'Popham4.gif','20040806091236!Popham4.gif',1044,60,60,8,'Popham signal flag 4. Created by me. {GFDL}',54496,'Auximines','20040806080811','0','BITMAP','image','gif',0,'9cbenasvmxnlqfpjieedoa29fhudh1i'),(1455,'Popham5.gif','20040806091244!Popham5.gif',955,60,60,8,'Popham signal flag 5. Created by me. {GFDL}',54496,'Auximines','20040806080833','0','BITMAP','image','gif',0,'qqsb7kjwjewxfjm25gwwwvjj83fjlsw'),(1456,'Popham7.gif','20040806091308!Popham7.gif',1046,60,60,8,'Popham signal flag 7. Created by me. {GFDL}',54496,'Auximines','20040806080851','0','BITMAP','image','gif',0,'q7yruunir0rgadn08591yrreh7jff58'),(1457,'Popham8.gif','20040806091334!Popham8.gif',901,60,60,8,'Popham signal flag 8. Created by me. {GFDL}',54496,'Auximines','20040806080904','0','BITMAP','image','gif',0,'s6ot9cweqdn6ich2j9ofjt6p2kl3cas'),(1458,'Popham9.gif','20040806091340!Popham9.gif',1025,60,60,8,'Popham signal flag 9. Created by me. {GFDL}',54496,'Auximines','20040806080924','0','BITMAP','image','gif',0,'m04fqdfskeegnx6l26w1e6b4auoy31l'),(1459,'Pophamsu.gif','20040806091743!Pophamsu.gif',997,60,60,8,'Popham flag SU. Created by me. {{GFDL}}',54496,'Auximines','20040806091541','0','BITMAP','image','gif',0,'a1ghji7j7jl102t0hr0stl7q69yvpnr'),(1460,'GeorgiaTechStudentCenterSidewalk.jpg','20040806094914!GeorgiaTechStudentCenterSidewalk.jpg',110477,640,455,8,'Got rid of balcony',13476,'Dcoetzee','20040407010753','a:23:{s:16:\"ImageDescription\";s:20:\"Intel Digital Camera\";s:4:\"Make\";s:30:\"Intel(R) Pocket Digital Camera\";s:5:\"Model\";s:5:\"CS780\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:04:06 21:05:49\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:5:\"1/120\";s:7:\"FNumber\";s:5:\"80/10\";s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"0000:00:00 00:00:00\";s:17:\"DateTimeDigitized\";s:19:\"0000:00:00 00:00:00\";s:22:\"CompressedBitsPerPixel\";s:5:\"16/10\";s:16:\"MaxApertureValue\";s:5:\"30/10\";s:12:\"MeteringMode\";i:1;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:7:\"646/100\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'satpk3kwsyqu2wsi0dg19hmrq0lgsay'),(1461,'GeorgiaTechStudentCenterSidewalk.jpg','20040806095034!GeorgiaTechStudentCenterSidewalk.jpg',114324,640,480,8,'Reverted to earlier revision',72385,'Asimperson','20040806094914','a:23:{s:16:\"ImageDescription\";s:20:\"Intel Digital Camera\";s:4:\"Make\";s:30:\"Intel(R) Pocket Digital Camera\";s:5:\"Model\";s:5:\"CS780\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:04:06 21:04:51\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:5:\"1/120\";s:7:\"FNumber\";s:5:\"80/10\";s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"0000:00:00 00:00:00\";s:17:\"DateTimeDigitized\";s:19:\"0000:00:00 00:00:00\";s:22:\"CompressedBitsPerPixel\";s:5:\"16/10\";s:16:\"MaxApertureValue\";s:5:\"30/10\";s:12:\"MeteringMode\";i:1;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:7:\"646/100\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'2009cnucpf11g2vd5f5n3qradf2fsw1'),(1462,'Popham8.gif','20040806112750!Popham8.gif',1001,60,60,8,'improved',54496,'Auximines','20040806091338','0','BITMAP','image','gif',0,'oit31nx46yiwmdffoxfpbzb5z217hbb'),(1463,'Pophamsu.gif','20040806112824!Pophamsu.gif',997,60,60,8,'corrected',54496,'Auximines','20040806091750','0','BITMAP','image','gif',0,'8s1prsahicakqqlp155ho5g8na21nzx'),(1464,'Perfect-Circular-Lie-(aesthectic-diagram).jpg','20040806195402!Perfect_Circular_Lie_(aesthectic_diagram).jpg',99664,444,381,8,'license of file/circular copyright/GFDL',90589,'R.B.','20040806195025','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"150/1\";s:11:\"YResolution\";s:5:\"150/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:08:06 12:43:09\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'capsm4ienxyq28jfdib952vxrbt5ume'),(1465,'Perfect-Circular-Lie-(aesthectic-diagram).jpg','20040806200541!Perfect_Circular_Lie_(aesthectic_diagram).jpg',99664,444,381,8,'license of file/circular copyright/GFDL',90589,'R.B.','20040806195414','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"150/1\";s:11:\"YResolution\";s:5:\"150/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:08:06 12:43:09\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'capsm4ienxyq28jfdib952vxrbt5ume'),(1466,'Indexf-layout.png','20040806203637!Indexf_layout.png',39064,895,424,8,'files-11 indexf.sys layout, created by me, public domain',74348,'Kate','20040806203208','0','BITMAP','image','png',0,'sjjpvwr05usvhl40epx7beklf26he6y'),(1467,'Perfect-Circular-Lie-(aesthectic-diagram).jpg','20040806203742!Perfect_Circular_Lie_(aesthectic_diagram).jpg',99664,0,0,0,'Image file .jpg/GDFL public domain/Physical cosmology',90589,'R.B.','20040806200601','',NULL,'unknown','unknown',0,''),(1468,'Perfect-Circular-Lie-(aesthectic-diagram).jpg','20040806210056!Perfect_Circular_Lie_(aesthectic_diagram).jpg',99664,444,381,8,'Author Name: R.B/theoretical drawing supporting text/Image:File.png|alt text/ Physical cosmology.jpg',90589,'R.B.','20040806203759','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"150/1\";s:11:\"YResolution\";s:5:\"150/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:08:06 12:43:09\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'capsm4ienxyq28jfdib952vxrbt5ume'),(1469,'Perfect-Circular-Lie-(aesthectic-diagram).jpg','20040806214323!Perfect_Circular_Lie_(aesthectic_diagram).jpg',99664,0,0,0,'author R.B. diagram drawing supporting theory\\wikipedia image description page:\\wikipedia: Fair use\\wikipedia: Pysical cosmology image depiction of Circular Lie Theory.jpg',90589,'R.B.','20040806210111','',NULL,'unknown','unknown',0,''),(1470,'Indexf-layout.png','20040806221516!Indexf_layout.png',36371,895,424,8,'',74348,'Kate','20040806203649','0','BITMAP','image','png',0,'s624of25c9di5e1ktdz0jom0c68xa7a'),(1471,'Indexf-layout.png','20040806231434!Indexf_layout.png',36236,895,424,8,'',74348,'Kate','20040806221524','0','BITMAP','image','png',0,'ilxz3t99ioz4g52um5ck15ilfgn5ku1'),(1472,'Uss-kearsarge-us-navy-web-040701-N-2972R-068.jpg','20040807025223!Uss_kearsarge_us_navy_web_040701-N-2972R-068.jpg',122796,600,842,8,'USS Kearsarge (LHD-3), US Navy photo gallery, public domain',16297,'Dougjih','20040806203754','0','BITMAP','image','jpeg',0,'447x9fi28z3s9hgu2ebfliq820ar6ek'),(1473,'Perfect-Circular-Lie-(aesthectic-diagram).jpg','20040807034909!Perfect_Circular_Lie_(aesthectic_diagram).jpg',99664,444,381,8,'author of sorce Physical cosmology inserts Image:Circular Lie Theory (aesthetic diagram), depiction of circular spaces/File licensed under GNUFDL circular copyright/Image:Circular Lie Theory (aesthtic diagram).jpg',90589,'R.B.','20040806214337','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"150/1\";s:11:\"YResolution\";s:5:\"150/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:08:06 12:43:09\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'capsm4ienxyq28jfdib952vxrbt5ume'),(1474,'Perfect-Circular-Lie-(aesthectic-diagram).jpg','20040807035707!Perfect_Circular_Lie_(aesthectic_diagram).jpg',99664,444,381,8,'author R.B. ',90589,'R.B.','20040807034922','0','BITMAP','image','jpeg',0,'e90jejah0rjdll0gs5uo6j7ahwfle7n'),(1475,'Vvbyhour.png','20040807051856!Vvbyhour.png',3459,442,320,2,'update (+ fix caption)',18610,'VeryVerily','20040802115043','0','BITMAP','image','png',0,'cdxo9gb5ve51n69z2dmuhchx4v87gvn'),(1476,'Indexf-layout.png','20040807132350!Indexf_layout.png',66898,1243,426,8,'',74348,'Kate','20040806231448','0','BITMAP','image','png',0,'gdg2poxntazjgwc2bi5ad07w2k1rel1'),(1477,'EnglandSubdivisions1986.png','20040807175049!EnglandSubdivisions1986.png',118668,2165,2670,8,'{{GFDL}}',17287,'Morwen','20040724150555','0','BITMAP','image','png',0,'9gkxsedmbn4m5po8f1lw6duy6w344e0'),(1478,'Novaya-Zemlya.jpg','20040807203509!Novaya_Zemlya.jpg',25617,351,460,8,'Novaya Zemlya, sattelite image from NASA',300,'Andre Engels','20020920074811','0','BITMAP','image','jpeg',0,'s89t02h65butiywk2buz4v7dcdyiivm'),(1479,'AudreyMunson-1916.jpg','20040808104546!AudreyMunson_1916.jpg',19909,320,240,8,'Photograph of Audrey Munson from The American Film Company  c1916',49943,'Solipsist','20040808103611','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:08:08 11:34:22\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'8e5ariqavmh3ndkqf4xanm0y84cehp3'),(1480,'Vexations-MIDI.zip','20040808105246!Vexations-MIDI.zip',14441,0,0,0,'2 different MIDI versions of Erik Satie\'s Vexations',85402,'Francis Schonken','20040714140323','','ARCHIVE','application','zip',0,'ffklagdk4htum8zc1qgig8jy078kgj8'),(1481,'Preziosi-painting-of-Turkish-harem.jpg','20040809004628!Preziosi_painting_of_Turkish_harem.jpg',35617,540,410,8,'Pictue is in the public domain. Link: http://www.atamanhotel.com/friends/amadeop3.html',83992,'Deff6','20040809004456','0','BITMAP','image','jpeg',0,'rthxx40eacj1q1dhbykbo8eqy2i8ui0'),(1482,'William-Henry-Preece.jpg','20040809054034!William_Henry_Preece.jpg',68050,550,672,8,'This is William Henry Preece, from \'\'Oliver Heaviside: Sage in Solitude\'\' (ISBN 0-87942-238-6), p. 60. The photograph is reprinted courtesy of the IEEE in London (as stated in the credits in the back of the book, p. 318), but its age implies that it\'s pub',17226,'Grendelkhan','20040728005857','0','BITMAP','image','jpeg',0,'hgh3cbdk21dwxatfd5m8ntt4ozdeb65'),(1483,'Mule-box.jpg','20040809080723!Mule_box.jpg',29424,400,300,8,'video game box cover {{fairuse}} from http://media.www.gamespy.com/articles/533/533968/img_2254784.html',49021,'Gracefool','20040809080329','0','BITMAP','image','jpeg',0,'akmw10urs2lz9tayac0lqxl3z0iyfmw'),(1484,'Loft-Story-eye.jpg','20040809083100!Loft_Story_eye.jpg',28703,314,281,8,'{{fairuse}}',73015,'Liberlogos','20040809082843','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:08:09 04:27:42\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'cn8jxjcs4o0kcj48cq2cfzyrj23ulnr'),(1485,'Little-egret-aswan.jpg','20040809183346!Little_egret_aswan.jpg',11803,243,340,8,'',90187,'Hapsiainen','20040805115457','0','BITMAP','image','jpeg',0,'s1c01o8gl8hlz4zkhwl7wo6gb7k1j1e'),(1486,'Turninst.jpg','20040809221826!Turninst.jpg',897132,996,1278,8,'Source: FAA-H-8083-25 \"Pilot;s Handbook of Aeronautical Knowledge,\" pg. 6-11.  Licence: Public domain (work is a product of US Government) {{PD}}.  Illustration of turn and bank and turn coordinator isntruments.  Linked to article \'\'turn coordinator.\'\'',92323,'Flightinstructor','20040809220743','0','BITMAP','image','jpeg',0,'eb4tl9p665nkl6by71ykinapoxr8ugz'),(1487,'Wikipedia-banner0002.png','20040809223338!Wikipedia-banner0002.png',94559,483,163,8,'Public Domain update of nohat\'s original',37056,'SimonMayer','20040416033217','0','BITMAP','image','png',0,'1x9h6yvdim7wn7fck9i0lgi840bcmy0'),(1488,'Lou-Criger-Baseball.jpg','20040810023910!Lou_Criger_Baseball.jpg',71797,448,630,8,'Lou Criger',90873,'Mattingly23','20040809214004','0','BITMAP','image','jpeg',0,'dhhrzqx3eaf1cjy2y7itbf2jqo4enub'),(1489,'Johnny-Cling-Baseball.jpg','20040810024141!Johnny_Cling_Baseball.jpg',51782,637,456,8,'Johnny Kling',90873,'Mattingly23','20040809210543','0','BITMAP','image','jpeg',0,'d6uy0yfc7m48q0nofi3oudrvw9dl8al'),(1490,'Hal-Chase-Baseball.jpg','20040810024348!Hal_Chase_Baseball.jpg',48538,401,500,8,'Hal Chase',90873,'Mattingly23','20040809203948','0','BITMAP','image','jpeg',0,'hg23lai273mzp9gpdg92t2x29g7v00x'),(1491,'Chinese-high-logo.PNG','20040810112138!Chinese_high_logo.PNG',1649,81,85,8,'The Chinese High School Logo',75807,'Frankchn','20040810103109','0','BITMAP','image','png',0,'4xjkc253whv2ghwb81ydzg73t36cscv'),(1492,'Eworth-Lady-Dacre.jpg','20040810120657!Eworth_Lady_Dacre.jpg',2101,80,100,8,'Portrait of Lady Dacre by Hans Eworth',64381,'Pethan','20040810120507','0','BITMAP','image','jpeg',0,'em96v1555p8f3z3dth8liv28bae1cos'),(1493,'DenmarkLæsø.png','20040810154943!DenmarkLæsø.png',28188,200,240,8,'',55077,'Keith Edkins','20040810154814','0','BITMAP','image','png',0,'11lm8cz557sda1s2hubsd79ektz7wax'),(1494,'Wiki.PNG','20040810175819!Wiki.PNG',40014,135,155,8,'Papi',27825,'BigCat','20031026081740','0','BITMAP','image','png',0,'b1n637p2ht5pum3519icrpvzdyh9nay'),(1495,'Jon787.jpg','20040810212754!Jon787.jpg',10640,347,470,8,'Clobbering MJS\'s image of me with a different one :p',32835,'Jon787','20040810211517','0','BITMAP','image','jpeg',0,'7hvg7zwuv6k0vrwlwg9vt5xobch2kdk'),(1496,'Mordecai-Brown-Baseball.jpg','20040810215229!Mordecai_Brown_Baseball.jpg',16454,426,381,8,'[[Mordecai brown]]',90873,'Mattingly23','20040810215220','0','BITMAP','image','jpeg',0,'sv2kz21viuyvgscq0lkou413emmofky'),(1497,'HanscomBrown.jpg','20040811005005!HanscomBrown.jpg',379527,800,600,8,'{{cc-by-nd-nc}}',32345,'Acegikmo1','20040811004458','0','BITMAP','image','jpeg',0,'qo9rae535hhqkdlsqavmf7y583uucxx'),(1498,'Wikipedia.vim','20040811042228!Wikipedia.vim',13866,0,0,0,'slightly improved',4635,'Tim Starling','20030615135605','','UNKNOWN','unknown','unknown',0,'lamjm6wkpdym56n1r0udftukoezifzr'),(1499,'Wikipedia.vim','20040811042228!Wikipedia.vim',14414,0,0,0,'nested bold/italic sections now display correctly',4319,'Bdesham','20040811042256','','UNKNOWN','unknown','unknown',0,'lamjm6wkpdym56n1r0udftukoezifzr'),(1500,'Tubular-unlocked.png','20040811165604!Tubular_unlocked.png',6876,250,102,8,'Illustration of a [[Tubular pin tumbler lock]] made by [[User:Wapcaplet|Wapcaplet]] in [[Blender (program)|Blender]] and touched up in the [[GIMP]].',6264,'Wapcaplet','20031124153125','0','BITMAP','image','png',0,'bhc39utz2xfdvilb7p04mtlmo6cgym8'),(1501,'Cache,basic.dia','20040811194147!Cache,basic.dia',25967,0,0,0,'Fixed diagram so cache is correctly caching memory!',35676,'Iain.mcclatchie','20040723181121','','UNKNOWN','unknown','unknown',0,'rh19945m1331u1wuqmgzmfi7q8jlke9'),(1502,'Cache,basic.png','20040811194230!Cache,basic.png',8140,335,144,8,'Diagram of the basic operation of a cache',35676,'Iain.mcclatchie','20040723180920','0','BITMAP','image','png',0,'22s8ky03l8r2g72ozqzct6nwwq7hnfe'),(1503,'Yamada-png.png','20040812030853!Yamada-png.png',9525,396,104,8,'{{GFDL}}',6707,'TakuyaMurata','20040812021143','0','BITMAP','image','png',0,'lqsbhud7wv124s1r8u97kw7bre0wc9f'),(1504,'Janine1982cover.jpg','20040812060154!Janine1982cover.jpg',13181,246,414,8,'cover of hardback edition of 1982, Janine, by Alasdair Gray; {{fairuse}}',44845,'Henry Flower','20040811091525','0','BITMAP','image','jpeg',0,'9zbd608zmecfc96pb8n753th3bs8q1y'),(1505,'Hephaestos.jpg','20040812175709!Hephaestos.jpg',177842,1232,1632,8,'',3628,'Hephaestos','20040318022704','0','BITMAP','image','jpeg',0,'fpadkcct0iu0mxj2x45rs7po9evy5ua'),(1506,'UssMemphis.jpg','20040813002013!UssMemphis.jpg',17730,448,294,8,'This image is in the public domain. It was obtained from: http://www.navsource.org/archives/04/acr1005.jpg',93191,'Tradermort','20040813001419','0','BITMAP','image','jpeg',0,'f6v06dk7u1x3dhhf62nsdjz6cof38x5'),(1507,'RhodosBeachChairs.jpg','20040813021335!RhodosBeachChairs.jpg',269092,608,894,8,'Beach chairs on the coast of Rhodes, Greece.',82592,'Neep','20040813021245','0','BITMAP','image','jpeg',0,'htfgaxmbiks2esluxpe47pzxoawhz2v'),(1508,'George-a-robinson.jpg','20040813102336!George_a_robinson.jpg',26260,234,340,8,'George Augustus Robinson',45959,'Jgritz','20040228121546','0','BITMAP','image','jpeg',0,'te9kmruk5q97eblc4lgchjg4ekpysyb'),(1509,'Toncontinairport.jpg','20040813150207!Toncontinairport.jpg',112512,1310,810,8,'Toncontin airport, Tegucigalpa, Honduras, 1980',71107,'Sonett72','20040813150001','0','BITMAP','image','jpeg',0,'41q3yk0rzc1xvy3l2735irq1r9l4xfn'),(1510,'Epica-do18-plot.png','20040813202042!Epica_do18_plot.png',6402,596,460,8,'',8072,'William M. Connolley','20040813201932','0','BITMAP','image','png',0,'1qa1sysk3ngil73c2v1ebhv4pwc82n9'),(1511,'Cold-fusion-electrolysis.PNG','20040813203359!Cold_fusion_electrolysis.PNG',13685,320,326,8,'drawn by [[user:Theresa knott|Theresa Knott]]. {{gfdl}}',8257,'Theresa knott','20040813093447','0','BITMAP','image','png',0,'jvg8at5sgfz2b13v0sye3ijf6vanxvm'),(1512,'Wikipedia-onthe-web.png','20040814021203!Wikipedia-onthe-web.png',4843,480,328,8,'Mentions of Wikipedia on other sites on the web',88976,'Kbh3rd','20040805171346','0','BITMAP','image','png',0,'q2y2fzd9ewrg3sh25ektsml51clgfn5'),(1513,'Wikipedia-onthe-web.png','20040814021703!Wikipedia-onthe-web.png',3339,480,240,8,'Mentions of Wikipedia on websites outside Wikipedia',88976,'Kbh3rd','20040814021217','0','BITMAP','image','png',0,'o34wwrzi97wbc9r29p97a3p648a3iv1'),(1514,'Google-Answers-using-Wikipedia.png','20040814024105!Google_Answers_using_Wikipedia.png',4448,480,480,8,'Google Answers using Wikipedia',88976,'Kbh3rd','20040814023442','0','BITMAP','image','png',0,'6myz43mw0czmlmdykr42hfm0l7nihji'),(1515,'Google-Answers-using-Wikipedia.png','20040814025334!Google_Answers_using_Wikipedia.png',3858,480,360,8,'Google Answers using Wikipedia',88976,'Kbh3rd','20040814024109','0','BITMAP','image','png',0,'agzi3uj1uidmm6sjoofsozoumrfr4tt'),(1516,'Nws-logo.png','20040814133658!Nws-logo.png',10571,85,78,8,'[[National Weather Service]] (NWS) logo.<p>{{PD-USGov}}',75749,'Ta bu shi da yu','20040814133455','0','BITMAP','image','png',0,'95al7mx19ykkw185nys8jydtwd7y8db'),(1517,'Jiuhuashan-bodhisattva-image.JPG','20040814143749!Jiuhuashan_bodhisattva_image.JPG',413590,1130,1329,8,'Image of a bodhisattva, relief, from Jiuhuashan in China\'s Anhui province',40885,'Nat Krause','20040814134525','a:28:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:7:\"DSC-P72\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:08:14 21:33:58\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/1250\";s:7:\"FNumber\";s:5:\"28/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:06:19 17:56:17\";s:17:\"DateTimeDigitized\";s:19:\"2004:06:19 17:56:17\";s:22:\"CompressedBitsPerPixel\";s:3:\"4/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"48/16\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"60/10\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'jtppy00mxuwsme16vcj902dhk18vhxt'),(1518,'Isle-of-Dogs,-London,-aerial-photo.jpg','20040814150413!Isle_of_Dogs,_London,_aerial_photo.jpg',189795,1024,768,8,'Isle of Dogs, London, aerial photo, 2003',93522,'Vb4','20040814144958','0','BITMAP','image','jpeg',0,'rc73pbti63mw9gfkpsnokcwsp8e4s9s'),(1519,'Strychnine.png','20040814230954!Strychnine.png',3454,152,109,8,'',88116,'Mykhal','20040814230059','0','BITMAP','image','png',0,'e4hx3y5ddz34goygzj3uzepez7ob1wb'),(1520,'Countdown.jpg','20040815020643!Countdown.jpg',31586,150,150,8,'http://web.tiscali.it/megadeth1/Covers/Countdown(Fronte).jpg {{msg:fairuse}}',61734,'FernE97','20040421190506','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:8:\"DateTime\";s:19:\"2004:04:21 12:04:23\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'tacufnaqkvzz3hwjjleimuvw7zqbofs'),(1521,'JapaneseLicensePlateDwg.gif','20040815063206!JapaneseLicensePlateDwg.gif',27349,640,322,8,'License Plate (Japan) Drawing {{GFDL}}',70428,'Fg2','20040815062732','0','BITMAP','image','gif',0,'lguu77fx5dal3zc3d9px9qgg0gqxhb0'),(1522,'JapaneseLicensePlateDwg.gif','20040815064322!JapaneseLicensePlateDwg.gif',25478,640,322,8,'',70428,'Fg2','20040815063211','0','BITMAP','image','gif',0,'t7c3ohpbqj8p1nwl1md9ztlifwzkndp'),(1523,'Tranzam-2.png','20040815105331!Tranzam-2.png',3026,302,239,8,'',93719,'Richard W.M. Jones','20040815105118','0','BITMAP','image','png',0,'40p90qvtmrjiwlh5o7j1mznwbqvllb4'),(1524,'Tranzam-2.png','20040815105533!Tranzam-2.png',3026,302,239,8,'',93719,'Richard W.M. Jones','20040815105337','0','BITMAP','image','png',0,'40p90qvtmrjiwlh5o7j1mznwbqvllb4'),(1525,'Arcade-atari-road-runner1.png','20040815142757!Arcade-atari-road-runner1.png',13922,400,300,8,'Screenshot Road Runner, Arcade version (StarROMs) on xmame, full resolution {{screenshot}}',72631,'Tjansen','20040815142457','0','BITMAP','image','png',0,'328aqn58ja451q6on0slp3x8b9clhkl'),(1526,'M209-testrender.jpg','20040815181923!M209_testrender.jpg',71235,640,480,8,'Test rendering of an [[M-209]] converter. Created by [[User:Wapcaplet|Wapcaplet]] in [[Blender (program)|Blender]]. {{GFDL}}',6264,'Wapcaplet','20040813015945','0','BITMAP','image','jpeg',0,'701fsgpnx1hg2glapm6fq7940y7e28c'),(1527,'TU-X1.png','20040816003721!TU-X1.png',455016,747,369,8,'Picture taken by Fernando Martins (eBay masterviewer), put into the public domain for use by the Tuner Information Center {{PD}}',13732,'Andrevan','20040816003146','0','BITMAP','image','png',0,'7f8h56475kn23ls536otlpfq0586i7t'),(1528,'TU-X1.png','20040816004026!TU-X1.png',128596,374,184,8,'',13732,'Andrevan','20040816003726','0','BITMAP','image','png',0,'fzmddxih7vu0gtg1zac66ibbhbm0eon'),(1529,'Bismarcksea.jpg','20040816012939!Bismarcksea.jpg',7964,250,166,8,'',21013,'Raul654','20040816012743','0','BITMAP','image','jpeg',0,'adp4c7bac5rl4c0m297rysxka3nq1d4'),(1530,'Bulgarian-Folk-Songs-Miladinovi.jpg','20040816014247!Bulgarian_Folk_Songs_Miladinovi.jpg',3961,96,165,8,'Bulgarian Folk Songs by the Mildinov Brothers',90457,'VMORO','20040816012733','0','BITMAP','image','jpeg',0,'1gefrqxkb90vprwa590tk8h2k606c90'),(1531,'Right.railswitch.jpg','20040816023507!Right.railswitch.jpg',74395,200,670,8,'This image is a slightly modified (by me) version of [[Image:Railroadswitch.jpg]]. I choose not to upload under the same name in order to make the name more descriptive; I was also weary of deleting a fellow Wikipedian\'s work. The original to this derivat',69801,'Ropers','20040815213425','0','BITMAP','image','jpeg',0,'91lbvmtwx4c8j71uf7bmzfjmhvg7cxv'),(1532,'Bomber-Scale-chart-1.jpg','20040816040533!Bomber_Scale-chart_1.jpg',137026,1332,1680,8,'I created this drawing myself, using paper, pen, etc.  There are \'\'\'\'\'no\'\'\'\'\' copyright issues',71699,'Karl Dickman','20040806011847','0','BITMAP','image','jpeg',0,'t9albv4dx0qrcnuhvpimu7pyhllpn64'),(1533,'Bomber-Scale-chart-1.jpg','20040816040716!Bomber_Scale-chart_1.jpg',144338,1332,1680,8,'I created this drawing myself, using paper, pen, etc.  There are \'\'\'\'\'no\'\'\'\'\' copyright issues',71699,'Karl Dickman','20040816040604','0','BITMAP','image','jpeg',0,'iszrb50jp0i8kcwzbccfc59avrjfl27'),(1534,'Falls-of-Clyde-prow.jpg','20040816080153!Falls_of_Clyde_prow.jpg',156393,800,600,8,'Falls of Clyde (detail of the prow)',78384,'Gachet','20040816075841','a:34:{s:4:\"Make\";s:5:\"NIKON\";s:5:\"Model\";s:5:\"E2000\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:9:\"E2000v1.4\";s:8:\"DateTime\";s:19:\"2004:08:15 00:16:17\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"24/9450\";s:7:\"FNumber\";s:7:\"490/100\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:50;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:08:15 00:16:17\";s:17:\"DateTimeDigitized\";s:19:\"2004:08:15 00:16:17\";s:22:\"CompressedBitsPerPixel\";s:5:\"37/10\";s:17:\"ExposureBiasValue\";s:5:\"0/100\";s:16:\"MaxApertureValue\";s:5:\"30/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:8:\"1739/100\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:21:\"FocalLengthIn35mmFilm\";i:115;s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:20:\"SubjectDistanceRange\";i:2;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'9mt24yw2cz22psya05j0bvi2qa71eo1'),(1535,'Lorazepam.png','20040816134543!Lorazepam.png',3247,164,148,8,'',88116,'Mykhal','20040816134326','0','BITMAP','image','png',0,'gmbgldi41felu8qprfbvnys5nb9i77a'),(1536,'Orange-Hawkweed.jpg','20040816161150!Orange-Hawkweed.jpg',37039,200,150,8,'Orange Hawkweed',62483,'Woofles','20040816161142','0','BITMAP','image','jpeg',0,'qn0fwwa2gv3pp5f0ay3fjxop7a8yhzp'),(1537,'Wikipedia-banner0002.png','20040816212641!Wikipedia-banner0002.png',96598,483,163,8,'messy black border on the outside of the wikipedia logo has been expunged from the image',22631,'Frazzydee','20040809223354','0','BITMAP','image','png',0,'40opdk0qtxt520tq0dcosd085f9tlis'),(1538,'Knive-types.png','20040817015744!Knive_types.png',3741,150,256,8,'Types of knives -- hand-crafted in Gimp by yours truly',6669,'Lament','20030128030744','0','BITMAP','image','png',0,'qm1iw7ub0d0d8yugq5ee3n9mlh1oxyz'),(1539,'Map-location-rockall.jpg','20040817154346!Map_location_rockall.jpg',84730,720,520,8,'larger image',3295,'Mintguy','20040727094403','0','BITMAP','image','jpeg',0,'0bqvhsru7zkolsrfdqtry6iaqowc0ui'),(1540,'Map-location-rockall.jpg','20040817154346!Map_location_rockall.jpg',162717,720,520,8,'Map_location-rocall.jpg',80775,'Metron','20040817154355','0','BITMAP','image','jpeg',0,'0bqvhsru7zkolsrfdqtry6iaqowc0ui'),(1541,'Map-location-rockall.jpg','20040817154611!Map_location_rockall.jpg',162717,720,520,8,'Map_location-rocall.jpg',80775,'Metron','20040817154429','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:08:17 17:41:22\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'rlxi8trnopuitfbydjoib7uhcievur2'),(1542,'Map-location-rockall.jpg','20040817155044!Map_location_rockall.jpg',162717,720,520,8,'Map_location_rockall- without U.K-ownership.jpg',80775,'Metron','20040817154617','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:08:17 17:41:22\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'rlxi8trnopuitfbydjoib7uhcievur2'),(1543,'Map-location-rockall.jpg','20040817155226!Map_location_rockall.jpg',162717,720,520,8,'Reverted to earlier revision',0,'62.158.226.27','20040817155044','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:08:17 17:41:22\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'rlxi8trnopuitfbydjoib7uhcievur2'),(1544,'Pythagorean-proof.png','20040817202045!Pythagorean_proof.png',11208,274,165,8,'visual proof of Pythagorean theorem (fixed a and b positions)',9059,'Mihai','20040407020626','0','BITMAP','image','png',0,'dndscq7n9eqkzz0g1v7ltbbuptqyge4'),(1545,'Whiskas-logo.png','20040817205312!Whiskas_logo.png',2499,104,48,8,'',47960,'Guanaco','20040815184842','0','BITMAP','image','png',0,'7nuzugrw5t8ywr6l0wpnpr6ax4jctmz'),(1546,'DiOnion.JPG','20040817215554!DiOnion.JPG',671904,360,540,8,'Diogenes with Onion',89047,'Diogenes','20040817215120','0','BITMAP','image','jpeg',0,'1o09u9o6xrxrpumiu186eiceqzcwr3z'),(1547,'DiOnion.JPG','20040817220552!DiOnion.JPG',92266,360,540,8,'Diogenes with Onion',89047,'Diogenes','20040817215601','0','BITMAP','image','jpeg',0,'1o09u9o6xrxrpumiu186eiceqzcwr3z'),(1548,'Conciergerie-Paris-DSC00684.jpg','20040818074950!Conciergerie_Paris_DSC00684.jpg',2107846,2592,1944,8,'the Conciergerie in Paris, France, Copyright (c) 2003 David Monniaux {{GFDL}}',22449,'David.Monniaux','20040818073413','a:28:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:7:\"DSC-P92\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2003:07:11 19:17:16\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/2000\";s:7:\"FNumber\";s:5:\"56/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2003:07:11 19:17:16\";s:17:\"DateTimeDigitized\";s:19:\"2003:07:11 19:17:16\";s:22:\"CompressedBitsPerPixel\";s:3:\"4/1\";s:17:\"ExposureBiasValue\";s:4:\"3/10\";s:16:\"MaxApertureValue\";s:5:\"48/16\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:1;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"80/10\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:1;s:12:\"WhiteBalance\";i:1;s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'ltli0kqvq0l6duutvnr14c8mbgg9q0u'),(1549,'I057.gif','20040818090612!I057.gif',1273,32,32,8,'32x32 Icon for Interstate 57 Sign, Dynamically Created',30225,'Rfc1394','20040818090241','0','BITMAP','image','gif',0,'ryswaxgaqsfowe5f73i0dfptlspape2'),(1550,'I057.gif','20040818090720!I057.gif',1273,32,32,8,'32x32 Icon for Interstate 57 Sign, Dynamically Created',30225,'Rfc1394','20040818090651','0','BITMAP','image','gif',0,'ryswaxgaqsfowe5f73i0dfptlspape2'),(1551,'I057.gif','20040818090854!I057.gif',1273,32,32,8,'Reverted to earlier revision',30225,'Rfc1394','20040818090720','0','BITMAP','image','gif',0,'ryswaxgaqsfowe5f73i0dfptlspape2'),(1552,'I065.gif','20040818090942!I065.gif',1289,0,0,0,'32x32 Icon for Interstate 65 Sign, Dynamically Created',30225,'Rfc1394','20040818090034','0','BITMAP','image','gif',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(1553,'I065.gif','20040818091109!I065.gif',1289,32,32,8,'32x32 Icon for Interstate 65 Sign, Dynamically Created',30225,'Rfc1394','20040818090948','0','BITMAP','image','gif',0,'orlmbecyf005qw1cliyx24licpuw7op'),(1554,'Theresa-Knott-Sig.gif','20040818135653!Theresa_Knott_Sig.gif',9014,67,28,8,'Me getting silly or creative ( take your pick) ~~~',8257,'Theresa knott','20040818012414','0','BITMAP','image','gif',0,'hn9q4jfh7o31j1bj079f4859fn6ns7q'),(1555,'Centcom20040818.jpg','20040818175528!Centcom20040818.jpg',522207,2032,1524,8,'\"Centcom\", [[User:Grunt]]\'s computer. Taken on [[August 18]], [[2004]]. {{pd}}',73738,'Grunt','20040818173325','a:35:{s:4:\"Make\";s:21:\"EASTMAN KODAK COMPANY\";s:5:\"Model\";s:32:\"KODAK CX7330 ZOOM DIGITAL CAMERA\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"230/1\";s:11:\"YResolution\";s:5:\"230/1\";s:14:\"ResolutionUnit\";i:2;s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:4:\"1/60\";s:7:\"FNumber\";s:5:\"28/10\";s:15:\"ExposureProgram\";i:2;s:11:\"ExifVersion\";s:4:\"0221\";s:16:\"DateTimeOriginal\";s:19:\"2004:08:18 16:42:17\";s:17:\"DateTimeDigitized\";s:19:\"2004:08:18 16:42:17\";s:17:\"ShutterSpeedValue\";s:5:\"60/10\";s:13:\"ApertureValue\";s:3:\"3/1\";s:17:\"ExposureBiasValue\";s:6:\"0/1000\";s:16:\"MaxApertureValue\";s:5:\"29/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:25;s:11:\"FocalLength\";s:5:\"56/10\";s:10:\"ColorSpace\";i:1;s:13:\"ExposureIndex\";s:5:\"140/1\";s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:5:\"0/100\";s:21:\"FocalLengthIn35mmFilm\";i:37;s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:20:\"SubjectDistanceRange\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'l38swpuk74i2v0j3hiqprfg0x99xhjb'),(1556,'Sledgehammer.jpg','20040818201226!Sledgehammer.jpg',73632,435,1164,8,'This is a picture of a [[sledgehammer]] taken by myself on [[August 8]], [[2004]]. {{pd}}',56299,'Slowking Man','20040818200809','0','BITMAP','image','jpeg',0,'hyxirmja2cpcvidl6tlqiwgv520cila'),(1557,'Arcade-sega-shinobi1.png','20040818213910!Arcade-sega-shinobi1.png',11742,359,287,8,'Screenshot Shinobi by Sega, arcade version, screenshot made myself via emulator {{screenshot}}',72631,'Tjansen','20040818212602','0','BITMAP','image','png',0,'p8tghkyoz1dy8fturxf8x4sdj7pee5q'),(1558,'Theresa-Knott-Sig.gif','20040818214855!Theresa_Knott_Sig.gif',4944,91,22,4,'Anagram transform',8257,'Theresa knott','20040818135744','0','BITMAP','image','gif',0,'eyztwnszfo4g4h65er081uh8noezu87'),(1559,'Vringrah66.jpg','20040818221520!Vringrah66.jpg',42854,535,284,8,'[[Vortex ring]] diagram - 3d modeling and rendering done by myself',55962,'Xmnemonic','20040816203845','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:8:\"DateTime\";s:19:\"2004:08:16 16:37:51\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'9kjdqb03fx9pwmoxsukjhui9lwq3oz3'),(1560,'JHancockAug2004.jpg','20040819013345!JHancockAug2004.jpg',13634,320,213,8,'32',62234,'Jesster79','20040819013155','0','BITMAP','image','jpeg',0,'1pe075veznqc949a4k65k54rejy7hog'),(1561,'HP-Blavatsky.jpg','20040819095027!HP_Blavatsky.jpg',32998,140,171,8,'Madame Helena Petrovna Blavatsky',94977,'Stjack','20040819094704','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:08:19 01:38:49\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'mgy2gu576o2pzfifrqevjdnd5aj2w0s'),(1562,'PeriodT.gif','20040819135017!PeriodT.gif',3584,515,327,8,'',94972,'Alberto Orlandini','20040819134437','0','BITMAP','image','gif',0,'qbhuckjxky0m427llddlwxwt0h1s9no'),(1563,'PeriodT.gif','20040819135805!PeriodT.gif',3470,485,317,8,'',94972,'Alberto Orlandini','20040819135026','0','BITMAP','image','gif',0,'h8g1mawt5308osg0lm9k5a5t7kol88u'),(1564,'Ketamine.png','20040819141038!Ketamine.png',3114,323,258,8,'Chemical structure of ketamine',46555,'Jfdwolff','20040316213803','0','BITMAP','image','png',0,'pegceo3l5hou9f3yvorrder8krbe8hk'),(1565,'Temple-of-Saint-Sava---liturgy.jpg','20040819161031!Temple_of_Saint_Sava_-_liturgy.jpg',6064,130,90,8,'Liturgy in the Temple of Saint Sava {{fairuse}}',11304,'Nikola Smolenski','20040817092152','0','BITMAP','image','jpeg',0,'0owsw9n69nasiw8347vrj0autb11ert'),(1566,'Gear-at-Summit-of-Chilkoot-Pass.jpg','20040819161325!Gear_at_Summit_of_Chilkoot_Pass.jpg',959909,1000,1500,8,'Artifact at summit of Chilkoot Trail; Uploader is photographer, released under {{GFDL}}',28502,'Klanda','20040819160746','a:16:{s:4:\"Make\";s:7:\"Noritsu\";s:5:\"Model\";s:34:\"SI-1080 Film Scanner Model DLS1640\";s:11:\"XResolution\";s:17:\"536870912/2097152\";s:11:\"YResolution\";s:17:\"536870912/2097152\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:18:\"Digital Lab System\";s:8:\"DateTime\";s:19:\"2001:07:27 13:45:12\";s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0200\";s:16:\"DateTimeOriginal\";s:19:\"2001:07:27 13:45:12\";s:17:\"DateTimeDigitized\";s:19:\"2001:07:27 13:45:12\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:16:\"568066048/262144\";s:21:\"FocalPlaneYResolution\";s:16:\"568066048/262144\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'p7o1lod5y8birzhvfibpld83i03foqv'),(1567,'Temple-of-Saint-Sava%27s-bells.jpg','20040819162823!Temple_of_Saint_Sava%27s_bells.jpg',803024,1957,1231,8,'Better quality image',11304,'Nikola Smolenski','20040819161557','',NULL,'unknown','unknown',0,''),(1568,'Temple-of-Saint-Sava%27s-bells.jpg','20040819165029!Temple_of_Saint_Sava%27s_bells.jpg',803024,1957,1231,8,'Better quality image',11304,'Nikola Smolenski','20040819162834','',NULL,'unknown','unknown',0,''),(1569,'Emperor-Maximilian-I.png','20040819165445!Emperor_Maximilian_I.png',344533,283,449,8,'Portrait of Emperor Maximilian I',28951,'Rübezahl','20040307215310','0','BITMAP','image','png',0,'brodab9if7a0woe5u1tiq9dxnrqyynu'),(1570,'Elephant.png','20040819194504!Elephant.png',27537,928,702,4,'public domain selfmade',95119,'TARZAN','20040819194327','0','BITMAP','image','png',0,'btgs5uzigredo7l3s4ymm2br5l73ivh'),(1571,'Elephant.png','20040819194504!Elephant.png',27537,928,702,4,'public domain selfmade',95119,'TARZAN','20040819194507','0','BITMAP','image','png',0,'btgs5uzigredo7l3s4ymm2br5l73ivh'),(1572,'Hercules-constellation-map-visualization.PNG','20040819214203!Hercules_constellation_map_visualization.PNG',30976,426,473,8,'The stars of the constellation Hercules reconnected so as to show Hercules in a more graphic way.  Based on the book \'\'The Stars &mdash; A New Way to See Them\'\' by H. A. Rey.',9565,'AugPi','20040817064038','0','BITMAP','image','png',0,'7rr82orsimjinfpfp7b0chclsyl79nc'),(1573,'Hercules-constellation-map-visualization.PNG','20040819214325!Hercules_constellation_map_visualization.PNG',31738,426,473,8,'Update: more stars labeled.',9565,'AugPi','20040819214223','0','BITMAP','image','png',0,'gkff0ea93p1h0078ulab8v7xnnaic37'),(1574,'Hercules-constellation-map-visualization.PNG','20040820044435!Hercules_constellation_map_visualization.PNG',30976,426,473,8,'Reverted to earlier revision',9565,'AugPi','20040819214328','0','BITMAP','image','png',0,'7rr82orsimjinfpfp7b0chclsyl79nc'),(1575,'UScoinage.jpg','20040820060159!UScoinage.jpg',94479,532,366,8,'Photo of current USA Coins. Public domain   {{PD}}',5904,'Hoshie','20040809234917','a:27:{s:4:\"Make\";s:21:\"EASTMAN KODAK COMPANY\";s:5:\"Model\";s:32:\"KODAK DC3400 ZOOM DIGITAL CAMERA\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:13:\"4718592/65536\";s:11:\"YResolution\";s:13:\"4718592/65536\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"QuickTime 6.5.1\";s:8:\"DateTime\";s:19:\"2004:08:09 19:35:59\";s:16:\"YCbCrPositioning\";i:1;s:9:\"Copyright\";s:32:\"KODAK DC3400 ZOOM DIGITAL CAMERA\";s:12:\"ExposureTime\";s:4:\"1/30\";s:7:\"FNumber\";s:7:\"300/100\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2000:04:14 14:47:16\";s:17:\"DateTimeDigitized\";s:19:\"2000:04:14 14:47:16\";s:17:\"ShutterSpeedValue\";s:5:\"50/10\";s:13:\"ApertureValue\";s:5:\"31/10\";s:17:\"ExposureBiasValue\";s:5:\"0/100\";s:16:\"MaxApertureValue\";s:5:\"31/10\";s:12:\"MeteringMode\";i:1;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:1;s:11:\"FocalLength\";s:5:\"63/10\";s:10:\"ColorSpace\";i:1;s:13:\"ExposureIndex\";s:5:\"100/1\";s:13:\"SensingMethod\";i:2;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'eevt3dc5xg6nk56z29d5qhra6l22558'),(1576,'Olivares.jpg','20040820085348!Olivares.jpg',34141,617,800,8,'Count-Duke Olivares. Public domain by age. {{PD}}',26071,'Adam Faanes','20040819105357','0','BITMAP','image','jpeg',0,'2jgmgcsn2lsag9tiqbtorf77kglooz4'),(1577,'Structure-of-scientific-revolutions-3rd-ed-pb.jpg','20040820102306!Structure-of-scientific-revolutions-3rd-ed-pb.jpg',23027,304,475,8,'cover of The Structure of Scientific Revolutions by Thomas S. Kuhn, 3rd Ed., paperback {{fairuse}}',36389,'David Gerard','20040820101907','0','BITMAP','image','jpeg',0,'g29pxl407cqjfxw2ynuj1js4ccedqjf'),(1578,'Theresa-Knott-Sig.gif','20040820194840!Theresa_Knott_Sig.gif',3858,91,22,4,'slightly less irritating version',8257,'Theresa knott','20040818214913','0','BITMAP','image','gif',0,'d27ss6laaab74b9phd7u2kq1m73ggtn'),(1579,'Theresa-Knott-Sig.gif','20040820201247!Theresa_Knott_Sig.gif',4944,91,22,4,'Reverted to earlier revision',95472,'Metrische Zeit','20040820194841','0','BITMAP','image','gif',0,'eyztwnszfo4g4h65er081uh8noezu87'),(1580,'Drapers-COA.jpg','20040821002357!Drapers_COA.jpg',14349,250,234,8,'Smaller version of previous, but looks suspiously like [http://www.thedrapers.co.uk/crest1.jpg]',30415,'Henrygb','20040729225339','0','BITMAP','image','jpeg',0,'arjgqm7a936pbosrmr7co96r78a5i13'),(1581,'Coat-of-Arms-Reagan-Shield-1.png','20040821002255!Coat_of_Arms_Reagan_Shield_1.png',23941,112,144,8,'The arms redrawn {{pd}}',54836,'Garryq','20040727103400','0','BITMAP','image','png',0,'4zqomcun1xx3q2e3ztxfuw575tmw6h3'),(1582,'Queen-Mother-funerary-lozenge.png','20040821002458!Queen_Mother_funerary_lozenge.png',49629,420,420,8,'Scottish Shield only on funerary lozenge',54836,'Garryq','20040603083427','0','BITMAP','image','png',0,'ho0sdegkzdah4m7v24lckwo47t87uqx'),(1583,'Canada1904.jpg','20040821001913!Canada1904.jpg',48527,298,393,8,'Contemporary postcard of semi-official arms of Canada',54836,'Garryq','20040513142459','0','BITMAP','image','jpeg',0,'qwdpz6tf9zb3ioywt3ns99x8jo24lmy'),(1584,'Canada1904.jpg','20040821004323!Canada1904.jpg',72125,797,498,8,'',54836,'Garryq','20040821002927','0','BITMAP','image','jpeg',0,'hn00xukl8vjd3yyg0dwxi5qsxier13m'),(1585,'Lesplanade-Laurier-Corner.jpg','20040821004855!Lesplanade_Laurier_Corner.jpg',106530,638,837,8,'L\'esplanade Laurier Corner, Ottawa, ON, CDN, {{GFDL}} August 2004',16455,'Peregrine981','20040821003316','a:33:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:19:\"Canon PowerShot S30\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"150/1\";s:11:\"YResolution\";s:5:\"150/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:28:\"Adobe Photoshop Elements 2.0\";s:8:\"DateTime\";s:19:\"2004:08:20 20:23:55\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:6:\"1/1000\";s:7:\"FNumber\";s:5:\"45/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:08:20 14:46:26\";s:17:\"DateTimeDigitized\";s:19:\"2004:08:20 14:46:26\";s:22:\"CompressedBitsPerPixel\";s:3:\"3/1\";s:17:\"ShutterSpeedValue\";s:6:\"319/32\";s:13:\"ApertureValue\";s:6:\"139/32\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:12:\"194698/65536\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:6:\"227/32\";s:10:\"ColorSpace\";i:65535;s:21:\"FocalPlaneXResolution\";s:11:\"1600000/278\";s:21:\"FocalPlaneYResolution\";s:11:\"1200000/209\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:9:\"2048/2048\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'raai4yn0wd6ldfqw7r2pxl8ctrky0ln'),(1586,'La-D%E9fense3.processed.jpg','20040821074718!La_D%E9fense3.processed.jpg',143084,662,473,8,'Test upload',7095,'Arpingstone','20040821074559','',NULL,'unknown','unknown',0,''),(1587,'Balkans-political-map-small.png','20040821121555!Balkans-political-map-small.png',38951,304,257,8,'a slightly different color for the two states marked \"sometimes\"',20318,'Shallot','20040507113347','0','BITMAP','image','png',0,'56o6lf3j6alryrovecd099cu5xg81z2'),(1588,'UCC---NUI,-Cork.png','20040821162347!UCC_-_NUI,_Cork.png',23219,151,181,8,'University College Cork - National University of Ireland, Cork',49447,'Djegan','20040725180420','0','BITMAP','image','png',0,'s009ta9wllg537ughlsl0y58ujhi5om'),(1589,'Squirell.500mm.5yards.jpg','20040821201046!Squirell.500mm.5yards.jpg',17744,274,130,8,'Taken spring of 2004 by [User:Clarknova]',65216,'Clarknova','20040821201010','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:08:21 14:58:07\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'psvn0k1jtk86mtzyjo63eopxkwnaj7d'),(1590,'Squirell.500mm.5yards.jpg','20040821201046!Squirell.500mm.5yards.jpg',17744,274,130,8,'Taken spring of 2004 by [[User:Clarknova]]',65216,'Clarknova','20040821201217','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:08:21 14:58:07\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'psvn0k1jtk86mtzyjo63eopxkwnaj7d'),(1591,'Squirell.500mm.5yards.jpg','20040821202110!Squirell.500mm.5yards.jpg',17744,274,130,8,'Taken spring of 2004 by [[User:Clarknova]]',65216,'Clarknova','20040821202050','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:08:21 14:58:07\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'psvn0k1jtk86mtzyjo63eopxkwnaj7d'),(1592,'Squirell.500mm.5yards.jpg','20040821203310!Squirell.500mm.5yards.jpg',17744,274,130,8,'Taken spring of 2004 by [[User:Clarknova]]',65216,'Clarknova','20040821203007','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:08:21 14:58:07\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'psvn0k1jtk86mtzyjo63eopxkwnaj7d'),(1593,'Teresa-Avila-Vision-of-the-Dove-Rubens.jpg','20040821223600!Teresa_Avila_Vision_of_the_Dove_Rubens.jpg',45882,490,780,8,'\'\'Teresa Avila\'s Vision of the Dove\'\' by [[Peter Paul Rubens]]',26071,'Adam Faanes','20040821223445','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0200\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'69tslo6jasdvyhznkcm6akwq36wsblr'),(1594,'Kosice-fontana.jpg','20040821230050!Kosice_fontana.jpg',13312,250,188,8,'Fountain on Main Street in Kosice, Slovakia',44414,'Brona','20040215023619','0','BITMAP','image','jpeg',0,'d05gmdcxcxl2xnj2et409eem0yulv0d'),(1595,'Taiwan-aborigine-en.jpg','20040822014504!Taiwan_aborigine_en.jpg',23757,356,498,8,'',74867,'Sichinaren','20040616142353','0','BITMAP','image','jpeg',0,'a0pe53xwps7cfijk9beml124vng9986'),(1596,'Doubleswitch.jpg','20040822112952!Doubleswitch.jpg',34423,610,185,8,'Double railway switch',71107,'Sonett72','20040822111402','0','BITMAP','image','jpeg',0,'oo1tv9uu1rwnpckqz3exc8g8djg5ojm'),(1597,'Doubleswitch.jpg','20040822113133!Doubleswitch.jpg',34965,610,185,8,'',71107,'Sonett72','20040822112957','0','BITMAP','image','jpeg',0,'982kq96tf3tmlj3nhabkvwplnbw5anx'),(1598,'IDA-Ireland.png','20040822122232!IDA_Ireland.png',3317,93,46,8,'IDA Ireland - fair use',49447,'Djegan','20040822121501','0','BITMAP','image','png',0,'r97yxzy47koabg0wfm1bxncolu4r429'),(1599,'Mescaline.png','20040822201045!Mescaline.png',1758,256,143,8,'The structure of mescaline',71147,'Daevatgl','20040721194931','0','BITMAP','image','png',0,'dr3br6s3balyafkxiv6yjbzwfv6mc4w'),(1600,'Mescaline.png','20040822201223!Mescaline.png',4697,300,245,8,'Chemical structure of Mescaline {{PD}}',96066,'Olaf Fritz','20040822201053','0','BITMAP','image','png',0,'8nnpm0jr236tu2ykm0rlmq8t08tigm3'),(1601,'Selected-languages-and-accents-of-the-british-isles-rjl.jpg','20040822213212!Selected_languages_and_accents_of_the_british_isles_rjl.jpg',255542,729,723,8,'Selected Languages And Accents Of The British Isles',66342,'Ricjl','20040822163928','0','BITMAP','image','jpeg',0,'04u1nvvaa9mnm6zgez819y51ymvlw6l'),(1602,'Roche-limit-(two-spheres).PNG','20040822230048!Roche_limit_(two_spheres).PNG',10833,475,168,8,'Drawn by Theresa Knott.  {{GFDL}}',8257,'Theresa knott','20040820225700','0','BITMAP','image','png',0,'flrazn1se1ga3l5x8gmqy2g2ztpquvf'),(1603,'Westont.PNG','20040823015655!Westont.PNG',9782,378,379,8,'same map of Ontario already posted to other articles, recoloured to represent a specific region',24902,'Bearcat','20040823003143','0','BITMAP','image','png',0,'f7nuypscczxlg6n4yyguvn5fo1t51v2'),(1604,'The-Scream.jpg','20040823034728!The_Scream.jpg',139811,750,970,8,'larger version',3628,'Hephaestos','20040701021840','0','BITMAP','image','jpeg',0,'871qa5h1m5q3tjfb69gfre6h71e5jhx'),(1605,'ChronoTriggerInside.PNG','20040823082644!ChronoTriggerInside.PNG',105156,381,334,8,'Chrono Trigger, SNES version screenshot, taken by me (FriedMilk) </p> {{msg:screenshot}}',47523,'FriedMilk','20040430061231','0','BITMAP','image','png',0,'ta9d6io8bwd23k05gkiayafmzx3djol'),(1606,'Alexa-traffic-ranking-for-wikipedia.png','20040823233859!Alexa_traffic_ranking_for_wikipedia.png',3658,480,360,8,'Alexa traffic ranking for wikipedia.org',88976,'Kbh3rd','20040814030942','0','BITMAP','image','png',0,'n7jzmy19m4u3yp18rvune4x0g2407lz'),(1607,'The-Scream.jpg','20040824135303!The_Scream.jpg',40299,400,513,8,'From http://www.munch.museum.no/en/artworks.htm',46083,'Cantus','20040823034733','0','BITMAP','image','jpeg',0,'hmitmeknv0nh2tz8a9jg7tp7ge4tinr'),(1608,'Persian-food.jpg','20040824160144!Persian_food.jpg',20439,500,375,8,'A Persian cuisine',72843,'Hoomanb','20040819140014','a:32:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:19:\"Canon PowerShot A40\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:08:11 19:01:49\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:4:\"1/60\";s:7:\"FNumber\";s:5:\"48/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:08:11 19:01:49\";s:17:\"DateTimeDigitized\";s:19:\"2004:08:11 19:01:49\";s:22:\"CompressedBitsPerPixel\";s:3:\"5/1\";s:17:\"ShutterSpeedValue\";s:6:\"189/32\";s:13:\"ApertureValue\";s:12:\"296620/65536\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:12:\"194698/65536\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:25;s:11:\"FocalLength\";s:6:\"518/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"1600000/206\";s:21:\"FocalPlaneYResolution\";s:11:\"1200000/155\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:9:\"1600/1600\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'19gn6hnpgtlq9qdfzid89x6rxkga8ka'),(1609,'Uk2pnd2002-S.jpg','20040824184256!Uk2pnd2002-S.jpg',23504,512,384,8,'UK £2 coin, 2002 - Scottish variation - own scan',7891,'Arwel Parry','20031208023228','0','BITMAP','image','jpeg',0,'i75vwhnu7vcmcv6240rdfbz3rd971up'),(1610,'Neont.PNG','20040824202345!Neont.PNG',9829,378,379,8,'same map of Ontario already posted to other articles, recoloured to represent a specific region',24902,'Bearcat','20040823002317','0','BITMAP','image','png',0,'5zhu5y5ijmbyq9hzwnazscr9jd5l7r5'),(1611,'Queen-Mother-funerary-lozenge.png','20040824221654!Queen_Mother_funerary_lozenge.png',23950,797,498,8,'',54836,'Garryq','20040821002919','0','BITMAP','image','png',0,'7r3ty0willjm8wem5im68o54wtjrxu4'),(1612,'Drapers-COA.jpg','20040824221830!Drapers_COA.jpg',72125,797,498,8,'',54836,'Garryq','20040821002836','0','BITMAP','image','jpeg',0,'hn00xukl8vjd3yyg0dwxi5qsxier13m'),(1613,'Roche-limit-(two-spheres).PNG','20040825030531!Roche_limit_(two_spheres).PNG',11243,480,165,8,'Sightly ammended the arrow now reacges to the middle of m_1',8257,'Theresa knott','20040822230052','0','BITMAP','image','png',0,'5x7r8n88rnh4j6y4gpauwg81zetfg9x'),(1614,'Roche-limit-(two-spheres).PNG','20040825033601!Roche_limit_(two_spheres).PNG',8086,480,165,8,'update for new formula',83987,'Wuzzeb','20040825030540','0','BITMAP','image','png',0,'m6kxwomtbdofswmevlnom1ofqn29gel'),(1615,'MapVietnamBenTre.png','20040825063423!MapVietnamBenTre.png',24977,290,210,8,'Map of Vietnam\'s Ben Tre province',25556,'Vardion','20040825061414','0','BITMAP','image','png',0,'l95oamgh9ypvhj14c078n0rqfcln6pz'),(1616,'Victoria-harbour.jpg','20040825065230!Victoria_harbour.jpg',23850,350,233,8,'Victoria, British Columbia',93949,'Dmgerman','20040816064222','0','BITMAP','image','jpeg',0,'38wesdsbehqaxmzhbgow75m1vs0abh3'),(1617,'LTColumbusFountain.jpg','20040825074514!LTColumbusFountain.jpg',65718,670,465,8,'photo by Einar Einarsson Kvaran {{GFDL}} [[Lorado Taft]]',86452,'Carptrash','20040825073333','0','BITMAP','image','jpeg',0,'5mey6egg76sanubxmmnc88b2fcozz1x'),(1618,'US3386883---fusor.png','20040825084931!US3386883_-_fusor.png',114817,430,651,8,'US3386883 - fusor',13833,'Reddi','20040825084247','0','BITMAP','image','png',0,'8bhxpww0m63pd942mqrhszkf5a94cbu'),(1619,'Sledgehammer.jpg','20040825110504!Sledgehammer.jpg',14731,131,350,8,'Smaller file',56299,'Slowking Man','20040818201232','0','BITMAP','image','jpeg',0,'qe6nr32bb7ansmv1vcxdb1ofphg9ac6'),(1620,'EU-GNI-pc-PPP.png','20040826035555!EU-GNI-pc-PPP.png',21316,683,467,8,'remove \'millions\' from graphic',46083,'Cantus','20040616183046','0','BITMAP','image','png',0,'m3atw9hgjz1u91oav7jrwr7yydyj66b'),(1621,'Aa-arayashiki.gif','20040826053028!Aa-arayashiki.gif',5582,80,80,8,'Scanned and edited image for size',97254,'Wavheawk','20040826052944','0','BITMAP','image','gif',0,'931vklrm2g069wjn5eo3e0vv81ods1u'),(1622,'Live-damage-dvd.jpg','20040826053501!Live_damage_dvd.jpg',11036,200,282,8,'Dark Tranquillity - Live Damage (DVD) cover art',87763,'Grappo6x6','20040826053433','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2003:04:30 17:05:55\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'toqayvbwnjdidm69f22eeu9rexp0wpb'),(1623,'Map-South-Holland-with-numbered-municipalities.png','20040826073611!Map_South_Holland_with_numbered_municipalities.png',18692,570,476,8,'[[nl:Afbeelding:GemeentenZuid-HollandNrs.png]], enlarged',4388,'Patrick','20040728091749','0','BITMAP','image','png',0,'0z9lsmz0ro70jcsn0i3m73kav0r4wl0'),(1624,'Gangneungs.png','20040826164251!Gangneungs.png',2716,96,96,8,'Seems to have gone missing from the servers; uploading replacement',22105,'Jamesday','20040216024619','0','BITMAP','image','png',0,'rlwco5pphekicc9vsm3fshdz5gz92l9'),(1625,'Okcheon.jpg','20040826191218!Okcheon.jpg',8884,150,170,8,'',30149,'Egon','20031210212021','0','BITMAP','image','jpeg',0,'5l035qf4jsblzwz45bwew9josdc5goa'),(1626,'Sokcho.jpg','20040826193540!Sokcho.jpg',6008,177,112,8,'',30149,'Egon','20031210214117','0','BITMAP','image','gif',0,'quc7uwvxdd367iaet9gj533legg3xds'),(1627,'Yeongwol.jpg','20040826200203!Yeongwol.jpg',12422,212,132,8,'',30149,'Egon','20031210230016','0','BITMAP','image','jpeg',0,'0q5zcdz8qks9yeqs4rf97fgrr2htoqc'),(1628,'Jackfruit-chips.jpg','20040826205325!Jackfruit_chips.jpg',33017,266,403,8,'Fixed the photo up a tad (hope it is an improvement)',16734,'Marshman','20031119185546','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2003:11:19 08:55:04\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'tm175fp70evssggmpvwv0tm9alxtm3r'),(1629,'Jackfruit-chips.jpg','20040826205430!Jackfruit_chips.jpg',18630,333,519,8,'Reverted to earlier revision',41941,'Nickdc','20040826205326','0','BITMAP','image','jpeg',0,'9236vsaxs8jcxgdgf8gqkqvozag3jkc'),(1630,'Ziemianski.jpg','20040826213255!Ziemianski.jpg',16337,267,412,8,'Andrzej Ziemia&#324;ski. Courtesy of Fabryka Slow (http://www.fabryka.pl/).',43152,'Ausir','20040430065042','0','BITMAP','image','jpeg',0,'2r4kej8vcorxfjb6zveqtk71iy9vehf'),(1631,'Map-of-New-Brunswick-highlighting-Albert-County.png','20040827170825!Map_of_New_Brunswick_highlighting_Albert_County.png',697017,2083,2032,8,'Public domain map of New Brunswick created by [[User:Plasma east]] with data courtesy of [http://geogratis.cgdi.gc.ca Geogratis], modified to show counties.  Released under GFDL.{{GFDL}}',60804,'Plasma east','20040827163752','0','BITMAP','image','png',0,'bgjqpo96tnrgh3o4pqkdnfw9nlfses9'),(1632,'Taylorseriesforsine.png','20040827183234!Taylorseriesforsine.png',6333,1069,358,8,'transparency, optimize',47960,'Guanaco','20040724005610','0','BITMAP','image','png',0,'im2120if6tib60mnchp8g3tjs9bbqf2'),(1633,'Galveston---1900-homes.jpg','20040827183636!Galveston_-_1900_homes.jpg',84300,700,459,8,'[[Great Galveston Hurricane]] - PD courtesy NOAA',35616,'Cyrius','20040802051643','0','BITMAP','image','jpeg',0,'q3rw4z9r4ifer7sc85kxf4jfe1hgqff'),(1634,'Rosiglitazone.png','20040827191606!Rosiglitazone.png',3143,439,127,8,'Rosiglitazone (improved)',46555,'Jfdwolff','20040426203429','0','BITMAP','image','png',0,'rce36fd4c2ipauciq54n15nypphiiol'),(1635,'Troglitazone.png','20040827191709!Troglitazone.png',3688,472,154,8,'Troglitazone',46555,'Jfdwolff','20040426203230','0','BITMAP','image','png',0,'pqd3gy0wb7it8fg4l8c3930hg9oyttc'),(1636,'Usinprogress.PNG','20040827211246!Usinprogress.PNG',36364,280,183,8,'update',35314,'Seth Ilys','20040717224236','0','BITMAP','image','png',0,'kq6w99vn72fznnx8vkcw58l6qoia8uq'),(1637,'Usinprogress.PNG','20040827212348!Usinprogress.PNG',35762,280,183,8,'update',35314,'Seth Ilys','20040827211258','0','BITMAP','image','png',0,'2id9x1dkq34dt3dt30ijuic3l19awll'),(1638,'Simvastatin.png','20040827213041!Simvastatin.png',3167,227,188,8,'[[Simvastatin]], a [[statin]] drug drawn by [[User:Jfdwolff]] {{msg:GFDL}}',46555,'Jfdwolff','20040504171150','0','BITMAP','image','png',0,'4ir7b3b41et3a1s8zre7zzraxoie5bw'),(1639,'Somethingdifferent.jpg','20040828000218!Somethingdifferent.jpg',58798,333,475,8,'DVD cover to Monty Python\'s [[And Now For Something Completely Different]]. {{fair use}}',94202,'Tom','20040828000115','0','BITMAP','image','jpeg',0,'0it3ojwb7fu3b8gpsf8g25hc0o6b5u3'),(1640,'Palmdale-region-topo.jpg','20040828033904!Palmdale_region_topo.jpg',39559,464,457,8,'Shaded-relief map showing the relationship of Palmdale, CA, with the surrounding geography.',88976,'Kbh3rd','20040828015458','0','BITMAP','image','jpeg',0,'oqqfxshxrgqyh0yqbzgjw7yjib0slt0'),(1641,'Palmdale-region-topo.jpg','20040828040000!Palmdale_region_topo.jpg',41221,464,457,8,'Shaded-relief map showing the relationship of Palmdale, CA, with the surrounding geography.',88976,'Kbh3rd','20040828033908','0','BITMAP','image','jpeg',0,'fddbftcx74bh7yco18vlywlqpgijamb'),(1642,'EU-GNI-pc-PPP.png','20040828050514!EU-GNI-pc-PPP.png',26911,683,467,8,'update data 2003',46083,'Cantus','20040826035603','0','BITMAP','image','png',0,'rir5vidrx76zjeb732f5esb19qg7ozx'),(1643,'AlanRHawley-AugustPost-1910Bennett.jpg','20040828105947!AlanRHawley-AugustPost-1910Bennett.jpg',219014,867,657,8,'Alan R Hawley and August Post just before their departure at the fifth Gordon Bennett Balloon Race',50198,'Costyn','20040828103818','0','BITMAP','image','jpeg',0,'r4onzw8fmkacjsqaur0ozkvbesk28ue'),(1644,'AlanRHawley.jpg','20040828123124!AlanRHawley.jpg',31979,336,458,8,'Alan Ramsay Hawley',50198,'Costyn','20040828110226','0','BITMAP','image','jpeg',0,'6ofq64v3vfnhemhct0fean1r97o48mh'),(1645,'Nat-turner.jpg','20040828152947!Nat_turner.jpg',51720,392,370,8,'Nat Turner woodcarving',57108,'Quadell','20040416151405','0','BITMAP','image','jpeg',0,'4ws9vzepgl4e1djhr2i9xpwzfy573n4'),(1646,'Nat-turner.jpg','20040828153009!Nat_turner.jpg',73956,466,500,8,'The capture of [[Nat Turner]] (1800-1831) by Benjamin Phipps on 30 October 1831: colored engraving.',93903,'Potatosalad','20040828152950','0','BITMAP','image','jpeg',0,'hhe9m103exhad7h9td0j5s6m1m8rgtb'),(1647,'Nat-turner.jpg','20040828153021!Nat_turner.jpg',51720,392,370,8,'Reverted to earlier revision',93903,'Potatosalad','20040828153009','0','BITMAP','image','jpeg',0,'4ws9vzepgl4e1djhr2i9xpwzfy573n4'),(1648,'Nat-turner.jpg','20040828155700!Nat_turner.jpg',73956,466,500,8,'Reverted to earlier revision',93903,'Potatosalad','20040828153021','0','BITMAP','image','jpeg',0,'hhe9m103exhad7h9td0j5s6m1m8rgtb'),(1649,'Meletius-Smotrisky-Cyrillic-Alphabet.PNG','20040828162236!Meletius_Smotrisky_Cyrillic_Alphabet.PNG',8552,430,700,1,'Scanned from &#1043;&#1088;&#1072;&#1084;&#1084;&#1072;&#1090;&#1080;&#1082;&#1080; &#1057;&#1083;&#1086;&#1074;&#1077;&#1085;&#1089;&#1082;&#1080;&#1103; &#1087;&#1088;&#1072;&#1074;&#1080;&#1083;&#1085;&#1086;&#1077; &#1089;&#1080;&#1085;&#1090;&#1072;&',49725,'A. Shetsen','20040711170722','0','BITMAP','image','png',0,'fl6srrjo5u7uyx3kkbdjrlyteyqmypa'),(1650,'Dublin-Institute-of-Technology.png','20040828163228!Dublin_Institute_of_Technology.png',15427,151,151,8,'reduced image size',49447,'Djegan','20040702173725','0','BITMAP','image','png',0,'t6heqefp0w852ntouhee38tuvzzlphq'),(1651,'Earth-axis-tilt-and-precession.jpg','20040828210147!Earth_axis_tilt_and_precession.jpg',74083,721,500,8,'Cartoon showing effect of axial precession and changing inclination through time.  I made this figure in PowerPoint on August 18, 2004',87125,'GregBenson','20040819002721','0','BITMAP','image','jpeg',0,'1hz36smh6rxs4dgq1m38njkh8ww1qpv'),(1652,'Earth-axis-tilt-and-precession.jpg','20040828210627!Earth_axis_tilt_and_precession.jpg',34214,500,300,8,'I have corrected the typos and removed the bold text across the bottom, which should be placed in a figure caption.',87125,'GregBenson','20040828210201','0','BITMAP','image','jpeg',0,'7gvx3shlop1mg0ruuu2d8wuopa8fn1i'),(1653,'Earth-axis-tilt-and-precession.jpg','20040828211054!Earth_axis_tilt_and_precession.jpg',34214,500,300,8,'Fixed typo (again!)',87125,'GregBenson','20040828210634','0','BITMAP','image','jpeg',0,'7gvx3shlop1mg0ruuu2d8wuopa8fn1i'),(1654,'Earth-axis-tilt-and-precession.jpg','20040828212356!Earth_axis_tilt_and_precession.jpg',34229,500,300,8,'Typo fix just won\'t take.  Not sure what\'s going on here.',87125,'GregBenson','20040828211111','0','BITMAP','image','jpeg',0,'h2jgu9r9h1ynr4nhcrhny7s1b38em0q'),(1655,'Earth-axis-tilt-and-precession.jpg','20040828212356!Earth_axis_tilt_and_precession.jpg',34229,500,300,8,'This is the third time I\'ve uploaded the corrected image.  I cannot imagine what is going on, but the image on Wikipedia refuses to be updated.',87125,'GregBenson','20040828212504','0','BITMAP','image','jpeg',0,'h2jgu9r9h1ynr4nhcrhny7s1b38em0q'),(1656,'Earth-axis-tilt-and-precession.jpg','20040828212936!Earth_axis_tilt_and_precession.jpg',34229,500,300,8,'This is the third time I\'ve uploaded the corrected image.  I cannot imagine what is going on, but the image on Wikipedia refuses to be updated.',87125,'GregBenson','20040828212551','0','BITMAP','image','jpeg',0,'h2jgu9r9h1ynr4nhcrhny7s1b38em0q'),(1657,'Bled-lake.jpg','20040829013710!Bled_lake.jpg',20830,388,270,8,'improved',3857,'Ericd','20031017120310','0','BITMAP','image','jpeg',0,'qlyo126zu9yufa4nuj6e8flcg764o3r'),(1658,'JapaneseLicensePlateDwg.png','20040829054045!JapaneseLicensePlateDwg.png',25703,640,322,8,'Japanese license plate illustration {{GFDL}}',70428,'Fg2','20040815110036','0','BITMAP','image','png',0,'gmx9cd4vu0wn1kfffedjvy7pipboo6e'),(1659,'HeJin.jpg','20040829112020!HeJin.jpg',14076,564,425,8,'He Jin in \"Romance of the Three Kingdoms\" TV series. Photo courtesy http://3kingdoms.net',82586,'Jie','20040829111927','0','BITMAP','image','jpeg',0,'cztd5f4qtft3zub6ovpmq9ixb92r08g'),(1660,'Wwi-central-casualties.png','20040829164614!Wwi-central-casualties.png',3025,256,190,8,'',4880,'Booyabazooka','20040829164206','0','BITMAP','image','png',0,'65tk6i69aufa746h3n52qh36ttlkjvu'),(1661,'Wwi-central-casualties.png','20040829164747!Wwi-central-casualties.png',3112,286,190,8,'padded right side to match Allied image',4880,'Booyabazooka','20040829164622','0','BITMAP','image','png',0,'hxqnp9k2cmm8vg5eedawz1kegfb1g6h'),(1662,'Wwi-central-casualties.png','20040829164953!Wwi-central-casualties.png',3115,286,190,8,'another minor screw-up... sorry...',4880,'Booyabazooka','20040829164751','0','BITMAP','image','png',0,'jgigckv9lgrlmadtfotxw9wcchqnyr8'),(1663,'Cairo.wav','20040829181047!Cairo.wav',19522,0,0,0,'recording of woman saying \"cairo\" {{GFDL}}',13661,'Nohat','20040829063223','','AUDIO','audio','wav',0,'4ueoxoal1wfk8fbh1csa38sxekhv9h6'),(1664,'Laplata.wav','20040829181806!Laplata.wav',21266,0,0,0,'recording of woman saying \"la plata\" {{GFDL}}',13661,'Nohat','20040829063558','','AUDIO','audio','wav',0,'8i7q0esini4b136vvz1ruzk6ly28yic'),(1665,'Britishfbi.wav','20040829195040!Britishfbi.wav',101272,0,0,0,'british fbi pronunciation {{GFDL}}',13661,'Nohat','20040829194309','','AUDIO','audio','wav',0,'77cl53p6r6ly100e3858fhyjcgrnhp1'),(1666,'Palmdale-CA-and-Antelope-Valley-and-Environs-Landsat7.jpg','20040829201849!Palmdale_CA_and_Antelope_Valley_and_Environs_Landsat7.jpg',62677,965,401,8,'Landsat-7 imagery draped over digital elevation model for Palmdale, CA, and environs',88976,'Kbh3rd','20040829083752','0','BITMAP','image','jpeg',0,'0opkpoyw1xele6itip9nw97m156angw'),(1667,'Valet2.wav','20040829210047!Valet2.wav',18523,0,0,0,'recording of a woman saying valet {{GFDL}}',51129,'NohatBot','20040829205631','','AUDIO','audio','wav',0,'nb0f7leq49ovelmc9l5h22wkl9yao3u'),(1668,'DwAlbertawildrose.jpg','20040829211346!DwAlbertawildrose.jpg',914440,1544,1024,8,'Alberta wild rose',36346,'Dwindrim','20040731233947','0','BITMAP','image','jpeg',0,'t1tww6zirx7ehl4r63iov737kp12kvy'),(1669,'Indict1.wav','20040829211744!Indict1.wav',18126,0,0,0,'recording of a woman saying indict {{GFDL}}',51129,'NohatBot','20040829211137','','AUDIO','audio','wav',0,'ddboodzd0xsoiiul7n5jqorc2ra2s9g'),(1670,'Iraq2.wav','20040829212610!Iraq2.wav',20122,0,0,0,'recording of a woman saying iraq {{GFDL}}',51129,'NohatBot','20040829211908','','AUDIO','audio','wav',0,'j5j6yos94ivsvmcr5lqlus3d070onug'),(1671,'Mexia.wav','20040829212847!Mexia.wav',20888,0,0,0,'recording of woman saying \"mexia\" {{GFDL}}',13661,'Nohat','20040829180914','','AUDIO','audio','wav',0,'eswebwej12nzdy30zn8hjtv8brom8wx'),(1672,'Nuclear2.wav','20040829213039!Nuclear2.wav',22660,0,0,0,'recording of a woman saying nuclear {{GFDL}}',51129,'NohatBot','20040829213020','','AUDIO','audio','wav',0,'s69nd3sn1duddunbot1fl6lrqcgunvr'),(1673,'DwArnicacordifolia.jpg','20040829213136!DwArnicacordifolia.jpg',355314,432,368,8,'Arnica cordifolia',36346,'Dwindrim','20040731234439','0','BITMAP','image','jpeg',0,'dzbue7dnb7s9l0nj8ux0ykadi7rayox'),(1674,'Senor2.wav','20040829213711!Senor2.wav',20704,0,0,0,'recording of a woman saying senor {{GFDL}}',51129,'NohatBot','20040829213408','','AUDIO','audio','wav',0,'q98jcivt9xi96eihwe0e436ef6oscot'),(1675,'DwButtercup1.jpg','20040829213731!DwButtercup1.jpg',235231,423,685,8,'Buttercup',36346,'Dwindrim','20040731235657','0','BITMAP','image','jpeg',0,'d1tx0jbz3zlegghqbwqmaliu54i2rdr'),(1676,'Temperature2.wav','20040829213801!Temperature2.wav',24166,0,0,0,'recording of a woman saying temperature {{GFDL}}',51129,'NohatBot','20040829213742','','AUDIO','audio','wav',0,'e3itzimn2ha3l7p1imhcup5x61atqrw'),(1677,'Valet2.wav','20040829213833!Valet2.wav',18523,0,0,0,'recording of a woman saying valet {{GFDL}}',51129,'NohatBot','20040829210049','','AUDIO','audio','wav',0,'nb0f7leq49ovelmc9l5h22wkl9yao3u'),(1678,'DwButtercup2.jpg','20040829214024!DwButtercup2.jpg',524545,775,690,8,'buttercup',36346,'Dwindrim','20040801000253','0','BITMAP','image','jpeg',0,'3rtkwzjkmy2eru6hldtbi35v1ki3gio'),(1679,'DwCinquefoil.jpg','20040829214304!DwCinquefoil.jpg',412807,720,572,8,'cinquefoil',36346,'Dwindrim','20040801000846','0','BITMAP','image','jpeg',0,'q5e87afne57iczjqfp96rx8qf7f4ouu'),(1680,'DwElephanthead1.jpg','20040829214544!DwElephanthead1.jpg',1542199,1461,1024,8,'Elephant head',36346,'Dwindrim','20040801001341','0','BITMAP','image','jpeg',0,'q8g0385z08qrvjjblnqiv7r3y4p67vf'),(1681,'DwElephanthead1.jpg','20040829214544!DwElephanthead1.jpg',284664,1461,1024,8,'Elephant head',36346,'Dwindrim','20040829214613','0','BITMAP','image','jpeg',0,'q8g0385z08qrvjjblnqiv7r3y4p67vf'),(1682,'DwElephanthead2.jpg','20040829214754!DwElephanthead2.jpg',353045,486,665,8,'elephant head (close)',36346,'Dwindrim','20040801001851','0','BITMAP','image','jpeg',0,'37t1gncj6nlvkr6kp92k7t9dac9rvqs'),(1683,'Senor1.wav','20040829215842!Senor1.wav',26537,0,0,0,'recording of a woman saying senor {{GFDL}}',51129,'NohatBot','20040829213357','','AUDIO','audio','wav',0,'4986h7m72ah3x6uj80kkvv3jplcohb4'),(1684,'Palmdale-CA-and-Antelope-Valley-and-Environs-Landsat7.jpg','20040829223313!Palmdale_CA_and_Antelope_Valley_and_Environs_Landsat7.jpg',62841,965,401,8,'Landsat-7 imagery draped over digital elevation model for Palmdale, California, and environs',88976,'Kbh3rd','20040829202005','0','BITMAP','image','jpeg',0,'7rvy4f57wr0b3q7per3zmhg0jlm04sp'),(1685,'DwMarshreedgrass.jpg','20040829223451!DwMarshreedgrass.jpg',649053,720,1086,8,'Marsh reedgrass',36346,'Dwindrim','20040801002854','0','BITMAP','image','jpeg',0,'2j7o569vr9cyoyrezoiq6guadnw82bl'),(1686,'Palmdale-CA-and-Antelope-Valley-and-Environs-Landsat7.jpg','20040829224404!Palmdale_CA_and_Antelope_Valley_and_Environs_Landsat7.jpg',61998,965,401,8,'palmdale etc',88976,'Kbh3rd','20040829223327','0','BITMAP','image','jpeg',0,'1q70i9tt99c93hrx1ymdg4wk38w1g9y'),(1687,'DwBrome.jpg','20040829230001!DwBrome.jpg',1483959,1024,1544,8,'Brome grass',36346,'Dwindrim','20040731234959','0','BITMAP','image','jpeg',0,'19qi8i6p2vedrc6d5a3a4uzd5iix3j5'),(1688,'DwBrome.jpg','20040829230001!DwBrome.jpg',344092,1024,1544,8,'Brome',36346,'Dwindrim','20040829230024','0','BITMAP','image','jpeg',0,'19qi8i6p2vedrc6d5a3a4uzd5iix3j5'),(1689,'DwWesternwoodlily1.jpg','20040829233609!DwWesternwoodlily1.jpg',607165,642,958,8,'Western wood lily',36346,'Dwindrim','20040801004342','0','BITMAP','image','jpeg',0,'d0qk7lunuy3cim5e008ca0gowyokl31'),(1690,'DwWesternwoodlily1.jpg','20040829233609!DwWesternwoodlily1.jpg',255131,642,958,8,'Western wood lily',36346,'Dwindrim','20040829233631','0','BITMAP','image','jpeg',0,'d0qk7lunuy3cim5e008ca0gowyokl31'),(1691,'DwWesternwoodlily2.jpg','20040829233816!DwWesternwoodlily2.jpg',414457,720,627,8,'Western wood lily',36346,'Dwindrim','20040801005040','0','BITMAP','image','jpeg',0,'4rmvcpxjrwuxn78jvpachy1svnzyrf1'),(1692,'Wheeler-peak.jpg','20040829233902!Wheeler_peak.jpg',20705,379,249,8,'Author: Self. License: {{GFDL}}. ',55979,'Metlin','20040829233415','0','BITMAP','image','jpeg',0,'kxcbvpte0jc18fdtzkrmvdjdtyf7v0n'),(1693,'Wheeler-peak.jpg','20040829233902!Wheeler_peak.jpg',20705,379,249,8,'Author: Self. License: {{GFDL}}.  Description: Picture of Wheeler Peak, the highest peak in New Mexico, US.',55979,'Metlin','20040829233905','0','BITMAP','image','jpeg',0,'kxcbvpte0jc18fdtzkrmvdjdtyf7v0n'),(1694,'DwWesternyarrow.jpg','20040829234040!DwWesternyarrow.jpg',324356,720,439,8,'Western (white) yarrow',36346,'Dwindrim','20040801005457','0','BITMAP','image','jpeg',0,'hoeyhv13zv1j9825c63m4iqu7dw0vds'),(1695,'DwWhitecamus.jpg','20040829234208!DwWhitecamus.jpg',1141567,789,1276,8,'White camus',36346,'Dwindrim','20040801010022','0','BITMAP','image','jpeg',0,'a1af8da99dd6ltyexrl1cy66z3knf0r'),(1696,'Wheeler-peak.jpg','20040829234255!Wheeler_peak.jpg',20705,379,249,8,'Author: Self. License: {{GFDL}}.  Description: Picture of Wheeler Peak, the highest peak in New Mexico, US.',55979,'Metlin','20040829233913','0','BITMAP','image','jpeg',0,'kxcbvpte0jc18fdtzkrmvdjdtyf7v0n'),(1697,'DwWhitecamus.jpg','20040829234208!DwWhitecamus.jpg',318514,789,1276,8,'White camus',36346,'Dwindrim','20040829234245','0','BITMAP','image','jpeg',0,'a1af8da99dd6ltyexrl1cy66z3knf0r'),(1698,'Mt-Walter.jpg','20040829234401!Mt_Walter.jpg',10290,284,213,8,'Author: Self. License: {{GFDL}}.  Description: Picture of Mt. Walter, the second highest peak in New Mexico, US.',55979,'Metlin','20040829233834','0','BITMAP','image','jpeg',0,'l7bqa140fjp7mar66uldecfjddaxlve'),(1699,'DwGaillardia.jpg','20040830004617!DwGaillardia.jpg',170569,432,378,8,'Gaillardia (blanketflower)',36346,'Dwindrim','20040830002902','0','BITMAP','image','jpeg',0,'fn28db86rtbi00ok9iof700dj28zf5b'),(1700,'DwGaillardia.jpg','20040830004617!DwGaillardia.jpg',170569,432,378,8,'Gaillardia (blanketflower)',36346,'Dwindrim','20040830004636','0','BITMAP','image','jpeg',0,'fn28db86rtbi00ok9iof700dj28zf5b'),(1701,'Brooklyn-Heights.jpg','20040830011652!Brooklyn_Heights.jpg',82964,1993,365,8,'View of Brooklyn Heights, Brooklyn, NY',65454,'Sfoskett','20040830010939','0','BITMAP','image','jpeg',0,'q13a7p4uf8reotcunvyee2r0cuno98w'),(1702,'DwBlanketflower.jpg','20040830011656!DwBlanketflower.jpg',158422,413,359,8,'Gaillardia (blanketflower)',36346,'Dwindrim','20040830011644','0','BITMAP','image','jpeg',0,'n7qa1015zp32smd503errunxe7fynfh'),(1703,'International-Brigades-poster3.jpg','20040830183147!International_Brigades_poster3.jpg',77522,491,413,8,'International Brigades propaganda poster',84330,'Rama','20040830182550','0','BITMAP','image','gif',0,'f18vzfyxxmhgj4y4gd2p56j45qi23xu'),(1704,'International-Brigades-poster1.jpg','20040830190252!International_Brigades_poster1.jpg',11937,144,204,8,'Propaganda poster about the International Brigades',84330,'Rama','20040830115343','0','BITMAP','image','jpeg',0,'574le96q3fknq1uwjj6lhsnfst7gvn5'),(1705,'DwSixspecies.jpg','20040830204322!DwSixspecies.jpg',2667498,1171,1717,8,'Six showy species in a half square metre',36346,'Dwindrim','20040830203723','0','BITMAP','image','jpeg',0,'rutjkwjggmjuvcezikbo7weg8hxn57r'),(1706,'Orpiment-pigment-sample.jpg','20040831063345!Orpiment_pigment_sample.jpg',13868,500,500,8,'Sample of orpiment ground and processed as a pigment, painted on paper',98640,'Palladian','20040831063203','0','BITMAP','image','jpeg',0,'gby2do2grvhrr2hbjew3vnqbw90c3l9'),(1707,'Dandelion.jpg','20040831130538!Dandelion.jpg',386051,1583,1184,8,'Dandelion on the banks of the Swifts Creek',99065,'Fir0002','20040831095943','0','BITMAP','image','jpeg',0,'0rnhnxcq6njw64zpb7c11p80pphghgo'),(1708,'Alexa-traffic-ranking-for-wikipedia.png','20040831134623!Alexa_traffic_ranking_for_wikipedia.png',2349,432,240,8,'Chart of Alexa traffic ranking for Wikipedia',88976,'Kbh3rd','20040823233907','0','BITMAP','image','png',0,'sve8n18sio7dphpff3mm47nlw69ouaa'),(1709,'Santorini.jpeg','20040831230542!Santorini.jpeg',39395,360,480,8,'Better colors.',6307,'Chmouel','20040721011921','0','BITMAP','image','jpeg',0,'jdbezijpnnw9h7sn0qo6qxnpay6hp8h'),(1710,'Alexa-reach-measurement-for-wikipedia.png','20040901020724!Alexa_reach_measurement_for_wikipedia.png',4219,480,360,8,'Alexa reach measurement for wikipedia.org',88976,'Kbh3rd','20040814032938','0','BITMAP','image','png',0,'2akp6au3u3ydj32qm5fn3zda1tbtkqi'),(1711,'Broken-Obelisk-in-UW-Red-Square.jpg','20040901033441!Broken_Obelisk_in_UW_Red_Square.jpg',77653,450,600,8,'Broken Obelisk by Barnett Newman in the University of Washington\'s Red Square',74476,'Jkiang','20040901033034','0','BITMAP','image','jpeg',0,'qj7uyyn3so3x2dbpkyprqe4090wexjm'),(1712,'Google-News-stories-mentioning-Wikipedia.png','20040901033845!Google_News_stories_mentioning_Wikipedia.png',2663,432,240,8,'Chart of Google news stories mentioning Wikipedia',88976,'Kbh3rd','20040824010248','0','BITMAP','image','png',0,'798i3x8bos1w4bugcynp7gcr7m1veju'),(1713,'Wikipedia-onthe-web.png','20040901034712!Wikipedia-onthe-web.png',2907,480,240,8,'Mentions of Wikipedia on websites outside Wikipedia',88976,'Kbh3rd','20040814021722','0','BITMAP','image','png',0,'s8zwbdww0rmjdqrj4znv51tu6f8tpds'),(1714,'Borobudur-perfect-buddha.jpg','20040901035212!Borobudur-perfect-buddha.jpg',143419,900,1200,8,'',82826,'Solitude','20040831103341','0','BITMAP','image','jpeg',0,'1idzesybd5p3y2d5h7swidvzfsy3u2z'),(1715,'Google-Answers-using-Wikipedia.png','20040901035606!Google_Answers_using_Wikipedia.png',3881,480,360,8,'Google Answers using Wikipedia',88976,'Kbh3rd','20040814025338','0','BITMAP','image','png',0,'qfff21uj0yctb2343czkfctjqbl4x0r'),(1716,'Broken-Obelisk-in-UW-Red-Square.jpg','20040901042356!Broken_Obelisk_in_UW_Red_Square.jpg',89329,450,600,8,'Broken Obelisk by Barnett Newman in UW Red Square',74476,'Jkiang','20040901033449','0','BITMAP','image','jpeg',0,'1r46kju12hp0e6nqmtquo64fmm649mt'),(1717,'Cev-cover.jpg','20040901050812!Cev-cover.jpg',12264,173,203,8,'Beauty shot of the cover of the [[Contemporary English Version]] published in 1995. {{msg:PD}}',5904,'Hoshie','20040409115531','0','BITMAP','image','jpeg',0,'i67ebqc06uhmq2ul39a5c8psbyj6ywa'),(1718,'Dandelion.jpg','20040901072728!Dandelion.jpg',167718,1000,748,8,'',82826,'Solitude','20040831130541','0','BITMAP','image','jpeg',0,'n7tf3uoegr17gdbcwq2vtxtzu0y0vbt'),(1719,'Dandelion.jpg','20040901072756!Dandelion.jpg',386051,1583,1184,8,'Reverted to earlier revision',99065,'Fir0002','20040901072729','0','BITMAP','image','jpeg',0,'0rnhnxcq6njw64zpb7c11p80pphghgo'),(1720,'Go-board.jpg','20040901185354!Go_board.jpg',50073,578,344,8,'boost sat, crop',4099,'Stevertigo','20040730032510','0','BITMAP','image','jpeg',0,'ak49xtiwbhtpv6784ik6ci9gmd4tz47'),(1721,'Go-board.jpg','20040901185452!Go_board.jpg',48248,600,317,8,'Reverted to earlier revision',96368,'Funkyj','20040901185355','0','BITMAP','image','jpeg',0,'czy70q9pposo6ev9yh491wj52893cjg'),(1722,'Gfi.socket.png','20040901191741!Gfi.socket.png',11195,139,271,8,'Stylized image of a Ground-Fault Interrupt socket outlet for 110 volt household current (N. American)',65216,'Clarknova','20040618030133','0','BITMAP','image','png',0,'g90elnv4hy93625h7mtmkwgkh4qn098'),(1723,'Hawthorne-Bridge.jpg','20040901222621!Hawthorne_Bridge.jpg',49503,528,379,8,'{{PD-USGov}}',75749,'Ta bu shi da yu','20040817143918','0','BITMAP','image','jpeg',0,'r5jlrh17w3st75ivt03biqwii7015u0'),(1724,'Weeds.jpg','20040902032227!Weeds.jpg',1438919,2048,1536,8,'Taken by [[User:Lupin|Lupin]] in [[Waterloo, Ontario]], 21/5/04 {{GFDL}}',42385,'Lupin','20040902032212','a:32:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:19:\"Canon PowerShot A70\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:05:21 21:32:19\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:5:\"1/200\";s:7:\"FNumber\";s:5:\"28/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:05:21 21:32:19\";s:17:\"DateTimeDigitized\";s:19:\"2004:05:21 21:32:19\";s:22:\"CompressedBitsPerPixel\";s:3:\"5/1\";s:17:\"ShutterSpeedValue\";s:6:\"245/32\";s:13:\"ApertureValue\";s:5:\"95/32\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:5:\"95/32\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:6:\"173/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"2048000/208\";s:21:\"FocalPlaneYResolution\";s:11:\"1536000/156\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:9:\"2048/2048\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'m5x4q2y75ci7qk14eqg37whuiyld1if'),(1725,'P-ogden1.jpg','20040902080833!P_ogden1.jpg',7708,160,195,8,'public domain (old)',33763,'Greenmountainboy','20031217221339','0','BITMAP','image','jpeg',0,'0776znw6uamcdfsyw1y9tlf5qfr9wf8'),(1726,'Bloomberg.jpg','20040902080911!Bloomberg.jpg',37403,407,258,8,'I took this pic of New York City Mayor Michael Bloomberg at the 2003 NYC Pride parade (June 29, I think it was).',11602,'Next Paige','20031002230328','0','BITMAP','image','jpeg',0,'ki8adz9w03aw8ocgfwkb6v52qbatqy1'),(1727,'Alexa-traffic-ranking-for-wikipedia.png','20040902133337!Alexa_traffic_ranking_for_wikipedia.png',2359,432,240,8,'updated as of August 31',88976,'Kbh3rd','20040831134632','0','BITMAP','image','png',0,'8q7znnurr1w7g81dycf5iyv6ke7r4c4'),(1728,'Bilobalide.png','20040902135849!Bilobalide.png',3319,143,113,8,'',88116,'Mykhal','20040902115620','0','BITMAP','image','png',0,'kml0tu5z1jd6et94llpxk18z6cweqcy'),(1729,'Pramiracetam.png','20040902140522!Pramiracetam.png',1947,174,105,8,'',88116,'Mykhal','20040831220707','0','BITMAP','image','png',0,'jnge6v2lv6ekk6sbdwmhsut06g12vgb'),(1730,'Fasoracetam.png','20040902140656!Fasoracetam.png',1563,135,79,8,'',88116,'Mykhal','20040831232138','0','BITMAP','image','png',0,'ih0ov9e7wtvdj5ampthr4e3g9tew3yf'),(1731,'Nebracetam.png','20040902140852!Nebracetam.png',1748,111,129,8,'',88116,'Mykhal','20040831230508','0','BITMAP','image','png',0,'lfui3fldm3x7yoyczkvv71zmsqsavzb'),(1732,'Oxiracetam.png','20040902141606!Oxiracetam.png',1506,105,119,8,'',88116,'Mykhal','20040831215834','0','BITMAP','image','png',0,'q0rrlxii3uje3gafzams4y4xafl2jck'),(1733,'Xylometazoline.png','20040902142220!Xylometazoline.png',1877,97,148,8,'',88116,'Mykhal','20040828005607','0','BITMAP','image','png',0,'erzdbc36yca8f6xqs7wyz33y8c2bvrw'),(1734,'Curcumin.png','20040902142606!Curcumin.png',3437,275,106,8,'',88116,'Mykhal','20040827231829','0','BITMAP','image','png',0,'i70wco2zin4edk00l122fmu3kw0rj9h'),(1735,'Chmouel-Boudjnah.jpg','20040902152055!Chmouel_Boudjnah.jpg',43353,429,799,8,'Chmouel Boudjnah. Picture for my profile page.',6307,'Chmouel','20040403094745','0','BITMAP','image','jpeg',0,'4up08zsjtx0yf0vcyhjg201v3dimi2d'),(1736,'Sealevel.png','20040902185010!Sealevel.png',5418,633,467,8,'Schematic of sea level over the last 20 kyr',8072,'William M. Connolley','20040902184716','0','BITMAP','image','png',0,'jwt2ou73bo4lg31z95snin42vhmw253'),(1737,'Frontier-flying-service-logo.png','20040902191930!Frontier_flying_service_logo.png',16746,328,53,8,'Corporate logo - copyrighted, claiming fair use',71581,'Kevyn','20040803210338','0','BITMAP','image','png',0,'a2u13rk8mlf848uxalin7cbx2sgz1xt'),(1738,'Borobudur-perfect-buddha.jpg','20040902202223!Borobudur-perfect-buddha.jpg',134727,900,1200,8,'',21013,'Raul654','20040901035214','0','BITMAP','image','jpeg',0,'eq64ta2k5whtnhpz1b0s7j975j130xd'),(1739,'Borobudur-perfect-buddha.jpg','20040902202316!Borobudur-perfect-buddha.jpg',143419,900,1200,8,'Reverted to earlier revision',89027,'Janderk','20040902202226','0','BITMAP','image','jpeg',0,'1idzesybd5p3y2d5h7swidvzfsy3u2z'),(1740,'Rotunda.jpg','20040902224013!Rotunda.jpg',20515,300,226,8,'The Rotunda at the University of Virginia',18998,'ElmoHoo','20031103043343','0','BITMAP','image','jpeg',0,'fljchfjgfmy5x2s8tl2i29j0niz799y'),(1741,'Rotunda.jpg','20040902224126!Rotunda.jpg',18282,248,165,8,'Reverted to earlier revision',18998,'ElmoHoo','20040902224014','0','BITMAP','image','jpeg',0,'3avwf5ldggcto0gwaui5wha2nb4ck0r'),(1742,'Darby-Digger-1.jpg','20040903081521!Darby_Digger_1.jpg',1311481,3450,2520,8,'',100074,'Normangrove','20040902230725','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:09:02 23:24:41\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'rcbtj0l4i4syf66zbyo9oh7u6i3b7qz'),(1743,'Dymaxion-map-unfolded.png','20040903163310!Dymaxion_map_unfolded.png',148357,744,379,8,'PD Dymaxion map',35616,'Cyrius','20040613063802','0','BITMAP','image','png',0,'4mqwugechuf26l501u0qkhulqmqjis1'),(1744,'Season-of-the-Sakura-box-cover.jpg','20040903164358!Season_of_the_Sakura_box_cover.jpg',28695,150,239,8,'The box cover of the game [[Season of the Sakura]].',75809,'AlexChurchill','20040902155250','0','BITMAP','image','jpeg',0,'cqosfnn9dht31h39pv0lkcn4wgukfyy'),(1745,'Eric-Morecambe-statue.jpg','20040903173625!Eric_Morecambe_statue.jpg',92217,800,600,8,'Taken by me, 11/Apr/2004. <br>{{msg:GFDL}}',42385,'Lupin','20040412124316','0','BITMAP','image','jpeg',0,'kzcszpvhm36anqhx4qd85daec4h8gza'),(1746,'RussiaNorthOssetia.Highlight.png','20040903210029!RussiaNorthOssetia.Highlight.png',34494,300,178,8,'modified Image:RussiaNorthOssetia.png, gfdl',23076,'Hajor','20040903184614','0','BITMAP','image','png',0,'6n66c26fq1ewttc2sfb04x6gplobvjk'),(1747,'Flag-of-Galicia.png','20040903211753!Flag_of_Galicia.png',9168,0,0,0,'Flag of Galicia',59560,'FernandoCela','20040903211448','',NULL,'unknown','unknown',0,''),(1748,'Flag-of-Galicia.png','20040903212502!Flag_of_Galicia.png',1495,0,0,0,'Flag of Galicia',59560,'FernandoCela','20040903211803','0','BITMAP','image','png',0,'hf2uvffd4q4fyjabo8vzn94bpnmsx5j'),(1749,'RussiaNorthOssetia.Highlight.png','20040903212613!RussiaNorthOssetia.Highlight.png',12272,300,178,8,'More professional looking. Done by myself.',46083,'Cantus','20040903210033','0','BITMAP','image','png',0,'ts3lox7blmaehr66xt1qg37ctd6zbqp'),(1750,'RGR.JPG','20040903213748!RGR.JPG',10102,250,221,8,'',64883,'Hammersfan','20040903213639','0','BITMAP','image','jpeg',0,'ocmdm3ut9n2riq1nkyih3yakavcokpc'),(1751,'Beslan-location.png','20040903233032!Beslan-location.png',14196,300,330,8,'Location of [[Beslan]]; derived from [[:Image:North ossetia map.png]] (PD). New version released under [[GNU Free Documentation License]]. {{GFDL}}',30200,'Sverdrup','20040903122811','0','BITMAP','image','png',0,'898z8i47xi56bj1rnhjf8uf5cx4e11m'),(1752,'ChrisDJackson.jpg','20040904010647!ChrisDJackson.jpg',60365,202,254,8,'Reverted to earlier revision',35792,'AmericanCentury21','20040408230122','0','BITMAP','image','jpeg',0,'co3vxtb643bij8aikjdepvzsjtp89m3'),(1753,'ChrisDJackson.jpg','20040904011010!ChrisDJackson.jpg',7643,180,208,8,'',35792,'AmericanCentury21','20040904010917','0','BITMAP','image','jpeg',0,'8xceb7xcsmuh6mrklgzfhxx4t6x7cay'),(1754,'Klm.fokker70.airbrakes.arp.750pix.jpg','20040904104730!Klm.fokker70.airbrakes.arp.750pix.jpg',153596,750,467,8,'KLM Fokker70 to show airbrakes',7095,'Arpingstone','20040904104333','a:34:{s:16:\"ImageDescription\";s:31:\"OLYMPUS DIGITAL CAMERA         \";s:4:\"Make\";s:19:\"OLYMPUS CORPORATION\";s:5:\"Model\";s:6:\"C750UZ\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:9:\"v753u2-86\";s:8:\"DateTime\";s:19:\"2004:08:30 10:33:46\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:8:\"10/10000\";s:7:\"FNumber\";s:5:\"56/10\";s:15:\"ExposureProgram\";i:4;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:08:30 10:33:46\";s:17:\"DateTimeDigitized\";s:19:\"2004:08:30 10:33:46\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"36/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:6:\"587/10\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:5:\"0/100\";s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'gd1mck0odomlablab4gpuvkcfwz8j0u'),(1755,'Trinity-College-Crest---embossed.png','20040904190011!Trinity_College_Crest_-_embossed.png',398513,500,578,8,'Trinity College Crest - embossed',20762,'Prisonblues','20040717135007','0','BITMAP','image','png',0,'7gezxge9qnq9d2rlgvds1xlqhttp9xi'),(1756,'LaEspero.mid','20040905043715!LaEspero.mid',10116,0,0,0,'La Espero - Anthem of Esperanto',5171,'Cprompt','20030701224907','','AUDIO','audio','midi',0,'hwhxk2mvq3sitnywdqf82nmp7qt4bfj'),(1757,'Ilyanepbyhour.png','20040905053454!Ilyanepbyhour.png',2660,441,320,2,'update',18610,'VeryVerily','20040802073907','0','BITMAP','image','png',0,'08mxng4q44lz6oyt3ltjll0jj6qfu67'),(1758,'Crossbedding-in-Kolob-Canyons.jpeg','20040905085302!Crossbedding_in_Kolob_Canyons.jpeg',64018,800,531,8,'Photo taken by [[user:maveric149|Daniel Mayer]] in August 2004. <br><br>{{GFDL}}<br> {{cc-by-sa}}',62,'Mav','20040905085258','0','BITMAP','image','jpeg',0,'1xjw166p2rpp1u9thnbqlgqorjdiwm2'),(1759,'Sentinal-Slide-in-Zion-Canyon.jpg','20040905094738!Sentinal_Slide_in_Zion_Canyon.jpg',131334,1000,553,8,'Photo taken by [[user:maveric149|Daniel Mayer]] in August 2004. <br><br>{{GFDL}}<br> {{cc-by-sa}}',62,'Mav','20040905090431','0','BITMAP','image','jpeg',0,'ergko26tyui4xgcs67s1zeozkxo47rg'),(1760,'Rockslide-debris-in-Kolob-Canyons.jpeg','20040905105320!Rockslide_debris_in_Kolob_Canyons.jpeg',63215,500,762,8,'Photo taken by [[user:maveric149|Daniel Mayer]] in August 2004. <br><br>{{GFDL}}<br> {{cc-by-sa}}',62,'Mav','20040905090159','0','BITMAP','image','jpeg',0,'9i6ogpwofc2yvpyw8pnrxmtemjarskc'),(1761,'Tdma-frame-structure.png','20040905125208!Tdma-frame-structure.png',7000,0,0,0,'diagram of TDMA framing and timeslot structure; by me; GFDL or ask',65193,'Mozzerati','20040905124911','0','BITMAP','image','png',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(1762,'Osuseal.jpg','20040905142804!Osuseal.jpg',12267,230,154,8,'Seal of OSU, released under the {{msg:GFDL}}',19400,'Taoster','20040502013953','0','BITMAP','image','jpeg',0,'skzzx5in9kcmkuk3n4nlxfji9u8a7ni'),(1763,'Osuseal.jpg','20040905142820!Osuseal.jpg',12267,230,154,8,'Reverted to earlier revision',19400,'Taoster','20040905142806','0','BITMAP','image','jpeg',0,'skzzx5in9kcmkuk3n4nlxfji9u8a7ni'),(1764,'Disc-tumbler-locked.png','20040905200600!Disc_tumbler_locked.png',9270,250,194,8,'Illustration of the [[disc tumbler lock]] created by [[User:Wapcaplet|Wapcaplet]] in [[Blender (program)|Blender]] and touched up in the [[GIMP]].',6264,'Wapcaplet','20031121221731','0','BITMAP','image','png',0,'1pey2x60d984igje3qm0257oon49sv6'),(1765,'Disc-tumbler-unlocked.png','20040905200647!Disc_tumbler_unlocked.png',9710,250,194,8,'fixed image (plug hadn\'t rotated)',6264,'Wapcaplet','20031121222636','0','BITMAP','image','png',0,'kz6zenb6yx8xbon4e6pb108nfw03t35'),(1766,'Dicyclomine-trans.png','20040905235217!Dicyclomine-trans.png',4219,271,154,8,'{{GFDL}}Dicyclomine chemical strucutre. Drawn by kaet using xymtex.',22390,'Kaet','20040905181753','0','BITMAP','image','png',0,'21g8kyw5qazoaeduet6whs044u9xfhr'),(1767,'Dicyclomine-trans.png','20040905235357!Dicyclomine-trans.png',2511,131,150,8,'{{GFDL}}New cleaner pic and with better layout by same author.',22390,'Kaet','20040905235225','0','BITMAP','image','png',0,'fgfloiecibi4j98p1h6s12x0zt4b1ic'),(1768,'Dicyclomine-trans.png','20040905235720!Dicyclomine-trans.png',2511,131,150,8,'{{GFDL}}Dicyclomine, chemical structure.',22390,'Kaet','20040905235404','0','BITMAP','image','png',0,'fgfloiecibi4j98p1h6s12x0zt4b1ic'),(1769,'Mebeverine-trans.png','20040906000017!Mebeverine-trans.png',2832,448,120,8,'{{GFDL}}Mebeverine chemical structure drawn using xymtech by myself.',22390,'Kaet','20040905183535','0','BITMAP','image','png',0,'qidlav2yk27hfwf3hjyclwkq9faj33y'),(1770,'Milverine-trans.png','20040906000334!Milverine-trans.png',4182,225,147,8,'{{GFDL}}Milverine chemical structure drawn by kaet with xymtex.',22390,'Kaet','20040905184959','0','BITMAP','image','png',0,'e11c6mdakr3e8dcy80sb9qeylginu1w'),(1771,'Coat-of-Arms-Reagan-Shield-1.png','20040906034605!Coat_of_Arms_Reagan_Shield_1.png',23950,797,498,8,'',54836,'Garryq','20040821002847','0','BITMAP','image','png',0,'tqn06ym2n1l6wj9te30fchhovwb7hzq'),(1772,'Broccoli-crop.jpg','20040906071226!Broccoli_crop.jpg',90116,500,747,8,'USDA photo.',7279,'Minesweeper','20040321104643','0','BITMAP','image','jpeg',0,'e4i2srste7mmmz7vz5txo32pe8euc0p'),(1773,'Darby-Digger-1.jpg','20040906161435!Darby_Digger_1.jpg',533767,2156,1575,8,'',100074,'Normangrove','20040903081547','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:09:03 08:59:53\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'mm9mqmfnfu1bga4viqvamwgnlh3xclw'),(1774,'Daily-page-requests-for-wikipedia.org.png','20040906163220!Daily_page_requests_for_wikipedia.org.png',3647,432,328,8,'Daily page requests for wikipedia.org',88976,'Kbh3rd','20040906162431','0','BITMAP','image','png',0,'lk7ej09szryx0tfyrqechjfi1fpjo08'),(1775,'Happy-Happy-Happy2.jpg','20040906172027!Happy_Happy_Happy2.jpg',145937,351,835,8,'cropped',10049,'Jiang','20040729025516','0','BITMAP','image','jpeg',0,'22rfcjvojv2avgx9rw4js78oczvwf31'),(1776,'Happy-Happy-Happy2.jpg','20040906172044!Happy_Happy_Happy2.jpg',145937,1024,835,8,'Reverted to earlier revision',100439,'Euniana','20040906172028','0','BITMAP','image','jpeg',0,'oyaej4dlnusodukq3jp4w29ho7ou7e1'),(1777,'Daily-page-requests-for-wikipedia.org.png','20040906173339!Daily_page_requests_for_wikipedia.org.png',3647,432,328,8,'Saner colors',88976,'Kbh3rd','20040906163223','0','BITMAP','image','png',0,'d8xp9f2pqz8akcdqc71vpkp7tuv4n97'),(1778,'Renoir-dancing-girl-with-castanets.jpg','20040906193153!Renoir-dancing_girl_with_castanets.jpg',25603,320,500,8,'[[Renoir]], painted in [[1909]].<p>{{PD-art}}',42385,'Lupin','20040906192901','0','BITMAP','image','jpeg',0,'0gzqlqw5h73vrelwle037s4degyna6k'),(1779,'Victoria-harbour.jpg','20040906210033!Victoria_harbour.jpg',63149,500,375,8,'Victoria Harbour; self photographed; 2001; {{GFDL}}',85594,'Filzstift','20040825065236','a:32:{s:11:\"Compression\";i:6;s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:22:\"Canon DIGITAL IXUS 300\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:10:\"ImageReady\";s:8:\"DateTime\";s:19:\"2001:09:22 10:28:21\";s:21:\"JPEGInterchangeFormat\";i:1524;s:27:\"JPEGInterchangeFormatLength\";i:5972;s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:5:\"1/160\";s:7:\"FNumber\";s:5:\"80/10\";s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2001:09:22 10:28:21\";s:17:\"DateTimeDigitized\";s:19:\"2001:09:22 10:28:21\";s:22:\"CompressedBitsPerPixel\";s:3:\"3/1\";s:17:\"ShutterSpeedValue\";s:6:\"234/32\";s:13:\"ApertureValue\";s:6:\"192/32\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:12:\"187820/65536\";s:15:\"SubjectDistance\";s:10:\"65535/1000\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:6:\"173/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"1600000/206\";s:21:\"FocalPlaneYResolution\";s:11:\"1200000/155\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'rc913zfixa4bxx2qeyqroh69g5ashbx'),(1780,'BeijingFromTian\'anmenChenglouJul2004.jpg','20040907004227!BeijingFromTian\'anmenChenglouJul2004.jpg',136533,640,479,8,'{{GFDL}} Beijing (Tian\'anmen Square) from Tian\'anmen Chenglou. Taken in July of 2004.',75080,'DF08','20040703182306','a:24:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:9:\"CYBERSHOT\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:13:\"4718592/65536\";s:11:\"YResolution\";s:13:\"4718592/65536\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"QuickTime 6.5.1\";s:8:\"DateTime\";s:19:\"2004:07:04 02:13:10\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:8:\"10/10000\";s:7:\"FNumber\";s:5:\"63/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:07:03 14:09:16\";s:17:\"DateTimeDigitized\";s:19:\"2004:07:03 14:09:16\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:16:\"MaxApertureValue\";s:5:\"48/16\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:6:\"121/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'5mke66nn7gj4anx5o96sq257vdtnuu1'),(1781,'Izzat-ibrahim.jpg','20040907042519!Izzat_ibrahim.jpg',5586,151,177,8,'US Central Command photo:\r\n\r\nhttp://www.centcom.mil/Operations/Iraqi%20Freedom/playing_cards.pdf ',7457,'Egil','20030426073935','0','BITMAP','image','jpeg',0,'g8xx583dwyi6q6tilwwgyeoh4cwyqh1'),(1782,'Synapse.png','20040907084231!Synapse.png',20712,250,193,8,'synapse dia',36346,'Dwindrim','20040427233041','0','BITMAP','image','png',0,'r01ji8ua9waz8mq7tfs3uisjbctjo40'),(1783,'Nlr-tjloco-amoswolfe.jpg','20040907100352!Nlr-tjloco-amoswolfe.jpg',66421,1024,769,8,'Northampton & Lamport Railway, steam locomotive',99342,'AmosWolfe','20040907094103','0','BITMAP','image','jpeg',0,'tmkmfsauj7qmoa3hifgfqionriw9hkp'),(1784,'Warfarin.png','20040907131727!Warfarin.png',2637,152,131,8,'',88116,'Mykhal','20040907131501','0','BITMAP','image','png',0,'4rgkjmd9tp2qdz0qowd8qkwlfv5fm0o'),(1785,'WP-Seattle-neighborhoods.png','20040907193126!WP_Seattle_neighborhoods.png',878,300,55,8,'Seattle neighborhoods progress bar',19020,'ShadowDragon','20040628175722','0','BITMAP','image','png',0,'6h832ste0ojgkls6ovvsuusjid61k7o'),(1786,'BlankMap-RussiaRepublics.png','20040908001943!BlankMap-RussiaRepublics.png',28432,1622,960,8,'Modified version of Morwen\'s [[:Image:BlankMap-RussiaDistricts.png]]',46083,'Cantus','20040907233742','0','BITMAP','image','png',0,'kyomoxfh4i5zfr41fzreeu9xis4k1rb'),(1787,'Alpha-L-Fructose-structure.png','20040908081419!Alpha-L-Fructose-structure.png',10208,459,294,8,'{{GFDL}} Molecule structure of [[Fructose]], typeset with [[PPCHTeX]].',30200,'Sverdrup','20040701041923','0','BITMAP','image','png',0,'q1ffmd45xuwsgsyawp9cmryszzlif1v'),(1788,'Vancouver-area-map.png','20040908144741!Vancouver_area_map.png',118893,801,525,8,'Map of the region around Vancouver, British Columbia',88976,'Kbh3rd','20040903065033','0','BITMAP','image','png',0,'13y2493f7xta7sx8w5m3j18lcmcalp4'),(1789,'Usinprogress.PNG','20040908190039!Usinprogress.PNG',35730,280,183,8,'update',35314,'Seth Ilys','20040827212405','0','BITMAP','image','png',0,'qe1uqrqby255dalz2ashez3bj5dsvfz'),(1790,'Adenine-structure.png','20040908212157!Adenine-structure.png',5567,412,423,8,'{{GFDL}} Structure formula of [[Adenine]], typeset with PPCHTeX.',30200,'Sverdrup','20040628145812','0','BITMAP','image','png',0,'p2x0uojpf9lkpxndapry24l3by1du68'),(1791,'Adenine-structure.png','20040908214850!Adenine-structure.png',7690,388,381,8,'Adenine',59843,'G3pro','20040908212201','0','BITMAP','image','png',0,'jdffnqtw20phvfkb50oc44422v01nza'),(1792,'Adenine-structure.png','20040908215038!Adenine-structure.png',7690,388,381,8,'Adenine',59843,'G3pro','20040908214853','0','BITMAP','image','png',0,'jdffnqtw20phvfkb50oc44422v01nza'),(1793,'Adenine-structure.png','20040908215101!Adenine-structure.png',10956,484,475,8,'Adenine',59843,'G3pro','20040908215041','0','BITMAP','image','png',0,'i9ybej87h1i17dziy90m8834hthpi77'),(1794,'Adenine-structure.png','20040908215359!Adenine-structure.png',7690,388,381,8,'Reverted to earlier revision',59843,'G3pro','20040908215101','0','BITMAP','image','png',0,'jdffnqtw20phvfkb50oc44422v01nza'),(1795,'Alexa-reach-measurement-for-wikipedia.png','20040909023235!Alexa_reach_measurement_for_wikipedia.png',3940,480,328,8,'Updated to stats as of 31 August 2004',88976,'Kbh3rd','20040901020727','0','BITMAP','image','png',0,'kwwqh2te6oohibvicgobu2sqhmzb0ex'),(1796,'Alexa-traffic-ranking-for-wikipedia.png','20040909023353!Alexa_traffic_ranking_for_wikipedia.png',2359,432,240,8,'Updated to 2-Sep-2004',88976,'Kbh3rd','20040902133345','0','BITMAP','image','png',0,'ihbiih10b5uep5hlrjcb8nbocc36u3d'),(1797,'Wikipede-books.png','20040909134400!Wikipede_books.png',5144,316,168,4,'cartoon of a bookipede by theresa and maria knott',8257,'Theresa knott','20030721220609','0','BITMAP','image','png',0,'70m0vlyvvo0mlhwbnupoqf9op4tqzgx'),(1798,'UIUCseal.jpg','20040909165608!UIUCseal.jpg',49648,425,319,8,'UIUC Seal',59843,'G3pro','20040909165254','0','BITMAP','image','jpeg',0,'r7hx4dlk5mjk4v4gwiz5pyvi10dft6q'),(1799,'Cache,associative-read.png','20040910061759!Cache,associative-read.png',17541,417,276,8,'Read path for an associative cache',35676,'Iain.mcclatchie','20040722073253','0','BITMAP','image','png',0,'88n1ljnehj5dnqvart5c7z39s2x1sz0'),(1800,'Cache,associative-read.dia','20040910061856!Cache,associative-read.dia',2588,0,0,0,'Source for [[Image:Cache,associative-read.png]]',35676,'Iain.mcclatchie','20040722073511','','UNKNOWN','unknown','unknown',0,'tgzxnxg4k13h1dkgtlpywqy56z3zdoj'),(1801,'Railway-bridge-by-goring.jpg','20040910092056!Railway_bridge_by_goring.jpg',498489,2048,1536,8,'Railway bridge by Goring',102481,'Scu98rkr','20040909122850','a:38:{s:4:\"Make\";s:8:\"FUJIFILM\";s:5:\"Model\";s:14:\"FinePix A303  \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:37:\"Digital Camera FinePix A303   Ver1.00\";s:8:\"DateTime\";s:19:\"2003:05:10 13:42:14\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/2400\";s:7:\"FNumber\";s:7:\"280/100\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2003:05:10 13:42:14\";s:17:\"DateTimeDigitized\";s:19:\"2003:05:10 13:42:14\";s:22:\"CompressedBitsPerPixel\";s:5:\"15/10\";s:17:\"ShutterSpeedValue\";s:7:\"790/100\";s:13:\"ApertureValue\";s:7:\"310/100\";s:15:\"BrightnessValue\";s:7:\"608/100\";s:17:\"ExposureBiasValue\";s:5:\"0/100\";s:16:\"MaxApertureValue\";s:7:\"300/100\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:8:\"1710/100\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:6:\"3884/1\";s:21:\"FocalPlaneYResolution\";s:6:\"3884/1\";s:24:\"FocalPlaneResolutionUnit\";i:3;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"SceneCaptureType\";i:0;s:9:\"Sharpness\";i:0;s:20:\"SubjectDistanceRange\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'mpip0yx4f5gar7hk5fnokvx13thpsr3'),(1802,'Arsenal-parade-2004---men.jpg','20040910132353!Arsenal_parade_2004_-_men.jpg',285089,1536,1024,8,'Photograph I have taken at the Arsenal Parade (Islington - 2004) {{PD}}  ',47402,'Dineshcooper','20040904194629','0','BITMAP','image','jpeg',0,'9jom5w9ket801p6k07s0aafsw11rh73'),(1803,'EU33-AK.png','20040910140455!EU33-AK.png',5764,262,160,8,'{{GFDL}}',85484,'Aris Katsaris','20040910133712','0','BITMAP','image','png',0,'01sfc9lpegwmaqh1fxkmdaizj58m5ay'),(1804,'Country-positions-Iraq-war.png','20040910144048!Country_positions_Iraq_war.png',45578,1357,628,8,'pngcrushed',85484,'Aris Katsaris','20040727051051','0','BITMAP','image','png',0,'qaaijyjhqdk1xrn8h3ytnpny8rmnp8v'),(1805,'Country-positions-Iraq-war.png','20040910144736!Country_positions_Iraq_war.png',89376,1357,628,8,'country positions Iraq war',49019,'Get-back-world-respect','20040910144105','0','BITMAP','image','png',0,'77gynhplme33cr0pt4x7um793fi7o9v'),(1806,'Very-Large-Telescope-Array.aerial-view.jpg','20040910145514!Very_Large_Telescope_Array.aerial_view.jpg',19727,350,326,8,'reloading image',35996,'Maio','20040313220513','0','BITMAP','image','jpeg',0,'eoorlcp3vne6j8nl5ib4ev1h6ujjm5t'),(1807,'EU33-AK.png','20040910160819!EU33-AK.png',5516,262,160,8,'',85484,'Aris Katsaris','20040910140505','0','BITMAP','image','png',0,'0jvrg03p4hhohgpcbvm5jkbw93o2oq8'),(1808,'FremontBridgePortland.jpg','20040910231008!FremontBridgePortland.jpg',149488,899,391,8,'Fremont Bridge in Portland, Oregon',94933,'Cacophony','20040901220457','a:35:{s:4:\"Make\";s:5:\"NIKON\";s:5:\"Model\";s:5:\"E3100\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:13:\"4718592/65536\";s:11:\"YResolution\";s:13:\"4718592/65536\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"QuickTime 6.5.1\";s:8:\"DateTime\";s:19:\"2004:09:01 15:03:14\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/4401\";s:7:\"FNumber\";s:5:\"56/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:09:01 13:03:48\";s:17:\"DateTimeDigitized\";s:19:\"2004:09:01 13:03:48\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"30/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:5:\"58/10\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:5:\"0/100\";s:21:\"FocalLengthIn35mmFilm\";i:38;s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:20:\"SubjectDistanceRange\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'2qyxuaiozfk6eyov4sdwoq9wynxlihq'),(1809,'Polemount-singlephase-closeup.jpg','20040911043914!Polemount-singlephase-closeup.jpg',98890,1556,2392,8,'Closeup of singlephase polemount transformer',62535,'Glogger','20040911033316','0','BITMAP','image','jpeg',0,'hmy53tckp4ntn5g4twtbk2zbv6bck9m'),(1810,'Virgen-de-quito-statue.jpg','20040911192308!Virgen_de_quito_statue.jpg',52833,594,889,8,'Winged statue of the Madonna on the Panecillo rise in Quito',91076,'RJHall','20040911191322','0','BITMAP','image','jpeg',0,'c9575wepssh84so495biam349xvmjs0'),(1811,'Ottawa-transitway.png','20040911214457!Ottawa-transitway.png',74430,800,559,8,'Map of the Ottawa Transitway and O-Train network. Image created by [[user:Montrealais|]] and released under GNU FDL as specified on the image.',3378,'Montrealais','20040421031922','0','BITMAP','image','png',0,'qdnv0y2sxez5s3byz3kvbpht7peua23'),(1812,'Jan-Karol-Chodkiewicz.jpg','20040911222425!Jan_Karol_Chodkiewicz.jpg',13775,202,266,8,'Jan Karol Chodkiewicz from WP-Pl',11,'Kpjas','20030105130048','0','BITMAP','image','jpeg',0,'737yotn6l7kb1yc09x1hzahgh89a5ex'),(1813,'KCROSS.jpg','20040912040747!KCROSS.jpg',18203,403,367,8,'I drew this Keynesian cross diagram',56750,'Jdevine','20040912040521','0','BITMAP','image','jpeg',0,'eldayerztlqrybzw1kt53hh7phi0mst'),(1814,'Morlamvcd.jpg','20040912053210!Morlamvcd.jpg',8678,339,254,8,'screenshot of track 5 from VCD \"Mor Lam Sa On 8\" by Jintara Poonlarb {{fairuse}}',44845,'Henry Flower','20040708031645','0','BITMAP','image','jpeg',0,'n3ydxaj1anrtnhqzvmv0karyboi2opn'),(1815,'Orbits-OrbitalParameters-001.PNG','20040912060737!Orbits-OrbitalParameters-001.PNG',46243,1024,768,8,'Orbit and its orbital parameters',96735,'0.39','20040912060719','0','BITMAP','image','png',0,'72vapyhivvxi9zly552tajyyv8ea43p'),(1816,'Orbits-OrbitalParameters-001.PNG','20040912062126!Orbits-OrbitalParameters-001.PNG',46243,1024,768,8,'Orbit and its orbital parameters',96735,'0.39','20040912060753','0','BITMAP','image','png',0,'72vapyhivvxi9zly552tajyyv8ea43p'),(1817,'Orbits-OrbitalParameters-001.PNG','20040912062224!Orbits-OrbitalParameters-001.PNG',47070,1024,768,8,'',96735,'0.39','20040912062129','0','BITMAP','image','png',0,'57tuh4nv9e9hhlk8uxhjgtvbhs1y8py'),(1818,'Orbits-OrbitalParameters-001.PNG','20040912062419!Orbits-OrbitalParameters-001.PNG',47070,1024,768,8,'',96735,'0.39','20040912062231','0','BITMAP','image','png',0,'57tuh4nv9e9hhlk8uxhjgtvbhs1y8py'),(1819,'REMNewAdventuresInHiFi.jpg','20040912101622!REMNewAdventuresInHiFi.jpg',9552,223,222,8,'{{fairuse}}, Source: http://images.amazon.com/images/P/B000002N9S.01.LZZZZZZZ.jpg',81738,'Pizzahunks','20040830140621','0','BITMAP','image','jpeg',0,'4qd7lk88vr5kqueybc9s565ecwrhh6a'),(1820,'IndiaTest.png','20040912103334!IndiaTest.png',34099,350,399,8,'Map of India, uploaded for discussion - to be deleted later',28394,'Ankur','20040817221356','0','BITMAP','image','png',0,'57egnilluyamla4gs4git6dh5o5tgae'),(1821,'Saint-Pons-small.jpg','20040912104104!Saint_Pons-small.jpg',42660,350,525,8,'',3857,'Ericd','20031008111141','0','BITMAP','image','jpeg',0,'gi2zys2kh1cro6dcxxdn1s15ezajjv1'),(1822,'IndiaTest.png','20040912180140!IndiaTest.png',202474,472,543,8,'Complet(er)',28394,'Ankur','20040912103345','0','BITMAP','image','png',0,'cf1ejnf6r0zzcd1nnjpy0i8f3cimojw'),(1823,'Mcgannpaul.jpg','20040913053216!Mcgannpaul.jpg',7441,150,150,8,'copyright-free publicity still of Paul McGann as the Doctor',6661,'PMelvilleAustin','20031020072736','0','BITMAP','image','jpeg',0,'8m6n4r0ohhdnqvd2c5pvb3i78m098l7'),(1824,'IndiaTest.png','20040913101053!IndiaTest.png',223882,472,543,8,'',21013,'Raul654','20040912180142','0','BITMAP','image','png',0,'nloouarktwejvfrj6wexvm6of63lq3g'),(1825,'Castel-Sant\'Angelo.jpg','20040913154640!Castel_Sant\'Angelo.jpg',584402,1983,1666,8,'Castel Sant\'Angelo in Rome, Italy. Picture taken on September 10 2004',92808,'TG','20040913153423','0','BITMAP','image','jpeg',0,'jh9x8way00k6yyzhg74su355zve7u1f'),(1826,'Thornbury.church.interior.arp.750pix.jpg','20040913200915!Thornbury.church.interior.arp.750pix.jpg',144617,750,561,8,'St Mary\'s Church interior',7095,'Arpingstone','20040913200522','a:34:{s:16:\"ImageDescription\";s:31:\"OLYMPUS DIGITAL CAMERA         \";s:4:\"Make\";s:19:\"OLYMPUS CORPORATION\";s:5:\"Model\";s:6:\"C750UZ\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:9:\"v753u2-86\";s:8:\"DateTime\";s:19:\"2004:09:03 11:11:34\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/130\";s:7:\"FNumber\";s:5:\"28/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:09:03 11:11:34\";s:17:\"DateTimeDigitized\";s:19:\"2004:09:03 11:11:34\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"30/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:5:\"63/10\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:5:\"0/100\";s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'thhmpszc5a4kc9knz2gwsa1k8zgyqf7'),(1827,'CSS-Arkansas-2.jpg','20040913215435!CSS_Arkansas_2.jpg',95167,740,490,8,'[[CSS Arkansas]]',19833,'Morven','20040913215204','0','BITMAP','image','jpeg',0,'apss2veoz9ntlbelk2ddbhf6j9evn6b'),(1828,'Horacecutler.jpg','20040913225530!Horacecutler.jpg',79133,302,315,8,'Sir Horace Cutler, Leader of the GLC 1977-1981',55217,'Fys','20040425001616','0','BITMAP','image','jpeg',0,'bv8c29uvetwpr8bh3sql6m3pcjjkf9q'),(1829,'Lateral-sulcus.png','20040914050950!Lateral_sulcus.png',160785,896,566,8,'Lateral sulcus of the human brain.',97339,'Jimhutchins','20040914050916','0','BITMAP','image','png',0,'itss681pk7cu3dkyjqrx5f4p6ik76e4'),(1830,'IndiaTest.png','20040914063306!IndiaTest.png',193385,472,547,8,'',28394,'Ankur','20040913101100','0','BITMAP','image','png',0,'ch7kmlcw1506hxj6j7r17iakipetx5e'),(1831,'Alexa-reach-measurement-for-wikipedia.png','20040914140721!Alexa_reach_measurement_for_wikipedia.png',3980,480,328,8,'to 9-sept-04',88976,'Kbh3rd','20040909023239','0','BITMAP','image','png',0,'5k56qx5ogngsexwp1y9bcc0p9noag3z'),(1832,'Alexa-reach-measurement-for-wikipedia.png','20040914140930!Alexa_reach_measurement_for_wikipedia.png',3557,480,328,8,'to 14 September 2004',88976,'Kbh3rd','20040914140727','0','BITMAP','image','png',0,'fee7mnlhk5citapd8395kgunc7xpp5w'),(1833,'Old-Kazakh-fellow-with-his-camel.jpg','20040914181320!Old_Kazakh_fellow_with_his_camel.jpg',1610797,2272,1704,8,'I took this picture in March, 04, in the steppe of western Kazakhstan,  ',104809,'Carole a','20040914180523','a:32:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:19:\"Canon PowerShot A80\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:04:13 00:49:07\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:5:\"1/500\";s:7:\"FNumber\";s:5:\"56/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:04:13 00:49:07\";s:17:\"DateTimeDigitized\";s:19:\"2004:04:13 00:49:07\";s:22:\"CompressedBitsPerPixel\";s:3:\"5/1\";s:17:\"ShutterSpeedValue\";s:6:\"287/32\";s:13:\"ApertureValue\";s:6:\"159/32\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:5:\"95/32\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:6:\"250/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"2272000/280\";s:21:\"FocalPlaneYResolution\";s:11:\"1704000/210\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:9:\"2272/2272\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'sav9no9m0jday9o880sztpm3ow7cnih'),(1834,'Map-South-Holland-with-numbered-municipalities.png','20040914201120!Map_South_Holland_with_numbered_municipalities.png',74682,570,476,8,'softened',4388,'Patrick','20040826073647','0','BITMAP','image','png',0,'f3584qzu7fgrwanngz1h8u7rb37ykj8'),(1835,'IndiaTest.png','20040914215621!IndiaTest.png',216446,472,547,8,'',21013,'Raul654','20040914063309','0','BITMAP','image','png',0,'h5usawiw7pukm2131v8hbtohaqenrso'),(1836,'AfricaByWilliamBillingsPianoReduction.ogg','20040915054333!AfricaByWilliamBillingsPianoReduction.ogg',259296,0,0,0,'Piano reduction of \"Africa,\" hymn by William Billings',20726,'Opus33','20040911213111','a:4:{s:7:\"version\";i:2;s:7:\"streams\";a:1:{i:18836515;a:8:{s:6:\"serial\";i:18836515;s:5:\"group\";i:0;s:4:\"type\";s:6:\"Vorbis\";s:6:\"vendor\";s:29:\"Xiph.Org libVorbis I 20020717\";s:6:\"length\";d:30.0350113378684824283482157625257968902587890625;s:4:\"size\";i:259296;s:6:\"header\";a:9:{s:14:\"vorbis_version\";i:0;s:14:\"audio_channels\";i:1;s:17:\"audio_sample_rate\";i:44100;s:15:\"bitrate_maximum\";i:0;s:15:\"bitrate_nominal\";i:80120;s:15:\"bitrate_minimum\";i:0;s:11:\"blocksize_0\";i:8;s:11:\"blocksize_1\";i:11;s:12:\"framing_flag\";i:0;}s:8:\"comments\";a:1:{s:11:\"TRACKNUMBER\";s:1:\"1\";}}}s:6:\"length\";d:30.0350113378684824283482157625257968902587890625;s:6:\"offset\";N;}','AUDIO','application','ogg',0,'hkh4kvproobum4q00qyglq2i077pp82'),(1837,'Kazakh-woman-in-her-front-yard-in-winter.jpg','20040915071700!Kazakh_woman_in_her_front_yard_in_winter.jpg',840785,1600,1200,8,'I took this picture. I have never used it anywhere else',104809,'Carole a','20040915070935','a:32:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:19:\"Canon PowerShot A80\";s:11:\"Orientation\";i:6;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:01:24 00:27:33\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:5:\"1/500\";s:7:\"FNumber\";s:5:\"71/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:01:24 00:27:33\";s:17:\"DateTimeDigitized\";s:19:\"2004:01:24 00:27:33\";s:22:\"CompressedBitsPerPixel\";s:3:\"5/1\";s:17:\"ShutterSpeedValue\";s:6:\"287/32\";s:13:\"ApertureValue\";s:6:\"181/32\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:6:\"147/32\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:6:\"749/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"1600000/280\";s:21:\"FocalPlaneYResolution\";s:11:\"1200000/210\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:9:\"2272/2272\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'lwixoss1oeh9grd49ncy78qlr4btzu0'),(1838,'Ryou-b.jpg','20040915080841!Ryou_b.jpg',9611,250,191,8,'Ryou Bakura from The anime/manga Yu-gi-oh!',105366,'Radfel','20040915080733','0','BITMAP','image','jpeg',0,'8oo75lsxab8ow2mgzyu833e3elr214s'),(1839,'Map9.gif','20040915124651!Map9.gif',18337,955,608,8,'',22444,'Adam Carr','20040914052151','0','BITMAP','image','gif',0,'3ae7s42teq606aqgg090p63u4e8p065'),(1840,'Map9.gif','20040915125327!Map9.gif',17788,940,608,8,'',22444,'Adam Carr','20040915124709','0','BITMAP','image','gif',0,'gde3anatni2wx37mcq78rpoby477o2h'),(1841,'Usinprogress.PNG','20040915152322!Usinprogress.PNG',35652,280,183,8,'update',35314,'Seth Ilys','20040908190044','0','BITMAP','image','png',0,'etby64smv55j808e3abmhakyo1m57pp'),(1842,'Jeanne-2004-Track.gif','20040915223320!Jeanne_2004_Track.gif',35100,895,716,8,'{{PD-USGov}} Source: [http://www.weather.gov The National Weather Service].',94202,'Tom','20040915175422','0','BITMAP','image','gif',0,'70bdzg5w32ndjzru4l2lebgmx7jf2lk'),(1843,'Map9a.gif','20040916025827!Map9a.gif',17788,940,608,8,'',22444,'Adam Carr','20040916025024','0','BITMAP','image','gif',0,'gde3anatni2wx37mcq78rpoby477o2h'),(1844,'Map9a.gif','20040916025827!Map9a.gif',17788,940,608,8,'',22444,'Adam Carr','20040916025923','0','BITMAP','image','gif',0,'gde3anatni2wx37mcq78rpoby477o2h'),(1845,'IndiaTest.png','20040916050140!IndiaTest.png',219107,473,546,8,'Rivers',28394,'Ankur','20040914215631','0','BITMAP','image','png',0,'a7brflmqo3lh3ebyrlgolmr8b2d5obi'),(1846,'IndiaTest.png','20040916050243!IndiaTest.png',216446,472,547,8,'Reverted to earlier revision',21013,'Raul654','20040916050140','0','BITMAP','image','png',0,'h5usawiw7pukm2131v8hbtohaqenrso'),(1847,'Napier-example-4.png','20040916075725!Napier-example-4.png',3939,417,185,8,'Modification of example to show additional calculations',105787,'Kbs','20040916074304','0','BITMAP','image','png',0,'spnuet9i2ktzu25galix2qoxwbn4gfa'),(1848,'Jeanne-2004-Track.gif','20040916164445!Jeanne_2004_Track.gif',35839,895,716,8,'As of 1700 EDT 09/15/2004',62427,'Zerbey','20040915223324','0','BITMAP','image','gif',0,'q4386qqxz3hvlqlw11l3rpkqcge01pw'),(1849,'EXTRNLTY.jpg','20040916171356!EXTRNLTY.jpg',33213,463,312,8,'explaining externality. I drew it myself. ',56750,'Jdevine','20040916170140','0','BITMAP','image','jpeg',0,'hu5jn75vbciwp4ue75p6pk59qnw18jv'),(1850,'EXTRNLTY.jpg','20040916172054!EXTRNLTY.jpg',33213,463,312,8,'explaining externality. I drew it myself. revised a little.',56750,'Jdevine','20040916171358','0','BITMAP','image','jpeg',0,'hu5jn75vbciwp4ue75p6pk59qnw18jv'),(1851,'EXTRNLTY.jpg','20040916172328!EXTRNLTY.jpg',33213,463,312,8,'modified picture',56750,'Jdevine','20040916172104','0','BITMAP','image','jpeg',0,'hu5jn75vbciwp4ue75p6pk59qnw18jv'),(1852,'Whaley-Bridge-Mechanics-Institute.jpg','20040916195842!Whaley-Bridge-Mechanics-Institute.jpg',24464,397,464,8,'Whaley Bridge Mechanic\'s Institute',90356,'Billlion','20040916195254','0','BITMAP','image','jpeg',0,'8vy5gs1lnowlwwvumi8cdbhdxsk3nnc'),(1853,'EXTRNLTY.jpg','20040916203629!EXTRNLTY.jpg',26169,417,262,8,'slightly revised',56750,'Jdevine','20040916172330','0','BITMAP','image','jpeg',0,'a32rfm9efqix2wc2uz8pxdxvcn3ytvu'),(1854,'Woolwich-Township,-Ontario.PNG','20040916231246!Woolwich_Township,_Ontario.PNG',13029,506,419,8,'Woolwich Township, Ontario',15941,'Timc','20040622213949','0','BITMAP','image','png',0,'rtuj3082azk9ulk2owdeeipgj9tov76'),(1855,'Wellesley-Township,-Ontario.PNG','20040916231903!Wellesley_Township,_Ontario.PNG',12981,506,419,8,'Wellesley Township, Ontario',15941,'Timc','20040622213821','0','BITMAP','image','png',0,'bptezpxmdu3urdqknmwy3ubtph0cqv8'),(1856,'Wilmot-Township,-Ontario.PNG','20040916231939!Wilmot_Township,_Ontario.PNG',12967,506,419,8,'Wilmot Township, Ontario',15941,'Timc','20040622213907','0','BITMAP','image','png',0,'piwsdt6p0luuxnx6k8yvz9e26xcu8k0'),(1857,'North-Dumfries-Township,-Ontario.PNG','20040916232119!North_Dumfries_Township,_Ontario.PNG',12842,506,419,8,'North Dumfries Township, Ontario',15941,'Timc','20040622213731','0','BITMAP','image','png',0,'q2jfa40o8zd71z5y7s6pvpcv9x6ocwo'),(1858,'DSCN3860-newlondonctskyline-e.JPG','20040917022458!DSCN3860_newlondonctskyline_e.JPG',181701,600,237,8,'[[New London, Connecticut]] skyline',37527,'Decumanus','20040917022355','a:25:{s:4:\"Make\";s:5:\"NIKON\";s:5:\"Model\";s:4:\"E995\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:8:\"E995v1.6\";s:8:\"DateTime\";s:19:\"2004:09:15 14:37:07\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/3617\";s:7:\"FNumber\";s:5:\"63/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:09:15 14:37:07\";s:17:\"DateTimeDigitized\";s:19:\"2004:09:15 14:37:07\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:4:\"0/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:6:\"295/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'094fxhc02xicfep3syg4py279ixs9yb'),(1859,'Ginza.png','20040917102520!Ginza.png',34111,606,487,8,'Tokyo Metro Ginza Line {{GFDL}}',70428,'Fg2','20040821120040','0','BITMAP','image','png',0,'5146fgihk6dp0q3992iicr1elx8jg9u'),(1860,'Marunouchi.png','20040917104847!Marunouchi.png',49744,869,431,8,'Tokyo Metro Marunouchi Line {{GFDL}}',70428,'Fg2','20040819115136','0','BITMAP','image','png',0,'2uztgw7lqdd5ixbmlolmorrtgzi59vr'),(1861,'Hanzomon.png','20040917111206!Hanzomon.png',34195,657,565,8,'Tokyo Metro Hanzomon Line map {{GFDL}}',70428,'Fg2','20040822051529','0','BITMAP','image','png',0,'t5gf46miz7gfl1xxwgurtiuukp3gomh'),(1862,'Hcjc.PNG','20040917115601!Hcjc.PNG',5546,250,250,8,'Hwa Chong Junior College',105466,'Art60214','20040915133636','0','BITMAP','image','png',0,'oh6wdw93gcf4ddrzaoddfnsgtant6je'),(1863,'Inferior-frontal-gyrus.png','20040917125455!Inferior_frontal_gyrus.png',38767,300,190,8,'inferior frontal gyrus of the human brain',97339,'Jimhutchins','20040916134316','0','BITMAP','image','png',0,'q6tlay88w16bdyowr7ln9yu29xihf9x'),(1864,'Hubblescheme.png','20040917153321!Hubblescheme.png',10646,800,400,8,'{{cc-sa}} A tuning-fork diagram of the Hubble galaxy classification scheme',43566,'Xerxes314','20040917150401','0','BITMAP','image','png',0,'85zl66op5lyr3inct5xj2jv0mosbk3p'),(1865,'Hubblescheme.png','20040917154630!Hubblescheme.png',11374,800,400,8,'{{cc-sa}} now with transparency',43566,'Xerxes314','20040917153325','0','BITMAP','image','png',0,'oq8qo5fozy7svvbrezxko5lykxd2oh7'),(1866,'Hubblescheme.png','20040917155845!Hubblescheme.png',44228,1600,800,8,'{{cc-sa}} now more legible',43566,'Xerxes314','20040917154640','0','BITMAP','image','png',0,'kbn2vohfqmo5cenash32yqpcxy3vadz'),(1867,'Jeanne-2004-Track.gif','20040917181348!Jeanne_2004_Track.gif',36936,895,716,8,'As of 11am EDT September 16',55077,'Keith Edkins','20040916164451','0','BITMAP','image','gif',0,'21bqpxz7gth44wzyfrhk8o4s35pucbo'),(1868,'Darwin-family-tree-v1.png','20040917190313!Darwin_family_tree_v1.png',6468,615,375,8,'uploaded a cropped version of the diagram',5364,'Lexor','20040610143318','0','BITMAP','image','png',0,'obkgpd8m1pbv2317dgxxaig96poce1n'),(1869,'Cow-and-Calf-rocks.jpg','20040917221637!Cow_and_Calf_rocks.jpg',220652,1600,1200,8,'Cow and Calf Rocks, Ilkley, Yorkshire',9238,'Jschwa1','20040917221511','0','BITMAP','image','jpeg',0,'ql23p3z9e2b4urfpcc5bdijsujhpspd'),(1870,'Vim.png','20040917230801!Vim.png',54272,628,636,8,'Screenshot of graphical vim (gvim).',72287,'Ehamberg','20040530004803','0','BITMAP','image','png',0,'25s021tgz1o560vrr9z1z2od3ngb85y'),(1871,'Axial-flow-compressor.png','20040918041157!Axial-flow-compressor.png',14725,620,441,8,'smaller filesize',3499,'Branko','20040430230004','0','BITMAP','image','png',0,'4hjmeia4xqyo7pncly7fiy5j22no240'),(1872,'Axial-flow-compressor.png','20040918041528!Axial-flow-compressor.png',5683,620,441,4,'reduced used colors to 10',87057,'Deelkar','20040918041200','0','BITMAP','image','png',0,'tpyd5hbe4oehkha380wpy2t6kxsszkd'),(1873,'Axial-flow-compressor.png','20040918041641!Axial-flow-compressor.png',5683,620,441,4,'reduced used colors to 8',87057,'Deelkar','20040918041531','0','BITMAP','image','png',0,'tpyd5hbe4oehkha380wpy2t6kxsszkd'),(1874,'Axial-flow-compressor.png','20040918043928!Axial-flow-compressor.png',5609,620,441,4,'now actually reduced used colors to 8, enhanced visibility of airflow arrows',87057,'Deelkar','20040918041644','0','BITMAP','image','png',0,'jbp6mdylwpuody9aes4kpp9tkjppm6p'),(1875,'Captain%20America.jpg','20040918052524!Captain%20America.jpg',40034,344,600,8,'http://keymi3.free.fr/Vengeurs%20&%20Fantastic%20Four/Captain%20America.jpg',72961,'Donar','20040918052315','',NULL,'unknown','unknown',0,''),(1876,'Dingdongling.gif','20040918141154!Dingdongling.gif',16992,260,155,7,'Photo self-taken in 2002',70570,'Hardouin','20040918140839','0','BITMAP','image','gif',0,'dd1y6rm6xsedhtkeebkmy9jyjygoesq'),(1877,'Bf-map-with-San-Salvador.png','20040918160907!Bf-map_with_San_Salvador.png',10846,330,355,8,'',55077,'Keith Edkins','20040902122339','0','BITMAP','image','png',0,'ts99c8pbe3e2su1yk76as4iwnuzute6'),(1878,'Honolulu-Catholic-Cemetery-5.jpg','20040919010051!Honolulu_Catholic_Cemetery_5.jpg',342293,768,1024,8,'Honolulu Catholic Cemetery Picture taken and uploaded by [[User:Aloysius Patacsil]] {{GFDL}}',90001,'Aloysius Patacsil','20040919010018','a:28:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:7:\"DSC-P10\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:09:18 14:46:23\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/1000\";s:7:\"FNumber\";s:5:\"56/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:09:18 12:01:58\";s:17:\"DateTimeDigitized\";s:19:\"2004:09:18 12:01:58\";s:22:\"CompressedBitsPerPixel\";s:3:\"4/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"48/16\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:15;s:11:\"FocalLength\";s:5:\"79/10\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'ljs7dx7kuk3o7qus4w1xg3isxik5xp9'),(1879,'Honolulu-Catholic-Cemetery-7.jpg','20040919010357!Honolulu_Catholic_Cemetery_7.jpg',294779,768,1024,8,'Honolulu Catholic Cemetery Picture taken and uploaded by [[User:Aloysius Patacsil]] {{GFDL}}',90001,'Aloysius Patacsil','20040919010324','a:28:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:7:\"DSC-P10\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:09:18 14:48:37\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/2000\";s:7:\"FNumber\";s:5:\"56/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:09:18 11:50:31\";s:17:\"DateTimeDigitized\";s:19:\"2004:09:18 11:50:31\";s:22:\"CompressedBitsPerPixel\";s:3:\"4/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"48/16\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"79/10\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'3x67x8ht2zucvj6ibb3drmt2azab327'),(1880,'Honolulu-Catholic-Cemetery-7.jpg','20040919010520!Honolulu_Catholic_Cemetery_7.jpg',294779,768,1024,8,'Honolulu Catholic Cemetery Picture taken and uploaded by [[User:Aloysius Patacsil]] {{GFDL}}',90001,'Aloysius Patacsil','20040919010403','a:28:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:7:\"DSC-P10\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:09:18 14:48:37\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/2000\";s:7:\"FNumber\";s:5:\"56/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:09:18 11:50:31\";s:17:\"DateTimeDigitized\";s:19:\"2004:09:18 11:50:31\";s:22:\"CompressedBitsPerPixel\";s:3:\"4/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"48/16\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"79/10\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'3x67x8ht2zucvj6ibb3drmt2azab327'),(1881,'L21-30receptacle-proc.jpg','20040919192529!L21-30receptacle_proc.jpg',94400,1068,1875,8,'L21-30 receptacle',62535,'Glogger','20040919042658','0','BITMAP','image','jpeg',0,'ekxqf77b60metufm8hwb4y37cwvzjcw'),(1882,'7Q5.jpg','20040920150240!7Q5.jpg',134158,879,1230,8,'Fragment 5 from Cave 7 of the Qumran Community',82938,'Smoothmoniker','20040629235944','0','BITMAP','image','jpeg',0,'1t7kuaafl6u48o162uckwxk1q8nfpwn'),(1883,'Pan-moon.jpg','20040920175205!Pan_moon.jpg',89083,499,499,8,'Pan Moon 2004-07-01 as seen from the Cassini space probe. Image credit: NASA/JPL/Space Science Institute http://www.nasa.gov/mission_pages/cassini/multimedia/conf0701-pia06085.html modified from the original content to emphasize the moon Pan.',83248,'Supercoop','20040702200053','0','BITMAP','image','jpeg',0,'mvj3qfp86rjx5wiboqaa82vanqb2uwm'),(1884,'Catholic-Cemetery-006.jpg','20040920200228!Catholic_Cemetery_006.jpg',1508003,0,0,0,'Catholic Cemetery 006.jpg.  Headstone of Msgr. Ropert in the Catholic Cemetry on King Street, Honolulu.  Photograph taken by user Aloysius Patacsil on September 17, 2004.  {| align=center border=0 cellpadding=4 cellspacing=4 style=\"border: 1px solid #CC9;',90001,'Aloysius Patacsil','20040918024220','0','BITMAP','image','jpeg',0,'oe4ykxmkiengcf55bf77m5l4su176yk'),(1885,'Alexa-reach-measurement-for-wikipedia.png','20040920214730!Alexa_reach_measurement_for_wikipedia.png',2956,480,328,4,'Proper version for 14-sep-04  :-P',88976,'Kbh3rd','20040914140948','0','BITMAP','image','png',0,'h8r7nxtm2k5o99eiml0r7uvp0u47ae4'),(1886,'Alexa-reach-measurement-for-wikipedia.png','20040920215218!Alexa_reach_measurement_for_wikipedia.png',0,0,0,0,'to 17 September 2004',88976,'Kbh3rd','20040920214740','0','BITMAP','image','png',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(1887,'Alexa-traffic-ranking-for-wikipedia.png','20040920215814!Alexa_traffic_ranking_for_wikipedia.png',2365,432,240,8,'to 9-sept-04',88976,'Kbh3rd','20040909023356','0','BITMAP','image','png',0,'4xvrgnlaovd3qx6d1849mhsup4y9l63'),(1888,'Uic.jpg','20040921022048!Uic.jpg',71667,300,225,8,'uic building',107710,'Carpeuterum','20040921021900','a:32:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:19:\"Canon PowerShot A70\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:09:20 21:21:34\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:6:\"1/1000\";s:7:\"FNumber\";s:5:\"32/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:08:19 11:12:20\";s:17:\"DateTimeDigitized\";s:19:\"2004:08:19 11:12:20\";s:22:\"CompressedBitsPerPixel\";s:3:\"5/1\";s:17:\"ShutterSpeedValue\";s:6:\"319/32\";s:13:\"ApertureValue\";s:6:\"107/32\";s:16:\"MaxApertureValue\";s:5:\"95/32\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:6:\"173/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"2048000/208\";s:21:\"FocalPlaneYResolution\";s:11:\"1536000/156\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:1;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:9:\"2048/2048\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'muy5hrqi8yh9kuew0m3e371cs253lkq'),(1889,'Uic.jpg','20040921022206!Uic.jpg',95311,500,375,8,'uic building',107710,'Carpeuterum','20040921022053','a:32:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:19:\"Canon PowerShot A70\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:09:20 21:25:11\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:6:\"1/1000\";s:7:\"FNumber\";s:5:\"32/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:08:19 11:12:20\";s:17:\"DateTimeDigitized\";s:19:\"2004:08:19 11:12:20\";s:22:\"CompressedBitsPerPixel\";s:3:\"5/1\";s:17:\"ShutterSpeedValue\";s:6:\"319/32\";s:13:\"ApertureValue\";s:6:\"107/32\";s:16:\"MaxApertureValue\";s:5:\"95/32\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:6:\"173/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"2048000/208\";s:21:\"FocalPlaneYResolution\";s:11:\"1536000/156\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:1;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:9:\"2048/2048\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'16gsrhsea6ij3l23xb70sb2t6rkgbtg'),(1890,'Pertweejon.jpg','20040921030503!Pertweejon.jpg',26970,150,182,8,'fixed apsect ratio',42385,'Lupin','20040417115648','0','BITMAP','image','jpeg',0,'7dnodbkcyokgs7856umq6vu6v1l5c9d'),(1891,'Kettlewell-scarecrow.jpg','20040921232049!Kettlewell_scarecrow.jpg',217736,1017,1635,8,'A scarecrow in Kettlewell in the Yorkshire Dales.  Photo taken 3 August 2004.',102856,'Johnteslade','20040921231846','a:23:{s:16:\"ImageDescription\";s:31:\"OLYMPUS DIGITAL CAMERA         \";s:4:\"Make\";s:23:\"OLYMPUS OPTICAL CO.,LTD\";s:5:\"Model\";s:16:\"C720UZ          \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"144/1\";s:11:\"YResolution\";s:5:\"144/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:8:\"DateTime\";s:19:\"2004:09:22 00:18:43\";s:12:\"ExposureTime\";s:4:\"1/50\";s:7:\"FNumber\";s:5:\"34/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:200;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:08:03 17:06:03\";s:17:\"DateTimeDigitized\";s:19:\"2004:08:03 17:06:03\";s:17:\"ExposureBiasValue\";s:4:\"7/10\";s:16:\"MaxApertureValue\";s:7:\"300/100\";s:12:\"MeteringMode\";i:3;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:8:\"5120/100\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'oyzb55n8x61e8mh5y2ynvq4ie5x64t1'),(1892,'Dog1.jpg','20040921232127!Dog1.jpg',27054,600,579,8,'',20505,'Jurriaan Schulman','20031120203456','0','BITMAP','image','jpeg',0,'n9bzkjjwc4aw2uufl0kd73ghnnmow3k'),(1893,'Jeanne-2004-Track.gif','20040922015011!Jeanne_2004_Track.gif',37954,895,716,8,'As at 11am Sept 17th',55077,'Keith Edkins','20040917181352','0','BITMAP','image','gif',0,'mwsr4xiflxurrx72myj0gcc0gkeuq0p'),(1894,'Go-board.jpg','20040922020402!Go_board.jpg',50073,578,344,8,'Reverted to earlier revision',96368,'Funkyj','20040901185453','0','BITMAP','image','jpeg',0,'ak49xtiwbhtpv6784ik6ci9gmd4tz47'),(1895,'Go-board.jpg','20040922020439!Go_board.jpg',48248,600,317,8,'Reverted to earlier revision',80653,'Tordek ar','20040922020403','0','BITMAP','image','jpeg',0,'czy70q9pposo6ev9yh491wj52893cjg'),(1896,'Jeanne-2004-Track.gif','20040922092901!Jeanne_2004_Track.gif',33999,895,716,8,'2004-09-21 5pm EDT',82329,'Moverton','20040922015033','0','BITMAP','image','gif',0,'dlh8tfv5nbx2a41bifymzd4k4wzbsm4'),(1897,'Jeanne-2004-Track.gif','20040922093023!Jeanne_2004_Track.gif',4967,157,117,5,'As at 5am Sept 22',55077,'Keith Edkins','20040922092905','0','BITMAP','image','gif',0,'feqr2smk0ukcb2ii8tm8cd4c3zbptej'),(1898,'Jeanne-2004-Track.gif','20040923001657!Jeanne_2004_Track.gif',34689,895,716,8,'Oops, wrong scale!',55077,'Keith Edkins','20040922093029','0','BITMAP','image','gif',0,'bjlgz0fs5jgu0vwuoj775qer2gpl6iy'),(1899,'Wikipedia-onthe-web.png','20040923014609!Wikipedia-onthe-web.png',2811,432,240,8,'Updated to 1 September 2004',88976,'Kbh3rd','20040901034716','0','BITMAP','image','png',0,'dphi6p1dysvsuilf1hyvi106rioh6kj'),(1900,'Jeanne-2004-Track.gif','20040923030716!Jeanne_2004_Track.gif',35882,895,716,8,'As of Sept 22, 2004, 5PM',101464,'TristanG','20040923001659','0','BITMAP','image','gif',0,'pdevvw5adrm8tc2of9d1yxoc3jlufvp'),(1901,'Jeanne-2004-Track.gif','20040923091737!Jeanne_2004_Track.gif',35882,895,716,8,'{{PD-USGov}}  Source: [http://www.weather.gov The National Weather Service]',30614,'Jxg','20040923030726','0','BITMAP','image','gif',0,'pdevvw5adrm8tc2of9d1yxoc3jlufvp'),(1902,'Carlos-Maria-Alvear.jpg','20040923093034!Carlos_Maria_Alvear.jpg',7662,107,147,8,'From [http://www.todo-argentina.net/biografias/Personajes/carlos_maria_de_alvear.htm]. PD by age.',34978,'Lupo','20040923092800','0','BITMAP','image','jpeg',0,'hfkbvm8c3wrpdm18dji1jpyv72tdanf'),(1903,'Jeanne-2004-Track.gif','20040923153518!Jeanne_2004_Track.gif',26426,895,716,8,'As at 4am CDT Sept 23',55077,'Keith Edkins','20040923092209','0','BITMAP','image','gif',0,'mr1i1cqghjofmfzpbe7m4zvml6r8ddc'),(1904,'Pale-blue-dot-is-fast-asleep.jpg','20040923235720!Pale_blue_dot_is_fast_asleep.jpg',49361,640,480,8,'Picture of user ``` getting some z\'s.',60874,'Pale blue dot','20040609152720','a:37:{s:4:\"Make\";s:8:\"FUJIFILM\";s:5:\"Model\";s:14:\"FinePix2650   \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"1998:12:31 22:53:18\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/600\";s:7:\"FNumber\";s:7:\"350/100\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2002:08:13 01:54:14\";s:17:\"DateTimeDigitized\";s:19:\"2002:08:13 01:54:14\";s:22:\"CompressedBitsPerPixel\";s:5:\"20/10\";s:17:\"ShutterSpeedValue\";s:7:\"600/100\";s:13:\"ApertureValue\";s:7:\"360/100\";s:17:\"ExposureBiasValue\";s:5:\"0/100\";s:16:\"MaxApertureValue\";s:7:\"360/100\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:25;s:11:\"FocalLength\";s:8:\"1430/100\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:6:\"2462/1\";s:21:\"FocalPlaneYResolution\";s:6:\"2462/1\";s:24:\"FocalPlaneResolutionUnit\";i:3;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"SceneCaptureType\";i:0;s:9:\"Sharpness\";i:0;s:20:\"SubjectDistanceRange\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'tbjrt97v3dckmlp07ngg4tuie48e1wa'),(1905,'Pale-blue-dot-is-fast-asleep.jpg','20040924003110!Pale_blue_dot_is_fast_asleep.jpg',207856,1280,960,8,'Photoshopped version of this picture',60874,'Pale blue dot','20040923235734','a:37:{s:4:\"Make\";s:8:\"FUJIFILM\";s:5:\"Model\";s:14:\"FinePix2650   \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:09:22 17:18:58\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/600\";s:7:\"FNumber\";s:7:\"350/100\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2002:08:13 01:54:14\";s:17:\"DateTimeDigitized\";s:19:\"2002:08:13 01:54:14\";s:22:\"CompressedBitsPerPixel\";s:5:\"20/10\";s:17:\"ShutterSpeedValue\";s:7:\"600/100\";s:13:\"ApertureValue\";s:7:\"360/100\";s:17:\"ExposureBiasValue\";s:5:\"0/100\";s:16:\"MaxApertureValue\";s:7:\"360/100\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:25;s:11:\"FocalLength\";s:8:\"1430/100\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:6:\"2462/1\";s:21:\"FocalPlaneYResolution\";s:6:\"2462/1\";s:24:\"FocalPlaneResolutionUnit\";i:3;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"SceneCaptureType\";i:0;s:9:\"Sharpness\";i:0;s:20:\"SubjectDistanceRange\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'9qmrnoytsctyc5pxtkun5h2jizrv9g9'),(1906,'Melbourne-map.png','20040924005622!Melbourne_map.png',85473,538,699,8,'Map of Melbourne, Australia',102344,'CloudSurfer','20040923231615','0','BITMAP','image','png',0,'asd8axoluvar6js0utjwfp26ib7vpln'),(1907,'Nicoheroin.JPG','20040924021251!Nicoheroin.JPG',49325,500,481,8,'Nico  ',65016,'Curtsurly','20040924014409','0','BITMAP','image','jpeg',0,'o9yimglz66ffkkdg0xvt7t7hqkehnmv'),(1908,'Nicoheroin.JPG','20040924021410!Nicoheroin.JPG',41178,500,481,8,'Nico',65016,'Curtsurly','20040924021309','0','BITMAP','image','jpeg',0,'i47purgov6a7cz23g57v72v8wwa83e5'),(1909,'Nicoheroin.JPG','20040924021510!Nicoheroin.JPG',49325,500,481,8,'Reverted to earlier revision',65016,'Curtsurly','20040924021410','0','BITMAP','image','jpeg',0,'o9yimglz66ffkkdg0xvt7t7hqkehnmv'),(1910,'Nicoheroin.JPG','20040924021932!Nicoheroin.JPG',49325,500,481,8,'Reverted to earlier revision',65016,'Curtsurly','20040924021510','0','BITMAP','image','jpeg',0,'o9yimglz66ffkkdg0xvt7t7hqkehnmv'),(1911,'Rotunda.jpg','20040924022649!Rotunda.jpg',20515,300,226,8,'Reverted to earlier revision',18998,'ElmoHoo','20040902224127','0','BITMAP','image','jpeg',0,'fljchfjgfmy5x2s8tl2i29j0niz799y'),(1912,'Melbourne-map.png','20040924032400!Melbourne_map.png',86494,538,699,8,'Reverted to earlier revision',102344,'CloudSurfer','20040924011031','0','BITMAP','image','png',0,'4a8go64onbajcqmh23fny12oz46ce9i'),(1913,'Jeanne-2004-Track.gif','20040924062126!Jeanne_2004_Track.gif',37760,895,716,8,'',39067,'Awolf002','20040923153534','0','BITMAP','image','gif',0,'rqppehfqwup1nk8728lmln8aht9enqy'),(1914,'Jeanne-2004-Track.gif','20040924091111!Jeanne_2004_Track.gif',41283,895,716,8,'As at 11pm Sept 23',55077,'Keith Edkins','20040924062140','0','BITMAP','image','gif',0,'q42grefy4zeab9b880xzkid6hjegxuy'),(1915,'Usenet-posts-containing-the-word-Wikipedia.png','20040924154510!Usenet_posts_containing_the_word_Wikipedia.png',2778,480,328,4,'Graph of Usenet posts containing the word Wikipedia',88976,'Kbh3rd','20040901161937','0','BITMAP','image','png',0,'pmi7t0dv9vgxqbaghc4dpzx63qjzcse'),(1916,'Rotunda.jpg','20040924164701!Rotunda.jpg',18282,248,165,8,'Reverted to earlier revision',91912,'Omnibus','20040924022649','0','BITMAP','image','jpeg',0,'3avwf5ldggcto0gwaui5wha2nb4ck0r'),(1917,'Ackermann.png','20040924174636!Ackermann.png',3887,354,60,8,'image for main page with [[Ackermann function]] <br>{{PD}}',42385,'Lupin','20040716100322','0','BITMAP','image','png',0,'8fulllk5pu5pg9mu5gq8kxdwr1vqb96'),(1918,'Rotunda.jpg','20040924194307!Rotunda.jpg',13139,200,147,8,'Reverted to earlier revision',91912,'Omnibus','20040924164703','0','BITMAP','image','jpeg',0,'kw8uww8k01ea2i8qpw5nrpk2ie2p9qe'),(1919,'Jeanne-2004-Track.gif','20040924211258!Jeanne_2004_Track.gif',42680,895,716,8,'As at 5am Sept 24',55077,'Keith Edkins','20040924091114','0','BITMAP','image','gif',0,'k8s85nfm06ka2ckqr5dyb5md6vuwwf7'),(1920,'Jeanne-2004-Track.gif','20040925103356!Jeanne_2004_Track.gif',39092,895,716,5,'As at 5 pm 24 Sept',55077,'Keith Edkins','20040924211305','0','BITMAP','image','gif',0,'tkcc1pxgpfnzefa5plgosgyecwix3zn'),(1921,'Jeanne-2004-Track.gif','20040925154250!Jeanne_2004_Track.gif',43461,895,716,8,'Sept 25 5am',51464,'Golbez','20040925103359','0','BITMAP','image','gif',0,'o0g65yt7yvkp9rlt9w6aiuschxpvlao'),(1922,'Jeanne-2004-Track.gif','20040925212608!Jeanne_2004_Track.gif',43657,895,716,8,'As at 11am Sept 24',55077,'Keith Edkins','20040925154255','0','BITMAP','image','gif',0,'qoym2wt8f9zvv7okcxlp6lc8ghk08hp'),(1923,'LocationSerbiaAndMontenegro.png','20040926021612!LocationSerbiaAndMontenegro.png',6127,250,115,8,'Reverted to earlier revision',25556,'Vardion','20031116055549','0','BITMAP','image','png',0,'82wfazk54m96zy26a5bk9c07jloniw6'),(1924,'Jeanne-2004-Track.gif','20040926045634!Jeanne_2004_Track.gif',40667,895,716,5,'As of 17:00 Sep 25',91707,'Livajo','20040925212611','0','BITMAP','image','gif',0,'prj0v7qa3hys4fwj6qjm8u2wjakglwn'),(1925,'Ginza.png','20040926051109!Ginza.png',43118,656,487,8,'',70428,'Fg2','20040917102522','0','BITMAP','image','png',0,'czzccvhapkwway9j04i0a1yy0ee8j3o'),(1926,'Hanzomon.png','20040926051740!Hanzomon.png',45199,764,590,8,'With station numbers',70428,'Fg2','20040917111219','0','BITMAP','image','png',0,'4pxiynrodnz608d4njqz9f1mhf7zche'),(1927,'Beatles-singles-yesterday.jpg','20040926055652!Beatles-singles-yesterday.jpg',7729,130,130,8,'The US single cover for Yesterday',53685,'ChicXulub','20040327132851','0','BITMAP','image','jpeg',0,'emhjgpz57assxndsnk1mtw3ic5bsrog'),(1928,'Vvbyhour.png','20040926092641!Vvbyhour.png',3495,442,320,2,'first year!',18610,'VeryVerily','20040807051859','0','BITMAP','image','png',0,'21lfyjut795hksapjzmz6x8vb716ybc'),(1929,'Bliss-Carman.jpg','20040926145534!Bliss_Carman.jpg',25504,405,613,8,'Photo in the public domain',3376,'DW','20021206152713','0','BITMAP','image','jpeg',0,'n8o8qxec3hlzkibzy8yy5j0soqkmt6t'),(1930,'Jeanne-2004-Track.gif','20040926150632!Jeanne_2004_Track.gif',42301,895,716,8,'As of 23:00 Sep 25',91707,'Livajo','20040926045636','0','BITMAP','image','gif',0,'q9pa1up5zqb16xh4nrqav6cg5uwzb1x'),(1931,'Jeanne-2004-Track.gif','20040926212945!Jeanne_2004_Track.gif',40102,895,716,8,'As at 11am Sept 26',55077,'Keith Edkins','20040926150638','0','BITMAP','image','gif',0,'7sx7ivmdxod0pzda1ouv1b1linz5eko'),(1932,'Quasi-satellite.png','20040927063647!Quasi-satellite.png',109278,163,222,0,'Shows the orbit of a quasi-satellite.  I made it myself in Microsoft Paint.',70992,'Ultrarob','20040531234944','0','BITMAP','image','x-bmp',0,'cgd7jptd6pay98c0dmxryhcj2dxzqce'),(1933,'Jeanne-2004-Track.gif','20040927072429!Jeanne_2004_Track.gif',36595,895,716,5,'As of 17:00 Sep 26',91707,'Livajo','20040926212946','0','BITMAP','image','gif',0,'8m1hq63i1dutf12ls7gzbzj64l981dz'),(1934,'Jeanne-2004-Track.gif','20040927164200!Jeanne_2004_Track.gif',36249,895,716,5,'As of 23:00 Sep 26',91707,'Livajo','20040927072430','0','BITMAP','image','gif',0,'486ncekimmewdjz9nyudu0wwrah29eb'),(1935,'2ndPrinceChun2.jpg','20040927221512!2ndPrinceChun2.jpg',20572,250,308,8,'{PD}}',70570,'Hardouin','20040927221510','0','BITMAP','image','jpeg',0,'0hv4asz0dm60c1cd8agpsr6o1u0d6je'),(1936,'Samuel-francis-dupont-photo.gif','20040927235845!Samuel_francis_dupont_photo.gif',80829,603,384,0,'19th century photograph, [[Samuel Francis du Pont]]',29695,'Postdlf','20040927235554','0','BITMAP','image','gif',0,'41fyj234lbbc3zlv8vlfkczbb6kuqm7'),(1937,'Finches.jpg','20040928000656!Finches.jpg',116904,2048,1536,8,'I took this photo, and I release it under the GFDL.',57108,'Quadell','20040928000226','a:32:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:19:\"Canon PowerShot A70\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:09:27 10:00:33\";s:16:\"YCbCrPositioning\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:8:\"2048/832\";s:16:\"SceneCaptureType\";i:0;s:12:\"ExposureTime\";s:4:\"1/60\";s:7:\"FNumber\";s:5:\"48/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:09:27 10:00:33\";s:17:\"DateTimeDigitized\";s:19:\"2004:09:27 10:00:33\";s:22:\"CompressedBitsPerPixel\";s:3:\"3/1\";s:17:\"ShutterSpeedValue\";s:6:\"189/32\";s:13:\"ApertureValue\";s:6:\"145/32\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:6:\"145/32\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:89;s:11:\"FocalLength\";s:6:\"519/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"5040127/208\";s:21:\"FocalPlaneYResolution\";s:11:\"3780095/156\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'6wrsnu7fuwblxgy494da7m119lpp6zg'),(1938,'Shwgunkmap.jpg','20040928022354!Shwgunkmap.jpg',34469,432,444,8,'Map of Shawangunks (red) in relation to other areas. Map mad eby [[User:Latitude0116|Latitude0116]]',62617,'Latitude0116','20040928021506','0','BITMAP','image','jpeg',0,'2k4ijb80xzr52pqpbrm03pa0k0vmfe6'),(1939,'Chu-bus0002.jpg','20040928041142!Chu-bus0002.jpg',21966,200,150,8,'{{GFDL}}',74463,'Ã?£','20040928040402','0','BITMAP','image','jpeg',0,'s3pbp12wztcso5budzfoiv8yp3iuzdv'),(1940,'Map-of-Ukraine-Donezk.png','20040928221743!Map_of_Ukraine_Donezk.png',258145,709,495,8,'Donezk Oblast',56649,'Steschke','20040928200411','0','BITMAP','image','png',0,'4x15ej8kfug2yk9a368ksxvq6p3pz9y'),(1941,'Melbourne-map.png','20040929024918!Melbourne_map.png',67858,539,680,8,'',102344,'CloudSurfer','20040924032447','0','BITMAP','image','png',0,'hvcce1flmche87jk07h5pmd8ubjhdw8'),(1942,'NurembergTrials.jpg','20040929030902!NurembergTrials.jpg',27807,400,312,8,'compressed version',7279,'Minesweeper','20030504102347','0','BITMAP','image','jpeg',0,'l6s1guecpmq52znzaonv5gvpaylhnf8'),(1943,'Cursus.png','20040929041545!Cursus.png',30122,627,404,8,'correcting preexisting figure',8201,'Muriel Gottrop','20030901104316','0','BITMAP','image','png',0,'hnt3qzk13ayw355gl50yc2u68zcx61b'),(1944,'Cursus.png','20040929041745!Cursus.png',35601,627,405,8,'Reverted to earlier revision',65016,'Curtsurly','20040929041546','0','BITMAP','image','png',0,'6um1eai88pytnwq836y51ca6zfpqsc8'),(1945,'Warlords1.png','20040930003114!Warlords1.png',1400,320,205,8,'{{fairuse}} <br> Screenshot of Warlords for Atari 2600',63286,'Bumm13','20040930002420','0','BITMAP','image','png',0,'kq68alqbebibja9pa0rzzznn2g8q13q'),(1946,'Warlords1.png','20040930003745!Warlords1.png',1400,320,205,8,'{{screenshot}} <br> Screenshot of Warlords for Atari 2600',63286,'Bumm13','20040930003213','0','BITMAP','image','png',0,'kq68alqbebibja9pa0rzzznn2g8q13q'),(1947,'Warlords1.png','20040930003836!Warlords1.png',1400,320,205,8,'Reverted to earlier revision',63286,'Bumm13','20040930003747','0','BITMAP','image','png',0,'kq68alqbebibja9pa0rzzznn2g8q13q'),(1948,'Portugal-complete.png','20040930014023!Portugal_complete.png',41130,359,308,8,'{{GFDL}} made by [[user:PedroPVZ]]',30470,'PedroPVZ','20040930012949','0','BITMAP','image','png',0,'633df5zshwur8crxi0jj1vsmhy46wtl'),(1949,'MN-def.png','20040930040113!MN_def.png',2541,250,130,8,'Drawn by [[User:Nanshu|Nanshu]]. {{GFDL}}',7930,'Nanshu','20040904034836','0','BITMAP','image','png',0,'j5mgqktwypzz6kmrvr1wdrenme78wt3'),(1950,'MN-Ulaanbaatar.png','20040930040743!MN_Ulaanbaatar.png',2569,250,130,8,'Drawn by [[User:Nanshu|Nanshu]]. {{GFDL}}',7930,'Nanshu','20040904035541','0','BITMAP','image','png',0,'dccx2bofq1blqkftg6on9jda606ibff'),(1951,'User-mrweeble.jpg','20040930202730!User_mrweeble.jpg',28314,470,453,8,'A pic for my user page',22475,'MrWeeble','20040613181638','0','BITMAP','image','jpeg',0,'6snney2qwsetu1ne569pu1osytkk9k6'),(1952,'MontrealExpos-100.png','20040930210406!MontrealExpos_100.png',19006,100,100,8,'clean up',19009,'Ed g2s','20040724205515','0','BITMAP','image','png',0,'surifbvgvcbkwrmmrbgvhd8ezp0hilw'),(1953,'Franklinwolinseal.png','20040930215603!Franklinwolinseal.png',12507,190,175,8,'Seal of the Franklin W. Olin College of Engineering',34673,'Dan83','20031216041255','0','BITMAP','image','png',0,'soja8wko4e4xe1qr4e0dk4hgoidwvn6'),(1954,'Africa-four-rail-triple-gauge.png','20041001145339!Africa_four_rail_triple_gauge.png',4754,436,146,8,'Four rail, triple gauge (proposed African system) diagram. Created from [[CombinedTrack.jpg]].',49236,'Zoney','20040915101017','0','BITMAP','image','png',0,'mrgky02kxnt3avuanaelnunlguc7l7g'),(1955,'Alexa-reach-measurement-for-wikipedia.png','20041001211523!Alexa_reach_measurement_for_wikipedia.png',3531,480,328,8,'Try again: up to 17 September 2004.  Last upload didn\'t work?',88976,'Kbh3rd','20040920215225','0','BITMAP','image','png',0,'q62fkkvvspmxekvipns2mcpfk1yqa75'),(1956,'Alexa-reach-rank-measurement-for-wikipedia.png','20041001212506!Alexa_reach_rank_measurement_for_wikipedia.png',2434,432,240,8,'Chart of Alexa Reach Rank measurement for Wikipedia.org',88976,'Kbh3rd','20041001211714','0','BITMAP','image','png',0,'k3g0irtpsofo4r1b5309brvjhaulyda'),(1957,'Alexa-traffic-ranking-for-wikipedia.png','20041001212831!Alexa_traffic_ranking_for_wikipedia.png',2373,432,240,8,'to 20 September 2004',88976,'Kbh3rd','20040920215826','0','BITMAP','image','png',0,'l9nx3t7mjbsvtddsibp51gg08xvak88'),(1958,'Google-Answers-using-Wikipedia.png','20041001212942!Google_Answers_using_Wikipedia.png',2972,432,240,8,'Updated to august 04',88976,'Kbh3rd','20040901035614','0','BITMAP','image','png',0,'rmyzufa7hnygv6x5k6nwb2p86gr3cht'),(1959,'Google-News-stories-mentioning-Wikipedia.png','20041001213020!Google_News_stories_mentioning_Wikipedia.png',2804,432,240,8,'August, 2004 stat',88976,'Kbh3rd','20040901033852','0','BITMAP','image','png',0,'lb130fng7hz7yti0kyx75608ujfn7tn'),(1960,'More-specific-Usenet-posts-containing-the-word-Wikipedia.png','20041001213228!More_specific_Usenet_posts_containing_the_word_Wikipedia.png',4167,480,328,8,'Usenet posts containing either wikipedia.org or wikipedia.com',88976,'Kbh3rd','20040902175907','0','BITMAP','image','png',0,'q7xc2wjb43kwomy2hnoa7ds82f1uu9v'),(1961,'Usenet-posts-containing-the-word-Wikipedia.png','20041001213350!Usenet_posts_containing_the_word_Wikipedia.png',3030,480,328,8,'Regenerated using corrected stats from Donar Reiskoffer',88976,'Kbh3rd','20040924154546','0','BITMAP','image','png',0,'dbmjzjvalccpker4de4hyy9bnuhdqer'),(1962,'Wikipedia-onthe-web.png','20041001213415!Wikipedia-onthe-web.png',2658,432,240,8,'fixed vertical scale',88976,'Kbh3rd','20040923014619','0','BITMAP','image','png',0,'9q7ks63qlup9f7seim9bdzd34cb0u6s'),(1963,'Lollywood-Billboards---Prince-Cinema-Budha-Bigra-Jaye-Billboard.JPG','20041001223507!Lollywood_Billboards_-_Prince_Cinema_Budha_Bigra_Jaye_Billboard.JPG',66351,640,480,8,'Movie Billboard at Prince Cinema in Lahore, Pakistan of the movie Budha Bigra Jaye (Dirty Old Man)',60874,'Pale blue dot','20041001222745','a:26:{s:16:\"ImageDescription\";s:8:\"Sunplus \";s:4:\"Make\";s:8:\"Sunplus \";s:5:\"Model\";s:8:\"Spca533 \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:10:01 08:20:28\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/8333\";s:7:\"FNumber\";s:5:\"30/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2002/02/16 22:14:53\";s:17:\"DateTimeDigitized\";s:19:\"2002/02/16 22:14:53\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:6:\"128/10\";s:16:\"MaxApertureValue\";s:7:\"317/100\";s:12:\"MeteringMode\";i:2;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:7:\"968/100\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'ecgxrvrah7ob12k8bf8697ccrterm99'),(1964,'Lollywood-Billboards---Prince-Cinema-Budha-Bigra-Jaye-Billboard.JPG','20041001223659!Lollywood_Billboards_-_Prince_Cinema_Budha_Bigra_Jaye_Billboard.JPG',68967,640,480,8,'Photoshopped Version',60874,'Pale blue dot','20041001223519','a:26:{s:16:\"ImageDescription\";s:8:\"Sunplus \";s:4:\"Make\";s:8:\"Sunplus \";s:5:\"Model\";s:8:\"Spca533 \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:10:01 15:34:18\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/8333\";s:7:\"FNumber\";s:5:\"30/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2002/02/16 22:14:53\";s:17:\"DateTimeDigitized\";s:19:\"2002/02/16 22:14:53\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:6:\"128/10\";s:16:\"MaxApertureValue\";s:7:\"317/100\";s:12:\"MeteringMode\";i:2;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:7:\"968/100\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'07ej40mozgyax8nbs7vu1s16xrrevpd'),(1965,'Lollywood-Billboards---Prince-Cinema-Budha-Bigra-Jaye-Billboard.JPG','20041001224035!Lollywood_Billboards_-_Prince_Cinema_Budha_Bigra_Jaye_Billboard.JPG',65157,640,480,8,'Improved Compression of this image',60874,'Pale blue dot','20041001223711','a:26:{s:16:\"ImageDescription\";s:8:\"Sunplus \";s:4:\"Make\";s:8:\"Sunplus \";s:5:\"Model\";s:8:\"Spca533 \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:10:01 15:34:18\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/8333\";s:7:\"FNumber\";s:5:\"30/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2002/02/16 22:14:53\";s:17:\"DateTimeDigitized\";s:19:\"2002/02/16 22:14:53\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:6:\"128/10\";s:16:\"MaxApertureValue\";s:7:\"317/100\";s:12:\"MeteringMode\";i:2;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:7:\"968/100\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'dsppc01xvjgb5jo5pqgmjxsw86tbx52'),(1966,'Tasmania-satellite-image.png','20041002134110!Tasmania_satellite_image.png',304764,829,902,8,'Tasmania - satellite Image (screen shot taken from World Winds program by NASA)',3861,'Chuq','20041002133612','0','BITMAP','image','png',0,'nqczqi8kdczz26y6l8zxquhms3otfbc'),(1967,'1959089-Aldermaston.jpg','20041002172711!1959089-Aldermaston.jpg',269493,901,603,8,'View of the village of Aldermaston, Berkshire, England circa 1959 ',111377,'Oldfarm','20041002170510','0','BITMAP','image','jpeg',0,'ag620k1me7slybis8sdulgyperxeavz'),(1968,'Flock-of-Canada-geese.jpg','20041002213417!Flock_of_Canada_geese.jpg',2769872,2272,1704,8,'{{copyrightedFreeUse}}  from http://arglist.com/photos/verulamium_park_birds.html',47291,'Duncharris','20040924215056','a:32:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:22:\"Canon DIGITAL IXUS 400\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2003:11:12 14:02:56\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:5:\"1/320\";s:7:\"FNumber\";s:5:\"28/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2003:11:12 14:02:56\";s:17:\"DateTimeDigitized\";s:19:\"2003:11:12 14:02:56\";s:22:\"CompressedBitsPerPixel\";s:3:\"5/1\";s:17:\"ShutterSpeedValue\";s:6:\"266/32\";s:13:\"ApertureValue\";s:5:\"95/32\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:5:\"95/32\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:6:\"237/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"2272000/280\";s:21:\"FocalPlaneYResolution\";s:11:\"1704000/210\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:1;s:16:\"DigitalZoomRatio\";s:9:\"2272/2272\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'2ajwhpx78c4zmr1gpyuxx32nv8wxiu9'),(1969,'Flock-of-Canada-geese.jpg','20041002213829!Flock_of_Canada_geese.jpg',219465,1815,1296,8,'Reupload of Canada Geese with 2.7MB cut down to 214K',7095,'Arpingstone','20041002213424','0','BITMAP','image','jpeg',0,'il4yrsnsz0r8gtlmlahrb3u9xmd85bv'),(1970,'Australia-locator-SA.png','20041003085831!Australia_locator_SA.png',9962,210,196,8,'Australia locator map - SA {{gfdl}}',3861,'Chuq','20041003034324','0','BITMAP','image','png',0,'emx4ghbakvuqzsdnp4z9rk4aqja4zy0'),(1971,'Australia-locator-ACT.png','20041003090158!Australia_locator_ACT.png',44255,938,878,8,'{{gfdl}}',3861,'Chuq','20041003085734','0','BITMAP','image','png',0,'5nag6f3rfd4h1du3mhnpfly23t23z9x'),(1972,'Coffee-Krups.jpg','20041003093701!Coffee-Krups.jpg',66239,1164,1164,8,'A small Krups coffee machine.',91761,'Pjf','20041003091611','0','BITMAP','image','jpeg',0,'jo0rerfq7hkcjnkwk6wuqpgira298jo'),(1973,'UserSilverfish.JPG','20041003153144!UserSilverfish.JPG',976239,1232,1840,8,'A picture of me',10903,'Silverfish','20041003151252','a:14:{s:4:\"Make\";s:25:\"FUJI PHOTO FILM CO., LTD.\";s:5:\"Model\";s:7:\"SP-1500\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:12:\"720000/10000\";s:11:\"YResolution\";s:12:\"720000/10000\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:37:\"FDi V4.5 / FRONTIER350/370-5.8-0E-650\";s:8:\"DateTime\";s:19:\"2003:08:28 10:37:49\";s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"    :  :     :  :  \";s:17:\"DateTimeDigitized\";s:19:\"2003:08:28 10:37:49\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'cc707bjsygjvu0x9fv26wlv55i3pnea'),(1974,'MD-Road-Rash.png','20041003220100!MD_Road_Rash.png',8504,320,240,8,'screenshot [[Sega Genesis]] [[Road_Rash]] by me {{screenshot}}',107001,'Tyan23','20041003214209','0','BITMAP','image','png',0,'ktbcoynioh5cvfhdbvygc6dszmzrnl1'),(1975,'JapaneseLicensePlateDwg.png','20041004085954!JapaneseLicensePlateDwg.png',50339,640,322,8,'{{GFDL}}',70428,'Fg2','20040829054050','0','BITMAP','image','png',0,'4a233fvnh1h0oelulnmvj905kphxh8g'),(1976,'St-helens-landslide.jpg','20041004093353!St_helens_landslide.jpg',79717,640,480,8,'Dust from landslides in Mt St Helens crater, taken from Castle Lake Viewpoint 2 Oct 2004 about 5:00pm',5094,'Llywrch','20041003041300','a:32:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:21:\"Canon PowerShot S1 IS\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:10:02 16:57:22\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:5:\"1/800\";s:7:\"FNumber\";s:5:\"45/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:10:02 16:57:22\";s:17:\"DateTimeDigitized\";s:19:\"2004:10:02 16:57:22\";s:22:\"CompressedBitsPerPixel\";s:3:\"3/1\";s:17:\"ShutterSpeedValue\";s:6:\"309/32\";s:13:\"ApertureValue\";s:6:\"139/32\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:6:\"104/32\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:10:\"17270/1000\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:10:\"640000/208\";s:21:\"FocalPlaneYResolution\";s:10:\"480000/156\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:9:\"2048/2048\";s:16:\"SceneCaptureType\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'ran9eubiamsgcjb8c7dddzlapq09u54'),(1977,'StHelensOct12004Eruption.jpg','20041004093451!StHelensOct12004Eruption.jpg',5489,308,231,8,'Mt. St. Helens, October 1, 2004 eruption',103137,'BalooUrsidae','20041001230151','0','BITMAP','image','jpeg',0,'acgo0p17x16tyr5kzq33xe25g45gb7e'),(1978,'NewZealandElectorates2002-Labeled.png','20041004100301!NewZealandElectorates2002-Labeled.png',34281,596,604,8,'Map of the 2002 New Zealand elections',25556,'Vardion','20041003081938','0','BITMAP','image','png',0,'i1tpsnk7zvd826vigqyaclhc868ulrt'),(1979,'NewZealandElectorates2002-Labeled.png','20041004101122!NewZealandElectorates2002-Labeled.png',34278,596,604,8,'fixing typo - Waimakariri',25556,'Vardion','20041004100705','0','BITMAP','image','png',0,'h2kq9nx0ty0nj1wmmbazd9fu345fqdo'),(1980,'Omeprazole.png','20041004140832!Omeprazole.png',2435,288,120,8,'molecular structure of omeprazole {{GFDL}}',38684,'Techelf','20040912083054','0','BITMAP','image','png',0,'6npjl4kil8qea3dzu71jxal2ahpr7rd'),(1981,'Sugarhouseobelisk.jpg','20041004190946!Sugarhouseobelisk.jpg',33276,469,1101,8,'obelisk at 2100 S 1100 E SLC UT by JonMoore {{GFDL}}',13747,'JonMoore','20040909200834','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"200/1\";s:11:\"YResolution\";s:5:\"200/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:8:\"DateTime\";s:19:\"2004:10:04 13:06:23\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'6m4j39i3d4b3e7j4ez3u9w9nvwzrf93'),(1982,'Rainiersourdoughridge.web.jpg','20041004230501!Rainiersourdoughridge.web.jpg',72141,681,402,8,'Mount Rainier resized',58781,'JoJan','20040924191101','0','BITMAP','image','jpeg',0,'62cxvpvzytmoi2pbaan7kmrpw5yxxve'),(1983,'Crossbow-diagram.png','20041005013407!Crossbow_diagram.png',24893,499,350,8,'crossbow diagram, by Xed',95934,'Xed','20040923102030','0','BITMAP','image','png',0,'kbpceau9w91xvkqllcxrxym53pgwk1s'),(1984,'Transport-title.png','20041005072330!Transport_title.png',25691,0,0,0,'Modified [[:Image:Steam Locomotive.jpg]]',49312,'Siroxo','20041005071926','',NULL,'unknown','unknown',0,''),(1985,'Transport-title.png','20041005072826!Transport_title.png',24215,175,124,8,'',49312,'Siroxo','20041005072337','0','BITMAP','image','png',0,'gyfyuji09zxci1iilw8g4jn8fpdp4y7'),(1986,'Fat%20Andy.jpg','20041005093522!Fat%20Andy.jpg',66412,356,631,8,'',113731,'Sk8erbobr','20041005093225','',NULL,'unknown','unknown',0,''),(1987,'Cirrostratus.jpg','20041005114155!Cirrostratus.jpg',1084238,1816,1188,8,'Cirrostratus',99065,'Fir0002','20041005113058','0','BITMAP','image','jpeg',0,'rapy4t7heaafwcai1g0kl7xhz86k1nt'),(1988,'Map-location-rockall.jpg','20041005124725!Map_location_rockall.jpg',84730,720,520,8,'Reverted to earlier revision',3295,'Mintguy','20041005123821','0','BITMAP','image','jpeg',0,'0bqvhsru7zkolsrfdqtry6iaqowc0ui'),(1989,'Generalhospital1994.jpg','20041005145345!Generalhospital1994.jpg',230454,320,240,0,'Granted permission by the GH Openings MSN group @ http://groups.msn.com/ghopenings. Fair use screenshot. {{fairuse}}',74099,'TheCustomOfLife','20040725004324','0','BITMAP','image','x-bmp',0,'beuxpkvycffv5c5zp5b4hl22cfry7zq'),(1990,'Map-location-rockall.jpg','20041005154317!Map_location_rockall.jpg',84730,720,520,8,'reverting image correctly',3295,'Mintguy','20041005124740','0','BITMAP','image','jpeg',0,'0bqvhsru7zkolsrfdqtry6iaqowc0ui'),(1991,'Ukraine-Luhans\'k-small.png','20041005204025!Ukraine_Luhans\'k_small.png',23834,367,514,8,'Small map of Luhans\'k',56649,'Steschke','20041005203649','0','BITMAP','image','png',0,'b3ybkn6r7vcbe3rmy1nvaf049sc4bhz'),(1992,'Ukraine-Cherkasy-small.png','20041005212112!Ukraine_Cherkasy_small.png',23270,259,232,8,'Small map of Cherkasy',56649,'Steschke','20041005201030','0','BITMAP','image','png',0,'5f757xppx3co9q84g654vwiknre9uef'),(1993,'Map-location-rockall.jpg','20041005221033!Map_location_rockall.jpg',162717,720,520,8,'Reverted to earlier revision',80775,'Metron','20041005154317','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:08:17 17:41:22\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'rlxi8trnopuitfbydjoib7uhcievur2'),(1994,'Rock-Against-Bush,-Vol.-2.jpg','20041006002407!Rock_Against_Bush,_Vol._2.jpg',13497,200,201,8,'{{fairuse}}',96760,'Mike Garcia','20041006002327','0','BITMAP','image','jpeg',0,'kmi53ixmnwz26m4s4pczur1uzj2hixh'),(1995,'St-Andrews-church,-Summer-Hill,-NSW,-Australia.jpg','20041006104336!St_Andrews_church,_Summer_Hill,_NSW,_Australia.jpg',294983,1632,1232,8,'Photo I took of St Andrews Church, in Summer Hill, NSW, Australia {{GFDL}}',94904,'Nickj','20041006103648','a:37:{s:4:\"Make\";s:21:\"EASTMAN KODAK COMPANY\";s:5:\"Model\";s:27:\"KODAK CX4200 DIGITAL CAMERA\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"230/1\";s:11:\"YResolution\";s:5:\"230/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"Version 1.0100 \";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:12:\"2074/1000000\";s:7:\"FNumber\";s:7:\"450/100\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:10:06 14:57:42\";s:17:\"DateTimeDigitized\";s:19:\"2004:10:06 14:57:42\";s:22:\"CompressedBitsPerPixel\";s:7:\"296/100\";s:17:\"ShutterSpeedValue\";s:7:\"891/100\";s:13:\"ApertureValue\";s:7:\"433/100\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:7:\"433/100\";s:12:\"MeteringMode\";i:2;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:7:\"600/100\";s:10:\"ColorSpace\";i:1;s:13:\"ExposureIndex\";s:5:\"100/1\";s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:4:\"0/10\";s:21:\"FocalLengthIn35mmFilm\";i:39;s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:20:\"SubjectDistanceRange\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'hu3or8ltd8bsa3dl0buehj4u3aauqeb'),(1996,'Brzozow-county-PL.png','20041006145911!Brzozow_county_PL.png',5946,200,231,4,'',105988,'Fqsik','20040925180910','0','BITMAP','image','png',0,'q2qxcg5goaaaz3ks9czlk17udat9iyt'),(1997,'32X-Virtua-Fighter.png','20041006224125!32X_Virtua_Fighter.png',7795,320,240,8,'screenshot [[32X]] [[Virtua_Fighter]], made myself. {{screenshot}}',107001,'Tyan23','20041006222401','0','BITMAP','image','png',0,'62en6a9znzfvfwbrfhdmsnxjv8j75hq'),(1998,'Lycopene.png','20041007072129!Lycopene.png',1527,714,48,8,'Chemical structure of lycopene (smaller than previous)',51395,'Delta G','20040406232626','0','BITMAP','image','png',0,'tpgmiiua5tk3x3x4av13xmwk00b761b'),(1999,'PRC-Expressway-ExitSign-New.jpg','20041007105755!PRC_Expressway_ExitSign_New.jpg',108670,639,480,8,'{{GFDL}} Chinese expressway exit sign (new). DF08 2004 image.',75080,'DF08','20040921122147','a:26:{s:4:\"Make\";s:6:\"CAMERA\";s:5:\"Model\";s:7:\"3MP-9F6\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:13:\"4718592/65536\";s:11:\"YResolution\";s:13:\"4718592/65536\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"QuickTime 6.5.1\";s:8:\"DateTime\";s:19:\"2004:09:21 20:14:51\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"1/1000\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:07:16 02:28:05\";s:17:\"DateTimeDigitized\";s:19:\"2004:07:16 02:28:05\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ShutterSpeedValue\";s:4:\"10/1\";s:13:\"ApertureValue\";s:3:\"3/1\";s:17:\"ExposureBiasValue\";s:3:\"0/2\";s:16:\"MaxApertureValue\";s:3:\"3/1\";s:12:\"MeteringMode\";i:2;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:7:\"996/100\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'fexrooke3daeiok6csxry1mw8dcrqmb'),(2000,'Crude-EU28.png','20041007161350!Crude-EU28.png',2334,262,160,2,'Added Croatia to [[:Image:Crude-EU27.png]]',30200,'Sverdrup','20040626103534','0','BITMAP','image','png',0,'qpmqoaky01j2r7v5y1v1vj28kzpr4hu'),(2001,'Crude-EU28.png','20041007171417!Crude-EU28.png',2271,262,160,2,'since in all likelihood bg and ro will join before hr, colored them darker',20318,'Joy','20041007161356','0','BITMAP','image','png',0,'mucf6ukfg7wg0goul42kh6yortyu5gw'),(2002,'CFA-map.jpg','20041007212816!CFA_map.jpg',20153,283,232,8,'modified version of [[:Image:Africa-western-countries.png]] {{GFDL}}',1591,'SimonP','20041007212247','0','BITMAP','image','jpeg',0,'nvkvfibf9gmb5bhhpldvw6gw73v8dbg'),(2003,'IndiaNumbered1.png','20041008011119!IndiaNumbered1.png',58104,300,365,8,'An alternative to the current map, redrawn by me.',77506,'Simonides','20041007134608','0','BITMAP','image','png',0,'bh9nqds7sez9e71j3qnmi8svk7ijuso'),(2004,'MichelineBernardini.jpg','20041008130838!MichelineBernardini.jpg',6245,140,235,8,'Micheline Bernardini',69644,'Michael L. Kaufman','20040627063453','0','BITMAP','image','jpeg',0,'il3mb87nehk2o1ng417eg7w60wem8j4'),(2005,'Dietcoke.jpg','20041008173756!Dietcoke.jpg',55041,600,800,8,'http://pdphoto.org/PictureDetail.php?mat=pdef&pg=7623 <br>{{msg:pd}}',42385,'Lupin','20040324203905','0','BITMAP','image','jpeg',0,'o7m7ktg69yox58pf73ykgcxd0hgw2ku'),(2006,'Circle-1.png','20041009002912!Circle-1.png',7521,250,250,8,'diagram of a circle',2251,'DrBob','20030827011350','0','BITMAP','image','png',0,'mpc1enpif7865bymj8x76ylfiv9ubka'),(2007,'Diodebridge4.png','20041009005359!Diodebridge4.png',6097,370,180,8,'Slightly updated version of diode bridge diagram, {{msg:GFDL}}',2251,'DrBob','20040308154940','0','BITMAP','image','png',0,'5zh45pmmis7x38bslgepb51rj23f77a'),(2008,'Hene-1.png','20041009005513!Hene-1.png',11170,600,168,8,'Diagram of a helium-neon laser',2251,'DrBob','20031125190043','0','BITMAP','image','png',0,'bipyk0j3ogr7lb8e8e2mtojyk5lj9j6'),(2009,'Hene-2.png','20041009005537!Hene-2.png',11851,320,320,8,'Energy level diagram of a helium-neon laser',2251,'DrBob','20031125190115','0','BITMAP','image','png',0,'j1k9fvcil3por3zwg4juo31ixu1d74s'),(2010,'Hermite-gaussian.png','20041009005557!Hermite-gaussian.png',35303,350,268,8,'bug fixed version',2251,'DrBob','20040310004543','0','BITMAP','image','png',0,'pt45yiv60huby4u3cp9yczwbrxz8eac'),(2011,'Laguerre-gaussian.png','20041009005617!Laguerre-gaussian.png',29854,350,287,8,'Laguerre-Gaussian transverse mode patterns {{msg:GFDL}}',2251,'DrBob','20040309224210','0','BITMAP','image','png',0,'0im3qpffvbjaluyeoxwjpjwrnmu3tff'),(2012,'Lasercons.png','20041009005640!Lasercons.png',11535,480,222,8,'Schematic diagram of a Nd:YAG laser, for [[laser construction]].',2251,'DrBob','20031203221114','0','BITMAP','image','png',0,'lf09ffmdrm55tbnsxsj9j036zymfo2l'),(2013,'Modelock-1.png','20041009005654!Modelock-1.png',12426,350,448,8,'Cavity mode diagram, for [[modelocking]]',2251,'DrBob','20031121175344','0','BITMAP','image','png',0,'hna4t58i8t1s6s17vom0uumo66kf60n'),(2014,'ABERR3.png','20041009010251!ABERR3.png',7469,400,239,4,'Aberration in optical systems; from the 1911 encyclopaedia; {{subst:PD}}',2251,'DrBob','20040315211313','0','BITMAP','image','png',0,'iy79qu15jy6yqixtwzdlghulehwbm1x'),(2015,'ABERR4.png','20041009010309!ABERR4.png',18041,400,201,4,'Aberration in optical systems; from the 1911 encyclopaedia; {{subst:PD}}',2251,'DrBob','20040315211403','0','BITMAP','image','png',0,'m74rpkwufecue155zlf93ywk2mc9ewa'),(2016,'ABERR5.png','20041009010353!ABERR5.png',8762,400,149,4,'Aberration in optical systems; from the 1911 encyclopaedia; {{subst:PD}}',2251,'DrBob','20040315211459','0','BITMAP','image','png',0,'4zmcdrnqgq50w6h2gn7kdpw12z8fjvp'),(2017,'ABERR6.png','20041009010421!ABERR6.png',41200,400,547,4,'Aberration in optical systems; from the 1911 encyclopaedia; {{subst:PD}}',2251,'DrBob','20040315211537','0','BITMAP','image','png',0,'jgpegln50bflajf5f5ebhvt0t7pvubc'),(2018,'Czerny-turner.png','20041009010619!Czerny-turner.png',26024,600,372,8,'Cerny-Turner monochromator; {{msg:GFDL}}',2251,'DrBob','20040323205131','0','BITMAP','image','png',0,'k59h569sgi0uesbs16omk16fxv7fbf1'),(2019,'Porro-prism.png','20041009010933!Porro-prism.png',8589,250,260,8,'Porro prism; {{msg:GFDL}}',2251,'DrBob','20040316221515','0','BITMAP','image','png',0,'l13kgcyxuxjzlw62wir9hejn6pt9fzm'),(2020,'Dichroic-prism.png','20041009011346!Dichroic-prism.png',12457,300,291,8,'slightly clearer version, fixed tiny optical error',2251,'DrBob','20040408210146','0','BITMAP','image','png',0,'t81mv5ndrm9fuyo82cf3fij5s3go852'),(2021,'Etalon-2.png','20041009011426!Etalon-2.png',9117,350,250,8,'Etalon transmission plot {{GFDL}}',2251,'DrBob','20040618194159','0','BITMAP','image','png',0,'0xjr8j4agnr1jxx2soe2mpwkpws86dv'),(2022,'Optical-coating-1.png','20041009011502!Optical-coating-1.png',6537,250,198,8,'Reflection and transmission coefficients of an optical coating {{msg:GFDL}}',2251,'DrBob','20040414005918','0','BITMAP','image','png',0,'a100yih3xif0hribsahex58hfs4qlhb'),(2023,'Optical-coating-2.png','20041009011518!Optical-coating-2.png',10428,300,299,8,'Interference in a lambda/4 coating',2251,'DrBob','20040414010013','0','BITMAP','image','png',0,'0k6mpjuq68hzqqlcyoamw7fjiibzk2m'),(2024,'InternationalExaminerlogo.png','20041009025215!InternationalExaminerlogo.png',2478,319,60,8,'International Examiner logo. {{fairuse}}. from http://www.iexaminer.org/',10642,'Lukobe','20040716202438','0','BITMAP','image','png',0,'a966mk6ydmcdilfd520awz0ytgk0mmo'),(2025,'InternationalExaminerlogo.png','20041009025524!InternationalExaminerlogo.png',2478,319,60,8,'Made smoother',13476,'Dcoetzee','20041009025256','0','BITMAP','image','png',0,'a966mk6ydmcdilfd520awz0ytgk0mmo'),(2026,'Australia-map.png','20041009033715!Australia_map.png',57950,330,354,8,'Australia - Outline map with coastline, borders, major and regional cities {{gfdl}}',3861,'Chuq','20041003053240','0','BITMAP','image','png',0,'cfce30z3jxcdv4sc2tzy2nzdyi0z4cm'),(2027,'St-george-staten-island.jpg','20041009034333!St_george_staten_island.jpg',26110,640,427,8,'{{GFDL}}',47523,'FriedMilk','20041009033654','a:6:{s:4:\"Make\";s:25:\"Pure Digital Technologies\";s:5:\"Model\";s:22:\"legends | EA4043303434\";s:8:\"Software\";s:53:\"2_7_CVS_RC7 (server #104) | ip=V2.7 delivery 08/03/04\";s:16:\"DateTimeOriginal\";s:19:\"2004:10:08 17:27:58\";s:5:\"Flash\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'0eklmt8718xo730pgd5qx005o3h4amm'),(2028,'Ellipse.png','20041009102331!Ellipse.png',2883,510,310,8,'Ellipse with annotations and axes',45336,'Wikibob','20040426161535','0','BITMAP','image','png',0,'4g2unax458fd69t2uy2ewnrdehecrua'),(2029,'Pyramid-lake-pah-rah.jpg','20041009190232!Pyramid_lake_pah_rah.jpg',84343,1597,480,8,'Pyramid Lake as seen from the Pah Rah Range',33188,'Toiyabe','20041009185746','0','BITMAP','image','jpeg',0,'8pjzfefh62shrqgjf59uc6lyi5fpyw5'),(2030,'Fefe-Dobson-(album).png','20041009191924!Fefe_Dobson_(album).png',135694,274,260,8,'{{albumcover}}',68411,'Neutrality','20041009191824','0','BITMAP','image','png',0,'s1ts5iv2x9eb6t0paqbv0kfbe7t8mfx'),(2031,'Fefe-Dobson-(album).png','20041009192035!Fefe_Dobson_(album).png',216854,295,300,8,'{{albumcover}}',68411,'Neutrality','20041009191933','0','BITMAP','image','png',0,'gdt9ujpuh66e6596fioawkjhqmjkad4'),(2032,'Franklinwolinseal.png','20041009221621!Franklinwolinseal.png',33712,190,175,8,'',104988,'L33tminion','20040930215612','0','BITMAP','image','png',0,'bblk4hl7ooba3i0lqyl0kxl30v89jbt'),(2033,'Unknown-flower-q1.jpg','20041009224825!Unknown_flower_q1.jpg',1148674,2048,1536,8,'Photo by [[user:Quadell|Quadell]] {{gfdl}}',57108,'Quadell','20041009224546','a:32:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:19:\"Canon PowerShot A70\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:09:27 08:02:39\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:4:\"1/60\";s:7:\"FNumber\";s:5:\"48/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:09:27 08:02:39\";s:17:\"DateTimeDigitized\";s:19:\"2004:09:27 08:02:39\";s:22:\"CompressedBitsPerPixel\";s:3:\"3/1\";s:17:\"ShutterSpeedValue\";s:6:\"189/32\";s:13:\"ApertureValue\";s:6:\"145/32\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:6:\"145/32\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:89;s:11:\"FocalLength\";s:6:\"519/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"2048000/208\";s:21:\"FocalPlaneYResolution\";s:11:\"1536000/156\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:9:\"2048/2048\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'m4cs2b363hwabdbh760osmhmhw6r08u'),(2034,'Lubaczow-County-DivisionPL.png','20041010085011!Lubaczow_County_DivisionPL.png',4782,250,222,4,'{{GFDL}}',105988,'Fqsik','20041010084641','0','BITMAP','image','png',0,'1ghkpnmvv1rpndvf2i7dq7epplkbiox'),(2035,'Marblemadnessscreenshot.png','20041010122148!Marblemadnessscreenshot.png',8820,336,240,8,'screenshot from the game [[Marble Madness]] ',10903,'Silverfish','20040817123153','0','BITMAP','image','png',0,'1hid6323bfofmz0cucvmag0xjbrhv21'),(2036,'ColonialAfrica.png','20041010190118!ColonialAfrica.png',8476,276,347,8,'Turned [[:Image:Colafrica.jpg]] of [[User:J.J.]] into png which is a more proper format for this.',85484,'Aris Katsaris','20040815100054','0','BITMAP','image','png',0,'p9fr5drghcr6ozqw82wakypsnr9g9rj'),(2037,'ColonialAfrica.png','20041010213727!ColonialAfrica.png',7219,276,323,8,'coorect and error',1591,'SimonP','20041010190127','0','BITMAP','image','png',0,'5kjmhjypraidb2a7dznt3kzmzm9jyas'),(2038,'Elbflorenz.jpg','20041010224623!Elbflorenz.jpg',87575,400,267,8,'The elberiver at night, photo copy allowed by elbflorenz.com',63090,'NetgutuDD','20040426185121','a:15:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:8:\"DateTime\";s:19:\"2004:04:26 20:47:09\";s:16:\"DateTimeOriginal\";s:19:\"2003:12:12 08:54:38\";s:17:\"DateTimeDigitized\";s:19:\"2003:12:12 08:54:38\";s:17:\"ExposureBiasValue\";s:6:\"0/1000\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'qikg916igigtjtc6vwyge41991qo36d'),(2039,'High-Altitude-Low-Opening-(HALO)-jump-at-McChord-AFB-981130.jpg','20041011000628!High_Altitude_Low_Opening_(HALO)_jump_at_McChord_AFB_981130.jpg',86556,1078,800,8,'High Altitude Low Opening (HALO) jump at McChord AFB',35996,'Maio','20040111103638','0','BITMAP','image','jpeg',0,'bsgvfxelqt2ya8faq4rtr46cyvdobef'),(2040,'Aimee-Mann---Bachelor-No.-2.jpg','20041011035652!Aimee_Mann_-_Bachelor_No._2.jpg',6792,200,200,8,'[[Category:album covers]] Aimee Mann - Bachelor No. 2 album cover',110766,'DCEdwards1966','20041011035444','0','BITMAP','image','jpeg',0,'e41wb7540ndryavdsln50t35y5vzz62'),(2041,'Meades-ranch.png','20041011233443!Meades_ranch.png',4237,422,359,4,'Location of Meades Ranch geodetic base point (NAD27)',88976,'Kbh3rd','20041011212826','0','BITMAP','image','png',0,'omkvsglsqd2o3yhcr4e3nvh0uv5rnlk'),(2042,'Meades-ranch.png','20041011235055!Meades_ranch.png',4877,422,273,4,'Whole 48 states shown',88976,'Kbh3rd','20041011233446','0','BITMAP','image','png',0,'g48g8551686cyaatbukeha28grmz01x'),(2043,'Meades-ranch.png','20041012000314!Meades_ranch.png',7882,422,273,8,'better coloring',88976,'Kbh3rd','20041011235058','0','BITMAP','image','png',0,'iflxr12smuyx6anbgiqej8qduwassib'),(2044,'Ethnic-groups-in-the-United-Kingdom-graph.png','20041012022103!Ethnic_groups_in_the_United_Kingdom_graph.png',16929,704,364,8,'Created by me in [[Microsoft Excel]]. {{GFDL}}',68411,'Neutrality','20041012021415','0','BITMAP','image','png',0,'57kbclmtwtrsekyf9mjrwxiozjkyhy2'),(2045,'Ethnic-groups-in-the-United-Kingdom-graph.png','20041012022112!Ethnic_groups_in_the_United_Kingdom_graph.png',13021,443,331,8,'{{GFDL}}',68411,'Neutrality','20041012022105','0','BITMAP','image','png',0,'74ylsbd914vcsorlo8gkgknroj7etqi'),(2046,'Ethnic-groups-in-the-United-Kingdom-graph.png','20041012022139!Ethnic_groups_in_the_United_Kingdom_graph.png',16929,704,364,8,'Reverted to earlier revision',68411,'Neutrality','20041012022112','0','BITMAP','image','png',0,'57kbclmtwtrsekyf9mjrwxiozjkyhy2'),(2047,'Bomber-Scale-chart-1.jpg','20041012023239!Bomber_Scale-chart_1.jpg',144338,1332,1680,8,'I created this drawing myself, using paper, pen, etc.  There are \'\'\'\'\'no\'\'\'\'\' copyright issues',71699,'Karl Dickman','20040816040724','0','BITMAP','image','jpeg',0,'iszrb50jp0i8kcwzbccfc59avrjfl27'),(2048,'Tysfjord-orca-1.jpg','20041012193915!Tysfjord_orca_1.jpg',64654,1054,481,8,'(C) 2002 [[User:Pcb21]] - licensed to Wikipedia under the GFDL. Please contact about the availability of hi-res images.',7320,'Pcb21','20040302195944','0','BITMAP','image','jpeg',0,'pflfbe1podavtnwb9qtp4a1igb2oe87'),(2049,'Dyna-Soar-launchers.png','20041012200721!Dyna_Soar_launchers.png',76498,540,720,8,'Proposed X-20 Dynasoar launch vehicles.',38428,'Reubenbarton','20040701215930','0','BITMAP','image','png',0,'24ky5uwhk3rjavk9s4dbhjpnhigrq6q'),(2050,'Australia-map.png','20041013002348!Australia_map.png',22130,330,354,8,'Map of [[Australia]]. {{PD-USGov-CIA-WF}}',68411,'Neutrality','20041009033719','0','BITMAP','image','png',0,'cfce30z3jxcdv4sc2tzy2nzdyi0z4cm'),(2051,'CliffordAlgebra-01.png','20041013054820!CliffordAlgebra-01.png',1795,133,120,8,'commutative diagram for [[Clifford algebra]]',43429,'Fropuff','20041013053011','0','BITMAP','image','png',0,'smsw3bqslzgietfpdgspbrdfo8k9rv6'),(2052,'Satellite-image-of-Adelaide-South-Australia.jpg','20041013110621!Satellite_image_of_Adelaide_South_Australia.jpg',17160,136,340,8,'Satellite image of Adelaide South Australia, including the outer areas still considered part of Adelaide proper. Taken from a hi-res shot of South Australia. Referred to street, directory, road atlas and my own knowledge of the street layout from Taxi Dri',105919,'Diceman','20041013095349','a:7:{s:11:\"Orientation\";i:1;s:8:\"Software\";s:27:\"ACD Systems Digital Imaging\";s:8:\"DateTime\";s:19:\"2004:10:13 19:08:47\";s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:10:\"SubSecTime\";s:3:\"586\";s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'0gcnds29oih4xmicdvej76p6s3xk4e2'),(2053,'Satellite-image-of-Adelaide-South-Australia.jpg','20041013110844!Satellite_image_of_Adelaide_South_Australia.jpg',17543,136,340,8,'',105919,'Diceman','20041013110630','a:7:{s:11:\"Orientation\";i:1;s:8:\"Software\";s:27:\"ACD Systems Digital Imaging\";s:8:\"DateTime\";s:19:\"2004:10:13 20:26:11\";s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:10:\"SubSecTime\";s:3:\"664\";s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'day798a5fetaba6tmsjsxdhh4fqa1aw'),(2054,'Bosom-pad.png','20041013195220!Bosom_pad.png',122609,1578,2164,4,'{{PD}}  U. S. patent no. 404881',9397,'Haabet','20041013194128','0','BITMAP','image','png',0,'5flh5fxegaq56mrzkmhvqmteyajnvdx'),(2055,'PSX-Ridge-Racer.png','20041013220303!PSX_Ridge_Racer.png',24738,320,240,8,'screenshot [[PSX]] [[Ridge Racer]], made by me {{screenshot}}',107001,'Tyan23','20041013192025','0','BITMAP','image','png',0,'3c9xjwhhy868cjmqocmzxh1ou6wq3br'),(2056,'13-colonies-present-boundaries.png','20041013220341!13-colonies-present-boundaries.png',63075,283,500,8,'{{GFDL}} Derived from {PD-USGov} Image:National-atlas-blank-state-outlines.png',12028,'Jengod','20041013215850','0','BITMAP','image','png',0,'7rkq679nh1tab3zxski3t1egys6yw8x'),(2057,'Alexa-reach-measurement-for-wikipedia.png','20041014014932!Alexa_reach_measurement_for_wikipedia.png',3538,480,328,8,'up to date',88976,'Kbh3rd','20041001211525','0','BITMAP','image','png',0,'hqamb68zczjjuejg7p8v4z0jsuqv7hf'),(2058,'Country-positions-Iraq-war.png','20041014021925!Country_positions_Iraq_war.png',88390,1357,628,8,'country positions 2003 Iraq war',49019,'Get-back-world-respect','20040910144739','0','BITMAP','image','png',0,'oig7uw7uo0wja2htcx8tygsit5e3ck0'),(2059,'Jingbao.jpg','20041014092649!Jingbao.jpg',16653,227,422,8,'The cover of Jingbao in Ching Dynasty',111062,'0101YUENyp','20041014091847','0','BITMAP','image','jpeg',0,'nfhnvxmwrg74lcn3oi5rd6275ptjygs'),(2060,'Norwich-terrier-kacy.jpg','20041014142545!Norwich_terrier_kacy.jpg',138168,640,480,8,'I took this picture of my dog, Kacy, and she is very close to breed standard.  {{CopyrightedFreeUseProvided}}',84395,'DavidBarak','20040728201757','a:35:{s:4:\"Make\";s:5:\"NIKON\";s:5:\"Model\";s:5:\"E2200\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:14:\"19660800/65536\";s:11:\"YResolution\";s:14:\"19660800/65536\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"QuickTime 6.5.1\";s:8:\"DateTime\";s:19:\"2004:07:08 22:53:14\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/601\";s:7:\"FNumber\";s:5:\"42/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:144;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:07:08 15:19:17\";s:17:\"DateTimeDigitized\";s:19:\"2004:07:08 15:19:17\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"28/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:25;s:11:\"FocalLength\";s:6:\"116/10\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:5:\"0/100\";s:21:\"FocalLengthIn35mmFilm\";i:89;s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:20:\"SubjectDistanceRange\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'1w5jv726lafr6b7zisk21xygcapdity'),(2061,'InsideAssemblyhall.jpg','20041014175411!InsideAssemblyhall.jpg',47782,650,442,8,'Insides Assembly Hall in Salt Lake City, Utah. Taken by me in 2002. {{GFDL}}',48455,'BigBen212','20040612193723','0','BITMAP','image','jpeg',0,'i9o9wc9ubjze54edacdci3yssg81cp6'),(2062,'Benítez-logo.png','20041014225346!Benítez_logo.png',14670,170,74,8,'',9351,'Lmb','20040401231547','0','BITMAP','image','png',0,'8vop4mtn6bvs0hv83vc2js99okn4czm'),(2063,'Government-Center-Boston-vista.jpg','20041014225454!Government_Center_Boston_vista.jpg',109482,787,525,8,'View of Government Center, Boston',69060,'KeithTyler','20041014221909','a:16:{s:4:\"Make\";s:21:\"Eastman Kodak Company\";s:5:\"Model\";s:39:\"Kodak CLAS Digital Film Scanner / HR200\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:17:\"536870912/2097152\";s:11:\"YResolution\";s:17:\"536870912/2097152\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:32:\"Kodak Digital Central Lab System\";s:8:\"DateTime\";s:19:\"1999:09:10 13:08:20\";s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0200\";s:17:\"DateTimeDigitized\";s:19:\"1999:09:10 13:08:20\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:16:\"296484864/262144\";s:21:\"FocalPlaneYResolution\";s:16:\"296484864/262144\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'i3fzzwdbpd6wlfjeib7swppm4r6698m'),(2064,'Government-Center-Boston-vista.jpg','20041014225559!Government_Center_Boston_vista.jpg',86321,787,525,8,'',69060,'KeithTyler','20041014225458','a:16:{s:4:\"Make\";s:21:\"Eastman Kodak Company\";s:5:\"Model\";s:39:\"Kodak CLAS Digital Film Scanner / HR200\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:17:\"536870912/2097152\";s:11:\"YResolution\";s:17:\"536870912/2097152\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:32:\"Kodak Digital Central Lab System\";s:8:\"DateTime\";s:19:\"1999:09:10 13:08:20\";s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0200\";s:17:\"DateTimeDigitized\";s:19:\"1999:09:10 13:08:20\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:16:\"296484864/262144\";s:21:\"FocalPlaneYResolution\";s:16:\"296484864/262144\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'bubzgrs7r54xl5sr1ybuppuqasudg27'),(2065,'Sf-framing-bit.png','20041014235503!Sf_framing_bit.png',12117,824,239,8,'Made this myself.  {{GFDL}}.  This diagrams a DS1 frame.  See the DS1 Page.',110125,'Awolsoldier','20041014234653','0','BITMAP','image','png',0,'ajmmmhfnocexjb47o47c4ko8qp5kzpl'),(2066,'Dred-Scott.jpg','20041015073833!Dred_Scott.jpg',86797,350,427,8,'',21013,'Raul654','20041013134259','0','BITMAP','image','jpeg',0,'fk6vfjhskzvya3hnlnwd23dqpukqqlj'),(2067,'Bairakgerb.jpg','20041015095737!Bairakgerb.jpg',9322,342,173,8,'The flag of the Chechen Republic of Ichkeria',99420,'Björn-Isak Rosendahl','20041015095610','0','BITMAP','image','jpeg',0,'d9c3yvj4qevihxh3ql1lq1ts4tkr580'),(2068,'Bairakgerb.jpg','20041015100355!Bairakgerb.jpg',9322,342,173,8,'The flag of the Chechen Republic of Ichkeria',99420,'Björn-Isak Rosendahl','20041015095822','0','BITMAP','image','jpeg',0,'d9c3yvj4qevihxh3ql1lq1ts4tkr580'),(2069,'Intel486.jpg','20041015151724!Intel486.jpg',53779,579,302,8,'Intel486',3937,'Vkem','20031125043701','0','BITMAP','image','jpeg',0,'fip59jn4um2pm3gdl5ctb646i66bak5'),(2070,'MyBloodyValentineLoveless.jpg','20041015203735!MyBloodyValentineLoveless.jpg',5161,200,200,8,'My Bloody Valentine \"Loveless\" album cover',8351,'TUF-KAT','20030314185708','0','BITMAP','image','jpeg',0,'tk4bxy4c8rxgw0ouoqhnehkyzs51qv2'),(2071,'230-Squadron-RAF.jpg','20041015211004!230_Squadron_RAF.jpg',116053,444,600,8,'{{CrownCopyright}} from www.rafmarham.co.uk',56128,'H1523702','20041015210839','0','BITMAP','image','jpeg',0,'13w1z4mmsijqnt74driyjdhmi4urs0o'),(2072,'Gray-square-illusion.png','20041016055917!Gray_square_illusion.png',111771,570,483,8,'Gray square illusion -- reproduction of [[Image:Optical.greysquares.arp.600pix.jpg]] in POV-Ray {{GFDL}}',14300,'Paul Stansifer','20041014210107','0','BITMAP','image','png',0,'8nk1h1rlnw4o3lc6gc1uwv5pelbmw48'),(2073,'Herb-Obojga-Narodow-small.jpg','20041016070603!Herb_Obojga_Narodow_small.jpg',37028,194,320,8,'smaller version of the [[:Image:Herb Obojga Narodow.jpg]] {{fairuse}}',32233,'Halibutt','20041016065859','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:8:\"DateTime\";s:19:\"2004:10:14 06:03:27\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'4fss4cq46y6x77mpfwd9kto0eh0heli'),(2074,'Herb-Obojga-Narodow-small.jpg','20041016070957!Herb_Obojga_Narodow_small.jpg',25865,194,320,8,'',32233,'Halibutt','20041016070613','0','BITMAP','image','jpeg',0,'jmkf82hvlt2wtt0hxtfktn3qopzkv2w'),(2075,'Herb-Obojga-Narodow-small.jpg','20041016071246!Herb_Obojga_Narodow_small.jpg',25435,194,320,8,'',32233,'Halibutt','20041016071007','0','BITMAP','image','jpeg',0,'b9gh3n044cxs6fw00nehdgeomqti842'),(2076,'NewZealandElectorates2002-Labeled.png','20041016082404!NewZealandElectorates2002-Labeled.png',34271,596,604,8,'fixing another typo - Waimakariri again',25556,'Vardion','20041004101130','0','BITMAP','image','png',0,'hjw6wibtarwjzqcggj69xh5atm5ixyt'),(2077,'America\'s-Army1.jpg','20041016210444!America\'s_Army1.jpg',31262,443,335,8,'',86580,'Zh','20041016210037','0','BITMAP','image','jpeg',0,'6cmr0ds6ncwsjog9s5tu7xsygrweoe7'),(2078,'Liang-Qichao4a.jpg','20041016222616!Liang_Qichao4a.jpg',8564,173,200,8,'{{PD}}',42891,'Spencer195','20041016222416','0','BITMAP','image','jpeg',0,'dxybegkjzskb9a4m4k5uik8hxwinl4f'),(2079,'Kult-title.png','20041016235136!Kult_title.png',12085,640,399,4,'Kult: Temple of the flying saucers title screenshot from Amiga version',16840,'Rvalles','20041016224614','0','BITMAP','image','png',0,'gop4vuhkobcibr4enr95ovj5mdu9faz'),(2080,'Canberra-lake-panorama01-JAC.jpg','20041017073622!Canberra-lake-panorama01_JAC.jpg',284277,4000,662,8,'Panorama od Lake Burley-Griffin from the centre of parliamentary triangle. Photgraph by John Conway, 2004. {{GFDL}}',118620,'Nyctopterus','20041016082258','0','BITMAP','image','jpeg',0,'5didzwha5q9xy1m0qe6wosrauhjuxew'),(2081,'Ffxmap.jpg','20041017074040!Ffxmap.jpg',94021,800,779,8,'Spira World Map',109967,'PiccoloNamek','20041017073520','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"150/1\";s:11:\"YResolution\";s:5:\"150/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2003:11:26 21:55:57\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'m4auw3exkzw6c5pe44p79ptinpckyue'),(2082,'Ffxmap.jpg','20041017074436!Ffxmap.jpg',94021,800,779,8,'Spira World Map',109967,'PiccoloNamek','20041017074043','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"150/1\";s:11:\"YResolution\";s:5:\"150/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2003:11:26 21:55:57\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'m4auw3exkzw6c5pe44p79ptinpckyue'),(2083,'Liang-Qichao.jpg','20041017091300!Liang_Qichao.jpg',8224,159,218,8,'Liang Qichao',111918,'0101WONGlh','20041017091033','0','BITMAP','image','jpeg',0,'2tnc9cs5qcme25e7fbfawb359z2op3t'),(2084,'Liang-Qichao.jpg','20041017091506!Liang_Qichao.jpg',8224,159,218,8,'Liang Qichao 1',111918,'0101WONGlh','20041017091306','0','BITMAP','image','jpeg',0,'2tnc9cs5qcme25e7fbfawb359z2op3t'),(2085,'HP-Blavatsky.jpg','20041017193710!HP_Blavatsky.jpg',32998,140,171,8,'hp_blavatsky',94977,'Stjack','20040819095040','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:08:19 01:38:49\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'mgy2gu576o2pzfifrqevjdnd5aj2w0s'),(2086,'HP-Blavatsky.jpg','20041017194205!HP_Blavatsky.jpg',32998,140,171,8,'Reverted to earlier revision',100588,'Alcidebava','20041017193710','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:08:19 01:38:49\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'mgy2gu576o2pzfifrqevjdnd5aj2w0s'),(2087,'Metrorail-Extensions.PNG','20041017233342!Metrorail_Extensions.PNG',30637,703,968,8,'',84161,'Johnnyjoe23','20041015211915','0','BITMAP','image','png',0,'iyoph6fokgbhhq5274bfiivhbjddpfe'),(2088,'Metrorail-Extensions.PNG','20041017233628!Metrorail_Extensions.PNG',30918,703,968,8,'',84161,'Johnnyjoe23','20041017233409','0','BITMAP','image','png',0,'77t94m87ayy1b0e6ah3o846b7z6982u'),(2089,'Metrorail-Extensions.PNG','20041017234058!Metrorail_Extensions.PNG',30637,703,968,8,'Reverted to earlier revision',84161,'Johnnyjoe23','20041017233628','0','BITMAP','image','png',0,'iyoph6fokgbhhq5274bfiivhbjddpfe'),(2090,'Metrorail-Extensions.PNG','20041017234112!Metrorail_Extensions.PNG',30918,703,968,8,'Reverted to earlier revision',84161,'Johnnyjoe23','20041017234058','0','BITMAP','image','png',0,'77t94m87ayy1b0e6ah3o846b7z6982u'),(2091,'M59-Resurrection.jpg','20041018044110!M59-Resurrection.jpg',18621,250,173,8,'From [http://www.neardeathstudios.com/]. {{fairuse}}',118008,'Defunkt','20041018043202','0','BITMAP','image','jpeg',0,'5c122sbvs3oxijmvvrkspr3k8px4fgp'),(2092,'VOR-on-sectional.gif','20041018061109!VOR_on_sectional.gif',83840,385,376,8,'Twentynine Palms VOR on the sectional chart',35839,'Rsduhamel','20041017203620','0','BITMAP','image','gif',0,'9llxiramos2qrj0u47xhhvjknb8g0yv'),(2093,'NewZealandElectorates1999-Labeled.png','20041018161618!NewZealandElectorates1999-Labeled.png',33721,596,604,8,'Map of the 1999 New Zealand elections',25556,'Vardion','20041018045427','0','BITMAP','image','png',0,'q8302jim30kg6vls05wuny8aeb8eqhx'),(2094,'KLM-Aircraft-at-Schiphol.jpg','20041018172129!KLM_Aircraft_at_Schiphol.jpg',384088,1400,1050,8,'KLM Aircraft at Schiphol',82826,'Solitude','20041016174922','0','BITMAP','image','jpeg',0,'hi0j3944xib6s1cx7ehcn1lk99qkvda'),(2095,'KLM-Aircraft-at-Schiphol.jpg','20041018173350!KLM_Aircraft_at_Schiphol.jpg',343709,1200,900,8,'enhanced',82826,'Solitude','20041018172247','0','BITMAP','image','jpeg',0,'dqwajpgsdbnx7xq4o7x16ra1t647hdi'),(2096,'Mlc4.JPG','20041018212608!Mlc4.JPG',10278,250,275,8,'created by jaxed',120005,'Jaxed','20041018212014','0','BITMAP','image','jpeg',0,'c6liw3b5jbqnu8hilea6jncubdftull'),(2097,'41-Squadron-RAF.jpg','20041018225445!41_Squadron_RAF.jpg',51293,217,300,8,'{{CrownCopyright}} from www.rafmarham.co.uk',56128,'H1523702','20041018225408','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:28:\"Adobe Photoshop Elements 2.0\";s:8:\"DateTime\";s:19:\"2004:10:18 23:53:56\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'32tkyl6dya6oc7bb0ghalfnlchwa5ht'),(2098,'PreferenceRankingMBTI.jpg','20041019042247!PreferenceRankingMBTI.jpg',277821,442,381,8,'I created the source file',43710,'Alterego','20041019042057','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:10:19 00:20:21\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'kcmypurymf3o1bk6bcptrfwwojkel9q'),(2099,'KLM-Aircraft-at-Schiphol.jpg','20041019063928!KLM_Aircraft_at_Schiphol.jpg',343709,1200,900,8,'enhanced',82826,'Solitude','20041018173404','0','BITMAP','image','jpeg',0,'dqwajpgsdbnx7xq4o7x16ra1t647hdi'),(2100,'KLM-Aircraft-at-Schiphol.jpg','20041019064158!KLM_Aircraft_at_Schiphol.jpg',245957,1400,1050,8,'coloring',82826,'Solitude','20041019064006','0','BITMAP','image','jpeg',0,'hvzr9msb9f5wzj3sr59wq802kn86djx'),(2101,'Siwucha.jpg','20041019120450!Siwucha.jpg',12545,164,311,8,'A bottle of [[Siwucha]], from the producer website ([http://www.polmos.zgora.pl/siwucha.htm]). Fair use assumed. <br> {{fairuse}}',32233,'Halibutt','20041019115754','0','BITMAP','image','jpeg',0,'nqmvdpz2ulndvkpg64ang4c5en5je1f'),(2102,'Yeri.png','20041019215620!Yeri.png',2906,518,65,8,'Image of Yeri',62026,'OwenBlacker','20041019215328','0','BITMAP','image','png',0,'7o844y0qfjfih553d7ze7unicmmc1hc'),(2103,'Kang-youwei2-small.jpg','20041020055906!Kang-youwei2-small.jpg',52976,317,462,8,'{{PD}}',42891,'Spencer195','20041020055621','0','BITMAP','image','jpeg',0,'r6ya9osyyobbtsiqvou7zbntg1dgasd'),(2104,'Pepsi-can-stove-lit.JPG','20041020171257!Pepsi_can_stove_lit.JPG',15066,480,370,8,'',101662,'Duk','20041019205230','0','BITMAP','image','jpeg',0,'j44bra0wnlcf0w9mcgmi734d411qjqz'),(2105,'UNKorea.jpg','20041020171328!UNKorea.jpg',13594,115,250,8,'United Nations Korean Medal',63572,'Husnock','20041020171318','0','BITMAP','image','jpeg',0,'ivwd3cb8s5cj6cekaer92v9kw44u63i'),(2106,'Pepsi-can-stove-lit.JPG','20041020185041!Pepsi_can_stove_lit.JPG',21869,480,480,8,'',101662,'Duk','20041020171305','0','BITMAP','image','jpeg',0,'4niilgpilt6p0nlkkg5z4h1jylvdu0e'),(2107,'Pepsi-can-stove-lit.JPG','20041020185121!Pepsi_can_stove_lit.JPG',15066,480,370,8,'Reverted to earlier revision',31175,'Hemanshu','20041020185042','0','BITMAP','image','jpeg',0,'j44bra0wnlcf0w9mcgmi734d411qjqz'),(2108,'Venezia-Ponte-dei-Sospiri.jpg','20041020194621!Venezia_Ponte_dei_Sospiri.jpg',638880,1200,1600,8,'made by Cindy Danielson {{GFDL}} ',120947,'Rawkergirl','20041020071507','a:26:{s:16:\"ImageDescription\";s:31:\"OLYMPUS DIGITAL CAMERA         \";s:4:\"Make\";s:23:\"OLYMPUS OPTICAL CO.,LTD\";s:5:\"Model\";s:6:\"C700UZ\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:10:01 23:31:40\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/3200\";s:7:\"FNumber\";s:5:\"40/10\";s:15:\"ExposureProgram\";i:5;s:15:\"ISOSpeedRatings\";i:141;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"0000:00:00 00:00:00\";s:17:\"DateTimeDigitized\";s:19:\"0000:00:00 00:00:00\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"30/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:1;s:11:\"FocalLength\";s:5:\"59/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'8bipuvks4hn4o2te2l6sx768z9ldut6'),(2109,'Usinprogress.PNG','20041020194640!Usinprogress.PNG',35336,280,183,8,'update,  WY done, starting on FL.',35314,'Seth Ilys','20040915152328','0','BITMAP','image','png',0,'puom93p2jl9kq96n3ear8svjqyjlavb'),(2110,'The-Doors---L.A.-Woman.jpg','20041021051419!The_Doors_-_L.A._Woman.jpg',8224,200,200,8,'[[Category:album covers]] The Doors - L.A. Woman album cover',110766,'DCEdwards1966','20041012231453','0','BITMAP','image','jpeg',0,'2w37u7oa1dptg6mekjd1ohd903o86ry'),(2111,'WikimeetlondonPic1-03.jpg','20041021131148!WikimeetlondonPic1-03.jpg',87946,822,724,8,'Theresa Knott at London Wikimeet. Photo by John Foley 5 June 2004.',62473,'John Foley','20040606111037','a:27:{s:4:\"Make\";s:5:\"CASIO\";s:5:\"Model\";s:9:\"QV-2000UX\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:14:\"99.09.07.11.08\";s:8:\"DateTime\";s:19:\"2004:06:06 12:08:14\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:13:\"10000/1683501\";s:7:\"FNumber\";s:5:\"28/10\";s:15:\"ExposureProgram\";i:2;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:06:05 15:23:01\";s:17:\"DateTimeDigitized\";s:19:\"2004:06:05 15:23:01\";s:22:\"CompressedBitsPerPixel\";s:15:\"6963200/1920000\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:5:\"20/10\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:12:\"121513/10000\";s:10:\"ColorSpace\";i:1;s:12:\"WhiteBalance\";i:1;s:9:\"Sharpness\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'k6hi3e49xfi4rasz6bw6kmit0i23zra'),(2112,'Bieszczady-county-PL.png','20041021152317!Bieszczady_county_PL.png',5940,200,231,4,'',105988,'Fqsik','20040925172332','0','BITMAP','image','png',0,'cozk2jgrnfhx4qaih859bad484zoe3f'),(2113,'Brzozow-county-PL.png','20041021152401!Brzozow_county_PL.png',5938,200,231,4,'{{GFDL}} this is real brzozow county :) [POLAND]',105988,'Fqsik','20041006145935','0','BITMAP','image','png',0,'parzi38kp3k6iz1z5wvys4jglk7devy'),(2114,'Debica-county-PL.png','20041021152513!Debica_county_PL.png',5931,200,231,4,'{{GFDL}}',105988,'Fqsik','20040925181942','0','BITMAP','image','png',0,'bpcd5dgviaee30ccmk9iuxclqi7r6kz'),(2115,'Jaroslaw-county-PL.png','20041021152600!Jaroslaw_county_PL.png',5945,200,231,4,'{{GFDL}}',105988,'Fqsik','20040926090104','0','BITMAP','image','png',0,'6ufaopl4kolcpgpdzzgqrogymsqmpx8'),(2116,'Jaslo-county-PL.png','20041021152717!Jaslo_county_PL.png',5921,200,231,4,'{{GFDL}}',105988,'Fqsik','20040926091805','0','BITMAP','image','png',0,'3wgxyze42hv296g0qj0ru0qivbdczjt'),(2117,'Kolbuszowa-county-PL.png','20041021152918!Kolbuszowa_county_PL.png',5931,200,231,4,'{{GFDL}} Kolbuszowa county [Poland]',105988,'Fqsik','20041006145031','0','BITMAP','image','png',0,'h7bem7ow194oqg2xtevojv27lke518c'),(2118,'Krosno-county-PL.png','20041021153138!Krosno_county_PL.png',5922,200,231,4,'{{GFDL}}',105988,'Fqsik','20041009191459','0','BITMAP','image','png',0,'2bww1bkl9nzjxlghfwgjxu3ppvgrjbt'),(2119,'Lancut-county-PL.png','20041021153300!Lancut_county_PL.png',5934,200,231,4,'{{GFDL}}',105988,'Fqsik','20041009104248','0','BITMAP','image','png',0,'mnd74vw9bxtqf4undjlsdtf01lh7a7l'),(2120,'Lesko-county-PL.png','20041021153327!Lesko_county_PL.png',5946,200,231,4,'{{GFDL}} Lesko county [POLAND]',105988,'Fqsik','20041006150432','0','BITMAP','image','png',0,'q2qxcg5goaaaz3ks9czlk17udat9iyt'),(2121,'Lezajsk-county-PL.png','20041021153443!Lezajsk_county_PL.png',5927,200,231,4,'{{GFDL}}',105988,'Fqsik','20041009100327','0','BITMAP','image','png',0,'netjqkjclr6zoie193ej248e5ob5nyc'),(2122,'Lubaczow-county-PL.png','20041021153515!Lubaczow_county_PL.png',5936,200,231,4,'{{GFDL}}',105988,'Fqsik','20041009101152','0','BITMAP','image','png',0,'20k8fcdh6p6uk5ut48pwxmty93ln3jn'),(2123,'Mielec-county-PL.png','20041021153532!Mielec_county_PL.png',5930,200,231,4,'{{GFDL}}',105988,'Fqsik','20041009104801','0','BITMAP','image','png',0,'b4qq8jdento2alq91j0v6sg2ubvk462'),(2124,'Nisko-county-PL.png','20041021153624!Nisko_county_PL.png',5916,200,231,4,'{{GFDL}}',105988,'Fqsik','20041009151750','0','BITMAP','image','png',0,'lsqqqh7m4v0b17t7jv9glk7yijxkmhd'),(2125,'Przemysl-county-PL.png','20041021153816!Przemysl_county_PL.png',5928,200,231,4,'{{GFDL}}',105988,'Fqsik','20041009191244','0','BITMAP','image','png',0,'h86gmhu48c2d6t2k59jxwzbu4c9sexb'),(2126,'Przeworsk-county-PL.png','20041021153838!Przeworsk_county_PL.png',5939,200,231,4,'{{GFDL}}',105988,'Fqsik','20041009153009','0','BITMAP','image','png',0,'02wf5z3lyco2ocnjema5jqq09fdgx7b'),(2127,'Ropczyce-Sedziszow-county-PL.png','20041021153859!Ropczyce_Sedziszow_county_PL.png',5929,200,231,4,'{{GFDL}}',105988,'Fqsik','20041009154137','0','BITMAP','image','png',0,'1jb5b7w69haz6yvhprtsvgw60s1ns7d'),(2128,'Rzeszow-county-PL.png','20041021153934!Rzeszow_county_PL.png',5914,200,231,4,'{{GFDL}}',105988,'Fqsik','20041009184635','0','BITMAP','image','png',0,'8395emxk5bjpyn59fve2xa6wosds5ol'),(2129,'Sanok-county-PL.png','20041021154056!Sanok_county_PL.png',5921,200,231,4,'{{GFDL}}',105988,'Fqsik','20041009154905','0','BITMAP','image','png',0,'el91td83cn5yzb26x9c5ca7td1zs517'),(2130,'Stalowa-Wola-county-PL.png','20041021154116!Stalowa_Wola_county_PL.png',5919,200,231,4,'{{GFDL}}',105988,'Fqsik','20041009160218','0','BITMAP','image','png',0,'52kj9d1a84fhzumrvj1ty5u827ufl9g'),(2131,'Strzyzow-county-PL.png','20041021154141!Strzyzow_county_PL.png',5924,200,231,4,'{{GFDL}}',105988,'Fqsik','20041009161557','0','BITMAP','image','png',0,'5vgrifm8klk9yscnrava8w1o86salke'),(2132,'Tarnobrzeg-county-pl.png','20041021154202!Tarnobrzeg_county_pl.png',5933,200,231,4,'{{GFDL}}',105988,'Fqsik','20041009183524','0','BITMAP','image','png',0,'hiuj6x8p9c5ggsxrya5wwqllrk62mg2'),(2133,'KP-St-Marks-Church.jpg','20041021164923!KP-St-Marks-Church.jpg',106663,600,800,8,'St Marks church Kennington photo by Chloe Bowles',117709,'Szczels','20041021164811','0','BITMAP','image','jpeg',0,'ivrrliplpr6msig2kgdeaaryfwr0d5s'),(2134,'KP-skatebowl-0.jpg','20041021170340!KP_skatebowl_0.jpg',36224,640,480,8,'Kennington Park Skatepark Photo by Stefan Szczelkun 2004',117709,'Szczels','20041021165947','a:15:{s:4:\"Make\";s:8:\"SONY    \";s:5:\"Model\";s:8:\"HANDYCAM\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:13:\"4718592/65536\";s:11:\"YResolution\";s:13:\"4718592/65536\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:13:\"QuickTime 6.5\";s:8:\"DateTime\";s:19:\"2004:10:20 11:12:31\";s:16:\"YCbCrPositioning\";i:2;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:03:01 14:59:41\";s:17:\"DateTimeDigitized\";s:19:\"2004:03:01 14:59:41\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'rgdnr4lvc6qc8ej9498l2nt1xenv93s'),(2135,'Alexa-reach-measurement-for-wikipedia.png','20041021174334!Alexa_reach_measurement_for_wikipedia.png',3203,480,328,8,'as of 14-oct-2004, using data at roughly 2-week intervals',88976,'Kbh3rd','20041014014936','0','BITMAP','image','png',0,'h0hj07lezyunz3ca5tryhftk6dueaam'),(2136,'WikimeetlondonPic1-03.jpg','20041021185027!WikimeetlondonPic1-03.jpg',168845,1544,756,8,'Reverted to earlier revision',63086,'Ellsworth','20041021131148','a:27:{s:4:\"Make\";s:5:\"CASIO\";s:5:\"Model\";s:9:\"QV-2000UX\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:14:\"99.09.07.11.08\";s:8:\"DateTime\";s:19:\"2004:06:06 11:02:42\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:13:\"10000/1683501\";s:7:\"FNumber\";s:5:\"28/10\";s:15:\"ExposureProgram\";i:2;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:06:05 15:23:01\";s:17:\"DateTimeDigitized\";s:19:\"2004:06:05 15:23:01\";s:22:\"CompressedBitsPerPixel\";s:15:\"6963200/1920000\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:5:\"20/10\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:12:\"121513/10000\";s:10:\"ColorSpace\";i:1;s:12:\"WhiteBalance\";i:1;s:9:\"Sharpness\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'n1kkxe89ui4telo2cd0cc5j73xahr5k'),(2137,'Escape-from-Colditz-Amiga-polishhq.png','20041021233601!Escape_from_Colditz_Amiga_polishhq.png',3976,320,229,8,'Polish HQ of Escape from Colditz, Amiga videogame. Screenshot under fair use.',16840,'Rvalles','20041021122638','0','BITMAP','image','png',0,'rjwscdp5jmka2xapczgaev9nwkadqnl'),(2138,'Amiga-kick34.5-askforwb1.3.png','20041021233749!Amiga_kick34.5_askforwb1.3.png',898,132,133,2,'Amiga asks for wb1.3. Screenshot. Fair use.',16840,'Rvalles','20041020130607','0','BITMAP','image','png',0,'ng4479i2xwwtfxk4m1dm13w86p1x1vz'),(2139,'Kult-ega.png','20041021234353!Kult_ega.png',7028,320,197,4,'screenshot of PC EGA version of Kult',16840,'Rvalles','20041017131806','0','BITMAP','image','png',0,'j06v4ge8i3tcmsso30e8dajpxa0x692'),(2140,'Kult-title.png','20041021234408!Kult_title.png',11481,320,200,4,'screenshot of the title screen from the Amiga version of Kult: The Temple of flying saucers? Source: taken from Unix Amiga Emulator? using The GIMP.',16840,'Rvalles','20041016235147','0','BITMAP','image','png',0,'e6vkfh5ie2t4uzrywqr66qi8o88lexd'),(2141,'The-Settlers-SVGA.png','20041021234440!The_Settlers_SVGA.png',118085,640,480,8,'The Settlers screenshot (fair use)',16840,'Rvalles','20041019154324','0','BITMAP','image','png',0,'39crypzpfx40596curpkyxmsiej5jux'),(2142,'ATP.png','20041022021654!ATP.png',2126,250,186,1,'Reverted to earlier revision',45935,'JuanitaJP','20040318142434','0','BITMAP','image','png',0,'jqqmlkz887bnxuo9rch7scf0va8vx1h'),(2143,'Apollo-1-2nd-plaque.png','20041022022531!Apollo_1_2nd_plaque.png',11045,400,300,8,'Drawing of second Apollo 1 plaque at KSC Launch Complex 34. I created it in Paint Shop Pro. {{GFDL}}',113548,'Error 404','20041021173412','0','BITMAP','image','png',0,'1wob4761y81of4biet4f4uwcd4cutbu'),(2144,'Choline.jpg','20041022022707!Choline.jpg',4627,108,192,8,'[http://bio.winona.msus.edu/berg/ChemStructures/Choline.gif \'Below is an alphabetical list of gif images which are free for the taking...handy for putting...onto websites\']',71699,'Karl Dickman','20041022022454','0','BITMAP','image','jpeg',0,'o357j24i5tth6ekwdx2wqojoz3jmagy'),(2145,'DUBLIN-AREA-RAPID-TRANSIT.PNG','20041022211757!DUBLIN_AREA_RAPID_TRANSIT.PNG',7319,338,627,8,'DART MAP',49447,'Djegan','20041020203507','0','BITMAP','image','png',0,'ernyhdbfzqd7ko9m05pwqgbj73n1of7'),(2146,'African-gdp-growth.png','20041023064020!African_gdp_growth.png',9597,360,392,8,'modified version of [[:Image:Africa-western-countries.png]] {{GFDL}}',1591,'SimonP','20041012001438','0','BITMAP','image','png',0,'8a3lbxrx7tm4bcw0p6g07o2cf518lqu'),(2147,'Clovehitch.png','20041023163238!Clovehitch.png',9315,219,189,8,'clove hitch',2954,'Heron','20030321133259','0','BITMAP','image','png',0,'pwnsxlztqwniyb59kcjbi9b8pvovy4w'),(2148,'Satellite-image-of-Adelaide-South-Australia.jpg','20041023173732!Satellite_image_of_Adelaide_South_Australia.jpg',17543,136,340,8,'Satellite image of Adelaide South Australia, including the outer areas still considered part of the larger Adelaide. Taken from a hi-res shot of most of South Australia. Referred to street, directory, road atlas and my own knowledge of the street layout f',105919,'Diceman','20041013110850','a:7:{s:11:\"Orientation\";i:1;s:8:\"Software\";s:27:\"ACD Systems Digital Imaging\";s:8:\"DateTime\";s:19:\"2004:10:13 20:26:11\";s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:10:\"SubSecTime\";s:3:\"664\";s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'day798a5fetaba6tmsjsxdhh4fqa1aw'),(2149,'Music-for-Airports.jpg','20041023234851!Music_for_Airports.jpg',34434,340,340,8,'Cover of the [[Brian Eno]] album \'\'Ambient 1/[[Music for Airports]]\'\', [[1978]].{{fairuse}}',80654,'Justin Foote','20041022024328','0','BITMAP','image','jpeg',0,'jtrda8usgxsjnbbayaj8lp3jntawgei'),(2150,'Giuliani-crime-rate.gif','20041024180541!Giuliani_crime_rate.gif',12202,683,467,0,'Crime Rate in USA, NYC, LA, Newark 1990-2003',98556,'Pdbailey','20040924030708','0','BITMAP','image','gif',0,'k4vl5msiy25n104vaqwvy84d1t6nuu2'),(2151,'Williams-Sonoma4.jpg','20041024181322!Williams-Sonoma4.jpg',24752,334,479,8,'Photoshopped version of Williams-Sonoma.jpg',21036,'Dpbsmith','20041024175555','0','BITMAP','image','jpeg',0,'i1o9cvo4su8fjx4u1m6r4qcxfxj0cn0'),(2152,'EverQuest-II-box-art.jpg','20041024195031!EverQuest_II_box_art.jpg',49981,356,500,8,'EverQuest II box art',110264,'Kx1186','20041024194328','0','BITMAP','image','jpeg',0,'3oeknsoinl8w3ygcbwcbi3rok2ggtvx'),(2153,'2004swingstates.png','20041024201414!2004swingstates.png',53494,502,383,8,'[[Swing state]]s in the [[U.S. Presidential election, 2004]]',37527,'Decumanus','20041024200145','0','BITMAP','image','png',0,'hx1qj9vyojkop8gzsl9j9dwrt7jaq1p'),(2154,'S65-45753.jpg','20041025071010!S65-45753.jpg',83547,320,240,8,'View of Cape Kennedy, Florida from Gemini 5',29293,'Enceladus','20031110105856','0','BITMAP','image','jpeg',0,'4haq25g1njdhtza3usfsuxu6pdnosxx'),(2155,'Li-Hongzhang-large.jpg','20041025101132!Li_Hongzhang-large.jpg',169822,520,744,8,'{{PD}}',42891,'Spencer195','20041025100501','0','BITMAP','image','jpeg',0,'10shtamqxa1khe3dky7v0tpno3hoqx2'),(2156,'Cheyenne-lodges-with-buffalo-meat-drying,-187.jpg','20041025102834!Cheyenne_lodges_with_buffalo_meat_drying,_187.jpg',73172,800,577,8,'Cheyenne lodges with buffalo meat drying, 187',26995,'Chris 73','20041025100430','0','BITMAP','image','jpeg',0,'7z8d6i6rby3r5gn1bozr912g6o05hg7'),(2157,'Marx-generator.png','20041025185547!Marx_generator.png',58123,582,487,8,'Marx generator',101662,'Duk','20041025182741','0','BITMAP','image','png',0,'ghmt4supmmxyf94rlinyc1gtamvfhxl'),(2158,'Montage2.jpg','20041025234730!Montage2.jpg',409351,900,4200,8,'still from the 1962 movie Carnival of Souls, which is in the Public domain {{PD}}',122516,'Kbgeek','20041025030246','0','BITMAP','image','jpeg',0,'4tf37nq5ancjl5gvx0c85z8rno4jj1y'),(2159,'MOO3Manual.jpg','20041026022404!MOO3Manual.jpg',185162,1024,768,8,'Master of Orion III manual {{GFDL}}',73419,'Flyhighplato','20041026022143','a:32:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:19:\"Canon PowerShot A80\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:10:25 20:22:28\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:3:\"1/8\";s:7:\"FNumber\";s:5:\"40/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:10:25 20:22:28\";s:17:\"DateTimeDigitized\";s:19:\"2004:10:25 20:22:28\";s:22:\"CompressedBitsPerPixel\";s:3:\"3/1\";s:17:\"ShutterSpeedValue\";s:5:\"96/32\";s:13:\"ApertureValue\";s:6:\"128/32\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:6:\"128/32\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:6:\"519/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"1024000/280\";s:21:\"FocalPlaneYResolution\";s:10:\"768000/210\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:9:\"2272/2272\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'m250b0rphvqu1q8zeb8v4ifjmn8c0x6'),(2160,'Force-Dynamics-example-1.png','20041026145813!Force_Dynamics_example_1.png',2232,100,86,8,'Created by Mark Dingemanse Oct 26 2004. Released under CC-by-2.0',119869,'Mark Dingemanse','20041026140642','0','BITMAP','image','png',0,'2z6n820qo0rikm96saswdzd6kjox9nk'),(2161,'Hitman2-screenshot01.jpg','20041026194245!Hitman2-screenshot01.jpg',69558,800,600,8,'47 having taken out and stolen the clothes of an enemy guard in the snowy [[St. Petersburg]]. {{screenshot}}',88248,'ZeroOne','20040925001614','0','BITMAP','image','jpeg',0,'9zv1qdu79vrnerve27zbp8ze4wsfam2'),(2162,'The-Donnas---Spend-the-Night.jpg','20041027004238!The_Donnas_-_Spend_the_Night.jpg',10677,200,199,8,'Cover for the album \'\'[[Spend the Night]]\'\' by [[The Donnas]] {{albumcover}}',110766,'DCEdwards1966','20041026233552','0','BITMAP','image','jpeg',0,'lvdfgtbc6nzzvfv7omd4y1q24sa9317'),(2163,'European-Union-map.png','20041027012859!European_Union_map.png',138589,551,475,8,'The [[European Union]] member states, 2007 admissions and candidate country',55814,'Gdr','20041024175454','0','BITMAP','image','png',0,'2hsaedgpwalvwve94ki6xsx1kbozn7t'),(2164,'Titan-photographed-by-Cassini-Huygens.jpg','20041027125040!Titan_photographed_by_Cassini-Huygens.jpg',4936,145,256,8,'Piercing the ubiquitous layer of smog enshrouding Titan, these images from the Cassini visual and infrared mapping spectrometer reveals an exotic surface covered with a variety of materials in the southern hemisphere. Taken from: http://photojournal.jpl.n',82826,'Solitude','20040705153345','0','BITMAP','image','jpeg',0,'1x7gofnqebm66hy3uugzt9qkxym8410'),(2165,'Bothwell-castle-1997-b.jpg','20041027220951!Bothwell_castle_1997_b.jpg',59269,718,581,8,'[[Bothwell Castle]] photographed in 1997 by [[User:dave souza]], {{GFDL}}',85186,'Dave souza','20041025234522','0','BITMAP','image','jpeg',0,'bm6n32yz2s77hcwhja52nm01jfcm62t'),(2166,'Bothwell-castle-1997-b.jpg','20041027221714!Bothwell_castle_1997_b.jpg',72199,869,594,8,'[[Bothwell Castle]] Donjon moat, with the Donjon to the right and the Prison Tower visible above the curtain wall to the left, photographed in 1997 by [[User:dave souza]], {{GFDL}}',85186,'Dave souza','20041027221022','0','BITMAP','image','jpeg',0,'m2kiywgicvzn0k3lsqj5xq0tyftlubc'),(2167,'Bothwell-castle-1997-b.jpg','20041027222032!Bothwell_castle_1997_b.jpg',72199,869,594,8,'[[Bothwell Castle]] photographed in 1997 by [[User:dave souza]], {{GFDL}}',85186,'Dave souza','20041027221753','0','BITMAP','image','jpeg',0,'m2kiywgicvzn0k3lsqj5xq0tyftlubc'),(2168,'P-g.gif','20041027223418!P_g.gif',7408,959,719,8,'self created',118758,'Truth seeker','20041027201533','0','BITMAP','image','gif',0,'rpp0treizt38sihijl08zz0ie38r7n1'),(2169,'P-g.gif','20041027223535!P_g.gif',7500,959,719,8,'self created',118758,'Truth seeker','20041027223431','0','BITMAP','image','gif',0,'i1fw6mjw039x3yvx434oikakijktkj6'),(2170,'P-g.gif','20041027223654!P_g.gif',7500,959,719,8,'self created',118758,'Truth seeker','20041027223538','0','BITMAP','image','gif',0,'i1fw6mjw039x3yvx434oikakijktkj6'),(2171,'P-g.gif','20041027223912!P_g.gif',7500,959,719,8,'parallax, geocentric',118758,'Truth seeker','20041027223656','0','BITMAP','image','gif',0,'i1fw6mjw039x3yvx434oikakijktkj6'),(2172,'P-g.gif','20041027223959!P_g.gif',7500,959,719,8,'parallax, geo',118758,'Truth seeker','20041027223914','0','BITMAP','image','gif',0,'i1fw6mjw039x3yvx434oikakijktkj6'),(2173,'Sialic-acid.jpg','20041028032328!Sialic_acid.jpg',8508,160,247,8,'[http://bio.winona.msus.edu/berg/Structures.htm] [http://bio.winona.msus.edu/berg/ChemStructures/sialicacid.gif \'Below is an alphabetical list of gif images which are free for the taking. These images are handy for putting ... onto web pages.\']',71699,'Karl Dickman','20041028031930','0','BITMAP','image','jpeg',0,'qmr18axalzn2kelu4kr0mssv9mb1oaa'),(2174,'Usinprogress.PNG','20041028145537!Usinprogress.PNG',34839,280,183,8,'update',35314,'Seth Ilys','20041020194645','0','BITMAP','image','png',0,'ewibi8it05a7wzgfd34q3uyez6wful2'),(2175,'Chicago---Chicago-VI.jpg','20041028190355!Chicago_-_Chicago_VI.jpg',11199,200,195,8,'Cover for the album \"[[Chicago VI]]\" by [[Chicago (band)]] {{albumcover}}',110766,'DCEdwards1966','20041028190301','0','BITMAP','image','jpeg',0,'9egm76trrbc48rdhgkiybwotouhy5se'),(2176,'European-Union-map.png','20041028213459!European_Union_map.png',117450,552,475,8,'add Kaliningrad; improve lettering',55814,'Gdr','20041027012957','0','BITMAP','image','png',0,'6sicyt80ukvh4tm7uk68gof9uydqfes'),(2177,'European-Union-map.png','20041029002609!European_Union_map.png',117450,552,475,8,'Add legend for non candidate states',55814,'Gdr','20041028213503','0','BITMAP','image','png',0,'6sicyt80ukvh4tm7uk68gof9uydqfes'),(2178,'European-Union-map.png','20041029002718!European_Union_map.png',117213,552,476,8,'Oops, uploaded wrong image last time!',55814,'Gdr','20041029002613','0','BITMAP','image','png',0,'644jx9ai0aa2wodz4g08finf76cmcqr'),(2179,'Kaneohebay1.jpg','20041029043722!Kaneohebay1.jpg',143088,800,600,8,'{{CopyrightedFreeUse}} A view of Kaneohe Bay and a section of the Ko\'olau Mountain Range from a Kahalu\'u residence.',125762,'Crazynorvegian','20041029043534','0','BITMAP','image','jpeg',0,'qvcstg5h0f5cpnvspzl7zmh3ierzf9q'),(2180,'DSCN3989-kennebunkportclamshack-e.jpg','20041029190949!DSCN3989_kennebunkportclamshack_e.jpg',67113,600,428,8,'Tourists cross the bridge over the [[Kennebunk River]] in [[Kennebunkport, Maine]]',37527,'Decumanus','20041029190757','a:25:{s:4:\"Make\";s:5:\"NIKON\";s:5:\"Model\";s:4:\"E995\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:28:\"Adobe Photoshop CS Macintosh\";s:8:\"DateTime\";s:19:\"2004:10:29 12:06:15\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/5091\";s:7:\"FNumber\";s:5:\"84/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:09:20 18:19:13\";s:17:\"DateTimeDigitized\";s:19:\"2004:09:20 18:19:13\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:4:\"0/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:6:\"110/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'aunqcdpmsf1adndjoj69gtyrz2kyh8y'),(2181,'Knaggs2.jpg','20041029214745!Knaggs2.jpg',30938,400,400,8,'Distribution of Knaggs surname in England in 1881',124766,'Knaggs','20041029214633','0','BITMAP','image','jpeg',0,'2kk4g7d0hi2h3msyip3mlr8pxvwkt6m'),(2182,'Fifelfoo.JPG','20041029234835!Fifelfoo.JPG',51187,480,640,8,'User Fifelfoo',28264,'Fifelfoo','20041029234349','0','BITMAP','image','jpeg',0,'6sdfiwqiekho6yv9x0zra1uj83oc1n4'),(2183,'Fifelfoo.JPG','20041029235254!Fifelfoo.JPG',16928,240,320,8,'Fifelfoo',28264,'Fifelfoo','20041029234845','0','BITMAP','image','jpeg',0,'jc9wg3s6f5499bo4lqhuy5iv6zy5uex'),(2184,'Flamenco-beach,-Isla-Culebra.JPG','20041030012212!Flamenco_beach,_Isla_Culebra.JPG',7060,651,100,8,'Images taken personally of Flamenco beach on Isla Culebra',124717,'Queson','20041030011910','0','BITMAP','image','jpeg',0,'qpt1zcvwoe65lud6r3s6v9jtl8mmrk0'),(2185,'Flamenco-beach,-Isla-Culebra.JPG','20041030012338!Flamenco_beach,_Isla_Culebra.JPG',14563,813,125,8,'',124717,'Queson','20041030012217','0','BITMAP','image','jpeg',0,'i7qx7e9i9i8gqxaptnf1mbtix7hbqqz'),(2186,'Flamenco-beach,-Isla-Culebra.JPG','20041030013634!Flamenco_beach,_Isla_Culebra.JPG',7060,651,100,8,'Reverted to earlier revision',124717,'Queson','20041030012338','0','BITMAP','image','jpeg',0,'qpt1zcvwoe65lud6r3s6v9jtl8mmrk0'),(2187,'Flamenco-beach,-Isla-Culebra.JPG','20041030014010!Flamenco_beach,_Isla_Culebra.JPG',32500,1301,200,8,'',124717,'Queson','20041030013637','0','BITMAP','image','jpeg',0,'tokqgaf4t056rop61ltkq844xjqcq9a'),(2188,'Flamenco-beach,-Isla-Culebra.JPG','20041030014048!Flamenco_beach,_Isla_Culebra.JPG',94282,976,150,8,'',124717,'Queson','20041030014014','0','BITMAP','image','jpeg',0,'li0gvrrorc8klopcbgtjky9r102v3gt'),(2189,'Flamenco-beach,-Isla-Culebra.JPG','20041030014200!Flamenco_beach,_Isla_Culebra.JPG',32500,1301,200,8,'Reverted to earlier revision',124717,'Queson','20041030014048','0','BITMAP','image','jpeg',0,'tokqgaf4t056rop61ltkq844xjqcq9a'),(2190,'LindaRonstadt.jpg','20041030030051!LindaRonstadt.jpg',6411,150,150,8,'Album cover in the public domain',3376,'DW','20021222225339','0','BITMAP','image','jpeg',0,'4ptzo4z5fbk8u5ef5suvlg66cp7ypyn'),(2191,'Acton-ACT-locality-MJC01.png','20041030115655!Acton_ACT_locality-MJC01.png',66807,700,1091,8,'First draft of a Canberra locality map. Image created by Maritn Conway and released under the GFDL {{GFDL}}',112533,'Martyman','20041016071234','0','BITMAP','image','png',0,'ij9wtu8ck3k41tlmr8jos9xue06im3a'),(2192,'Federal-Standard-Regions-map.png','20041030151837!Federal_Standard_Regions_map.png',72576,490,321,8,'Map of the Standard Federal Regions in US',118176,'Frank101','20041028194727','0','BITMAP','image','png',0,'ssaawnpmpivapm8xs1ciifiv66cex42'),(2193,'Book-of-common-prayer-Scotland-1637.jpg','20041030182153!Book_of_common_prayer_Scotland_1637.jpg',267884,860,1286,8,'The Booke of Common Prayer for [[Scotland]] published in [[Edinburgh]], [[1637]]. {{PD}} image reproduced in \'\'Scotland, A Concise History\'\', Fitzroy Maclean, Thames and Hudson 1991, ISBN 0-500-27706-0   ',85186,'Dave souza','20041030171559','0','BITMAP','image','jpeg',0,'2sace2yh7m1xe31diiqzz1upa2340pf'),(2194,'George-IV-in-kilt,-caricature.jpg','20041030182526!George_IV_in_kilt,_caricature.jpg',65008,598,995,8,'Contemporary caricature of King [[George IV of England]] in kilt during the [[Visit of King George IV to Scotland]] in [[1822]].  {{PD}} image reproduced in \'\'The King\'s Jaunt\'\', John Prebble, Birlinn Limited, Edinburgh 2000, ISBN 1-84158-068-6 : ',85186,'Dave souza','20041030172147','0','BITMAP','image','jpeg',0,'2hemnqeetvy9wt6fh4wrw3t3wpzrqbn'),(2195,'Sauber-Petronas-logo.png','20041030184742!Sauber_Petronas_logo.png',3367,198,149,8,'{{logo}}',19009,'Ed g2s','20041030184404','0','BITMAP','image','png',0,'f7j22vbamsqf1dwl26fxjcgu6jr1jtg'),(2196,'Switch-alternate-and-or.png','20041030185233!Switch_alternate_and_or.png',4261,575,198,8,'Simple switch circuit diagram of the alternate AND and OR gates, drawn by myself',14486,'Dysprosia','20030903115122','0','BITMAP','image','png',0,'fztyf8pajlc5mi1w0jzq931hjikpx92'),(2197,'Jaguar-logo.png','20041030185450!Jaguar_logo.png',6896,312,167,8,'Jaguar Logo, claiming fair use<br>{{fairuse}}',23743,'RadicalBender','20040627010251','0','BITMAP','image','png',0,'napgilwvgjo3y74yaprakx3uplrvqm5'),(2198,'Yukon---Kluane-Park-and-Alaska-Highway-area.png','20041030201522!Yukon_-_Kluane_Park_and_Alaska_Highway_area.png',8302,514,488,4,'Southern Yukon, including Kluane Park and the Alaska highway',124348,'Geo Swan','20041030200343','0','BITMAP','image','png',0,'ofncr3z7ndl8vlvefc9cgbp7rsfc145'),(2199,'Yukon---Kluane-Park-and-Alaska-Highway-area.png','20041030205328!Yukon_-_Kluane_Park_and_Alaska_Highway_area.png',8302,514,488,4,'',124348,'Geo Swan','20041030201529','0','BITMAP','image','png',0,'ofncr3z7ndl8vlvefc9cgbp7rsfc145'),(2200,'Yukon---Kluane-Park-and-Alaska-Highway-area.png','20041030205733!Yukon_-_Kluane_Park_and_Alaska_Highway_area.png',11941,514,553,4,'South west corner of the Yukon',124348,'Geo Swan','20041030205335','0','BITMAP','image','png',0,'9prrecw7r0ib536zz39ofn7n6559aqf'),(2201,'GreaterSarajevo.PNG','20041030222844!GreaterSarajevo.PNG',5409,204,110,8,'',72174,'Asim Led','20041029221816','0','BITMAP','image','png',0,'kr4aqhixrxhofl5wii91mmoljngs720'),(2202,'SLTrib-Liberal-victory.jpg','20041031014150!SLTrib_Liberal_victory.jpg',67515,520,568,8,'{{PD}}',42878,'Cool Hand Luke','20041030201858','0','BITMAP','image','jpeg',0,'3722r1075p3hamnvlptz2tjr7v4umic'),(2203,'Shipping-Zones.png','20041031100416!Shipping_Zones.png',177188,504,569,8,'Crappy little map I made',35639,'Dmn','20041031022246','0','BITMAP','image','png',0,'c7t5z21abq5f2s3sqy3admjszn17vxf'),(2204,'Phalanx-CIWS.jpg','20041031130653!Phalanx_CIWS.jpg',19149,300,315,8,'Phalanx weapon system {{PD-USGov}}',835,'Rmhermen','20040727003542','0','BITMAP','image','jpeg',0,'t5yqyo9n6xq6xgpsinydaj0rp2ux68z'),(2205,'Grom.png','20041031163733!Grom.png',36099,293,425,8,'[[GROM]] shoulder badge <br> {{User:Halibutt/GFDL}}',32233,'Halibutt','20041031163439','0','BITMAP','image','png',0,'oe3345fizul9r06xvf233k2i7notmop'),(2206,'Grom-Wieslaw-Sierocinski.jpg','20041031171340!Grom_Wieslaw_Sierocinski.jpg',30107,278,352,8,'http://pl.wikipedia.org/wiki/ORP_Grom',3759,'Topory','20040528011545','0','BITMAP','image','jpeg',0,'ibqmkp6wxxmgcx8de9jcde7365yopia'),(2207,'2004-10-29-Bin-Laden-still.jpg','20041031175950!2004-10-29_Bin_Laden_still.jpg',14080,203,152,8,'Fair use still of Bin Laden 2004 video',10109,'Evercat','20041029203426','0','BITMAP','image','jpeg',0,'n9jqth6u9tqkc7ydhbjqiv6tmenbfka'),(2208,'Metrorail-Extensions.PNG','20041031191056!Metrorail_Extensions.PNG',30918,703,968,8,'Reverted to earlier revision',84161,'Johnnyjoe23','20041017234112','0','BITMAP','image','png',0,'77t94m87ayy1b0e6ah3o846b7z6982u'),(2209,'Metrorail-Extensions.PNG','20041031191203!Metrorail_Extensions.PNG',32395,803,968,8,'',84161,'Johnnyjoe23','20041031191103','0','BITMAP','image','png',0,'8bfy3hgwbz5qcrl71vmz9xldh526yia'),(2210,'2004-10-29-Bin-Laden-still.jpg','20041031215847!2004-10-29_Bin_Laden_still.jpg',7586,203,152,8,'Made pretty in The Gimp (basically, I blurred the background)',9920,'Dpol','20041031175959','0','BITMAP','image','jpeg',0,'eipxrwmbntngwptu77a7bxbzeoxebow'),(2211,'ST-Oids.png','20041031224355!ST_Oids.png',1253,320,200,8,'screenshot [[Atari ST]] [[Oids]], made myself. {{screenshot}}',107001,'Tyan23','20041031132357','0','BITMAP','image','png',0,'ml8p4agmxzok9ohol5eyozjat3wy1p0'),(2212,'Map-of-USA-Locator-Mojave.jpg','20041101024710!Map_of_USA_Locator_Mojave.jpg',19273,280,183,8,'',65017,'Scott Burley','20041031194452','0','BITMAP','image','jpeg',0,'t25q8zb2dhvu9h8teaiaux8gz2bbl8w'),(2213,'Map-of-USA-Locator-Mojave.jpg','20041101024814!Map_of_USA_Locator_Mojave.jpg',19272,280,183,8,'',65017,'Scott Burley','20041101024719','0','BITMAP','image','jpeg',0,'t25q8zb2dhvu9h8teaiaux8gz2bbl8w'),(2214,'Map-of-USA-Locator-Mojave.jpg','20041101024937!Map_of_USA_Locator_Mojave.jpg',19272,280,183,8,'',65017,'Scott Burley','20041101024817','0','BITMAP','image','jpeg',0,'t25q8zb2dhvu9h8teaiaux8gz2bbl8w'),(2215,'European-Union-map.png','20041101133621!European_Union_map.png',70669,552,476,8,'And compress a bit',55814,'Gdr','20041029002721','0','BITMAP','image','png',0,'gttyrwai3u7pdt7k1o4s0rbc6nmlr8h'),(2216,'USPresidentialSeal-transparent-100px.png','20041101154613!USPresidentialSeal_transparent_100px.png',8392,100,101,8,'USPresidentialSeal_transparent_100px',82826,'Solitude','20041101134815','0','BITMAP','image','png',0,'frrxs2l9le7wrq7mmq9lqcqyeehq8rb'),(2217,'Wojewodztwo-mazowieckie.png','20041101165919!Wojewodztwo_mazowieckie.png',3854,210,186,8,'',3759,'Topory','20030114002320','0','BITMAP','image','png',0,'mag549xd0hrqprpm4sxm1tq16u3vqht'),(2218,'Alpha-L-Fructose-structure.png','20041101184703!Alpha-L-Fructose-structure.png',5859,491,294,8,'fixing mistake',30200,'Sverdrup','20040908081429','0','BITMAP','image','png',0,'39b172gins65yi8sjd1tynwgkguwwz7'),(2219,'Hijacking-catastrophe-(poster).jpg','20041101200922!Hijacking_catastrophe_(poster).jpg',24246,379,418,8,'Poster for Hijacking Catastrophe',94806,'RoyBoy','20041101195553','0','BITMAP','image','jpeg',0,'toy8w7kow4wsw547urpflphkidmqiw7'),(2220,'Wilanow3.jpg','20041101214849!Wilanow3.jpg',61554,800,533,8,'With permission, Author: Marek and Ewa Wojciechowscy, http://www.poczta-polska.pl/mw/ {{fairuse}} ',60647,'Emax','20041101211028','0','BITMAP','image','jpeg',0,'qhj69y3dj6f0kj1qmqadb76ma1icx8e'),(2221,'Wilanow8.jpg','20041101215230!Wilanow8.jpg',73671,800,533,8,'With permission, Author: Marek and Ewa Wojciechowscy, http://www.poczta-polska.pl/mw/ {{fairuse}} ',60647,'Emax','20041101211240','0','BITMAP','image','jpeg',0,'dh3wr99cw09od2tp52wu1sg5abr4okr'),(2222,'Palac-Branickich3.jpg','20041101215540!Palac_Branickich3.jpg',56574,800,409,8,'With permission, Author: Marek and Ewa Wojciechowscy, http://www.poczta-polska.pl/mw/ {{fairuse}} ',60647,'Emax','20041101210438','0','BITMAP','image','jpeg',0,'2uzfkhx6a5jrp5t83iia8s0bhlu7rm9'),(2223,'Palac-Branickich3.jpg','20041101232141!Palac_Branickich3.jpg',103135,800,409,8,'With permission, Author: Marek and Ewa Wojciechowscy, http://www.poczta-polska.pl/mw/ {{fairuse}} ',60647,'Emax','20041101215552','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:8:\"DateTime\";s:19:\"2004:11:01 22:55:38\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'2one4ghhkfmeuom9gzb4rnreep01ss7'),(2224,'Palac-Branickich3.jpg','20041101232244!Palac_Branickich3.jpg',56574,800,409,8,'Reverted to earlier revision',60647,'Emax','20041101232141','0','BITMAP','image','jpeg',0,'2uzfkhx6a5jrp5t83iia8s0bhlu7rm9'),(2225,'European-Union-map.png','20041102010032!European_Union_map.png',117241,552,479,8,'Colour Croatia as a candidate state',55814,'Gdr','20041101133730','0','BITMAP','image','png',0,'389xd74hgacvwf3juixy24c5ds1e40n'),(2226,'Van-Speyk-shoots-at-gunpowder.jpg','20041102022618!Van_Speyk_shoots_at_gunpowder.jpg',29961,500,405,8,'Van Speyk shoots at a barrel of gunpowder, detonataing his own ship; source:http://www.engelfriet.net/Alie/Hans/speijk.htm',111478,'Mixcoatl','20041030140508','0','BITMAP','image','jpeg',0,'4lale3kooh0tgwilalk9rwj47lbp08a'),(2227,'Hiramwalkergrave.jpg','20041102023613!Hiramwalkergrave.jpg',61546,600,479,8,'Hiram Walker\'s grave site, Elmwood Cemetery, Detroit, MI',98579,'Architectureguy','20041102023244','0','BITMAP','image','jpeg',0,'nj0f4jx4p882oznj20tgf49i880voob'),(2228,'Map1.gif','20041102060816!Map1.gif',24886,1022,597,8,'',22444,'Adam Carr','20040914051914','0','BITMAP','image','gif',0,'iusbwx3eqcgwqtbjckswd4umazdcrxs'),(2229,'Map7.gif','20041102060912!Map7.gif',18396,956,607,8,'',22444,'Adam Carr','20040914052106','0','BITMAP','image','gif',0,'q8uc51us7drn58yfai2fxsu3orfny21'),(2230,'Map8.gif','20041102060929!Map8.gif',16793,940,638,8,'',22444,'Adam Carr','20040914052135','0','BITMAP','image','gif',0,'fife1bmodu0t0305ps4wv8br3r6fvxf'),(2231,'Map9a.gif','20041102060956!Map9a.gif',17788,940,608,8,'',22444,'Adam Carr','20040916025941','0','BITMAP','image','gif',0,'gde3anatni2wx37mcq78rpoby477o2h'),(2232,'Schneur-Zalman-of-Liadi.jpg','20041102070523!Schneur_Zalman_of_Liadi.jpg',29056,331,425,8,'Very old accepted public image of  Schner Zalman of Liadi of Lubavitch',6549,'IZAK','20041102070128','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2003:12:14 17:05:49\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'pvf35xh5xkxnvjhol9buv1s1snju7nu'),(2233,'USPresidentialSeal-transparent-100px.png','20041102084946!USPresidentialSeal_transparent_100px.png',7469,100,101,8,'Make it more betterer',94120,'PhilHibbs','20041101154621','0','BITMAP','image','png',0,'lcbnnz38ar96fig07c8fyzwlb7uv49q'),(2234,'USPresidentialSeal-transparent-100px.png','20041102144258!USPresidentialSeal_transparent_100px.png',8473,100,101,8,'less jagged version',82826,'Solitude','20041102084948','0','BITMAP','image','png',0,'fd9459ryvcb3kch4kacwgf77vklo7g4'),(2235,'USPresidentialSeal-transparent-100px.png','20041102145344!USPresidentialSeal_transparent_100px.png',21358,100,101,8,'Replace jagged image',82899,'Rhobite','20041102144433','0','BITMAP','image','png',0,'fd9459ryvcb3kch4kacwgf77vklo7g4'),(2236,'European-Union-map.png','20041102161814!European_Union_map.png',117410,552,480,8,'More saturated colours',55814,'Gdr','20041102010040','0','BITMAP','image','png',0,'sx7ts9v3yhojotfc94kffql3zklrt6s'),(2237,'USPresidentialSeal-transparent-100px.png','20041102190417!USPresidentialSeal_transparent_100px.png',8473,100,101,8,'Reverted to earlier revision',82899,'Rhobite','20041102145344','0','BITMAP','image','png',0,'fd9459ryvcb3kch4kacwgf77vklo7g4'),(2238,'Classical-Greek-G.gif','20041102204456!Classical_Greek_G.gif',1678,375,550,8,'Classical Greek G',126116,'Munchkinguy','20041102201939','0','BITMAP','image','gif',0,'sp2u9f5ekx9h50h443wopfukhhijo39'),(2239,'Classical-Greek-G.gif','20041102204613!Classical_Greek_G.gif',333,118,106,1,'Classical Greek G',126116,'Munchkinguy','20041102204501','0','BITMAP','image','gif',0,'n3seaqeb8c9uolzn085xmd56ddehhn0'),(2240,'European-Union-map.png','20041102212936!European_Union_map.png',72806,552,483,8,'Make French Guiana look less like an island',55814,'Gdr','20041102161827','0','BITMAP','image','png',0,'lsy1lti29dr5e2622myvcxddc90szbb'),(2241,'FaveroPlaqueSmall.jpg','20041102224222!FaveroPlaqueSmall.jpg',112581,500,375,8,'A memorial plaque in [[Duluth, Georgia]] for three victims of the [[ValuJet Flight 592]] plane crash. Reads: \'\'IN LOVING MEMORY OF OUR FRIENDS LAURA, BETSY AND FRANCO FAVERO\'\'',13476,'Dcoetzee','20041102224147','a:33:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:19:\"Canon PowerShot A75\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:11:02 17:38:40\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:5:\"1/200\";s:7:\"FNumber\";s:5:\"32/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:11:02 13:02:18\";s:17:\"DateTimeDigitized\";s:19:\"2004:11:02 13:02:18\";s:22:\"CompressedBitsPerPixel\";s:3:\"3/1\";s:17:\"ShutterSpeedValue\";s:6:\"245/32\";s:13:\"ApertureValue\";s:6:\"107/32\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:6:\"107/32\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:6:\"251/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"2048000/208\";s:21:\"FocalPlaneYResolution\";s:11:\"1536000/156\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:9:\"2048/2048\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'9c65dfq14drvns0itc401chjragkv4g'),(2242,'TCOIL3.png','20041103004815!TCOIL3.png',34886,478,333,8,'Reverted to earlier revision',56905,'Kieff','20040526084814','0','BITMAP','image','png',0,'5ns99wsmfglm8balq6arpf819k11bh8'),(2243,'AGN-Jet-Blueshift.png','20041103061857!AGN_Jet_Blueshift.png',11325,375,145,8,'Blue- Shifting of a spectrum compared with a beaming effect. A blueshift (or redshift) does not alter the amount of energy emitted by the object and therefore is not a beaming effect. This image created with Corel PhotoPaint 10 by Mrbrak (Ron Kollgaard) {',118456,'Mrbrak','20041103061853','0','BITMAP','image','png',0,'nal477wvujouak6d7dxbphrskhrln1e'),(2244,'IndiaTest.png','20041103091210!IndiaTest.png',219107,473,546,8,'Reverted to earlier revision',21013,'Raul654','20040916050243','0','BITMAP','image','png',0,'a7brflmqo3lh3ebyrlgolmr8b2d5obi'),(2245,'IndiaTest.png','20041103091616!IndiaTest.png',223882,472,543,8,'Reverted to earlier revision',55862,'Kums','20041103091211','0','BITMAP','image','png',0,'nloouarktwejvfrj6wexvm6of63lq3g'),(2246,'Growthsharematrix.png','20041103213235!Growthsharematrix.png',2365,317,263,8,'My rendition of the BCG growth share matrix',18084,'Tempshill','20041103210254','0','BITMAP','image','png',0,'79jvvycrddfowjv7m1zweupurudhvfb'),(2247,'Strychnine.png','20041103221454!Strychnine.png',3588,152,119,8,'',88116,'Mykhal','20040814230958','0','BITMAP','image','png',0,'0fz9humx7l11hviez1xzodoq82uhy25'),(2248,'Lodz-Voivodship.png','20041104081354!Lodz_Voivodship.png',3828,210,186,8,'',23645,'Caius2ga','20031202053956','0','BITMAP','image','png',0,'5txsly26iix164y6vlzgd686abr0r22'),(2249,'Wojewodztwo-dolnoslaskie.png','20041104081806!Wojewodztwo_dolnoslaskie.png',3810,210,186,8,'',3759,'Topory','20030113235331','0','BITMAP','image','png',0,'393sfsksz1xltjp51f6hfwkk0656vku'),(2250,'Lublin-Voivodship.png','20041104082118!Lublin_Voivodship.png',3794,0,0,0,'',23645,'Caius2ga','20031204025808','',NULL,'unknown','unknown',0,''),(2251,'Wojewodztwo-lubuskie.png','20041104082741!Wojewodztwo_lubuskie.png',3810,210,186,8,'',3759,'Topory','20030114001118','0','BITMAP','image','png',0,'tkmbu23txgub99utsj3ochsolcxxd7q'),(2252,'Lublin-Voivodship.png','20041104082951!Lublin_Voivodship.png',11247,210,186,8,'',32233,'Halibutt','20041104082134','0','BITMAP','image','png',0,'653uum99i2o89hs4xf6o74kt364r390'),(2253,'Wojewodztwo-opolskie.png','20041104083059!Wojewodztwo_opolskie.png',3789,210,186,8,'',3759,'Topory','20030114000149','0','BITMAP','image','png',0,'q27gf7zizjaon5xtt5mzwnxgnb0riin'),(2254,'Swvoivodship.png','20041104083642!Swvoivodship.png',3781,210,186,8,'Swietokrzyskie',11,'Kpjas','20030707181920','0','BITMAP','image','png',0,'qism4o71qkekvern4jq8avpyx0pvolx'),(2255,'Wojewodztwo-slaskie.png','20041104084448!Wojewodztwo_slaskie.png',3803,210,186,8,'',3759,'Topory','20030114000443','0','BITMAP','image','png',0,'81u07dq90ylon2h3xnxghjrb7sps5m8'),(2256,'Warmian-Masurian-Voivodship.png','20041104084656!Warmian-Masurian_Voivodship.png',3758,210,186,8,'',23645,'Caius2ga','20031208015229','0','BITMAP','image','png',0,'hf2pxekilog3ndbo26vgsdahgq07xfj'),(2257,'Wojewodztwo-zachodniopomorskie.png','20041104084837!Wojewodztwo_zachodniopomorskie.png',3773,210,186,8,'from polish wikipedia',7580,'Ahoerstemeier','20031014134717','0','BITMAP','image','png',0,'2afexr2c2b29vqz938e0yqqubt9hz1v'),(2258,'SarajevoinBosnia2.PNG','20041104101308!SarajevoinBosnia2.PNG',16071,140,135,8,'',72174,'Asim Led','20041030170456','0','BITMAP','image','png',0,'7jh2wnthh60mr2eluxe1izpyi0brh6s'),(2259,'Wojewodztwo-mazowieckie.png','20041104101907!Wojewodztwo_mazowieckie.png',11315,580,425,8,'[[Masovian Voivodship]] on a map of Poland <br> {{User:Halibutt/GFDL}}',32233,'Halibutt','20041101165926','0','BITMAP','image','png',0,'k9d45mmvswqn3r19kd3mr9lav27afms'),(2260,'Wojewodztwo-mazowieckie.png','20041104103257!Wojewodztwo_mazowieckie.png',4919,392,392,4,'cleansed version',32233,'Halibutt','20041104101910','0','BITMAP','image','png',0,'ktnheez9o0krogqdhb2ogb61hguxkrq'),(2261,'Krakow-Mapa1.png','20041104113457!Krakow_Mapa1.png',55314,580,425,8,'Kraków on a map of Poland. From the Polish WP Kraków article.',47506,'DO\'Neil','20040612125543','0','BITMAP','image','png',0,'7pk6utnyje4z7hkm10amwzzrjefjw4y'),(2262,'Lodz-Mapa1.PNG','20041104113540!Lodz_Mapa1.PNG',55523,580,425,8,'[[Lodz|&#321;ód&#378;]] on a contour map of Poland, by [[User:Halibutt|Halibutt]], made in [[GIMP]] {{GFDL}}',32233,'Halibutt','20040903094327','0','BITMAP','image','png',0,'9rpw8mcgjfm6ansbicj56cd5vn8z1de'),(2263,'Polska22-wolynskie.png','20041104150400!Polska22_wolynskie.png',3141,244,267,8,'',86399,'Berkut','20040715123405','0','BITMAP','image','png',0,'fss5ih2iafkt80ke9755x6qoj7tp76v'),(2264,'Wojewodztwo-wilenskie-38.png','20041104150617!Wojewodztwo_wilenskie_38.png',5471,244,267,8,'Wilno Voivodship (from the Polish wiki - see interwiki link)',32233,'Halibutt','20040619031619','0','BITMAP','image','png',0,'lka7b1d4nyzd2c5fsmpp11pegm4n1hm'),(2265,'Strychnine.png','20041104150823!Strychnine.png',6011,207,152,8,'Chemical structure of ',83784,'Cacycle','20041103221659','0','BITMAP','image','png',0,'2j7qf2uu3k2w9hjfyg35fe9msa9qfcq'),(2266,'Growthsharematrix.png','20041104172439!Growthsharematrix.png',2434,317,263,8,'updated BCG growth-share matrix',18084,'Tempshill','20041103213259','0','BITMAP','image','png',0,'5zouqwc6grety9osw0m8tbjsmpa7f5y'),(2267,'Growthsharematrix.png','20041104172747!Growthsharematrix.png',2434,317,263,8,'BCS growth-share matrix.  3rd attempt.',18084,'Tempshill','20041104172445','0','BITMAP','image','png',0,'5zouqwc6grety9osw0m8tbjsmpa7f5y'),(2268,'Growthsharematrix.png','20041104181032!Growthsharematrix.png',2444,317,263,8,'BCG growth-share matrix.  Corrected.',18084,'Tempshill','20041104172750','0','BITMAP','image','png',0,'34uhltn3smqlkpdl4072gpfrkohswwc'),(2269,'Us-senate-result-2004.PNG','20041105043705!Us_senate_result_2004.PNG',10109,506,313,8,'made by me {{PD}}',69381,'Willhsmit','20041105040006','0','BITMAP','image','png',0,'j7i6h1b5uyziqt9cn3fq88gh289e83k'),(2270,'Us-senate-result-2004.PNG','20041105044001!Us_senate_result_2004.PNG',10109,506,313,8,'',69381,'Willhsmit','20041105043712','0','BITMAP','image','png',0,'j7i6h1b5uyziqt9cn3fq88gh289e83k'),(2271,'Franklinwolinseal.png','20041105083558!Franklinwolinseal.png',12507,190,175,8,'Reverted to earlier revision',10823,'Nertzy','20041009221621','0','BITMAP','image','png',0,'soja8wko4e4xe1qr4e0dk4hgoidwvn6'),(2272,'Franklinwolinseal.png','20041105083612!Franklinwolinseal.png',33712,190,175,8,'Reverted to earlier revision',10823,'Nertzy','20041105083558','0','BITMAP','image','png',0,'bblk4hl7ooba3i0lqyl0kxl30v89jbt'),(2273,'Alps-composite-NASA.jpg','20041105140647!Alps_composite_NASA.jpg',103372,1024,425,8,'',86857,'Dbachmann','20041105140452','0','BITMAP','image','jpeg',0,'5teh87d7451lrmxporpj7ld37hs4x98'),(2274,'2000-US-elections-map.png','20041105144349!2000_US_elections_map.png',32628,800,495,8,'Created from [[:Image:Map of USA with state names.svg]]. {{GFDL}}',19009,'Ed g2s','20040925020618','0','BITMAP','image','png',0,'ols9lwtp48ypggu40mgjrottdtb4uns'),(2275,'Suisse-geographique.jpg','20041105145244!Suisse_geographique.jpg',206978,933,594,8,'Geographic map of Switzerland',6815,'Yann','20040221223748','0','BITMAP','image','jpeg',0,'k7vdnmmm9py2kxonx54ownqck7a4etn'),(2276,'NewZealandElectorates1978-Labeled.png','20041105163328!NewZealandElectorates1978-Labeled.png',36324,678,604,8,'Map of the 1978 New Zealand elections',25556,'Vardion','20041105121406','0','BITMAP','image','png',0,'q9ixmslkh3n3926arh0npf9hm1qku2m'),(2277,'Mykonos.jpg','20041105204104!Mykonos.jpg',70851,700,422,8,'Mykonos (hora)',13428,'Davidzuccaro','20040820223355','0','BITMAP','image','jpeg',0,'r4rusyc99z98hoidpytjukhk34tgzdf'),(2278,'Liz-Phair---Liz-Phair.jpg','20041106080853!Liz_Phair_-_Liz_Phair.jpg',8365,200,197,8,'Cover for the album \'\'[[Liz Phair (album)|Liz Phair]]\'\' by [[Liz Phair]] {{albumcover}}',110766,'DCEdwards1966','20041026031155','0','BITMAP','image','jpeg',0,'2mjml7fqm3mvvnoa5ik135ae4s96xya'),(2279,'San-Juan.jpg','20041106131355!San_Juan.jpg',20871,335,206,8,'',48296,'PHG','20041106062201','0','BITMAP','image','jpeg',0,'kfivju3gdrp42joy92rf9lcj0af7gls'),(2280,'Trafalgar.square.pidgeon.je.jpg','20041106150544!Trafalgar.square.pidgeon.je.jpg',495751,1600,1200,8,'One of the dubious pidgeons of Trafalgar Square in London.  I took this picture myself, and as such agree to it\'s use for all cases.',129884,'JamesErrico','20041106045132','a:24:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:9:\"CYBERSHOT\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:09:20 20:29:41\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/1250\";s:7:\"FNumber\";s:5:\"56/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:09:20 20:29:41\";s:17:\"DateTimeDigitized\";s:19:\"2004:09:20 20:29:41\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:5:\"10/10\";s:16:\"MaxApertureValue\";s:5:\"48/16\";s:12:\"MeteringMode\";i:2;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:1;s:11:\"FocalLength\";s:6:\"240/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'803kq0avvbhd5ubagcvkrjcjchrkzo7'),(2281,'Australian-salmon.png','20041106190250!Australian_salmon.png',26230,636,360,8,'from Gunther, 1880',33103,'Hadal','20041106185603','0','BITMAP','image','png',0,'n8tkw61npmjtl4v2ezb4g3nldmpksbj'),(2282,'Wexner.jpg','20041106215736!Wexner.jpg',83805,400,238,8,'Wexner Center photo, cropped and color balanced',29695,'Postdlf','20040414051812','a:29:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:19:\"Canon PowerShot S10\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:04:14 01:14:01\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:4:\"1/45\";s:7:\"FNumber\";s:5:\"28/10\";s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2000:08:02 20:25:52\";s:17:\"DateTimeDigitized\";s:19:\"2000:08:02 20:25:52\";s:22:\"CompressedBitsPerPixel\";s:3:\"3/1\";s:17:\"ShutterSpeedValue\";s:12:\"359914/65536\";s:13:\"ApertureValue\";s:12:\"194698/65536\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:5:\"28/10\";s:15:\"SubjectDistance\";s:10:\"65535/1000\";s:12:\"MeteringMode\";i:2;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:6:\"204/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"1600000/246\";s:21:\"FocalPlaneYResolution\";s:11:\"1200000/184\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'m24esfjz2xs4v3lzcoa4rvkay9k14lg'),(2283,'2uktax2004-5.png','20041107000711!2uktax2004-5.png',5663,500,500,8,'UK [[Income Tax]] and [[National Insurance]] ([[2004]]-[[2005]]) {{PD}} (made the chart myself with [[Gnuplot]] and [[Perl]])',4261,'Edward','20040707174641','0','BITMAP','image','png',0,'4x2t4iety2zuvdh6svo0jta8vjnbw7z'),(2284,'ELO-ELO2-album-cover.jpg','20041107020615!ELO_ELO2_album_cover.jpg',3716,143,143,8,'Electric Light Orchestra - Electric Light Orchestra II album cover',54496,'Auximines','20040401094451','0','BITMAP','image','jpeg',0,'je2fqmbq13tprokd8bxsoom3fcrilpz'),(2285,'StudentOWU.jpg','20041107050009!StudentOWU.jpg',11408,287,262,8,'Wesleyan Student',89888,'Xiaoping choi','20041107045413','0','BITMAP','image','jpeg',0,'op4ghic1ctwk0d5vb1ab1l90sr1r2kx'),(2286,'Kraftwerk-The-Man-Machine-album-cover.jpg','20041107134935!Kraftwerk_The_Man_Machine_album_cover.jpg',8481,143,143,8,'Kraftwerk - The Man Machine album cover',54496,'Auximines','20040401134231','0','BITMAP','image','jpeg',0,'4mc1bznjj2lj9u9mx43u41rp6xkwugs'),(2287,'Kraftwerk-Tour-De-France-Soundtracks-album-cover.jpg','20041107135136!Kraftwerk_Tour_De_France_Soundtracks_album_cover.jpg',7898,150,150,8,'Kraftwerk - Tour De France Soundtracks album cover',54496,'Auximines','20040401140335','0','BITMAP','image','jpeg',0,'6ragpfv7j8dkm3s6wgjefw59ulfx53v'),(2288,'Charles-Thomas-Longley.jpg','20041107222805!Charles_Thomas_Longley.jpg',77702,292,388,8,'Photo of [[Charles Thomas Longley]] by [[Lewis Carroll]], touched up by [[User:Dcoetzee|Derrick Coetzee]]. Original in public domain by expiration of copyright; changes placed in public domain by modifier. {{pd}}',13476,'Dcoetzee','20041107221716','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:11:07 17:17:05\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'atpuis0dzchy3o5nvzaddq625g1qs6i'),(2289,'SwimmingDockCropped--AmericanEnglish.jpg','20041108010704!SwimmingDockCropped--AmericanEnglish.jpg',15951,414,309,8,'{{GFDL}} <br> Picture taken by me May 2004 (from family property)',46219,'Niteowlneils','20041108002035','0','BITMAP','image','jpeg',0,'fcdeipna3k72m2sfudhv70qvqjs6bwu'),(2290,'SwimmingDockCropped--AmericanEnglish.jpg','20041108010906!SwimmingDockCropped--AmericanEnglish.jpg',75340,1110,525,8,'{{GFDL}} Picture taken by me May 2004 (from family property)',46219,'Niteowlneils','20041108010709','0','BITMAP','image','jpeg',0,'m37ndk4fe1wxl7y1rmz8ewlo1zar8rd'),(2291,'WashingtonStateFerryNisqually.jpg','20041108050511!WashingtonStateFerryNisqually.jpg',382989,1536,1024,8,'{{GFDL}} Taken by me, May 2004',46219,'Niteowlneils','20041108050217','0','BITMAP','image','jpeg',0,'m1dyu2jtwu8vu0azcprh7vs00xhak88'),(2292,'Machine-gun-fellatio-promo-shot.jpg','20041108063823!Machine_gun_fellatio_promo_shot.jpg',12407,190,250,8,'Machine Gun Fellatio promo shot',3861,'Chuq','20040918025849','0','BITMAP','image','jpeg',0,'6gua24isf9f0lz2hfed6j3xnzo7tail'),(2293,'Arnold-Schwarzenegger-sexual-harassment-protestors.JPG','20041108091417!Arnold_Schwarzenegger_sexual_harassment_protestors.JPG',38711,430,226,8,'crop pic',13833,'Reddi','20031117215058','a:24:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:9:\"CYBERSHOT\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2003:11:17 12:06:22\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/6400\";s:7:\"FNumber\";s:5:\"56/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:200;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2003:11:17 12:06:22\";s:17:\"DateTimeDigitized\";s:19:\"2003:11:17 12:06:22\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"48/16\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:21;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"80/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'73jfkiwdwlpouu9wqncbhblf3x6jt43'),(2294,'Piranha.jpg','20041108103232!Piranha.jpg',480390,983,809,8,'PD Pirahnas',131052,'Mjoachim','20041108102946','0','BITMAP','image','jpeg',0,'8ij9hyjdthn47mgrbb0wi1rfttnf4yu'),(2295,'PinkFloyd-London-66-67.jpg','20041108131223!PinkFloyd_London_66_67.jpg',6024,130,130,8,'Pink Floyd London \'66-\'67 album cover {{msg:fairuse}}',54496,'Auximines','20040331103043','0','BITMAP','image','jpeg',0,'ihvwgg2x1trk1xyu4jaotzax9a8mki6'),(2296,'Online-codes-highlevel.png','20041108202927!Online_codes_highlevel.png',12971,330,306,8,'High level view of Online Codes {{PD}}',87157,'Agl','20041108195714','0','BITMAP','image','png',0,'dcxh3joib6h7c77j1vj49sz4mqlkc7g'),(2297,'Lock15.png','20041109004136!Lock15.png',686,15,15,8,'{{GFDL}} Trying with a transparent PNG, I think it would look much better for the protected templates.',22631,'Frazzydee','20041109001821','0','BITMAP','image','png',0,'h9zbjjc7dy2hrnpefxjnzx3nhdkbs1g'),(2298,'Lock15.png','20041109004229!Lock15.png',543,15,15,8,'better?',22631,'Frazzydee','20041109004140','0','BITMAP','image','png',0,'s8nrf8d75d39bxf169rdy2cxd1qlkjn'),(2299,'Rhcp7.jpg','20041109125653!Rhcp7.jpg',6703,117,117,8,'',35203,'Uzi tany','20031220121448','0','BITMAP','image','jpeg',0,'e1jj7gs759q04h02zlepr9qg7i4vnpw'),(2300,'Rhcp1.jpg','20041109130302!Rhcp1.jpg',12598,117,117,8,'',35203,'Uzi tany','20031220114952','0','BITMAP','image','jpeg',0,'06d08wt79vxntv4jyzt85m9g4xp079r'),(2301,'Rhcp4.jpg','20041109130657!Rhcp4.jpg',7263,117,117,8,'',35203,'Uzi tany','20031220121126','0','BITMAP','image','jpeg',0,'q7ocfiywes5cwx3tb09neggd4lgmokg'),(2302,'Return-of-the-Rentals.jpg','20041109130912!Return_of_the_Rentals.jpg',3279,150,151,8,'album cover, uploaded as fair use',16924,'M123','20030822230150','0','BITMAP','image','jpeg',0,'ove5iafkw5qh1hmh0zgisszzxsou85x'),(2303,'Rush-Caress-of-Steel.jpg','20041109131242!Rush_Caress_of_Steel.jpg',4214,130,130,8,'Rush - \"Caress of Steel\" album cover',27822,'RedWolf','20031205045342','0','BITMAP','image','jpeg',0,'ruwteg1d0zava5kf8iu2wxvduonwdtv'),(2304,'Cartlinearlarge.png','20041109134909!Cartlinearlarge.png',185095,701,448,8,'a cartogram, a map in which the sizes of states have been rescaled according to their population.',38664,'Jacoplane','20041109120504','0','BITMAP','image','png',0,'8unsvtmd3k17gxq2m8dcpsyv42n1w0k'),(2305,'Cartlinearlarge.png','20041109135007!Cartlinearlarge.png',189341,701,448,8,'add color description',38664,'Jacoplane','20041109134951','0','BITMAP','image','png',0,'frn0a5vtzp262by0ycwozk27judxt7r'),(2306,'Cartlinearlarge.png','20041109135026!Cartlinearlarge.png',185095,701,448,8,'Reverted to earlier revision',38664,'Jacoplane','20041109135008','0','BITMAP','image','png',0,'8unsvtmd3k17gxq2m8dcpsyv42n1w0k'),(2307,'Alexa-reach-measurement-for-wikipedia.png','20041109195140!Alexa_reach_measurement_for_wikipedia.png',3176,480,328,8,'updated',88976,'Kbh3rd','20041021174341','0','BITMAP','image','png',0,'8vgn0l7s8jrsu5a6iq14544p6xft2bg'),(2308,'Alexa-traffic-ranking-for-wikipedia.png','20041109195254!Alexa_traffic_ranking_for_wikipedia.png',2382,432,240,8,'up to date',88976,'Kbh3rd','20041001212837','0','BITMAP','image','png',0,'f8g5vctbs53wt78cilp6e7lz4l68feq'),(2309,'Daily-page-requests-for-wikipedia.org.png','20041109195351!Daily_page_requests_for_wikipedia.org.png',3631,432,328,8,'Colors more in conformity w/ other graphs, i think',88976,'Kbh3rd','20040906173343','0','BITMAP','image','png',0,'lo0tireqpmzmlmrwnxs52kuyxqvktbr'),(2310,'Daily-page-requests-for-wikipedia.org-logscale.png','20041109195721!Daily_page_requests_for_wikipedia.org_logscale.png',3821,432,328,8,'Daily page requests for wikipedia.org, logarithmic scale',88976,'Kbh3rd','20040906173613','0','BITMAP','image','png',0,'lvzwumm9stosp5xw88ttmti1qyoqkzc'),(2311,'Daily-page-requests-for-wikipedia.org.png','20041109201150!Daily_page_requests_for_wikipedia.org.png',3802,432,328,8,'thru oct 2004',88976,'Kbh3rd','20041109195358','0','BITMAP','image','png',0,'73azgqrrkprg9ezq2fgak5oirvhzds4'),(2312,'Google-Answers-using-Wikipedia.png','20041109203524!Google_Answers_using_Wikipedia.png',2798,432,240,8,'up to date',88976,'Kbh3rd','20041001212946','0','BITMAP','image','png',0,'3808t2o3n25h14fuzq0j6l2gpeqp0fz'),(2313,'Google-News-stories-mentioning-Wikipedia.png','20041109203605!Google_News_stories_mentioning_Wikipedia.png',2462,432,240,8,'up to date',88976,'Kbh3rd','20041001213202','0','BITMAP','image','png',0,'p2fdjnczxfyzogyy2fbecsusquy40sf'),(2314,'More-specific-Usenet-posts-containing-the-word-Wikipedia.png','20041109203916!More_specific_Usenet_posts_containing_the_word_Wikipedia.png',4340,480,328,8,'up to date',88976,'Kbh3rd','20041001213233','0','BITMAP','image','png',0,'q0q50e2botoa12vlenfsnexqj0o275m'),(2315,'Usenet-posts-containing-the-word-Wikipedia.png','20041109204305!Usenet_posts_containing_the_word_Wikipedia.png',3151,480,328,8,'up to date',88976,'Kbh3rd','20041001213353','0','BITMAP','image','png',0,'bd8ftlcwj5oqr3wx8tu1dtwjodvmcxc'),(2316,'S327-coll-sqr-big-small.png','20041110072012!S327_coll-sqr-big-small.png',328485,300,351,8,'The pandal at College Square, Calcutta, which has a large lake in front.  The pandal is a full scale replica of the Coochbehar Palace in N. Bengal.  Photographed on May 16, 2004. ',60430,'Mukerjee','20041110062841','0','BITMAP','image','png',0,'fpowghfvb34o68rrluw37jip7e1kxxi'),(2317,'Zebra-tail-lizard.jpg','20041110090117!Zebra_tail_lizard.jpg',31413,400,274,8,'',65017,'Scott Burley','20041110090037','0','BITMAP','image','jpeg',0,'76qbew9ijyhn4czf4f2g1uird2lo1rw'),(2318,'The-Purple-Heart.jpg','20041110112453!The_Purple_Heart.jpg',1593322,1488,2240,8,'The Purple Heart',82826,'Solitude','20041110081759','a:35:{s:4:\"Make\";s:17:\"NIKON CORPORATION\";s:5:\"Model\";s:11:\"NIKON D100 \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:28:\"Adobe Photoshop Elements 2.0\";s:8:\"DateTime\";s:19:\"2004:09:02 13:36:27\";s:16:\"YCbCrPositioning\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:1;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:3:\"1/1\";s:21:\"FocalLengthIn35mmFilm\";i:82;s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:20:\"SubjectDistanceRange\";i:0;s:12:\"ExposureTime\";s:6:\"10/600\";s:7:\"FNumber\";s:5:\"63/10\";s:15:\"ExposureProgram\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2002:03:06 05:44:35\";s:17:\"DateTimeDigitized\";s:19:\"2002:03:06 05:44:35\";s:22:\"CompressedBitsPerPixel\";s:3:\"4/1\";s:17:\"ExposureBiasValue\";s:3:\"0/6\";s:16:\"MaxApertureValue\";s:5:\"30/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:6:\"550/10\";s:10:\"ColorSpace\";i:1;s:13:\"SensingMethod\";i:2;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'kb3azu4mdteqe5xc0e8bok6gx0n434o'),(2319,'Kilburn-Station,-London.honeydew.jpg','20041110190314!Kilburn_Station,_London.honeydew.jpg',129090,1280,960,8,'{{GDFL}} Taken by me on 6 Nov 2004',131711,'Honeydew','20041110184823','0','BITMAP','image','jpeg',0,'kv596e56lej36cpforrns9kogywep1n'),(2320,'Polarization-ellipse.png','20041110212153!Polarization_ellipse.png',8272,230,240,8,'',60494,'Russell E','20040528123915','0','BITMAP','image','png',0,'fwec5dzds377b1wzo1cykp2xp7cc2b5'),(2321,'Polarization-ellipse.png','20041110213139!Polarization_ellipse.png',7673,287,294,8,'Corrected image',46265,'Chinasaur','20041110212159','0','BITMAP','image','png',0,'4zstellrozwsvzaa8xau0ei11hwsp2s'),(2322,'Polarization-ellipse.png','20041110213305!Polarization_ellipse.png',11300,287,294,8,'Corrected version attempt 2',46265,'Chinasaur','20041110213142','0','BITMAP','image','png',0,'5ia5o4ce0zejaag771d949d2aitbimt'),(2323,'USPresidentialSeal-transparent-100px.png','20041111012113!USPresidentialSeal_transparent_100px.png',8230,100,101,8,'Previous images were either jaggy or did not work in IE',82899,'Rhobite','20041102190424','0','BITMAP','image','png',0,'8bsniibjfvqqnmxyjnq7jpx2ho92k2g'),(2324,'USPresidentialSeal-transparent-100px.png','20041111012148!USPresidentialSeal_transparent_100px.png',8473,100,101,8,'Reverted to earlier revision',20759,'Fvw','20041111012113','0','BITMAP','image','png',0,'fd9459ryvcb3kch4kacwgf77vklo7g4'),(2325,'Polarization-ellipse.png','20041111050556!Polarization_ellipse.png',7673,287,294,8,'Reverted to earlier revision',0,'67.180.36.239','20041110213305','0','BITMAP','image','png',0,'4zstellrozwsvzaa8xau0ei11hwsp2s'),(2326,'VulvaDiagram-800.jpg','20041111111738!VulvaDiagram-800.jpg',91242,800,568,8,'{{GFDL}} :: Notes on image -- I took this picture using a Nikon Coolpix 950. The model was over 18 years old, fully awake and aware of the photography taking place. I will not reveal any personal details about the model whatsoever, so do not bother inquir',53740,'PhiloVivero','20041106144850','a:26:{s:4:\"Make\";s:5:\"NIKON\";s:5:\"Model\";s:4:\"E950\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:7:\"v981-76\";s:8:\"DateTime\";s:19:\"1999:08:04 22:13:19\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/200\";s:7:\"FNumber\";s:5:\"34/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:0;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"1999:08:04 22:13:19\";s:17:\"DateTimeDigitized\";s:19:\"1999:08:04 22:13:19\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"26/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:6:\"146/10\";s:10:\"ColorSpace\";i:1;s:12:\"WhiteBalance\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'6vqxjd55bfuvki6d6ll285zq9fitpkh'),(2327,'Santorini.jpg','20041111183819!Santorini.jpg',71856,1024,768,8,'Santorini - Landsat photo',62689,'Balcer','20040829044631','0','BITMAP','image','jpeg',0,'bwky5b0mpsvz0pps5ron38vvpdbyle0'),(2328,'Africa-four-rail-triple-gauge.png','20041111220232!Africa_four_rail_triple_gauge.png',5342,436,146,8,'update existing diagram (added space measurements)',49236,'Zoney','20041001145412','0','BITMAP','image','png',0,'1li0su1epsuv6y3an9xnk6sm9ignkg7'),(2329,'Shipping-Zones.png','20041111234059!Shipping_Zones.png',175169,504,569,8,'Crappy map I made',35639,'Dmn','20041031100419','0','BITMAP','image','png',0,'3dqmj0qbcxlotaea04nnx7fh0egefwa'),(2330,'Cartlinearlarge.png','20041111234548!Cartlinearlarge.png',189341,701,448,8,'Reverted to earlier revision',38664,'Jacoplane','20041109135026','0','BITMAP','image','png',0,'frn0a5vtzp262by0ycwozk27judxt7r'),(2331,'Reene-ingrown-nail-postop.jpg','20041112040306!Reene_ingrown_nail_postop.jpg',11576,216,175,8,'This is a scan of my left big toe after surgery to remove an ingrown toenail.',99030,'Reene','20041111212708','0','BITMAP','image','jpeg',0,'1ogwggapq32nzvyztffxbu6z3k7f6mg'),(2332,'Fuzzyimage.png','20041112053730!Fuzzyimage.png',7225,182,92,8,'',4099,'Stevertigo','20030603101139','0','BITMAP','image','png',0,'qqms2nlmd1463yy28m9y8lotsnytbgu'),(2333,'Eperth.png','20041112080517!Eperth.png',2156,99,117,8,'East Perth logo',133774,'Pontsticill','20041112075755','0','BITMAP','image','png',0,'qbxptj6j22lp8e3ybymkyo9kpvoqaej'),(2334,'Alexander-James-Begg.jpg','20041112110417!Alexander_James_Begg.jpg',14892,300,400,8,'Picture of Alexander James Begg, [[User:AlexTheMartian]]',96850,'AlexTheMartian','20041027195941','0','BITMAP','image','jpeg',0,'8kd492t1j5ls88anyscd4novwsdztc2'),(2335,'VulvaDiagram-800.jpg','20041112120423!VulvaDiagram-800.jpg',106590,800,568,8,'better contrast',62,'Mav','20041111111741','0','BITMAP','image','jpeg',0,'pf1ylba6aakns2o00b7ekdl4rfsu52y'),(2336,'Odpusage.png','20041112155641!Odpusage.png',2218,544,326,4,'Numer of sites using ODP data.',5861,'Liftarn','20031127121459','0','BITMAP','image','png',0,'1vtychcmiwqcgx4w71oar3kzwdgjiqx'),(2337,'Ultima10.jpg','20041113135017!Ultima10.jpg',11121,320,240,8,'Ultima 10',133811,'Walleweasel','20041113133820','0','BITMAP','image','jpeg',0,'ss61fdiaafn0potl9irtt1iu5gorfoq'),(2338,'Africa-by-hdi.png','20041113142637!Africa_by_hdi.png',9650,360,392,8,'modified version of [[:Image:Africa-western-countries.png]] {{GFDL}}',1591,'SimonP','20041015035009','0','BITMAP','image','png',0,'6qmn9fsl16mwaapuk6a3py8yeynzmmc'),(2339,'NMOS-NAND-WITH-RESISTIVE-LOAD.PNG','20041113185013!NMOS_NAND_WITH_RESISTIVE_LOAD.PNG',9684,394,450,8,'NMOS NAND gate with generic load drawn by Allen Timothy Chang',44426,'Allentchang','20041113184111','0','BITMAP','image','png',0,'jlqwyv8ejsdseblcyz1ajkujttcjbkt'),(2340,'NMOS-NAND-WITH-RESISTIVE-LOAD.PNG','20041113185307!NMOS_NAND_WITH_RESISTIVE_LOAD.PNG',9684,394,450,8,'NMOS NAND gate with resistive load drawn by Allen Timothy Chang',44426,'Allentchang','20041113185021','0','BITMAP','image','png',0,'nw72x80fpwncokv8o7rsmi69i34urkh'),(2341,'NMOS-NAND-WITH-RESISTIVE-LOAD.PNG','20041113185345!NMOS_NAND_WITH_RESISTIVE_LOAD.PNG',9684,394,450,8,'Reverted to earlier revision',44426,'Allentchang','20041113185308','0','BITMAP','image','png',0,'jlqwyv8ejsdseblcyz1ajkujttcjbkt'),(2342,'CaryGilson.PNG','20041113194030!CaryGilson.PNG',1248,134,123,8,'Kes Cary Gilson House Tie',133301,'Wheatley000','20041113193131','0','BITMAP','image','png',0,'91w5bx1s28aghbgvybds8mc9bl0vdms'),(2343,'CSSRappahannock.jpg','20041113233838!CSSRappahannock.jpg',23351,623,325,8,'Photograph of CSS Rappahannock, ca. 1864',83591,'McMullen','20041113231602','0','BITMAP','image','jpeg',0,'3gow1288abd56qcg6snj8epl5mpzrf2'),(2344,'SingerBuildingView.jpg','20041114010355!SingerBuildingView.jpg',18221,251,281,8,'Manhattan view showing Singer Building, c. 1909, from stereocard',4444,'Infrogmation','20031016141914','0','BITMAP','image','jpeg',0,'djr2g7yho2dfghs5ia1zf15oimznmm9'),(2345,'European-Parliament-6th-term.png','20041114021725!European_Parliament_6th_term.png',4104,225,128,8,'Composition of the European Parliament as Sunday 14, 2004 (6th term). Image made by myself with an app I\'ve created.',82969,'Habbit','20041114021051','0','BITMAP','image','png',0,'kn8fvli5xmxt91ktlw1uw3snclxj62o'),(2346,'Tetracycline.png','20041114044009!Tetracycline.png',1972,399,183,4,'',0,'(Automated conversion)','20020720114935','0','BITMAP','image','png',0,'md22xg69hfevjsyl8h1cf9c6lbii5e9'),(2347,'Pretzel-Logic-album.jpg','20041114092614!Pretzel_Logic_album.jpg',19530,0,0,0,'Cover of [[Pretzel Logic]]',29184,'Calmypal','20040328180302','0','BITMAP','image','jpeg',0,'8tuu1wac4ijnqv3vgpmij3364ztp02e'),(2348,'Mary-Surratt.jpg','20041114141142!Mary_Surratt.jpg',13367,202,272,8,'[[Mary Surratt]]; from [http://members.aol.com/RVSNorton/Lincoln26.html]. Picture obviously pre-1923.<br>{{PD}}',34978,'Lupo','20041114140843','0','BITMAP','image','jpeg',0,'o568qrvorwe58iekoy2p226miwb65uk'),(2349,'Tabby-cat-domestic-shorthair-balthazar.jpg','20041114151752!Tabby-cat-domestic-shorthair-balthazar.jpg',143766,499,333,8,'Balthazar is a domestic shorthaired tabby cat.',13661,'Nohat','20040121172751','a:33:{s:16:\"ImageDescription\";s:31:\"OLYMPUS DIGITAL CAMERA         \";s:4:\"Make\";s:23:\"OLYMPUS OPTICAL CO.,LTD\";s:5:\"Model\";s:16:\"X-2,C-50Z       \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:13:\"4718592/65536\";s:11:\"YResolution\";s:13:\"4718592/65536\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:13:\"QuickTime 6.5\";s:8:\"DateTime\";s:19:\"2004:01:21 12:13:28\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:4:\"1/50\";s:7:\"FNumber\";s:5:\"40/10\";s:15:\"ExposureProgram\";i:5;s:15:\"ISOSpeedRatings\";i:320;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2003:03:23 21:21:34\";s:17:\"DateTimeDigitized\";s:19:\"2003:03:23 21:21:34\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:7:\"300/100\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:25;s:11:\"FocalLength\";s:8:\"1471/100\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:7:\"100/100\";s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'e4wsitrvy93qhrldtrbi77lbxr3f5zg'),(2350,'Africa-by-hdi.png','20041114170120!Africa_by_hdi.png',5717,360,392,4,'Countries in positions 1-120 are \"above 120\" not \"below 120\"',19009,'Ed g2s','20041113142640','0','BITMAP','image','png',0,'de2chvofgpo31b4p3dqotddqru4xmig'),(2351,'C-flanders.png','20041114172839!C-flanders.png',64429,375,444,8,'Ned Flanders. Fair Use. (General publicity photo issued. Such publicity photos are given out freely without restriction to all media outlets and are never copyrighted.)',6661,'PMelvilleAustin','20040314042249','0','BITMAP','image','png',0,'64zpny5exumzyzhzwsiwodg3mdss5bz'),(2352,'Love-in-a-Tub.png','20041114234603!Love_in_a_Tub.png',49032,281,303,8,'Scene from George Etherege, \'\'Love in a Tub\'\'. {{PD-art}}',85193,'Bishonen','20041112140340','0','BITMAP','image','png',0,'cc0fpcxq3vkn6tdx3o794x43qp5baz3'),(2353,'Nell-Gwyn.png','20041114234807!Nell_Gwyn.png',94476,178,225,8,'Nell Gwyn by Peter Lely. {{PD-art}}',85193,'Bishonen','20041108033149','0','BITMAP','image','png',0,'ca2o6as6st968wo9rnbhz8xp7xa4iod'),(2354,'Josie-hb.jpg','20041115012132!Josie_hb.jpg',48631,400,300,8,'screen capture from \'\'[[Josie and the Pussycats]]\'\' ([[1970]] TV show) {{fairuse}}',106704,'B Touch','20041115010800','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:11:14 20:07:15\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'9hrra1dl6dd6kadfoqg8qv2v4od38oc'),(2355,'Josie-hb.jpg','20041115012412!Josie_hb.jpg',48631,400,300,8,'screen capture from \'\'[[Josie and the Pussycats]]\'\' ([[1970]] TV show) {{fairuse}}',106704,'B Touch','20041115012138','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:11:14 20:07:15\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'9hrra1dl6dd6kadfoqg8qv2v4od38oc'),(2356,'Tetracycline2.png','20041115013330!Tetracycline2.png',7319,339,192,8,'Chemical structure of tetracycline, made by [[user:Jaguar2k]] in JChemPaint',109195,'Jaguar2k','20041114044213','0','BITMAP','image','png',0,'mfxdgum7936wiiqcm29lzuolv63dmxd'),(2357,'Love-in-a-Tub.png','20041115013512!Love_in_a_Tub.png',32822,281,303,8,'Fixed image with corrupt gamma information. Reduced size slightly.',72856,'Chmod007','20041114234612','0','BITMAP','image','png',0,'af1wezwuk25m23inq1r50nvojks7bo4'),(2358,'Modified-Nolan-Chart.png','20041115022050!Modified_Nolan_Chart.png',8684,299,249,8,'{{GFDL}}, I am the original author. In the article \"Communitarianism (ideology)\". It is a modified version of the Nolan chart, which is a 2d representation of the political spectrum.',80884,'Juan Ponderas','20040621034026','0','BITMAP','image','png',0,'362946qqzglrjmcxj6z3v9e92rp906o'),(2359,'Modified-Nolan-Chart.png','20041115022242!Modified_Nolan_Chart.png',48542,500,417,8,'A modified Nolan Chart',80884,'Juan Ponderas','20041115022059','0','BITMAP','image','png',0,'mkyj4ra0nrh90im5x2skz4pymievtak'),(2360,'Aus-img-small.jpg','20041115041506!Aus_img_small.jpg',31055,350,263,8,'Photo of [[user:Jimbo Wales]], {{msg:GFDL}}',24,'Jimbo Wales','20040501152130','0','BITMAP','image','jpeg',0,'em9q9r2qbmufffzwymb9cij4vexdraq'),(2361,'RIC-Crest.jpg','20041115145430!RIC_Crest.jpg',33683,135,133,8,'Royal Institute of Chemistry Crest',124766,'Knaggs','20041115144759','0','BITMAP','image','jpeg',0,'pt0knqgy05l7hq212tq3vzh26uc9lxz'),(2362,'Amkarlogo.png','20041115164427!Amkarlogo.png',2974,70,70,8,'FC Amkar Perm logo',97993,'Grue','20041113202614','0','BITMAP','image','png',0,'nbtgk9e2tbr4gikmsjky1b48nebojja'),(2363,'Chip-1985.jpg','20041115175034!Chip_1985.jpg',178582,805,573,8,'Chip  Greenman',135612,'Chip greenman','20041115174817','0','BITMAP','image','jpeg',0,'1mtyqzsrgbdd8bjpa9rr697m5niqf1f'),(2364,'Chip-1985.jpg','20041115175416!Chip_1985.jpg',178582,805,573,8,'Chip Greenman',135612,'Chip greenman','20041115175038','0','BITMAP','image','jpeg',0,'1mtyqzsrgbdd8bjpa9rr697m5niqf1f'),(2365,'Chip-1985.jpg','20041115175519!Chip_1985.jpg',178582,805,573,8,'Chip Greenman',135612,'Chip greenman','20041115175416','0','BITMAP','image','jpeg',0,'1mtyqzsrgbdd8bjpa9rr697m5niqf1f'),(2366,'EnteringMetz.jpg','20041116014334!EnteringMetz.jpg',59091,400,450,8,'\r\n{{PD-USGov-Military-Army}}',40277,'Oberiko','20041114212925','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"200/1\";s:11:\"YResolution\";s:5:\"200/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2003:06:04 14:50:37\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'pks9uu6dj4v5e0n4odxo1p2i1eiu63f'),(2367,'EnteringMetz.jpg','20041116014555!EnteringMetz.jpg',59091,400,354,8,'{{PD-USGov-Military-Army}}',40277,'Oberiko','20041116014334','0','BITMAP','image','jpeg',0,'g93ihyc6aoa5zeio16e7eafsubv33d9'),(2368,'HukaFalls-Taupo-NewZealand.jpg','20041116020119!HukaFalls-Taupo-NewZealand.jpg',94463,1024,680,8,'Huka Falls, near Lake Taupo.',53740,'PhiloVivero','20040328104244','0','BITMAP','image','jpeg',0,'lnuo9p8om6zfl7tmcez5ep3ar9ikum5'),(2369,'Us-senate-result-1994.PNG','20041116031830!Us_senate_result_1994.PNG',10148,506,313,8,'{{PD}}',69381,'Willhsmit','20041116025011','0','BITMAP','image','png',0,'2fce5gz2xkwkdvaf9jgl05hh8kq4lel'),(2370,'Cities-along-highway-401-ontario.png','20041116050247!Cities_along_highway_401_ontario.png',6647,514,320,4,'Cities along highway 401 Ontario',124348,'Geo Swan','20041116044225','0','BITMAP','image','png',0,'ollxw9d3nutktly2xdby1zisaaorblz'),(2371,'Cities-along-highway-401-ontario.png','20041116051127!Cities_along_highway_401_ontario.png',6674,514,320,4,'approximate path of highway 401 and the cities along it, in Ontario, Canada',124348,'Geo Swan','20041116050247','0','BITMAP','image','png',0,'2utwbuhnjd19mwqhtalxnyr636i0rgm'),(2372,'THFsynthesispathway.png','20041116061350!THFsynthesispathway.png',7767,426,267,8,'tetrahydrofolate synthesis pathway {{GFDL}}',38684,'Techelf','20040918112624','0','BITMAP','image','png',0,'sj7tdlzesvjunu5otpgb7mccm1p28i4'),(2373,'2004-us-hybrid2.jpg','20041116074442!2004_us_hybrid2.jpg',147487,674,345,8,'2004 us election, hybrid map of exit polls and vote count',9076,'Kevin Baas','20041116065651','0','BITMAP','image','jpeg',0,'3v7avxhe7h4eam6ic5fjz5rynhefbvt'),(2374,'Yangzi-river-coal-barge-loading-point.jpg','20041116111006!Yangzi_river_coal_barge_loading_point.jpg',96324,1024,768,8,'Coal barge loading point on the Yangzi River.  Coal is trucked to this point where coal barges are loaded for the trip downriver.  Photo taken Richard Chambers, AAA Yangtzi Sampler tour May 2004.',81864,'Richardelainechambers','20040813120513','0','BITMAP','image','jpeg',0,'d8zyv4ulneiu8x3kacjniqoncri00cf'),(2375,'Yangzi-river-shrines-on-hill-top.jpg','20041116111301!Yangzi_river_shrines_on_hill_top.jpg',120355,1024,768,8,'Photo of shrines on top of hillside on the banks of the Yangzi River.  Photo taken Richard Chambers, AAA Yangtzi Sampler tour, May 2004.',81864,'Richardelainechambers','20040813123409','0','BITMAP','image','jpeg',0,'t44hg4csfyfojhcturz60xbak82wcq9'),(2376,'Littleboy01.jpg','20041116151814!Littleboy01.jpg',9618,206,176,8,'little kublai',126311,'Kublai','20041116151405','0','BITMAP','image','jpeg',0,'q9x6znsw5px2rov1civ2h9k9ko7knim'),(2377,'Wikipedia-banner0002.png','20041116182445!Wikipedia-banner0002.png',96506,483,163,8,'more minor touchups',22631,'Frazzydee','20040816212648','0','BITMAP','image','png',0,'7idztqtr9tg4m2bku6d3ozem2ga0eh3'),(2378,'Wikipedia-banner0002.png','20041116195438!Wikipedia-banner0002.png',96506,483,163,8,'Reverted to earlier revision',29678,'Mirv','20041116190556','0','BITMAP','image','png',0,'7idztqtr9tg4m2bku6d3ozem2ga0eh3'),(2379,'Wikipedia-banner0002.png','20041116230910!Wikipedia-banner0002.png',96506,483,163,8,'Reverted to earlier revision',91937,'FirstPrinciples','20041116225321','0','BITMAP','image','png',0,'7idztqtr9tg4m2bku6d3ozem2ga0eh3'),(2380,'Finite-element-triangulation.png','20041117003645!Finite_element_triangulation.png',31978,461,376,8,'The picture of a piecewise linear function. I created it today with Matlab.  {{PD}}',136527,'Olegalexandrov','20041117001524','0','BITMAP','image','png',0,'du77t7ks555nswrd84ysj5jnkkqg9ho'),(2381,'Us-senate-result-1992.PNG','20041117040130!Us_senate_result_1992.PNG',10177,506,313,8,'{{PD}}',69381,'Willhsmit','20041116030541','0','BITMAP','image','png',0,'ldw92oanpw6e9cembn0ia1q7jfi3bkk'),(2382,'Us-senate-result-1994.PNG','20041117040141!Us_senate_result_1994.PNG',10124,506,313,8,'',69381,'Willhsmit','20041116031830','0','BITMAP','image','png',0,'42p7os7vylemyx9bf82tnbdspupo5ht'),(2383,'Us-senate-result-1996.PNG','20041117040151!Us_senate_result_1996.PNG',10143,506,313,8,'{{PD}} made by me',69381,'Willhsmit','20041116020414','0','BITMAP','image','png',0,'4ssre6h65jfdc1796ljjtvemwy4zp4k'),(2384,'Us-senate-result-1998.PNG','20041117040205!Us_senate_result_1998.PNG',10144,506,313,8,'made by me {{PD}}',69381,'Willhsmit','20041105222358','0','BITMAP','image','png',0,'tfwlpw1xpr526wsvhwqxpto55vcdqak'),(2385,'Us-senate-result-2002.PNG','20041117040230!Us_senate_result_2002.PNG',10088,506,313,8,'made by me {{PD}}',69381,'Willhsmit','20041105041211','0','BITMAP','image','png',0,'jifcc0m82ub7g37syjj4bjarheyb92e'),(2386,'Us-senate-result-2004.PNG','20041117040241!Us_senate_result_2004.PNG',10040,506,313,8,'',69381,'Willhsmit','20041105044003','0','BITMAP','image','png',0,'9txowcr08y6a0wys7uvn2x78u3fcimo'),(2387,'Wikipedia-banner0002.png','20041117055417!Wikipedia-banner0002.png',96506,483,163,8,'Reverted to earlier revision',91937,'FirstPrinciples','20041117004901','0','BITMAP','image','png',0,'7idztqtr9tg4m2bku6d3ozem2ga0eh3'),(2388,'Wikipedia-banner0002.png','20041117060328!Wikipedia-banner0002.png',96506,483,163,8,'Reverted to earlier revision',7580,'Ahoerstemeier','20041117055712','0','BITMAP','image','png',0,'7idztqtr9tg4m2bku6d3ozem2ga0eh3'),(2389,'Bas-saint-laurent.PNG','20041117065529!Bas-saint-laurent.PNG',15516,418,480,8,'in Que.',26201,'Earl Andrew','20041116194138','0','BITMAP','image','png',0,'50fkwuy1z0mp770ehsd99vtmz91e3uh'),(2390,'Wikipedia-banner0002.png','20041117081928!Wikipedia-banner0002.png',96506,483,163,8,'Reverted to earlier revision',33103,'Hadal','20041117060625','0','BITMAP','image','png',0,'7idztqtr9tg4m2bku6d3ozem2ga0eh3'),(2391,'Wikipedia-banner0002.png','20041117083445!Wikipedia-banner0002.png',96506,483,163,8,'Reverted to earlier revision',4,'Magnus Manske','20041117082148','0','BITMAP','image','png',0,'7idztqtr9tg4m2bku6d3ozem2ga0eh3'),(2392,'Wikipedia-banner0002.png','20041117083710!Wikipedia-banner0002.png',96506,483,163,8,'Reverted to earlier revision',96850,'AlexTheMartian','20041117083519','0','BITMAP','image','png',0,'7idztqtr9tg4m2bku6d3ozem2ga0eh3'),(2393,'Wikipedia-banner0002.png','20041117084621!Wikipedia-banner0002.png',96506,483,163,8,'Reverted to earlier revision',7580,'Ahoerstemeier','20041117083749','0','BITMAP','image','png',0,'7idztqtr9tg4m2bku6d3ozem2ga0eh3'),(2394,'England-NormandsPlantagenets.png','20041117103546!England-NormandsPlantagenets.png',61336,1139,2234,1,'Family tree drawn by [[User:Muriel Gottrop|Muriel Gottrop]] (November 2004) {{GFDL}}',8201,'Muriel Gottrop','20041117103229','0','BITMAP','image','png',0,'sbaejxzojuwkn0vndp86ld2vpctn027'),(2395,'Wikipedia-banner0002.png','20041117194151!Wikipedia-banner0002.png',96506,483,163,8,'Reverted to earlier revision',33103,'Hadal','20041117084736','0','BITMAP','image','png',0,'7idztqtr9tg4m2bku6d3ozem2ga0eh3'),(2396,'Estonia-FA.gif','20041118162412!Estonia_FA.gif',4267,150,150,6,'Estonia FA, by http://www.hqfl.dk',75150,'Dryazan','20041030152952','0','BITMAP','image','gif',0,'s1dy2aofo7gpmniok1mx7zgvgdgdyln'),(2397,'Portugal-FPF-crest.png','20041118162639!Portugal_FPF_crest.png',6473,142,187,8,'Portuguese Football Federation crest',42276,'DragonFire','20040405164622','0','BITMAP','image','png',0,'h0dys8gszy179xdl30zn5fk1z5eld67'),(2398,'SwimmingDockCropped--AmericanEnglish.jpg','20041118184221!SwimmingDockCropped--AmericanEnglish.jpg',55434,1110,525,8,'{{GFDL}} Picture taken by me May 2004 (from family property)',46219,'Niteowlneils','20041108010909','0','BITMAP','image','jpeg',0,'3qjekgd6zwtc9ca2ajgo9e0u87zaw45'),(2399,'EU-blank-no-rivers-territories256.png','20041118223803!EU_blank_no_rivers_territories256.png',28952,510,452,8,'Updated to show Croatia candidacy',49236,'Zoney','20040618114326','0','BITMAP','image','png',0,'dhfppyvbeyc8xlxqev1tj2ru0dpu2qw'),(2400,'EU-blank-no-rivers-territories256.png','20041118225906!EU_blank_no_rivers_territories256.png',37391,505,452,8,'New version of map - redone, errors fixed, recoloured.',49236,'Zoney','20041118223804','0','BITMAP','image','png',0,'hhr6zvh9zw9w4siwb37wo73yahg0f8m'),(2401,'Metallocenes.png','20041119085920!Metallocenes.png',30110,1181,414,8,'{{PD}} Metallocenes for olefin polymerization catalysts',117006,'Kobone','20041119085229','0','BITMAP','image','png',0,'a8mz7znyvwdgmjehhc2ekac90huhla3'),(2402,'Metallocenes2.png','20041119091921!Metallocenes2.png',22272,787,276,8,'{{PD}} Metallocenes for olefin polymerization catalysts',117006,'Kobone','20041119091451','0','BITMAP','image','png',0,'ls5rqpdjl3ah2kyyhk73k5tm2sgo1pa'),(2403,'JK-the-Unwise.jpg','20041119124359!JK_the_Unwise.jpg',9575,404,442,8,'Jk the unwise',136062,'JK the unwise','20041119124019','0','BITMAP','image','jpeg',0,'1ved5t2fb0oo0h0ddufopjj9qemq1pa'),(2404,'JK-the-Unwise.jpg','20041119124852!JK_the_Unwise.jpg',5531,202,221,8,'Jk the unwise',136062,'JK the unwise','20041119124359','0','BITMAP','image','jpeg',0,'torwj40ursmt048bij806i1xwkepm3f'),(2405,'VCReginaldClareHart.jpg','20041119130205!VCReginaldClareHart.jpg',24138,175,239,8,'Photo of Victoria Cross recipient Reginald Clare Hart, migrated from the Victoria Cross Reference site with permission. Photo submitted by Gerald Napier - (from the Royal Engineers Library with permission). ',135781,'Historian','20041119125614','0','BITMAP','image','jpeg',0,'sqlnmaxll6a5hztzak3mndj5tb0e1il'),(2406,'Orzel-Senatu.jpg','20041119141126!Orzel_Senatu.jpg',27389,84,140,8,'{{pd}}',60647,'Emax','20041115182245','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:6:\"5000/1\";s:11:\"YResolution\";s:6:\"5000/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:8:\"DateTime\";s:19:\"2004:11:15 19:21:28\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'sag4368mmi09fp8wuzglew33ssrl3wx'),(2407,'Jimbo-more-like-Angela.jpg','20041119154824!Jimbo_more_like_Angela.jpg',11281,84,398,8,'imbo_more_like_Angela.jpg',101662,'Duk','20041114210322','0','BITMAP','image','jpeg',0,'ch4rbupk11hd637kf4n83kjerrlfmug'),(2408,'York-millenium-bridge.jpg','20041119194519!York_millenium_bridge.jpg',86006,800,422,8,'York Millennium Bridge.  Photo taken November 2003.',102856,'Johnteslade','20040922193030','a:24:{s:16:\"ImageDescription\";s:31:\"OLYMPUS DIGITAL CAMERA         \";s:4:\"Make\";s:23:\"OLYMPUS OPTICAL CO.,LTD\";s:5:\"Model\";s:16:\"C720UZ          \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"144/1\";s:11:\"YResolution\";s:5:\"144/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:8:\"DateTime\";s:19:\"2004:09:22 20:31:49\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:5:\"1/250\";s:7:\"FNumber\";s:5:\"34/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"0000:00:00 00:00:00\";s:17:\"DateTimeDigitized\";s:19:\"0000:00:00 00:00:00\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:7:\"300/100\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:8:\"1633/100\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'1sed8l29bfukjn52v822aawmkyn5dea'),(2409,'Camassia-quamash.jpg','20041120182907!Camassia-quamash.jpg',42623,600,900,8,'Common camas or Indian Camas',86574,'Robbiegiles','20040801021900','0','BITMAP','image','jpeg',0,'nh7dvc9gfhct7mksqddbgiz4f25hr28'),(2410,'Camassia-quamash.jpg','20041120183400!Camassia-quamash.jpg',77242,593,823,8,'crop white borders',17226,'Grendelkhan','20041120182907','0','BITMAP','image','jpeg',0,'2d718ttp6yum8uooeliehpxzyq12a53'),(2411,'Neotropic.png','20041120211951!Neotropic.png',48812,1096,744,8,'[[Neotropic]] Ecozone - redrawn from French wiki by ~~~',38759,'MPF','20041120161919','0','BITMAP','image','png',0,'agnku39uzqh17xt1w8p5nor28o9zvm5'),(2412,'Eperth.png','20041121014139!Eperth.png',4791,99,117,8,'East Perth logo',133774,'Pontsticill','20041112080528','0','BITMAP','image','png',0,'1ln2jsat98iru3w7m5rnblza0m5nfk2'),(2413,'TinaTurnerPrivateDancer.jpg','20041121055823!TinaTurnerPrivateDancer.jpg',8352,200,200,8,'Tina Turner \"Private Dancer\" album cover',8351,'TUF-KAT','20030315201106','0','BITMAP','image','jpeg',0,'2hklpo71w9vgcli8hb296x2e27sakex'),(2414,'Israel-and-arab-states-map.png','20041121083101!Israel_and_arab_states_map.png',8208,336,188,8,'Based on [[Image:BlankMap-World.png]], hence {{GFDL}}',31851,'Humus sapiens','20041121074221','0','BITMAP','image','png',0,'set8sqwnpxohjwq2uzclzzi4qbe8zo9'),(2415,'Grain3.jpg','20041121132851!Grain3.jpg',81314,353,472,8,'Cover of 2003 book. I am the author/editor of this book.',137225,'Bhob','20041121132510','0','BITMAP','image','jpeg',0,'5h89jbrpr6erctrd6zls4z0ylqn45mt'),(2416,'Grain3.jpg','20041121133232!Grain3.jpg',81314,353,472,8,'Biographical anthology of Wood published by TwoMorrows in 2003.',137225,'Bhob','20041121132851','0','BITMAP','image','jpeg',0,'5h89jbrpr6erctrd6zls4z0ylqn45mt'),(2417,'Grain3.jpg','20041121133336!Grain3.jpg',81314,353,472,8,'Reverted to earlier revision',137225,'Bhob','20041121133233','0','BITMAP','image','jpeg',0,'5h89jbrpr6erctrd6zls4z0ylqn45mt'),(2418,'Paris-Landsat.jpg','20041121155311!Paris_Landsat.jpg',85132,432,432,8,'A closer up Paris LANDSAT',15708,'WhisperToMe','20040203070344','0','BITMAP','image','jpeg',0,'mh3kggqxiuezf24su8i3mu286mirwfs'),(2419,'Nontron-logo.png','20041121161757!Nontron_logo.png',686,200,200,1,'traditional logo found on Nontron knives {{GFDL}}',88434,'Flapdragon','20041121161209','0','BITMAP','image','png',0,'ttf2vry04jm4smfsde1nf7tnqk3ib98'),(2420,'VulvaDiagram-800.jpg','20041121164746!VulvaDiagram-800.jpg',95282,800,568,8,'Diagram of the Human Vulva -- Text made simpler, moved to right, lines made semitransparent, \"obscured\" removed, image lightened (aesthetically pleasing).',53740,'PhiloVivero','20041112120433','a:26:{s:4:\"Make\";s:5:\"NIKON\";s:5:\"Model\";s:4:\"E950\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:7:\"v981-76\";s:8:\"DateTime\";s:19:\"1999:08:04 22:13:19\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/200\";s:7:\"FNumber\";s:5:\"34/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:0;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"1999:08:04 22:13:19\";s:17:\"DateTimeDigitized\";s:19:\"1999:08:04 22:13:19\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"26/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:6:\"146/10\";s:10:\"ColorSpace\";i:1;s:12:\"WhiteBalance\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'oz8epeuphjbyut86w36on1dj15lui8u'),(2421,'VulvaDiagram-800.jpg','20041121164823!VulvaDiagram-800.jpg',106590,800,568,8,'Reverted to earlier revision',129610,'VerTiCal','20041121164746','0','BITMAP','image','jpeg',0,'pf1ylba6aakns2o00b7ekdl4rfsu52y'),(2422,'Dankojones.gif','20041121184317!Dankojones.gif',19122,118,118,8,'self titled',139134,'Alyssac','20041121182609','0','BITMAP','image','gif',0,'mvueyzmb8ekmlu7qacrk7t8ga32z3em'),(2423,'Stagecoach-A1-Service-bus.JPG','20041121210057!Stagecoach_A1_Service_bus.JPG',783262,2288,1712,8,'A Stagecoach A1 Service bus in Ardrossan, Ayrshire.',138559,'Ayrshire--77','20041121205159','a:34:{s:16:\"ImageDescription\";s:31:\"OLYMPUS DIGITAL CAMERA         \";s:4:\"Make\";s:19:\"OLYMPUS CORPORATION\";s:5:\"Model\";s:6:\"C765UZ\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:7:\"v777-76\";s:8:\"DateTime\";s:19:\"2004:09:04 15:51:04\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/8000\";s:7:\"FNumber\";s:5:\"56/10\";s:15:\"ExposureProgram\";i:5;s:15:\"ISOSpeedRatings\";i:64;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:09:04 15:51:04\";s:17:\"DateTimeDigitized\";s:19:\"2004:09:04 15:51:04\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"34/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:5:\"94/10\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:5:\"0/100\";s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'5nflw3mqfwylppwtxny2r3d9rasu5nr'),(2424,'Polyvinyl-acetate-formula.png','20041121221811!Polyvinyl_acetate_formula.png',1145,314,124,8,'polyvinyl acetate formula',139245,'Twisp','20041121220121','0','BITMAP','image','png',0,'bdq9n9wivupy8vvhu1582ftkkm8xcjh'),(2425,'Skin-shade-map.gif','20041121234138!Skin_shade_map.gif',99378,705,383,8,'Remake of Image:Map_of_skin_color_distribution.gif See that image history for original source. This image has been fairly substantially changed.',16559,'Patrick0Moran','20041121093439','0','BITMAP','image','gif',0,'h251bgsuhclrfocmzv2c0vv1af5wvji'),(2426,'Presque-isle-from-plane.jpg','20041122014603!Presque_isle_from_plane.jpg',226791,1836,1140,8,'Presque Isle State Park, known to locals as \"the peninsula.\" This photo was taken from an airplane by Wikipedia user JoeW. The image is copyrighted, but is free to use for any purpose.',139351,'JoeW','20041122013300','0','BITMAP','image','jpeg',0,'j20wl2dqi00qmqx8kym66ulwgdepu91'),(2427,'Presque-isle-from-plane.jpg','20041122014918!Presque_isle_from_plane.jpg',14259,501,216,8,'Presque Isle State Park, known to locals as \"the peninsula.\" This photo was taken from an airplane by Wikipedia user JoeW. The image is copyrighted, but is free to use for any purpose.',139351,'JoeW','20041122014603','0','BITMAP','image','jpeg',0,'pfhc2nah61w665jenqsmc19x6nlcxrb'),(2428,'Presque-isle-from-plane.jpg','20041122014947!Presque_isle_from_plane.jpg',226791,1836,1140,8,'Reverted to earlier revision',139351,'JoeW','20041122014918','0','BITMAP','image','jpeg',0,'j20wl2dqi00qmqx8kym66ulwgdepu91'),(2429,'Ozbook03illo.jpeg','20041122063855!Ozbook03illo.jpeg',76822,350,350,8,'A color illustration by John R. Neill, from Ozma of Oz (1907). Now out of copyright.',134284,'Saroz162','20041122062909','0','BITMAP','image','jpeg',0,'ay3f4bq4f9yfrndhv9hupr8evh9aqsx'),(2430,'Relative-NPC-chart.PNG','20041122074413!Relative_NPC_chart.PNG',9856,356,472,8,'NP Complete',9697,'Poor Yorick','20030619030003','0','BITMAP','image','png',0,'i92dcpbybxzzsi87l0yxv05mhztcpef'),(2431,'Omeprazole.png','20041122103942!Omeprazole.png',2458,288,120,8,'molecular structure of omeprazole {{GFDL}} (revised)',38684,'Techelf','20041004140841','0','BITMAP','image','png',0,'ahcw3l98xc47e26itkpl508rwbz04ad'),(2432,'Captopril.png','20041122113011!Captopril.png',1566,147,104,8,'molecular structure of captopril',38684,'Techelf','20040701075441','0','BITMAP','image','png',0,'786vcbre026yqidbkuu1wcjeilwx08f'),(2433,'Fosinoprilat.png','20041122114018!Fosinoprilat.png',2192,334,104,8,'molecular structure of fosinoprilat',38684,'Techelf','20040701115053','0','BITMAP','image','png',0,'jaub9wjb6f44la9dh2mc73syi1hayd0'),(2434,'RenfrewshireJohnstone.png','20041122145240!RenfrewshireJohnstone.png',5846,200,149,8,'{{PD-self}} ',56643,'K851jg2','20041122145201','0','BITMAP','image','png',0,'e26qdukm8ppbovmphv4ta1jcc12gj8h'),(2435,'ShiHuangDi.jpg','20041123010414!ShiHuangDi.jpg',7154,150,270,8,'{{PD}}',70570,'Hardouin','20041123010211','0','BITMAP','image','jpeg',0,'jy9p9cv7vdsa4i4w3cdpjhfcanvbgkp'),(2436,'Seganomad.jpg','20041123051016!Seganomad.jpg',24280,400,300,8,'Smaller image of a picture I took',60132,'Armaced','20041123050800','0','BITMAP','image','jpeg',0,'kf1pznqi6e8o07wpv24gmzkpygf4hky'),(2437,'Yuan-genealogy.png','20041123080332!Yuan_genealogy.png',24002,1024,768,8,'{{GFDL}}',7930,'Nanshu','20041101065203','0','BITMAP','image','png',0,'iondfn2hy15wy4tebwktask1682rwg0'),(2438,'Grutness.jpg','20041123080736!Grutness.jpg',4054,80,33,8,'sig logo for User:Grutness',117878,'Grutness','20041123080416','0','BITMAP','image','jpeg',0,'6aq8n5s80fitucdmrznsos8qm5hldbh'),(2439,'Grutness.jpg','20041123082208!Grutness.jpg',1031,44,17,8,'sig logo for User:Grutness',117878,'Grutness','20041123080736','0','BITMAP','image','jpeg',0,'g5igob3bkko0e7a7wcgqv803m5q6asa'),(2440,'IndiaNumbered2.png','20041123095142!IndiaNumbered2.png',20286,300,365,8,'Modified the file',41228,'Nichalp','20041009193134','0','BITMAP','image','png',0,'41zcw005rloo9yq87mpkrhot9ftpdg8'),(2441,'Uk-south-seven-sisters.jpg','20041123135511!Uk_south_seven_sisters.jpg',18933,292,185,8,'The Seven Sisters near Beachy Head in the South of England',8689,'Diruwiki','20030922141943','0','BITMAP','image','jpeg',0,'6tdmnk5ovyj1c0y3ifpw6xi2lqtns77'),(2442,'Skin-shade-map.gif','20041123163759!Skin_shade_map.gif',140365,937,507,8,'Revised version of file by the same name.',16559,'Patrick0Moran','20041121234138','0','BITMAP','image','gif',0,'787v3vl4sr2rhvio7ijyls5uck65mje'),(2443,'Jagiellon-Genealogy.png','20041124010632!Jagiellon_Genealogy.png',57734,1603,1109,8,'{{GFDL}}',48983,'Kpalion','20041116033109','0','BITMAP','image','png',0,'sv17j8g8uqmd26b9td409jw9tf8i69h'),(2444,'Thad-Jones.jpg','20041124051100!Thad_Jones.jpg',22582,391,500,8,'Thad Jones',101662,'Duk','20041124050348','0','BITMAP','image','jpeg',0,'4y4gzza9x2yz5q02x2axqru77s21bce'),(2445,'Alexander-James-Begg.jpg','20041124104103!Alexander_James_Begg.jpg',62207,691,518,8,'[[User:AlexTheMartian]]',96850,'AlexTheMartian','20041112110427','0','BITMAP','image','jpeg',0,'rftjk2et4my7tdltn7dkluu68ed7tm1'),(2446,'Star.jpg','20041125034023!Star.jpg',551814,484,380,0,'picture of Betelguese',16822,'Dinopup','20040321150632','0','BITMAP','image','x-bmp',0,'r78nbn50q9enhuzmby481aj2vciissz'),(2447,'EastVictoriaHwy.jpg','20041125034853!EastVictoriaHwy.jpg',115253,1070,1002,8,'{{pd}}',37448,'Fikri','20041124084818','0','BITMAP','image','jpeg',0,'nwrkyvdp13s5vj7tkz8uwswehreabxe'),(2448,'EastVictoriaHwy.jpg','20041125035153!EastVictoriaHwy.jpg',123732,1051,991,8,'Interstate links, insert Omeo hwy and other tidy ups',37448,'Fikri','20041125034853','0','BITMAP','image','jpeg',0,'tbkjq8kk31ix9x4fmm8rzvqkbbbbtf2'),(2449,'EastVictoriaHwy.jpg','20041125035316!EastVictoriaHwy.jpg',115253,1070,1002,8,'Reverted to earlier revision',37448,'Fikri','20041125035154','0','BITMAP','image','jpeg',0,'nwrkyvdp13s5vj7tkz8uwswehreabxe'),(2450,'Luche-reduction.gif','20041125054836!Luche_reduction.gif',15828,787,300,8,'Luche reduction of carvone',131355,'Walkerma','20041125054036','0','BITMAP','image','gif',0,'fn6o6unmuqcv4a9juyblboqdat9m4m8'),(2451,'Jagiellon-Genealogy.png','20041125125223!Jagiellon_Genealogy.png',42924,1593,771,8,'new version',48983,'Kpalion','20041124010632','0','BITMAP','image','png',0,'aktmo320ulf5j9vo9yyrt6zlb1w04vs'),(2452,'Enigma-baldwin.jpg','20041125143839!Enigma-baldwin.jpg',103621,1024,768,8,'German Army/GAF Enigma serial number 2229 Original photo for Wikipedia.{{PD}}',50457,'Matt Crypto','20041027121229','0','BITMAP','image','jpeg',0,'0ni4cgu3hzgfwj26goetzpqm60g3dnw'),(2453,'Peter-Wolf---Up-to-No-Good.JPG','20041126023955!Peter_Wolf_-_Up_to_No_Good.JPG',15401,216,210,8,'Cover for album \'\'[[Up to No Good]]\'\' by [[Peter Wolf]]. {{albumcover}}',110766,'DCEdwards1966','20041126023830','0','BITMAP','image','jpeg',0,'7hqxm00hax4fgkyapbyuoxir1m9i2ze'),(2454,'Yukonwikimap.PNG','20041126024142!Yukonwikimap.PNG',172582,863,926,8,'Map of the Yukon my creation',26201,'Earl Andrew','20041125230521','0','BITMAP','image','png',0,'1cup85kru4jhu37kukntlahgc1bw1ev'),(2455,'Peter-Wolf---Up-to-No-Good.JPG','20041126024218!Peter_Wolf_-_Up_to_No_Good.JPG',15401,216,210,8,'Cover for album \'\'[[Up to No Good]]\'\' by [[Peter Wolf]]. {{albumcover}}',110766,'DCEdwards1966','20041126023955','0','BITMAP','image','jpeg',0,'7hqxm00hax4fgkyapbyuoxir1m9i2ze'),(2456,'Couscous.jpg','20041126073242!Couscous.jpg',30379,423,400,8,'Photo I just took of some \'instant\' couscous, feel free to replace it by something better!',18338,'Flyingbird','20040229220248','0','BITMAP','image','jpeg',0,'7ggtiebfyte0gquc1lct4xfr960kfpt'),(2457,'Beatles-singles-heyjude-uk.jpg','20041126155128!Beatles-singles-heyjude-uk.jpg',11337,170,170,8,'The UK single cover for Hey Jude',53685,'ChicXulub','20040725232636','0','BITMAP','image','jpeg',0,'8k6zs75x4c7zfj9hva9bih8f5yq9i5q'),(2458,'Bell-222.jpg','20041126160254!Bell_222.jpg',2347,141,106,8,'Bell 222 from vandenberg.af.mil',35839,'Rsduhamel','20041126071745','0','BITMAP','image','jpeg',0,'1qn4xjpjbhknzpbcwyagzenlcnph34f'),(2459,'Bell-222.jpg','20041126161458!Bell_222.jpg',10921,159,119,8,'',35839,'Rsduhamel','20041126160254','0','BITMAP','image','jpeg',0,'o3lim8347t932pyhh81jqgu1v8zwc5c'),(2460,'Npn-structure.png','20041126212230!Npn-structure.png',2914,342,376,8,'npn transistor structure and circuit',2954,'Heron','20041126211710','0','BITMAP','image','png',0,'lhtsrg2hvxoce05632oeufy5s5jcfnq'),(2461,'Ketamine.png','20041127025732!Ketamine.png',1921,96,101,8,'corrected wrong structure',88116,'Mykhal','20040819141041','0','BITMAP','image','png',0,'fy1ngds2oj7al4xt99vsf8s82djhjsj'),(2462,'Benjamin-Rush.png','20041127045845!Benjamin_Rush.png',456543,572,728,8,'Half-length [[portrait]] of Dr. [[Benjamin Rush]], an [[Founding Father of the United States|Founding Father]] of the [[United States]].  [[Engraving]] by James Barton Longacre ([[1794]]&ndash;[[1869]]), from [[painting]] by Thomas Sully ([[1783]]&ndash;[',68411,'Neutrality','20041118022408','0','BITMAP','image','png',0,'msxirq0lzlvv2us4q3drgz2zib8ihyq'),(2463,'Benjamin-Rush.png','20041127050301!Benjamin_Rush.png',347225,572,728,8,'pngout-ed',86399,'Berkut','20041127045845','0','BITMAP','image','png',0,'mxqkrw721u2trageuety7vkoan2u4f6'),(2464,'WilliamIII.png','20041127053426!WilliamIII.png',80268,163,217,8,'William III of England, detail from Peter Lely, {PD-art}',85193,'Bishonen','20041105111708','0','BITMAP','image','png',0,'5s4fs7dnpbmwcc7h3e3kkpvyj3yydsg'),(2465,'Upham-1-NZ.JPG','20041127071818!Upham_1_NZ.JPG',144073,640,480,8,'Photo taken by myself of the resting place of Sir Charles Upham',142135,'ANZac','20041127070415','0','BITMAP','image','jpeg',0,'8wpx4pj11ky2a6zufidwnilnkwhb8lu'),(2466,'Location-arithmetic-2counter.gif','20041127170504!Location_arithmetic_2counter.gif',121,30,30,2,'{{PD}} I made this image, and placing it in the public domain. It is used just to explain location arithmetic.',105787,'Kbs','20041126233456','0','BITMAP','image','gif',0,'0dtglsg71k6q5hsfpudw8both32h4gc'),(2467,'Kit-body-sashonwhite.png','20041127194708!Kit_body_sashonwhite.png',1040,38,59,8,'soccer jersey with colored sash on white',75150,'Dryazan','20041030192956','0','BITMAP','image','png',0,'b41ajbs7dwjc5r38d7hyo1kpd58x2z2'),(2468,'Eicosanoid-synthesis.png','20041127223031!Eicosanoid_synthesis.png',6736,424,345,8,'[[Eicosanoid]] synthesis',46555,'Jfdwolff','20040502194527','0','BITMAP','image','png',0,'1mq3nhaenvwgks0b0l5b2rwit47oy2d'),(2469,'Haleakala-Maui-Hawaii-APR00-1.jpg','20041127234619!Haleakala_Maui_Hawaii_APR00_1.jpg',601178,872,589,8,'(Haleakala, Maui, Hawaii. Photo taken by Viriditas APR00 {{GFDL}})',101805,'Viriditas','20040911032854','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"150/1\";s:11:\"YResolution\";s:5:\"150/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:09:10 17:32:15\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'kwefo340kjvf3orem0g2cjcbj4q1gpa'),(2470,'Weaubleau-Structure-outline.png','20041128005635!Weaubleau_Structure_outline.png',15585,600,599,8,'This  is a diagram of the circular components of the [[Weaubleau Structure]]',88976,'Kbh3rd','20041127222122','0','BITMAP','image','png',0,'luiystyltevt5bkax952j11x43jdjep'),(2471,'Weaubleau-Structure-outline.png','20041128005848!Weaubleau_Structure_outline.png',13744,1158,1156,8,'Included 2nd internal circular feature',88976,'Kbh3rd','20041128005635','0','BITMAP','image','png',0,'dd64byog1aobow8gki024gh96dathhn'),(2472,'Skin-shade-map.png','20041128022040!Skin_shade_map.png',92531,502,325,8,'redo Skin_shade_map.gif',16559,'Patrick0Moran','20041123171038','0','BITMAP','image','png',0,'bgcptc0x1ev40iymr43z4yh1ipv96xv'),(2473,'Curiosa-(1).JPG','20041128071501!Curiosa_(1).JPG',40239,400,300,8,'Crowd at Curiosa in San Francisco, taken by Sarah Beebe',142604,'Lollipopsandscars','20041128071326','0','BITMAP','image','jpeg',0,'7gelsykswh9ycre51lfv4g18qqubgep'),(2474,'Kit1.jpg','20041128072915!Kit1.jpg',6638,250,252,8,'',8846,'Andrewa','20030911021801','0','BITMAP','image','jpeg',0,'mmaa6cisct2ixjs2oshgzlgwkr4x0rx'),(2475,'Eicosanoid-synthesis.png','20041128102154!Eicosanoid_synthesis.png',12826,424,371,8,'improved',46555,'Jfdwolff','20041127223031','0','BITMAP','image','png',0,'m1pgj4xepy55vk5s6caz1ar4u96tjcp'),(2476,'Hartnellwilliam.jpg','20041129042301!Hartnellwilliam.jpg',26026,150,191,8,'visually fixed apsect ratio',42385,'Lupin','20040417115316','0','BITMAP','image','jpeg',0,'l9xjb7rl8t5hf98efxf2x9acwgqqllb'),(2477,'DuranDuran-UK-PressKit-1981.jpg','20041129060022!DuranDuran_UK_PressKit_1981.jpg',42525,307,390,8,'Duran Duran 1981 Press Kit Photo (fair use)',8316,'CatherineMunro','20041129052105','0','BITMAP','image','jpeg',0,'razzdb6icbnnnf75bxo06x7u2co6x0b'),(2478,'DuranDuran-UK-PressKit-1986.jpg','20041129061617!DuranDuran_UK_PressKit_1986.jpg',32706,390,311,8,'Duran Duran 1986 Press Kit Photo (fair use)',8316,'CatherineMunro','20041129054224','0','BITMAP','image','jpeg',0,'naqzo4b34w419a625f9yem1u5g372bs'),(2479,'DuranDuran-UK-PressKit-1997.jpg','20041129061740!DuranDuran_UK_PressKit_1997.jpg',32908,390,312,8,'Duran Duran 1997 Press Kit Photo (fair use)',8316,'CatherineMunro','20041129053126','0','BITMAP','image','jpeg',0,'my3mke7fdo1ji1rrsnoavsorwgfktlb'),(2480,'DuranDuran-UK-PressKit-1997.jpg','20041129061833!DuranDuran_UK_PressKit_1997.jpg',29249,361,241,8,'Duran Duran 1997 Press Kit Photo (fair use)',8316,'CatherineMunro','20041129061740','0','BITMAP','image','jpeg',0,'3kryne6j02n5mdi59y98xxbxftq7e7w'),(2481,'Troupe-2.jpg','20041129065222!Troupe_2.jpg',72110,639,499,8,'Haverly\'s Ragged Tambo Men, a minstrel troupe from New Zealand {{PD}}',142992,'Scipiocoon','20041129064522','0','BITMAP','image','jpeg',0,'ex8na0pmh4wxnmx1h1g5pagdpn0pqb8'),(2482,'Rachelle-Waterman.jpg','20041129124530!Rachelle_Waterman.jpg',41509,160,176,8,'Photo for Rachelle Waterman article. Uploaded from U.S. federally-funded web site (http://www.ccsd.k12.ak.us/chs/pages/ACDC03/images/2004%20pics/rachellew.jpg), so copyright is waived. {{GFDL}}',95882,'David Vasquez','20041129043254','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"1970:01:14 14:22:01\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'jw6viu8s918w71nz2kehybqceli0fqb'),(2483,'Christina-Aguilera---Stripped.jpg','20041129205004!Christina_Aguilera_-_Stripped.jpg',7049,200,206,8,'[[Category:album covers]] Christina Aguilera - Stripped album cover',110766,'DCEdwards1966','20041005002949','0','BITMAP','image','jpeg',0,'o3pob1d133k9sbpxieqfhixcwx9weuv'),(2484,'Upper-canada-college.jpg','20041130022314!Upper_canada_college.jpg',32778,420,290,8,'{{GFDL}},  I got this picture off a page of Toronto landmarks, and I am currently at the school and thought I would add it to the school\'s webpage.',137983,'Travisritch','20041129175703','0','BITMAP','image','jpeg',0,'7efz7l8tqi5wcp1961qpxjhc4l20kgs'),(2485,'Homocyteinestucture.jpg','20041130041839!Homocyteinestucture.jpg',4679,283,92,8,'',143042,'Katfisch','20041130041406','0','BITMAP','image','jpeg',0,'7g6mgsm5lcb9fpz95omtamxxsififks'),(2486,'T-Square-fractal-(evolution).gif','20041130181455!T-Square_fractal_(evolution).gif',4554,768,128,2,'The evolution of the [[T-Square (fractal)|T-Square]] [[fractal]]. <hr><center>Image by [[User:Solkoll]]</center>{{PD}}',85498,'Solkoll','20041130153341','0','BITMAP','image','gif',0,'jh46w8p572g1qwkp0rj8y8cdq7rihq9'),(2487,'Mazowsze-Lipsko.png','20041130202519!Mazowsze_Lipsko.png',8622,349,393,8,'Masovian Voivodship, Lipsko County',32233,'Halibutt','20040519232424','0','BITMAP','image','png',0,'hg29qmek5vo9rnuu338r8hfhcf6jbj4'),(2488,'Mozilla-Firefox-1.0-front-page-screenshot.png','20041130225544!Mozilla_Firefox_1.0_front_page_screenshot.png',112692,978,687,8,'',110454,'Minghong','20041109161134','0','BITMAP','image','png',0,'oebdpo8mdlpkd9q7uhjt8sjd0msf388'),(2489,'Looking-at-Taliesin-from-Hill-Crown.jpg','20041130231935!Looking_at_Taliesin_from_Hill_Crown.jpg',38801,348,259,8,'This photograph was taken by myself. {{GFDL}}',144056,'Marykeiran','20041130231749','0','BITMAP','image','jpeg',0,'b7bjtpi9mdtuyn3ov3i8nw0owakdsw5'),(2490,'Mozilla-Firefox-1.0-front-page-screenshot.png','20041130232307!Mozilla_Firefox_1.0_front_page_screenshot.png',150757,800,574,8,'Changed to conform to [[Wikipedia:Software_screenshots|serving suggestion]] {{GFDL}}',27043,'Boffy b','20041130225544','0','BITMAP','image','png',0,'rgsdiylatzohk9ev3myszrdh25mxw62');
insert  into `oldimage`(`oi_id`,`oi_name`,`oi_archive_name`,`oi_size`,`oi_width`,`oi_height`,`oi_bits`,`oi_description`,`oi_user`,`oi_user_text`,`oi_timestamp`,`oi_metadata`,`oi_media_type`,`oi_major_mime`,`oi_minor_mime`,`oi_deleted`,`oi_sha1`) values (2491,'Tommytrojancovered.jpg','20041201050744!Tommytrojancovered.jpg',568970,906,936,8,'{{GFDL}} made by Cindy Danielson',120947,'Rawkergirl','20041201050557','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:11:30 20:57:28\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'t4221rsnf310sb0tqb98fy10sh3x8nv'),(2492,'Page-table-actions.png','20041201054208!Page_table_actions.png',5496,625,405,8,'Typical actions taken upon a virtual-physical address translation. Drawn by myself',14486,'Dysprosia','20041124053202','0','BITMAP','image','png',0,'s7godmse2g60pq0fu6a30by0kr8rtgv'),(2493,'Ketamine.png','20041201170338!Ketamine.png',3114,323,258,8,'Reverted to earlier revision',99313,'AlasVivas','20041127025732','0','BITMAP','image','png',0,'pegceo3l5hou9f3yvorrder8krbe8hk'),(2494,'Miniworldmap.jpg','20041201172112!Miniworldmap.jpg',1254,40,27,8,'{{PD-USGov}} Source: http://www.hhs.gov/ogha/images/map.jpg',12028,'Jengod','20041130214817','0','BITMAP','image','jpeg',0,'ghq32amhibaabqq8fjn0xnl1w0nihz1'),(2495,'Qur\'anic-initial-letters-en.PNG','20041201230942!Qur\'anic_initial_letters_en.PNG',35688,300,511,8,'Tree chart of the [[Qur\'anic initial letters]] (to be read right to left), made by me. {{GFDL}}',57891,'Mustafaa','20041201220825','0','BITMAP','image','png',0,'lexy0afpnxxu6ki8f4zcq7lopy649a8'),(2496,'Decaturville-Crater-shaded-relief-false-color.jpg','20041202010050!Decaturville_Crater_shaded-relief_false-color.jpg',34955,512,444,8,'This image shows the central portion of the [[Decaturville crater]] in false-clor shaded-relief format with exaggerated vertical relief.',88976,'Kbh3rd','20041128192303','0','BITMAP','image','jpeg',0,'qazn8nd5c5c4nnoexzdshtf27vkbdm7'),(2497,'Folinic-acid.png','20041202025123!Folinic_acid.png',3044,360,183,8,'molecular structure of folinic acid {{GFDL}}',38684,'Techelf','20040918133126','0','BITMAP','image','png',0,'is8l2hlz3zgm2qa6wzmocrdyozv26ft'),(2498,'Viking-Age.png','20041202094850!Viking_Age.png',132536,660,415,8,'{{GFDL}} based on http://home.online.no/~anlun/tipi/vrout.jpg',86857,'Dbachmann','20041201163410','0','BITMAP','image','png',0,'9o6v0gl4unhddu1j4krwiwoopkiuu5b'),(2499,'Viking-Age.png','20041202123832!Viking_Age.png',112343,697,438,8,'added dates',86857,'Dbachmann','20041202094850','0','BITMAP','image','png',0,'seualzx6jw14oasyvsc49fzad472rv7'),(2500,'Herb-Suprasl.gif','20041202153256!Herb_Suprasl.gif',4054,145,171,8,'{{pd}}',60647,'Emax','20041202121453','0','BITMAP','image','gif',0,'3zqno56j1ccx4ou5fg07nwublmisdu7'),(2501,'Dickinson-nd-dhs-1984.jpg','20041202154244!Dickinson-nd-dhs-1984.jpg',20861,577,261,8,'Dickinson High School. 1984',47531,'Hansjorn','20040716110021','0','BITMAP','image','jpeg',0,'s7wa30b8slu89w97ynvyyygc7sfo27g'),(2502,'Viva-La-Woman.jpg','20041202234553!Viva_La_Woman.jpg',32952,389,380,8,'Used under fair use',89571,'Fataltourist','20041202234417','0','BITMAP','image','jpeg',0,'ergni5kou8h90me4xa261kxjlu63r2e'),(2503,'38th-parallel-structures.png','20041203020731!38th_parallel_structures.png',13140,273,178,8,'This string of circular structures have been interpreted as a possible serial meteorite strike.',88976,'Kbh3rd','20041128171354','0','BITMAP','image','png',0,'2e0fvxz0ltdl18u8cafojtjsl9phrbz'),(2504,'Alexander-James-Begg.jpg','20041203134351!Alexander_James_Begg.jpg',61549,691,518,8,'fixed color and brightness',96850,'AlexTheMartian','20041124104104','0','BITMAP','image','jpeg',0,'5kbxnwu5gyio26uw3oo888qjdsdrobv'),(2505,'Ukraine-Elections2004-Voter-Turnout.png','20041203140438!Ukraine_Elections2004_Voter_Turnout.png',78914,1181,825,8,'{{GFDL}}',86399,'Berkut','20041203115636','0','BITMAP','image','png',0,'065lhu4vsjssydskf3kog9p80n27rdg'),(2506,'Whittier-Narrows-Plaque.JPG','20041203143506!Whittier_Narrows_Plaque.JPG',1435170,2272,1704,8,'{{PD}} I took this picture ',145653,'Lebite','20041203143210','a:32:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:20:\"Canon PowerShot S400\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:11:14 18:29:59\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:6:\"1/1600\";s:7:\"FNumber\";s:5:\"71/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:11:14 18:29:59\";s:17:\"DateTimeDigitized\";s:19:\"2004:11:14 18:29:59\";s:22:\"CompressedBitsPerPixel\";s:3:\"5/1\";s:17:\"ShutterSpeedValue\";s:6:\"341/32\";s:13:\"ApertureValue\";s:6:\"181/32\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:5:\"95/32\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:6:\"237/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"2272000/280\";s:21:\"FocalPlaneYResolution\";s:11:\"1704000/210\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:9:\"2272/2272\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'nttytaaxgomiao74c4ced981f3bi7q8'),(2507,'Pine-cones,-immature-female.jpg','20041203152842!Pine_cones,_immature_female.jpg',81484,316,424,8,'cam-corder\'ed myself {{msg:GFDL}}',6153,'Menchi','20040514091638','a:38:{s:4:\"Make\";s:9:\"Panasonic\";s:5:\"Model\";s:6:\"DMC-F1\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:7:\"Ver1.10\";s:8:\"DateTime\";s:19:\"2004:05:14 02:13:53\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/600\";s:7:\"FNumber\";s:5:\"28/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:05:14 02:08:08\";s:17:\"DateTimeDigitized\";s:19:\"2004:05:14 02:08:08\";s:22:\"CompressedBitsPerPixel\";s:5:\"35/10\";s:17:\"ShutterSpeedValue\";s:9:\"5907/1000\";s:13:\"ApertureValue\";s:5:\"30/10\";s:17:\"ExposureBiasValue\";s:5:\"0/100\";s:16:\"MaxApertureValue\";s:5:\"30/10\";s:12:\"MeteringMode\";i:3;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:25;s:11:\"FocalLength\";s:5:\"58/10\";s:10:\"ColorSpace\";i:1;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:1;s:16:\"DigitalZoomRatio\";s:4:\"0/10\";s:21:\"FocalLengthIn35mmFilm\";i:35;s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:2;s:10:\"Saturation\";i:2;s:9:\"Sharpness\";i:2;s:20:\"SubjectDistanceRange\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'0ulhyb9togn8yg0nycg4e6o248wiffy'),(2508,'Olin-Center-Sunset.JPG','20041203204559!Olin_Center_Sunset.JPG',1248823,2560,1920,8,'Sunset over the Olin Center at Olin College',104988,'L33tminion','20041203204345','a:24:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:9:\"CYBERSHOT\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2003:10:29 17:42:29\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/300\";s:7:\"FNumber\";s:5:\"20/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2003:10:29 17:42:29\";s:17:\"DateTimeDigitized\";s:19:\"2003:10:29 17:42:29\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"33/16\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"97/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'oef3w11mlas34c4vi2ocllh5n7irxef'),(2509,'Olin-Center-Sunset.JPG','20041203204945!Olin_Center_Sunset.JPG',431337,750,563,8,'',104988,'L33tminion','20041203204559','a:25:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:9:\"CYBERSHOT\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:8:\"DateTime\";s:19:\"2004:12:03 15:45:43\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/300\";s:7:\"FNumber\";s:5:\"20/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2003:10:29 17:42:29\";s:17:\"DateTimeDigitized\";s:19:\"2003:10:29 17:42:29\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"33/16\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"97/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'saa98gmeb93i7ijjva6m35348c6ll8a'),(2510,'Olin-College-Great-Lawn.jpg','20041203215120!Olin_College_Great_Lawn.jpg',794579,2100,1500,8,'A view of the great lawn at Olin College',104988,'L33tminion','20041203214933','a:24:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:12:\"Canon EOS-1D\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2002:10:21 10:04:08\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"1/1000\";s:7:\"FNumber\";s:3:\"8/1\";s:15:\"ExposureProgram\";i:1;s:15:\"ISOSpeedRatings\";i:200;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2002:10:20 14:04:41\";s:17:\"DateTimeDigitized\";s:19:\"2002:10:20 14:04:41\";s:17:\"ShutterSpeedValue\";s:12:\"655360/65536\";s:13:\"ApertureValue\";s:12:\"393216/65536\";s:17:\"ExposureBiasValue\";s:3:\"0/1\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:4:\"39/1\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'8wkeb9y37ipjr9leb6es255wzgfhkyh'),(2511,'Olin-College-Great-Lawn.jpg','20041203215243!Olin_College_Great_Lawn.jpg',794579,2100,1500,8,'A view of the great lawn at Olin College',104988,'L33tminion','20041203215121','a:24:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:12:\"Canon EOS-1D\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2002:10:21 10:04:08\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"1/1000\";s:7:\"FNumber\";s:3:\"8/1\";s:15:\"ExposureProgram\";i:1;s:15:\"ISOSpeedRatings\";i:200;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2002:10:20 14:04:41\";s:17:\"DateTimeDigitized\";s:19:\"2002:10:20 14:04:41\";s:17:\"ShutterSpeedValue\";s:12:\"655360/65536\";s:13:\"ApertureValue\";s:12:\"393216/65536\";s:17:\"ExposureBiasValue\";s:3:\"0/1\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:4:\"39/1\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'8wkeb9y37ipjr9leb6es255wzgfhkyh'),(2512,'Sonata.mid','20041203220539!Sonata.mid',39016,0,0,0,'I made it myself',69445,'Herschelkrustofsky','20040613121129','','AUDIO','audio','midi',0,'nipckuopzh3qo2smp4wdpn0y8yutsnb'),(2513,'2004-us-per-1000004.png','20041203222414!2004_us_per_1000004.png',66962,641,267,8,'2004 us election controversy intro image',9076,'Kevin Baas','20041203220802','0','BITMAP','image','png',0,'ic1mjz0e3z47mm1skpfo92fssur4qr1'),(2514,'Saint-Francis-of-assisi-in-his-tomb.jpg','20041203232231!Saint_Francis_of_assisi_in_his_tomb.jpg',42637,300,432,8,'\'\'St. Francis of Assisi in his tomb\'\', by [[Francisco de Zurbaran]]. {{PD-old}}',26071,'Adam Faanes','20041203232143','0','BITMAP','image','jpeg',0,'osoybe046aa1vbgs1fihfqrd664kmmr'),(2515,'Alexei-rykov.jpg','20041203233902!Alexei_rykov.jpg',20027,165,250,8,'Soviet politician Alexei Ivanovich Rykov',53702,'Aika','20041203144636','0','BITMAP','image','jpeg',0,'jjz8wrtf5ot7c86ftqed8jq3p6wf9pr'),(2516,'Boyes-civilian-clothes.jpg','20041204100004!Boyes_civilian_clothes.jpg',16727,360,240,8,'enlarged from http://195.234.240.231/shared/contentbinaries/publish/470726.jpg',135781,'Historian','20041120032443','0','BITMAP','image','jpeg',0,'ow6pnclnpgp0zfbe04nmidqw04yw06x'),(2517,'Cy-map.png','20041204185325!Cy-map.png',12341,629,319,4,'crop black border',17226,'Grendelkhan','20040525002344','0','BITMAP','image','png',0,'1yjhnctfbcf6ahh80xxi2t285d27hkg'),(2518,'Skyline-Pictures-012.jpg','20041204205240!Skyline_Pictures_012.jpg',87243,640,480,8,'XMOD',135926,'Jettaman','20041204034537','a:21:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:11:\"DCR-TRV340 \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:04:07 17:08:52\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:5:\"1/500\";s:7:\"FNumber\";s:7:\"680/100\";s:15:\"ExposureProgram\";i:2;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:04:07 17:08:52\";s:17:\"DateTimeDigitized\";s:19:\"2004:04:07 17:08:52\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:5:\"0/100\";s:16:\"MaxApertureValue\";s:7:\"140/100\";s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:6:\"139/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'75tiz0ibwg2i9kwjjlvxa7a77xijzpw'),(2519,'LewWallace.jpeg','20041205070109!LewWallace.jpeg',11809,216,249,8,'Lew Wallace (19th century photograph)',3628,'Hephaestos','20030911000216','0','BITMAP','image','jpeg',0,'op19k4eq9tv7v40rjcjf8tlgsixlvxx'),(2520,'P.t.barnum.jpg','20041205074726!P.t.barnum.jpg',19151,300,421,8,'P.T. Barnum, from http://lcweb.loc.gov/rr/print/235_pob.html#BarnumP',6280,'Dave Farquhar','20030407232900','0','BITMAP','image','jpeg',0,'ld4c8ucbgjpdmcaezrm5jd7qsiw3216'),(2521,'HMS-Amethyst-(U16).jpg','20041205135634!HMS_Amethyst_(U16).jpg',91513,1000,769,8,'[[HMS Amethyst (U16)]]{{Copyrighted-navyphotos}}Downloaded from [http://www.navyphotos.co.uk/ameth6b.jpg]',55814,'Gdr','20041205135308','0','BITMAP','image','jpeg',0,'oponwmc2jk6ba67s3uxezie47v9gfti'),(2522,'NSWhighways.png','20041205141336!NSWhighways.png',63696,1080,810,8,'{{GFDL}}',37448,'Fikri','20041201092546','0','BITMAP','image','png',0,'thmlngdb9vz1i7eep8kdukifa7vaol4'),(2523,'Villeneuve-Switzerland.jpg','20041205160132!Villeneuve_Switzerland.jpg',63665,366,495,8,'Image of a street  in  Villeneuve, (the one on the shores of lake geneva!)',69607,'Ojw','20041205154412','0','BITMAP','image','jpeg',0,'mzp1j6zcm2akz9jk2qfz9z8nf86n8xs'),(2524,'Jaguar-xj6-1995.jpg','20041205212953!Jaguar_xj6_1995.jpg',423248,2039,901,8,'Jaguar Xj6 (Sovereign) - 1995 model',135177,'Ross Burgess','20041205172918','0','BITMAP','image','jpeg',0,'fswb1oeg9rpatlf91eyzmt82cwqjbd4'),(2525,'Venlafaxine.png','20041206031011!Venlafaxine.png',1638,289,192,8,'Venlafaxine',51395,'Delta G','20040502021714','0','BITMAP','image','png',0,'ghvn42yllfm79dixxlsttso2vgwjaho'),(2526,'MontyPythonFoot.jpg','20041206052617!MontyPythonFoot.jpg',1079,35,35,8,'Detail from \"An Allegory of Lust\" by Bronzino - believed {{PD}}',7104,'Paul A','20041206044409','0','BITMAP','image','jpeg',0,'blexunpn169za3zmhebn7g0elz3o0n8'),(2527,'Manhattan-wiring.jpg','20041206053934!Manhattan_wiring.jpg',35757,803,842,8,'',21013,'Raul654','20041206053616','0','BITMAP','image','jpeg',0,'5lqs7nfmdoe4om9e28c5hlrl913ev2w'),(2528,'Ireland-road-lanes.png','20041206113302!Ireland_road_lanes.png',4031,118,268,8,'Diagram explaining road lanes, as in Britain and Ireland. Irish road markings. Diagram created by [[User:Zoney|Zoney]]. {{GFDL}}',49236,'Zoney','20041114223942','0','BITMAP','image','png',0,'ri23qrrbh189m3cwiakt6bkf3f9x418'),(2529,'Liealgebra.png','20041206173715!Liealgebra.png',6780,150,190,8,'{{PD-self}} latex compiled',18901,'Phys','20041206172217','0','BITMAP','image','png',0,'e7i7vk2mwe8gpweiamvkphe8aq8quxx'),(2530,'Pulsefrequency.png','20041206230000!Pulsefrequency.png',1111,321,82,8,'COSY NMR pulse diagram',141160,'Nonoelmo','20041206224412','0','BITMAP','image','png',0,'jv98lztm1v9ujbahfe73satbabr031l'),(2531,'National-atlas-georgia.PNG','20041207022251!National-atlas-georgia.PNG',122981,820,663,8,'National Atlas map of Georgia {{PD-USGov}}',124717,'Queson','20041105013921','0','BITMAP','image','png',0,'iariw4vh3pvufz7ldjjmt68drtktq4y'),(2532,'Alexa-reach-measurement-for-wikipedia-logscale.png','20041207030059!Alexa_reach_measurement_for_wikipedia-logscale.png',3006,480,328,8,'Alexa reach measurement for wikipedia.org',88976,'Kbh3rd','20041021173143','0','BITMAP','image','png',0,'n6afnhd6fuh6waee4hubfxce2y0omf1'),(2533,'Alexa-reach-measurement-for-wikipedia.png','20041207030121!Alexa_reach_measurement_for_wikipedia.png',3183,480,328,8,'thru oct 2004',88976,'Kbh3rd','20041109195148','0','BITMAP','image','png',0,'el7rc9iqg4lgpd41jq29zoil46ijba6'),(2534,'Alexa-traffic-ranking-for-wikipedia.png','20041207030141!Alexa_traffic_ranking_for_wikipedia.png',2450,432,240,8,'thru oct 2004',88976,'Kbh3rd','20041109195301','0','BITMAP','image','png',0,'pjrym4xusyfdcnl143vj62xpouk39hu'),(2535,'Google-Answers-using-Wikipedia.png','20041207030201!Google_Answers_using_Wikipedia.png',2858,432,240,8,'thru oct 2004',88976,'Kbh3rd','20041109203542','0','BITMAP','image','png',0,'bllncuiywdfxxplh4bzdsxk6wpopm84'),(2536,'Google-News-stories-mentioning-Wikipedia.png','20041207030236!Google_News_stories_mentioning_Wikipedia.png',2409,432,240,8,'thru oct 2004',88976,'Kbh3rd','20041109203629','0','BITMAP','image','png',0,'p0wkrtyv5gz1t7fr0ylmj752odtwjds'),(2537,'More-specific-Usenet-posts-containing-the-word-Wikipedia.png','20041207030311!More_specific_Usenet_posts_containing_the_word_Wikipedia.png',4278,480,328,8,'thru oct 2004',88976,'Kbh3rd','20041109203958','0','BITMAP','image','png',0,'cbjboxmsrh11n31ey84asjghocjizei'),(2538,'Usenet-posts-containing-the-word-Wikipedia.png','20041207030330!Usenet_posts_containing_the_word_Wikipedia.png',3113,480,328,8,'thru oct 2004',88976,'Kbh3rd','20041109204410','0','BITMAP','image','png',0,'8v2asni54dt1y9ip1un3x0q66b6uylv'),(2539,'Color-temp.gif','20041207114648!Color_temp.gif',12505,598,108,8,'Color Temputure of Light -- Graphic. Created by Daniel Murphy {{GFDL}}',106026,'Dmurphy','20040916201534','0','BITMAP','image','gif',0,'fz0d565bkzhoflhq249z333pse58ao7'),(2540,'Color-temp.gif','20041207114831!Color_temp.gif',10553,578,97,7,'',91342,'Dkroll2','20041207114649','0','BITMAP','image','gif',0,'aqjdb6ceeulqzcbfw5t19hlxcttloc4'),(2541,'Color-temp.gif','20041207120254!Color_temp.gif',10553,578,97,7,'',91342,'Dkroll2','20041207114831','0','BITMAP','image','gif',0,'aqjdb6ceeulqzcbfw5t19hlxcttloc4'),(2542,'Color-temp.gif','20041207120447!Color_temp.gif',10545,578,97,7,'Basic Correlated Color Temp Scale',91342,'Dkroll2','20041207120254','0','BITMAP','image','gif',0,'3lwrvdnxh7g0j7mprkfn92bxu57rvu9'),(2543,'Huff-Daland-XB-1-Silhouette.gif','20041207135536!Huff-Daland_XB-1_Silhouette.gif',1141,40,36,8,'{{GFDL}} ',84713,'MaxMad','20041207134850','0','BITMAP','image','gif',0,'4vdn4ipi9ul58bkhkdf1ofzgpvoz1rf'),(2544,'Huff-Daland-XB-1-Silhouette.gif','20041207140037!Huff-Daland_XB-1_Silhouette.gif',1851,118,107,8,'{{GFDL}} Larger version of earlier image',84713,'MaxMad','20041207135536','0','BITMAP','image','gif',0,'fa4o57qex0pkz6ws0wqkdjrbrc1plmu'),(2545,'America\'s-Army1.jpg','20041207162731!America\'s_Army1.jpg',26760,443,334,8,'',86580,'Zh','20041016210449','0','BITMAP','image','jpeg',0,'iahj24z15do889acjns0dlwr3j797z2'),(2546,'Troutslayerwoodthing.gif','20041207204523!Troutslayerwoodthing.gif',20735,175,219,8,'Picture of outside of the trout slayer wood thing {{pd}}',148171,'Drydenmaker','20041207203828','0','BITMAP','image','gif',0,'okp9ez58ptkdqzs3i9k7joguth8oypq'),(2547,'Larchmont-ny-emblem.jpg','20041208033733!Larchmont_ny_emblem.jpg',70066,400,331,8,'{{PD}} Emblem of the Village of Larchmont, New York.  Drawing by J. Stander, released to public domain.',135835,'Gsd97jks','20041208033012','0','BITMAP','image','jpeg',0,'74v58wgc4hs0l749oo2b1pga5dnfj7z'),(2548,'Curtiss-AT-9-Jeep.jpg','20041208053357!Curtiss_AT-9_Jeep.jpg',27776,465,251,8,'Photo of a Curtiss AT-9, Public Domain Image from wpafb.af.mi',147345,'Mikeb4789','20041208021623','0','BITMAP','image','jpeg',0,'nzqcjnk7vs38p5zsxoyo92rdbkc9cw9'),(2549,'Curtiss-AT-9-Jeep.jpg','20041208053556!Curtiss_AT-9_Jeep.jpg',12955,561,260,8,'Photo of a Curtiss AT-9, Public Domain Image from www.aetc.randolph.af.mil',147345,'Mikeb4789','20041208053357','0','BITMAP','image','jpeg',0,'9x63io879csdvc9bmey8zk1txapoto2'),(2550,'Cradle-of-Humanity-States.png','20041208064543!Cradle_of_Humanity_States.png',58694,782,532,8,'removed text from picture so it can be NPOVed',52,'Eloquence','20040201212753','0','BITMAP','image','png',0,'1djlbn2jicsu4vnt9k8jnd6anlxf9gm'),(2551,'Cradle-of-Humanity-States.png','20041208064610!Cradle_of_Humanity_States.png',307806,2607,1903,8,'Reverted to earlier revision',89416,'Kelvinc','20041208064545','0','BITMAP','image','png',0,'0yln0168cvfdkg7hgdg9kg00tp7wym3'),(2552,'Ontbrt.PNG','20041208064712!Ontbrt.PNG',9656,378,379,8,'Brant County, Ontario',26201,'Earl Andrew','20031209041250','0','BITMAP','image','png',0,'4gdp0smhtka00dcax269e1p0cp7unu4'),(2553,'Ontbtd.PNG','20041208064904!Ontbtd.PNG',9660,378,379,8,'Brantford, Ontario',26201,'Earl Andrew','20040618080633','0','BITMAP','image','png',0,'47vtbiai00er3zxeks69pdisqw86mz0'),(2554,'County-tier-ontario.PNG','20041208073038!County-tier-ontario.PNG',9813,378,379,8,'Counties of Ontario',15348,'Snickerdo','20041208072307','0','BITMAP','image','png',0,'7nsmqxfixg0cwevm0k1rs6w2mttrpv5'),(2555,'County-tier-ontario.PNG','20041208084007!County-tier-ontario.PNG',9812,378,379,8,'The Counties of Ontario',15348,'Snickerdo','20041208073038','0','BITMAP','image','png',0,'7m2ngui4pu5ht0my4ev4viwa8qwqvee'),(2556,'Ontbtd.PNG','20041208085313!Ontbtd.PNG',9548,378,379,8,'Brantford, Ontario',15348,'Snickerdo','20041208064904','0','BITMAP','image','png',0,'asdjaiy2inpiupxbwgq80tthajmecqk'),(2557,'Vf32swordsmen.jpg','20041208230212!Vf32swordsmen.jpg',15839,234,256,8,'{{PD}} US NAVY',133968,'Katefan0','20041208230101','0','BITMAP','image','jpeg',0,'nyare6p1mo2c14dne1swsl2l9gq7irw'),(2558,'Voll-Honig.JPG','20041209040458!Voll_Honig.JPG',137076,800,600,8,'Honey in capped cells on frame',142549,'Shoefly','20041209035804','a:18:{s:4:\"Make\";s:7:\"TOSHIBA\";s:5:\"Model\";s:7:\"PDR2300\";s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:4:\"1.00\";s:8:\"DateTime\";s:19:\"2004:07:30 09:59:34\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:4:\"1/30\";s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:07:30 09:59:34\";s:17:\"DateTimeDigitized\";s:19:\"2004:07:30 09:59:34\";s:17:\"ShutterSpeedValue\";s:7:\"493/100\";s:13:\"ApertureValue\";s:4:\"0/10\";s:5:\"Flash\";i:1;s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'dl3gnmsjgludd5w3iolf4e4z4qgxv7p'),(2559,'Inca-map-small.png','20041209192635!Inca-map-small.png',91713,400,740,8,'{PD} Map showing the expansion of Tahuantinsuyu 1438 CE - 1525 CE',138752,'Zenyu','20041206235318','0','BITMAP','image','png',0,'0drff9hv73hk1k7gxedhbt27tq7t7kh'),(2560,'BANDERA-MW-small.png','20041209214307!BANDERA_MW_small.png',11673,452,214,8,'War Banner of the [[Polish Navy]], for use in the [[Template:Infobox Polish Navy]] (note that the navy blue triangle is not part of the banner itself but of the infobox background) <br>{{User:Halibutt/GFDL}}',32233,'Halibutt','20041018074855','0','BITMAP','image','png',0,'cwtt8vi705reqwbi6loc0eqv7or77xc'),(2561,'BANDERA-MW-small.png','20041209215555!BANDERA_MW_small.png',8455,452,214,8,'use transparency, index colour',9855,'Tkinias','20041209214309','0','BITMAP','image','png',0,'7nc71rdyiabt3j2s3o0k9rz53tvfxj2'),(2562,'Poland-ensign.png','20041209224011!Poland_ensign.png',714,63,30,8,'[[Polish Navy]] ensign',9855,'Tkinias','20041209220817','0','BITMAP','image','png',0,'7g5xr0219bwnc6kv43l5nadg35p3d22'),(2563,'BANDERA-MW-small.png','20041209224121!BANDERA_MW_small.png',5341,452,214,8,'cleaned up',9855,'Tkinias','20041209215555','0','BITMAP','image','png',0,'19dehelja88w1inlyfm40yf4dswk8dg'),(2564,'BANDERA-MW-small.png','20041209224900!BANDERA_MW_small.png',5241,452,214,8,'colour corrected',9855,'Tkinias','20041209224121','0','BITMAP','image','png',0,'5lw7bzgy77f6sa56jkz5gmj6r99eriq'),(2565,'Halifax-county.JPG','20041209232703!Halifax_county.JPG',19621,455,341,8,'halifax county map',136489,'Alexk001','20041209232310','0','BITMAP','image','jpeg',0,'eaz3ktp963xlfblida30fhkgzqmz9sc'),(2566,'Modern-school-magazine.jpg','20041210010402!Modern_school_magazine.jpg',51315,223,300,8,'Cover of the Spring, 1920 [[Modern School]] magazine',29695,'Postdlf','20040822065519','0','BITMAP','image','jpeg',0,'0bxnsancn4yik8wrshwm4zeriaubfze'),(2567,'Gcrook.jpg','20041210043712!Gcrook.jpg',12859,177,236,8,'',25253,'AlexPlank','20031122033120','0','BITMAP','image','jpeg',0,'olsljxytdyhfzx2wubm9u5z2c52wrla'),(2568,'MontyPythonFoot.jpg','20041210065230!MontyPythonFoot.jpg',1381,35,35,8,'',7104,'Paul A','20041206052617','0','BITMAP','image','jpeg',0,'oylylr5us969kh17id93c72zcldfir7'),(2569,'OkanaganBC2.PNG','20041210082958!OkanaganBC2.PNG',86847,498,498,8,'Public domain map of British Columbia created by [[User:Roleypolinde]] with data courtesy of [http://geogratis.cgdi.gc.ca Geogratis], modified to show regional districts. Released under GFDL.{{GFDL}}',149070,'Roleypolinde','20041210074022','0','BITMAP','image','png',0,'gjr1k1j4zot9wtb902vj7b9vlef76uo'),(2570,'WestVictoriaHwy.png','20041210102215!WestVictoriaHwy.png',90430,1080,1440,8,'{{pd}}',37448,'Fikri','20041124084630','0','BITMAP','image','png',0,'99iqvtwp1lm19a65lpko8h3b1wesau9'),(2571,'EastVictoriaHwy.png','20041210102357!EastVictoriaHwy.png',132614,1051,970,8,'{{pd}}',37448,'Fikri','20041125061219','0','BITMAP','image','png',0,'rvxxswfke8p224qi2dpbzk0fmwyvo1a'),(2572,'Murrayriver.gif','20041210131057!Murrayriver.gif',11176,583,454,8,'Map by [[User:Adam Carr|Adam Carr]] {{PD}}',22444,'Adam Carr','20041210071335','0','BITMAP','image','gif',0,'s0ycdna850vsqwunpbuoa9u8fvd238w'),(2573,'NewZealandElectorates1984-Labeled.png','20041210134629!NewZealandElectorates1984-Labeled.png',37226,678,604,8,'map of the 1984 New Zealand elections',25556,'Vardion','20041210083853','0','BITMAP','image','png',0,'2p82vlr526f0zpp70h9739n4urbuuxt'),(2574,'VCRobertMcBeathGrave.jpg','20041210211837!VCRobertMcBeathGrave.jpg',34505,400,364,8,'Grave photo of Victoria Cross recipient Robert McBeath, migrated from the Victoria Cross Reference site with permission. Photo by Terry Macdonald.',142018,'J.N. Houterman','20041129215304','0','BITMAP','image','jpeg',0,'srovedkm2a479q06voj4j118y2mr5db'),(2575,'VCRobertMcBeathGrave.jpg','20041210212402!VCRobertMcBeathGrave.jpg',186410,670,919,8,'Updated Photograph',116139,'Kcic','20041210211837','0','BITMAP','image','jpeg',0,'rjarrudhqbaaduzsbvdqew35ltk5fo0'),(2576,'OkanaganBCRegions2.png','20041210215953!OkanaganBCRegions2.png',10955,388,634,8,'{{GFDL}}',149070,'Roleypolinde','20041210214551','0','BITMAP','image','png',0,'2e7bdnhqzrbt38jr9b47f38ypz50zwi'),(2577,'Map-of-New-York-highlighting-Upstate.png','20041210225809!Map_of_New_York_highlighting_Upstate.png',13987,300,232,8,'Upstate New York',37527,'Decumanus','20040130172258','0','BITMAP','image','png',0,'2mhrkid6ua4lpdzkj0lpq0hyg3z61aq'),(2578,'NewZealandElectorates1984-Labeled.png','20041211005050!NewZealandElectorates1984-Labeled.png',37941,678,604,8,'forgot to label Maori seats',25556,'Vardion','20041210134630','0','BITMAP','image','png',0,'9mqg58lvupgy9idp7cuwpqn5lc9vu54'),(2579,'Hydnjo.JPG','20041211012627!Hydnjo.JPG',319810,958,808,8,'Hydnjo = Heidi & Joe',14741,'Hydnjo','20041211011141','a:35:{s:4:\"Make\";s:5:\"NIKON\";s:5:\"Model\";s:5:\"E3100\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:13:\"4718592/65536\";s:11:\"YResolution\";s:13:\"4718592/65536\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"QuickTime 6.5.1\";s:8:\"DateTime\";s:19:\"2004:08:02 18:50:00\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/601\";s:7:\"FNumber\";s:5:\"28/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:08:01 11:09:43\";s:17:\"DateTimeDigitized\";s:19:\"2004:08:01 11:09:43\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"30/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:25;s:11:\"FocalLength\";s:5:\"58/10\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:5:\"0/100\";s:21:\"FocalLengthIn35mmFilm\";i:38;s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:20:\"SubjectDistanceRange\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'6lepjhzxx9oxwhejurd54ksoabsf8y5'),(2580,'Hydnjo.JPG','20041211013451!Hydnjo.JPG',2030,96,81,8,'Hydnjo = Heidi & Joe',14741,'Hydnjo','20041211012627','a:7:{s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'imteo5hq8meptkg5lduur5f715zh0sm'),(2581,'Hydnjo.JPG','20041211013547!Hydnjo.JPG',2030,96,81,8,'Hydnjo = Heidi & Joe',14741,'Hydnjo','20041211013451','a:7:{s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'imteo5hq8meptkg5lduur5f715zh0sm'),(2582,'Hydnjo.JPG','20041211013640!Hydnjo.JPG',2030,96,81,8,'Reverted to earlier revision',14741,'Hydnjo','20041211013549','a:7:{s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'imteo5hq8meptkg5lduur5f715zh0sm'),(2583,'Hydnjo.JPG','20041211013643!Hydnjo.JPG',2030,96,81,8,'Reverted to earlier revision',14741,'Hydnjo','20041211013640','a:7:{s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'imteo5hq8meptkg5lduur5f715zh0sm'),(2584,'Flaga-Lwow.jpg','20041211024048!Flaga_Lwow.jpg',74461,310,322,8,'{{pd}}',60647,'Emax','20041211023615','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"96/1\";s:11:\"YResolution\";s:4:\"96/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:8:\"DateTime\";s:19:\"2004:12:11 03:32:34\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'dj8urab6e97v0873zomf97sv4zrv17j'),(2585,'Hydnjo.JPG','20041211024333!Hydnjo.JPG',2030,96,81,8,'Reverted to earlier revision',14741,'Hydnjo','20041211013643','a:7:{s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'imteo5hq8meptkg5lduur5f715zh0sm'),(2586,'Hydnjo.JPG','20041211024622!Hydnjo.JPG',2030,96,81,8,'Reverted to earlier revision',14741,'Hydnjo','20041211024333','a:7:{s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'imteo5hq8meptkg5lduur5f715zh0sm'),(2587,'Flaga-Kujawy.jpg','20041211041126!Flaga_Kujawy.jpg',69674,314,326,8,'{{pd}}',60647,'Emax','20041211040319','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"96/1\";s:11:\"YResolution\";s:4:\"96/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:8:\"DateTime\";s:19:\"2004:12:11 05:01:14\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'lw5oodyy5k14cezvktx9fh6ygwxnlcc'),(2588,'Flaga-Kujawy.jpg','20041211053805!Flaga_Kujawy.jpg',68914,314,326,8,'{{pd}}',60647,'Emax','20041211041127','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"96/1\";s:11:\"YResolution\";s:4:\"96/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:8:\"DateTime\";s:19:\"2004:12:11 05:10:51\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'e9zqruexxx3t3l027bsmvty7jxr7gzz'),(2589,'Arctic-grayling.jpg','20041211191354!Arctic_grayling.jpg',46225,700,385,8,'touched up from NOAA',33103,'Hadal','20040726191129','0','BITMAP','image','jpeg',0,'kee9fl61x9mtm1bvhc959ph7mql0240'),(2590,'Hydnjo.JPG','20041211192705!Hydnjo.JPG',2030,96,81,8,'Reverted to earlier revision',14741,'Hydnjo','20041211024622','a:7:{s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'imteo5hq8meptkg5lduur5f715zh0sm'),(2591,'Hydnjo.JPG','20041211194658!Hydnjo.JPG',5534,96,81,8,'Heidi & Joe reversed',14741,'Hydnjo','20041211192706','a:10:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:13:\"4718592/65536\";s:11:\"YResolution\";s:13:\"4718592/65536\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"QuickTime 6.5.1\";s:8:\"DateTime\";s:19:\"2004:12:11 11:26:40\";s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'46zlxvhe5h40pcg9k4aa5tdu5l0tu5d'),(2592,'OkanaganBCRegions2.png','20041211200753!OkanaganBCRegions2.png',12981,388,634,8,'{{GFDL}}',149070,'Roleypolinde','20041210215953','0','BITMAP','image','png',0,'in26c336b7p527zljstl5ks647abw72'),(2593,'French-monarchsBourbon.png','20041211225405!French-monarchsBourbon.png',73401,741,1549,8,'Family tree of the 4th dynasty of the kings of France - Bourbon',8201,'Muriel Gottrop','20040304181743','0','BITMAP','image','png',0,'6xy10z64hdq23ayns9xbe4gsvvq9nyy'),(2594,'French-monarchsBourbon.png','20041211225603!French-monarchsBourbon.png',61558,741,1549,8,'Kings of France Fourth Dynasty - House of Bourbon',138950,'ElJayDee','20041211225405','0','BITMAP','image','png',0,'0xge6srkr4y1o61kwg76xfuhq397il0'),(2595,'French-monarchsBourbon.png','20041211230021!French-monarchsBourbon.png',73401,741,1549,8,'Reverted to earlier revision',138950,'ElJayDee','20041211225603','0','BITMAP','image','png',0,'6xy10z64hdq23ayns9xbe4gsvvq9nyy'),(2596,'Hydnjo.JPG','20041212021048!Hydnjo.JPG',5546,96,81,8,'Try reversed again',14741,'Hydnjo','20041211194659','a:10:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:13:\"4718592/65536\";s:11:\"YResolution\";s:13:\"4718592/65536\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"QuickTime 6.5.1\";s:8:\"DateTime\";s:19:\"2004:12:11 14:37:16\";s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'2yk3kqn6qny1gyq6q77246a3h6rlqmy'),(2597,'Hydnjo.JPG','20041212033339!Hydnjo.JPG',5552,96,81,8,'Heidi & Joe reversed',14741,'Hydnjo','20041212021048','a:10:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:13:\"4718592/65536\";s:11:\"YResolution\";s:13:\"4718592/65536\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"QuickTime 6.5.1\";s:8:\"DateTime\";s:19:\"2004:12:11 14:49:56\";s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'ev3em16m012cyzoqqf1zc4xpcntdck6'),(2598,'Hydnjo.JPG','20041212033440!Hydnjo.JPG',2030,96,81,8,'Reverted to earlier revision',95882,'David Vasquez','20041212033340','a:7:{s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'imteo5hq8meptkg5lduur5f715zh0sm'),(2599,'Hydnjo.JPG','20041212052214!Hydnjo.JPG',5552,96,81,8,'Reverted to earlier revision',95882,'David Vasquez','20041212033440','a:10:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:13:\"4718592/65536\";s:11:\"YResolution\";s:13:\"4718592/65536\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"QuickTime 6.5.1\";s:8:\"DateTime\";s:19:\"2004:12:11 14:49:56\";s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'ev3em16m012cyzoqqf1zc4xpcntdck6'),(2600,'Hydnjo.JPG','20041212055411!Hydnjo.JPG',5588,96,81,8,'Upsidedown',14741,'Hydnjo','20041212052214','a:10:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:13:\"4718592/65536\";s:11:\"YResolution\";s:13:\"4718592/65536\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"QuickTime 6.5.1\";s:8:\"DateTime\";s:19:\"2004:12:12 00:20:35\";s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'925f8ds5cuh1jypj71c0otzow6k6db1'),(2601,'Ukraine-Elections2004-Turnout-Diff.png','20041212113439!Ukraine_Elections2004_Turnout_Diff.png',59416,1181,825,8,'Ukrainian Presedential Elections of 2004, showing voter turnout increase between 1st and run-off rounds {{gfdl}}',86399,'Berkut','20041204012554','0','BITMAP','image','png',0,'gcvy6ycdvbh1evon8zmn1zr62an6mc6'),(2602,'Links-mandrake-linux-9.2-paddu.png','20041212161902!Links-mandrake-linux-9.2-paddu.png',111586,644,884,8,'Screenshot of the main page in links on linux with color taken by me',6949,'Paddu','20040224123737','0','BITMAP','image','png',0,'hqq6b5x1vgsrh87ly89239f0v3gpb5g'),(2603,'Ilyanepbyhour.png','20041213010202!Ilyanepbyhour.png',2662,442,320,2,'update',18610,'VeryVerily','20040905053458','0','BITMAP','image','png',0,'2b7en1m5z4pepz8e073e1sdzvhiphyk'),(2604,'Deflection.png','20041213073908!Deflection.png',10815,676,344,8,'deflection diagram {{GFDL}}',56905,'Kieff','20041213072640','0','BITMAP','image','png',0,'7gjgliul0euydtzpozq42mhnj78umtk'),(2605,'Tunny-wheels.jpg','20041213094029!Tunny-wheels.jpg',37988,467,251,8,'Image of [[Lorenz SZ 40/42]] by Greg Goebel. From [http://www.vectorsite.net/ttcode9.html#m2]. {{PD}}',50457,'Matt Crypto','20041208153657','0','BITMAP','image','jpeg',0,'6mebv04exjgnfwwyhg8g6ek6dhey40q'),(2606,'National-atlas-georgia.PNG','20041213094729!National-atlas-georgia.PNG',103000,737,498,8,'crop',19009,'Ed g2s','20041207022251','0','BITMAP','image','png',0,'pnw15hyj0p4gi4yjb87vrnm9gvizhvo'),(2607,'National-atlas-georgia.PNG','20041213101330!National-atlas-georgia.PNG',107770,820,663,8,'reduced file size',86399,'Berkut','20041213094729','0','BITMAP','image','png',0,'duwfbqlkfytwzqs17l9ju9fv6yfkr8l'),(2608,'Ramoncrater4.jpg','20041213104052!Ramoncrater4.jpg',152804,640,300,8,'',144020,'Carbonbase','20041213103903','a:28:{s:4:\"Make\";s:21:\"EASTMAN KODAK COMPANY\";s:5:\"Model\";s:27:\"KODAK DX3600 DIGITAL CAMERA\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:8:\"DateTime\";s:19:\"2004:12:13 04:51:34\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:18:\"1533917/1073741824\";s:7:\"FNumber\";s:19:\"751619264/134217728\";s:15:\"ExposureProgram\";i:2;s:11:\"ExifVersion\";s:4:\"0200\";s:16:\"DateTimeOriginal\";s:19:\"2002:04:13 09:21:44\";s:17:\"DateTimeDigitized\";s:19:\"2002:04:13 09:21:44\";s:17:\"ShutterSpeedValue\";s:20:\"1275068416/134217728\";s:13:\"ApertureValue\";s:19:\"671088640/134217728\";s:17:\"ExposureBiasValue\";s:3:\"0/1\";s:16:\"MaxApertureValue\";s:19:\"456340288/134217728\";s:15:\"SubjectDistance\";s:19:\"578478400/134217728\";s:12:\"MeteringMode\";i:1;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:19:\"751619264/134217728\";s:10:\"ColorSpace\";i:1;s:13:\"ExposureIndex\";s:19:\"1677721600/16777216\";s:13:\"SensingMethod\";i:2;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'lcsazv5sly8l54mlnvw1hdb6itw3ybm'),(2609,'Ramoncrater4.jpg','20041213104127!Ramoncrater4.jpg',152804,640,300,8,'',144020,'Carbonbase','20041213104053','a:28:{s:4:\"Make\";s:21:\"EASTMAN KODAK COMPANY\";s:5:\"Model\";s:27:\"KODAK DX3600 DIGITAL CAMERA\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:8:\"DateTime\";s:19:\"2004:12:13 04:51:34\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:18:\"1533917/1073741824\";s:7:\"FNumber\";s:19:\"751619264/134217728\";s:15:\"ExposureProgram\";i:2;s:11:\"ExifVersion\";s:4:\"0200\";s:16:\"DateTimeOriginal\";s:19:\"2002:04:13 09:21:44\";s:17:\"DateTimeDigitized\";s:19:\"2002:04:13 09:21:44\";s:17:\"ShutterSpeedValue\";s:20:\"1275068416/134217728\";s:13:\"ApertureValue\";s:19:\"671088640/134217728\";s:17:\"ExposureBiasValue\";s:3:\"0/1\";s:16:\"MaxApertureValue\";s:19:\"456340288/134217728\";s:15:\"SubjectDistance\";s:19:\"578478400/134217728\";s:12:\"MeteringMode\";i:1;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:19:\"751619264/134217728\";s:10:\"ColorSpace\";i:1;s:13:\"ExposureIndex\";s:19:\"1677721600/16777216\";s:13:\"SensingMethod\";i:2;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'lcsazv5sly8l54mlnvw1hdb6itw3ybm'),(2610,'OChem-Reaction-SulfonationBenzene.png','20041213135157!OChem-Reaction-SulfonationBenzene.png',1557,530,105,8,'{{PD-self}}',104525,'Jag123','20041213133457','0','BITMAP','image','png',0,'krr2umf9pwbabnud6j1on6m0ijm6lf4'),(2611,'Ilyanep-contribution-graph.png','20041213182949!Ilyanep_contribution_graph.png',6612,521,179,8,'',26675,'Fredrik','20040802173751','0','BITMAP','image','png',0,'6g8ogsptq4ma0k76l301ueglhrjmyex'),(2612,'Castrovalva.jpg','20041213202849!Castrovalva.jpg',54966,656,846,8,'\'\'[[Castrovalva (M. C. Escher)|Castrovalva]]\'\', by [[M. C. Escher]]. [[Lithograph]], [[1930]].{{permission}}',80654,'Justin Foote','20041128012832','0','BITMAP','image','jpeg',0,'cb1mzg2em6hswp9zgoucpff88wcgg4i'),(2613,'Magic-Mirror.jpg','20041213203327!Magic_Mirror.jpg',48964,996,614,8,'\'\'[[Magic Mirror]]\'\', by [[M. C. Escher]]. [[Lithograph]], [[1943]].',80654,'Justin Foote','20041128014439','0','BITMAP','image','jpeg',0,'0xcgor7d0l1k7l5e9i0xk94bso40m22'),(2614,'Escher\'s-Relativity.jpg','20041213203548!Escher\'s_Relativity.jpg',71574,883,850,8,'\'\'[[Relativity (M. C. Escher)|Relativity]]\'\', by [[M. C. Escher]]. [[Lithograph]], [[1953]].{{permission}}',80654,'Justin Foote','20041128015246','0','BITMAP','image','jpeg',0,'91220gdiaf0ajsmzrkw9vevtguwi51b'),(2615,'Escher\'s-Reptiles.jpg','20041213211254!Escher\'s_Reptiles.jpg',54827,980,850,8,'\'\'[[Reptiles (M. C. Escher)|Reptiles]]\'\', by [[M. C. Escher]]. [[Lithograph]], [[1943]].{{permission}}',80654,'Justin Foote','20041128015924','0','BITMAP','image','jpeg',0,'2fvh2qvh3b1weljbkvcbfk70pv4e5nv'),(2616,'De-Chirico\'s-Love-Song.jpg','20041213212639!De_Chirico\'s_Love_Song.jpg',56677,831,1030,8,'\"Love Song\" by [[Giorgio de Chirico]]. Oil on  canvas, [[1914]].{{PD}}',80654,'Justin Foote','20041003010807','0','BITMAP','image','jpeg',0,'4i9d9vb0fjqoyl8g57u4v2uqlqfmo60'),(2617,'Gare-Montparnasse.jpg','20041213212903!Gare_Montparnasse.jpg',28164,720,536,8,'\"Gare Montparnasse (The Melancholy of Departure) by [[Giorgio de Chirico]]. Oil on canvas, 1914.{{PD}}',80654,'Justin Foote','20041003234802','0','BITMAP','image','jpeg',0,'d2d5l8k12nfa0h2upi9rdk3aisy4y3f'),(2618,'Metaphysical-with-Biscuits.jpg','20041213213050!Metaphysical_with_Biscuits.jpg',30713,424,540,8,'\'\'Metaphysical Interior with Biscuits\'\' by [[Giorgio de Chirico]]. Oil on canvas, 1916.{{PD}}',80654,'Justin Foote','20041004001242','0','BITMAP','image','jpeg',0,'hfsslf3rybt1xy407spcq80re5ffbqu'),(2619,'StillLifewSphericalMirror.jpg','20041213213305!StillLifewSphericalMirror.jpg',40619,995,868,8,'\'\'[[Still Life with Spherical Mirror]]\'\', by [[M. C. Escher]]. [[Lithograph]], [[1934]].{{permission}}',80654,'Justin Foote','20041128020523','0','BITMAP','image','jpeg',0,'qltsw8unb4s7gffsipe0u303bvlj0ey'),(2620,'Southpark-ep105-2.jpg','20041214014649!Southpark_ep105_2.jpg',18638,464,352,8,'[[South Park]] screenshot of episode 105: Protestors [[slingshot|slingshotting]] themselves at the network headquarters {{Screenshot}}',140084,'Cburnett','20041214013532','0','BITMAP','image','jpeg',0,'p8y0wrhiawcdokik4qbkgjop1xlchzo'),(2621,'Susan-Werner---Midwestern-Saturday-Night.jpg','20041214033950!Susan_Werner_-_Midwestern_Saturday_Night.jpg',16373,300,300,8,'Cover for album \'\'[[Midwestern Saturday Night]]\'\' by [[Susan Werner]]. {{albumcover}}',110766,'DCEdwards1966','20041214031608','0','BITMAP','image','jpeg',0,'9f8d14ckc9c1w72v03xtmi9fbv2vyjn'),(2622,'Susan-Werner---Midwestern-Saturday-Night.jpg','20041214034041!Susan_Werner_-_Midwestern_Saturday_Night.jpg',16373,300,300,8,'Cover for album \'\'[[Time Between Trains]]\'\' by [[Susan Werner]]. {{albumcover}}',110766,'DCEdwards1966','20041214033950','0','BITMAP','image','jpeg',0,'9f8d14ckc9c1w72v03xtmi9fbv2vyjn'),(2623,'Sca-kant.jpg','20041214193827!Sca-kant.jpg',78078,432,636,8,'Steven Anderson photo',55169,'Sca','20041214185851','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:11:30 12:01:28\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'awpm876uwapb3x2e8guzsgr3llvzqw3'),(2624,'Us000848479.gif','20041214211935!Us000848479.gif',86303,782,1316,4,'U. S patent no. 488479 {{PD}}',9397,'Haabet','20041214190711','0','BITMAP','image','gif',0,'4ddf4h5mejo3btagv72heeajw29mh0v'),(2625,'Kong-logo.png','20041214223308!Kong_logo.png',3126,125,63,8,'[[KONG]] logo',19020,'ShadowDragon','20040627052918','0','BITMAP','image','png',0,'qfwekk0a7kji2go4w6h18d4hinaisut'),(2626,'Gabriel-Wicke.jpg','20041214232506!Gabriel_Wicke.jpg',19271,110,143,8,'a thumb of myself for my user page, {{GFDL}}',35675,'Gwicke','20040727175104','a:23:{s:16:\"ImageDescription\";s:31:\"Tchibo   DIGITAL CAMERA        \";s:4:\"Make\";s:23:\"Tchibo   OPTICAL CO,LTD\";s:5:\"Model\";s:6:\"TCM410\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:7:\"V4-1018\";s:8:\"DateTime\";s:19:\"2001:12:00 00:00:00\";s:16:\"YCbCrPositioning\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2001:07:25 21:35:20\";s:17:\"DateTimeDigitized\";s:19:\"2001:07:25 21:35:24\";s:22:\"CompressedBitsPerPixel\";s:9:\"1050/7742\";s:17:\"ShutterSpeedValue\";s:4:\"46/8\";s:13:\"ApertureValue\";s:11:\"35055/10000\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:12:\"MeteringMode\";i:0;s:5:\"Flash\";i:1;s:11:\"FocalLength\";s:9:\"8240/1000\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'npjcwu0b3yl8jcmonic9jhjhk1omlul'),(2627,'Untagged-Images-Remaining.png','20041214234517!Untagged_Images_Remaining.png',2207,432,240,8,'Progress at [[Wikipedia:Untagged Images]]',88976,'Kbh3rd','20041213161920','0','BITMAP','image','png',0,'eo4rbjpbr94ulstvmyxhcaa9xssl3g0'),(2628,'SPD.png','20041215040534!SPD.png',23783,422,153,8,'incandescent and fluorescent Spectral Power Distributions',91342,'Dkroll2','20041215023213','0','BITMAP','image','png',0,'j9nj77qyvwn978uoqepv1eer4yq3we4'),(2629,'Rostov-jacob-monastery.jpg','20041215065712!Rostov_jacob_monastery.jpg',137498,1024,917,8,'The Yakovlevsky monastery, Rostov Veliky in 1913 {{PD}}',147410,'Ghirlandajo','20041214154123','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:12:14 12:07:09\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'eqv47vu3vdjz433vwhgxn22ytf3xuxw'),(2630,'Openmind-J-Fox.jpg','20041215073924!Openmind_J_Fox.jpg',1000244,2400,3000,8,'Artwork created by user:Transient, <P>Uploaded to Wikipedia',152298,'Tansient','20041215073242','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2003:06:25 09:03:10\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'3sje16b8h4p100d1njb62fgl0zgdym0'),(2631,'Openmind-J-Fox.jpg','20041215074124!Openmind_J_Fox.jpg',313119,1200,1500,8,'Image Created by user:Transient',152298,'Tansient','20041215073924','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:12:15 02:37:38\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'n2w4zgy3istjx88pmonjbxmjqjoq19r'),(2632,'Openmind-J-Fox.jpg','20041215074326!Openmind_J_Fox.jpg',121452,600,750,8,'',152298,'Tansient','20041215074124','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:12:15 02:40:29\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'pa0j274251nsqdo1p8luyj1bm4r1pwf'),(2633,'The-Scream.jpg','20041215080029!The_Scream.jpg',139811,750,970,8,'Reverted to earlier revision',19009,'Ed g2s','20040824135305','0','BITMAP','image','jpeg',0,'871qa5h1m5q3tjfb69gfre6h71e5jhx'),(2634,'Untagged-Images-Remaining.png','20041215133525!Untagged_Images_Remaining.png',2209,432,240,8,'14-Dec-2004 - 05:24 - 30,278 remaining',88976,'Kbh3rd','20041214234517','0','BITMAP','image','png',0,'0hdialaulv5gs4xxrxkpbk1qmdfe2lv'),(2635,'Simple-supply-and-demand.png','20041215171927!Simple_supply_and_demand.png',2852,328,281,8,'',0,'(Automated conversion)','20020720114927','0','BITMAP','image','png',0,'tunw2yx8e85h0zz4u9rfzihri4gw486'),(2636,'Swiss-Flag-Ellipse.gif','20041215174502!Swiss_Flag_Ellipse.gif',1084,130,130,5,'Elliptical flag of user Switzerland',152542,'Switzerland','20041215173521','0','BITMAP','image','gif',0,'60hawfpe9djl4qjnqfn92sc25ea35wy'),(2637,'Graph-potus-heights.jpg','20041215203753!Graph-potus-heights.jpg',142015,1000,1000,8,'Graph of U.S. presidential heights',12028,'Jengod','20041215203116','0','BITMAP','image','jpeg',0,'bzs1gaevb88wrv5dzkuhv8lwao7knav'),(2638,'Shipping-Zones.png','20041215222347!Shipping_Zones.png',175790,504,569,8,'tried to make scotland bigger',35639,'Dmn','20041111234102','0','BITMAP','image','png',0,'pz48gayn8yz2cx9vox8cs51fizebq8r'),(2639,'Shipping-Zones.png','20041215222346!Shipping_Zones.png',175790,504,569,8,'tried to make scotland bigger',35639,'Dmn','20041111234102','0','BITMAP','image','png',0,'c7t5z21abq5f2s3sqy3admjszn17vxf'),(2640,'Shipping-Zones.png','20041215222521!Shipping_Zones.png',175169,504,569,8,'Reverted to earlier revision',55445,'Telso','20041215222347','0','BITMAP','image','png',0,'3dqmj0qbcxlotaea04nnx7fh0egefwa'),(2641,'Untagged-Images-Remaining.png','20041216015239!Untagged_Images_Remaining.png',2215,432,240,8,'15-Dec-2004 - 05:07 = 29,304 remaining',88976,'Kbh3rd','20041215133525','0','BITMAP','image','png',0,'khdjuadzmpmtbbn83vgp7agdcw4xx5a'),(2642,'County-tier-ontario.PNG','20041216034945!County-tier-ontario.PNG',9836,378,379,8,'Counties of Ontario',15348,'Snickerdo','20041208084007','0','BITMAP','image','png',0,'ffohbelagrkh16btdr4jbu60x7akh2a'),(2643,'Chapman1861.jpg','20041216090820!Chapman1861.jpg',34517,454,444,8,'Chapman University logo',125210,'Rlazarowich','20041216090420','0','BITMAP','image','jpeg',0,'0qxri79lkhnpw766er8flqbt2gew1rh'),(2644,'George-Marselis.jpg','20041216130452!George_Marselis.jpg',8110,270,360,8,'My own pic, used in my own page',91201,'Project2501a','20041207151552','0','BITMAP','image','jpeg',0,'43cm4pabh1zrrh4h1ooo47qc2zz2x0r'),(2645,'Untagged-Images-Remaining.png','20041217033228!Untagged_Images_Remaining.png',2221,432,240,8,'16-Dec-2004 - 00:31 = 27,992 remaining',88976,'Kbh3rd','20041216015239','0','BITMAP','image','png',0,'b7eowogfa6mwhrz6byma7q1i4wdjrg5'),(2646,'Benzylpiperazine.jpg','20041217051406!Benzylpiperazine.jpg',16488,228,152,8,'Benzylpiperazine structural forumula. {{PD}}',91937,'FirstPrinciples','20041210102701','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:12:10 23:26:35\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'1ba7th2i25j6eephslf67uww1fo1eul'),(2647,'WestminsterAssembly.jpg','20041217062245!WestminsterAssembly.jpg',30868,400,238,8,'Westminster Assembly.  Believes to be public domain.  {{PD}}',90640,'Brian0918','20041217062235','0','BITMAP','image','jpeg',0,'pjy0nx1trmwwt83js3i6iz6yo6p094p'),(2648,'Nikolai-karamzin.jpg','20041217094757!Nikolai_karamzin.jpg',18594,561,673,8,'Portrait of Nikolai Karamzin {{PD}}',147410,'Ghirlandajo','20041217094402','0','BITMAP','image','jpeg',0,'189e0wknqk2htgz8gqf33ksu3akznzx'),(2649,'VulvaDiagram-800.jpg','20041217100912!VulvaDiagram-800.jpg',95282,800,568,8,'Reverted to earlier revision',129610,'VerTiCal','20041121164823','a:26:{s:4:\"Make\";s:5:\"NIKON\";s:5:\"Model\";s:4:\"E950\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:7:\"v981-76\";s:8:\"DateTime\";s:19:\"1999:08:04 22:13:19\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/200\";s:7:\"FNumber\";s:5:\"34/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:0;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"1999:08:04 22:13:19\";s:17:\"DateTimeDigitized\";s:19:\"1999:08:04 22:13:19\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"26/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:6:\"146/10\";s:10:\"ColorSpace\";i:1;s:12:\"WhiteBalance\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'oz8epeuphjbyut86w36on1dj15lui8u'),(2650,'VulvaDiagram-800.jpg','20041217100924!VulvaDiagram-800.jpg',106590,800,568,8,'Reverted to earlier revision',132145,'Tchalvak','20041217100912','0','BITMAP','image','jpeg',0,'pf1ylba6aakns2o00b7ekdl4rfsu52y'),(2651,'VulvaDiagram-800.jpg','20041217101533!VulvaDiagram-800.jpg',91242,800,568,8,'Reverted to earlier revision',132145,'Tchalvak','20041217100924','a:26:{s:4:\"Make\";s:5:\"NIKON\";s:5:\"Model\";s:4:\"E950\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:7:\"v981-76\";s:8:\"DateTime\";s:19:\"1999:08:04 22:13:19\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/200\";s:7:\"FNumber\";s:5:\"34/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:0;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"1999:08:04 22:13:19\";s:17:\"DateTimeDigitized\";s:19:\"1999:08:04 22:13:19\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"26/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:6:\"146/10\";s:10:\"ColorSpace\";i:1;s:12:\"WhiteBalance\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'6vqxjd55bfuvki6d6ll285zq9fitpkh'),(2652,'THC-structure.png','20041217104411!THC_structure.png',2842,227,130,8,'',83784,'Cacycle','20041129200157','0','BITMAP','image','png',0,'s35oo0o39hr1bzab04kfjhn5arxht7p'),(2653,'THV-structure.png','20041217104419!THV_structure.png',2702,185,130,8,'',83784,'Cacycle','20041130171636','0','BITMAP','image','png',0,'j3wedatwur3gn9srugcltox8g6ttoaz'),(2654,'Prince2-diagram.png','20041217104553!Prince2_diagram.png',2091,576,333,4,'PRINCE2 Processes',67185,'Rellis1067','20041217103849','0','BITMAP','image','png',0,'905ngpujq2m1nbz21iho74mw6w8pu74'),(2655,'Prince2-diagram.png','20041217104902!Prince2_diagram.png',2790,628,423,4,'Prince2 diagram',67185,'Rellis1067','20041217104553','0','BITMAP','image','png',0,'a2k9eee4spbefp3ofs0vzmxer1rui8f'),(2656,'Prince2-diagram.png','20041217105436!Prince2_diagram.png',4124,628,423,8,'Prince2 diagram',67185,'Rellis1067','20041217104902','0','BITMAP','image','png',0,'12b7mtbk3a4izbumittvzowuver6kas'),(2657,'Prince2-diagram.png','20041217105514!Prince2_diagram.png',4804,628,423,8,'Prince2 diagram',67185,'Rellis1067','20041217105436','0','BITMAP','image','png',0,'012t5t5782xq5er8bfh6vlv8na313iu'),(2658,'Crude-EU28.png','20041217151349!Crude-EU28.png',3403,262,160,8,'Correcting whiteness of sea',85484,'Aris Katsaris','20041007171454','0','BITMAP','image','png',0,'2tegqbu86px2ys10ijwae310t6q9ige'),(2659,'Bouncing-cats.jpg','20041217173806!Bouncing_cats.jpg',112279,640,480,8,'{{PD-self}}',138776,'Rebroad','20041215164411','a:14:{s:4:\"Make\";s:9:\"Panasonic\";s:5:\"Model\";s:13:\"NV-GS5       \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2002:04:30 14:33:33\";s:16:\"YCbCrPositioning\";i:2;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2002:04:30 14:33:33\";s:17:\"DateTimeDigitized\";s:19:\"2002:04:30 14:33:33\";s:22:\"CompressedBitsPerPixel\";s:5:\"34/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'8yu2tzxch4uizu6r1r2opcnbuzbr3hz'),(2660,'Gendarmes-mobiles-FAMAS.jpg','20041217194252!Gendarmes_mobiles_FAMAS.jpg',92333,621,813,8,'gendarmes mobiles',22449,'David.Monniaux','20041217193318','a:28:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:7:\"DSC-P52\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:04:01 14:27:11\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/1600\";s:7:\"FNumber\";s:5:\"56/10\";s:15:\"ExposureProgram\";i:8;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:04:01 14:27:11\";s:17:\"DateTimeDigitized\";s:19:\"2004:04:01 14:27:11\";s:22:\"CompressedBitsPerPixel\";s:3:\"4/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"62/16\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:1;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"63/10\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:1;s:16:\"SceneCaptureType\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'df9c46v39bf7y77v990sy3wvfcufw2q'),(2661,'THV-structure.png','20041217200857!THV_structure.png',2695,185,130,8,'stereochemistry corrected',83784,'Cacycle','20041217104419','0','BITMAP','image','png',0,'73kqd10uhgyt4pkkjux4k29ur0yhopz'),(2662,'Pepsi-can-stove-lit.JPG','20041217201715!Pepsi_can_stove_lit.JPG',21869,480,480,8,'Reverted to earlier revision',31175,'Hemanshu','20041020185121','0','BITMAP','image','jpeg',0,'4niilgpilt6p0nlkkg5z4h1jylvdu0e'),(2663,'Pepsi-can-stove-lit.JPG','20041217201720!Pepsi_can_stove_lit.JPG',15066,480,370,8,'Reverted to earlier revision',128473,'Cookie3','20041217201715','0','BITMAP','image','jpeg',0,'j44bra0wnlcf0w9mcgmi734d411qjqz'),(2664,'Pepsi-can-stove-lit.JPG','20041217205414!Pepsi_can_stove_lit.JPG',21869,480,480,8,'Reverted to earlier revision',128473,'Cookie3','20041217201720','0','BITMAP','image','jpeg',0,'4niilgpilt6p0nlkkg5z4h1jylvdu0e'),(2665,'Pepsi-can-stove-lit.JPG','20041217205848!Pepsi_can_stove_lit.JPG',15066,480,370,8,'Reverted to earlier revision',145965,'Alex Jaspersen','20041217205414','0','BITMAP','image','jpeg',0,'j44bra0wnlcf0w9mcgmi734d411qjqz'),(2666,'Ohio-recount4.jpg','20041217220937!Ohio_recount4.jpg',65766,378,253,8,'{{GFDL}}',9076,'Kevin Baas','20041216212417','0','BITMAP','image','jpeg',0,'lsyeonrdrqi3y1pd9qlwp10iwx3ao6x'),(2667,'Roman-ring-with-one-wormhole.png','20041217232006!Roman_ring_with_one_wormhole.png',2743,312,233,8,'tidied and pnged version of [[Image:Roman0.jpg]], originally uploaded by [[User:Neutrino 79]] with no licence informantion',66,'Bryan Derksen','20041211045003','0','BITMAP','image','png',0,'icejqbest8h724ue9gt7w7sijor87g6'),(2668,'Roman-ring-with-two-wormholes.png','20041217232020!Roman_ring_with_two_wormholes.png',2858,312,233,8,'tidied and pnged version of [[:Image:Roman1.jpg]], originally uploaded by [[User:Neutrino 79]] with no licence informantion. {{unverified}}',66,'Bryan Derksen','20041211045130','0','BITMAP','image','png',0,'p0s2u2ypqh53qnka7erakab9q8fgd3n'),(2669,'Roman-ring-with-four-wormholes.png','20041217232054!Roman_ring_with_four_wormholes.png',3199,312,233,8,'tidied and pnged version of [[:Image:Roman2.jpg]], originally uploaded by [[User:Neutrino 79]] with no licence informantion. {{unverified}}',66,'Bryan Derksen','20041211045201','0','BITMAP','image','png',0,'e73iv6m64qe6aht3x6wrnw6jycw9r4h'),(2670,'Roman-ring-with-one-wormhole.png','20041217232607!Roman_ring_with_one_wormhole.png',1016,150,150,8,'GFDL version',57108,'Quadell','20041217232006','0','BITMAP','image','png',0,'an8is2q270zrwplsit5idszy8vfdvps'),(2671,'Roman-ring-with-two-wormholes.png','20041217232645!Roman_ring_with_two_wormholes.png',1373,150,150,8,'GFDL version',57108,'Quadell','20041217232020','0','BITMAP','image','png',0,'ilii8dhj7uq65hsqqeznh9nt6s7khts'),(2672,'Roman-ring-with-four-wormholes.png','20041217232711!Roman_ring_with_four_wormholes.png',1682,150,150,8,'GFDL version',57108,'Quadell','20041217232054','0','BITMAP','image','png',0,'sf7zntc16go2xlhrj4cmtwt7r0ajo4v'),(2673,'Ohio-recount4.jpg','20041217233136!Ohio_recount4.jpg',66497,378,253,8,'{{GFDL}}',9076,'Kevin Baas','20041217220937','0','BITMAP','image','jpeg',0,'rh70ne74ck3b7d0nrdt8z2n4q424ahr'),(2674,'Avishai-cohen-in-brno.jpg','20041218000402!Avishai_cohen_in_brno.jpg',34807,640,480,8,'avishai cohen in brno (czech republic)',139245,'Twisp','20041217235952','0','BITMAP','image','jpeg',0,'ilx6vbb897u5oqvnrr71z7huhv4aw48'),(2675,'BC-RD-29-Sunshine-Coast.png','20041218033826!BC_RD_29_Sunshine_Coast.png',5678,472,391,4,'British Columbia - Sunshine Coast Regional District map',23958,'Denelson83','20040614230844','0','BITMAP','image','png',0,'9ooptemjv27coyh3aopaaf5bahgsu3i'),(2676,'Red.arrows.single.arp.750pix.jpg','20041218090640!Red.arrows.single.arp.750pix.jpg',100599,750,510,8,'Red Arrows singleton',7095,'Arpingstone','20040812134750','a:34:{s:16:\"ImageDescription\";s:31:\"OLYMPUS DIGITAL CAMERA         \";s:4:\"Make\";s:19:\"OLYMPUS CORPORATION\";s:5:\"Model\";s:6:\"C750UZ\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:9:\"v753u2-86\";s:8:\"DateTime\";s:19:\"2004:06:20 13:35:33\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:8:\"10/10000\";s:7:\"FNumber\";s:5:\"70/10\";s:15:\"ExposureProgram\";i:4;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:06:20 13:35:33\";s:17:\"DateTimeDigitized\";s:19:\"2004:06:20 13:35:33\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"38/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:6:\"630/10\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:5:\"0/100\";s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'go9vq2od3yohvzirzvxgctbwutxxffq'),(2677,'Hetman-Maly1.gif','20041218162758!Hetman_Maly1.gif',7386,144,169,8,'author emax',60647,'Emax','20041218162513','0','BITMAP','image','gif',0,'58b0grna68z08c7xj9cyqi73njtvvsg'),(2678,'Hetman-Maly1.gif','20041218163152!Hetman_Maly1.gif',7134,144,169,8,'author emax',60647,'Emax','20041218162758','0','BITMAP','image','gif',0,'6viq32jxvd3il2dlcibw3q87hlazhzz'),(2679,'Usinprogress.PNG','20041218173743!Usinprogress.PNG',34622,280,183,8,'update...',35314,'Seth Ilys','20041028145542','0','BITMAP','image','png',0,'0p0zbp0nlyyeemd4yvmidd344fyk4tj'),(2680,'Smashing-Pumpkins-Greatest-Hits-album-cover.jpg','20041218223441!Smashing_Pumpkins_Greatest_Hits_album_cover.jpg',173779,985,978,8,'{{albumcover}} The Smashing Pumpkins \'\'Greatest Hits\'\' album cover',38020,'Dbenbenn','20041218222254','a:32:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:20:\"Canon PowerShot A310\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:12:18 12:23:10\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:4:\"1/20\";s:7:\"FNumber\";s:5:\"36/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:12:18 12:23:10\";s:17:\"DateTimeDigitized\";s:19:\"2004:12:18 12:23:10\";s:22:\"CompressedBitsPerPixel\";s:3:\"3/1\";s:17:\"ShutterSpeedValue\";s:6:\"138/32\";s:13:\"ApertureValue\";s:6:\"118/32\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:6:\"118/32\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:6:\"160/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"2048000/208\";s:21:\"FocalPlaneYResolution\";s:11:\"1536000/156\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:9:\"2048/2048\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'ccl827xfh9w4hfyj55yau5n6k8fmn66'),(2681,'Ohio-recount4.jpg','20041219041455!Ohio_recount4.jpg',66885,378,253,8,'{{GFDL}}',9076,'Kevin Baas','20041217233136','0','BITMAP','image','jpeg',0,'sd2vx5pp6np1kac790kk9n8c7n79ox0'),(2682,'Thomas-Jefferson-Signature.gif','20041219061936!Thomas_Jefferson_Signature.gif',3870,153,50,8,'Signature of Thomas Jefferson',91912,'Omnibus','20041219015506','0','BITMAP','image','gif',0,'rge8pk338j1gvfrumjhphb4p0dspo08'),(2683,'InsideAssemblyhall.jpg','20041219080254!InsideAssemblyhall.jpg',65932,650,442,8,'Improved contrast',42878,'Cool Hand Luke','20041014175449','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:10:14 11:52:29\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'ahkov29gr4wm7b9iz2ku53x97u3hsag'),(2684,'Virtual-finite-state-machine-executor-in-the-virtual-environment.gif','20041219162901!Virtual_finite_state_machine_executor_in_the_virtual_environment.gif',2759,360,204,8,'virtual finite state machine executor in the virtual environment',146633,'Thowa','20041218183114','0','BITMAP','image','gif',0,'7tq47b18su2x5al7uzl46fzg289kuew'),(2685,'P7140079.JPG','20041219165558!P7140079.JPG',1011539,2560,1920,8,'photo of Ferry street in Ironbound, Newark, taken by author of article, JSB.  {{GFDL}}  ',16822,'Dinopup','20040714213505','a:33:{s:16:\"ImageDescription\";s:31:\"OLYMPUS DIGITAL CAMERA         \";s:4:\"Make\";s:23:\"OLYMPUS CORPORATION    \";s:5:\"Model\";s:16:\"C-5000Z         \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"144/1\";s:11:\"YResolution\";s:5:\"144/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:31:\"Version 1.0                    \";s:8:\"DateTime\";s:19:\"2004:07:14 15:46:14\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:5:\"1/125\";s:7:\"FNumber\";s:5:\"56/10\";s:15:\"ExposureProgram\";i:5;s:15:\"ISOSpeedRatings\";i:50;s:11:\"ExifVersion\";s:4:\"0221\";s:16:\"DateTimeOriginal\";s:19:\"2004:07:14 15:46:14\";s:17:\"DateTimeDigitized\";s:19:\"2004:07:14 15:46:14\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:7:\"300/100\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:25;s:11:\"FocalLength\";s:7:\"780/100\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:7:\"100/100\";s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'jdtmbc0yrsxi4n9uuduateug8uv31v1'),(2686,'Pei-led.JPG','20041219170413!Pei_led.JPG',5981,190,127,8,'',88099,'MS123','20041213023229','0','BITMAP','image','jpeg',0,'5oedme5abtvuz8plj0tspiouz0t2vs7'),(2687,'Map-of-Camden-County-highlighting-Camden.png','20041219171103!Map_of_Camden_County_highlighting_Camden.png',7466,550,681,4,'taken from State of New Jersey website - adapted by H. Cheney - GFDL & CC-SA-BY',35530,'Hcheney','20040608184200','0','BITMAP','image','png',0,'ffew9j1z00m0g14yqut1rry2s7rnjzy'),(2688,'Untagged-Images-Remaining.png','20041219180110!Untagged_Images_Remaining.png',2221,432,240,8,'17-Dec-2004 - 00:15 = 27,072 remaining',88976,'Kbh3rd','20041217033228','0','BITMAP','image','png',0,'mxh9o2zfh8qpbt443afq4t88hmuyjzu'),(2689,'Stations.jpeg','20041219212805!Stations.jpeg',7587,292,204,8,'Stations of the Crass cover art used with band\'s permission',3741,'Quercusrobur','20041219212221','0','BITMAP','image','jpeg',0,'7rzc4nql8tk3vs4ig0gcl4ocpyjipg5'),(2690,'Discussion-tab.png','20041220003716!Discussion-tab.png',11867,408,133,8,'Discussion tab. {{GFDL}}',48159,'Tom-','20041220003332','0','BITMAP','image','png',0,'k4824kaga0we8wi4cw9x6it814f3c8m'),(2691,'Discussion-tab.png','20041220003949!Discussion-tab.png',10512,408,130,8,'Discussion tab. {{GFDL}}',48159,'Tom-','20041220003716','0','BITMAP','image','png',0,'gnq1w2w5thidwalelyfyomnh172iej9'),(2692,'Discussion-tab.png','20041220004444!Discussion-tab.png',10928,408,130,8,'Discussion tab. {{GFDL}}',48159,'Tom-','20041220003949','0','BITMAP','image','png',0,'6o6qaq4afo32ux39vmd7qqvgshrlyts'),(2693,'History-tab.png','20041220010338!History-tab.png',4197,326,111,8,'History tab {{GFDL}}',48159,'Tom-','20041220010047','0','BITMAP','image','png',0,'hvraf3zfj8z2fzuibqfk93ceaojwj25'),(2694,'Edit-this-page-tab.png','20041220011004!Edit-this-page-tab.png',10559,408,130,8,'Edit this page tab. {{GFDL}}',48159,'Tom-','20041220004700','0','BITMAP','image','png',0,'8l5g1r883qvi0vh687g4sh12bkeoy7d'),(2695,'Discussion-tab.png','20041220011005!Discussion-tab.png',10508,408,130,8,'Discussion tab. {{GFDL}}',48159,'Tom-','20041220004444','0','BITMAP','image','png',0,'3dn53sf08pflkub013ywia6sxklz5rs'),(2696,'Elzbieta-Czartoryska-(1736-1819).jpg','20041220014449!Elzbieta_Czartoryska_(1736-1819).jpg',55306,340,400,8,'Elzbieta Czartoryska {{pd}}',60647,'Emax','20041206214201','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:8:\"DateTime\";s:19:\"2004:12:06 22:40:02\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'rvrjvy83uotc3jn0z0j7em6jw9ro484'),(2697,'Yukon---Kluane-Park-and-Alaska-Highway-area.png','20041220014645!Yukon_-_Kluane_Park_and_Alaska_Highway_area.png',11941,514,553,4,'',124348,'Geo Swan','20041030205751','0','BITMAP','image','png',0,'9prrecw7r0ib536zz39ofn7n6559aqf'),(2698,'Jozef-Poniatowski.jpg','20041220015741!Jozef_Poniatowski.jpg',12774,210,265,8,'',60647,'Emax','20040923132343','0','BITMAP','image','jpeg',0,'spourp8189h1n5bvfaltik7s7wqh16r'),(2699,'2pesos.jpg','20041220021130!2pesos.jpg',58086,208,93,0,'',15906,'Gustavobernhardt','20031220115219','0','BITMAP','image','x-bmp',0,'fiy0zx9fa3eacbu9mcnljxjbaks036v'),(2700,'5pesos.jpg','20041220021216!5pesos.jpg',58086,208,93,0,'',15906,'Gustavobernhardt','20031220113744','0','BITMAP','image','x-bmp',0,'840oub0vo1nubcykfrpp5p2pyfwo1yi'),(2701,'10pesos.jpg','20041220021250!10pesos.jpg',58086,208,93,0,'',15906,'Gustavobernhardt','20031220114829','0','BITMAP','image','x-bmp',0,'6qvbrv6wbg33bv7zeclbvbhgy58sfuj'),(2702,'20pesos.jpg','20041220021317!20pesos.jpg',59334,208,95,0,'',15906,'Gustavobernhardt','20031220120052','0','BITMAP','image','x-bmp',0,'qdyi2ak1naux8c74tjoiixjorj639hc'),(2703,'50pesos.jpg','20041220021413!50pesos.jpg',59574,213,93,0,'',15906,'Gustavobernhardt','20031220120809','0','BITMAP','image','x-bmp',0,'aa1f4ywdss4wbnbhwixr5hkgp6llwqs'),(2704,'Sunset.bodø.norway.jpg','20041220022430!Sunset.bodø.norway.jpg',1216475,2526,1684,8,'A sunset view over Bodø, Norway, in late summer.  Created by Seth G. Cowdery on August 28th, 2004.  {{cc-by}}',154757,'BlueCanoe','20041220021122','a:38:{s:4:\"Make\";s:8:\"FUJIFILM\";s:5:\"Model\";s:14:\"FinePix S7000 \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:12:19 17:15:13\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/600\";s:7:\"FNumber\";s:7:\"300/100\";s:15:\"ExposureProgram\";i:1;s:15:\"ISOSpeedRatings\";i:200;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:08:28 20:47:04\";s:17:\"DateTimeDigitized\";s:19:\"2004:08:28 20:47:04\";s:22:\"CompressedBitsPerPixel\";s:5:\"20/10\";s:17:\"ShutterSpeedValue\";s:7:\"600/100\";s:13:\"ApertureValue\";s:7:\"320/100\";s:15:\"BrightnessValue\";s:7:\"135/100\";s:17:\"ExposureBiasValue\";s:5:\"0/100\";s:16:\"MaxApertureValue\";s:7:\"300/100\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:8:\"1700/100\";s:10:\"ColorSpace\";i:65535;s:21:\"FocalPlaneXResolution\";s:6:\"3742/1\";s:21:\"FocalPlaneYResolution\";s:6:\"3742/1\";s:24:\"FocalPlaneResolutionUnit\";i:3;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:1;s:12:\"WhiteBalance\";i:1;s:16:\"SceneCaptureType\";i:0;s:9:\"Sharpness\";i:2;s:20:\"SubjectDistanceRange\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'qtkkdnjyjbh0gxtk9y0zi9suwhgcqyb'),(2705,'History-example.png','20041220023448!History-example.png',1024,296,69,2,'history example {{GFDL}}',48159,'Tom-','20041220022726','0','BITMAP','image','png',0,'km249fwpmrmv1i85m43rgddwj7weq0r'),(2706,'History-example.png','20041220024132!History-example.png',2192,229,55,4,'history example {{GFDL}}',48159,'Tom-','20041220023448','0','BITMAP','image','png',0,'9142d5v43bssd01j5g1pr8pkg36sj7s'),(2707,'History-example.png','20041220024427!History-example.png',1027,290,66,2,'history example {{GFDL}}',48159,'Tom-','20041220024132','0','BITMAP','image','png',0,'s44iiexo83w3gm3yk2b73eprjgjxdbd'),(2708,'History-example.png','20041220024500!History-example.png',1027,290,66,2,'history example {{GFDL}}',48159,'Tom-','20041220024427','0','BITMAP','image','png',0,'s44iiexo83w3gm3yk2b73eprjgjxdbd'),(2709,'History-example.png','20041220024557!History-example.png',1027,290,66,2,'history example {{GFDL}}',48159,'Tom-','20041220024500','0','BITMAP','image','png',0,'s44iiexo83w3gm3yk2b73eprjgjxdbd'),(2710,'Karen-Kwiatkowski.jpg','20041220045304!Karen_Kwiatkowski.jpg',29315,720,480,8,'{{fairuse}}',84330,'Rama','20041218080324','0','BITMAP','image','jpeg',0,'gq7p72pmj7dclv50jmamd5juc2x117b'),(2711,'04-Jan-2003-(12).jpg','20041220052707!04_Jan_2003_(12).jpg',213544,504,344,8,'lymphedema4.jpg',83996,'Drgnu23','20041216021445','0','BITMAP','image','jpeg',0,'l01kkqk3tp12tzd5td6k1ba64hn4bi8'),(2712,'Untagged-Images-Remaining.png','20041220175516!Untagged_Images_Remaining.png',2233,432,240,8,'19-Dec-2004 - 03:53 = 25,011 remaining',88976,'Kbh3rd','20041219180111','0','BITMAP','image','png',0,'0etik0fqbwdqr9e4tkuw30w0kg59ra4'),(2713,'Untagged-Images-Remaining.png','20041220175637!Untagged_Images_Remaining.png',2221,432,240,8,'20-Dec-2004 - 02:50 	24,381',88976,'Kbh3rd','20041220175516','0','BITMAP','image','png',0,'b7eowogfa6mwhrz6byma7q1i4wdjrg5'),(2714,'Ohio-recount4.jpg','20041220180643!Ohio_recount4.jpg',67494,378,253,8,'{{GFDL}}',9076,'Kevin Baas','20041219041455','0','BITMAP','image','jpeg',0,'4mpu5r98x633xk1kq9jh8slhfh6righ'),(2715,'DemonHunterDemonHunter.png','20041220181454!DemonHunterDemonHunter.png',102297,195,195,8,'Cover of [[Demon Hunter]]\'s debut, \'\'[[Demon Hunter (album)|Demon Hunter]]\'\'.  {{fairuse}}',34631,'Boarder8925','20041220181137','0','BITMAP','image','png',0,'j0ok7947d2rqxyf5tzjpoajehzgd6rn'),(2716,'Popscene.jpg','20041220202339!Popscene.jpg',6599,145,143,8,'{{albumcover}} Cover of [[Blur]] [[single]] [[Popscene]]',86091,'Moochocoogle','20041220201845','0','BITMAP','image','jpeg',0,'m1yp9x18j43zr8rwiga47r8ldmn6z1n'),(2717,'VulvaDiagram-800.jpg','20041220212406!VulvaDiagram-800.jpg',106590,800,568,8,'Reverted to earlier revision',132145,'Tchalvak','20041217101533','0','BITMAP','image','jpeg',0,'pf1ylba6aakns2o00b7ekdl4rfsu52y'),(2718,'Wawa-Ontario.png','20041220214118!Wawa_Ontario.png',12398,514,389,8,'Wawa Ontario',124348,'Geo Swan','20041220001546','0','BITMAP','image','png',0,'tegbfwg23mn8dp48it3dkheh1bmuppg'),(2719,'Fraudcast-News.jpg','20041220221040!Fraudcast_News.jpg',92238,680,535,8,'Promo card for \"Fraudcast News\". {{fairuse}}',122756,'Keyser Söze','20041220215839','0','BITMAP','image','jpeg',0,'pz9l59duft2w5k2t1naz65bzuy2wp4v'),(2720,'Walpole-island-ontario.png','20041220223051!Walpole_island_ontario.png',9534,514,611,8,'map of Walpole Island, Ontario',124348,'Geo Swan','20041220220338','0','BITMAP','image','png',0,'a2goqfrkrgoe2fbv2fp027qqvuh29fq'),(2721,'Us-senate-result-1966.PNG','20041221004949!Us_senate_result_1966.PNG',10301,506,313,8,'U.S. Senate results -- Republican pickups in dark red, Republican holds in light red, Democratic pickups in dark blue, Democratic holds in light blue<br>made by me<br> {PD}',69381,'Willhsmit','20041220234057','0','BITMAP','image','png',0,'o1g006afxx0c2qzztcs70b02gqm3yet'),(2722,'With-tactical.jpg','20041221030203!With_tactical.jpg',25758,419,345,8,'',146693,'Wterrell','20041221025751','0','BITMAP','image','jpeg',0,'bds5v4khjgf9i6mkdb0cqbk3agtmcmp'),(2723,'Us-senate-result-1966.PNG','20041221030352!Us_senate_result_1966.PNG',10322,506,313,8,'',69381,'Willhsmit','20041221004949','0','BITMAP','image','png',0,'gkxut026qu786jfr0xikh9wboqkbif2'),(2724,'92G-SD.jpg','20041221030953!92G-SD.jpg',34443,500,335,8,'',146693,'Wterrell','20041205144323','0','BITMAP','image','jpeg',0,'ay2m136wjzta43zyf5mfhvyvgz4dj5r'),(2725,'Yukonwikimap.PNG','20041221062603!Yukonwikimap.PNG',172542,863,926,8,'fixed typo',26201,'Earl Andrew','20041126024142','0','BITMAP','image','png',0,'h8iwh4g3ifiwlbdzshi15uvsu1m2kri'),(2726,'Yukonwikimap.PNG','20041221063247!Yukonwikimap.PNG',172582,863,926,8,'Reverted to earlier revision',152315,'Luigizanasi','20041221062603','0','BITMAP','image','png',0,'1cup85kru4jhu37kukntlahgc1bw1ev'),(2727,'Fairlight.png','20041221085838!Fairlight.png',1612,397,248,8,'',11907,'Hashar','20040810132014','0','BITMAP','image','png',0,'gnots5tko4ggqe24nf39rg6yni8scdx'),(2728,'Gateway-logo.png','20041221101609!Gateway_logo.png',2008,118,28,8,'Gateway logo, claiming fair use<br>{{msg:fairuse}}',23743,'RadicalBender','20040403021616','0','BITMAP','image','png',0,'je5shycyozt6uymci6745z4n97g3hkb'),(2729,'Michal-Kazimierz-Rybenko-Radziwill.jpg','20041221115311!Michal_Kazimierz_Rybenko_Radziwill.jpg',80068,312,489,8,'{{pd}}',60647,'Emax','20041221113929','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:8:\"DateTime\";s:19:\"2004:12:21 12:36:04\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'nuil43ypbyzmzys3xifdg59w2k073y5'),(2730,'Catenary.png','20041221125921!Catenary.png',8064,1200,900,8,'Catenary, y =  2 cosh(x/2)',138889,'Eramesan','20041215044957','0','BITMAP','image','png',0,'6zpuj71mi3jc9z0olw0bm1ep6g0xqm7'),(2731,'Untagged-Images-Remaining.png','20041221153021!Untagged_Images_Remaining.png',2240,432,240,8,'20-Dec-2004 - 02:50 	24,381 for real, this time',88976,'Kbh3rd','20041220175637','0','BITMAP','image','png',0,'n3itj2kcxr2dnfzdf9l39xb0dz625li'),(2732,'Karnaugh-map2.png','20041221183750!Karnaugh_map2.png',3347,289,270,8,'Based on the [[Image:Karnaugh map.png|image]] by [[User:Fubar_Obfusco]].<br>{{GFDL}}',88248,'ZeroOne','20041221002202','0','BITMAP','image','png',0,'mtprqdeeztsgv3fys0us8dcq055w7ba'),(2733,'Wikipedia-Arbitration-Committee-appointments.png','20041221195657!Wikipedia_Arbitration_Committee_appointments.png',65480,1063,585,8,'Thought that a graphical overview might be useful. Made in OmniOutliner. GFDL (by me).',8776,'Jdforrester','20041221141622','0','BITMAP','image','png',0,'2vun4m14f9jax8t0aw6s5i2hwi125ez'),(2734,'Wikipedia-Arbitration-Committee-appointments.png','20041221200015!Wikipedia_Arbitration_Committee_appointments.png',48836,738,407,8,'Fiddled with a little.',8776,'Jdforrester','20041221195657','0','BITMAP','image','png',0,'i0eo27wz6q2z4e2cvive402cqnokj89'),(2735,'Anarchism-in-Spain-Fascism-Snake.jpg','20041221220831!Anarchism_in_Spain_Fascism_Snake.jpg',20997,138,200,8,'CNT poster from spanish civil war - worker destroying fascism',63223,'Tothebarricades.tk','20040827220306','0','BITMAP','image','jpeg',0,'t7u4bsc2mct5mc2bjamn5aeuiolwwic'),(2736,'Anarchism-in-Spain-Fascism-Snake.jpg','20041221221337!Anarchism_in_Spain_Fascism_Snake.jpg',55311,345,500,8,'larger version',119861,'Foant','20041221220831','0','BITMAP','image','jpeg',0,'m975d4umzvb11a477l7seqatzhvl0bd'),(2737,'Us-senate-result-1990.PNG','20041221234709!Us_senate_result_1990.PNG',10261,506,313,8,'U.S. Senate results -- Republican pickups in dark red, Republican holds in light red, Democratic pickups in dark blue, Democratic holds in light blue<br>made by me<br> {PD}',69381,'Willhsmit','20041117040811','0','BITMAP','image','png',0,'kvo4b48e8fww0pzt78pka4self3za3c'),(2738,'Somethingdifferent.jpg','20041222014916!Somethingdifferent.jpg',58798,333,475,8,'DVD cover to Monty Python\'s [[And Now For Something Completely Different]]. {{fair use}}',94202,'Tom','20040828000222','0','BITMAP','image','jpeg',0,'0it3ojwb7fu3b8gpsf8g25hc0o6b5u3'),(2739,'Us-senate-result-1966.PNG','20041222015557!Us_senate_result_1966.PNG',10322,506,313,8,'',69381,'Willhsmit','20041221030352','0','BITMAP','image','png',0,'gkxut026qu786jfr0xikh9wboqkbif2'),(2740,'Us-senate-result-1966.PNG','20041222015621!Us_senate_result_1966.PNG',10324,506,313,8,'',69381,'Willhsmit','20041222015557','0','BITMAP','image','png',0,'gkxut026qu786jfr0xikh9wboqkbif2'),(2741,'Us-senate-result-1966.PNG','20041222015642!Us_senate_result_1966.PNG',10322,506,313,8,'Reverted to earlier revision',69381,'Willhsmit','20041222015621','0','BITMAP','image','png',0,'gkxut026qu786jfr0xikh9wboqkbif2'),(2742,'Us-senate-result-1966.PNG','20041222015750!Us_senate_result_1966.PNG',10324,506,313,8,'Reverted to earlier revision',69381,'Willhsmit','20041222015642','0','BITMAP','image','png',0,'gkxut026qu786jfr0xikh9wboqkbif2'),(2743,'Calixa-Lavallée.png','20041222040623!Calixa_Lavallée.png',71802,403,398,8,'Sketch of [[Calixa Lavallée]] from 1873, and thus public domain.  Copied from [http://collections.ic.gc.ca/montreal/d051.html] {{PD}}',1591,'SimonP','20041222040313','0','BITMAP','image','png',0,'slo3zcpkbd9qvmhporhtxl8drultbbc'),(2744,'Untagged-Images-Remaining.png','20041222053502!Untagged_Images_Remaining.png',2253,432,240,8,'21-Dec-2004 - 03:02 	22,849 ',88976,'Kbh3rd','20041221153021','0','BITMAP','image','png',0,'92q1b9bostp14ebjnw743wuyks6wqjb'),(2745,'Untagged-Images-Remaining.png','20041222053728!Untagged_Images_Remaining.png',2256,432,240,8,'22-Dec-2004 - 02:26 	21,326',88976,'Kbh3rd','20041222053502','0','BITMAP','image','png',0,'r46z5bhtw15fqshlxv8lqun5m8sicgi'),(2746,'Aetobatus-narinari.jpg','20041222065508!Aetobatus_narinari.jpg',39329,532,263,8,'Aetobatus narinarijpg',58781,'JoJan','20040627164010','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:6:\"1350/1\";s:11:\"YResolution\";s:6:\"1350/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:06:27 18:24:54\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'boflgl5xb8np9e3lbo4oi2hgx8f84uc'),(2747,'Aetobatus-narinari.jpg','20041222065805!Aetobatus_narinari.jpg',1282044,1684,1168,8,'better resolution version',140548,'Evil Monkey','20041222065508','0','BITMAP','image','jpeg',0,'0s2kl89thqcppr29ybhee7dfwrzg6sg'),(2748,'Tool-Undertow.jpg','20041222094345!Tool-Undertow.jpg',5451,329,329,8,'Tool - Undertow album cover',71006,'Jh51681','20040721055439','0','BITMAP','image','jpeg',0,'pfv3wfq4umja6afc4kzkcv6j9050v0v'),(2749,'Tool-Undertow.jpg','20041222094404!Tool-Undertow.jpg',11299,329,329,8,'brightened, less blurry version made from source at toolshed.down.net',17226,'Grendelkhan','20041222094345','0','BITMAP','image','jpeg',0,'3cw4fsn0ytraqjg3r81m6n9obsjb8k6'),(2750,'Ocean-Software-logo.png','20041222140038!Ocean_Software_logo.png',16278,157,46,8,'{{logo}}',110243,'Zelda','20041121223317','0','BITMAP','image','png',0,'8zbx4kr7bv4m5rz3sr1sue9vj5jam0j'),(2751,'LHC5.jpg','20041222151555!LHC5.jpg',222216,748,595,8,'First image on the web',155919,'Dr.psycho','20041222151407','0','BITMAP','image','jpeg',0,'mlzn8bkm828rqli3aocta25hyk4qmu5'),(2752,'BattleBetweenMonitorMerrimac.png','20041222175613!BattleBetweenMonitorMerrimac.png',421603,800,590,8,'Battle between the Monitor and Merrimac--fought March 9th 1862 at Hampton Roads, near Norfolk, Va.  CALL NUMBER:  PGA - Kurz & Allison--Battle between the Monitor and Merrimac (D size) [P&P].  REPRODUCTION NUMBER:  LC-USZC4-1752 (color film copy transpare',90640,'Brian0918','20041220213255','0','BITMAP','image','png',0,'3orp9kosm0nxb83ymhlh5kh75o8xah6'),(2753,'BattleBetweenMonitorMerrimac.png','20041222175736!BattleBetweenMonitorMerrimac.png',275723,770,544,8,'Battle between the Monitor and Merrimac--fought March 9th 1862 at Hampton Roads, near Norfolk, Va.  CALL NUMBER:  PGA - Kurz & Allison--Battle between the Monitor and Merrimac (D size) [P&P].  REPRODUCTION NUMBER:  LC-USZC4-1752 (color film copy transpare',90640,'Brian0918','20041222175613','0','BITMAP','image','png',0,'rhgdqa2fd0dhpyuee80jbourojcmerh'),(2754,'BattleBetweenMonitorMerrimac.png','20041222175810!BattleBetweenMonitorMerrimac.png',275723,770,544,8,'Battle between the Monitor and Merrimac--fought March 9th 1862 at Hampton Roads, near Norfolk, Va.  CALL NUMBER:  PGA - Kurz & Allison--Battle between the Monitor and Merrimac (D size) [P&P].  REPRODUCTION NUMBER:  LC-USZC4-1752 (color film copy transpare',90640,'Brian0918','20041222175736','0','BITMAP','image','png',0,'rhgdqa2fd0dhpyuee80jbourojcmerh'),(2755,'Donatello-statue.jpg','20041222195920!Donatello_statue.jpg',17500,200,390,8,'',75150,'Dryazan','20041222195303','0','BITMAP','image','jpeg',0,'eofo05zf2ujqk294mfyira2ewl3uz5o'),(2756,'Untagged-Images-Remaining.png','20041223055515!Untagged_Images_Remaining.png',2308,432,240,8,'Fixed problem w/ commas ',88976,'Kbh3rd','20041222053728','0','BITMAP','image','png',0,'qlfdynh341co6r3xfo8luzuo9084xcg'),(2757,'SOEgeorgestarr.jpg','20041223071117!SOEgeorgestarr.jpg',4379,132,119,8,'Hmm',29653,'Petermanchester','20031114001933','0','BITMAP','image','jpeg',0,'rm4rjkulkq6wu4wrb2a7futs2k1uiiu'),(2758,'JamesDignan.jpg','20041223075701!JamesDignan.jpg',14099,198,198,8,'User:Grutness, circa 1999',117878,'Grutness','20041223075631','0','BITMAP','image','jpeg',0,'spmvko1iegecmf7oew7fp4tt0wm2qbl'),(2759,'Apollo-7-Florida.jpg','20041223215606!Apollo_7_Florida.jpg',20540,344,350,8,'Apollo 7 photo of Florida (NASA)',38428,'Reubenbarton','20040819123901','0','BITMAP','image','jpeg',0,'kge2euwspc3ud65i7ui0xyojwigcw9a'),(2760,'Cricket-no-pic.png','20041224001130!Cricket_no_pic.png',2037,155,155,4,'Wikipedia has no licensable picture of this cricketer. Please help [[Wikipedia:WikiProject Cricket]] by supplying one if you can!',6972,'Ngb','20041224001023','0','BITMAP','image','png',0,'ig15j2brlcg1exqgk4j7wx7689ni1kv'),(2761,'Stanislaw-Kostka-Potocki-(1757-1821).jpg','20041224004544!Stanislaw_Kostka_Potocki_(1757-1821).jpg',58795,280,400,8,'{{pd}}',60647,'Emax','20041224003151','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:8:\"DateTime\";s:19:\"2004:12:24 01:29:48\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'9ufm5z39ocqxvvrfsi1wk0dt8f1dkxh'),(2762,'County-tier-ontario.PNG','20041224032821!County-tier-ontario.PNG',9884,378,379,8,'replacing existing map; a small but very noticeable corner of Renfrew County was not coloured red',24902,'Bearcat','20041216034945','0','BITMAP','image','png',0,'2aubih0rseyiakxrdbzfwi3wh8azxdv'),(2763,'County-tier-ontario.PNG','20041224032835!County-tier-ontario.PNG',9836,378,379,8,'Reverted to earlier revision',15348,'Snickerdo','20041224032821','0','BITMAP','image','png',0,'ffohbelagrkh16btdr4jbu60x7akh2a'),(2764,'County-tier-ontario.PNG','20041224033011!County-tier-ontario.PNG',9884,378,379,8,'Reverted to earlier revision',15348,'Snickerdo','20041224032835','0','BITMAP','image','png',0,'2aubih0rseyiakxrdbzfwi3wh8azxdv'),(2765,'Tarski.png','20041224065727!Tarski.png',18702,655,186,8,'',112153,'Sean Kelly','20041224064726','0','BITMAP','image','png',0,'ccdl2zyifafd8mxfsy0xsatxqoj74j5'),(2766,'4Nivo3-BK.png','20041224084954!4Nivo3_BK.png',38964,163,157,8,'Original Image by Asim Led on Wikipedia. Revised for clarification of Bosanska Krajina region',136143,'Dado','20041118015857','0','BITMAP','image','png',0,'ml0pcm7evjpdh37smez5z5ddjx4hee5'),(2767,'4Nivo3-BK.png','20041224085203!4Nivo3_BK.png',6402,163,157,8,'Updated for consistancy',136143,'Dado','20041224084955','0','BITMAP','image','png',0,'tc3ztn7ccztcrwlge082uynyrtrr4lq'),(2768,'4Nivo3-BK.png','20041224085223!4Nivo3_BK.png',6402,163,157,8,'Updated color for consistancy',136143,'Dado','20041224085203','0','BITMAP','image','png',0,'tc3ztn7ccztcrwlge082uynyrtrr4lq'),(2769,'Bigtyler.gif','20041224180438!Bigtyler.gif',55256,257,310,8,'George P. A. Healy (1813-1894)\r\nOil on canvas, 1859\r\nNational Portrait Gallery, Smithsonian Institution\r\nTransfer from the National Museum of American Art; gift of Friends of the National Institute',25253,'AlexPlank','20031106005846','0','BITMAP','image','gif',0,'db9gyzsqeh6x68v3tb38wcpes9h5g6m'),(2770,'Untagged-Images-Remaining.png','20041224213524!Untagged_Images_Remaining.png',2310,432,240,8,'23-Dec-2004 - 04:01 	20,726',88976,'Kbh3rd','20041223055516','0','BITMAP','image','png',0,'epg5oy3s5dyvi9hrb6ebbgdm3d8kf7o'),(2771,'YugiMutou.PNG','20041224230619!YugiMutou.PNG',386242,360,465,8,'Yugi Mutou, from Shonen Jump no. 6',15708,'WhisperToMe','20041224224821','0','BITMAP','image','png',0,'ay4ylogzcuk6bxl2v22dk6hcps5xn0d'),(2772,'Rdrs-cold.jpg','20041225181527!Rdrs_cold.jpg',257930,2048,1536,8,'picture of user rdrs',142945,'Rdrs','20041225180449','a:22:{s:16:\"ImageDescription\";s:8:\"3MegaCam\";s:4:\"Make\";s:8:\"3MegaCam\";s:5:\"Model\";s:8:\"3MegaCam\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:4:\"2/36\";s:7:\"FNumber\";s:5:\"20/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"1/11\";s:16:\"MaxApertureValue\";s:3:\"3/2\";s:12:\"MeteringMode\";i:2;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"82/11\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'684efu9bo7y9coxfpe9ezngyffntmdp'),(2773,'Kde-konqueror-khtml-snapshot.png','20041225182017!Kde-konqueror-khtml-snapshot.png',197698,1032,851,8,'Snapshot of konqueror (KDE) showing the rendered wikipedia article of KHTML',9313,'Marco Krohn','20041225181347','0','BITMAP','image','png',0,'iv58890i5plyvqyek9pwznzwyx2u3jf'),(2774,'Penny-EIIR-QRI.jpg','20041225211331!Penny_EIIR_QRI.jpg',21119,319,159,8,'British Pennies compared, QII R vs. V RI. Composite of [[:Image:ElizIIPenny.jpeg]] and [[:Image:76-790.jpg]] {{GFDL}}',8776,'Jdforrester','20040708073542','0','BITMAP','image','jpeg',0,'32mur23kaxbom6jva1uby8mmsorc8fs'),(2775,'Grutness.jpg','20041226001809!Grutness.jpg',4054,80,33,8,'Reverted to earlier revision',117878,'Grutness','20041123082208','0','BITMAP','image','jpeg',0,'6aq8n5s80fitucdmrznsos8qm5hldbh'),(2776,'Three-phase-voltages.png','20041226020401!Three_phase_voltages.png',11824,640,401,4,'Three phase voltages',139104,'Wtshymanski','20041225233225','0','BITMAP','image','png',0,'mm13i3kikx2uhh4bu69h0q0u2hfxll9'),(2777,'Untagged-Images-Remaining.png','20041226023158!Untagged_Images_Remaining.png',2320,432,240,8,'24-Dec-2004 - 00:30 	19,235',88976,'Kbh3rd','20041224213524','0','BITMAP','image','png',0,'pm257ho2uq1oqu7gwuw0xv7ecn4m2qx'),(2778,'Untagged-Images-Remaining.png','20041226023436!Untagged_Images_Remaining.png',2464,432,240,8,'26-Dec-2004 - 01:53 	17,188',88976,'Kbh3rd','20041226023159','0','BITMAP','image','png',0,'efrk5or11aquwlcnzc9pb51nehc03h0'),(2779,'Doxapram.png','20041226120134!Doxapram.png',1501,211,144,8,'[[Doxapram]], drawn in [[OpenOffice.org]] by [[User:Jfdwolff]], {{GFDL}}',46555,'Jfdwolff','20041225204015','0','BITMAP','image','png',0,'aur3ac01dtcujpz6mmzaku5zi6ees17'),(2780,'HockeyRink-Creases.png','20041226220229!HockeyRink-Creases.png',4937,355,169,8,'The two types of goal creases found on contemporary [[hockey rink]]s {{GFDL}}',6852,'Flamurai','20041226155316','0','BITMAP','image','png',0,'ht68vosfwel7g0gxufrlunj603ej3ix'),(2781,'AtlanticHurricaneTrackmap.png','20041226223703!AtlanticHurricaneTrackmap.png',109075,1024,768,8,'{{PD-USGov-NOAA}}',69695,'Goobergunch','20041226223545','0','BITMAP','image','png',0,'68ld91x07a83end2187srnt7itc5ipa'),(2782,'Evil-Atheist-Conspira-logo.png','20041227010902!Evil_Atheist_Conspira_logo.png',88115,1242,1260,8,'The Evil Atheist Conspiracy Logo {{GFDL}}',55485,'Nova77','20041227005821','0','BITMAP','image','png',0,'pnie2xpuz3rynimdit62k5ldjqysefg'),(2783,'Dupuytrens-01.jpg','20041227045939!Dupuytrens-01.jpg',798876,1600,1200,8,'Duputrens Contracture ',83996,'Drgnu23','20041227040413','a:18:{s:4:\"Make\";s:7:\"TOSHIBA\";s:5:\"Model\";s:7:\"PDR2300\";s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:4:\"1.01\";s:8:\"DateTime\";s:19:\"2005:10:06 17:21:54\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:4:\"1/30\";s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2005:10:06 17:21:54\";s:17:\"DateTimeDigitized\";s:19:\"2005:10:06 17:21:54\";s:17:\"ShutterSpeedValue\";s:7:\"493/100\";s:13:\"ApertureValue\";s:4:\"0/10\";s:5:\"Flash\";i:1;s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'j7oe4yi6ytingfieb4euo9syy1m9gmf'),(2784,'Keloid-01.jpg','20041227050730!Keloid-01.jpg',320358,765,852,8,'Keloid-01',83996,'Drgnu23','20041225051415','a:19:{s:4:\"Make\";s:7:\"TOSHIBA\";s:5:\"Model\";s:7:\"PDR2300\";s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:4:\"1.01\";s:8:\"DateTime\";s:19:\"2005:10:06 19:17:34\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:4:\"1/30\";s:7:\"FNumber\";s:7:\"721/100\";s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2005:10:06 19:17:34\";s:17:\"DateTimeDigitized\";s:19:\"2005:10:06 19:17:34\";s:17:\"ShutterSpeedValue\";s:7:\"493/100\";s:13:\"ApertureValue\";s:3:\"6/1\";s:5:\"Flash\";i:1;s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'ofmkaqly8yv8ej5f60q1rq5v01bgmgc'),(2785,'Keloid-02.jpg','20041227050920!Keloid-02.jpg',273946,640,673,8,'keloid-02',83996,'Drgnu23','20041225051611','0','BITMAP','image','jpeg',0,'6hk2n0ifawf1xsvth2mva7ygqmbclhn'),(2786,'Apple.png','20041227100510!Apple.png',48928,360,192,8,'Apple absorbs all but red',91342,'Dkroll2','20041227100234','0','BITMAP','image','png',0,'ndrhsxysfbi7qeqi4m9girce2xdlej1'),(2787,'HockeyRink-Creases.png','20041227165445!HockeyRink-Creases.png',4937,355,169,8,'minor color change',6852,'Flamurai','20041226220229','0','BITMAP','image','png',0,'alp0dg4jdcaur74oin84ynuo36zumv2'),(2788,'Untagged-Images-Remaining.png','20041227185329!Untagged_Images_Remaining.png',2472,432,240,8,'26-Dec-2004 - 01:53 	17,188 w/ fixed labels on x axis',88976,'Kbh3rd','20041226023439','0','BITMAP','image','png',0,'gmk9j5pwdzlqopwu91c3mm5oa1m3k5v'),(2789,'Chicago-CFD-Logo.png','20041227220520!Chicago_CFD_Logo.png',177582,176,180,8,'Chicago Fire Department Logo',20171,'Gerard Czadowski','20041227171153','0','BITMAP','image','png',0,'6wwbinhiijr15l4ki9qfoueanaf25sd'),(2790,'DucdeChoiseul.jpg','20041227231828!DucdeChoiseul.jpg',20275,231,268,8,'',9079,'Black Widow','20030315050311','0','BITMAP','image','jpeg',0,'hr13aw5c99ftcuxuuk6vjfwu8cul5ne'),(2791,'Whangaparaoa-peninsula-evening.jpg','20041228041346!Whangaparaoa_peninsula_evening.jpg',143574,800,600,8,'Stanmore Bay, Whangaparaoa, NZ, in evening light',38463,'Bigal101','20041228040316','a:36:{s:4:\"Make\";s:9:\"Panasonic\";s:5:\"Model\";s:8:\"DMC-FZ10\";s:11:\"Orientation\";i:1;s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:7:\"Ver1.05\";s:8:\"DateTime\";s:19:\"2004:11:07 18:43:42\";s:16:\"YCbCrPositioning\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:4:\"0/10\";s:21:\"FocalLengthIn35mmFilm\";i:82;s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:20:\"SubjectDistanceRange\";i:3;s:12:\"ExposureTime\";s:6:\"10/800\";s:7:\"FNumber\";s:5:\"37/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:50;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:11:07 18:43:42\";s:17:\"DateTimeDigitized\";s:19:\"2004:11:07 18:43:42\";s:22:\"CompressedBitsPerPixel\";s:3:\"4/1\";s:17:\"ShutterSpeedValue\";s:9:\"6322/1000\";s:13:\"ApertureValue\";s:5:\"38/10\";s:17:\"ExposureBiasValue\";s:5:\"0/100\";s:16:\"MaxApertureValue\";s:5:\"30/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:1;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:6:\"137/10\";s:10:\"ColorSpace\";i:1;s:13:\"SensingMethod\";i:2;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'h64u53pnq43taj0q22rvh9y7a01m6hf'),(2792,'Untagged-Images-Remaining.png','20041228053456!Untagged_Images_Remaining.png',2475,432,240,8,'  27-Dec-2004 - 00:05   16,958',88976,'Kbh3rd','20041227185329','0','BITMAP','image','png',0,'5fzv41s07dv65952sopsg8yp3k8zswb'),(2793,'Ulcer-subungual-DM.jpg','20041228054519!Ulcer_subungual_DM.jpg',795330,1200,1600,8,'Subungual ulcer ',83996,'Drgnu23','20041227044316','a:19:{s:4:\"Make\";s:7:\"TOSHIBA\";s:5:\"Model\";s:7:\"PDR2300\";s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:4:\"1.01\";s:8:\"DateTime\";s:19:\"2004:12:13 11:08:53\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:4:\"1/30\";s:7:\"FNumber\";s:7:\"446/100\";s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:12:13 11:08:53\";s:17:\"DateTimeDigitized\";s:19:\"2004:12:13 11:08:53\";s:17:\"ShutterSpeedValue\";s:7:\"493/100\";s:13:\"ApertureValue\";s:3:\"4/1\";s:5:\"Flash\";i:1;s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'310rx8kssb07w6poamb37a1uevpn11e'),(2794,'Apollo17.jpg','20041228073233!Apollo17.jpg',10890,204,262,8,'Eugene Cernan on the Moon, with Earth in the sky',57730,'The Singing Badger','20040925210411','0','BITMAP','image','jpeg',0,'0pw68jrl1e6jojr0h3ovmpm2ftrgife'),(2795,'Chris-Horry.jpg','20041228173108!Chris_Horry.jpg',87613,597,400,8,'Chris Horry (User:Zerbey).  Photo by Kelly Horry.',62427,'Zerbey','20041017183705','a:14:{s:4:\"Make\";s:25:\"FUJI PHOTO FILM CO., LTD.\";s:5:\"Model\";s:7:\"SP-1500\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:12:\"720000/10000\";s:11:\"YResolution\";s:12:\"720000/10000\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:37:\"FDi V4.5 / FRONTIER350/370-5.8-0E-650\";s:8:\"DateTime\";s:19:\"2004:10:10 14:51:57\";s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"    :  :     :  :  \";s:17:\"DateTimeDigitized\";s:19:\"2004:10:10 14:51:57\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'iue0qdkepnnx525q1slttb7clg5yoim'),(2796,'IPA-dental-flap.png','20041228194216!IPA-dental_flap.png',277,20,30,8,'image of [[International Phonetic Alphabet]] symbol for [[dental flap]] {{GFDL}}',51129,'NohatBot','20041228194129','0','BITMAP','image','png',0,'k486tvhjf0enwibpmslmxx0ccrxijjf'),(2797,'IPA-dental-flap.png','20041228203132!IPA-dental_flap.png',277,20,30,8,'image of [[International Phonetic Alphabet]] symbol for [[dental flap]] {{GFDL}}',51129,'NohatBot','20041228194216','0','BITMAP','image','png',0,'k486tvhjf0enwibpmslmxx0ccrxijjf'),(2798,'IPA-dental-flap.png','20041228203338!IPA-dental_flap.png',277,20,30,8,'image of [[International Phonetic Alphabet]] symbol for [[dental flap]] {{GFDL}}',51129,'NohatBot','20041228203132','0','BITMAP','image','png',0,'k486tvhjf0enwibpmslmxx0ccrxijjf'),(2799,'Gemini-11-launch.jpg','20041229010953!Gemini_11_launch.jpg',39147,349,450,8,'Gemini 11 launch. (NASA)',38428,'Reubenbarton','20040831145204','0','BITMAP','image','jpeg',0,'rje0xxwsojn4j4e066drhfr5doo5qnv'),(2800,'Gemini-9A-launch.jpg','20041229011215!Gemini_9A_launch.jpg',23028,296,350,8,'Gemini 9A launch (NASA)',38428,'Reubenbarton','20040915151313','0','BITMAP','image','jpeg',0,'6x7dqiweks1e2m88oatkq8lf5lzre74'),(2801,'Untagged-Images-Remaining.png','20041229023407!Untagged_Images_Remaining.png',2482,432,240,8,'28-Dec-2004 - 00:17 	15,491',88976,'Kbh3rd','20041228053456','0','BITMAP','image','png',0,'dkzp5bq0nb2rrk1vcie73hfwnw424bs'),(2802,'Launch-Apollo4.jpg','20041229035232!Launch_Apollo4.jpg',148856,250,649,8,'Launch of Apollo 4',29293,'Enceladus','20031123041322','0','BITMAP','image','jpeg',0,'kmypshb635yafn7m3qjixvwxsi1uqga'),(2803,'Little-Joe-II-A-004.jpg','20041229035532!Little_Joe_II_A-004.jpg',27842,295,350,8,'Little Joe II A-004, White Sands, NM (NASA)',38428,'Reubenbarton','20040711160202','0','BITMAP','image','jpeg',0,'78tnvhhi94ddov510gxvhtjr2wo5a8d'),(2804,'Untagged-Images-Remaining---hourly.png','20041229070503!Untagged_Images_Remaining_-_hourly.png',2895,432,328,8,'Numbers from Wikipedia:Untagged_Images',88976,'Kbh3rd','20041229065435','0','BITMAP','image','png',0,'qp20n3v3vwsi7189jrwu2morsmc2qej'),(2805,'Fairy-shrimp.jpg','20041229085303!Fairy_shrimp.jpg',7521,159,124,8,'Fairy shrimp',35839,'Rsduhamel','20041229084652','0','BITMAP','image','jpeg',0,'89k71wm43fj2hjzmygnruxmae98851e'),(2806,'Lukasz-Opalinski-(1581-1654).jpg','20041229130815!Lukasz_Opalinski_(1581-1654).jpg',130605,680,1052,8,'{{pd}}',60647,'Emax','20041226160926','0','BITMAP','image','jpeg',0,'dbk5c81wdcf6opcutydyc2tstrpw92k'),(2807,'Constantine-pavlovich.jpg','20041229134059!Constantine_pavlovich.jpg',25942,201,288,8,'Grand Duke Constantine Pavlovich (1779-1831) {{PD}}',147410,'Ghirlandajo','20041229131419','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:12:29 16:10:05\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'7aba4nnl40jfcmj87xorkkkfwyujl3n'),(2808,'Untagged-Images-Remaining---hourly.png','20041229200528!Untagged_Images_Remaining_-_hourly.png',3042,432,328,8,'improved formatting',88976,'Kbh3rd','20041229070503','0','BITMAP','image','png',0,'r6e77eetib1tmdjivtpnmr01qlmr1xs'),(2809,'Blue-plate.jpg','20041229215310!Blue_plate.jpg',14109,286,143,8,'Typical sectional blue plate used for \"blue plate specials\", as used at the Red Arrow Diner in [[Manchester, New Hampshire]].',91287,'Kaszeta','20041229211136','0','BITMAP','image','jpeg',0,'q1qj5u2wpdlypceq8unvvltxhqu52yv'),(2810,'Blue-plate-special-sign.jpg','20041229215403!Blue_plate_special_sign.jpg',30347,250,336,8,'Typical \"blue plate special\" sign, from the Red Arrow Diner in [[Manchester, New Hampshire]].',91287,'Kaszeta','20041229211241','0','BITMAP','image','jpeg',0,'ttmne3z9q6fn1uozgmvt9nq6m8cs1kw'),(2811,'Journey\'sEndFilm.jpg','20041229222003!Journey\'sEndFilm.jpg',43342,240,179,8,'image of the actors in James Whales\' \'Journey\'s End\'',159706,'Emmashep','20041229221743','0','BITMAP','image','jpeg',0,'pggn3mtvojgy5f7musk6vqt3s4fahea'),(2812,'RationalYouth-Heredity.jpg','20041229224353!RationalYouth-Heredity.jpg',23928,225,220,8,'{{Albumcover}} Photographed from my own copy.',4687,'Awahlbom','20041228222522','a:33:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:19:\"Canon PowerShot A80\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:12:28 23:20:13\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:4:\"1/25\";s:7:\"FNumber\";s:5:\"35/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:12:28 23:41:27\";s:17:\"DateTimeDigitized\";s:19:\"2004:12:28 23:41:27\";s:22:\"CompressedBitsPerPixel\";s:3:\"3/1\";s:17:\"ShutterSpeedValue\";s:6:\"149/32\";s:13:\"ApertureValue\";s:6:\"116/32\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:6:\"116/32\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:6:\"435/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"2272000/280\";s:21:\"FocalPlaneYResolution\";s:11:\"1704000/210\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:1;s:12:\"WhiteBalance\";i:1;s:16:\"DigitalZoomRatio\";s:9:\"2272/2272\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'tegem98v0z6o1m3muht06urno4qkfqa'),(2813,'User-Fredrik.jpg','20041230005039!User_Fredrik.jpg',49405,321,531,8,'recent image',26675,'Fredrik','20040802164927','0','BITMAP','image','jpeg',0,'4nf3kqegmt1c9505hvb0xqtt5e7y0ny'),(2814,'Schizophonic.jpg','20041230064237!Schizophonic.jpg',6901,296,300,8,'Album cover of [[Geri Halliwell]]\'s \'\'[[Schizophonic]]\'\'. Source: [http://www.amazon.com/exec/obidos/tg/detail/-/B00000J8EM/qid=1104387192/sr=8-2/ref=sr_8_xs_ap_i1_xgl15/102-1917447-9776929?v=glance&s=music&n=507846]. {{albumcover}}',83184,'Vague Rant','20041230061844','0','BITMAP','image','jpeg',0,'5gytwzabr256icymheuaum6tbtfn05t'),(2815,'Schizophonic.jpg','20041230064643!Schizophonic.jpg',22025,300,300,8,'',83184,'Vague Rant','20041230064237','0','BITMAP','image','jpeg',0,'8cffxzrfjum7cfogmk3uhexnjzcbye2'),(2816,'Untagged-Images-Remaining---hourly.png','20041230071501!Untagged_Images_Remaining_-_hourly.png',3013,432,328,8,'Adjusted timescale to UTC; 14637 remaining',88976,'Kbh3rd','20041229200528','0','BITMAP','image','png',0,'3d599r5zaytsbo4p2md28pubutdwv9o'),(2817,'Untagged-Images-Remaining.png','20041230071921!Untagged_Images_Remaining.png',2487,432,240,8,'29-Dec-2004 - 00:01 	14,865',88976,'Kbh3rd','20041229023407','0','BITMAP','image','png',0,'92fs9bj7fxql1e4bcqj73nfqgjh3tst'),(2818,'Santiaguito-from-Santamaria.jpg','20041230111855!Santiaguito_from_Santamaria.jpg',29259,450,299,8,'From gallery.world-traveller.org, used with permission',93723,'Worldtraveller','20040821101646','0','BITMAP','image','jpeg',0,'f02huo80ba4slcimte4a2g814pollii'),(2819,'Kinuta-040329-088.jpg','20041230140240!Kinuta-040329-088.jpg',303107,1280,960,8,'Cherry blossoms in Kinuta Park, 2004',159977,'Maynard Hogg','20041230135843','a:34:{s:16:\"ImageDescription\";s:31:\"OLYMPUS DIGITAL CAMERA         \";s:4:\"Make\";s:23:\"OLYMPUS OPTICAL CO.,LTD\";s:5:\"Model\";s:6:\"C750UZ\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:7:\"v753-81\";s:8:\"DateTime\";s:19:\"2004:03:29 12:15:27\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/4000\";s:7:\"FNumber\";s:5:\"40/10\";s:15:\"ExposureProgram\";i:5;s:15:\"ISOSpeedRatings\";i:50;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:03:29 12:15:27\";s:17:\"DateTimeDigitized\";s:19:\"2004:03:29 12:15:27\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"30/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:5:\"63/10\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:5:\"0/100\";s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'je592hw82875jk59pcoxr6e748y3xc8'),(2820,'Pattonb.jpg','20041230161700!Pattonb.jpg',62279,1000,651,8,'{{PD}}',159238,'Trehan','20041230080504','0','BITMAP','image','jpeg',0,'oyb5txp2l76gpjsnan9amupq90jr6fi'),(2821,'FERHADIJARUSEVINE2.jpg','20041230165156!FERHADIJARUSEVINE2.jpg',120960,416,302,8,'Permission granted by www.ferhadija.com',136143,'Dado','20041230163822','0','BITMAP','image','jpeg',0,'hkp93gevpuwf3iis2ldfhz6luddqrkd'),(2822,'Relayer-fold-out-left.jpg','20041230200357!Relayer_fold_out_left.jpg',49598,477,556,8,'Painting by [[Roger Dean]] used in the left hand fold out of the [[Yes]] album \'\'[[Relayer]]\'\', [[1974]].{{fairuse}}',80654,'Justin Foote','20041230195730','0','BITMAP','image','jpeg',0,'dkhmvgcky8ti9p3c5ggupkbzdyqk0r5'),(2823,'Untagged-Images-Remaining---hourly.png','20041230203431!Untagged_Images_Remaining_-_hourly.png',3018,432,328,8,'14452 remaining at Thu December 30 07:12:29 2004',88976,'Kbh3rd','20041230071502','0','BITMAP','image','png',0,'fmh2snnnlqrfaw697xz49km15tv1irr'),(2824,'SA2-on-pad.jpg','20041230214643!SA2_on_pad.jpg',44479,342,451,8,'optimizing file size',3628,'Hephaestos','20031205013811','0','BITMAP','image','jpeg',0,'6g0klksb8i47j2lakcdpchywab4cpzo'),(2825,'Lens-Flare.jpg','20041231021203!Lens_Flare.jpg',21645,320,320,8,'Sample of lens flare',3857,'Ericd','20030319031915','0','BITMAP','image','jpeg',0,'7egjtqvdf93aeqqw4j64q2lpc6krx19'),(2826,'Surveyor-3-Conrad.jpeg','20041231023516!Surveyor_3_Conrad.jpeg',17440,397,324,8,'NASA photo of the Surveyor 3 probe, being visited by astronaut Conrad of Apollo 12 (visible in background)',66,'Bryan Derksen','20020903163100','0','BITMAP','image','jpeg',0,'1jf7n70mujxpzq3byf2ycrethb0i8hm'),(2827,'Champaign-From-Above.jpg','20041231045443!Champaign_From_Above.jpg',2301886,4927,3211,8,'A view of Champaign looking East from far above Neil & Green.',94128,'Capybara','20041231044705','0','BITMAP','image','jpeg',0,'qdkj03xdqr96qxxs6hq6f83yanwoz4d'),(2828,'PLL1.png','20041231070118!PLL1.png',4532,432,71,8,'Most basic diagram of a PLL.',35676,'Iain.mcclatchie','20041230073314','0','BITMAP','image','png',0,'3y3pr31bg5lwq2ehrwj58d2i181tnqr'),(2829,'Christmas-tree-in-taiwan-village.jpg','20041231083449!Christmas_tree_in_taiwan_village.jpg',84128,410,600,8,'Christmas tree in taiwan village',65827,'Jeremykemp','20041230201101','0','BITMAP','image','jpeg',0,'09bzykdvr68cmeafhxdpw825zwtoxt2'),(2830,'Marigold-bed-at-Green-Park-Wakamatsu.jpg','20041231092850!Marigold_bed_at_Green_Park_Wakamatsu.jpg',89095,640,480,8,'Multi-coloured marigolds at Green Park, Wakamatsu in November 2004.',135781,'Historian','20041231091906','a:24:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:9:\"CYBERSHOT\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:12:31 18:17:53\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:5:\"1/245\";s:7:\"FNumber\";s:5:\"40/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:11:13 16:00:34\";s:17:\"DateTimeDigitized\";s:19:\"2004:12:31 18:17:53\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:3:\"3/1\";s:12:\"MeteringMode\";i:2;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"69/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'d0rdcd6r0u38xwg0h28sc6lglet6n9r'),(2831,'IndiaTest.png','20041231115647!IndiaTest.png',219107,473,546,8,'Reverted to earlier revision',55862,'Kums','20041103091616','0','BITMAP','image','png',0,'a7brflmqo3lh3ebyrlgolmr8b2d5obi'),(2832,'Favalorosmallmb.jpg','20041231120108!Favalorosmallmb.jpg',14531,115,155,8,'',9351,'Lmb','20040206152345','0','BITMAP','image','jpeg',0,'ae6knzme0xhjc1qx256qhcy9tqrl7v4'),(2833,'Elizabeth-venus.jpg','20041231144724!Elizabeth_venus.jpg',22966,400,400,8,'Elizabeth Petrovna as Venus, painted when she was a child {{PD}}',147410,'Ghirlandajo','20041231143108','0','BITMAP','image','jpeg',0,'smof28am736r7gagemizxh14kwzamq3'),(2834,'Snowykeepsm.jpg','20041231172718!Snowykeepsm.jpg',24192,288,400,8,'Photo I took of the keep, Hedingham Castle, in Dec 1999 {{GFDL}}',160788,'Simondaw','20041231171320','0','BITMAP','image','jpeg',0,'1xmwvclpbct7y84brws6r05cfze3jdp'),(2835,'Taiwan-christmas-tree-bunun.jpg','20041231181807!Taiwan_christmas_tree_bunun.jpg',70253,403,600,8,'Taiwanese aboriginals, tutored by Christian missionaries, celebrate with trees outside their homes.',65827,'Jeremykemp','20041231085613','0','BITMAP','image','jpeg',0,'tid7k44ghvyd4eqmd0vld0nwkuud76h'),(2836,'Somalia-Factions.png','20041231191107!Somalia-Factions.png',24902,426,585,8,'This is a diagram of the factions in Somalia. All borders are disputed. See the respective articles for more information about the factions. Note: GIMPed from another Wikipedia image, assumed GNU FDL. {{GFDL}}',108279,'PeterSP','20041020234653','0','BITMAP','image','png',0,'iqb438j0av750y52agi10dtuij1arv1'),(2837,'Somalia-Factions.png','20041231191436!Somalia-Factions.png',26932,426,585,8,'Note: GIMPed from another Wikipedia image, assumed GNU FDL. {{GFDL}}) ',160870,'Kregor','20041231191107','0','BITMAP','image','png',0,'rbt9sivd5zwbq68n8123ea7c4spaka4'),(2838,'Somalia-Factions.png','20041231192033!Somalia-Factions.png',26932,426,585,8,'(This is a diagram of the factions in Somalia. All borders are disputed. See the respective articles for more information about the factions. Note: GIMPed from another Wikipedia image, assumed GNU FDL. {{GFDL}}) ',160870,'Kregor','20041231191436','0','BITMAP','image','png',0,'rbt9sivd5zwbq68n8123ea7c4spaka4'),(2839,'WCML-at-Rugby.jpg','20041231204659!WCML_at_Rugby.jpg',177676,800,452,8,'Photo by G-Man',8272,'G-Man','20041230201005','0','BITMAP','image','jpeg',0,'f0rxo2lqjfftarmmrgns9o4a6cgnbl4'),(2840,'Exclamation-icon.png','20041231222013!Exclamation_icon.png',436,24,24,8,'Exclamation icon',122756,'Keyser Söze','20041231220119','0','BITMAP','image','png',0,'hkwf6361aspjzv8qid38r35x36m1y0q'),(2841,'31-January-2004-Taipei101-Interior.jpg','20041231230857!31-January-2004-Taipei101-Interior.jpg',93586,640,480,8,'Interior of the Taipei 101 skyscraper.',53740,'PhiloVivero','20040328080027','a:25:{s:4:\"Make\";s:5:\"NIKON\";s:5:\"Model\";s:4:\"E995\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:8:\"E995v1.6\";s:8:\"DateTime\";s:19:\"2004:01:31 00:38:05\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/415\";s:7:\"FNumber\";s:5:\"26/10\";s:15:\"ExposureProgram\";i:3;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:01:31 00:38:05\";s:17:\"DateTimeDigitized\";s:19:\"2004:01:31 00:38:05\";s:22:\"CompressedBitsPerPixel\";s:3:\"4/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:4:\"0/10\";s:12:\"MeteringMode\";i:3;s:11:\"LightSource\";i:2;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"82/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'631849uhoeojizb9tjfpjvbtp8pha7s'),(2842,'Taipei-101-construction-2003-07.jpg','20041231230935!Taipei-101-construction-2003-07.jpg',55214,250,440,8,'Taipei 101, under construction 2003/07.  (taken by me)',9156,'Pratyeka','20031119063716','a:33:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:22:\"Canon DIGITAL IXUS 330\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:3:\"1/1\";s:11:\"YResolution\";s:3:\"1/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2003:11:19 14:31:59\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:5:\"1/200\";s:7:\"FNumber\";s:5:\"80/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2003:07:26 19:20:29\";s:17:\"DateTimeDigitized\";s:19:\"2003:07:26 19:20:29\";s:22:\"CompressedBitsPerPixel\";s:3:\"5/1\";s:17:\"ShutterSpeedValue\";s:6:\"245/32\";s:13:\"ApertureValue\";s:12:\"393216/65536\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:12:\"187820/65536\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:6:\"173/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"1600000/206\";s:21:\"FocalPlaneYResolution\";s:11:\"1200000/155\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:9:\"1600/1600\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'kf7p2voftx7eukb9y8b8wgyf2i1cfmu'),(2843,'Untagged-Images-Remaining---hourly.png','20041231231305!Untagged_Images_Remaining_-_hourly.png',2908,432,328,8,'14360 remaining at Thu Dec 30 20:01:00 2004',88976,'Kbh3rd','20041230203432','0','BITMAP','image','png',0,'o90vds7llb1qkke076fwl4ovbvn2agw'),(2844,'Rukai-chief.jpg','20041231232902!Rukai_chief.jpg',42300,512,768,8,'{{PD}}',106942,'Mababa','20041231232343','0','BITMAP','image','jpeg',0,'d014lbrdnn5cdypb9hibwogocklvz08'),(2845,'Somalia-Factions.png','20050101042623!Somalia-Factions.png',26932,426,585,8,'Reverted to earlier revision',0,'81.179.248.248','20041231192033','0','BITMAP','image','png',0,'rbt9sivd5zwbq68n8123ea7c4spaka4'),(2846,'AlphaHelix.jpg','20050101065946!AlphaHelix.jpg',30564,346,319,8,'{{PD-self}}',104525,'Jag123','20050101065633','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2005:01:01 01:59:23\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'axwzvshc161l9h1j83lonug353q5y1u'),(2847,'AlphaHelix.jpg','20050101070403!AlphaHelix.jpg',19167,127,156,8,'{{PD-self}}',104525,'Jag123','20050101065946','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2005:01:01 02:02:43\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'qtz8e64reqtk65chg7jthsz7lo0igm0'),(2848,'AlphaHelix.jpg','20050101071054!AlphaHelix.jpg',20275,189,197,8,'',104525,'Jag123','20050101070403','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2005:01:01 02:06:40\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'35hnmo2cs11rzslkj8gev46m5bzfz14'),(2849,'AlphaHelix.jpg','20050101072113!AlphaHelix.jpg',16124,192,104,8,'',104525,'Jag123','20050101071054','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2005:01:01 02:13:23\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'e7p5ll2o0u5dm6yy7jow78hdt5qs6t4'),(2850,'Untagged-Images-Remaining---hourly.png','20050101084335!Untagged_Images_Remaining_-_hourly.png',2927,432,328,8,'13191 remaining at Fri Dec 31 23:01:01 2004',88976,'Kbh3rd','20041231231305','0','BITMAP','image','png',0,'hmeotvjjiouooipyrn5i2l12tc4xjy5'),(2851,'Dred-Scott.jpg','20050101130638!Dred_Scott.jpg',82729,350,427,8,'',21013,'Raul654','20041015073835','0','BITMAP','image','jpeg',0,'p99eb4huovdu2cdk8ecei4ypljdmksf'),(2852,'Untagged-Images-Remaining---hourly.png','20050101173401!Untagged_Images_Remaining_-_hourly.png',3078,432,328,8,'12818 remaining at Sat Jan  1 08:43:02 2005',88976,'Kbh3rd','20050101084335','0','BITMAP','image','png',0,'eyrzvq6q8r4owruphskqhrudnictbjz'),(2853,'Canfourcornermap.png','20050101203846!Canfourcornermap.png',14396,330,364,8,'',47960,'Guanaco','20050101202857','0','BITMAP','image','png',0,'pumec5ikjisi5krmxn5p9bt2le51otu'),(2854,'Usinprogress.PNG','20050101214620!Usinprogress.PNG',34477,280,183,8,'update',35314,'Seth Ilys','20041218173743','0','BITMAP','image','png',0,'m6s21tr2hw5nkrbwegwrov5a51bkbda'),(2855,'English-dialects.png','20050101223021!English_dialects.png',9026,413,296,8,'Replacement for English_types.png',84047,'AxSkov','20041223055516','0','BITMAP','image','png',0,'7zin3o1oe1ze2yfuoyl2v47sbj2xrw9'),(2856,'Uni-Bergen-emblem.png','20050102010016!Uni-Bergen-emblem.png',1722,425,417,8,'Emblem of the [[University of Bergen]], [[Norway]]. {{Fairuse}}',87321,'Uppland','20050102005716','0','BITMAP','image','png',0,'cjqvp51gcalainugmhnd1vhdnkis09h'),(2857,'Uni-Bergen-emblem.png','20050102010158!Uni-Bergen-emblem.png',1722,425,417,8,'',87321,'Uppland','20050102010018','0','BITMAP','image','png',0,'cjqvp51gcalainugmhnd1vhdnkis09h'),(2858,'Jetsons.jpg','20050102014914!Jetsons.jpg',12898,212,226,8,'Picture of The Jetsons family',74041,'The stuart','20041227151650','0','BITMAP','image','jpeg',0,'33pxsg719sxew850sgs0ln2sm8cqzmb'),(2859,'Charlescalvert5th.jpg','20050102035311!Charlescalvert5th.jpg',19502,221,400,8,'Charles Calvert, fifth lord baltimore',56563,'Formeruser-81','20040807193439','0','BITMAP','image','jpeg',0,'i9ebhmy2p2tlmudkttwwv79sr0b3675'),(2860,'Charlescalvert-800.jpg','20050102041311!Charlescalvert_800.jpg',69901,457,800,8,'3rd Lord Baltimore',56563,'Formeruser-81','20040807184524','0','BITMAP','image','jpeg',0,'c9q5sn209ndbciadj5v17rxig6zjc9b'),(2861,'Agustin-Eyzaguirre.jpg','20050102051912!Agustin_Eyzaguirre.jpg',184592,674,794,8,'Agustin Eyzaguirre - President of Chile',122225,'Melromero','20050102050852','0','BITMAP','image','jpeg',0,'b8bi2cslczrwkcdxnp8uz8pexpue6ez'),(2862,'Ramon-freire.jpg','20050102153302!Ramon_freire.jpg',14022,192,272,8,'Ramon Freire - President of Chile',122225,'Melromero','20050102140708','0','BITMAP','image','jpeg',0,'jkaar21qlydpkeimlfahkf4j8fwpgmk'),(2863,'Voll-Honig.JPG','20050102162614!Voll_Honig.JPG',137076,800,600,8,'Honey in capped cells on frame',142549,'Shoefly','20041209040458','a:18:{s:4:\"Make\";s:7:\"TOSHIBA\";s:5:\"Model\";s:7:\"PDR2300\";s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:4:\"1.00\";s:8:\"DateTime\";s:19:\"2004:07:30 09:59:34\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:4:\"1/30\";s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:07:30 09:59:34\";s:17:\"DateTimeDigitized\";s:19:\"2004:07:30 09:59:34\";s:17:\"ShutterSpeedValue\";s:7:\"493/100\";s:13:\"ApertureValue\";s:4:\"0/10\";s:5:\"Flash\";i:1;s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'dl3gnmsjgludd5w3iolf4e4z4qgxv7p'),(2864,'Voll-Honig.JPG','20050102162818!Voll_Honig.JPG',137076,800,600,8,'A capped frame of honey comb',142549,'Shoefly','20050102162614','a:18:{s:4:\"Make\";s:7:\"TOSHIBA\";s:5:\"Model\";s:7:\"PDR2300\";s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:4:\"1.00\";s:8:\"DateTime\";s:19:\"2004:07:30 09:59:34\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:4:\"1/30\";s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:07:30 09:59:34\";s:17:\"DateTimeDigitized\";s:19:\"2004:07:30 09:59:34\";s:17:\"ShutterSpeedValue\";s:7:\"493/100\";s:13:\"ApertureValue\";s:4:\"0/10\";s:5:\"Flash\";i:1;s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'dl3gnmsjgludd5w3iolf4e4z4qgxv7p'),(2865,'Itaipu.jpg','20050102172524!Itaipu.jpg',61199,640,480,8,'my photo of Itaipu',38,'Chuck Smith','20020811175532','a:24:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:9:\"CYBERSHOT\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2002:07:28 08:51:31\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:5:\"1/201\";s:7:\"FNumber\";s:5:\"28/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2002:07:28 08:51:31\";s:17:\"DateTimeDigitized\";s:19:\"2002:07:28 08:51:31\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:3:\"3/1\";s:12:\"MeteringMode\";i:2;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"80/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'7l7xsvj6le2lijvnwhuijr1cwocem7l'),(2866,'Untagged-Images-Remaining---hourly.png','20050102175004!Untagged_Images_Remaining_-_hourly.png',3084,432,328,8,'12633 remaining at Sat January 1 17:32:29 2005',88976,'Kbh3rd','20050101173401','0','BITMAP','image','png',0,'no89v3xe49zd1nl63m0x7wx52gyntu4'),(2867,'N-Water-03-02.jpg','20050102175759!N_Water_03_02.jpg',97108,640,470,8,'Photo of the North American Common Water Snake.',50585,'Jkarp','20050102174803','0','BITMAP','image','jpeg',0,'04ojwtvu52oz4iwi99a3xyx8e710q6f'),(2868,'Whiteboard.JPG','20050102185733!Whiteboard.JPG',47308,406,547,8,'I took this photograph of a whiteboard myself on an Olympus C-60 Zoom digital camera, and I reduced the size in Microsoft Photo Editor {{PD-link}}',153938,'TheNewAuk','20050102182832','0','BITMAP','image','jpeg',0,'m60817z886wp3626leoox0l9a2bs3et'),(2869,'Voll-Honig.JPG','20050102210457!Voll_Honig.JPG',137076,800,600,8,'Reverted to earlier revision',142549,'Shoefly','20050102162822','a:18:{s:4:\"Make\";s:7:\"TOSHIBA\";s:5:\"Model\";s:7:\"PDR2300\";s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:4:\"1.00\";s:8:\"DateTime\";s:19:\"2004:07:30 09:59:34\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:4:\"1/30\";s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:07:30 09:59:34\";s:17:\"DateTimeDigitized\";s:19:\"2004:07:30 09:59:34\";s:17:\"ShutterSpeedValue\";s:7:\"493/100\";s:13:\"ApertureValue\";s:4:\"0/10\";s:5:\"Flash\";i:1;s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'dl3gnmsjgludd5w3iolf4e4z4qgxv7p'),(2870,'Mdm-1-fox.jpg','20050102222908!Mdm-1-fox.jpg',43100,600,450,8,'MDM-1 Fox SP-3623 at Rybnik Aeroclub',162159,'Mortenp','20050102222048','a:32:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:21:\"Canon DIGITAL IXUS v2\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:07:26 14:12:16\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:5:\"1/640\";s:7:\"FNumber\";s:5:\"71/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:07:26 14:12:16\";s:17:\"DateTimeDigitized\";s:19:\"2004:07:26 14:12:16\";s:22:\"CompressedBitsPerPixel\";s:3:\"3/1\";s:17:\"ShutterSpeedValue\";s:6:\"298/32\";s:13:\"ApertureValue\";s:12:\"370648/65536\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:12:\"194698/65536\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:6:\"173/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"1600000/206\";s:21:\"FocalPlaneYResolution\";s:11:\"1200000/155\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:9:\"1600/1600\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'n6ovgbm9ea9lc11jt5it16ug93oxga5'),(2871,'Pohang-logo.jpg','20050102233937!Pohang_logo.jpg',3334,131,105,8,'{{logo}}Official logo of Pohang City, South Korea. Retrieved January 2, 2005 from city government website. [http://eng.ipohang.org/city/images/phmark.jpg]',123395,'Visviva','20050102233527','0','BITMAP','image','jpeg',0,'308w2wutl8e1yw8nob8t9nbou6w2kxm'),(2872,'P1020097.JPG','20050103010523!P1020097.JPG',968315,2560,1920,8,'photo of landmark church in Ironbound, Newark.  Taken for wikipedia.  1/2/2005 {{GFDL}}',16822,'Dinopup','20050102224802','a:33:{s:16:\"ImageDescription\";s:31:\"OLYMPUS DIGITAL CAMERA         \";s:4:\"Make\";s:23:\"OLYMPUS CORPORATION    \";s:5:\"Model\";s:16:\"C-5000Z         \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"144/1\";s:11:\"YResolution\";s:5:\"144/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:31:\"Version 1.0                    \";s:8:\"DateTime\";s:19:\"2005:01:02 13:25:29\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:5:\"1/400\";s:7:\"FNumber\";s:5:\"28/10\";s:15:\"ExposureProgram\";i:5;s:15:\"ISOSpeedRatings\";i:50;s:11:\"ExifVersion\";s:4:\"0221\";s:16:\"DateTimeOriginal\";s:19:\"2005:01:02 13:25:29\";s:17:\"DateTimeDigitized\";s:19:\"2005:01:02 13:25:29\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:7:\"300/100\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:25;s:11:\"FocalLength\";s:7:\"780/100\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:7:\"100/100\";s:16:\"SceneCaptureType\";i:2;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'agddse8mnd6zfs0561o0lupxizkgypl'),(2873,'American-Friends-Service-Committee-logo.png','20050103025907!American_Friends_Service_Committee_logo.png',14568,123,112,8,'{{fairuse}}',68411,'Neutrality','20040925063837','0','BITMAP','image','png',0,'jo3ac57letmn0tmr0py1n8qvewimvv3'),(2874,'Untagged-Images-Remaining---hourly.png','20050103065107!Untagged_Images_Remaining_-_hourly.png',3086,432,328,8,'12497 remaining at Sun January 2 05:01:01 2005',88976,'Kbh3rd','20050102175004','0','BITMAP','image','png',0,'p36rupx0tekh40v1lqczc2ot54i51u0'),(2875,'Races-of-Bees.png','20050103084155!Races_of_Bees.png',93383,1370,697,4,'This map is here only as a model for what might be done, and for the sake of facilitating discussion. It is not at all accurate, just a \"mock up',16559,'Patrick0Moran','20050102034825','0','BITMAP','image','png',0,'lxzfsutmrgg14akvgcj8lpcj6erued4'),(2876,'Airolo-winter.jpg','20050103143200!Airolo_winter.jpg',20424,133,100,8,'Airolo',74856,'Corti','20041029163307','a:22:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:9:\"CYBERSHOT\";s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2003:12:27 10:42:49\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:6:\"5/1000\";s:7:\"FNumber\";s:5:\"56/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2003:12:27 10:42:49\";s:17:\"DateTimeDigitized\";s:19:\"2003:12:27 10:42:49\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:3:\"3/1\";s:12:\"MeteringMode\";i:2;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:3:\"8/1\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'fxejfv4e4afb0pbm7b6v4cz8gsqwdbh'),(2877,'2004-Indian-Ocean-Earthquake-relief1.jpg','20050103182207!2004_Indian_Ocean_Earthquake_relief1.jpg',194294,1000,1400,8,'U.S. Navy photo',7279,'Minesweeper','20050103001450','0','BITMAP','image','jpeg',0,'68mri1a8ryi5gol87puu5xgfps4tn0f'),(2878,'South-Moor-Park,-Co.-Durham.jpg','20050103195820!South_Moor_Park,_Co._Durham.jpg',213109,1024,645,8,'image created by John-Paul Stephenson on Jan 3rd 2005',158361,'The JPS','20050103150826','a:33:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:18:\"Canon PowerShot G5\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2005:01:03 15:04:32\";s:16:\"YCbCrPositioning\";i:1;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:12:\"ExposureTime\";s:4:\"1/50\";s:7:\"FNumber\";s:5:\"22/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2005:01:03 14:10:36\";s:17:\"DateTimeDigitized\";s:19:\"2005:01:03 14:10:36\";s:22:\"CompressedBitsPerPixel\";s:3:\"3/1\";s:17:\"ShutterSpeedValue\";s:6:\"181/32\";s:13:\"ApertureValue\";s:5:\"73/32\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:5:\"64/32\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:6:\"230/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"1024000/283\";s:21:\"FocalPlaneYResolution\";s:10:\"768000/212\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:9:\"2592/2592\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'bm6i3fymljjx99xyrjhkj3b2pa5izjf'),(2879,'Philip-Fry.png','20050103222856!Philip_Fry.png',9800,303,404,8,'Philip J. Fry. (General publicity shot)',122756,'Keyser Söze','20041024232711','0','BITMAP','image','png',0,'khixerevq2qkg44cor6m46he9hfgnre'),(2880,'Philip-Fry.png','20050104005450!Philip_Fry.png',23194,300,393,8,'',122756,'Keyser Söze','20050103222857','0','BITMAP','image','png',0,'tht4biw46fkrcp500nu5r26qxwolj24'),(2881,'Alexa-reach-measurement-for-wikipedia-logscale.png','20050104045400!Alexa_reach_measurement_for_wikipedia-logscale.png',3066,480,328,8,'thru Nov. 2004',88976,'Kbh3rd','20041207030059','0','BITMAP','image','png',0,'q06wozf67lqbm615fmocud63vuedind'),(2882,'Alexa-reach-measurement-for-wikipedia.png','20050104045436!Alexa_reach_measurement_for_wikipedia.png',3227,480,328,8,'thru Nov. 2004',88976,'Kbh3rd','20041207030121','0','BITMAP','image','png',0,'5oq2urmb46i6iej6m8cdx6ntxsj2pt1'),(2883,'Alexa-traffic-ranking-for-wikipedia.png','20050104045518!Alexa_traffic_ranking_for_wikipedia.png',2472,432,240,8,'thru Nov. 2004',88976,'Kbh3rd','20041207030141','0','BITMAP','image','png',0,'1gqg0bddcfg8wydmndv36274l2uchz7'),(2884,'Untagged-Images-Remaining---hourly.png','20050104053824!Untagged_Images_Remaining_-_hourly.png',3086,432,328,8,'12233 remaining at Mon January 3 06:01:01 2005',88976,'Kbh3rd','20050103065108','0','BITMAP','image','png',0,'dh5lzthh9gp8rz8yh1ryeqn9vly2gvj'),(2885,'HMCoSecondEdHobbits.jpg','20050104073930!HMCoSecondEdHobbits.jpg',292439,1440,982,8,'A line-up of the American second edition printings of The Hobbit',8183,'Strebe','20040830065237','a:29:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:19:\"Canon PowerShot S10\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2004:08:29 23:37:10\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:4:\"1/15\";s:7:\"FNumber\";s:5:\"50/10\";s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:08:29 23:02:34\";s:17:\"DateTimeDigitized\";s:19:\"2004:08:29 23:02:34\";s:22:\"CompressedBitsPerPixel\";s:3:\"3/1\";s:17:\"ShutterSpeedValue\";s:12:\"256042/65536\";s:13:\"ApertureValue\";s:12:\"304340/65536\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:5:\"28/10\";s:15:\"SubjectDistance\";s:8:\"552/1000\";s:12:\"MeteringMode\";i:2;s:5:\"Flash\";i:1;s:11:\"FocalLength\";s:6:\"403/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"1600000/246\";s:21:\"FocalPlaneYResolution\";s:11:\"1200000/184\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'phwde5kidcmyhkj7xaa2r6b5uq6tzsh'),(2886,'HMCoSecondEdHobbits.jpg','20050104074509!HMCoSecondEdHobbits.jpg',173230,1124,757,8,'A line-up of the American second edition printings of The Hobbit',8183,'Strebe','20050104073930','a:29:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:19:\"Canon PowerShot S10\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:28:\"Adobe Photoshop CS Macintosh\";s:8:\"DateTime\";s:19:\"2005:01:03 23:32:45\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:4:\"1/15\";s:7:\"FNumber\";s:5:\"40/10\";s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2005:01:03 23:00:33\";s:17:\"DateTimeDigitized\";s:19:\"2005:01:03 23:00:33\";s:22:\"CompressedBitsPerPixel\";s:3:\"3/1\";s:17:\"ShutterSpeedValue\";s:12:\"256042/65536\";s:13:\"ApertureValue\";s:12:\"262144/65536\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:5:\"28/10\";s:15:\"SubjectDistance\";s:8:\"953/1000\";s:12:\"MeteringMode\";i:2;s:5:\"Flash\";i:1;s:11:\"FocalLength\";s:6:\"403/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"1600000/246\";s:21:\"FocalPlaneYResolution\";s:11:\"1200000/184\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'7t0lld64h09efdfkz5wgcpk994cb0ii'),(2887,'Recovery-from-cults-book-cover-AFF.jpg','20050104230552!Recovery_from_cults_book_cover_AFF.jpg',11491,125,187,8,'Book cover (fair use)',39099,'Andries','20041226112510','0','BITMAP','image','jpeg',0,'8kse8qlymw8m6qfrzif7qz24vh9i82r'),(2888,'Untagged-Images-Remaining---hourly.png','20050105031149!Untagged_Images_Remaining_-_hourly.png',3092,432,328,8,'12124 remaining at Tue Jan  4 05:01:02 2005',88976,'Kbh3rd','20050104053824','0','BITMAP','image','png',0,'sednkoo76rcqgyxsred2lneqhdp1pbv'),(2889,'HMCoSecondEdHobbits.jpg','20050105064911!HMCoSecondEdHobbits.jpg',173230,1124,757,8,'A line-up of the American second edition printings of The Hobbit',8183,'Strebe','20050104074510','a:29:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:19:\"Canon PowerShot S10\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:28:\"Adobe Photoshop CS Macintosh\";s:8:\"DateTime\";s:19:\"2005:01:03 23:32:45\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:4:\"1/15\";s:7:\"FNumber\";s:5:\"40/10\";s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2005:01:03 23:00:33\";s:17:\"DateTimeDigitized\";s:19:\"2005:01:03 23:00:33\";s:22:\"CompressedBitsPerPixel\";s:3:\"3/1\";s:17:\"ShutterSpeedValue\";s:12:\"256042/65536\";s:13:\"ApertureValue\";s:12:\"262144/65536\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:5:\"28/10\";s:15:\"SubjectDistance\";s:8:\"953/1000\";s:12:\"MeteringMode\";i:2;s:5:\"Flash\";i:1;s:11:\"FocalLength\";s:6:\"403/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"1600000/246\";s:21:\"FocalPlaneYResolution\";s:11:\"1200000/184\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'7t0lld64h09efdfkz5wgcpk994cb0ii'),(2890,'Uralic-Yukaghir.png','20050105144525!Uralic-Yukaghir.png',30237,406,226,8,'{{GFDL}}, drawn after Ruhlen, Merritt, A Guide to the World\'s languages, Stanford, California (1987), p. 64',86857,'Dbachmann','20050105143029','0','BITMAP','image','png',0,'bfv1d53vg3ubir4lewupfrzyphh8jru'),(2891,'Basiccandlesticks.GIF','20050105174528!Basiccandlesticks.GIF',2523,46,485,8,'Basic Candlesticks',128575,'Felixpeters','20050105163901','0','BITMAP','image','gif',0,'1n8onfh4ecnrij0bsnb6r6mo9g57ct9'),(2892,'Rupert-Brooke-statue.jpg','20050105184125!Rupert_Brooke_statue.jpg',125353,300,725,8,'my own photo',8272,'G-Man','20050104200423','a:25:{s:16:\"ImageDescription\";s:8:\"KF2-2002\";s:4:\"Make\";s:7:\"KONICA \";s:5:\"Model\";s:12:\"KONICA KD-20\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:11:21 05:47:39\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:4:\"1/32\";s:7:\"FNumber\";s:3:\"7/2\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:11:21 05:47:39\";s:17:\"DateTimeDigitized\";s:19:\"2004:11:21 05:47:39\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:5:\"88/10\";s:16:\"MaxApertureValue\";s:3:\"7/2\";s:12:\"MeteringMode\";i:2;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:1;s:11:\"FocalLength\";s:5:\"56/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'ss5ns7nngzor33oz2uey5nqj9wytdpb'),(2893,'Untagged-Images---percent-done.png','20050105191913!Untagged_Images_-_percent_done.png',2967,432,328,8,'[[Wikipedia:Untagged Images]] percent done {{GFDL}}',88976,'Kbh3rd','20050105185519','0','BITMAP','image','png',0,'hc6wfbrgr5328uwq4ok7hnpl384tpbj'),(2894,'Untagged-Images---percent-done.png','20050105192533!Untagged_Images_-_percent_done.png',2967,432,328,8,'Fixed y-axis label. 11229 remaining at Wed January 5 19:01:00 2005',88976,'Kbh3rd','20050105191914','0','BITMAP','image','png',0,'hc6wfbrgr5328uwq4ok7hnpl384tpbj'),(2895,'Zelda-II-The-Adventure-of-Link-box.jpg','20050106023912!Zelda_II_The_Adventure_of_Link_box.jpg',242604,700,981,8,'{{Gamecover}}',18500,'ZeWrestler','20050106023643','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"100/1\";s:11:\"YResolution\";s:5:\"100/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2005:01:05 21:38:58\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'i7qpvy4mhguofesyvj87ur31ank3hmj'),(2896,'Zelda-II-The-Adventure-of-Link-box.jpg','20050106024307!Zelda_II_The_Adventure_of_Link_box.jpg',117694,350,491,8,'{{Gamecover}}',18500,'ZeWrestler','20050106023912','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"100/1\";s:11:\"YResolution\";s:5:\"100/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2005:01:05 21:41:37\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'fr3kx6izat3268shnm3depiyyqvl47c'),(2897,'Centraltv-90logo.jpg','20050106073936!Centraltv-90logo.jpg',8558,252,189,8,'Central Independent Television early 1990s logo',7891,'Arwel Parry','20030527001008','0','BITMAP','image','jpeg',0,'36dvgn2k7anew4sw176e44x9gsrneyz'),(2898,'Ci-map.png','20050106074913!Ci-map.png',16392,342,730,4,'Map of [[Chile]] from [http://www.lib.utexas.edu/maps/cia02/chile_sm02.gif CIA World Factbook].',17226,'Grendelkhan','20040523210009','0','BITMAP','image','png',0,'j747xhp227latl6k5lj6knwwg1vvpvb'),(2899,'Ci-map.png','20050106075115!Ci-map.png',20937,325,709,8,'',46083,'Cantus','20050106074913','0','BITMAP','image','png',0,'elnwifingdpezj4x5xwzcy2kr01k55q'),(2900,'Alexander-James-Begg.jpg','20050106091943!Alexander_James_Begg.jpg',34634,576,432,8,'me, December 1, 2004',96850,'AlexTheMartian','20041203134352','0','BITMAP','image','jpeg',0,'656sunjt89su3emt8gkm1b6hdeclfks'),(2901,'Uralic-Yukaghir.png','20050106105512!Uralic-Yukaghir.png',30906,406,226,8,'update',86857,'Dbachmann','20050105144525','0','BITMAP','image','png',0,'cc3amn5yq4kris421jkr2zqc6ykxd7b'),(2902,'Untagged-Images---percent-done.png','20050106184529!Untagged_Images_-_percent_done.png',2978,432,328,8,'Oops, really fix y-axis label. :-P',88976,'Kbh3rd','20050105192534','0','BITMAP','image','png',0,'13agpybcp71m1gci76bziyfw8uo6m37'),(2903,'Ignacy-Domeyko.jpg','20050106193944!Ignacy_Domeyko.jpg',78951,270,379,8,'{{pd}}',60647,'Emax','20050106193840','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"75/1\";s:11:\"YResolution\";s:4:\"75/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:8:\"DateTime\";s:19:\"2005:01:06 20:36:12\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'hlfuy61aew3afzqpd1g7t6c86xmujoa'),(2904,'Livejournal-logo.png','20050106215114!Livejournal-logo.png',178622,250,178,8,'[[LiveJournal]] logo, {{logo}}',51957,'Christopherlin','20050106201021','0','BITMAP','image','png',0,'dgsohcgv8ou4lzs07vk0beq275t3oc1'),(2905,'Untagged-Images---percent-done.png','20050107045314!Untagged_Images_-_percent_done.png',2991,432,328,8,'9662 remaining at Thu January 6 18:00:59 2005',88976,'Kbh3rd','20050106184529','0','BITMAP','image','png',0,'fq932e2dqpak3tmpm6u9g1dt92woccm'),(2906,'Shefa-Tal.png','20050107052023!Shefa_Tal.png',45726,450,381,8,'Shefa Tal, Hanau, 1612. Hebraic Section, Library of Congress',84928,'Zappaz','20050107045809','0','BITMAP','image','png',0,'pw9hu4f7p2tqjgybin2qp38uv9yr1n8'),(2907,'Huygens\'-distance-from-Titan.png','20050107081424!Huygens\'_distance_from_Titan.png',16817,512,460,8,'Huygens\' distance from Titan',50800,'Python eggs','20050103052511','0','BITMAP','image','png',0,'a3du45fmtb75lfb2pofbp3wz8kl12mq'),(2908,'Africastubmap.png','20050107173603!Africastubmap.png',2464,230,296,8,'Africa outline for use with Africa-geo-stub',117878,'Grutness','20050107013130','0','BITMAP','image','png',0,'26u8rcvukgih37td78ys6z9eahg5tyi'),(2909,'Angamos.jpg','20050107200225!Angamos.jpg',25379,425,268,8,'Naval Combat of Angamos',131526,'Messhermit','20041214025338','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2003:07:14 23:33:45\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'3be7qxmpksfvgsw4uk2v2xyr7drxp2m'),(2910,'Brindleyplace-Birmingham.jpg','20050107233451!Brindleyplace_Birmingham.jpg',187473,800,465,8,'Photo by G-Man',8272,'G-Man','20041231195923','a:25:{s:16:\"ImageDescription\";s:8:\"KF2-2002\";s:4:\"Make\";s:7:\"KONICA \";s:5:\"Model\";s:12:\"KONICA KD-20\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2003:11:26 11:06:39\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:5:\"1/128\";s:7:\"FNumber\";s:3:\"7/2\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2003:11:26 11:06:39\";s:17:\"DateTimeDigitized\";s:19:\"2003:11:26 11:06:39\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:6:\"115/10\";s:16:\"MaxApertureValue\";s:3:\"7/2\";s:12:\"MeteringMode\";i:2;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"56/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'1u0sbkasw77pntuz7jizagw5j8ukjxl'),(2911,'Halilocation.JPG','20050108003619!Halilocation.JPG',18531,513,204,8,'Halifax municipality and urban area location',136489,'Alexk001','20050108003226','0','BITMAP','image','jpeg',0,'juqklhjibyfsryqiebfw2ho4adukr7d'),(2912,'1972-federal-german-result.png','20050108015345!1972_federal_german_result.png',5194,527,302,8,'German election results seat chart<br>SDP in red, Green in green, PDS in pink, FDP in black, CDU/CSU in blue<br>made by me<br>{{PD}}',69381,'Willhsmit','20050105233128','0','BITMAP','image','png',0,'gwf9u9tq7doa4y3qup2yavwx98vfdjv'),(2913,'Neopets-homepage.png','20050108033156!Neopets-homepage.png',170861,800,600,8,'Screenshot of the Neopets homepage {{screenshot}}',123228,'Somebody in the WWW','20050108031441','0','BITMAP','image','png',0,'qiw0j59fcf9u9z9r1pblholt8p6s010'),(2914,'Uruguaiana-in-Brazil.png','20050108034414!Uruguaiana_in_Brazil.png',4486,300,310,8,'Urugaiana in Brazil',41208,'Herr Klugbeisser','20040528134426','0','BITMAP','image','png',0,'f2dzzgd8kxqt9yq8kiuepodg14j2ncw'),(2915,'Untagged-Images---percent-done.png','20050108050638!Untagged_Images_-_percent_done.png',3002,432,328,8,'81.1%: 9171 remaining at Fri January 7 04:46:40 2005',88976,'Kbh3rd','20050107045315','0','BITMAP','image','png',0,'c4dx6ybxhjwkmn3w5ebiffq3vgl7t6x'),(2916,'Untagged-Images-Remaining.png','20050108052115!Untagged_Images_Remaining.png',2491,432,240,8,'29-Dec-2004 - 00:01 	14,865\n30-Dec-2004 - 00:30 	14,497',88976,'Kbh3rd','20041230071921','0','BITMAP','image','png',0,'g6thwp12ilix6hrr4q0pizoy9dirtw5'),(2917,'Untagged-Images-Remaining---hourly.png','20050108052136!Untagged_Images_Remaining_-_hourly.png',3102,432,328,8,'11631 remaining at Wed January 5 03:01:00 2005',88976,'Kbh3rd','20050105031149','0','BITMAP','image','png',0,'3nops9brwunfbkspniujk8o7vo0muim'),(2918,'Elridgevillmap.png','20050108065711!Elridgevillmap.png',21929,210,360,8,'Map of Eldridge, Belize (based on that by [[User:Lucas Arzu]] {{PD}}',117878,'Grutness','20050108065339','0','BITMAP','image','png',0,'hytg3128eso5vramvf3lmtn5a1jhvaz'),(2919,'GermanAutobahn.jpg','20050109002234!GermanAutobahn.jpg',123071,640,480,8,'{{GFDL}} German A7 Autobahn. DF08 2004 image.',75080,'DF08','20040818200549','a:26:{s:4:\"Make\";s:6:\"CAMERA\";s:5:\"Model\";s:7:\"3MP-9F6\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:13:\"4718592/65536\";s:11:\"YResolution\";s:13:\"4718592/65536\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"QuickTime 6.5.1\";s:8:\"DateTime\";s:19:\"2004:08:18 17:31:07\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:5:\"1/250\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:08:14 19:32:08\";s:17:\"DateTimeDigitized\";s:19:\"2004:08:14 19:32:08\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ShutterSpeedValue\";s:3:\"8/1\";s:13:\"ApertureValue\";s:3:\"3/1\";s:17:\"ExposureBiasValue\";s:3:\"0/2\";s:16:\"MaxApertureValue\";s:3:\"3/1\";s:12:\"MeteringMode\";i:2;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:7:\"996/100\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'j1n8xzmw881ywnqnkm9z0bm0e1nylal'),(2920,'LambertCosineLaw2.png','20050109014531!LambertCosineLaw2.png',16534,410,240,8,'Lambert cosine law figure 2',131603,'PAR','20050107165301','0','BITMAP','image','png',0,'6bcz3civfxjtl0wdu7qhmkak7ykckty'),(2921,'Taiwan-100-nt.jpg','20050109074033!Taiwan_100_nt.jpg',59335,600,233,8,'Taiwan 100NT note with portrait of Sun Yat Sen.',65827,'Jeremykemp','20041231084601','0','BITMAP','image','jpeg',0,'8e071q7zytdox74v86mxaidgpv9e6vo'),(2922,'Bull-leaping.jpg','20050109131603!Bull-leaping.jpg',140473,640,417,8,'{{PD-art}}',26468,'ChrisO','20050109131056','0','BITMAP','image','jpeg',0,'0vvhsuwv1nwjedies552dinc26muezl'),(2923,'Untagged-Images---percent-done.png','20050109190918!Untagged_Images_-_percent_done.png',3279,432,328,8,'82.3 pct 08-Jan-2005 - 03:45 8586',88976,'Kbh3rd','20050108050639','0','BITMAP','image','png',0,'o2rv1nh1hw0r2jgy3gtc1j1xzcgl8bq'),(2924,'Papillon.jpg','20050109221029!Papillon.jpg',813388,1600,1200,8,'Papillon {{PD}}',145363,'MrFalcon','20050109213915','a:24:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:9:\"CD MAVICA\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:03:17 00:18:20\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/500\";s:7:\"FNumber\";s:5:\"21/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:03:17 00:18:20\";s:17:\"DateTimeDigitized\";s:19:\"2004:03:17 00:18:20\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"20/10\";s:12:\"MeteringMode\";i:3;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:1;s:11:\"FocalLength\";s:5:\"93/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'pp6dv8qm8ulv8a4xvsoz1y8e5d7oj56'),(2925,'Muybridge-runner.jpg','20050110000910!Muybridge_runner.jpg',40109,590,541,8,'Nude Man Running - Edward Muybridge',143313,'W mccall','20050110000512','0','BITMAP','image','jpeg',0,'iq1isecn4vhteylv3bvxwvsizvz8sd3'),(2926,'Maria-Louisa-Bustill-(1853-1904).jpg','20050110005147!Maria_Louisa_Bustill_(1853-1904).jpg',48390,237,310,8,'Maria Louisa Bustill (1853-1904) {{pd}}',158051,'Richard Arthur Norton (1958- )','20050109203802','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2005:01:09 15:20:10\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'bezppvh4h6kqnf9x2vy3z15t69vlnst'),(2927,'Papillon.jpg','20050110005404!Papillon.jpg',338528,800,600,8,'',145363,'MrFalcon','20050109221030','a:24:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:9:\"CD MAVICA\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:03:17 00:18:20\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/500\";s:7:\"FNumber\";s:5:\"21/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:03:17 00:18:20\";s:17:\"DateTimeDigitized\";s:19:\"2004:03:17 00:18:20\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"20/10\";s:12:\"MeteringMode\";i:3;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:1;s:11:\"FocalLength\";s:5:\"93/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'0ffxc4pb0qo0fx4rbczml38njae7gni'),(2928,'Defender-barnstar.png','20050110024115!Defender_barnstar.png',13479,111,107,8,'{{pd}}Created (poorly) by me in GIMP with PD images.',137964,'ClockworkSoul','20050110022713','0','BITMAP','image','png',0,'ljwu3aylbnc8e4sdyxrq6rfjc17p6zk'),(2929,'Povest-vremennykh-let-text.PNG','20050110042906!Povest_vremennykh_let_text.PNG',33217,627,220,8,'The opening of the Old Russian (Ruthenian, Ukrainian, East Slavic) [[Primary Chronicle]] from the Laurentian codex of 1377.',49725,'A. Shetsen','20050110040937','0','BITMAP','image','png',0,'2o3l9352knd05hr8vx3nfmkj0ovs0fr'),(2930,'Povest-vremennykh-let-text.PNG','20050110042953!Povest_vremennykh_let_text.PNG',14774,802,275,8,'',49725,'A. Shetsen','20050110042906','0','BITMAP','image','png',0,'ms6dyily1vxpdplvxeqa42x8kq8l3ku'),(2931,'Povest-vremennykh-let-text.PNG','20050110043558!Povest_vremennykh_let_text.PNG',31737,602,207,8,'',49725,'A. Shetsen','20050110042953','0','BITMAP','image','png',0,'9tqh6ovhphon4mw21opiebikxojeaub'),(2932,'Tallking.jpg','20050110063720!Tallking.jpg',133514,1198,898,8,'U.S. Military Image downloaded from http://www.defenselink.mil/news/Feb2001/g010216-D-6570C.html \"Information presented on DefenseLINK is considered public information and may be distributed or copied unless otherwise specified. Use of appropriate byline/',165640,'Nvinen','20050110063338','0','BITMAP','image','jpeg',0,'5f0g1ntx08z9wxmyua62f5vkf933rnr'),(2933,'JamesDignan.jpg','20050110111451!JamesDignan.jpg',14099,198,198,8,'User:Grutness, circa 1999',117878,'Grutness','20041223075701','0','BITMAP','image','jpeg',0,'spmvko1iegecmf7oew7fp4tt0wm2qbl'),(2934,'Untagged-Images---percent-done.png','20050110143803!Untagged_Images_-_percent_done.png',3295,432,328,8,'83.8% - 7852 remaining at Sun January 9 19:01:01 2005',88976,'Kbh3rd','20050109190919','0','BITMAP','image','png',0,'f2wrgdgg0es5l625gwevz3tukjshsar'),(2935,'InteriorNewStLouisCathedral.jpg','20050110144532!InteriorNewStLouisCathedral.jpg',25713,480,640,8,'43',62234,'Jesster79','20041228223550','0','BITMAP','image','jpeg',0,'lbxdw43cwos56o2ncunamh483z5yx1m'),(2936,'GO-Empty.PNG','20050110144722!GO_Empty.PNG',184,40,40,8,'An empty sqare in Go. {{GFDL}}',57108,'Quadell','20050110140813','0','BITMAP','image','png',0,'f61agizhw91mb74styi8kxas32qv2we'),(2937,'GO-Black.PNG','20050110150353!GO_Black.PNG',297,40,40,8,'An square in Go with a black stone. {{GFDL}}',57108,'Quadell','20050110142157','0','BITMAP','image','png',0,'e1wiegwqzkpgbkt0syi40orkoot0w6r'),(2938,'GO-White.PNG','20050110150552!GO_White.PNG',308,40,40,8,'An square in Go with a white stone. {{GFDL}}',57108,'Quadell','20050110142527','0','BITMAP','image','png',0,'gbx3enttzi9m5mqgwzv1tm1tprxc1yi'),(2939,'GO-Black-latest.PNG','20050110151022!GO_Black_latest.PNG',334,40,40,8,'An square in Go with a highilighted black stone. {{GFDL}}',57108,'Quadell','20050110143206','0','BITMAP','image','png',0,'mgjqe460z7oo6c5lfimbxp23punuo1e'),(2940,'GO-White-latest.PNG','20050110151815!GO_White_latest.PNG',370,40,40,8,'An square in Go with a highilighted white stone. {{GFDL}}',57108,'Quadell','20050110143039','0','BITMAP','image','png',0,'gn25h98uu9nu91qjnlualnh3ohfkc1o'),(2941,'The.Big.Lebowski.1998.Screenshot.2.jpg','20050110211844!The.Big.Lebowski.1998.Screenshot.2.jpg',56488,640,360,8,'{{screenshot}}',73244,'Zondor','20041123022937','0','BITMAP','image','jpeg',0,'1fqt6yz944wkwk3kpyigkk7lcgcl5ye'),(2942,'Erie-map-national-atlas-mapmaker-edited.jpg','20050110225341!Erie-map-national-atlas-mapmaker-edited.jpg',104239,664,489,8,'',12028,'Jengod','20050109025221','0','BITMAP','image','jpeg',0,'7iotzx2e54tdxrn38dbitorb3u0q68h'),(2943,'Map-of-USA-highlighting-Northeast.png','20050111014509!Map_of_USA_highlighting_Northeast.png',17027,280,183,8,'Map of [[United States]] created by [[User:Wapcaplet|Wapcaplet]]',6264,'Wapcaplet','20040515021110','0','BITMAP','image','png',0,'os5s1r9p7l928l1txyg67ccw699nh57'),(2944,'Untagged-Images---percent-done.png','20050111060401!Untagged_Images_-_percent_done.png',3303,432,328,8,'84.5% - 7663 remaining at Mon January 10 05:01:00 2005',88976,'Kbh3rd','20050110143803','0','BITMAP','image','png',0,'obaiy32tbjw3bt11zz6kmrx99ih8g6y'),(2945,'AppolodotusCoin.JPG','20050111120852!AppolodotusCoin.JPG',46286,610,293,8,'',48296,'PHG','20050109025735','a:24:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:20:\"Canon PowerShot S110\";s:8:\"DateTime\";s:19:\"2005:01:09 11:47:43\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:5:\"1/400\";s:7:\"FNumber\";s:5:\"28/10\";s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2005:01:09 11:47:43\";s:17:\"DateTimeDigitized\";s:19:\"2005:01:09 11:47:43\";s:22:\"CompressedBitsPerPixel\";s:3:\"5/1\";s:17:\"ShutterSpeedValue\";s:6:\"277/32\";s:13:\"ApertureValue\";s:5:\"95/32\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:12:\"194698/65536\";s:15:\"SubjectDistance\";s:8:\"130/1000\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:6:\"173/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"1600000/206\";s:21:\"FocalPlaneYResolution\";s:11:\"1200000/155\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'8t0vgvvwnao94i2n4u8mmwez48msji7'),(2946,'Quinoline-chemical-structure.png','20050111172708!Quinoline_chemical_structure.png',14020,522,115,8,'',83784,'Cacycle','20050110195851','0','BITMAP','image','png',0,'7kv0u4heuo5bejmjurv3hw43vwxv3iw'),(2947,'Capital-beltway-240x209.PNG','20050111215838!Capital_beltway_240x209.PNG',9708,240,209,8,'Map of the Capital Beltway, from US Census Tiger on-line mapping system',30225,'Rfc1394','20031224233557','0','BITMAP','image','png',0,'9tfpwuw3ug0qjjrovn92eaxjq0bis3h'),(2948,'Neic-slav-fig72.gif','20050111222013!Neic_slav_fig72.gif',60669,612,792,5,'{{PD-USGov-Interior-USGS}}',44727,'Curps','20050109221403','0','BITMAP','image','gif',0,'if8qy4zplvfq2g2x3uwzzqzlgc4hlwe'),(2949,'Truf2.JPG','20050112035348!Truf2.JPG',92824,640,480,8,'Truffle the pet  Patterdale Terrier',156089,'Chilepine','20050111111755','a:36:{s:16:\"ImageDescription\";s:31:\"MINOLTA DIGITAL CAMERA         \";s:4:\"Make\";s:17:\"minolta Co., Ltd.\";s:5:\"Model\";s:11:\"DiMAGE E323\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:9:\"Ver. 1.00\";s:8:\"DateTime\";s:19:\"2004:04:01 09:44:29\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/300\";s:7:\"FNumber\";s:5:\"48/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:04:01 09:44:29\";s:17:\"DateTimeDigitized\";s:19:\"2004:04:01 09:44:29\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"30/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:25;s:11:\"FocalLength\";s:5:\"56/10\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:5:\"0/100\";s:21:\"FocalLengthIn35mmFilm\";i:36;s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:20:\"SubjectDistanceRange\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'98iyq9q0me696iq3fp869uyrdy40bmu'),(2950,'PeacePark7241.JPG','20050112035726!PeacePark7241.JPG',1147341,2048,1536,8,'Statue in Nagasaki Peace Park',168061,'Nagasakidude','20050112034952','a:34:{s:4:\"Make\";s:7:\"KYOCERA\";s:5:\"Model\";s:15:\"Finecam SL300R \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:13:\"4718592/65536\";s:11:\"YResolution\";s:13:\"4718592/65536\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"QuickTime 6.5.2\";s:8:\"DateTime\";s:19:\"2004:12:30 10:35:29\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/3500\";s:7:\"FNumber\";s:5:\"75/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:200;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:12:29 11:53:15\";s:17:\"DateTimeDigitized\";s:19:\"2004:12:29 11:53:15\";s:22:\"CompressedBitsPerPixel\";s:5:\"40/10\";s:17:\"ShutterSpeedValue\";s:7:\"839/100\";s:13:\"ApertureValue\";s:7:\"687/100\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:7:\"300/100\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:6:\"164/10\";s:10:\"ColorSpace\";i:65535;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:4:\"0/10\";s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'ib488ro1mmv4hxdrwvw2pst36b4w1ae'),(2951,'Brazilstubmap.png','20050112052754!Brazilstubmap.png',28539,288,288,8,'Brazilian map for Brazil-geo-stub template {{gfdl}}',117878,'Grutness','20050112052401','0','BITMAP','image','png',0,'axqqzchcny0uox6xpnff22h9k8jpaoa'),(2952,'Brazilstubmap.png','20050112054111!Brazilstubmap.png',28539,288,288,8,'Map for Brazil-geo-stub template {{gfdl}}',117878,'Grutness','20050112052754','0','BITMAP','image','png',0,'axqqzchcny0uox6xpnff22h9k8jpaoa'),(2953,'Krzyz-Grunwaldzki-Ribbon.png','20050112054820!Krzyz_Grunwaldzki_Ribbon.png',230,106,30,4,'[[Grunwald Cross]] - Ribbon<br>{{User:Halibutt/GFDL}}',32233,'Halibutt','20050112054201','0','BITMAP','image','png',0,'fj4hf1t4oepu2or0qtuv9xxw6gfwg92'),(2954,'Untagged-Images---percent-done.png','20050112062849!Untagged_Images_-_percent_done.png',3311,432,328,8,'85.3% - 7136 remaining at Tue January 11 06:01:00 2005',88976,'Kbh3rd','20050111060401','0','BITMAP','image','png',0,'cpoqocn53jmi1ashvtrp227bxfqmn3o'),(2955,'Untagged-Images---percent-done.png','20050112153517!Untagged_Images_-_percent_done.png',3330,432,328,8,'87.6% - 6032 remaining at Wed January 12 06:27:09 2005',88976,'Kbh3rd','20050112062849','0','BITMAP','image','png',0,'g91wilnxk2ld6j3m7x6rw898cwq3gpx'),(2956,'Gerrymander-diagram-for-four-sample-districts.gif','20050112211305!Gerrymander_diagram_for_four_sample_districts.gif',18757,438,315,8,'gerrymander diagram for four sample districts',65827,'Jeremykemp','20050112204822','0','BITMAP','image','gif',0,'i4qmegie5kdkr7p06wdy6lqz6z94r84'),(2957,'Gerrymander-diagram-for-four-sample-districts.gif','20050112212901!Gerrymander_diagram_for_four_sample_districts.gif',18358,439,341,8,'gerrymander diagram for four sample districts',65827,'Jeremykemp','20050112211306','0','BITMAP','image','gif',0,'m18fumt1cavy614zb4uyiwj7m4oy8lf'),(2958,'Pyrrole-chemical-structure.png','20050112225129!Pyrrole_chemical_structure.png',6665,341,101,8,'',83784,'Cacycle','20050111182838','0','BITMAP','image','png',0,'by8x4mjedi1iqntcgdx6x83fvkn1wzo'),(2959,'Rcv-cover.jpg','20050112235323!Rcv-cover.jpg',44459,203,286,8,'Photo of the [[Recovery Version]], published in 1991. Photo was taken by ~~~ and is public domain.  {{PD-user|Hoshie}}',5904,'Hoshie','20050103225908','a:27:{s:4:\"Make\";s:21:\"EASTMAN KODAK COMPANY\";s:5:\"Model\";s:32:\"KODAK DC3400 ZOOM DIGITAL CAMERA\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:13:\"4718592/65536\";s:11:\"YResolution\";s:13:\"4718592/65536\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"QuickTime 6.5.2\";s:8:\"DateTime\";s:19:\"2005:01:03 03:35:07\";s:16:\"YCbCrPositioning\";i:1;s:9:\"Copyright\";s:32:\"KODAK DC3400 ZOOM DIGITAL CAMERA\";s:12:\"ExposureTime\";s:4:\"1/30\";s:7:\"FNumber\";s:7:\"300/100\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2005:01:02 23:49:18\";s:17:\"DateTimeDigitized\";s:19:\"2005:01:02 23:49:18\";s:17:\"ShutterSpeedValue\";s:5:\"50/10\";s:13:\"ApertureValue\";s:5:\"31/10\";s:17:\"ExposureBiasValue\";s:5:\"0/100\";s:16:\"MaxApertureValue\";s:5:\"31/10\";s:12:\"MeteringMode\";i:1;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:1;s:11:\"FocalLength\";s:5:\"63/10\";s:10:\"ColorSpace\";i:1;s:13:\"ExposureIndex\";s:5:\"100/1\";s:13:\"SensingMethod\";i:2;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'sxhkkdb2bfjknlr3by5os1x4y9gh63x'),(2960,'Megrinningstupidly.jpg','20050113002437!Megrinningstupidly.jpg',17679,640,480,8,'Me, grinning stupidly {{GFLD}}',162313,'Consequencefree','20050113002343','0','BITMAP','image','jpeg',0,'30bmhp80jbzqif43ibbb092iauaeqju'),(2961,'Simpsons-on-Tracey-Ullman.png','20050113023914!Simpsons_on_Tracey_Ullman.png',53939,541,500,8,'The Simpsons on The Tracey Ullman Show. {{fairuse}}',122756,'Keyser Söze','20041224062946','0','BITMAP','image','png',0,'721uqtepeipb6t1cg5mldxon4uo2cbk'),(2962,'Untagged-Images---percent-done.png','20050113040949!Untagged_Images_-_percent_done.png',3101,400,304,8,'Resized 400px: 88.6% - 5532 remaining at Wed January 12 10:01:01 2005',88976,'Kbh3rd','20050112153518','0','BITMAP','image','png',0,'s43hk7lzml9mev3novazidyubf39zzr'),(2963,'Two-babylons.jpg','20050113053209!Two-babylons.jpg',15480,179,368,8,'{{fairuse}}',75749,'Ta bu shi da yu','20050113052123','0','BITMAP','image','jpeg',0,'ep46juhrjgmqbo9tfhrcmojg2ngp5wk'),(2964,'Tashisunrise.jpg','20050113191543!Tashisunrise.jpg',22554,400,342,8,'Sunrise at \'\'\'Tashi Viewpoint\'\'\' near [[Gangtok]]',41228,'Nichalp','20050112195143','0','BITMAP','image','jpeg',0,'st9pe30uwe0y2u7tblexza4dk4p5pl3'),(2965,'ABERR6.png','20050113232737!ABERR6.png',35638,400,547,4,'pngcrushed version',2251,'DrBob','20041009010422','0','BITMAP','image','png',0,'6tdu5rsw9wcefkmoqcs7czcnhapdtan'),(2966,'ABERR3.png','20050113232800!ABERR3.png',6672,400,239,4,'pngcrushed version',2251,'DrBob','20041009010253','0','BITMAP','image','png',0,'1azdd3iz8a85ad210bcn3zbaybwtsi7'),(2967,'ABERR5.png','20050113232804!ABERR5.png',8118,400,149,4,'pngcrushed version',2251,'DrBob','20041009010355','0','BITMAP','image','png',0,'5kic1stu9e9dm0wajgj96bslb5tbduo'),(2968,'Untagged-Images---percent-done.png','20050114053130!Untagged_Images_-_percent_done.png',3109,400,304,8,'90%: 4828 remaining at Thu January 13 04:07:46 2005',88976,'Kbh3rd','20050113040951','0','BITMAP','image','png',0,'ej926vrkxog7qduo2kxx38on0glkgwe'),(2969,'Untagged-Images-Remaining---hourly.png','20050114053343!Untagged_Images_Remaining_-_hourly.png',3093,432,328,8,'8566 remaining at Sat January 8 05:01:01 2005',88976,'Kbh3rd','20050108052137','0','BITMAP','image','png',0,'hfsev2hvgslncngd6jw76etk2jp91cg'),(2970,'Untagged-Images-Remaining.png','20050114053632!Untagged_Images_Remaining.png',2541,432,240,8,'8566 remaining at Sat January 8 05:01:01 2005',88976,'Kbh3rd','20050108052115','0','BITMAP','image','png',0,'55udg1jdeo3aad26u9tnlyp5p58dev9'),(2971,'Sunderland-pre-1949-(Unofficial).gif','20050114091830!Sunderland_pre_1949_(Unofficial).gif',147153,534,742,8,'',54836,'Garryq','20050113182748','0','BITMAP','image','gif',0,'c1f1dxqxkd62nxwjeq74r457ry2nwzk'),(2972,'Ancient-Oak.jpg','20050114211447!Ancient_Oak.jpg',212951,763,542,8,'Foto of second place Ohio champion white oak tree, foto by John Knouse ([[user:jaknouse]])',3212,'Jaknouse','20040810143242','0','BITMAP','image','jpeg',0,'3wc2020tt5zbg6rq0m0pv3dql7p0d4t'),(2973,'Star-piece.png','20050115021400!Star_piece.png',4538,100,96,8,'{{GFDL}}',48117,'Avsa','20041226142905','0','BITMAP','image','png',0,'kr1j4a0yfm2jvoj16e9wj6xidsq86gb'),(2974,'FrancisShunk.jpg','',9717,0,0,0,'Penn. Gov, pic from http://www.phmc.state.pa.us/bah/dam/governors/overview.asp',35314,'Seth Ilys','20040126145709','',NULL,'unknown','unknown',0,''),(2975,'Untagged-Images---percent-done.png','20050115051110!Untagged_Images_-_percent_done.png',3126,400,304,8,'91.7% - 3997 remaining at Fri January 14 05:29:39 2005',88976,'Kbh3rd','20050114053131','0','BITMAP','image','png',0,'4sfeo9q0qtjg7jw5qnotx2p93jx7xty'),(2976,'Winnipeg-snowstorm-aftermath.jpg','20050115075926!Winnipeg_snowstorm_aftermath.jpg',73761,640,480,8,'Winnipeg street after two snowstorms, 2005-01-02  {{GFDL}}',61482,'Mzajac','20050115074804','0','BITMAP','image','jpeg',0,'a399i74bmvr89qln7vt86rm56upcntd'),(2977,'Huygens-landing01-L.jpg','20050115135254!Huygens_landing01_L.jpg',20237,400,243,8,'{{noncommercial}}',44727,'Curps','20050114204158','0','BITMAP','image','jpeg',0,'i3oj334c0ah0hk962vfuyprgh80z07t'),(2978,'Purcelus-de-guinea.jpg','20050115193238!Purcelus-de-guinea.jpg',16699,489,368,8,'{{GFDL}}Made by me',9475,'Bogdangiusca','20050115193023','0','BITMAP','image','jpeg',0,'bssvhudufm0zmp7y9b8rctq4hkt5ezt'),(2979,'YourCountryNeedsYou.jpg','20050116003517!YourCountryNeedsYou.jpg',33756,577,762,8,'',122335,'119','20050116003050','0','BITMAP','image','jpeg',0,'oevyhruk1pwy4kqr42ybzzmc70d9lol'),(2980,'030817-silly.jpg','20050116032416!030817_silly.jpg',98627,800,600,8,'Silly Railway Station (Belgium)',19650,'Sdschuit','20030817120255','a:27:{s:16:\"ImageDescription\";s:31:\"OLYMPUS DIGITAL CAMERA         \";s:4:\"Make\";s:23:\"OLYMPUS OPTICAL CO.,LTD\";s:5:\"Model\";s:6:\"C2000Z\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:27:\"ACD Systems Digital Imaging\";s:8:\"DateTime\";s:19:\"2003:08:17 14:01:53\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:7:\"10/1250\";s:7:\"FNumber\";s:5:\"50/10\";s:15:\"ExposureProgram\";i:4;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2003:08:17 11:54:41\";s:17:\"DateTimeDigitized\";s:19:\"2003:08:17 11:54:41\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"30/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"82/10\";s:10:\"SubSecTime\";s:3:\"932\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'5uovkntqt96w6nyy44goxmsx2378tbx'),(2981,'2002313-Saddlebilled-Stork.jpg','20050116035439!2002313_Saddlebilled_Stork.jpg',30827,250,330,8,'Saddlebilled Stork',57579,'Wildlifelands','20040404155924','0','BITMAP','image','jpeg',0,'t8jl5kjr06qjr8xvmpbp009077u60ib'),(2982,'2001588-Giant-Petrel-2.jpg','20050116041323!2001588_Giant_Petrel_2.jpg',26693,350,263,8,'Giant Petrel',57579,'Wildlifelands','20040404155340','0','BITMAP','image','jpeg',0,'9jwmqefbjoe6ufpj3oj9l4e0exezdud'),(2983,'Heart-mountain-veterans-plaque.jpg','20050116082757!Heart_mountain_veterans_plaque.jpg',42739,600,463,8,'Heart Mountain veterans plaque',65827,'Jeremykemp','20050116075123','0','BITMAP','image','jpeg',0,'tve3rde7xlyiqjzt008fjv04fn6tj0v'),(2984,'Bighorn-basin-historical-marker.jpg','20050116084429!Bighorn_basin_historical_marker.jpg',104478,632,400,8,'bighorn basin historical marker',65827,'Jeremykemp','20050116074546','0','BITMAP','image','jpeg',0,'2u0rwcghcyrhh6t7cywwsjv8ailt692'),(2985,'Udpdtahoe.jpg','20050116193747!Udpdtahoe.jpg',305441,1024,768,8,'Image taken by myself of unit 41-7 of the UDPD',137891,'FtWashGuy','20050116054153','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2005:01:16 00:40:04\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'e6g47kndwea46czj5c8i38j637f1gbq'),(2986,'Joseph-Locke.jpg','20050116233855!Joseph_Locke.jpg',40127,383,444,8,'[[Joseph Locke]], presumably {{PD-old}}',47291,'Duncharris','20050116233738','0','BITMAP','image','jpeg',0,'so4y2qaeorfrdccis9dq9840euir0rp'),(2987,'Singapore-blue.jpg','20050117165301!Singapore-blue.jpg',1225624,6037,1897,8,'Singapore panorama from Boat Quay',7294,'MichaelJanich','20030223111307','0','BITMAP','image','jpeg',0,'n0fpupkeu68xdcw0k3dgdfh15ounxj1'),(2988,'Sirenspectrogram.jpg','20050117224232!Sirenspectrogram.jpg',636824,1275,824,8,'Spectrogram of a police siren',99270,'Key45','20050117223247','0','BITMAP','image','jpeg',0,'0bwgqdj3x366f9iisw5t2e3a7ze5c9u'),(2989,'Humphrey.jpg','20050118015540!Humphrey.jpg',15524,360,243,8,'Reverted to earlier revision',34793,'Anthony','20040303015724','0','BITMAP','image','jpeg',0,'5b4s1r72wskvoyhoieaiwzo4eo0gqtm'),(2990,'Map-of-New-Brunswick-highlighting-Kent-County.png','',20169,0,0,0,'Public domain map of New Brunswick created by [[User:Plasma east]] with data courtesy of [http://geogratis.cgdi.gc.ca Geogratis], modified to show counties.  Released under GFDL.{{GFDL}}',60804,'Plasma east','20040828021814','',NULL,'unknown','unknown',0,''),(2991,'Untagged-Images---percent-done.png','20050118161411!Untagged_Images_-_percent_done.png',3151,400,304,8,'92.3% - 3728 remaining at Sat January 15 05:01:01 2005',88976,'Kbh3rd','20050115051111','0','BITMAP','image','png',0,'s5oksowu4pulldspeuv6j87xz2rqcd3'),(2992,'Tampa-meetup-Jimbo-and-Mav2.jpg','20050118235703!Tampa_meetup_Jimbo_and_Mav2.jpg',1356771,2016,1512,8,'{{User:Raul654/License}}',21013,'Raul654','20050118234301','a:34:{s:4:\"Make\";s:9:\"Panasonic\";s:5:\"Model\";s:7:\"DMC-FZ3\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2005:01:15 17:27:36\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/600\";s:7:\"FNumber\";s:5:\"28/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2005:01:15 17:27:36\";s:17:\"DateTimeDigitized\";s:19:\"2005:01:15 17:27:36\";s:22:\"CompressedBitsPerPixel\";s:3:\"4/1\";s:17:\"ExposureBiasValue\";s:5:\"0/100\";s:16:\"MaxApertureValue\";s:5:\"30/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:4;s:5:\"Flash\";i:89;s:11:\"FocalLength\";s:5:\"46/10\";s:10:\"ColorSpace\";i:1;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:4:\"0/10\";s:21:\"FocalLengthIn35mmFilm\";i:35;s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'swlrszxny2xan27b9pjrj6c337rdjw1'),(2993,'Musicstar2.png','20050119014114!Musicstar2.png',92260,245,254,8,'Candidate for the Music Barnstar {{GFDL}}',75539,'Alkivar','20050119013956','0','BITMAP','image','png',0,'q4ach1ro3lswlx14rgpzm10jzjn0f3c'),(2994,'CUPS-process.PNG','20050119030114!CUPS_process.PNG',20461,185,575,8,'{{GFDL}} Overview of the [[CUPS]] process.',75749,'Ta bu shi da yu','20050119015236','0','BITMAP','image','png',0,'5mxyxyfosvc8r4zchwu872da51ymdih'),(2995,'CUPS-process.PNG','20050119031329!CUPS_process.PNG',19667,196,692,8,'',75749,'Ta bu shi da yu','20050119030114','0','BITMAP','image','png',0,'iy2vfbtzl042k25hayq7y0ti345qv0c'),(2996,'CUPS-process.PNG','20050119031909!CUPS_process.PNG',20347,196,692,8,'New version without transparency',75749,'Ta bu shi da yu','20050119031330','0','BITMAP','image','png',0,'esicm8qo9808j2lxh2x2rymr4k76d1z'),(2997,'CUPS-process.PNG','20050119032359!CUPS_process.PNG',19738,211,692,8,'missing a label!',75749,'Ta bu shi da yu','20050119031910','0','BITMAP','image','png',0,'l73i6kpfn0dknonq5kvtis89usn3l2p'),(2998,'Gesture-thumb-in-mouth-then-flicked-out-forward.jpg','20050119061305!Gesture_thumb_in_mouth_then_flicked_out_forward.jpg',15708,472,400,8,'gesture_thumb_in_mouth_then_flicked_out_forward',65827,'Jeremykemp','20050119055205','0','BITMAP','image','jpeg',0,'fctxckxs2zpip4sm1msesta49lzr8jl'),(2999,'Ph-seal-rizal.png','20050119071410!Ph_seal_rizal.png',12011,150,150,8,'Provincial seal of [[Rizal]], [[Philippines]].',6627,'Seav','20030523205939','0','BITMAP','image','png',0,'7q4ebhbb5x2ngmqyy2vydd8ul621634'),(3000,'Supremes-1968-reflections.jpg','20050119073850!Supremes-1968-reflections.jpg',108323,353,300,8,'The Cover to [[The Supremes]]\' 1968 LP, \'\'Reflections\'\' {{albumcover}}',106704,'B Touch','20050119073039','0','BITMAP','image','jpeg',0,'fr2uplb5lysxcer9peymok8qq0ot1yr'),(3001,'Cathedral-kronstadt.jpg','20050119130925!Cathedral_kronstadt.jpg',17820,204,322,8,'The Old Naval Cathedral in Kronstadt {{pd}}',156587,'Pierre Aronax','20041223201055','0','BITMAP','image','jpeg',0,'jf3ehzoaeg380ykc3x5aw4726my93c4'),(3002,'Lightwater-Valley-Entrance.jpg','20050119184953!Lightwater_Valley_Entrance.jpg',124476,640,480,8,'Entrance to Lightwater Valley Theme Park photographed by S J Simms, Monday 23rd August 2004. ',172201,'StuSimms','20050119183140','a:32:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:21:\"Canon DIGITAL IXUS II\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:08:23 13:09:04\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:5:\"1/125\";s:7:\"FNumber\";s:5:\"28/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:08:23 13:09:04\";s:17:\"DateTimeDigitized\";s:19:\"2004:08:23 13:09:04\";s:22:\"CompressedBitsPerPixel\";s:3:\"3/1\";s:17:\"ShutterSpeedValue\";s:6:\"223/32\";s:13:\"ApertureValue\";s:5:\"95/32\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:5:\"95/32\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:6:\"173/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:10:\"640000/208\";s:21:\"FocalPlaneYResolution\";s:10:\"480000/156\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:9:\"2048/2048\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'26qqm5wyf5wsu3czcqesoqof38f56w4'),(3003,'The-L.J.-Brown-Block,-Main-Street,-Fitchburg,-Massachusetts,-1885---Project-Gutenberg-eText-14689.png','20050119195113!The_L.J._Brown_Block,_Main_Street,_Fitchburg,_Massachusetts,_1885_-_Project_Gutenberg_eText_14689.png',94045,474,593,4,'The L.J. Brown Block, Main Street, [[Fitchburg, Massachusetts]], [[1885]] - Project Gutenberg eText 14689 - http://www.gutenberg.org/dirs/1/4/6/8/14689/14689-h/14689-h.htm#toc_9 - {{PD}}',51294,'Tagishsimon','20050119194759','0','BITMAP','image','png',0,'9bilnmxvp6h8ngoppg2xyufp6pdhrn6'),(3004,'Adventure1.png','20050119215912!Adventure1.png',4818,288,173,8,'Screenshot of Atari Adventure',22976,'Caveyak','20030921042128','0','BITMAP','image','png',0,'m3nikg6wwfpf7zxjk9w0l30azdkgu05'),(3005,'Pyrrole-chemical-structure.png','20050119223639!Pyrrole_chemical_structure.png',9428,341,101,8,'',83784,'Cacycle','20050112225130','0','BITMAP','image','png',0,'6f7ysk0e04h00d0icq65614d20zzg5t'),(3006,'Indazole-chemical-structure.png','20050119223647!Indazole_chemical_structure.png',12972,481,124,8,'',83784,'Cacycle','20050110195928','0','BITMAP','image','png',0,'6awdse85eolqvh8k8kwv5eo30332yel'),(3007,'Oxazole-chemical-structure.png','20050119223650!Oxazole_chemical_structure.png',14033,338,92,8,'',83784,'Cacycle','20050110195829','0','BITMAP','image','png',0,'2ywv6z65g3z07rcb0vrobqb3feiib65'),(3008,'Isoxazole-chemical-structure.png','20050119223706!Isoxazole_chemical_structure.png',12222,345,90,8,'',83784,'Cacycle','20050111172845','0','BITMAP','image','png',0,'r3et6t2r5i7hgfov4bl7bvj6uvume12'),(3009,'Quinoline-chemical-structure.png','20050119224152!Quinoline_chemical_structure.png',12452,501,116,8,'',83784,'Cacycle','20050111172708','0','BITMAP','image','png',0,'b7e9vgia7cb2psc3qtl13qn7mpvq882'),(3010,'Quinoline-chemical-structure.png','20050119224701!Quinoline_chemical_structure.png',12460,501,116,8,'',83784,'Cacycle','20050119224152','0','BITMAP','image','png',0,'fp1cj5ajilo4e5wz7sjzsqf25cy8mhb'),(3011,'Smashing-Pumpkins-Greatest-Hits-album-cover.jpg','20050120015905!Smashing_Pumpkins_Greatest_Hits_album_cover.jpg',172312,982,977,8,'cropped better',38020,'Dbenbenn','20041218223441','a:32:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:20:\"Canon PowerShot A310\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:12:18 12:23:10\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:4:\"1/20\";s:7:\"FNumber\";s:5:\"36/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:12:18 12:23:10\";s:17:\"DateTimeDigitized\";s:19:\"2004:12:18 12:23:10\";s:22:\"CompressedBitsPerPixel\";s:3:\"3/1\";s:17:\"ShutterSpeedValue\";s:6:\"138/32\";s:13:\"ApertureValue\";s:6:\"118/32\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:6:\"118/32\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:6:\"160/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"2048000/208\";s:21:\"FocalPlaneYResolution\";s:11:\"1536000/156\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:9:\"2048/2048\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'83vs86ttpwgquot9cx916yb8bckv8kb'),(3012,'Communism-expansion.PNG','20050120051402!Communism_expansion.PNG',46343,1357,628,8,'',172473,'Sean II','20050120045525','0','BITMAP','image','png',0,'qsjrj5szhjo75o6ifv8uh3w5ktddsmv'),(3013,'Untagged-Images---percent-done.png','20050120060912!Untagged_Images_-_percent_done.png',3171,400,304,8,'94.5% - 2620 remaining at Tue January 18 16:01:01 2005',88976,'Kbh3rd','20050118161411','0','BITMAP','image','png',0,'2txpwnmc1p19xafknff1uvy02ulf1wi'),(3014,'Shin-ra.png','20050120063505!Shin-ra.png',41356,149,149,8,'Logo of the [[Shin-Ra|Shin-Ra Electric Power Company]] from \'\'[[Final Fantasy VII]]\'\' {{fairuse]]',132265,'Seancdaug','20050120063010','0','BITMAP','image','png',0,'hlbny8wbd602x06brjfdpd7rjskobjn'),(3015,'Naphthalene-chemical-structure.png','20050120090134!Naphthalene_chemical_structure.png',13359,495,104,8,'',83784,'Cacycle','20050111220653','0','BITMAP','image','png',0,'i3nnye931kihvqkjvjdtt65pnju2fep'),(3016,'Ph-seal-marinduque.png','20050120190913!Ph_seal_marinduque.png',46149,150,150,8,'Provincial seal of [[Marinduque]], [[Philippines]]. {{coatofarms}}',148639,'TheCoffee','20050119105403','0','BITMAP','image','png',0,'9rfomrwf96ugllvi3nkwoonubk2tvod'),(3017,'Untagged-Images---percent-done.png','20050120194449!Untagged_Images_-_percent_done.png',3175,400,304,8,'95.5% : 2159 remaining at Thu January 20 06:01:00 2005',88976,'Kbh3rd','20050120060912','0','BITMAP','image','png',0,'k1htnbue8bv066y79410mosbm9ofq58'),(3018,'Fiona-Rosy-Boa.jpg','20050121014317!Fiona_Rosy_Boa.jpg',535456,1995,1653,8,'Fiona the [[snake]].  A [[Rosy Boa]].  Photo taken by [[User:TomPreuss]] and released under the [[GDFL]].  {{GFDL}}',83904,'TomPreuss','20050121014306','0','BITMAP','image','jpeg',0,'4b3ab28l6o5z1ctlbejfbded3vnkheo'),(3019,'A-Toot-and-a-Snore-in-\'74.jpg','20050121022558!A_Toot_and_a_Snore_in_\'74.jpg',41328,320,320,8,'Album cover of the [[bootleg]] recording \'\'[[A Toot and a Snore in \'74]]\'\'. Source: [http://www.bootlegzone.com/beatleg/discs/scans/tootsnor.jpg]. {{albumcover}}',83184,'Vague Rant','20050117125559','0','BITMAP','image','jpeg',0,'n8efkrsrn398vkt6371lphpzslrqczi'),(3020,'Sharks-1-bg-100801-2.jpg','20050121034301!Sharks_1_bg_100801_2.jpg',146226,1184,888,8,'',62617,'Latitude0116','20040424233419','a:37:{s:4:\"Make\";s:21:\"EASTMAN KODAK COMPANY\";s:5:\"Model\";s:37:\"KODAK EASYSHARE CX6200 DIGITAL CAMERA\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"230/1\";s:11:\"YResolution\";s:5:\"230/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:15:\"Version 1.0100 \";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:14:\"125000/1000000\";s:7:\"FNumber\";s:7:\"450/100\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:200;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:04:24 19:22:15\";s:17:\"DateTimeDigitized\";s:19:\"2004:04:24 19:22:15\";s:22:\"CompressedBitsPerPixel\";s:7:\"111/100\";s:17:\"ShutterSpeedValue\";s:7:\"300/100\";s:13:\"ApertureValue\";s:7:\"433/100\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:7:\"433/100\";s:12:\"MeteringMode\";i:2;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:7:\"499/100\";s:10:\"ColorSpace\";i:1;s:13:\"ExposureIndex\";s:5:\"200/1\";s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:4:\"0/10\";s:21:\"FocalLengthIn35mmFilm\";i:38;s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:20:\"SubjectDistanceRange\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'am3ngsehijtujd6n9vy54aveoooge7w'),(3021,'Untagged-Images---percent-done.png','20050121063037!Untagged_Images_-_percent_done.png',3181,400,304,8,'96.3% : 1802 remaining at Thu January 20 19:01:01 2005',88976,'Kbh3rd','20050120194449','0','BITMAP','image','png',0,'lwfvt8ckbig5ca3m2849jgg2a7zfdkp'),(3022,'Untagged-Images-Remaining.png','20050121063340!Untagged_Images_Remaining.png',2369,432,240,8,'14-Jan-2005 - 00:15 4238',88976,'Kbh3rd','20050114053632','0','BITMAP','image','png',0,'50stpmdcy2r2ohki9aygbhmzx0kfc4y'),(3023,'Untagged-Images-Remaining---hourly.png','20050121063420!Untagged_Images_Remaining_-_hourly.png',3158,432,328,8,'3997 remaining at Fri Jan 14 05:29:39 2005',88976,'Kbh3rd','20050114053343','0','BITMAP','image','png',0,'0eaxninv63n2dgvq7pkeskxtmweus8x'),(3024,'Amish-POV.png','20050121074841!Amish_POV.png',6578,65,56,8,'{{GFDL}} Amish POV Icon',89570,'Crtrue','20050121074347','0','BITMAP','image','png',0,'9wgxleuiqc9zgbnw1zx75dnnxc1nsx2'),(3025,'Arbroath-Keptie-Pond.jpg','20050121124644!Arbroath_Keptie_Pond.jpg',279949,1600,1200,8,'Arbroath, Keptie Pond',13223,'A1r','20050121124217','a:32:{s:4:\"Make\";s:23:\"CASIO COMPUTER CO.,LTD \";s:5:\"Model\";s:7:\"EX-M20 \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:21:\"1.00                 \";s:8:\"DateTime\";s:19:\"2004:12:28 14:26:43\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:5:\"1/640\";s:7:\"FNumber\";s:5:\"35/10\";s:15:\"ExposureProgram\";i:2;s:11:\"ExifVersion\";s:4:\"0221\";s:16:\"DateTimeOriginal\";s:19:\"2004:12:28 14:26:43\";s:17:\"DateTimeDigitized\";s:19:\"2004:12:28 14:26:43\";s:22:\"CompressedBitsPerPixel\";s:15:\"1075200/1920000\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:5:\"37/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:11;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:7:\"560/100\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:1;s:21:\"FocalLengthIn35mmFilm\";i:37;s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'pbxtnf1bzgnhywebclk6jn33j69orl0'),(3026,'HermaeusCoin.jpg','20050121135041!HermaeusCoin.jpg',10959,339,163,8,'',48296,'PHG','20040710004600','0','BITMAP','image','jpeg',0,'mwzqvibsi2bflnb1l2dbns9yp1bf1ij'),(3027,'Tocho-building-1-from-12th-floor.jpg','20050121135922!Tocho_building_1_from_12th_floor.jpg',58164,600,450,8,'Photo of [[Tokyo Metropolitan Government Building]] {{PD}}',48598,'Zhen Lin','20050121135447','a:32:{s:4:\"Make\";s:5:\"Canon\";s:5:\"Model\";s:21:\"Canon DIGITAL IXUS v3\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"180/1\";s:11:\"YResolution\";s:5:\"180/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:12:11 08:12:37\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:5:\"1/400\";s:7:\"FNumber\";s:5:\"28/10\";s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:12:11 08:12:37\";s:17:\"DateTimeDigitized\";s:19:\"2004:12:11 08:12:37\";s:22:\"CompressedBitsPerPixel\";s:3:\"5/1\";s:17:\"ShutterSpeedValue\";s:6:\"277/32\";s:13:\"ApertureValue\";s:5:\"95/32\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:5:\"95/32\";s:12:\"MeteringMode\";i:5;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:6:\"173/32\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:11:\"2048000/207\";s:21:\"FocalPlaneYResolution\";s:11:\"1536000/156\";s:24:\"FocalPlaneResolutionUnit\";i:2;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"DigitalZoomRatio\";s:9:\"2048/2048\";s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'fp6c1uu7p9nc99pwr0ay64aos4v6vnx'),(3028,'Arbroath-Keptie-Pond.jpg','20050121171206!Arbroath_Keptie_Pond.jpg',279949,1600,1200,8,'Arbroath, Keptie Pond',13223,'A1r','20050121124645','a:32:{s:4:\"Make\";s:23:\"CASIO COMPUTER CO.,LTD \";s:5:\"Model\";s:7:\"EX-M20 \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:21:\"1.00                 \";s:8:\"DateTime\";s:19:\"2004:12:28 14:26:43\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:5:\"1/640\";s:7:\"FNumber\";s:5:\"35/10\";s:15:\"ExposureProgram\";i:2;s:11:\"ExifVersion\";s:4:\"0221\";s:16:\"DateTimeOriginal\";s:19:\"2004:12:28 14:26:43\";s:17:\"DateTimeDigitized\";s:19:\"2004:12:28 14:26:43\";s:22:\"CompressedBitsPerPixel\";s:15:\"1075200/1920000\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:5:\"37/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:11;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:7:\"560/100\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:1;s:21:\"FocalLengthIn35mmFilm\";i:37;s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'pbxtnf1bzgnhywebclk6jn33j69orl0'),(3029,'Arbroath-harbour1.jpg','20050121171416!Arbroath_harbour1.jpg',230496,1600,1200,8,'View of Arbroath Harbour.',13223,'A1r','20050121131204','a:32:{s:4:\"Make\";s:23:\"CASIO COMPUTER CO.,LTD \";s:5:\"Model\";s:7:\"EX-M20 \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:21:\"1.00                 \";s:8:\"DateTime\";s:19:\"2004:12:28 14:12:02\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:5:\"1/500\";s:7:\"FNumber\";s:5:\"35/10\";s:15:\"ExposureProgram\";i:2;s:11:\"ExifVersion\";s:4:\"0221\";s:16:\"DateTimeOriginal\";s:19:\"2004:12:28 14:12:02\";s:17:\"DateTimeDigitized\";s:19:\"2004:12:28 14:12:02\";s:22:\"CompressedBitsPerPixel\";s:15:\"1075200/1920000\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:5:\"37/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:11;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:7:\"560/100\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:1;s:21:\"FocalLengthIn35mmFilm\";i:37;s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'c1zsy98yl29tlhcbaxll5j90mal385l'),(3030,'Braunston-Marina.jpg','20050121191156!Braunston_Marina.jpg',168139,800,713,8,'Photo by G-Man',8272,'G-Man','20050114204121','a:25:{s:16:\"ImageDescription\";s:8:\"KF2-2002\";s:4:\"Make\";s:7:\"KONICA \";s:5:\"Model\";s:12:\"KONICA KD-20\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:12:01 06:23:32\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:4:\"1/42\";s:7:\"FNumber\";s:3:\"7/2\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:12:01 06:23:32\";s:17:\"DateTimeDigitized\";s:19:\"2004:12:01 06:23:32\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:5:\"97/10\";s:16:\"MaxApertureValue\";s:3:\"7/2\";s:12:\"MeteringMode\";i:2;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"56/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'8069wf86l6jujxj2oq2y41ewaxmylt7'),(3031,'Untagged-Images---percent-done.png','20050121224820!Untagged_Images_-_percent_done.png',3186,400,304,8,'97.8% : 1078 remaining at Fri January 21 06:01:01 2005',88976,'Kbh3rd','20050121063037','0','BITMAP','image','png',0,'9yx9eux06umqca0lxvum6fzjl6z4l1z'),(3032,'Studebakerlark.jpg','20050122004849!Studebakerlark.jpg',23621,370,309,8,'',96074,'Stude62','20050122004250','0','BITMAP','image','jpeg',0,'ltotlppfy33br09yqckhjz35g86gq1a'),(3033,'Studewagonaire63.jpg','20050122021736!Studewagonaire63.jpg',13204,337,179,8,'1963 Studebaker Wagonaire Station Wagon ',96074,'Stude62','20050120033138','0','BITMAP','image','jpeg',0,'pji0ob4lepc892o5xhpt0uujku2l9df'),(3034,'Ph-seal-nueva-ecija.png','20050122022228!Ph_seal_nueva_ecija.png',19150,150,150,8,'Provincial seal of [[Nueva Ecija]], [[Philippines]]. {{coatofarms}}',148639,'TheCoffee','20050119090908','0','BITMAP','image','png',0,'l22vncwpmwku55tdp3qfiaa5vvlif09'),(3035,'Ph-seal-quezon.png','20050122022749!Ph_seal_quezon.png',16435,150,150,8,'Provincial seal of [[Quezon]], [[Philippines]]. {{coatofarms}}',148639,'TheCoffee','20050119090302','0','BITMAP','image','png',0,'65k2ovq215vs6rnvzi2x3priousugqo'),(3036,'Yes---Union.jpg','20050122025322!Yes_-_Union.jpg',8887,200,200,8,'Cover for album \'\'[[Union (album)|Union]]\'\' by [[Yes (band)|Yes]]. {{albumcover}}',110766,'DCEdwards1966','20041112051801','0','BITMAP','image','jpeg',0,'jj1fwouot1u3zlup02c950yjz6u7p9j'),(3037,'Sandoverjacket.JPG','20050122030934!Sandoverjacket.JPG',32078,272,418,8,'fair use of jacket cover for \"The Changing Light at Sandover\" (1982)',157182,'Sandover','20050120210449','0','BITMAP','image','jpeg',0,'600c2cssf1j9dg7z4txuxmc0x66vk29'),(3038,'Sandoverjacket.JPG','20050122031635!Sandoverjacket.JPG',20562,204,314,8,'replacement JPG (smaller) for \'Changing Light at Sandover\' jacket cover',157182,'Sandover','20050122030934','0','BITMAP','image','jpeg',0,'ifg9b14dw2m0d2c5z2x61thpkusc8cj'),(3039,'Craters-of-the-Moon-National-Monument-2000px.jpeg','20050122044026!Craters_of_the_Moon_National_Monument-2000px.jpeg',50878,2000,514,8,'Image taken in July 2004 by [[user:maveric149|Daniel Mayer]].<br><br>{{msg:GFDL}}<br>{{msg:cc-by-sa}}\n',62,'Mav','20040720033738','0','BITMAP','image','jpeg',0,'ef62squcw6d8yetljea38myf3ao4lfj'),(3040,'Divinecomedies.JPG','20050122053737!Divinecomedies.JPG',27069,295,198,8,'Divine Comedies cover image',157182,'Sandover','20050122025436','a:25:{s:4:\"Make\";s:5:\"NIKON\";s:5:\"Model\";s:4:\"E995\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:8:\"DateTime\";s:19:\"2005:01:05 19:36:48\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/353\";s:7:\"FNumber\";s:5:\"26/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"0000:00:00 00:00:00\";s:17:\"DateTimeDigitized\";s:19:\"0000:00:00 00:00:00\";s:22:\"CompressedBitsPerPixel\";s:3:\"4/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:4:\"0/10\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"82/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'dlz2pkx81x7ziixpcy0hzsm28bpg022'),(3041,'GermanBreakthroughUSArmy.png','20050122071105!GermanBreakthroughUSArmy.png',77725,795,2715,8,'',122335,'119','20050122070933','0','BITMAP','image','png',0,'2qz9zxm7855fywivt0abnvn1l4wer4e'),(3042,'Taipei-MRT-(English-Tongyong-Pinyin).gif','20050122133034!Taipei_MRT_(English-Tongyong_Pinyin).gif',154671,2468,1830,0,'Simply made by myself',169744,'Taiwan Junior','20050115033923','0','BITMAP','image','gif',0,'0b86vaxedtdkvhl6bpb2lynrhlt4e2p'),(3043,'Taipei-MRT-(English-Hanyu-Pinyin).gif','20050122134747!Taipei_MRT_(English-Hanyu_Pinyin).gif',154439,2468,1830,0,'Simply made by myself',169744,'Taiwan Junior','20050115035256','0','BITMAP','image','gif',0,'mb046pl6l28wudqqm8v7d0kdn5y2zqh'),(3044,'Taipei-MRT-(English-Tongyong-Pinyin).gif','20050122135754!Taipei_MRT_(English-Tongyong_Pinyin).gif',155049,2468,1830,0,'Simply made by myself',169744,'Taiwan Junior','20050122133034','0','BITMAP','image','gif',0,'4nui3890pcvydgsjnv6bsewzbfqt557'),(3045,'Taipei-MRT-(English-Hanyu-Pinyin).gif','20050122140001!Taipei_MRT_(English-Hanyu_Pinyin).gif',154640,2468,1830,0,'Simply made by myself',169744,'Taiwan Junior','20050122134748','0','BITMAP','image','gif',0,'nn6nkp94cg2zjretp7b2ax703tdbsot'),(3046,'Taipei-MRT-(English-Tongyong-Pinyin).gif','20050122140605!Taipei_MRT_(English-Tongyong_Pinyin).gif',155049,2468,1830,0,'Simply made by myself',169744,'Taiwan Junior','20050122135756','0','BITMAP','image','gif',0,'4nui3890pcvydgsjnv6bsewzbfqt557'),(3047,'Verbena-hastata.jpg','20050122142530!Verbena_hastata.jpg',9994,310,408,8,'[[Vervain]] - USGS photo',38759,'MPF','20050122142114','0','BITMAP','image','jpeg',0,'0kz4zhi88t71m1l1r33ar1qbykm98cv'),(3048,'Mexico-metro-l1.png','20050122231202!Mexico_metro_l1.png',51946,1145,316,8,'Mexico City Metro, line 1 map',162413,'Panchosama','20050121231858','0','BITMAP','image','png',0,'r6oxqqbznpjnf2loj4oejhl9o8sy3mx'),(3049,'Crystalis-gameplay.png','20050123073315!Crystalis_gameplay.png',3506,248,218,4,'Gameplay screenshot from Crystalis for the Nintendo Entertainment System (NES) {{screenshot}}',90619,'Mr Person','20040930050849','0','BITMAP','image','png',0,'hoiek32sallw6mff0z8gpmmjbji5qng'),(3050,'Taiwan-aborigine-en.jpg','20050123074415!Taiwan_aborigine_en.jpg',23757,341,498,8,'rm Fujianese islands and label and touchup',10049,'Jiang','20040822014531','0','BITMAP','image','jpeg',0,'g73z7tycsew0m8s5s1xem9c262l6hj4'),(3051,'Taiwan-aborigine-en.jpg','20050123075225!Taiwan_aborigine_en.jpg',33243,341,498,8,'{{GFDL}}',106942,'Mababa','20050123074415','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"96/1\";s:11:\"YResolution\";s:4:\"96/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2005:01:22 23:43:38\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'klwwx2vlwjzot5br8kztkjfeangitih'),(3052,'Taiwan-aborigine-en.jpg','20050123075314!Taiwan_aborigine_en.jpg',33243,341,498,8,'{{GFDL}}',106942,'Mababa','20050123075225','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"96/1\";s:11:\"YResolution\";s:4:\"96/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2005:01:22 23:43:38\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'klwwx2vlwjzot5br8kztkjfeangitih'),(3053,'NES-Rad-Racer.png','20050123081328!NES_Rad_Racer.png',7678,256,240,8,'\'\'[[Rad Racer]]\'\' for the [[Nintendo Entertainment System]] {{screenshot}}',132265,'Seancdaug','20050123080706','0','BITMAP','image','png',0,'p07c9mk52umb8uo6qrha70udrva9mtp'),(3054,'Rcr-gameplay.png','20050123083258!Rcr_gameplay.png',1848,248,183,4,'River City Ransom gameplay screenshot {{fairuse}}',90619,'Mr Person','20040830225049','0','BITMAP','image','png',0,'75e50w20k5a6hj2ek6x8nfjtr7nn36p'),(3055,'Heracles-Shukongoshin.JPG','20050123121954!Heracles-Shukongoshin.JPG',75092,874,378,8,'',48296,'PHG','20050123115055','0','BITMAP','image','jpeg',0,'28kni47iq4wp89c9woonb258dw143sn'),(3056,'Toronto-gno.jpg','20050123145610!Toronto_gno.jpg',6291,170,170,8,'',173677,'Flurng','20050123063232','0','BITMAP','image','jpeg',0,'ppbfgwmjue5l243esjkt6xjgaus9mm1'),(3057,'NES-Three-Kingdoms.png','20050123170346!NES_Three_Kingdoms.png',32576,512,480,8,'\'\'[[Romance of the Three Kingdoms]]\'\' for the [[Nintendo Entertainment System]] {{screenshot}}',132265,'Seancdaug','20050123164330','0','BITMAP','image','png',0,'la96j30s9zhqk7oee3r42y8upes16uh'),(3058,'NES-Startropics.png','20050123170410!NES_Startropics.png',44281,512,480,8,'\'\'[[Startropics]]\'\' for the [[Nintendo Entertainment System]] {{screenshot}}',132265,'Seancdaug','20050123164313','0','BITMAP','image','png',0,'kqs3zih5q897soh6u18oiubb5qk8mfe'),(3059,'Usinprogress.PNG','20050123211209!Usinprogress.PNG',34142,280,183,8,'update',35314,'Seth Ilys','20050101214621','0','BITMAP','image','png',0,'gyv5b606yujl6a28neefc6vxfyode72'),(3060,'Location-of-Callao-region.png','20050124014543!Location_of_Callao_region.png',30386,238,347,8,'Location of the Callao region in Peru',148190,'StarbucksFreak','20050110183344','0','BITMAP','image','png',0,'6n8o1eg1olbfqoazg0t4n4pun97og18'),(3061,'Mexico-metro-l2.png','20050124031301!Mexico_metro_l2.png',78691,766,1112,8,'Mexico City Metro, line 2 map',162413,'Panchosama','20050121232529','0','BITMAP','image','png',0,'73qpg54n2eq7lut66twsjg3l8w1kb1c'),(3062,'Kevlar-chemical-structure.png','20050124090401!Kevlar_chemical_structure.png',4179,404,197,8,'',83784,'Cacycle','20040819205516','0','BITMAP','image','png',0,'3l4vfexlmsax98dhmoscdi46zxuq4f6'),(3063,'Floater.jpg','20050124113837!Floater.jpg',4227,426,426,8,'Artist\'s impression of a \"string-of-pearls\" floater',21036,'Dpbsmith','20050124024455','0','BITMAP','image','jpeg',0,'314r0iaj6g2mjl7xhbiilh1jzfjbdfa'),(3064,'LeicesterClockTower.jpg','20050124192439!LeicesterClockTower.jpg',9204,177,613,8,'clock tower, leicester',17287,'Morwen','20031031204656','0','BITMAP','image','jpeg',0,'abfcp1f3521a63nfdn9jff5v985park'),(3065,'Feb20532.JPG','20050124220712!Feb20532.JPG',602971,1734,1134,8,'',91445,'Glenlarson','20050124220523','0','BITMAP','image','jpeg',0,'7ucti5l39nmpwulp4i819yo1klwsper'),(3066,'Cartdivr.jpg','20050124225055!Cartdivr.jpg',42478,386,1080,8,'simple Cartesan diver experiment',48904,'Finn-Zoltan','20050124224233','0','BITMAP','image','jpeg',0,'16a8teku1gt1aokl0gb69660qg0tiur'),(3067,'Cartdivr.jpg','20050124225849!Cartdivr.jpg',13768,193,540,8,'simple Cartesan diver experiment',48904,'Finn-Zoltan','20050124225057','0','BITMAP','image','jpeg',0,'7shkhkrb080q2jpmwtfg77neny3wxvt'),(3068,'Floater.jpg','20050125003056!Floater.jpg',1744,200,200,8,'Revised version',21036,'Dpbsmith','20050124113837','0','BITMAP','image','jpeg',0,'qq168if10c58rpz897p37v5aelwb3dj'),(3069,'Floater.jpg','20050125003220!Floater.jpg',6234,250,250,8,'Artist\'s impression of appearance of ocular floaters',21036,'Dpbsmith','20050125003057','0','BITMAP','image','jpeg',0,'8ii5wriotqk5i0qbdi9vbiwjstwhsaw'),(3070,'MxPx-On-The-Cover-CD-cover.JPG','20050125012633!MxPx_On_The_Cover_CD_cover.JPG',8253,130,130,8,'cd cover for mxpx - on the cover',175788,'Silic0N','20050125011940','0','BITMAP','image','jpeg',0,'qowdsd6b75o3ct20v00bp2y085u7mrr'),(3071,'Floater.jpg','20050125022414!Floater.jpg',6234,250,250,8,'',21036,'Dpbsmith','20050125003221','0','BITMAP','image','jpeg',0,'8ii5wriotqk5i0qbdi9vbiwjstwhsaw'),(3072,'MKDE-model.png','20050125024100!MKDE_model.png',3265,446,272,8,'',75749,'Ta bu shi da yu','20041223224045','0','BITMAP','image','png',0,'in41db75h084hadvoeenkc5bzw4pbjq'),(3073,'Mexico-metro-l3.png','20050125050521!Mexico_metro_l3.png',60588,508,1423,8,'Mexico City Metro, line 3 map',162413,'Panchosama','20050121232852','0','BITMAP','image','png',0,'3u9a1i53haut73ltpzd80120wez08jz'),(3074,'Mexico-metro-l4.png','20050125050609!Mexico_metro_l4.png',32756,320,898,8,'Mexico City Metro, line 4 map',162413,'Panchosama','20050122040955','0','BITMAP','image','png',0,'peq5y6mv8ma0s4pcfv8xto0zlu1nk3y'),(3075,'Bowland-sunset.jpg','20050125105007!Bowland_sunset.jpg',448950,2962,1058,8,'my photo forest of bowland',91228,'Soloist','20050125104434','0','BITMAP','image','jpeg',0,'h2hdqj9iitywmprq89rw4n0u5bxla5n'),(3076,'Exoendo.png','20050125154140!Exoendo.png',67773,222,364,8,'Image created by Tsujigiri on January 25, 2004.',88005,'Tsujigiri','20050125131841','0','BITMAP','image','png',0,'4dtclvgogwbnbl3vqly9ehc2ejbgwkt'),(3077,'NES-Mario-is-Missing.png','20050125213422!NES_Mario_is_Missing.png',9737,256,240,8,'\'\'[[Mario is Missing]]\'\' for the [[Nintendo Entertainment System]] {{screenshot}}',132265,'Seancdaug','20050124040620','0','BITMAP','image','png',0,'l6zu08zhkvk4lskcn21p5t0doa75mmf'),(3078,'Galantamine.png','20050125235009!Galantamine.png',7109,337,149,8,'Galantamine molecular structure',142240,'Philipc','20041127144432','0','BITMAP','image','png',0,'m8bqr7cr9irculh3yhszmnj6tu1awgf'),(3079,'Blake-Ross-WIRED-cover.jpeg','20050126041343!Blake_Ross_WIRED_cover.jpeg',22042,136,162,8,'Cover of WIRED Magazine featuring Blake Ross',58006,'Joeblakesley','20050125053728','0','BITMAP','image','jpeg',0,'5du6gpt0tj0wzkvoyt6c6ku1xdaaj2l'),(3080,'Alexander-James-Begg.jpg','20050126050522!Alexander_James_Begg.jpg',30957,576,432,8,'[[December 15]], [[2004]]',96850,'AlexTheMartian','20050106091944','0','BITMAP','image','jpeg',0,'k0333e9ppp3yorj8yi2k6au0g7ttwh4'),(3081,'Alexander-James-Begg.jpg','20050126052040!Alexander_James_Begg.jpg',39493,450,600,8,'[[January 23]], [[2005]]',96850,'AlexTheMartian','20050126050522','0','BITMAP','image','jpeg',0,'53xui8ynjcr7c70x47ia6aaeiwpnzmq'),(3082,'Math-stub-image.png','20050126093421!Math_stub_image.png',687,95,45,8,'math stub image, TeX rendering from Wikipedia page',76,'The Anome','20050126092853','0','BITMAP','image','png',0,'gu065gue5v5p7xnj3z4i6ygoxii24bi'),(3083,'Knowledge-visualization-framework-burkhard.gif','20050126094646!Knowledge_visualization_framework_burkhard.gif',17436,960,325,5,'Knowledge Visualization Framework by Remo Burkhard',176942,'Burkhard','20050126093455','0','BITMAP','image','gif',0,'iwbzvy0gm9dp2q8b3ezk875u3hd3zv4'),(3084,'Knowledge-visualization-model-burkhard.gif','20050126094727!Knowledge_visualization_model_burkhard.gif',111885,2891,1408,8,'Knowledge Visualization Model by Remo Burkhard',176942,'Burkhard','20050126093726','0','BITMAP','image','gif',0,'4hrivvnrr301uf5tsn7x4lwjdr9yscx'),(3085,'Qsci.jpg','20050126134849!Qsci.jpg',13870,200,295,8,'QCSHS logo',176962,'Ciaomarco','20050126132611','0','BITMAP','image','jpeg',0,'mzlnfghfsa8rbvkyy4bvha7so322htn'),(3086,'Disambig-fork.png','20050126173611!Disambig_fork.png',1161,40,31,8,'I made this.  It is public domain.  See my user page for details. - ~~~~ <br> {{PD}}',18931,'Omegatron','20050126172147','0','BITMAP','image','png',0,'9eh8yqcskrm29vyt4bm52ihyzw01oei'),(3087,'Iraqi-election.jpg','20050126181620!Iraqi_election.jpg',18139,431,284,8,'Street sign in Southgate, Michigan giving directions to polling place {{GFDL}} Photo by rmhermen',835,'Rmhermen','20050126180512','0','BITMAP','image','jpeg',0,'iexh25a0n5eqn55zrzzomfi06qsyhv0'),(3088,'Van-Speyk-shoots-at-gunpowder.jpg','20050126211059!Van_Speyk_shoots_at_gunpowder.jpg',15973,472,371,8,'Fixed contrast/brightness, rm frame, rotate 0.25 degrees counterclockwise.',81121,'RedWordSmith','20041102023147','0','BITMAP','image','jpeg',0,'6tyhgjkr75q5bq5xkq461szzsy09ku8'),(3089,'Ronald-Reagan.jpg','20050127001748!Ronald_Reagan.jpg',47164,514,640,8,'Official White Portrait of U.S. President Ronald Reagan. Provided by the \"American Memory\" collection of the Library of Congress, as part of the \"By Popular Demand: Portraits of the Presidents and First Ladies, 1789-Present\" database. {{PD-USGov-POTUS}}',68411,'Neutrality','20050127001453','0','BITMAP','image','jpeg',0,'jwiadza8prspjyzguxkgvulh9a5m760'),(3090,'E34-front.jpg','20050127045625!E34-front.jpg',1493822,2048,1536,8,'1994 BMW 525i (E34 body style) front 3/4 view',177618,'DonIncognito','20050127045231','a:31:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:7:\"DSC-P93\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:11:13 10:03:41\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/2000\";s:7:\"FNumber\";s:5:\"71/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:11:13 10:03:41\";s:17:\"DateTimeDigitized\";s:19:\"2004:11:13 10:03:41\";s:22:\"CompressedBitsPerPixel\";s:3:\"8/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"48/16\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:6:\"136/10\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"SceneCaptureType\";i:0;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'1fm9k7m9ne4siptqbpnvwj2gdlf4y8s'),(3091,'Bilbao-metro-map.png','20050127053109!Bilbao-metro-map.png',21165,825,401,8,'Bilbao metro map, created by Montrealais (see image for copyright info and GNU release)',3378,'Montrealais','20031208083009','0','BITMAP','image','png',0,'2c82mg15rjogadmu93eez9jdkdogk9b'),(3092,'Jjonahjameson.jpg','20050127071031!Jjonahjameson.jpg',33907,194,282,8,'',44846,'Gamaliel','20040907214425','0','BITMAP','image','jpeg',0,'ihhicsjnv8asryl5p4jjm3m5kwihsd4'),(3093,'Jjonahjameson.jpg','20050127071441!Jjonahjameson.jpg',54116,194,282,8,'cleaning up scanning artefacts',66,'Bryan Derksen','20050127071031','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"100/1\";s:11:\"YResolution\";s:5:\"100/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2005:01:27 00:13:30\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'1x5pxuobec76bj7582d0wchl4a1znld'),(3094,'Triglyceride-GeneralStructure.png','20050127102939!Triglyceride-GeneralStructure.png',3541,373,232,8,'{{PD-self}}',104525,'Jag123','20050127102634','0','BITMAP','image','png',0,'iby6pmhf5jg90jd70g51mm66pmdfqin'),(3095,'DS1-ESF-frame.png','20050127143313!DS1_ESF_frame.png',22086,677,644,8,'DS1 ESF Frame Diagram',177313,'Victor Snesarev','20050127140149','0','BITMAP','image','png',0,'02bo6m5fchttsbmbotzalfmuuabdyfj'),(3096,'FoolsGoldWhatTheWorldIsWaitingFor.jpg','20050127170631!FoolsGoldWhatTheWorldIsWaitingFor.jpg',18354,275,275,8,'{{albumcover}}',166784,'Madchester','20050127163103','0','BITMAP','image','jpeg',0,'06r9ul7eqht8yzn5lsgyzrhui573xyt'),(3097,'Missouri-Kansas-Texas-locomotive-142.jpg','20050128033821!Missouri_Kansas_Texas_locomotive_142.jpg',145152,1017,539,8,'Missouri Kansas Texas (MKT) locomotive #142  {{GFDL}}',107140,'Rmeier','20041130031801','0','BITMAP','image','jpeg',0,'51jhhj24grcmhbjzgt5h14o40hv29br'),(3098,'Missouri-Kansas-Texas-locomotive-142.jpg','20050128063338!Missouri_Kansas_Texas_locomotive_142.jpg',124866,801,551,8,'better shot - sunlit this time',107140,'Rmeier','20050128033821','0','BITMAP','image','jpeg',0,'kxxunez1u7xieuxkarmeiylzujn62s2'),(3099,'English-vowels.png','20050128130317!English_vowels.png',8856,372,258,8,'IPA English vowels',48598,'Zhen Lin','20040321073828','0','BITMAP','image','png',0,'oykrutfymo6kkwocbrjhl4pevvi7p4d'),(3100,'English-vowels.png','20050128141657!English_vowels.png',8444,372,258,8,'English vowel chart including missing vowel',84047,'AxSkov','20050128130318','0','BITMAP','image','png',0,'2ipp5iiik2vk1nhxlr6kab6w4fvbsnz'),(3101,'Jerzy-Sebastian-Lubomirski-(1616-1667).jpg','20050128191137!Jerzy_Sebastian_Lubomirski_(1616-1667).jpg',32015,471,550,8,'{{pd}}',60647,'Emax','20041211234531','0','BITMAP','image','jpeg',0,'e64xlcef1o4gjr7yaum984q2g7ogi9u'),(3102,'Sebastian-Lubomirski-(1539-1613).jpg','20050128222333!Sebastian_Lubomirski_(1539-1613).jpg',98243,343,397,8,'{{pd}}',60647,'Emax','20050107021239','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:8:\"DateTime\";s:19:\"2005:01:07 03:08:02\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'nn0grboksbfee2c3lzebd7x1mdgtlt5'),(3103,'RansomScript.png','20050129192304!RansomScript.png',13715,924,67,8,'\"Ransom script effect\" (typography)',69607,'Ojw','20050129191434','0','BITMAP','image','png',0,'nei0mgc4evlgvt1h66mgghpjw6c7fv6'),(3104,'EnPassant.png','20050129201219!EnPassant.png',2199,653,215,8,'En passant diagram, created with WinBoard and GIMP',84326,'TrbleClef','20050129104226','0','BITMAP','image','png',0,'tfjynad51yoq4wib5il4mbs0n5fmeqt'),(3105,'All-Saints-Churchill.jpg','20050129220942!All_Saints_Churchill.jpg',154886,1280,960,8,'All Saints Church, Churchill, Oxfordshire',159495,'Mel Etitis','20050129214905','a:38:{s:4:\"Make\";s:8:\"FUJIFILM\";s:5:\"Model\";s:14:\"FinePix S5000 \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:36:\"Digital Camera FinePix S5000 Ver3.00\";s:8:\"DateTime\";s:19:\"2004:02:08 16:20:41\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:7:\"10/4500\";s:7:\"FNumber\";s:7:\"450/100\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:160;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:02:08 16:20:41\";s:17:\"DateTimeDigitized\";s:19:\"2004:02:08 16:20:41\";s:22:\"CompressedBitsPerPixel\";s:5:\"30/10\";s:17:\"ShutterSpeedValue\";s:7:\"880/100\";s:13:\"ApertureValue\";s:7:\"430/100\";s:15:\"BrightnessValue\";s:7:\"735/100\";s:17:\"ExposureBiasValue\";s:5:\"0/100\";s:16:\"MaxApertureValue\";s:7:\"300/100\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:7:\"570/100\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:6:\"2405/1\";s:21:\"FocalPlaneYResolution\";s:6:\"2405/1\";s:24:\"FocalPlaneResolutionUnit\";i:3;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"SceneCaptureType\";i:0;s:9:\"Sharpness\";i:3;s:20:\"SubjectDistanceRange\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'c82ozixi09bb3k6yjcip085a4ipae8j'),(3106,'BestTwoBand.jpg','20050130001913!BestTwoBand.jpg',22972,330,330,8,'Cover of The Band\'s 2nd greatest hits album.',177359,'BernardWebb','20050130001628','0','BITMAP','image','jpeg',0,'mdzvyvb7ob27di2p7r0qu1yjb2iopzj'),(3107,'Oxaprozin.gif','20050130020124!Oxaprozin.gif',1805,212,117,8,'Oxaprozin',50005,'Rob n','20041222060040','0','BITMAP','image','gif',0,'t9m78wqgj7iaj5vy78o9tv8b5a2nliy'),(3108,'9337063109294732015.jpg','20050130050430!9337063109294732015.jpg',28916,168,235,8,'Frank Hawks (1897-1938) circa   {{pd}}',158051,'Richard Arthur Norton (1958- )','20050130050341','0','BITMAP','image','jpeg',0,'rfnlxdee8vkfn61ap76nhblso65370x'),(3109,'Disneymania3.jpg','20050130075659!Disneymania3.jpg',13009,176,174,8,'',164521,'Bluedame','20050130074853','0','BITMAP','image','jpeg',0,'1kv0pmf57f0hq1afe6g5xehhpqswvvo'),(3110,'Disneymania3.jpg','20050130075742!Disneymania3.jpg',64287,500,496,8,'',164521,'Bluedame','20050130075659','0','BITMAP','image','jpeg',0,'abzsa876bsisby73okdxthge2l9q2s9'),(3111,'Disneymania3.jpg','20050130075828!Disneymania3.jpg',64287,500,496,8,'',164521,'Bluedame','20050130075742','0','BITMAP','image','jpeg',0,'abzsa876bsisby73okdxthge2l9q2s9'),(3112,'Zupy.jpg','20050130093116!Zupy.jpg',322506,910,478,8,'Map of Historical counties of Slovakia',106996,'Kristian Slimak','20041014210729','0','BITMAP','image','jpeg',0,'hfbmbwe8lycvfm2fd7f4gf5l3znjixm'),(3113,'Akranes-pos.png','20050130151312!Akranes_pos.png',20616,300,223,8,'position of Akranes',20332,'Bjarki S','20040410205258','0','BITMAP','image','png',0,'f3q79miiu95boyo6nnnqj54jnqhacuz'),(3114,'Official-logo-uwc.png','20050130161144!Official_logo_uwc.png',48416,800,436,8,'Official logo of the [[United World Colleges]] {{logo}}',113573,'Notafish','20050130160342','0','BITMAP','image','png',0,'kiveqpfig9x3wgvy85b9a8mo6nucvpm'),(3115,'Lord-Leycester-hospital,-Warwick-1.jpg','20050130163637!Lord_Leycester_hospital,_Warwick_1.jpg',270287,1296,972,8,'Lord Leycester Hospital, Warwick',136926,'Velela','20050123224109','0','BITMAP','image','jpeg',0,'dgyq98tziy12dm160kmivb9ahp0s4h6'),(3116,'Lord-Leycester-hospital,-Warwick-1.jpg','20050130165325!Lord_Leycester_hospital,_Warwick_1.jpg',281690,1296,972,8,'enhanced version',8272,'G-Man','20050130163638','0','BITMAP','image','jpeg',0,'1e3rzv8ll3686mdllsbxbqdlmxnmqu7'),(3117,'Westminster-quarters.mid','20050130212052!Westminster-quarters.mid',323,0,0,0,'Midi file of the Westminster Quarters striking six o\'clock (created by ~~~)',3378,'Montrealais','20030814034557','','AUDIO','audio','midi',0,'s17xsu715vrn0izjjg3xsi4fjshn5pt'),(3118,'Westminster-quarters.mid','20050130212204!Westminster-quarters.mid',280,0,0,0,'a midi file of the Westminster Quarters striking six o\'clock',86733,'Ibagli','20050130212053','','AUDIO','audio','midi',0,'aikj1w37igvjm43k5c0tsv0bojn7cyv'),(3119,'Shylock.jpg','20050130220507!Shylock.jpg',55136,308,475,8,'',107928,'Darwinek','20050130220334','0','BITMAP','image','jpeg',0,'lq7wxj7efz0q9lu7zwjtte4v1kftanq'),(3120,'IE-PNG-bug.png','20050130222728!IE_PNG_bug.png',14893,184,92,8,'{{cc-by-2.0}} Original \"IE with a cross\" icon found here: http://www.tbray.org/ongoing/When/200x/2003/07/17/BrowserDream',110454,'Minghong','20050106173538','0','BITMAP','image','png',0,'ox47j7p9wfvg3q94ploe60c1ynd87zl'),(3121,'Rcaf-roundel-old-wht.png','20050131014618!Rcaf_roundel_old_wht.png',23896,300,300,8,'',77722,'N328KF','20040723150600','0','BITMAP','image','png',0,'ip65n3o8160wsomt6not7qalpsex891'),(3122,'5pin180dinplug.jpg','20050131073239!5pin180dinplug.jpg',2888,300,195,8,'5 pin 180 degree DIN plug',8846,'Andrewa','20031111122409','0','BITMAP','image','jpeg',0,'2erm8n1dcbtmhq2gnfhe9hermpky9be'),(3123,'Translink-machine.jpg','20050131091940!Translink_machine.jpg',1487208,2288,1712,8,'{[PD-self}}',74131,'Lacrimosus','20050131085156','0','BITMAP','image','jpeg',0,'8ufpv3ga5uy4n0anhwhhsct1wl3zehj'),(3124,'Jobfora-woman.jpg','20050131123737!Jobfora_woman.jpg',24315,293,475,8,'',107928,'Darwinek','20050131123619','0','BITMAP','image','jpeg',0,'ay0wkahxdspidq6z5btmw4gdb975pko'),(3125,'Ajvwg.jpg','20050131141037!Ajvwg.jpg',64092,390,579,8,'William Gardener from a private collection',175463,'Johnvernon','20050131140312','0','BITMAP','image','jpeg',0,'ql78bdoh6dalit25e3rwq009o3ta5d4'),(3126,'Activation.png','20050131164740!Activation.png',1813,251,253,4,'from meta',4,'Magnus Manske','20020827132632','0','BITMAP','image','png',0,'k60uuhq64qgx3pnpw0pjnbvwen8wa3c'),(3127,'Digitalblasphemy-whitemagic-small.jpg','20050131195954!Digitalblasphemy_whitemagic_small.jpg',39956,350,280,8,'',69607,'Ojw','20050131194154','0','BITMAP','image','jpeg',0,'3rzlluk0grictpry1u0na8o5wijntol'),(3128,'Rio-Darro.JPG','20050131214158!Rio_Darro.JPG',860544,2048,1536,8,'River Darro, Granada, Spain.',181289,'Mys23','20050131212742','a:38:{s:4:\"Make\";s:8:\"FUJIFILM\";s:5:\"Model\";s:14:\"FinePix S3000 \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:37:\"Digital Camera FinePix S3000  Ver1.00\";s:8:\"DateTime\";s:19:\"2005:01:19 10:23:19\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/700\";s:7:\"FNumber\";s:7:\"280/100\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2005:01:19 10:23:19\";s:17:\"DateTimeDigitized\";s:19:\"2005:01:19 10:23:19\";s:22:\"CompressedBitsPerPixel\";s:5:\"20/10\";s:17:\"ShutterSpeedValue\";s:7:\"610/100\";s:13:\"ApertureValue\";s:7:\"300/100\";s:15:\"BrightnessValue\";s:7:\"457/100\";s:17:\"ExposureBiasValue\";s:5:\"0/100\";s:16:\"MaxApertureValue\";s:7:\"300/100\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:16;s:11:\"FocalLength\";s:7:\"600/100\";s:10:\"ColorSpace\";i:1;s:21:\"FocalPlaneXResolution\";s:6:\"3884/1\";s:21:\"FocalPlaneYResolution\";s:6:\"3884/1\";s:24:\"FocalPlaneResolutionUnit\";i:3;s:13:\"SensingMethod\";i:2;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"SceneCaptureType\";i:0;s:9:\"Sharpness\";i:3;s:20:\"SubjectDistanceRange\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'3lsq9ud04cqb0ftj0zliisusw35a02x'),(3129,'Japan-prov-map-bingo.PNG','20050201012759!Japan_prov_map_bingo.PNG',8111,235,300,8,'Small map of Bingo Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021432','0','BITMAP','image','png',0,'rcoez9mochjbe7gz4z6ujoygwqzqd1a'),(3130,'Japan-prov-map-bitchu.PNG','20050201012825!Japan_prov_map_bitchu.PNG',8116,235,300,8,'Small map of Bitchu Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021446','0','BITMAP','image','png',0,'k9gya94rsdtrxowgb4d36w3jkmdi8pl'),(3131,'Japan-prov-map-bizen.PNG','20050201012848!Japan_prov_map_bizen.PNG',8118,235,300,8,'Small map of Bizen Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021456','0','BITMAP','image','png',0,'lgohhb324v9kbymnjwglhvpkkia7f8e'),(3132,'Japan-prov-map-bungo.PNG','20050201012931!Japan_prov_map_bungo.PNG',8106,235,300,8,'Small map of Bungo Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021506','0','BITMAP','image','png',0,'n4em0ojx2ahayp1pywlu8nk7u8i2a2b'),(3133,'Japan-prov-map-buzen.PNG','20050201012940!Japan_prov_map_buzen.PNG',8117,235,300,8,'Small map of Buzen Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021515','0','BITMAP','image','png',0,'5tlysmunnhrexydewodtgc80k7ttmbl'),(3134,'Japan-prov-map-chikugo.PNG','20050201012949!Japan_prov_map_chikugo.PNG',8111,235,300,8,'Small map of Chikugo Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021527','0','BITMAP','image','png',0,'hdeh2u98zt2o4waw92j7neqs1rnjhv4'),(3135,'Japan-prov-map-chikuzen.PNG','20050201013003!Japan_prov_map_chikuzen.PNG',8111,235,300,8,'Small map of Chikuzen Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021537','0','BITMAP','image','png',0,'9qqpwov3xuleuj53jd750xj71ncuxs6'),(3136,'Japan-prov-map-dewa.PNG','20050201013017!Japan_prov_map_dewa.PNG',8075,235,300,8,'Small map of Dewa Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021547','0','BITMAP','image','png',0,'jstujn1m0z0jw3z0x4mlt9avwwvhl3b'),(3137,'Japan-prov-map-echigo.PNG','20050201013029!Japan_prov_map_echigo.PNG',8110,235,300,8,'Small map of Echigo Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021557','0','BITMAP','image','png',0,'p2endrfpfp10y3glko9110b8ki96r2c'),(3138,'Japan-prov-map-echizen.PNG','20050201013038!Japan_prov_map_echizen.PNG',8114,235,300,8,'Small map of Echizen Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021606','0','BITMAP','image','png',0,'ksapeynszqvoo1juzvv7t5wkqqblkb3'),(3139,'Japan-prov-map-etchu.PNG','20050201013048!Japan_prov_map_etchu.PNG',8114,235,300,8,'Small map of Etchu Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021615','0','BITMAP','image','png',0,'gpnz0l3zowbs2vg4n8b5pdx1ixwuwq9'),(3140,'Japan-prov-map-harima.PNG','20050201013056!Japan_prov_map_harima.PNG',8115,235,300,8,'Small map of Harima Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021639','0','BITMAP','image','png',0,'91l8r6gszm8xrpev8krr6x4j3syc9rh'),(3141,'Japan-prov-map-hida.PNG','20050201013104!Japan_prov_map_hida.PNG',8120,235,300,8,'Small map of Hida Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021648','0','BITMAP','image','png',0,'5g7wn1zkjvydgbjab1kmgue7m5vh6uc'),(3142,'Japan-prov-map-higo.PNG','20050201013118!Japan_prov_map_higo.PNG',8112,235,300,8,'Small map of Higo Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021656','0','BITMAP','image','png',0,'ml4c7pju7g4y3dazk6p0llmbqqjfrb1'),(3143,'Japan-prov-map-hitachi.PNG','20050201013136!Japan_prov_map_hitachi.PNG',8123,235,300,8,'Small map of Hitachi Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021704','0','BITMAP','image','png',0,'b4jvr13nwgbe4edlcw6h18ziyo1ys1s'),(3144,'Japan-prov-map-hizen.PNG','20050201013156!Japan_prov_map_hizen.PNG',8104,235,300,8,'Small map of Hizen Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021712','0','BITMAP','image','png',0,'b1lj5jl6d9qm3rfqysswkv2152w4f6v'),(3145,'Japan-prov-map-hoki.PNG','20050201013206!Japan_prov_map_hoki.PNG',8110,235,300,8,'Small map of Hoki Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021720','0','BITMAP','image','png',0,'d0w8evm60462whxba11z7dxqyhxl7po'),(3146,'Japan-prov-map-hyuga.PNG','20050201013217!Japan_prov_map_hyuga.PNG',8112,235,300,8,'Small map of Hyuga Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021729','0','BITMAP','image','png',0,'aca8uhi3nrfo5p81kjferaajaevo4oh'),(3147,'Japan-prov-map-iga.PNG','20050201013225!Japan_prov_map_iga.PNG',8113,235,300,8,'Small map of Iga Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021740','0','BITMAP','image','png',0,'dqj01tzww7c0hzhp4m03am7wwl2mps0'),(3148,'Japan-prov-map-iki.PNG','20050201013232!Japan_prov_map_iki.PNG',8159,235,300,8,'Small map of Iki Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021759','0','BITMAP','image','png',0,'cmjopagynmrkru20z5fnde0fvgwzlze'),(3149,'Japan-prov-map-inaba.PNG','20050201013246!Japan_prov_map_inaba.PNG',8115,235,300,8,'Small map of Inaba Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021813','0','BITMAP','image','png',0,'muv8wyve0iuuhz6n7ny5wr7aqr0ng2i'),(3150,'Japan-prov-map-ise.PNG','20050201013255!Japan_prov_map_ise.PNG',8127,235,300,8,'Small map of Ise Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021826','0','BITMAP','image','png',0,'90jezcvpuvyjkriqfg7nbvc7e7oo8ti'),(3151,'Japan-prov-map-iwami.PNG','20050201013306!Japan_prov_map_iwami.PNG',8117,235,300,8,'Small map of Iwami Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021836','0','BITMAP','image','png',0,'7erxdzme15ru95g1knoyeb5y50dfjdh'),(3152,'Japan-prov-map-iyo.PNG','20050201013314!Japan_prov_map_iyo.PNG',8107,235,300,8,'Small map of Iyo Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021844','0','BITMAP','image','png',0,'cie7xj6hjglrl9yo8sfm801owbbcmmg'),(3153,'Japan-prov-map-izu.PNG','20050201013403!Japan_prov_map_izu.PNG',8119,235,300,8,'Small map of Izu Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021857','0','BITMAP','image','png',0,'0o8nmj7gjcwnbvy35su68nkkro6znig'),(3154,'Japan-prov-map-izumi.PNG','20050201013419!Japan_prov_map_izumi.PNG',8122,235,300,8,'Small map of Izumi Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021909','0','BITMAP','image','png',0,'pll1rao53w5petyh4w43779o7tp14kh'),(3155,'Japan-prov-map-izumo.PNG','20050201013505!Japan_prov_map_izumo.PNG',8111,235,300,8,'Small map of Izumo Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021922','0','BITMAP','image','png',0,'beskja7fq5k1ah9vsn4h7nfy7ntioka'),(3156,'Japan-prov-map-kaga.PNG','20050201013514!Japan_prov_map_kaga.PNG',8112,235,300,8,'Small map of Kaga Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129021935','0','BITMAP','image','png',0,'7cxvjtu2ja961twl97jgr4qk1h8p0tj'),(3157,'Japan-prov-map-kawachi.PNG','20050201013556!Japan_prov_map_kawachi.PNG',8110,235,300,8,'Small map of Kawachi Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022001','0','BITMAP','image','png',0,'4t9ib2cczif2x1pryssenbjfnp5gxoz'),(3158,'Japan-prov-map-kazusa.PNG','20050201013610!Japan_prov_map_kazusa.PNG',8102,235,300,8,'Small map of Kazusa Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022024','0','BITMAP','image','png',0,'m25imbexcj2ny2khsqtom3du1okhw82'),(3159,'Japan-prov-map-kii.PNG','20050201013639!Japan_prov_map_kii.PNG',8123,235,300,8,'Small map of Kii Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022049','0','BITMAP','image','png',0,'dbtovn699zalrpqyvgejcpzx5n96nly'),(3160,'Japan-prov-map-kozuke.PNG','20050201013734!Japan_prov_map_kozuke.PNG',8096,235,300,8,'Small map of Kozuke Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022102','0','BITMAP','image','png',0,'rklcj5gp9x6z6ohpc0dv2yee3mxa8tj'),(3161,'Japan-prov-map-mimasaka.PNG','20050201013842!Japan_prov_map_mimasaka.PNG',8113,235,300,8,'Small map of Mimasaka Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022207','0','BITMAP','image','png',0,'mygy5da1bts4t33cj2aejk2is65fsxn'),(3162,'Japan-prov-map-musashi.PNG','20050201013910!Japan_prov_map_musashi.PNG',8098,235,300,8,'Small map of Musashi Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022223','0','BITMAP','image','png',0,'l4vsnzro5y5d0dk681tleinbxsmsnmn'),(3163,'Japan-prov-map-mutsu.PNG','20050201013919!Japan_prov_map_mutsu.PNG',8093,235,300,8,'Small map of Mutsu Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022232','0','BITMAP','image','png',0,'2upg5oiny0hhkouxzzsnmzpvzdu8w3l'),(3164,'Japan-prov-map-nagato.PNG','20050201013929!Japan_prov_map_nagato.PNG',8117,235,300,8,'Small map of Nagato Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022242','0','BITMAP','image','png',0,'l1ev3xjmqr47e2k4gt2vric7b3eqwas'),(3165,'Japan-prov-map-noto.PNG','20050201013938!Japan_prov_map_noto.PNG',8100,235,300,8,'Small map of Noto Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022251','0','BITMAP','image','png',0,'tuikx0f5szfkq46kb3xeplnu12i9xq4'),(3166,'Japan-prov-map-oki.PNG','20050201013948!Japan_prov_map_oki.PNG',8189,235,300,8,'Small map of Oki Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022301','0','BITMAP','image','png',0,'bu4nppbd0b00yyzwlo2da4lzo2pwyta'),(3167,'Japan-prov-map-omi.PNG','20050201013957!Japan_prov_map_omi.PNG',8124,235,300,8,'Small map of Omi Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022317','0','BITMAP','image','png',0,'cgwy84vely5mgq9ffkzjc5ozit5uujj'),(3168,'Japan-prov-map-osumi.PNG','20050201014011!Japan_prov_map_osumi.PNG',8106,235,300,8,'Small map of Osumi Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022326','0','BITMAP','image','png',0,'k7qp98mt85bth3azznmiif4hn2pa10o'),(3169,'Japan-prov-map-sado.PNG','20050201014027!Japan_prov_map_sado.PNG',8143,235,300,8,'Small map of Sado Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022353','0','BITMAP','image','png',0,'nduvrjkmzat53l43jfjstrth7qz9jpm'),(3170,'Japan-prov-map-sagami.PNG','20050201014038!Japan_prov_map_sagami.PNG',8124,235,300,8,'Small map of Sagami Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022402','0','BITMAP','image','png',0,'4ykwop3ov332w2qjk65xxp7coj3vtc4'),(3171,'Japan-prov-map-sanuki.PNG','20050201014057!Japan_prov_map_sanuki.PNG',8114,235,300,8,'Small map of Sanuki Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022411','0','BITMAP','image','png',0,'55psn26g81fmtndfj8psi2hrd4j1jam'),(3172,'Japan-prov-map-satsuma.PNG','20050201014104!Japan_prov_map_satsuma.PNG',8115,235,300,8,'Small map of Satsuma Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022422','0','BITMAP','image','png',0,'3x9ufbmcea7rnyhm6idmpd5gnuymth7'),(3173,'Japan-prov-map-shima.PNG','20050201014127!Japan_prov_map_shima.PNG',8140,235,300,8,'Small map of Shima Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022444','0','BITMAP','image','png',0,'btv91vao1imsgwicgz4mke8e1ihytqc'),(3174,'Japan-prov-map-shimosa.PNG','20050201014136!Japan_prov_map_shimosa.PNG',8101,235,300,8,'Small map of Shimosa Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022453','0','BITMAP','image','png',0,'5bvsmf8032ck8hquep628i1kntvnwct'),(3175,'Japan-prov-map-shimotsuke.PNG','20050201014144!Japan_prov_map_shimotsuke.PNG',8097,235,300,8,'Small map of Shimotsuke Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022503','0','BITMAP','image','png',0,'sdddnajiebt44pa529smacajmm3xcyk'),(3176,'Japan-prov-map-shinano.PNG','20050201014153!Japan_prov_map_shinano.PNG',8119,235,300,8,'Small map of Shinano Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022511','0','BITMAP','image','png',0,'719z61shocsbovbczmofik2qdb43aqm'),(3177,'Japan-prov-map-suo.PNG','20050201014202!Japan_prov_map_suo.PNG',8113,235,300,8,'Small map of Suo Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022520','0','BITMAP','image','png',0,'jy7b0072pslazjdhzaccx4nugnf04vl'),(3178,'Japan-prov-map-tajima.PNG','20050201014219!Japan_prov_map_tajima.PNG',8115,235,300,8,'Small map of Tajima Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022538','0','BITMAP','image','png',0,'by3bjsalbfqoiydcb2yi02q8xa8mc68'),(3179,'Japan-prov-map-tamba.PNG','20050201014228!Japan_prov_map_tamba.PNG',8111,235,300,8,'Small map of Tamba Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022551','0','BITMAP','image','png',0,'4wxfmpxd8zitb11hcc0gy5c74ooatvi'),(3180,'Japan-prov-map-tango.PNG','20050201014235!Japan_prov_map_tango.PNG',8113,235,300,8,'Small map of Tango Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022600','0','BITMAP','image','png',0,'pdze4n72jsa3cw71ta05ewzvl0dor67'),(3181,'Japan-prov-map-tosa.PNG','20050201014243!Japan_prov_map_tosa.PNG',8131,235,300,8,'Small map of Tosa Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022609','0','BITMAP','image','png',0,'7akiy64q38p9ferghhy76n516ao7xkt'),(3182,'Japan-prov-map-totomi.PNG','20050201014255!Japan_prov_map_totomi.PNG',8103,235,300,8,'Small map of Totomi Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022617','0','BITMAP','image','png',0,'7m6q68mfg6i2uav9fdrwju7gtta2r4w'),(3183,'Japan-prov-map-tsushima.PNG','20050201014303!Japan_prov_map_tsushima.PNG',8165,235,300,8,'Small map of Tsushima Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022626','0','BITMAP','image','png',0,'olm574fhkob6p1d5a67zk16yq7j2lw1'),(3184,'Japan-prov-map-wakasa.PNG','20050201014329!Japan_prov_map_wakasa.PNG',8209,235,300,8,'Small map of Wakasa Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022636','0','BITMAP','image','png',0,'stby46qjif1xot60ufggbyo4lppt9d2'),(3185,'Japan-prov-map-yamashiro.PNG','20050201014401!Japan_prov_map_yamashiro.PNG',8114,235,300,8,'Small map of Yamashiro Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022645','0','BITMAP','image','png',0,'3kzgihj22w4btd3zz5s5yufzoypeuvp'),(3186,'Japan-prov-map-yamato.PNG','20050201014408!Japan_prov_map_yamato.PNG',8108,235,300,8,'Small map of Yamato Province<br>Based on PD images used for prefectures<br>{{PD-self}}',69381,'Willhsmit','20050129022653','0','BITMAP','image','png',0,'33odn6fgk69gfupwbglxkcii3ad0c5w'),(3187,'French-colonial-Empire.PNG','20050201035215!French_colonial_Empire.PNG',39651,1357,628,8,'',172473,'Sean II','20050130212303','0','BITMAP','image','png',0,'55gefs7cblyopjmv43corqsvp9qawla'),(3188,'French-colonial-Empire.PNG','20050201040221!French_colonial_Empire.PNG',39769,1357,628,8,'',172473,'Sean II','20050201035216','0','BITMAP','image','png',0,'obtrsmupq0poc2ip8envy03y3pvsk7e'),(3189,'Felixfrankfurter.jpg','20050201060556!Felixfrankfurter.jpg',11900,165,240,8,'',44378,'Perl','20040228140250','0','BITMAP','image','jpeg',0,'3zbmbji8hyei5vezadxsc54buubtbyu'),(3190,'Sex-stub-icon2.png','20050201183242!Sex-stub-icon2.png',6783,258,318,8,'alternative version of icon for Template:sex-stub -- made in word processor, screen-grabbed and bitmap-edited by me -- {{GFDL}}',76,'The Anome','20050201122304','0','BITMAP','image','png',0,'ezomzi1fp7epnlzmnbu28895yloczdr'),(3191,'Sv2.jpg','20050201194120!Sv2.jpg',99368,580,435,8,'Shantavira',23736,'Shantavira','20050131190625','a:26:{s:16:\"ImageDescription\";s:31:\"OLYMPUS DIGITAL CAMERA         \";s:4:\"Make\";s:23:\"OLYMPUS OPTICAL CO.,LTD\";s:5:\"Model\";s:11:\"C860L,D360L\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:22:\"OLYMPUS CAMEDIA Master\";s:8:\"DateTime\";s:19:\"2003:06:15 08:36:01\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:5:\"1/144\";s:7:\"FNumber\";s:6:\"110/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:125;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"0000:00:00 00:00:00\";s:17:\"DateTimeDigitized\";s:19:\"0000:00:00 00:00:00\";s:22:\"CompressedBitsPerPixel\";s:3:\"1/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:3:\"3/1\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:1;s:11:\"FocalLength\";s:5:\"55/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'2t8d3669zie8gzqp3382i8au4rxhi8o'),(3192,'Bern-location-flags.png','20050201195509!Bern_location_flags.png',11341,634,324,8,'Berne location {{FDL}}',69607,'Ojw','20050201195039','0','BITMAP','image','png',0,'0u1yfbmz3pkwzmd006bz9fiqsehzyos'),(3193,'Argentinia-santa-cruz.jpeg','20050201221430!Argentinia_santa_cruz.jpeg',39815,500,500,8,'Santa cruz, argentinia {{FDL}}',69607,'Ojw','20050201220901','0','BITMAP','image','jpeg',0,'dmh1hat5lip57x0lojqepb8b6x3z3l0'),(3194,'CSet.png','20050202043006!CSet.png',6642,429,272,8,'Complement Set Email Filtering ',65486,'Mayosmith','20040505143202','0','BITMAP','image','png',0,'c1dcjrbp185818sq78sfy33mrfvabcx'),(3195,'PentosePhosphatePathway-OxidativeNADPH.png','20050202064912!PentosePhosphatePathway-OxidativeNADPH.png',7082,1183,143,8,'{{PD-self}}',104525,'Jag123','20050202064234','0','BITMAP','image','png',0,'eloe7jw5dm9prqbp1sjm7zra9cwgdv4'),(3196,'Akranes-pos.png','20050202111326!Akranes_pos.png',73479,692,580,8,'{{GFDL}} from public domain xrmap data',42385,'Lupin','20050130151312','0','BITMAP','image','png',0,'hwphkmsv4u0cr64kx1f70ggab5oqum6'),(3197,'Relation-between-heads-hydrostatic.png','20050202153920!Relation_between_heads_hydrostatic.png',15297,472,251,8,'diagram showing heads for hydrostatic condition',166520,'KrisK','20050118164409','0','BITMAP','image','png',0,'4psd70b2eoeovmw7s8ucho8dn7cy4fj'),(3198,'Mendip-TV-Mast-Lookingup.jpg','20050202201131!Mendip_TV_Mast_Lookingup.jpg',92466,960,1280,8,'A view of the Mendip TV Mast near it\'s base, which could not be fitted into the picture.',155631,'Jsommer','20050202200959','0','BITMAP','image','jpeg',0,'oyynthkxl939tqakksmagdalzzw13wm'),(3199,'Keyboard-Layout-Norwegian.png','20050202205159!Keyboard_Layout_Norwegian.png',1802,540,225,2,'Norwegian [[keyboard layout]].',102403,'Spug','20050202194408','0','BITMAP','image','png',0,'4m0pqpxpuk43ptspl9io82gdugcrrh2'),(3200,'Oregon-hall1.jpg','20050202213019!Oregon_hall1.jpg',149724,600,450,8,'Oregon Hall (pictured taken by Emre Yildirim)',182985,'Varlock','20050202212848','0','BITMAP','image','jpeg',0,'2sgcpeqgfl9lndnps3i9shpawjj1vng'),(3201,'Oregon-hall1.jpg','20050202215453!Oregon_hall1.jpg',149724,600,450,8,'Oregon Hall (pictured taken by Emre Yildirim)',182985,'Varlock','20050202213019','0','BITMAP','image','jpeg',0,'2sgcpeqgfl9lndnps3i9shpawjj1vng'),(3202,'Oasis\'-Whatever-Single-Cover.jpg','',7109,0,0,0,'[http://www.windowsmedia.com/mediaguide/albuminfo/?a_id=R+++230568&name=Oasis] {fair use}',86685,'Crestville','20050202233605','','UNKNOWN','','unix-directory',0,'phoiac9h4m842xq45sp7s6u21eteeq1'),(3203,'Harriet-Quimby-01.jpg','20050203022043!Harriet_Quimby_01.jpg',16057,496,365,8,'Harriet Quimby (1875-1912)  {{pd}}',158051,'Richard Arthur Norton (1958- )','20050203020143','0','BITMAP','image','jpeg',0,'6yh3dj335vy6g20alzoxblvllvueuru'),(3204,'Bond-hill,-cincinnati.JPG','20050203053320!Bond_hill,_cincinnati.JPG',54708,766,609,8,'Bond Hill, a neighborhood of Cincinnati Ohio',37695,'Aharon','20040601030822','0','BITMAP','image','jpeg',0,'6kmkj37xolinq31q5swhu4iel6ebksh'),(3205,'Price-daniel.jpg','20050203053707!Price_daniel.jpg',65407,473,595,8,'Picture of Texas politician [[Price Daniel]]. From public domain Texas State Library and Archives at http://www.tsl.state.tx.us/governors/modern/daniel-p01.html {{PD}}',26071,'Adam Faanes','20050122103259','0','BITMAP','image','jpeg',0,'eg77hnk12vfasar5s5x3llgncqgsazc'),(3206,'Handballcourt.jpg','20050203092519!Handballcourt.jpg',25450,441,477,8,'Layout of a Handball Court {{PD}}',50215,'Hetch','20050202104211','0','BITMAP','image','jpeg',0,'34d7fp4uban7tuqwkhysfd971ezb03t'),(3207,'Cgisf-tgg.png','20050203094518!Cgisf-tgg.png',1672,288,176,2,'',0,'(Automated conversion)','20020720114925','0','BITMAP','image','png',0,'9f3cy33oo2ehrvqni66090i5lj17d2d'),(3208,'Europe-southern-countries.png','20050203101752!Europe-southern-countries.png',4572,264,196,8,'map for [[Southern Europe]]',20318,'Shallot','20040327235824','0','BITMAP','image','png',0,'7jxco2dyk21cffad1kqtczev6mei45h'),(3209,'Firemans-chair-knot.png','20050203211535!Firemans_chair_knot.png',65340,550,550,8,'{{FDL}}',69607,'Ojw','20050203211109','0','BITMAP','image','png',0,'k75r78wmhac3gnktwizigsotfg48pwl'),(3210,'Firemans-chair-knot-in-use.png','20050203214022!Firemans_chair_knot_in_use.png',16337,488,337,8,'{{FDL}}',69607,'Ojw','20050203213519','0','BITMAP','image','png',0,'hx1hpyb7lghbuqfj5ojxqe4i2nu9uh5'),(3211,'Swiss-cantons-light.png','20050203234359!Swiss_cantons_light.png',557179,1366,866,8,'{{FDL}}',69607,'Ojw','20050203232739','0','BITMAP','image','png',0,'1i938l0qj4qc7mrjih5i5g3mlelzz12'),(3212,'Sinfulness.gif','20050204042257!Sinfulness.gif',1410,243,53,4,'\"sinfulness\" with the [[long s]]; Times New Roman, 48',25013,'Branddobbe','20040628052810','0','BITMAP','image','gif',0,'io0pr18v384ef8d2u6zkcaaqjrnjapc'),(3213,'Taiwan-aborigine-en.jpg','20050204054302!Taiwan_aborigine_en.jpg',32692,341,498,8,'{{GFDL}}',106942,'Mababa','20050123075314','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"96/1\";s:11:\"YResolution\";s:4:\"96/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2005:01:22 23:52:55\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'am1c0vligda64wmh3xefz170o5sn4n6'),(3214,'USAFE-Band-trumpeter.jpg','20050204062047!USAFE_Band_trumpeter.jpg',61538,720,555,8,'{{PD-USGov-Military-Air Force}}',6852,'Flamurai','20050204061839','0','BITMAP','image','jpeg',0,'0rpfllcs1xiggnsgydz28o8aul4r5gn'),(3215,'Autobiography-weekly-performance.png','20050204070411!Autobiography-weekly-performance.png',11441,676,303,8,'{{PD-self}} Weekly chart performance for \"Autobiography\" by Ashlee Simpson',36005,'Carnildo','20050204064818','0','BITMAP','image','png',0,'e9rkpl6txeoo3mym4l7pt58a8hctjhh'),(3216,'Perovchristians.jpg','20050204072028!Perovchristians.jpg',27127,785,507,8,'[[Vasily Perov]]. \'\'First Christians in [[Kiev]]\'\' (1880) {{PD}}',147410,'Ghirlandajo','20050204070829','0','BITMAP','image','jpeg',0,'8amt0um5whymbyoe14xkwa3hhrzjt6o'),(3217,'Early-timpani-and-trumpet.jpg','20050204082017!Early_timpani_and_trumpet.jpg',42434,400,499,8,'{{PD-art}}',6852,'Flamurai','20050204081529','a:28:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:7:\"DSC-P72\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:03:17 16:24:03\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/400\";s:7:\"FNumber\";s:5:\"50/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:250;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:03:17 16:24:03\";s:17:\"DateTimeDigitized\";s:19:\"2004:03:17 16:24:03\";s:22:\"CompressedBitsPerPixel\";s:3:\"4/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"48/16\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:77;s:11:\"FocalLength\";s:6:\"154/10\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'3gsq2eidzzzc48rl8vu7bpb97nafiqx'),(3218,'Early-timpani-and-trumpet.jpg','20050204082406!Early_timpani_and_trumpet.jpg',42434,400,499,8,'cropped and resized',6852,'Flamurai','20050204082017','a:28:{s:4:\"Make\";s:4:\"SONY\";s:5:\"Model\";s:7:\"DSC-P72\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:03:17 16:24:03\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:6:\"10/400\";s:7:\"FNumber\";s:5:\"50/10\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:250;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:03:17 16:24:03\";s:17:\"DateTimeDigitized\";s:19:\"2004:03:17 16:24:03\";s:22:\"CompressedBitsPerPixel\";s:3:\"4/1\";s:17:\"ExposureBiasValue\";s:4:\"0/10\";s:16:\"MaxApertureValue\";s:5:\"48/16\";s:12:\"MeteringMode\";i:5;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:77;s:11:\"FocalLength\";s:6:\"154/10\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:16:\"SceneCaptureType\";i:0;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'3gsq2eidzzzc48rl8vu7bpb97nafiqx'),(3219,'City-trumpeteers.jpg','20050204082806!City_trumpeteers.jpg',69126,528,328,8,'{{PD-art}}',6852,'Flamurai','20050204082123','0','BITMAP','image','jpeg',0,'ilrrsbz32wve9l85qnfonhjtz9uk3o6'),(3220,'Sharps-Container.jpg','20050204102849!Sharps_Container.jpg',97855,1280,960,8,'Immediate disposal of used needles into a sharps container is standard procedure.',139435,'Rafti Institute','20041209030047','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"480/1\";s:11:\"YResolution\";s:5:\"480/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2003:06:29 22:06:15\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'c3qbsfrsajyc58mua3cz5f6lwooh7hv'),(3221,'Baseball-lf.png','20050204125249!Baseball_lf.png',10063,514,393,8,'baseball position left field {{FDL}}',69607,'Ojw','20050202130248','0','BITMAP','image','png',0,'bxdasaq2nxo9nluberwb3g6fasq3ccc'),(3222,'Baseball-lf.png','20050204125853!Baseball_lf.png',30397,1208,982,8,'{{FDL}}',69607,'Ojw','20050204125250','0','BITMAP','image','png',0,'6hu1f12mml1uy3g6ohhn7sh8pq0wzum'),(3223,'Baseball-lf.png','20050204131843!Baseball_lf.png',17670,604,491,8,'{{FDL}}',69607,'Ojw','20050204125854','0','BITMAP','image','png',0,'2skebfm5qdl0670ac34scv1l7u0qyki'),(3224,'Commutative.png','20050204133829!Commutative.png',2171,65,70,8,'{{PD-self}} latex compiled',18901,'Phys','20041206172110','0','BITMAP','image','png',0,'fsizi5f90uxqh7c6jzhl5lt31vens7c'),(3225,'Commutative.png','20050204133936!Commutative.png',2624,303,205,8,'TeXed by myself. {{GFDL}}',42385,'Lupin','20050204133829','0','BITMAP','image','png',0,'078xgdyy565sbfrqa1rpn3iwao5zew7'),(3226,'Grayrigg-Forest.jpg','20050204154035!Grayrigg_Forest.jpg',16371,450,337,8,'Grayrigg Forest from the west',178675,'StephenDawson','20050204153153','0','BITMAP','image','jpeg',0,'8v19d86a80g4k6w0tiiimout73s3roq'),(3227,'Baseball-lf.png','20050204165626!Baseball_lf.png',16182,627,481,8,'{{FDL}}',69607,'Ojw','20050204131843','0','BITMAP','image','png',0,'g7jzwwbxdruxfql3nlef1za6zb8hjtg'),(3228,'Swiss-cantons-light-labelled.png','20050204201502!Swiss_cantons_light_labelled.png',188241,1366,866,8,'{{FDL}}',69607,'Ojw','20050204200052','0','BITMAP','image','png',0,'ru2pvoxf8a9hqti7hg9wfbsl8ao3uu4'),(3229,'Baseball-lf.png','20050204201640!Baseball_lf.png',15946,606,467,8,'{{FDL}}',69607,'Ojw','20050204165627','0','BITMAP','image','png',0,'9bwixqk5oorn9kq39txjfxcuqr56ppg'),(3230,'Baseball-lf.png','20050204210749!Baseball_lf.png',15953,490,384,8,'{{FDL}}',69607,'Ojw','20050204201640','0','BITMAP','image','png',0,'364a34v1pahiq89yfoipwzmn46x815v'),(3231,'Map-of-Lima-Provincias-region.PNG','20050204233425!Map_of_Lima_Provincias_region.PNG',13814,303,377,8,'Map of the Lima Provincias region of Peru',148190,'StarbucksFreak','20050129235942','0','BITMAP','image','png',0,'k2bu0srv77bdrep5cpepubt70z5hdbw'),(3232,'Map-of-Lima-Provincias-region.PNG','20050204233814!Map_of_Lima_Provincias_region.PNG',13904,303,377,8,'',148190,'StarbucksFreak','20050204233425','0','BITMAP','image','png',0,'2j3m4yt0qltoai9papv13eu2ldc27cw'),(3233,'Ntsb-diagram.jpg','20050205062718!Ntsb_diagram.jpg',59790,480,707,8,'NTSB diagram of Air Florida Flight 90 crash January 13, 1982',37169,'Vaoverland','20050205062503','0','BITMAP','image','jpeg',0,'740fmia4zpm5uilha4eel84i87xl3l5'),(3234,'Media-Lab-Europe.png','20050205102433!Media_Lab_Europe.png',3170,227,82,8,'fair use',49447,'Djegan','20050126103853','0','BITMAP','image','png',0,'g1joyubhx1ysclii2aq1b2ui2spd84c'),(3235,'MiddleEastoutline.png','20050205122514!MiddleEastoutline.png',10645,232,222,8,'Middle East outline map for MEast-geo-stub',117878,'Grutness','20050205122144','0','BITMAP','image','png',0,'srs83yjintqfsgh3r0v8m828fex6tkp'),(3236,'Interior-of-Bullring.jpg','20050205165411!Interior_of_Bullring.jpg',183099,500,667,8,'Photo by G-Man Jan 2004 {{PD-user|G-Man}}',8272,'G-Man','20050204200552','a:25:{s:16:\"ImageDescription\";s:8:\"KF2-2002\";s:4:\"Make\";s:7:\"KONICA \";s:5:\"Model\";s:12:\"KONICA KD-20\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2003:11:26 12:10:13\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:4:\"1/42\";s:7:\"FNumber\";s:3:\"7/2\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2003:11:26 12:10:13\";s:17:\"DateTimeDigitized\";s:19:\"2003:11:26 12:10:13\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:5:\"93/10\";s:16:\"MaxApertureValue\";s:3:\"7/2\";s:12:\"MeteringMode\";i:2;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:0;s:11:\"FocalLength\";s:5:\"56/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'8tu147fa5ybu6xu7ees9ticums2hywa'),(3237,'Coventry-city-centre-750.jpg','20050205171745!Coventry_city_centre_750.jpg',205042,750,563,8,'Photo by G-Man',8272,'G-Man','20041215214239','a:25:{s:16:\"ImageDescription\";s:8:\"KF2-2002\";s:4:\"Make\";s:7:\"KONICA \";s:5:\"Model\";s:12:\"KONICA KD-20\";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"DateTime\";s:19:\"2004:11:01 04:51:56\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:4:\"1/30\";s:7:\"FNumber\";s:3:\"7/2\";s:15:\"ExposureProgram\";i:2;s:15:\"ISOSpeedRatings\";i:200;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:11:01 04:51:56\";s:17:\"DateTimeDigitized\";s:19:\"2004:11:01 04:51:56\";s:22:\"CompressedBitsPerPixel\";s:3:\"2/1\";s:17:\"ExposureBiasValue\";s:5:\"74/10\";s:16:\"MaxApertureValue\";s:3:\"7/2\";s:12:\"MeteringMode\";i:2;s:11:\"LightSource\";i:0;s:5:\"Flash\";i:1;s:11:\"FocalLength\";s:5:\"56/10\";s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'byxyoaol2uxlsixhcleyb3oxzzjr9gg'),(3238,'CroydonTownHall.png','20050205232244!CroydonTownHall.png',340245,500,386,8,'Croydon Town Hall taken 5 Feb 2005 {{GFDL}} ',138610,'Mtiedemann','20050205231801','0','BITMAP','image','png',0,'sd84s7liqpyz7dttapr7ed9uu10r5qc'),(3239,'Stephen-Avenue.jpg','20050206020223!Stephen_Avenue.jpg',1154635,1280,960,8,'',173140,'Tyson2k','20050206015821','0','BITMAP','image','jpeg',0,'h1xy1242cgk3s1j767w5hp3xgk5w8ow'),(3240,'Basic-instinct-001.jpg','20050206055307!Basic_instinct_001.jpg',10928,200,252,8,'',46072,'Dilesh','20040222071148','0','BITMAP','image','jpeg',0,'95oxlnm1jsjinuphnmygudbdjubtznw'),(3241,'SilkRoadPeoples.jpg','20050206060405!SilkRoadPeoples.jpg',89557,390,521,8,'',48296,'PHG','20050206053536','0','BITMAP','image','jpeg',0,'qis5hbfxhzlh79likbevl70yhcacgln'),(3242,'Crude-EU27.png','20050206063252!Crude-EU27.png',3976,262,160,8,'highlighted enlargement',20318,'Shallot','20040310184723','0','BITMAP','image','png',0,'ez413b5xx6299v9cxoa6goxguk3sun1'),(3243,'Navel-orange-bottom-part.jpg','20050206213217!Navel_orange_bottom_part.jpg',104629,1024,768,8,'Bottom part of the navel orange taken Jan. 25, 2005 by Allen Timothy Chang {{GFDL}}',44426,'Allentchang','20050201193555','0','BITMAP','image','jpeg',0,'hwoihisdp1d62ik1eby4t8pp4svr9pu'),(3244,'D5DBKa.png','20050206230548!D5DBKa.png',32229,1612,1616,8,'{{PD}}, latexed by myself',42385,'Lupin','20050206225100','0','BITMAP','image','png',0,'r3ofk3ct2nxsdtk9g7rcwi53xtd0vuc'),(3245,'Uk2pnd2002-S.jpg','20050207131413!Uk2pnd2002-S.jpg',43047,504,500,8,'copied scottish version flag onto high-resolution english version, bit of a cheat but looks ok IMO',27043,'Boffy b','20040824184308','0','BITMAP','image','jpeg',0,'b1eud73o9wsaggohnlhlvoku4nj3hdd'),(3246,'Uk2pnd2002-S.jpg','20050207131731!Uk2pnd2002-S.jpg',23504,512,384,8,'Reverted to earlier revision',7891,'Arwel Parry','20050207131413','0','BITMAP','image','jpeg',0,'i75vwhnu7vcmcv6240rdfbz3rd971up'),(3247,'Paris-commune.jpg','20050207154131!Paris-commune.jpg',430793,1246,1047,8,'Map of the Paris Commune',6815,'Yann','20040821172028','0','BITMAP','image','jpeg',0,'92t33d58kzgppu832dpwkuiynsruypb'),(3248,'Jimbocho.jpg','20050207224552!Jimbocho.jpg',32100,450,300,8,'A picture of a street in Jimbocho, taken in November 2004. {{PD-user|Boleslav_Bobcik}}',2123,'Boleslav Bobcik','20050207220651','0','BITMAP','image','jpeg',0,'swivymop90qb4doqsv5gtz8dtpg6ifi'),(3249,'Swiss-cantons-brown-flags.png','20050207231612!Swiss_cantons_brown_flags.png',169724,1366,866,8,'{{FDL}}',69607,'Ojw','20050207225700','0','BITMAP','image','png',0,'1zcs5abrymtzd53jzvx2a30zh2tcnqp'),(3250,'Nightswimming.jpg','20050208024143!Nightswimming.jpg',55449,200,198,8,'{{albumcover}} Cover of \"[[Nightswimming]]\" UK single by [[R.E.M. (band)|R.E.M.]]',86091,'Moochocoogle','20050121064333','0','BITMAP','image','jpeg',0,'o5l1yqgchu7c4hu87f7tj2zz4cxwfvu'),(3251,'Popscene.jpg','20050208030642!Popscene.jpg',6599,145,143,8,'{{albumcover}} Cover of Blur single Popscene',86091,'Moochocoogle','20041220202339','0','BITMAP','image','jpeg',0,'m1yp9x18j43zr8rwiga47r8ldmn6z1n'),(3252,'Binturong-0.jpg','20050208034122!Binturong_0.jpg',75632,640,480,8,'Binturong, emphasizing the tail, from Field Museum of Natural History, Chicago',37284,'Ancheta Wis','20050208033250','0','BITMAP','image','jpeg',0,'jmascuck96cyyyt6g88rm7goqxu1g18'),(3253,'Go-board.jpg','20050208051009!Go_board.jpg',50073,578,344,8,'Reverted to earlier revision',80653,'Tordek ar','20040922020439','0','BITMAP','image','jpeg',0,'ak49xtiwbhtpv6784ik6ci9gmd4tz47'),(3254,'Go-board.jpg','20050208051106!Go_board.jpg',150448,600,352,8,'Reverted to earlier revision',43805,'Ds13','20050208051009','0','BITMAP','image','jpeg',0,'om2s79bt3rgro1yynwafbim0yfwa7n7'),(3255,'IIH.png','20050208052821!IIH.png',2508,639,480,2,'placeholder for images that will be \"coming soon\"',30,'The Epopt','20040226224619','0','BITMAP','image','png',0,'tg64zdgzksh7pydk991cr0dinrpw35i'),(3256,'IIH.png','20050208053828!IIH.png',3921,300,100,8,'a slightly less insistant version of \"Insert Image Here\"',30,'The Epopt','20050208052821','0','BITMAP','image','png',0,'nqhd1jp9fk8fnno4ab9skji3ehlql5l'),(3257,'Kunzum-Pass-between-Lahaul-&-Spiti.jpg','20050208065445!Kunzum_Pass_between_Lahaul_&_Spiti.jpg',231827,1600,1200,8,'a photo I took on a trip in June 2004',179750,'John Hill','20050208064100','a:33:{s:4:\"Make\";s:19:\"PENTAX Corporation \";s:5:\"Model\";s:17:\"PENTAX Optio S4i \";s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:27:\"ACD Systems Digital Imaging\";s:8:\"DateTime\";s:19:\"2005:02:08 16:36:16\";s:16:\"YCbCrPositioning\";i:1;s:12:\"ExposureTime\";s:6:\"1/2000\";s:7:\"FNumber\";s:5:\"43/10\";s:15:\"ISOSpeedRatings\";i:50;s:11:\"ExifVersion\";s:4:\"0220\";s:16:\"DateTimeOriginal\";s:19:\"2004:06:27 22:54:55\";s:17:\"DateTimeDigitized\";s:19:\"2004:06:27 22:54:55\";s:22:\"CompressedBitsPerPixel\";s:15:\"9830400/1920000\";s:17:\"ExposureBiasValue\";s:3:\"0/3\";s:16:\"MaxApertureValue\";s:5:\"28/10\";s:12:\"MeteringMode\";i:3;s:5:\"Flash\";i:24;s:11:\"FocalLength\";s:7:\"580/100\";s:10:\"SubSecTime\";s:3:\"169\";s:10:\"ColorSpace\";i:1;s:14:\"CustomRendered\";i:0;s:12:\"ExposureMode\";i:0;s:12:\"WhiteBalance\";i:0;s:21:\"FocalLengthIn35mmFilm\";i:35;s:16:\"SceneCaptureType\";i:1;s:8:\"Contrast\";i:0;s:10:\"Saturation\";i:0;s:9:\"Sharpness\";i:2;s:20:\"SubjectDistanceRange\";i:3;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'qxlx8ykybdzjxonbit4mowda1uzbjrx'),(3258,'Confocalprinciple.png','20050208100735!Confocalprinciple.png',5177,400,163,4,'confocal principle',4359,'Svenbor','20021223092208','0','BITMAP','image','png',0,'1eov6t7a1wbuzzzfngcfutw9k51hoh0'),(3259,'Confocalprinciple.png','20050208102851!Confocalprinciple.png',48686,550,339,8,'gfdl version',142498,'IMeowbot','20050208100736','0','BITMAP','image','png',0,'oo4hw2cf2nvnzas6k7jc4n7468l9y94'),(3260,'Example.jpg','20050208133544!Example.jpg',37624,355,349,8,'Reverted to earlier revision',44727,'Curps','20050201211123','0','BITMAP','image','jpeg',0,'nkyj6q39ryqkafvp7g0rd0ut81jydnh'),(3261,'Example.jpg','20050208134209!Example.jpg',11974,135,155,8,'Reverted to earlier revision',58130,'Estel','20050208134111','0','BITMAP','image','png',0,'oknebl2xt9hqu34rqqzxlu5lgwl9ciw'),(3262,'CuCl2-chloride-complexes.png','20050208165917!CuCl2_chloride_complexes.png',41555,2723,1054,1,'Structures of anionic chloride complexes of copper(II)',131355,'Walkerma','20050208163819','0','BITMAP','image','png',0,'igbur7617nqwr1hmpmyim9xn9qu94q1'),(3263,'CuCl2-alpha-chlorination.png','20050208171346!CuCl2_alpha_chlorination.png',11899,2269,546,1,'Alpha chlorination of butanal using copper(II) chloride',131355,'Walkerma','20050208170405','0','BITMAP','image','png',0,'5634sbf130xkvuj214saject2t3xyfv'),(3264,'CuCl2-alpha-chlorination.png','20050208172456!CuCl2_alpha_chlorination.png',79058,1815,437,8,'Alpha chlorination of butanal using copper(II) chloride',131355,'Walkerma','20050208171355','0','BITMAP','image','png',0,'an6dv9yxoao14t3jm68i7xqas0g9aij'),(3265,'DanielFreeman.gif','20050208173651!DanielFreeman.gif',20186,208,350,8,'Photograph of [[Daniel Freeman]], first person to file for a claim under the [[Homestead Act]].  {{PD-old}}',47920,'Dsmdgold','20050208170731','0','BITMAP','image','gif',0,'d9sg0v9wpw91iphnsfrs78mlj7q3y5t'),(3266,'KoH-CS-Varasd.png','20050208194437!KoH-CS-Varasd.png',16723,637,386,4,'made from [[:Image:Croatia-Slavonia-Kingdom-of-Hungary.png]]',20318,'Joy','20040827151554','0','BITMAP','image','png',0,'anv0dyc6fxw750dbkpkakujpdcbtzpj'),(3267,'DisneyETicket-wbelf.jpg','20050208201021!DisneyETicket_wbelf.jpg',85154,479,318,8,'[[Disneyland]] [[E ticket]]',40082,'Elf','20050208200322','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"150/1\";s:11:\"YResolution\";s:5:\"150/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:28:\"Adobe Photoshop Elements 2.0\";s:8:\"DateTime\";s:19:\"2005:02:08 11:59:03\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'j2z86bwo8j9lzj9bmq1ouitbw9i5ngl'),(3268,'DisneyTicketBook-wbelf.jpg','20050208201029!DisneyTicketBook_wbelf.jpg',99606,800,316,8,'[[Disneyland]] ticket book',40082,'Elf','20050208200414','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"200/1\";s:11:\"YResolution\";s:5:\"200/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:28:\"Adobe Photoshop Elements 2.0\";s:8:\"DateTime\";s:19:\"2005:02:08 11:58:04\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'snk6vw27nvccl1uoy0ye4lak6maeaz5'),(3269,'Elm-ave-2.jpg','20050208211853!Elm_ave_2.jpg',253473,1125,675,8,'Elm Ave. looking west, early 1900s',187504,'Jjotz','20050208211239','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:26:\"Adobe Photoshop CS Windows\";s:8:\"DateTime\";s:19:\"2005:02:08 16:12:05\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'md3tdmc2a8av853rk5c9nh3g91v2wo8'),(3270,'Country-positions-Iraq-war.png','20050208220945!Country_positions_Iraq_war.png',88134,1357,628,8,'World government positions regarding the 2003 Iraq war',49019,'Get-back-world-respect','20041014021934','0','BITMAP','image','png',0,'kx5938f6lz1k0dwqb0cma2nmwtjdh6h'),(3271,'Cape-York-Peninsula-Map.jpg','20050209002239!Cape_York_Peninsula_Map.jpg',426035,838,1259,8,'Map of Cape York Peninsula ',179750,'John Hill','20050207053020','a:10:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:27:\"ACD Systems Digital Imaging\";s:8:\"DateTime\";s:19:\"2005:02:07 15:19:54\";s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:10:\"SubSecTime\";s:3:\"187\";s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'8us1epwi0jbe9vviz5jhhfhk2nqrrrg'),(3272,'Cape-York-Peninsula-Map.jpg','20050209002723!Cape_York_Peninsula_Map.jpg',340190,641,963,8,'I have just made the map a bit smaller than previously',179750,'John Hill','20050209002239','a:10:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:27:\"ACD Systems Digital Imaging\";s:8:\"DateTime\";s:19:\"2005:02:09 10:18:56\";s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:10:\"SubSecTime\";s:3:\"964\";s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'hjv7ace9pvpwx2zq5bpa79bc4lytmtd'),(3273,'Cape-York-Peninsula-Map.jpg','20050209003137!Cape_York_Peninsula_Map.jpg',422606,705,1059,8,'another slight edit to size of map',179750,'John Hill','20050209002723','a:10:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:27:\"ACD Systems Digital Imaging\";s:8:\"DateTime\";s:19:\"2005:02:09 10:25:03\";s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:10:\"SubSecTime\";s:3:\"521\";s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'3xx3p32rurdv0l6rtc5rso1bpc4oomx'),(3274,'Dymaxion-map-unfolded.png','20050209010945!Dymaxion_map_unfolded.png',165709,744,379,8,'now white background',48117,'Avsa','20040903163322','0','BITMAP','image','png',0,'rndnphlkwlwprw53rsyr5v3pnthfywu'),(3275,'Dymaxion-map-unfolded.png','20050209011056!Dymaxion_map_unfolded.png',148357,744,379,8,'Reverted to earlier revision',201,'Nemo','20050209010945','0','BITMAP','image','png',0,'4mqwugechuf26l501u0qkhulqmqjis1'),(3276,'Three-monks-chanting-in-Lhasa,-1993.jpg','20050209023505!Three_monks_chanting_in_Lhasa,_1993.jpg',159160,499,321,8,'I took this photo myself in 1993',179750,'John Hill','20050209021827','a:10:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:27:\"ACD Systems Digital Imaging\";s:8:\"DateTime\";s:19:\"2005:02:09 12:16:05\";s:16:\"YCbCrPositioning\";i:1;s:11:\"ExifVersion\";s:4:\"0220\";s:10:\"SubSecTime\";s:3:\"721\";s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'9babl9xvgj1k2jf7rgc8g83gvzj5ppu'),(3277,'Miracle-on-Ice---Eruzione-tees-up-goal.jpg','20050209042412!Miracle_on_Ice_-_Eruzione_tees_up_goal.jpg',68713,615,480,8,'Screenshot from the ABC Sports broadcast of the 1980 Olympics {{screenshot}}',6852,'Flamurai','20050209040650','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2005:02:08 22:50:40\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'m38onhhiqxgtbsvk9tsv5kspzszlgp0'),(3278,'Hcsobadge1.png','20050209103300!Hcsobadge1.png',16045,317,302,8,'Hernando County Sheriff\'s Office logo {{msg:logo}}',72348,'Moral Defense','20050209042408','0','BITMAP','image','png',0,'dmrnj7kp158jeum5vjbnwcv86evcbh8'),(3279,'Beerpong.jpg','20050209135509!Beerpong.jpg',50343,480,360,8,'Beer Pong game in progress',85723,'Rethcir','20050209133831','0','BITMAP','image','jpeg',0,'rid97x6z7r1arvx56m92oovrnzbtu33'),(3280,'Usinprogress.PNG','20050209223459!Usinprogress.PNG',33960,280,183,8,'update',35314,'Seth Ilys','20050123211209','0','BITMAP','image','png',0,'4ho7vnqeildsqxqvn3vnp9yufu9imz9'),(3281,'NYCS-acc.png','20050210012255!NYCS_acc.png',277769,3868,4413,8,'#REDIRECT [[New York City Subway accessibility]] (see [[:Image:handicap.png]] for information)',113059,'SPUI','20050210010120','0','BITMAP','image','png',0,'gwy9769l6aweggcilu8flsnhd4i7c68'),(3282,'SanJoseMapWithLAFCOandAdjacentCitiesandSJandCAPrimaries.jpg','20050210041918!SanJoseMapWithLAFCOandAdjacentCitiesandSJandCAPrimaries.jpg',133981,779,562,8,'{{PD-USGov}} {{PD}}From US Census Bureau public domain map. I release my edits public domain, as well.',46219,'Niteowlneils','20050210040646','0','BITMAP','image','jpeg',0,'44rbyxej8bvheoywlfamxhgf8qi67ux'),(3283,'InscribedAngle-CenterCircle.png','20050210125940!InscribedAngle_CenterCircle.png',55951,250,250,8,'',95981,'Fiveless','20050210124956','0','BITMAP','image','png',0,'8lwba0y0oqg8l3ltz11qbdrtx5kwtx8'),(3284,'User-Fredrik-contribution-graph.png','20050210172215!User_Fredrik_contribution_graph.png',5355,490,1099,4,'update',26675,'Fredrik','20041201175815','0','BITMAP','image','png',0,'kjmr6okk1fw75d135fkdf2t0q0fnpo9'),(3285,'Hezekiah---Manasseh---Amon.jpg','20050210184945!Hezekiah_-_Manasseh_-_Amon.jpg',7866,250,143,8,'{{PD-old}} from [http://gallery.euroweb.hu/html/m/michelan/3sistina/6lunette/07/lu07hez.html]',1591,'SimonP','20050210184108','0','BITMAP','image','jpeg',0,'bx4wr0up348vne6b2kvndwitzkk765m'),(3286,'Udpdtahoe.jpg','20050210223257!Udpdtahoe.jpg',127379,1024,768,8,'Image taken by myself of unit 41-7 of the UDPD',137891,'FtWashGuy','20050116193747','0','BITMAP','image','jpeg',0,'p66255zpw2l43ehxfacl2dgfuznx34s'),(3287,'Udpdtahoe.jpg','20050210223324!Udpdtahoe.jpg',305441,1024,768,8,'Reverted to earlier revision',137891,'FtWashGuy','20050210223258','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2005:01:16 00:40:04\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'e6g47kndwea46czj5c8i38j637f1gbq'),(3288,'User-mrweeble.jpg','20050210225426!User_mrweeble.jpg',20131,300,300,8,'updated pic',22475,'MrWeeble','20040930202740','0','BITMAP','image','jpeg',0,'jpduo6bcb7fkzm1xhri2emqfmjqx2nm'),(3289,'Udpdtahoe.jpg','20050210233759!Udpdtahoe.jpg',305441,1024,768,8,'Reverted to earlier revision',137891,'FtWashGuy','20050210223324','a:8:{s:11:\"Orientation\";i:1;s:11:\"XResolution\";s:5:\"300/1\";s:11:\"YResolution\";s:5:\"300/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:19:\"Adobe Photoshop 7.0\";s:8:\"DateTime\";s:19:\"2005:01:16 00:40:04\";s:10:\"ColorSpace\";i:65535;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'e6g47kndwea46czj5c8i38j637f1gbq'),(3290,'Rxn-step-1.jpg','20050211031155!Rxn_step_1.jpg',7787,614,74,8,'Picture 1 of a Free-Radical Addition rxn',149877,'TheDaoOf42','20050211030031','0','BITMAP','image','jpeg',0,'c47sfvm3pt8mvb15eahb8sbnb3yrzzh'),(3291,'Rxn-step-1.jpg','20050211031521!Rxn_step_1.jpg',8109,588,73,8,'Re-touched RXN step 1',149877,'TheDaoOf42','20050211031155','0','BITMAP','image','jpeg',0,'f39mksig275x2r097327ol6c837wvdv'),(3292,'Rxn-step-1.jpg','20050211031637!Rxn_step_1.jpg',7787,614,74,8,'Reverted to earlier revision',149877,'TheDaoOf42','20050211031521','0','BITMAP','image','jpeg',0,'c47sfvm3pt8mvb15eahb8sbnb3yrzzh'),(3293,'Rxn-step-1.jpg','20050211031639!Rxn_step_1.jpg',8109,588,73,8,'Reverted to earlier revision',149877,'TheDaoOf42','20050211031637','0','BITMAP','image','jpeg',0,'f39mksig275x2r097327ol6c837wvdv'),(3294,'Athens1896poster.jpg','20050211230917!Athens1896poster.jpg',37865,400,400,8,'Although often listed as the poster of the 1896 Games, this is actually the cover of the official report of these Games. {{PD}}',108,'Jeronimo','20050211230710','0','BITMAP','image','jpeg',0,'oeg2j7ov4v4mjslz04l8yww6r22i7c9'),(3295,'Yaks-with-loads.JPG','20050211232858!Yaks_with_loads.JPG',134196,909,464,8,'This drawing comes from T. E. Gordon\'s 1876 book, The Roof of the World - so I don\'t think it should be considered as in the \"public domain.\"',179750,'John Hill','20050211231647','0','BITMAP','image','jpeg',0,'9r4ov5bv9qo4bqlmff7wg5ck8xgn15f'),(3296,'Blueme.jpg','20050212050750!Blueme.jpg',37810,373,493,8,'Blue Me',150324,'Wooran','20050212042150','0','BITMAP','image','jpeg',0,'csk6prenduo8jzlgd8ng0iupdvityw6'),(3297,'Capsaicin-structure.png','20050212092011!Capsaicin-structure.png',1908,261,167,8,'Skeletal structure of the capsaicin molecule.',13407,'Geoff','20030621215128','0','BITMAP','image','png',0,'gj7y739j6osd445udedpap15ta8phpo'),(3298,'Capsaicin-structure.png','20050212093932!Capsaicin-structure.png',3057,630,167,8,'cleanup',142498,'IMeowbot','20050212092011','0','BITMAP','image','png',0,'cgio6900ultsquutwvlaz357d6w48pm'),(3299,'Tta-nes-screenshot1.gif','20050212151441!Tta_nes_screenshot1.gif',4075,200,175,8,'{{screenshot}} Tiny Toon Adventures for the NES Screenshot #1',38430,'Eric42','20050211134057','0','BITMAP','image','gif',0,'0z85dmyr2qv4z8kuartvqwh82014uot'),(3300,'Tta-nes-screenshot1.gif','20050212151723!Tta_nes_screenshot1.gif',2976,150,131,8,'{{Screenshot}} Tiny Toon Adventures NES Screenshot #1',38430,'Eric42','20050212151441','0','BITMAP','image','gif',0,'nh0bgo83w2k08ihrdratnznzrqusse4'),(3301,'Karenflag.jpg','20050212194904!Karenflag.jpg',75755,600,581,8,'[[Kayin]] State flag (can be also referred to [[Karen]] state)',186269,'Svenjakal','20050212193549','0','BITMAP','image','jpeg',0,'dmln4qxx0p5ggnxg8hbfucc0ve02m2z'),(3302,'KylieMinogueIShouldBeSoLucky.ogg','20050213062444!KylieMinogueIShouldBeSoLucky.ogg',674573,0,0,0,'30 second sound sample of the song \"I Should Be So Lucky\" by [[Kylie Minogue]]',39836,'Rossrs','20050212142936','a:3:{s:7:\"version\";i:1;s:7:\"streams\";a:1:{i:9804;a:8:{s:6:\"serial\";i:9804;s:5:\"group\";i:0;s:4:\"type\";s:6:\"Vorbis\";s:6:\"vendor\";s:29:\"Xiph.Org libVorbis I 20020717\";s:6:\"length\";d:30.48888888888888715200664591975510120391845703125;s:4:\"size\";i:674573;s:6:\"header\";a:9:{s:14:\"vorbis_version\";i:0;s:14:\"audio_channels\";i:2;s:17:\"audio_sample_rate\";i:44100;s:15:\"bitrate_maximum\";i:0;s:15:\"bitrate_nominal\";i:160003;s:15:\"bitrate_minimum\";i:0;s:11:\"blocksize_0\";i:8;s:11:\"blocksize_1\";i:11;s:12:\"framing_flag\";i:0;}s:8:\"comments\";a:0:{}}}s:6:\"length\";d:30.48888888888888715200664591975510120391845703125;}','AUDIO','application','ogg',0,'dbb8odsdkceod4275qzgyvb2g29jh93'),(3303,'Guido-verboom-portrait-small.jpg','20050213064728!Guido_verboom_portrait_small.jpg',23686,270,360,8,'picture of myself',55246,'Guidoverboom','20050213064112','0','BITMAP','image','jpeg',0,'9ingkxtp5akxy4wfr71tl51x5btvkb7'),(3304,'Bakert.jpg','20050213104707!Bakert.jpg',64494,262,281,8,'',6661,'PMelvilleAustin','20040514012537','0','BITMAP','image','jpeg',0,'2x52fmwru8z6i4v5iwzy62s9s58f64e'),(3305,'Rugby-legue-ireland-shirt.png','20050213121647!Rugby_legue_ireland_shirt.png',1640,300,250,8,'{{GFDL}} ',62080,'Grinner','20040903103216','0','BITMAP','image','png',0,'s5g3gb1eb6vjj53ezd2f1vrdon8ly77'),(3306,'Deet.png','20050213125733!Deet.png',1488,214,96,8,'',16924,'Maximus Rex','20031129032100','0','BITMAP','image','png',0,'20875yuz8xwmuo26vw7cgttkdkiyhu2'),(3307,'Joerg-Kurt-Wegner-Grand-Canyon.jpg','20050213125917!Joerg_Kurt_Wegner_Grand_Canyon.jpg',49537,667,467,8,'User_Joerg_Kurt_Wegner_At_The_Grand_Canyon',186477,'Joerg Kurt Wegner','20050213124214','0','BITMAP','image','jpeg',0,'nl71a2cy5dvccqtzd3hd4n0h1g0bu07'),(3308,'Dexamethasone.png','20050213133940!Dexamethasone.png',5345,333,261,8,'Dexamethasone',46555,'Jfdwolff','20040426203553','0','BITMAP','image','png',0,'0wrwbhp1r408rjxwkrvev2sff7f4m2x'),(3309,'Elaichi.jpg','20050213181429!Elaichi.jpg',77201,500,258,8,'Elaichi',41228,'Nichalp','20050121191839','0','BITMAP','image','jpeg',0,'nkp41dmec4tnkaup6dy0f84rzpqkykw'),(3310,'Bakert.jpg','20050213205610!Bakert.jpg',111091,523,561,8,'',6661,'PMelvilleAustin','20050213104708','0','BITMAP','image','jpeg',0,'451e29kf0pf2fzk4ywmxak1xj7pmch9'),(3311,'Bakert.jpg','20050213210011!Bakert.jpg',64494,262,281,8,'Reverted to earlier revision',6661,'PMelvilleAustin','20050213205611','0','BITMAP','image','jpeg',0,'2x52fmwru8z6i4v5iwzy62s9s58f64e'),(3312,'Rect-function.png','20050213231121!Rect_function.png',2590,150,150,8,'[[Rectangular function]]. {{gfdl}}',56905,'Kieff','20041223080553','0','BITMAP','image','png',0,'if30bbmplywtwtzrm1o4tipjbgrg045'),(3313,'Bakert.jpg','20050214001102!Bakert.jpg',111091,523,561,8,'',6661,'PMelvilleAustin','20050213210012','0','BITMAP','image','jpeg',0,'451e29kf0pf2fzk4ywmxak1xj7pmch9'),(3314,'Voll-Honig.JPG','20050214011359!Voll_Honig.JPG',6046,215,133,8,'Capped honeycomb full of honey',142549,'Shoefly','20050102210457','a:18:{s:4:\"Make\";s:7:\"TOSHIBA\";s:5:\"Model\";s:7:\"PDR2300\";s:11:\"XResolution\";s:4:\"72/1\";s:11:\"YResolution\";s:4:\"72/1\";s:14:\"ResolutionUnit\";i:2;s:8:\"Software\";s:4:\"1.00\";s:8:\"DateTime\";s:19:\"2004:07:30 09:59:34\";s:16:\"YCbCrPositioning\";i:2;s:12:\"ExposureTime\";s:4:\"1/30\";s:15:\"ISOSpeedRatings\";i:100;s:11:\"ExifVersion\";s:4:\"0210\";s:16:\"DateTimeOriginal\";s:19:\"2004:07:30 09:59:34\";s:17:\"DateTimeDigitized\";s:19:\"2004:07:30 09:59:34\";s:17:\"ShutterSpeedValue\";s:7:\"493/100\";s:13:\"ApertureValue\";s:4:\"0/10\";s:5:\"Flash\";i:1;s:10:\"ColorSpace\";i:1;s:22:\"MEDIAWIKI_EXIF_VERSION\";i:1;}','BITMAP','image','jpeg',0,'gf4tuhv4bzd3x3ffvz3dpwgm1rj0aak'),(3315,'Human-Language-Families.PNG','20050214022010!Human_Language_Families.PNG',71230,1357,628,8,'Map of Human Language Families',191440,'Industrius','20050214003516','0','BITMAP','image','png',0,'r1u3x95cpex7h1ibdnsuer5621kb56m'),(3316,'Human-Language-Families.PNG','20050214022422!Human_Language_Families.PNG',71230,1357,650,8,'',191440,'Industrius','20050214022010','0','BITMAP','image','png',0,'76qs20zbpj2o2hvtovxjtqyiiej2dyw'),(3317,'Tempts-page-display.jpg','20050214025023!Tempts-page-display.jpg',144865,400,306,8,'A photo of [[The Temptations]], from the cover to the [[2002]] compilation \'\'My Girl: The Very Best of the Temptations\'\' {{albumcover}}',106704,'B Touch','20050214023850','0','BITMAP','image','jpeg',0,'aw6lvfyglg9vioas4kpb21l7g1pdmtn'),(3318,'Human-Language-Families.PNG','20050214043524!Human_Language_Families.PNG',71230,1357,650,8,'I have changed original German map key to English',191440,'Industrius','20050214022422','0','BITMAP','image','png',0,'o9jba614grof0e345wyimg0yqyo96ex'),(3319,'Human-Language-Families.PNG','20050214043752!Human_Language_Families.PNG',71230,1357,650,8,'Minor modifications',191440,'Industrius','20050214043524','0','BITMAP','image','png',0,'tmjpin6rvv460lduzw78xdodn3gyoi6'),(3320,'Human-Language-Families.PNG','20050214044111!Human_Language_Families.PNG',71230,1357,650,8,'Miniscule tweak of Dravidian family',191440,'Industrius','20050214043754','0','BITMAP','image','png',0,'4iea8t4n63yavjjwskfrg61je46azgq'),(3321,'Human-Language-Families.PNG','20050214044258!Human_Language_Families.PNG',71230,1357,650,8,'Argh - am having trouble getting Dravidians to upload correctly',191440,'Industrius','20050214044111','0','BITMAP','image','png',0,'4iea8t4n63yavjjwskfrg61je46azgq'),(3322,'Human-Language-Families.PNG','20050214044341!Human_Language_Families.PNG',71230,1357,650,8,'Reverted to earlier revision',191440,'Industrius','20050214044258','0','BITMAP','image','png',0,'4iea8t4n63yavjjwskfrg61je46azgq'),(3323,'Human-Language-Families.PNG','20050214044607!Human_Language_Families.PNG',71230,1357,650,8,'Reverted to earlier revision',191440,'Industrius','20050214044343','0','BITMAP','image','png',0,'4iea8t4n63yavjjwskfrg61je46azgq'),(3324,'Human-Language-Families.PNG','20050214044741!Human_Language_Families.PNG',71230,1357,650,8,'Trying again....',191440,'Industrius','20050214044608','0','BITMAP','image','png',0,'4iea8t4n63yavjjwskfrg61je46azgq'),(3325,'Human-Language-Families.PNG','20050214045230!Human_Language_Families.PNG',71230,1357,650,8,'Reverted to earlier revision',191