<!doctype html>
<!--[if lt IE 7]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="en"> <![endif]-->
<!--[if IE 7]>    <html class="no-js lt-ie9 lt-ie8" lang="en"> <![endif]-->
<!--[if IE 8]>    <html class="no-js lt-ie9" lang="en"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js" lang="en"> <!--<![endif]-->
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta name="viewport" content="width=device-width">
	<title>Creative Table</title>
	<link rel="stylesheet" href="css/style.css">
    <link id="changeable_style" rel="stylesheet" href="styles/creative/style.css">
	<script src="js/modernizr-2.5.3-respond-1.1.0.min.js"></script>
	<script src="js/jquery-1.8.2.min.js"></script>
    <script src="js/scripts.js"></script>
    <script src="js/creative_table_ajax-1.4.js"></script>
</head>
<body>

    <header id="header">
        <a id="logo" href="index.html">
            <img src="images/logo-creative-table.png" />
        </a>
        <nav id="main-menu">
            <ul>
    	        <li><a href="documentation/01_files.html"><div>Documentation</div><div class="description">all you need to know</div></a></li>
    	        <li><a href="examples.php"><div>Examples</div><div class="description">lots of it</div></a></li>
    	        <li class="active"><a href="styles.php"><div>Styles</div><div class="description">beautify it</div></a></li>
    	        <li><a href="history.html"><div>History</div><div class="description">what was made</div></a></li>
    	        <li><a href="http://www.creativedreams.eu/creative-table/support/" target="_blank"><div>Support</div><div class="description">no more doubts</div></a></li>
            </ul>
        </nav>
        <hr/>
    </header>

    <div id="main-container">

        <aside id="sidebar" class="w1_4">

            <nav id="sub-menu">
                <h2>Styles</h2>
                <ul>
                    <li class="current_page_item"><a href="#" rel="creative">Creative</a></li>
                    <li><a href="#" rel="blue">Blue</a></li>
                    <li><a href="#" rel="green">Green</a></li>
                    <li><a href="#" rel="gray">Gray</a></li>
                    <li><a href="#" rel="black">Black</a></li>
                </ul>
    		</nav>

        </aside>

        <div id="main" class="box w3_4 last">

            <header>
                <h1>Styles</h1>
                <h2> / Creative</h2>
            </header>

            <div id="content">

                <p class="creative_title" style="margin-bottom: 30px;">A clean look table with a blue pager</p>

                <p class="blue_title" style="margin-bottom: 30px; display: none;">A minimal layout table with a blue pager</p>

                <p class="green_title" style="margin-bottom: 30px; display: none;">A green headed table with a green pager</p>

                <p class="gray_title" style="margin-bottom: 30px; display: none;">A gray headed table with green rows and a gray pager</p>

                <p class="black_title" style="margin-bottom: 30px; display: none;">A black headed table with dark rows and a green pager</p>

                <hr class="dotted" />

                <?php

                include_once('styles-php.php');

                if('PHP'=='not installed'){

                ?>

                <div class="ct_search_container" id="ct_search_container"><input type="text" onkeyup="ctSearch('ct');" onkeypress="ctSearchKeypress('ct');" onblur="ctSearchBlur('ct');" onfocus="ctSearchFocus('ct');" placeholder="Search" value="" name="ct_search" class="ct_search" id="ct_search"><a title="Advanced Search" href="javascript: ctShowAdvancedSearch('ct');" class="ct_advanced_search" id="ct_advanced_search"><img src="images/advanced_search.png"></a><div id="ct_loader"></div></div><div class="ct_items_per_page_container" id="ct_items_per_page_container"><select onchange="ctItemsPerPage('ct')" name="ct_items_per_page_change" class="ct_items_per_page_change" id="ct_items_per_page_change"><option selected="selected" value="10">10</option><option value="20">20</option><option value="50">50</option><option value="100">100</option><option value="all">250</option></select></div><table class="ct" id="ct"><thead><tr id="ct_sort"><th width="25" class="sort" onclick="ctSort('ct','1')">Rank</th><th width="40" class="sort" onclick="ctSort('ct','2')">Rating</th><th class="sort" onclick="ctSort('ct','3')">Title</th><th width="50" class="sort" onclick="ctSort('ct','4')">Votes</th></tr><tr style="display: none;" class="ct_multiple_search" id="ct_multiple_search"><th><input type="text" onkeyup="ctMultiSearch('ct');" value="" name="ct_multiple_search[]" id="ct_multiple_search1"></th><th><input type="text" onkeyup="ctMultiSearch('ct');" value="" name="ct_multiple_search[]" id="ct_multiple_search2"></th><th><input type="text" onkeyup="ctMultiSearch('ct');" value="" name="ct_multiple_search[]" id="ct_multiple_search3"></th><th><input type="text" onkeyup="ctMultiSearch('ct');" value="" name="ct_multiple_search[]" id="ct_multiple_search4"></th></tr></thead><tbody><tr class="odd"><td width="25">1</td><td width="40">9.1</td><td>The Shawshank Redemption (1994)</td><td width="50">489048</td></tr><tr class="even"><td>2</td><td>9.1</td><td>The Godfather (1972)</td><td>392126</td></tr><tr class="odd"><td>3</td><td>9.0</td><td>The Godfather: Part II (1974)</td><td>232161</td></tr><tr class="even"><td>4</td><td>8.9</td><td>Il buono, il brutto, il cattivo. (1966)</td><td>148969</td></tr><tr class="odd"><td>5</td><td>8.9</td><td>Pulp Fiction (1994)</td><td>396749</td></tr><tr class="even"><td>6</td><td>8.8</td><td>Schindler's List (1993)</td><td>262551</td></tr><tr class="odd"><td>7</td><td>8.8</td><td>12 Angry Men (1957)</td><td>109861</td></tr><tr class="even"><td>8</td><td>8.8</td><td>One Flew Over the Cuckoo's Nest (1975)</td><td>202689</td></tr><tr class="odd"><td>9</td><td>8.8</td><td>Star Wars: Episode V - The Empire Strikes Back (1980)</td><td>265556</td></tr><tr class="even"><td>10</td><td>8.8</td><td>The Dark Knight (2008)</td><td>436120</td></tr></tbody></table><div class="ct_pager_container" id="ct_pager_container"><span class="ct_pager_info1" id="ct_pager_info1">Total: 250</span><ul class="ct_pager" id="ct_pager"><li><a class="selected" href="javascript: ctPager('ct','1');">1</a></li><li><a href="javascript: ctPager('ct','2');">2</a></li><li><a href="javascript: ctPager('ct','3');">3</a></li><li><a href="javascript: ctPager('ct','4');">4</a></li><li><a href="javascript: ctPager('ct','5');">5</a></li><li id="ct_pager_next"><a href="javascript: ctPager('ct','2');">»</a></li><li id="ct_pager_pre_last">...</li><li id="ct_pager_last"><a href="javascript: ctPager('ct','25');">Last »</a></li></ul><span class="ct_pager_info2" id="ct_pager_info2">Page: 1 of 25</span></div>

                <?php } ?>

            </div>

        </div>

    </div>

    <footer id="footer">

        <hr style="clear: both; margin: 0 0 30px 0;">

        <div style="float: left; padding-bottom: 15px;">

            <a href="http://www.creativedreams.eu/creative-table/" target="_blank" class="items">
                <img src="images/thumbnail-creative-table-no-shadow.png" class="image" />
                <img src="images/thumbnail_shadow.png" class="shadow" />
            </a>

            <a id="support" href="http://www.creativedreams.eu/creative-table/support/" target="_blank" class="social" style="float: left;">
                <img src="images/chat3_support.png" class="image" />
                <img src="images/support_shadow.png" class="shadow" />
            </a>

            <div class="tiny" style="clear: both; padding: 5px 0 0 5px;">PRODUCT PAGE & SUPPORT CENTER</div>

        </div>

        <div style="float: right; padding-bottom: 15px;">

            <a href="http://www.creativedreams.eu" target="_blank" class="items" style="float: right; margin-right: 0; width: 117px;">
                <img src="images/thumbnail_creative_dreams_no_shadow.png" class="image" />
                <img src="images/thumbnail_shadow_creative_dreams.png" class="shadow_creative_dreams" />
            </a>

            <a id="envato" href="http://codecanyon.net/user/CreativeDreams" target="_blank" class="social">
                <img src="images/envato.png" class="image" />
                <img src="images/social_shadow.png" class="shadow" />
            </a>

            <a id="twitter" href="http://twitter.com/creative8dreams" target="_blank" class="social">
                <img src="images/twitter.png" class="image" />
                <img src="images/social_shadow.png" class="shadow" />
            </a>

            <div class="tiny" style="clear: both; padding: 5px 5px 0 0; float: right;">&copy; COPYRIGHT 2014 - CREATIVE DREAMS</div>

        </div>

    </footer>

    <script type="text/javascript">

    // YOU DON'T NEED THIS
    $(document).ready(function() {
        $("#sub-menu li a").click(function() {
            $("#changeable_style").attr("href",'styles/'+$(this).attr('rel')+'/style.css');
            $(".current_page_item").removeClass("current_page_item");
            $(this).blur().parent().addClass("current_page_item");
            $('.creative_title, .blue_title, .green_title, .gray_title, .black_title').hide();
            $('.'+$(this).attr('rel')+'_title').show();
            $('#main header h2').css('text-transform','capitalize').html(' / '+$(this).attr('rel'));
        });
    });

    </script>

</body>
</html>