<?php

// MySQL settings and DB connection (if your project have already an open DB connection, you don't need to include this)
include_once('config.php');

// includes the function getCreativePagerLite()
include_once('functions.php');

// Gets the data
$id=isset($_POST['id']) ? $_POST['id'] : '';
$search=isset($_POST['search']) ? $_POST['search'] : '';
$multiple_search=isset($_POST['multiple_search']) ? $_POST['multiple_search'] : array();
$items_per_page=isset($_POST['items_per_page']) ? $_POST['items_per_page'] : '';
$sort=isset($_POST['sort']) ? $_POST['sort'] : '';
$page=isset($_POST['page']) ? $_POST['page'] : 1;
$total_items=(isset($_POST['total_items']) and $_POST['total_items']>=0) ? $_POST['total_items'] : '';
$extra_cols=isset($_POST['extra_cols']) ? $_POST['extra_cols'] : array();
$extra_vars=isset($_POST['extra_vars']) ? $_POST['extra_vars'] : array();

$style = isset($_GET['s']) ? $_GET['s'] : 'creative';

// Uses the creativeTable to build the table
include_once('creativeTable.php');

$ct=new CreativeTable();

// Data Gathering
$params = array(
    'sql_query'                => "SELECT * FROM imdbtop250",
    'search'                   => $search,
    'multiple_search'          => $multiple_search,
    'items_per_page'           => $items_per_page,
    'sort'                     => $sort,
    'page'                     => $page,
    'total_items'              => $total_items,
    'header'                   => 'Rank,Rating,Title,Votes',
    'width'                    => '25,40,,50',
    'items_per_page_init'      => '10,20,50,100',
    'ajax_url'                 => 'styles-php.php?style='.$style
);

$ct->table($params);

// Insert a Pager into the table (I used this CreativePager Lite version because its very easy to use, but you may use any pager system that you like)
$ct->pager = getCreativePagerLite('ct',$page,$ct->total_items,$ct->items_per_page);

// If its an ajax call
if(isset($_POST['ajax_option'])){
    echo json_encode($ct->display($_POST['ajax_option'],true));
    exit;
}else{
    $out=$ct->display();
}

?>

<?php echo $out;?>